      BLOCK DATA BD04
C
C 
C  BLOCK DATA Subprogram 04: /BASEQ1/,/BASEQ5/
C
C
C  BLOCK DATA 04 initializes the zero mile levels and deterioration rates
C  (intercepts & slopes) of the base FTP exhaust emission rate equations.
C
C  Changes: (Last change first)
C
C  12 Jul 02 AIR Task: Change EMFAC to 2880 cells due to RELATIVE HUMIDITY.
C  20 Mar 02 @EPA-bag BUG386 revised 1989 diesel TRANSIT bus HC (high and low
C            altitude) emission line slopes
C  10 Jan 02 @EPA-bag BUG353 revised diesel school bus NOx emission line
C                     parameters (ZML's & DR's)
C  26 Jun 01 @EPA-bag BUG325 comments
C  23 Mar 01 @EPA-bag BUG320 2007 rule for heavy duty GAS vehicles; added zero mile
C            emission rates and emission line slopes
C  18 Jan 01 @EPA-bag 2007 rule for heavy duty vehicles; added zero mile
C            emission rates and emission line slopes
C  14 Sep 00 @EPA-bag Bug246 Updated 2004+ heavy duty diesel vehicle high
C            and low altitude zero mileage emission points; diesel transit
C            buses were the only heavy duty diesel vehicle without changes;
C            these numbers are documented in bug246.xls
C  13 Jul 00 @EPA-ddj Bug191 Added 1993 values to SDH16, SDH29, SZH16,
C            SZH29, RDH16, RDH29, RZH16 and RZH29 to accommodate null
C            altitude effect for post-1993 LDDT emissions.
C  15 Jun 00 @EPA-BAG BUG126 Diesel School Bus (HDDBS, IV=27) low altitude
C                 HC emission zero mile level for 2004+ vehicles is wrong.
C                 The 2004+ model year (factor #32,) should be 0.483.
C                 Factor #33 is not used and should be zero. The deterioration
C                 rates for both high and low altitude also contain numbers in
C                 factor #33.  These should be set to zero.
C  15 Jun 00 @EPA-BAG BUG124 The deterioration rate for Low Alt. 1987 model year
C                 HDDBS for NOx (the 22nd value) in BD04 is 0.024. The correct
C                 value (based on the benchmark and confirmed by the high alt.
C                 value) should be zero (0.0).
C  08 Jun 00 @EPA-djb Bug113 Removed HIGHER array.
C  16 May 00 @EPA-ddj BUG27; Collapsed array EMFAC from 277200 to 120.
C  04 Apr 00 @EPA-EG  Fixed bug #81; 1990 HDGV8B ZML typo (8.305 replaced with 6.305)
C  04 Apr 00 @EPA-EG  Fixed bug #82; HDDV mismatch of model year and ZML's
C  21 Apr 00 @EPA-djb Replaced all values in SZL,SZH,SDL,SDH,RZL,
C            ZH,RDL and RDH arrays (open loop emission rates) to match
C            OPENLOOP.XLS spreadsheet.
C  20 Apr 00 AIR Task 02: Fixed equivalence error between SEBZML and SZL08
C  17 Apr 00 @EPA-djb Fixed LDDT34, HDDV, HDGV integration.
C  25 Jan 00 @DynTel-ZK 1-031 Entered  ZML and DR from new spreadsheet.
C   2 Feb 00 @DynTel-ddj 1-032  Changed value for LDTS starts for low
C            altitude (SDL16) NOx pre-1981 from 0.032 to 0.003 per EPA
C            spreadsheet.  Changed LDDT to LDDT12 and created
C            LDDT34 by copying LDDT12 data to place holder for
C            vehicle type 28.
C  21 Mar 00 @EPA-eg           hrloop revisions
C  27 Oct. 99 @Dyntel-HXQ 2-680 Entered ZML and DR from new spreadsheet.
C   29 July 99 @Dyntel-HXQ 2-705 Change data for RZL14, SDL16, RDL16
C    9 July 99 @Dyntel-JWR 2-705 Supplied more zero-initialised values (now 5544)
C                         to ERUZML, ERUDR, ESUZML,ESUDR to reflect
C                        increased number of allowed user supplied BERs.
C   15 JUn 99 @Dyntel-HXQ using the HDGV8A data for HDGV8B data
C    2 Jun 99 @Dyntel-HXQ 2-668 Modified and delete some description.
C   16 Feb 99 @Dyntel-HXQ 2-668 Removed MOBILE5 2nd deterioration rate
C                         array since HDV do not need them  
C   6 JAN 99 @Dyntel-HXQ 2-668 Pre-1981 LDGV & LDGT basic exhaust
C                        engine start and running
C  07 Dec. 98 @DynTel-HXQ 2-680 to include updated zero mile levels
C                         deterioration rates for HDGV8B
C  22 Oct. 98 @DynTel-HXQ 2-680 to include updated zero mile levels and 
C                         deterioration rates for hydrocarbons,
C                         carbon monoxide and oxides of nitrogen
C                                 for low and high altitudes.
C  11 Aug 98 @DynTel-MLA 2-000  Changed HDG and HDD names to conform to
C            new naming conventions.
C
C
C  Common block array subscripts:
C
C
C  ERBDR(33,3,28,2)   -  ERBDR  ( IGER, IP,   IV, IR )
C  ERBZML(33,3,28,2)  -  ERBZML ( IGER, IP,   IV, IR )
C  ERUDR(33,3,28,2)   -  ERUDR  ( IGER, IP,   IV, IR )
C  ERUZML(33,3,28,2)  -  ERUZML ( IGER, IP,   IV, IR )
C  ESUDR(33,3,28,2)   -  ESUDR  ( IGER, IP,   IV, IR )
C  ESUZML(33,3,28,2)  -  ESUZML ( IGER, IP,   IV, IR )
C
C  These arrays deal with seperate start and running, NON-HDV
C
C  SEBZML(25,3,28,2)  -  SEBZML ( IGER, IP,   IV, IR)
C  REBZML(25,3,28,2)  -  REBZML ( IGER, IP,   IV, IR)
C  SEBDR (25,3,28,2)  -  SEBDR  ( IGER, IP,   IV, IR)
C  REBDR (25,3,28,2)  -  REBDR  ( IGER, IP,   IV, IR)
C
C  Common block dictionary:
C
C   Name   Type              Description
C  ------  ----  --------------------------------------------
C  Note: 3rd character syntax: B = Block Data hardcoded, U = User supplied
C
C  /BASEQ1/:
C
C  ERBZML   R    Hardcoded FTP Emission Rate (ER) equation zero mile levels
C  ERBDR    R    Hardcoded FTP ER equation deterioration rates
C
C  SEBZML   R    Hardcoded FTP (Starting) Emission Rate (ER) equation zero mile levels
C  SEBDR    R    Hardcoded FTP ER equation deterioration rates(starting)
C  REBZML   R    Hardcoded FTP (Running) Emission Rate (ER) equation 
C  RRBDR    R    Hardcoded FTP ER equation deterioration rates (Running)


C  /BASEQ5/:
C
C  ERUZML   R    User supplied (via NEWFLG) FTP/running ER equation zero 
C                mile levels
C  ERUDR    R    User supplied FTP/running ER equation deterioration rates
C  ESUZML   R    User supplied (via NEWFLG) starts ER equation zero mile
C                levels
C  ESUDR    R    User supplied starts ER equation deterioration rates
C
C  Local array subscripts:
C
C  <J><K><LL>(33,3,2)  -  <J><K><LL> ( IG, IP, IVER )
C
C  where <J> = D (deterioration rate), Z (zero mile level)
C        <K> = L (low altitude region), H (high altitude region)
C        <LL> =  2 (LDGV,LDGT1),   4 (LDGT2/3),       6 (LDGT4,HDGV2B),
C                8 (HDGV3/4),     10 (HDGV5/6),      12 (HDGV7/8a),
C               14 (HDGV8B,LDDV), 16 (LDDT12, HDDV2B), 18 (HDDV3/4),
C               20 (HDDV5/6),     22 (HDDV7/8A),     24 (HDDV8A, MC),
C               26 (HDGB (GASOLINE BUS), HDDBT (DIESEL TRANSIT BUS)),
C               28 (HDDBS (DIESEL SCHOOL BUS), LDDT34)
C        IVER = 1 (1st of vt pair LL), 2 (2nd of vt pair LL)
C        IG   = Model Year
C        IP   = 1 (HC), 2 (CO), 3(NO)
C
C  Local array dictionary:
C
C   Name      Type                Descriptions
C  ---------  ----  --------------------------------------------------------
C  <J><K><LL>  R    as defined above, the slope/intercept <J> in region <K>
C                   for vehicle type pair <LL> of the FTP exhaust emission
C                   rate equation
C
C  Notes:
C
C  BD04 was modified to include kinked EFs for LDGT in MOBILE5.
C
C  Modified on 11-16-93 by TMM@ARC per EPA request #2-356 to correct
C    one ZML value for LDGV HC at low and high altitude. The value was
C    changed from 0.184 to 0.185.
C
C  22 Jun 95 @ CSC-mla Req. 2-502 - Changed Zero Mile Levels for HDDV NOx
C  for 1990, 1991-1997, 1998-2000, and 2001-2020 (high and low altitude).
C
C  14 Nov 96 DynTel@MLA 2-622  Changed the names of the ZL, ZH, DL, and DH
C            arrays and the ERBnn arrays (used locally only), and added new
C            names to accomodate the two new LDGT vehicles types and the 14
C            new HDG and HDD types. Redimensioned all of the ERB and ERU 
C            arrays.
C
C  2 Apr 97 - DynTel@MLA 2-622  Expanded arrays ERBZML and ERBDR to 
C             accomodate the new BUS vehicle categories.
C
C  8 Apr 98  @DynTel-RJD 2-654  Added additional arrays to accommodate
C            seperate starting and running emissions.
C
C  23 Jul 98 @DynTel-MLA 2-000  Changed LDGT names to conform to
C            certification naming conventions.
C
      IMPLICIT NONE
      INCLUDE 'BASEQ1.I'
      INCLUDE 'BASEQ5.I'
C
      REAL ZL02(35,3,2),ZL04(35,3,2),ZL06(35,3,2),ZL08(35,3,2)
      REAL ZL10(35,3,2),ZL12(35,3,2),ZL14(35,3,2),ZL16(35,3,2)
      REAL ZL18(35,3,2),ZL20(35,3,2),ZL22(35,3,2),ZL24(35,3,2)
      REAL ZL26(35,3,2),ZL28(35,3,2)
      REAL ZH02(35,3,2),ZH04(35,3,2),ZH06(35,3,2),ZH08(35,3,2)
      REAL ZH10(35,3,2),ZH12(35,3,2),ZH14(35,3,2),ZH16(35,3,2)
      REAL ZH18(35,3,2),ZH20(35,3,2),ZH22(35,3,2),ZH24(35,3,2)
      REAL ZH26(35,3,2),ZH28(35,3,2)
      REAL DL02(35,3,2),DL04(35,3,2),DL06(35,3,2),DL08(35,3,2)
      REAL DL10(35,3,2),DL12(35,3,2),DL14(35,3,2),DL16(35,3,2)
      REAL DL18(35,3,2),DL20(35,3,2),DL22(35,3,2),DL24(35,3,2)
      REAL DL26(35,3,2),DL28(35,3,2)
      REAL DH02(35,3,2),DH04(35,3,2),DH06(35,3,2),DH08(35,3,2)
      REAL DH10(35,3,2),DH12(35,3,2),DH14(35,3,2),DH16(35,3,2)
      REAL DH18(35,3,2),DH20(35,3,2),DH22(35,3,2),DH24(35,3,2)
      REAL DH26(35,3,2),DH28(35,3,2)
C
      REAL SZL02(35,3,2),SZL04(35,3,2),SZL06(35,3,2),SZL08(35,3,2)
      REAL SZL10(35,3,2),SZL12(35,3,2),SZL14(35,3,2),SZL16(35,3,2)
      REAL SZL18(35,3,2),SZL20(35,3,2),SZL22(35,3,2),SZL24(35,3,2)
      REAL SZL26(35,3,2),SZL28(35,3,2)
      REAL SZH02(35,3,2),SZH04(35,3,2),SZH06(35,3,2),SZH08(35,3,2)
      REAL SZH10(35,3,2),SZH12(35,3,2),SZH14(35,3,2),SZH16(35,3,2)
      REAL SZH18(35,3,2),SZH20(35,3,2),SZH22(35,3,2),SZH24(35,3,2)
      REAL SZH26(35,3,2),SZH28(35,3,2)
      REAL SDL02(35,3,2),SDL04(35,3,2),SDL06(35,3,2),SDL08(35,3,2)
      REAL SDL10(35,3,2),SDL12(35,3,2),SDL14(35,3,2),SDL16(35,3,2)
      REAL SDL18(35,3,2),SDL20(35,3,2),SDL22(35,3,2),SDL24(35,3,2)
      REAL SDL26(35,3,2),SDL28(35,3,2)
      REAL SDH02(35,3,2),SDH04(35,3,2),SDH06(35,3,2),SDH08(35,3,2)
      REAL SDH10(35,3,2),SDH12(35,3,2),SDH14(35,3,2),SDH16(35,3,2)
      REAL SDH18(35,3,2),SDH20(35,3,2),SDH22(35,3,2),SDH24(35,3,2)
      REAL SDH26(35,3,2),SDH28(35,3,2)
C
C
      EQUIVALENCE
     *  (ERBZML(1,1,1, 1),ZL02(1,1,1)),(ERBZML(1,1,3, 1),ZL04(1,1,1)),
     *  (ERBZML(1,1,5, 1),ZL06(1,1,1)),(ERBZML(1,1,7, 1),ZL08(1,1,1)),
     *  (ERBZML(1,1,9, 1),ZL10(1,1,1)),(ERBZML(1,1,11,1),ZL12(1,1,1)),
     *  (ERBZML(1,1,13,1),ZL14(1,1,1)),(ERBZML(1,1,15,1),ZL16(1,1,1)),
     *  (ERBZML(1,1,17,1),ZL18(1,1,1)),(ERBZML(1,1,19,1),ZL20(1,1,1)),
     *  (ERBZML(1,1,21,1),ZL22(1,1,1)),(ERBZML(1,1,23,1),ZL24(1,1,1)),
     *  (ERBZML(1,1,25,1),ZL26(1,1,1)),(ERBZML(1,1,27,1),ZL28(1,1,1)),
     *  (ERBZML(1,1,1, 2),ZH02(1,1,1)),(ERBZML(1,1,3, 2),ZH04(1,1,1)),
     *  (ERBZML(1,1,5, 2),ZH06(1,1,1)),(ERBZML(1,1,7, 2),ZH08(1,1,1)),
     *  (ERBZML(1,1,9, 2),ZH10(1,1,1)),(ERBZML(1,1,11,2),ZH12(1,1,1)),
     *  (ERBZML(1,1,13,2),ZH14(1,1,1)),(ERBZML(1,1,15,2),ZH16(1,1,1)),
     *  (ERBZML(1,1,17,2),ZH18(1,1,1)),(ERBZML(1,1,19,2),ZH20(1,1,1)),
     *  (ERBZML(1,1,21,2),ZH22(1,1,1)),(ERBZML(1,1,23,2),ZH24(1,1,1)),
     *  (ERBZML(1,1,25,2),ZH26(1,1,1)),(ERBZML(1,1,27,2),ZH28(1,1,1))
C
      EQUIVALENCE
     *  (ERBDR(1,1,1, 1),DL02(1,1,1)),(ERBDR(1,1,3, 1),DL04(1,1,1)),
     *  (ERBDR(1,1,5, 1),DL06(1,1,1)),(ERBDR(1,1,7, 1),DL08(1,1,1)),
     *  (ERBDR(1,1,9, 1),DL10(1,1,1)),(ERBDR(1,1,11,1),DL12(1,1,1)),
     *  (ERBDR(1,1,13,1),DL14(1,1,1)),(ERBDR(1,1,15,1),DL16(1,1,1)),
     *  (ERBDR(1,1,17,1),DL18(1,1,1)),(ERBDR(1,1,19,1),DL20(1,1,1)),
     *  (ERBDR(1,1,21,1),DL22(1,1,1)),(ERBDR(1,1,23,1),DL24(1,1,1)),
     *  (ERBDR(1,1,25,1),DL26(1,1,1)),(ERBDR(1,1,27,1),DL28(1,1,1)),
     *  (ERBDR(1,1,1, 2),DH02(1,1,1)),(ERBDR(1,1,3, 2),DH04(1,1,1)),
     *  (ERBDR(1,1,5, 2),DH06(1,1,1)),(ERBDR(1,1,7, 2),DH08(1,1,1)),
     *  (ERBDR(1,1,9, 2),DH10(1,1,1)),(ERBDR(1,1,11,2),DH12(1,1,1)),
     *  (ERBDR(1,1,13,2),DH14(1,1,1)),(ERBDR(1,1,15,2),DH16(1,1,1)),
     *  (ERBDR(1,1,17,2),DH18(1,1,1)),(ERBDR(1,1,19,2),DH20(1,1,1)),
     *  (ERBDR(1,1,21,2),DH22(1,1,1)),(ERBDR(1,1,23,2),DH24(1,1,1)),
     *  (ERBDR(1,1,25,2),DH26(1,1,1)),(ERBDR(1,1,27,2),DH28(1,1,1))
C
C
C
      EQUIVALENCE
     *  (SEBZML(1,1,1, 1),SZL02(1,1,1)),(SEBZML(1,1,3, 1),SZL04(1,1,1)),
     *  (SEBZML(1,1,5, 1),SZL06(1,1,1)),(SEBZML(1,1,7, 1),SZL08(1,1,1)),
     *  (SEBZML(1,1,9, 1),SZL10(1,1,1)),(SEBZML(1,1,11,1),SZL12(1,1,1)),
     *  (SEBZML(1,1,13,1),SZL14(1,1,1)),(SEBZML(1,1,15,1),SZL16(1,1,1)),
     *  (SEBZML(1,1,17,1),SZL18(1,1,1)),(SEBZML(1,1,19,1),SZL20(1,1,1)),
     *  (SEBZML(1,1,21,1),SZL22(1,1,1)),(SEBZML(1,1,23,1),SZL24(1,1,1)),
     *  (SEBZML(1,1,25,1),SZL26(1,1,1)),(SEBZML(1,1,27,1),SZL28(1,1,1)),
     *  (SEBZML(1,1,1, 2),SZH02(1,1,1)),(SEBZML(1,1,3, 2),SZH04(1,1,1)),
     *  (SEBZML(1,1,5, 2),SZH06(1,1,1)),(SEBZML(1,1,7, 2),SZH08(1,1,1)),
     *  (SEBZML(1,1,9, 2),SZH10(1,1,1)),(SEBZML(1,1,11,2),SZH12(1,1,1)),
     *  (SEBZML(1,1,13,2),SZH14(1,1,1)),(SEBZML(1,1,15,2),SZH16(1,1,1)),
     *  (SEBZML(1,1,17,2),SZH18(1,1,1)),(SEBZML(1,1,19,2),SZH20(1,1,1)),
     *  (SEBZML(1,1,21,2),SZH22(1,1,1)),(SEBZML(1,1,23,2),SZH24(1,1,1)),
     *  (SEBZML(1,1,25,2),SZH26(1,1,1)),(SEBZML(1,1,27,2),SZH28(1,1,1))
C                                      
      EQUIVALENCE
     *  (SEBDR(1,1,1, 1),SDL02(1,1,1)),(SEBDR(1,1,3, 1),SDL04(1,1,1)),
     *  (SEBDR(1,1,5, 1),SDL06(1,1,1)),(SEBDR(1,1,7, 1),SDL08(1,1,1)),
     *  (SEBDR(1,1,9, 1),SDL10(1,1,1)),(SEBDR(1,1,11,1),SDL12(1,1,1)),
     *  (SEBDR(1,1,13,1),SDL14(1,1,1)),(SEBDR(1,1,15,1),SDL16(1,1,1)),
     *  (SEBDR(1,1,17,1),SDL18(1,1,1)),(SEBDR(1,1,19,1),SDL20(1,1,1)),
     *  (SEBDR(1,1,21,1),SDL22(1,1,1)),(SEBDR(1,1,23,1),SDL24(1,1,1)),
     *  (SEBDR(1,1,25,1),SDL26(1,1,1)),(SEBDR(1,1,27,1),SDL28(1,1,1)),
     *  (SEBDR(1,1,1, 2),SDH02(1,1,1)),(SEBDR(1,1,3, 2),SDH04(1,1,1)),
     *  (SEBDR(1,1,5, 2),SDH06(1,1,1)),(SEBDR(1,1,7, 2),SDH08(1,1,1)),
     *  (SEBDR(1,1,9, 2),SDH10(1,1,1)),(SEBDR(1,1,11,2),SDH12(1,1,1)),
     *  (SEBDR(1,1,13,2),SDH14(1,1,1)),(SEBDR(1,1,15,2),SDH16(1,1,1)),
     *  (SEBDR(1,1,17,2),SDH18(1,1,1)),(SEBDR(1,1,19,2),SDH20(1,1,1)),
     *  (SEBDR(1,1,21,2),SDH22(1,1,1)),(SEBDR(1,1,23,2),SDH24(1,1,1)),
     *  (SEBDR(1,1,25,2),SDH26(1,1,1)),(SEBDR(1,1,27,2),SDH28(1,1,1))
C
C
      REAL RZL02(35,3,2),RZL04(35,3,2),RZL06(35,3,2),RZL08(35,3,2)
      REAL RZL10(35,3,2),RZL12(35,3,2),RZL14(35,3,2),RZL16(35,3,2)
      REAL RZL18(35,3,2),RZL20(35,3,2),RZL22(35,3,2),RZL24(35,3,2)
      REAL RZL26(35,3,2),RZL28(35,3,2)
      REAL RZH02(35,3,2),RZH04(35,3,2),RZH06(35,3,2),RZH08(35,3,2)
      REAL RZH10(35,3,2),RZH12(35,3,2),RZH14(35,3,2),RZH16(35,3,2)
      REAL RZH18(35,3,2),RZH20(35,3,2),RZH22(35,3,2),RZH24(35,3,2)
      REAL RZH26(35,3,2),RZH28(35,3,2)
      REAL RDL02(35,3,2),RDL04(35,3,2),RDL06(35,3,2),RDL08(35,3,2)
      REAL RDL10(35,3,2),RDL12(35,3,2),RDL14(35,3,2),RDL16(35,3,2)
      REAL RDL18(35,3,2),RDL20(35,3,2),RDL22(35,3,2),RDL24(35,3,2)
      REAL RDL26(35,3,2),RDL28(35,3,2)
      REAL RDH02(35,3,2),RDH04(35,3,2),RDH06(35,3,2),RDH08(35,3,2)
      REAL RDH10(35,3,2),RDH12(35,3,2),RDH14(35,3,2),RDH16(35,3,2)
      REAL RDH18(35,3,2),RDH20(35,3,2),RDH22(35,3,2),RDH24(35,3,2)
      REAL RDH26(35,3,2),RDH28(35,3,2)
C
      EQUIVALENCE
     *  (REBZML(1,1,1, 1),RZL02(1,1,1)),(REBZML(1,1,3, 1),RZL04(1,1,1)),
     *  (REBZML(1,1,5, 1),RZL06(1,1,1)),(REBZML(1,1,7, 1),RZL08(1,1,1)),
     *  (REBZML(1,1,9, 1),RZL10(1,1,1)),(REBZML(1,1,11,1),RZL12(1,1,1)),
     *  (REBZML(1,1,13,1),RZL14(1,1,1)),(REBZML(1,1,15,1),RZL16(1,1,1)),
     *  (REBZML(1,1,17,1),RZL18(1,1,1)),(REBZML(1,1,19,1),RZL20(1,1,1)),
     *  (REBZML(1,1,21,1),RZL22(1,1,1)),(REBZML(1,1,23,1),RZL24(1,1,1)),
     *  (REBZML(1,1,25,1),RZL26(1,1,1)),(REBZML(1,1,27,1),RZL28(1,1,1)),
     *  (REBZML(1,1,1, 2),RZH02(1,1,1)),(REBZML(1,1,3, 2),RZH04(1,1,1)),
     *  (REBZML(1,1,5, 2),RZH06(1,1,1)),(REBZML(1,1,7, 2),RZH08(1,1,1)),
     *  (REBZML(1,1,9, 2),RZH10(1,1,1)),(REBZML(1,1,11,2),RZH12(1,1,1)),
     *  (REBZML(1,1,13,2),RZH14(1,1,1)),(REBZML(1,1,15,2),RZH16(1,1,1)),
     *  (REBZML(1,1,17,2),RZH18(1,1,1)),(REBZML(1,1,19,2),RZH20(1,1,1)),
     *  (REBZML(1,1,21,2),RZH22(1,1,1)),(REBZML(1,1,23,2),RZH24(1,1,1)),
     *  (REBZML(1,1,25,2),RZH26(1,1,1)),(REBZML(1,1,27,2),RZH28(1,1,1))
C
      EQUIVALENCE
     *  (REBDR(1,1,1, 1),RDL02(1,1,1)),(REBDR(1,1,3, 1),RDL04(1,1,1)),
     *  (REBDR(1,1,5, 1),RDL06(1,1,1)),(REBDR(1,1,7, 1),RDL08(1,1,1)),
     *  (REBDR(1,1,9, 1),RDL10(1,1,1)),(REBDR(1,1,11,1),RDL12(1,1,1)),
     *  (REBDR(1,1,13,1),RDL14(1,1,1)),(REBDR(1,1,15,1),RDL16(1,1,1)),
     *  (REBDR(1,1,17,1),RDL18(1,1,1)),(REBDR(1,1,19,1),RDL20(1,1,1)),
     *  (REBDR(1,1,21,1),RDL22(1,1,1)),(REBDR(1,1,23,1),RDL24(1,1,1)),
     *  (REBDR(1,1,25,1),RDL26(1,1,1)),(REBDR(1,1,27,1),RDL28(1,1,1)),
     *  (REBDR(1,1,1, 2),RDH02(1,1,1)),(REBDR(1,1,3, 2),RDH04(1,1,1)),
     *  (REBDR(1,1,5, 2),RDH06(1,1,1)),(REBDR(1,1,7, 2),RDH08(1,1,1)),
     *  (REBDR(1,1,9, 2),RDH10(1,1,1)),(REBDR(1,1,11,2),RDH12(1,1,1)),
     *  (REBDR(1,1,13,2),RDH14(1,1,1)),(REBDR(1,1,15,2),RDH16(1,1,1)),
     *  (REBDR(1,1,17,2),RDH18(1,1,1)),(REBDR(1,1,19,2),RDH20(1,1,1)),
     *  (REBDR(1,1,21,2),RDH22(1,1,1)),(REBDR(1,1,23,2),RDH24(1,1,1)),
     *  (REBDR(1,1,25,2),RDH26(1,1,1)),(REBDR(1,1,27,2),RDH28(1,1,1))
C
C  Hardcoded FTP ER equation zero mile levels and deterioration (per 10000
C  miles) rates are blocked by vehicle class.  Within each block, the
C  continuation code is the pollutant type: H = HC, C = CO and N = NOx.
C  There are up to 2 lines and 20 cases per pollutant per vehicle class per
C  region per equation parameter.
C
C
C  /BASEQ1/:
C
C
C  Hardcoded zero mile composite start & running exhaust levels
C
C  Low altitude region
C
        DATA ZL02/
C  LDGV
     H 35*0.,
     C 35*0.,
     N 35*0.,
C  LDGT1
     H 35*0.,
     C 35*0.,
     N 35*0./
C
        DATA ZL04/
C  LDGT2
     H 35*0.,
     C 35*0.,
     N 35*0.,
C  LDGT3
     H 35*0.,
     C 35*0.,
     N 35*0./
C
        DATA ZL06/
C  LDGT4
     H 35*0.,
     C 35*0.,
     N 35*0.,
C    HDGV2B 
C      1969,   1973,  1974,  1975,  1976,  1977,  1978,  1979,
     H 12.230, 6.490, 6.341, 6.199, 6.057, 5.929, 5.800, 3.028,
C      1980,  1981,  1982,  1983,  1984,  1985,  1986,  1987,
     H 3.006, 2.948, 2.930, 2.927, 2.927, 2.052, 1.820, 0.983,
C      1988,  1989,  1990,  1991,  1992,  1993,  1994,  1995,
     H 0.664, 0.665, 0.377, 0.356, 0.357, 0.358, 0.359, 0.360,
C      2007,  2008,  NEYR,  8*0000,
     H 0.362, 0.098, 0.078, 8*0.0,
C      1969     1973     1974     1975     1976     1977
     C 148.973, 110.918, 108.377, 105.950, 103.524, 101.329,
C      1978    1979    1980    1981    1982    1983    1984
     C 99.133, 47.146, 46.810, 45.913, 45.633, 45.577, 45.577,
C      1985    1986    1987    1988    1989    1990   1991
     C 32.253, 25.643, 13.329, 14.823, 14.850, 7.414, 7.661,
C      1992   1993   1994   1995   NEYR   10*0000
     C 7.682, 7.704, 7.732, 7.753, 7.782, 10*0.0,
C     1969   1973   1974   1975   1976   1977   1978   1979
     N 5.837, 6.586, 4.699, 4.594, 4.489, 4.394, 4.299, 4.886,
C      1980   1981   1982   1983   1984   1985   1986   1987
     N 4.851, 4.758, 4.729, 4.724, 4.724, 4.696, 4.725, 6.184,
C      1988   1989   1990   1991   1992   1993   1994   1995
     N 5.312, 5.322, 3.884, 3.496, 3.506, 3.515, 3.528, 3.538,
C      1997   2007   2008   NEYR   7*0000
     N 3.551, 2.839, 0.347, 0.121, 7*0.0/
C
        DATA ZL08/
CG  HDGV3
C      1969   1973   1974   1975   1976   1977   1978   1979
     H 17.237, 9.146, 9.119, 9.092, 9.065, 9.031, 9.004, 4.781,
C      1980   1981   1982   1983   1984   1985   1986   1987
     H 4.835, 4.820, 4.878, 4.874, 4.871, 3.416, 3.029, 1.060,
C      1988   1989   1990   1991   1992   1993   1994   1995
     H 0.714, 0.713, 0.403, 0.379, 0.379, 0.379, 0.379, 0.379,
C      2007   2008   NEYR   8*0000
     H 0.380, 0.088, 0.073, 8*0.0,
     C 209.959, 156.326, 155.863, 155.401, 154.939, 154.361,
     C 153.899, 74.448, 75.289, 75.064, 75.961, 75.905, 75.849,
     C 53.690, 42.664, 14.377, 15.930, 15.916, 7.924, 8.158,
     C 8.158, 8.158, 8.158, 8.158, 8.165, 10*0.0,
C      1969   1973   1974   1975   1976   1977   1978   1979
     N 8.226, 9.282, 6.758, 6.738, 6.718, 6.693, 6.673, 7.716,
C      1980   1981   1982   1983   1984   1985   1986   1987
     N 7.803, 7.780, 7.873, 7.867, 7.861, 7.817, 7.861, 6.670,
C      1988   1989   1990   1991   1992   1993   1994   1995
     N 5.709, 5.704, 4.152, 3.723, 3.723, 3.723, 3.723, 3.723,
C      1997   2007   2008   NEYR   7*0000
     N 3.726, 2.979, 0.379, 0.163, 7*0.0,
C
CG  HDGV4
C      1969   1973   1974   1975   1976   1977   1978   1979
     H 17.237, 9.146, 9.119, 9.092, 9.065, 9.031, 9.004, 4.781,
C      1980   1981   1982   1983   1984   1985   1986   1987
     H 4.835, 4.820, 4.878, 4.874, 4.871, 3.418, 3.033, 1.071,
C      1988   1989   1990   1991   1992   1993   1994   1995
     H 0.719, 0.717, 0.403, 0.379, 0.378, 0.377, 0.376, 0.375,
C      2007   2008   NEYR   8*0000
     H 0.374, 0.082, 0.067, 8*0.0,
     C 209.959, 156.326, 155.863, 155.401, 154.939, 154.361, 
     C 153.899, 74.448, 75.289, 75.064, 75.961, 75.905, 75.849, 
     C 53.729, 42.727, 14.527, 16.054, 15.999, 7.937, 8.158, 
     C 8.137, 8.115, 8.094, 8.073, 8.051, 10*0.0,
C      1969   1973   1974   1975   1976   1977   1978   1979
     N 8.226, 9.282, 6.758, 6.738, 6.718, 6.693, 6.673, 7.716,
C      1980   1981   1982   1983   1984   1985   1986   1987
     N 7.803, 7.780, 7.873, 7.867, 7.861, 7.822, 7.872, 6.740,
C      1988   1989   1990   1991   1992   1993   1994   1995
     N 5.754, 5.734, 4.159, 3.723, 3.713, 3.703, 3.694, 3.684,
C       1997  2007   2008   NEYR   7*0000
     N 3.674, 2.937, 0.361, 0.145, 7*0.0/
C
        DATA ZL10/
CG HDGV5
C       1969   1973   1974   1975   1976   1977   1978   1979
     H 17.237, 9.146, 9.119, 9.092, 9.065, 9.031, 9.004, 4.781,
C      1980   1981   1982   1983   1984   1985   1986   1987
     H 4.835, 4.820, 4.878, 4.871, 4.864, 3.408, 3.020, 1.188,
C      1988   1989   1990   1991   1992   1993   1994   1995
     H 0.802, 0.804, 0.455, 0.431, 0.432, 0.433, 0.434, 0.436,
C      2007   2008   NEYR   8*0000
     H 0.437, 0.096, 0.079, 8*0.0,
     C 209.959, 156.326, 155.863, 155.401, 154.939, 154.361,
     C 153.899, 74.448, 75.289, 75.064, 75.961, 75.849, 75.737,
     C 53.570, 42.537, 16.112, 17.909, 17.950, 8.964, 9.266,
     C 9.287, 9.315, 9.344, 9.372, 9.400, 10*0.0,
C      1969   1973   1974   1975   1976   1977   1978   1979
     N 8.226, 9.282, 6.758, 6.738, 6.718, 6.693, 6.673, 7.716,
C      1980   1981   1982   1983   1984   1985   1986   1987
     N 7.803, 7.780, 7.873, 7.861, 7.849, 7.799, 7.837, 7.475,
C      1988   1989   1990   1991   1992   1993   1994   1995
     N 6.418, 6.433, 4.697, 4.228, 4.238, 4.251, 4.264, 4.277,
C      1997   2007   2008   NEYR   7*0000
     N 4.290, 3.429, 0.422, 0.169, 7*0.0,
C  HDGV6
C      1969    1973    1974    1975    1976    1977    1978
     H 19.276, 10.228, 10.410, 10.505, 10.485, 10.390, 10.262,
C      1979   1980   1981   1982   1983   1984   1985   1986
     H 5.371, 5.227, 5.108, 4.889, 4.849, 4.813, 3.357, 2.963,
C      1987   1988   1989   1990   1991   1992   1993   1994
     H 1.206, 0.812, 0.812, 0.458, 0.432, 0.432, 0.432, 0.432,
C       1995  2007   2008   NEYR   8*0000
     H 0.432, 0.433, 0.095, 0.078, 8*0.0,
     C 234.787, 174.812, 177.932, 179.549, 179.203, 177.585,
     C 175.390, 83.642, 81.399, 79.549, 76.129, 75.513, 74.952,
     C 52.775, 41.744, 16.361, 18.130, 18.130, 9.019, 9.294,
     C 9.294, 9.294, 9.294, 9.301, 9.308, 10*0.0,
C      1969   1973    1974   1975   1976   1977   1978   1979
     N 9.199, 10.379, 7.715, 7.786, 7.771, 7.700, 7.605, 8.669,
C      1980   1981   1982   1983   1984   1985   1986   1987
     N 8.436, 8.244, 7.890, 7.826, 7.768, 7.683, 7.691, 7.591,
C      1988   1989   1990   1991   1992   1993   1994   1995
     N 6.498, 6.498, 4.725, 4.241, 4.241, 4.241, 4.241, 4.244,
C      1997   2007   2008   NEYR   7*0000
     N 4.248, 3.395, 0.418, 0.167, 7*0.0/
C
        DATA ZL12/
C  HDGV7
C      1969    1973    1974    1975    1976    1977    1978
     H 24.206, 12.844, 12.783, 12.756, 12.702, 12.594, 12.256,
C      1979    1980   1981  1982   1983   1984   1985   1986
     H 6.304, 6.142, 6.156, 6.170, 6.127, 6.091, 4.250, 3.753,
C      1987   1988   1989   1990   1991,  1992   1993   1994
     H 1.272, 0.861, 0.865, 0.491, 0.465, 0.467, 0.470, 0.472,
C      1995   2007   2008   NEYR   8*0000
     H 0.475, 0.477, 0.105, 0.086, 8*0.0,
     C 294.842, 219.526, 218.486, 218.024, 217.100, 215.251,
     C 209.474, 98.161, 95.638, 95.863, 96.087, 95.414, 94.854,
     C 66.814, 52.870, 17.260, 19.224, 19.307, 9.660, 10.004,
     C 10.054, 10.103, 10.153, 10.210, 10.267, 10*0.0,
C      1969    1973    1974   1975   1976   1977   1978   1979
     N 11.552, 13.034, 9.474, 9.454, 9.414, 9.334, 9.083, 10.173,
C      1980   1981   1982   1983   1984   1985   1986   1987
     N 9.912, 9.935, 9.958, 9.889, 9.831, 9.727, 9.741, 8.008,
C      1988   1989   1990   1991   1992   1993   1994   1995
     N 6.889, 6.919, 5.061, 4.565, 4.588, 4.611, 4.633, 4.659,
C      1997   2007   2008   NEYR   7*0000
     N 4.685, 3.745, 0.461, 0.184, 7*0.0,
C  HDGV8A
C       1969   1973    1974    1975    1976    1977    1978
     H 26.142, 13.872, 13.459, 13.101, 13.337, 12.432, 12.100,
C       1979   1980   1981,  1982  1983   1984   1985   1986
     H 6.289, 6.232, 6.088, 6.026, 5.983, 5.944, 4.147, 3.661,
C       1987   1988   1989   1990  1991,  1992   1993   1994
     H 1.383, 0.934, 0.936, 0.530, 0.501, 0.502, 0.504, 0.505,
C      1995   2007   2008   NEYR   8*0.0,
     H 0.507, 0.508, 0.112, 0.092, 8*0.0,
     C 318.429, 237.088, 230.040, 223.917, 227.960, 212.478,
     C 206.817, 97.937, 97.040, 94.797, 93.844, 93.172, 92.555,
     C 65.183, 51.570, 18.757, 20.857, 20.898, 10.425, 10.771,
     C 10.799, 10.835, 10.863, 10.899, 10.934, 10*0.0,
C      1969    1973    1974   1975   1976   1977   1978   1979
     N 12.476, 14.077, 9.975, 9.709, 9.885, 9.213, 8.968, 10.150,
C      1980    1981   1982   1983   1984   1985   1986   1987
     N 10.057, 9.825, 9.726, 9.656, 9.592, 9.490, 9.502, 8.702,
C      1988   1989   1990   1991   1992   1993   1994   1995
     N 7.475, 7.490, 5.462, 4.915, 4.928, 4.944, 4.957, 4.973,
C      1997   2007   2008   NEYR   7*0000
     N 4.990, 3.989, 0.491, 0.196, 7*0.0/
C
        DATA ZL14/
C  HDGV8B
C       1969   1973     1974   1975    1976    1977    1978
     H 33.086, 17.556, 16.805, 16.156, 15.521, 15.521, 15.521, 
C       1979   1980   1981  1982   1983   1984   1985   1986
     H 8.266, 8.266, 8.266, 8.266, 8.266, 8.266, 5.809, 5.166,
C       1987   1988   1989  1990   1991   1992,  1993,  1994,
     H 1.951, 1.319, 1.321, 0.747, 0.706, 0.708, 0.711, 0.713,
C      1995    2007   2008   NEYR   8*0000
     H 0.715, 0.717,  0.112, 0.092, 8*0.0,
     C 403.002, 300.057, 287.232, 276.141, 265.280, 265.280, 
     C 265.280, 128.714, 128.714, 128.714, 128.714, 128.714, 
     C 128.714,  91.312,  72.775,  26.470,  29.433,  29.492,  
     C  14.711,  15.199,  15.240,  15.290,  15.330,  15.380, 
     C  15.430,   10*0.0,
C      1969    1973    1974    1975    1976    1977    1978
     N 15.790, 17.815, 12.455, 11.974, 11.503, 11.503, 11.503,
C      1979    1980    1981    1982    1983    1984    1985
     N 13.340, 13.340, 13.340, 13.340, 13.340, 13.340, 13.294,
C      1986    1987    1988    1989     1990    1991    1992
     N 13.409, 12.281, 10.548, 10.569,  7.708,  6.936,  6.954,
C       1993    1994    1995    1997    2007    2008
     N  6.977,  6.996,  7.018,  7.041,  5.629,  0.491,
C       NEYR   7*0000
     N  0.196, 7*0.0,
C  LDDV
     H 35*0.,
     C 35*0.,
     N 35*0./
C
        DATA ZL16/
C  LDDT12
     H 35*0.,
     C 35*0.,
     N 35*0.,
C  HDDV2B
     H 1.159, 1.159, 1.159, 1.159, 1.159, 1.159, 1.159, 1.159,
     H 1.159, 1.159, 1.159, 1.159, 1.159, 1.102, 1.102, 1.102,
     H 1.080, 1.080, 1.079, 1.078, 0.947, 0.947, 0.706, 0.705,
     H 0.571, 0.516, 0.515, 0.514, 0.284, 0.284, 0.283, 0.189,
     H 0.141, 2*0.0,
     C 3.383, 3.383, 3.383, 3.383, 3.383, 3.383, 3.383, 3.383,
     C 3.383, 3.383, 3.383, 3.383, 3.383, 4.409, 4.409, 4.409,
     C 4.320, 4.320, 4.315, 4.310, 4.301, 4.301, 1.335, 1.332,
     C 1.989, 0.439, 0.438, 0.438, 1.301, 1.298, 1.297,
     C 0.131, 3*0.,
     N 7.534, 7.534, 7.534, 7.534, 7.534, 7.534, 7.534, 7.534,
     N 7.534, 7.534, 7.534, 7.534, 7.534, 7.469, 7.469, 7.469,
     N 7.319, 7.319, 7.311, 7.303, 7.287, 7.287, 4.787, 4.778,
     N 5.330, 4.805, 4.796, 4.792, 4.459, 4.451, 4.447, 3.553,
     N 2.299, 1.242, 0.196/
C
        DATA ZL18/
C  HDDV3
     H 2.658, 2.658, 2.658, 2.658, 2.658, 2.658, 2.658, 2.658,
     H 2.471, 2.311, 2.167, 2.167, 2.167, 2.062, 2.062, 2.062,
     H 2.062, 2.062, 2.062, 2.062, 1.815, 1.815, 0.802, 0.801,
     H 0.651, 0.588, 0.588, 0.588, 0.325, 0.325, 0.325, 0.216,
     H 0.161, 2*0.0,
     C 7.760, 7.760, 7.760, 7.760, 7.760, 7.760, 7.760, 7.760,
     C 7.214, 6.747, 6.327, 6.327, 6.327, 8.246, 8.246, 8.246,
     C 8.246, 8.246, 8.246, 8.246, 8.246, 8.246, 1.516, 1.515,
     C 2.264, 0.500, 0.500, 0.500, 1.488, 1.488, 1.488,
     C 0.150, 3*0.0,
     N 17.283, 17.283, 17.283, 17.283, 17.283, 17.283, 17.283,
     N 17.283, 16.068, 15.028, 14.092, 14.092, 14.092, 13.971,
     N 13.971, 13.971, 13.971, 13.971, 13.971, 13.971, 13.971,
     N 13.971,  5.438,  5.434,  6.067,  5.475,  5.475,  5.475, 
     N  5.100,  5.100,  5.100,  4.075,  2.636,  1.424,  0.225,
C  HDDV4
     H 2.658, 2.658, 2.658, 2.658, 2.658, 2.658, 2.658, 2.658,
     H 2.471, 2.311, 2.167, 2.167, 2.167, 2.062, 2.062, 2.062,
     H 2.062, 2.062, 2.062, 2.062, 1.815, 1.815, 0.957, 0.954,
     H 0.773, 0.696, 0.694, 0.692, 0.381, 0.380, 0.379, 0.252,
     H 0.188, 2*0.0,
     C 7.760, 7.760, 7.760, 7.760, 7.760, 7.760, 7.760, 7.760,
     C 7.214, 6.747, 6.327, 6.327, 6.327, 8.246, 8.246, 8.246,
     C 8.246, 8.246, 8.246, 8.246, 8.246, 8.246, 1.810, 1.804,
     C 2.690, 0.592, 0.590, 0.589, 1.746, 1.741, 1.735,
     C 0.175, 3*0.,
     N 17.283, 17.283, 17.283, 17.283, 17.283, 17.283, 17.283,
     N 17.283, 16.068, 15.028, 14.092, 14.092, 14.092, 13.971,
     N 13.971, 13.971, 13.971, 13.971, 13.971, 13.971, 13.971,
     N 13.971, 6.493, 6.471, 7.207, 6.487, 6.465, 6.447, 5.985,
     N 5.969, 5.949, 4.753, 3.075, 1.661, 0.262/

C
        DATA ZL20/
C  HDDV5
     H 2.658, 2.658, 2.658, 2.658, 2.658, 2.658, 2.658, 2.658,
     H 2.471, 2.311, 2.167, 2.167, 2.167, 2.062, 2.062, 2.062,
     H 2.062, 2.062, 2.062, 2.062, 1.815, 1.815, 1.073, 1.064,
     H 0.857, 0.769, 0.763, 0.757, 0.415, 0.412, 0.409, 0.272,
     H 0.203, 2*0.0,
     C 7.760, 7.760, 7.760, 7.760, 7.760, 7.760, 7.760, 7.760,
     C 7.214, 6.747, 6.327, 6.327, 6.327, 8.246, 8.246, 8.246,
     C 8.246, 8.246, 8.246, 8.246, 8.246, 8.246, 2.028, 2.011,
     C 2.985, 0.654, 0.649, 0.644, 1.900, 1.886, 1.872,
     C 0.189, 3*0.0,
     N 17.283, 17.283, 17.283, 17.283, 17.283, 17.283, 17.283,
     N 17.283, 16.068, 15.028, 14.092, 14.092, 14.092, 13.971,
     N 13.971, 13.971, 13.971, 13.971, 13.971, 13.971, 13.971,
     N 13.971,  7.274,  7.213,  7.998,  7.166,  7.109,  7.052, 
     N 6.516, 6.467, 6.418, 5.128, 3.317, 1.792, 0.283,

C  HDDV6
     H 3.016, 3.016, 3.016, 3.077, 3.077, 3.141, 3.208, 3.208,
     H 3.138, 3.004, 2.881, 2.833, 2.726, 2.498, 2.410, 2.331,
     H 2.255, 2.236, 2.214, 2.196, 1.921, 1.921, 1.306, 1.303,
     H 1.024, 0.786, 0.784, 0.782, 0.605, 0.604, 0.602, 0.321,
     H 0.251, 2*0.0,
     C 8.805, 8.805, 8.805, 8.984, 8.984, 9.171, 9.365, 9.365,
     C 9.160, 8.769, 8.410, 8.270, 7.957, 9.992, 9.641, 9.323,
     C 9.018, 8.943, 8.855, 8.784, 8.728, 8.728, 3.364, 3.356,
     C 3.564, 2.475, 2.470, 2.463, 1.658, 1.655, 1.651,
     C 0.194, 3*0.0,
     N 19.611, 19.611, 19.611, 20.011, 20.011, 20.427, 20.859,
     N 20.859, 20.403, 19.531, 18.731, 18.419, 17.723, 16.929,
     N 16.334, 15.795, 15.279, 15.152, 15.002, 14.883, 14.788,
     N 14.788, 12.725, 12.693, 9.550, 8.897, 8.879, 8.856, 
     N 8.994, 8.976, 8.953, 7.166, 4.081, 2.196, 0.350/
C
        DATA ZL22/
C  HDDV7
     H 3.187, 3.253, 3.253, 3.253, 3.322, 3.322, 3.322, 3.395,
     H 3.413, 3.419, 3.395, 3.386, 3.218, 2.822, 2.637, 2.608,
     H 2.566, 2.546, 2.526, 2.507, 2.191, 2.191, 1.579, 1.580,
     H 1.246, 0.959, 0.960, 0.961, 0.746, 0.746, 0.747, 0.399,
     H 0.311, 2*0.0,
     C 9.304,  9.498,  9.498,  9.498,  9.699, 9.699,  9.699,  9.911,
     C 9.965,  9.982,  9.911,  9.886,  9.394, 11.288, 10.549, 10.432,
     C 10.263, 10.184, 10.104, 10.029, 9.954, 9.954,  4.066,
     C 4.070, 4.337, 3.021, 3.024, 3.028, 2.044, 2.046, 2.048,
     C 0.241, 3*0.,
     N 20.723, 21.154, 21.154, 21.154, 21.602, 21.602, 21.602,
     N 22.074, 22.194, 22.234, 22.074, 22.018, 20.923, 19.125,
     N 17.872, 17.674, 17.388, 17.254, 17.119, 16.992, 16.865,
     N 16.865, 15.381, 15.393, 11.621, 10.863, 10.872, 10.886,
     N 11.087, 11.096, 11.105,  8.889,  5.063,  2.725,  0.434,
C
C  HDDV8A
     H 3.499, 3.572, 3.572, 3.648, 3.648, 3.728, 3.728, 3.728,
     H 3.818, 3.811, 3.882, 3.911, 3.845, 3.609, 3.583, 3.634,
     H 3.614, 3.579, 3.551, 3.522, 3.077, 3.077, 1.385, 1.373,
     H 1.507, 0.862, 0.855, 0.848, 0.617, 0.612, 0.608, 0.388,
     H 0.356, 2*0.0,
     C 10.216, 10.428, 10.428, 10.650, 10.650, 10.884, 10.884,
     C 10.884, 11.146, 11.124, 11.333, 11.419, 11.225, 14.438,
     C 14.330, 14.536, 14.457, 14.316, 14.204, 14.087, 13.979,
     C 13.979,  3.948,  3.915,  5.245,  5.231,  5.189,  5.147,
     C  3.002,  2.979,  2.956,  0.332, 3*0.0,
     N 22.754, 23.226, 23.226, 23.722, 23.722, 24.242, 24.242,
     N 24.242, 24.825, 24.778, 25.241, 25.433, 25.001, 24.461,
     N 24.279, 24.628, 24.493, 24.255, 24.065, 23.867, 23.684,
     N 23.684, 18.501, 18.350, 14.055, 13.105, 13.001, 12.896,
     N 12.936, 12.834, 12.737, 10.168, 5.497, 2.937, 0.497/
C
        DATA ZL24/
C  HDDV8B
     H 3.781, 3.860, 3.860, 3.942, 3.942, 4.028, 4.028, 4.028,
     H 4.091, 4.058, 4.124, 4.184, 4.134, 3.869, 3.898, 3.808,
     H 3.688, 3.686, 3.675, 3.671, 3.223, 3.223, 1.534, 1.519,
     H 1.665, 0.951, 0.942, 0.934, 0.679, 0.673, 0.667, 0.426,
     H 0.391, 2*0.0,
     C 11.038, 11.268, 11.268, 11.509, 11.509, 11.760, 11.760,
     C 11.760, 11.943, 11.846, 12.040, 12.216, 12.069, 15.477,
     C 15.594, 15.233, 14.751, 14.742, 14.700, 14.686, 14.644,
     C 14.644,  4.372,  4.330,  5.794,  5.771,  5.717,  5.666, 
     C  3.301,  3.272,  3.243,  0.364, 3*0.,
     N 24.586, 25.097, 25.097, 25.633, 25.633, 26.193, 26.193,
     N 26.193, 26.601, 26.385, 26.817, 27.209, 26.881, 26.221,
     N 26.420, 25.809, 24.992, 24.977, 24.905, 24.881, 24.810,
     N 24.810, 20.492, 20.291, 15.525, 14.460, 14.323, 14.195,
     N 14.222, 14.097, 13.973, 11.154, 6.030, 3.222, 0.546,
C  MC
     H 35*0.,
     C 35*0.,
     N 35*0./
C
        DATA ZL26/
C  HDGB (GASOLINE BUS) 
C      1966    1967    1968    1969     1970   1971   1972
     H 15.819, 15.819, 15.861, 15.836,  8.403, 8.403, 7.977,
C       1973    1974    1975    1976    1977   1978   1979
     H  7.990,  7.990,  8.044,  8.011,  8.011, 8.004, 4.266, 
C       1980    1981    1982    1983    1984   1985   1986
     H  4.129,  4.158,  4.180,  4.180,  4.180, 2.937, 2.612,  
C        1987   1988    1989    1990    1991   1992   1993
     H  1.492,  1.009,  1.012,  0.574,  0.543, 0.545, 0.547,  
C       1994    1995    2007   2008   NEYR   2*0000
     H  0.549,  0.551,  0.593, 0.130, 0.107, 2*0.0,
     C 192.690, 192.690, 193.199, 192.889, 143.616, 143.616, 136.337, 
     C 136.568, 136.568, 137.493, 136.915, 136.915, 136.799,  66.431,  
     C  64.301,  64.749,  65.086,  65.086,  65.086,  46.173,  36.800,  
     C  20.243,  22.532,  22.601,  11.293,  11.680,  11.722,  11.772, 
     C  11.814,  11.864,  12.750,   4*0.0,
C      1966   1967   1968   1969   1970   1971   1972
     N 7.550, 7.550, 7.570, 7.557, 8.527, 8.527, 8.095,
C      1973   1974   1975   1976   1977   1978   1979
     N 8.109, 5.922, 5.962, 5.937, 5.937, 5.932, 6.885,
C      1980   1981   1982   1983   1984   1985   1986
     N 6.664, 6.711, 6.745, 6.745, 6.745, 6.722, 6.780,
C      1987   1988   1989   1990   1991   1992   1993
     N 9.391, 8.075, 8.100, 5.917, 5.330, 5.349, 5.372,
C      1994   1995   1997   2007   2008   NEYR   0000
     N 5.391, 5.414, 5.818, 4.651, 0.573, 0.229, 0.0,
C  HDDBT (DIESEL TRANSIT BUS)
     H 3.501, 3.501, 3.644, 3.715, 3.690, 3.690,
     H 3.690, 3.690, 3.690, 3.690, 3.690, 3.491,
     H 3.532, 3.364, 3.407, 3.516, 3.587, 3.587,
     H 3.587, 3.587, 3.157, 3.157, 1.884, 1.884,
     H 2.085, 2.486, 2.488, 1.204, 0.321, 0.322,
     H 0.322, 0.322, 3*0.0,
     C 10.221, 10.221, 10.638, 10.846, 10.772, 10.772,
     C 10.772, 10.772, 10.772, 10.772, 10.772, 10.193,
     C 10.311, 13.455, 13.628, 14.063, 14.347, 14.347,
     C 14.347, 14.347, 14.347, 14.347,  5.371,  5.371,
     C  7.257, 10.827, 10.834, 11.642,  4.258,  4.262,
     C  4.266, 0.443, 3*0.0,
     N 22.766, 22.766, 23.694, 24.158, 23.994, 23.994,
     N 23.994, 23.994, 23.994, 23.994, 23.994, 22.702,
     N 22.966, 22.796, 23.089, 23.827, 24.307, 24.307,
     N 24.307, 24.307, 24.307, 24.307, 25.173, 25.173,
     N 19.446, 18.246, 18.257, 17.102, 19.603, 19.620,
     N 19.640, 15.696,  8.894,  4.830,  0.725/
C
        DATA ZL28/
C  HDDBS (DIESEL SCHOOL BUS) 
     H 2.033, 2.033, 2.033, 2.033, 2.033, 2.033,
     H 2.033, 2.033, 2.033, 2.033, 2.033, 2.033,
     H 2.033, 1.934, 1.876, 1.884, 1.890, 1.890,
     H 1.890, 1.890, 1.663, 1.663, 1.764, 1.772,
     H 1.402, 1.083, 1.108, 1.129, 0.892, 0.909,
     H 0.927, 0.495, 0.386, 2*0.000,
     C 5.936, 5.936, 5.936, 5.936, 5.936, 5.936,
     C 5.936, 5.936, 5.936, 5.936, 5.936, 5.936,
     C 5.936, 7.736, 7.502, 7.535, 7.558, 7.558,
     C 7.558, 7.558, 7.558, 7.558, 4.544, 4.565,
     C 4.882, 3.412, 3.491, 3.557, 2.445, 2.492,
     C 2.541, 0.299, 3*0.0,
     N 13.221, 13.221, 13.221, 13.221, 13.221, 13.221,
     N 13.221, 13.221, 13.221, 13.221, 13.221, 13.221,
     N 13.221, 13.107, 12.710, 12.766, 12.805, 12.805,
     N 12.805, 12.805, 12.805, 12.805, 17.187, 17.265,
     N 13.080, 12.267, 12.553, 12.788, 13.263, 13.517,
     N 13.779, 11.029,  6.281,  3.381,  0.538,
C  LDDT34
     H 35*0.,
     C 35*0.,
     N 35*0./
C
C  High altitude region
C
        DATA ZH02/
C  LDGV
     H 35*0.,
     C 35*0.,
     N 35*0.,
C  LDGT1
     H 35*0.,
     C 35*0.,
     N 35*0./
C
        DATA ZH04/
C  LDGT2
     H 35*0.,
     C 35*0.,
     N 35*0.,
C  LDGT3
     H 35*0.,
     C 35*0.,
     N 35*0./
C
         DATA ZH06/
C  LDGT4
     H 35*0.,
     C 35*0.,
     N 35*0.,
CG  HDGV2B
C      1969    1973   1974   1975   1976   1977   1978   1979   1980
     H 16.670, 8.845, 8.643, 8.449, 8.256, 8.081, 7.906, 4.127, 4.097,
C      1981   1982   1983   1984   1985   1986   1987   1988   1989
     H 4.019, 3.994, 3.989, 3.989, 2.797, 2.481, 1.823, 1.232, 1.234,
C      1990   1991   1992   1993   1994   1995   2007   2008
     H 0.699, 0.661, 0.662, 0.664, 0.667, 0.668, 0.671, 0.182,
C      NEYR   8*0000
     H 0.145, 8*0.0,
     C 267.108, 198.877, 194.319, 189.969, 185.618, 181.682, 177.746,
     C 84.534, 83.931, 82.322, 81.820, 81.719, 81.719, 57.830, 45.977,
     C 42.412, 47.166, 47.254, 23.590, 24.377, 24.445, 24.513, 24.603,
     C 24.671, 24.761, 10*0.0,
C      1969   1973   1974   1975   1976   1977   1978   1979   1980
     N 3.887, 4.386, 3.130, 3.060, 2.990, 2.926, 2.863, 3.254, 3.231,
C      1981   1982   1983   1984   1985   1986   1987   1988   1989
     N 3.169, 3.150, 3.146, 3.146, 3.127, 3.147, 5.058, 4.345, 4.353,
C      1990   1991   1992   1993   1994   1995   1997   2007
     N 3.177, 2.860, 2.868, 2.876, 2.886, 2.894, 2.905, 2.322,
C      2008   NEYR   7*0000
     N 0.284, 0.098, 7*0.0/
C
        DATA ZH08/
CG  HDGV3
C      1969    1973    1974    1975    1976    1977    1978
     H 23.494, 12.466, 12.430, 12.393, 12.356, 12.310, 12.273,
C      1979   1980   1981   1982   1983   1984   1985   1986
     H 6.516, 6.590, 6.570, 6.649, 6.644, 6.639, 4.655, 4.128,
C      1987   1988   1989   1990   1991   1992   1993   1994
     H 1.966, 1.324, 1.323, 0.747, 0.703, 0.703, 0.703, 0.703,
C      1995   2007   2008   NEYR   8*0000
     H 0.703, 0.704, 0.163, 0.136, 8*0.0,
     C 376.456, 280.292, 279.463, 278.635, 277.806, 276.770,
     C 275.941, 133.485, 134.992, 134.590, 136.199, 136.098,
     C 135.998, 96.265, 76.496, 45.747, 50.689, 50.645, 25.213,
     C 25.958, 25.958, 25.958, 25.958, 25.958, 25.981, 10*0.0,
C      1969   1973   1974   1975   1976   1977   1978   1979
     N 5.479, 6.182, 4.501, 4.488, 4.474, 4.458, 4.444, 5.139,
C      1980   1981   1982   1983   1984   1985   1986   1987
     N 5.197, 5.181, 5.243, 5.239, 5.235, 5.206, 5.235, 5.456,
C      1988   1989   1990   1991   1992   1993   1994   1995
     N 4.670, 4.666, 3.396, 3.045, 3.045, 3.045, 3.045, 3.045,
C      1997   2007   2008   NEYR   7*0000
     N 3.048, 2.436, 0.310, 0.134, 7*0.0,
C
C  HDGV4
C      1969    1973    1974    1975    1976    1977    1978
     H 23.494, 12.466, 12.430, 12.393, 12.356, 12.310, 12.273, 
C      1979   1980   1981   1982   1983   1984   1985   1986
     H 6.516, 6.590, 6.570, 6.649, 6.644, 6.639, 4.659, 4.134, 
C      1987   1988   1989   1990   1991   1992   1993   1994
     H 1.986, 1.334, 1.330, 0.748, 0.703, 0.702, 0.700, 0.698,
C      1995   2007   2008   NEYR   8*0000
     H 0.696, 0.694, 0.152, 0.125, 8*0.0,
     C 376.456, 280.292, 279.463, 278.635, 277.806, 276.770, 
     C 275.941, 133.485, 134.992, 134.590, 136.199, 136.098, 
     C 135.998, 96.337, 76.610, 46.224, 51.085, 50.909, 25.256, 
     C 25.958, 25.891, 25.823, 25.755, 25.687, 25.620, 10*0.0,
C      1969   1973   1974   1975   1976   1977   1978   1979
     N 5.479, 6.182, 4.501, 4.488, 4.474, 4.458, 4.444, 5.139, 
C      1980   1981   1982   1983   1984   1985   1986   1987
     N 5.197, 5.181, 5.243, 5.239, 5.235, 5.210, 5.243, 5.513, 
C      1988   1989   1990   1991   1992   1993   1994   1995
     N 4.706, 4.690, 3.402, 3.045, 3.037, 3.029, 3.021, 3.013, 
C      1997   2007   2008   NEYR   7*0000
     N 3.005, 2.403, 0.296, 0.118, 7*0.0/
C
        DATA ZH10/
C  HDGV5
C      1969    1973    1974    1975    1976    1977    1978
     H 23.494, 12.466, 12.430, 12.393, 12.356, 12.310, 12.273, 
C      1979   1980   1981   1982   1983   1984   1985   1986
     H 6.516, 6.590, 6.570, 6.649, 6.639, 6.629, 4.645, 4.116, 
C      1987   1988   1989   1990   1991   1992   1993   1994
     H 2.203, 1.488, 1.492, 0.845, 0.799, 0.801, 0.803, 0.806,
C      1995   2007   2008   NEYR   8*0000
     H 0.808, 0.810, 0.178, 0.146, 8*0.0,
     C 376.456, 280.292, 279.463, 278.635, 277.806, 276.770, 
     C 275.941, 133.485, 134.992, 134.590, 136.199, 135.998, 
     C 135.797, 96.051, 76.269, 51.267, 56.986, 57.118, 28.523, 
     C 29.483, 29.551, 29.641, 29.731, 29.822, 29.912, 10*0.0,
C      1969   1973   1974   1975   1976   1977   1978   1979
     N 5.479, 6.182, 4.501, 4.488, 4.474, 4.458, 4.444, 5.139, 
C      1980   1981   1982   1983   1984   1985   1986   1987
     N 5.197, 5.181, 5.243, 5.235, 5.228, 5.194, 5.220, 6.114, 
C      1988   1989   1990   1991   1992   1993   1994   1995
     N 5.250, 5.262, 3.842, 3.459, 3.467, 3.477, 3.488, 3.498, 
C      1997   2007   2008   NEYR   7*0000
     N 3.509, 2.805, 0.345, 0.138, 7*0.0,
C  HDGV6
C      1969    1973    1974    1975    1976    1977    1978
     H 26.273, 13.941, 14.189, 14.318, 14.291, 14.162, 13.987, 
C      1979   1980   1981   1982   1983   1984   1985   1986
     H 7.321, 7.125, 6.963, 6.663, 6.609, 6.560, 4.576, 4.039, 
C      1987   1988   1989   1990   1991   1992   1993   1994
     H 2.237, 1.507, 1.507, 0.850, 0.801, 0.801, 0.801, 0.801,
C      1995   2007   2008   NEYR   8*0000
     H 0.802, 0.803, 0.176, 0.145, 8*0.0,
     C 420.974, 313.438, 319.031, 321.932, 321.310, 318.410, 
     C 314.474, 149.969, 145.949, 142.632, 136.500, 135.394, 
     C 134.389, 94.625, 74.848, 52.062, 57.691, 57.691, 28.698, 
     C 29.573, 29.573, 29.573, 29.573, 29.596, 29.618, 10*0.0,
C      1969   1973   1974   1975   1976   1977   1978   1979
     N 6.127, 6.913, 5.138, 5.185, 5.175, 5.128, 5.065, 5.773, 
C      1980   1981   1982   1983   1984   1985   1986   1987
     N 5.618, 5.491, 5.255, 5.212, 5.173, 5.117, 5.122, 6.209, 
C      1988   1989   1990   1991   1992   1993   1994   1995
     N 5.315, 5.315, 3.865, 3.469, 3.469, 3.469, 3.469, 3.472, 
C      1997   2007   2008   NEYR   7*0000
     N 3.475, 2.778, 0.342, 0.137, 7*0.0/
C
        DATA ZH12/
C  HDGV7
C      1969    1973    1974    1975    1976    1977    1978
     H 32.993, 17.506, 17.423, 17.387, 17.313, 17.165, 16.705, 
C      1979   1980   1981   1982   1983   1984   1985   1986
     H 8.592, 8.371, 8.391, 8.410, 8.351, 8.302, 5.793, 5.115, 
C      1987   1988   1989   1990   1991   1992   1993   1994
     H 2.360, 1.597, 1.604, 0.910, 0.863, 0.867, 0.871, 0.875,
C      1995   2007   2008   NEYR   8*0000
     H 0.880, 0.885, 0.194, 0.160, 8*0.0,
     C 528.652, 393.610, 391.746, 390.917, 389.260, 385.945, 
     C 375.587, 176.003, 171.480, 171.882, 172.284, 171.078, 
     C 170.072, 119.797,  94.796,  54.921,  61.170,  61.434, 
     C  30.737,  31.832,  31.991,  32.149,  32.307,  32.488, 
     C  32.668, 10*0.0,
C      1969   1973   1974   1975   1976   1977    1978   1979
     N 7.694, 8.681, 6.310, 6.296, 6.270, 6.216, 6.049, 6.775, 
C      1980   1981   1982   1983   1984   1985   1986   1987
     N 6.601, 6.617, 6.632, 6.586, 6.547, 6.478, 6.488, 6.550, 
C      1988   1989   1990   1991   1992   1993   1994   1995
     N 5.636, 5.660, 4.140, 3.734, 3.753, 3.771, 3.790, 3.811, 
C      1997   2007   2008   NEYR   7*0000
     N 3.832, 3.064, 0.377, 0.151, 7*0.0,
C  HDGV8A
C      1969    1973    1974    1975    1976    1977    1978
     H 35.632, 18.907, 18.345, 17.856, 18.179, 16.944, 16.493, 
C      1979   1980   1981   1982   1983   1984   1985   1986
     H 8.572, 8.494, 8.297, 8.214, 8.155, 8.101, 5.652, 4.990, 
C      1987   1988   1989   1990   1991   1992   1993   1994
     H 2.565, 1.733, 1.737, 0.982, 0.929, 0.931, 0.934, 0.937, 
C      1995   2007   2008   NEYR   8*0000
     H 0.940, 0.943, 0.207, 0.170, 8*0.0,
     C 570.944, 425.099, 412.462, 401.482, 408.733, 380.973, 
     C 370.822, 175.601, 173.992, 169.972, 168.263, 167.057, 
     C 165.951, 116.873,  92.466,  59.686,  66.367,  66.499,
     C  33.171,  34.272,  34.363,  34.476,  34.566,  34.679, 
     C  34.792,  10*0.0,
C      1969   1973   1974   1975   1976   1977   1978   1979
     N 8.309, 9.375, 6.643, 6.466, 6.583, 6.136, 5.973, 6.760, 
C      1980   1981   1982   1983   1984   1985   1986   1987
     N 6.698, 6.543, 6.477, 6.431, 6.388, 6.320, 6.328, 7.119, 
C      1988   1989   1990   1991   1992   1993   1994   1995
     N 6.114, 6.126, 4.468, 4.021, 4.031, 4.044, 4.055, 4.068, 
C      1997   2007   2008   NEYR   7*0000
     N 4.081, 3.263, 0.401, 0.161, 7*0.0/
C
         DATA ZH14/
C  HDGV8B
C      1969    1973    1974    1975    1976    1977    1978
     H 45.096, 23.928, 22.906, 22.021, 21.155, 21.155, 21.155, 
C      1979    1980    1981    1982    1983    1984    1985
     H 11.266, 11.266, 11.266, 11.266, 11.266, 11.266, 7.918, 
C      1986    1987    1988    1989    1990    1991    1992
     H  7.041,  3.620,  2.446,  2.451,  1.386,  1.310, 1.314, 
C       1993    1994    1995    2007    2008   NEYR,  8*0000
     H  1.318,  1.322,  1.326,  1.330,  0.207, 0.170, 8*0.0,
     C 722.583, 538.003, 515.008, 495.120, 475.647, 475.647, 
     C 475.647, 230.784, 230.784, 230.784, 230.784, 230.784, 
     C 230.784, 163.722, 130.486,  84.228,  93.656,  93.842, 
     C  46.810,  48.365,  48.492,  48.652,  48.779,  48.939, 
     C  49.098,  10*0.0,
C       1969   1973    1974   1975   1976   1977   1978   1979
     N 10.516, 11.865, 8.295, 7.975, 7.661, 7.661, 7.661, 8.884, 
C       1980    1981   1982   1983   1984   1985   1986   1987
     N  8.884,  8.884, 8.884, 8.884, 8.884, 8.854, 8.930,10.046, 
C       1988    1989   1990   1991   1992   1993   1994   1995
     N  8.628,  8.646, 6.305, 5.674, 5.689, 5.707, 5.722, 5.741,
C       1997    2007   2008   NEYR   7*0000
     N  5.760,  4.604, 0.401, 0.161, 7*0.0,
C  LDDV
     H 35*0.,
     C 35*0.,
     N 35*0./
C
         DATA ZH16/
C  LDDT12
     H 35*0.,
     C 35*0.,
     N 35*0.,
C  HDDV2B
     H 2.375, 2.375, 2.375, 2.375, 2.375, 2.375, 2.375, 2.375, 
     H 2.375, 2.375, 2.375, 2.375, 2.375, 2.259, 2.259, 2.259, 
     H 2.214, 2.214, 2.211, 2.209, 1.940, 1.940, 1.447, 1.445, 
     H 1.172, 1.057, 1.055, 1.054, 0.583, 0.582, 0.581, 0.387,
     H 0.288, 2*0.0,
     C 8.321,  8.321, 8.321, 8.321, 8.321, 8.321, 8.321, 8.321,
     C 8.321,  8.321, 8.321, 8.321, 8.321,10.845,10.845,10.845,
     C 10.626,10.626,10.615,10.603,10.580,10.580, 3.283,
     C  3.277, 4.893, 1.079, 1.077, 1.076, 3.200, 3.194, 3.191,
     C  0.322, 3*0.,
     N 7.685, 7.685, 7.685, 7.685, 7.685, 7.685, 7.685, 7.685, 
     N 7.685, 7.685, 7.685, 7.685, 7.685, 7.619, 7.619, 7.619, 
     N 7.465, 7.465, 7.457, 7.449, 7.433, 7.433, 4.883, 4.874, 
     N 5.437, 4.901, 4.892, 4.888, 4.549, 4.540, 4.536, 3.624, 
     N 2.345, 1.266, 0.200/
C
        DATA ZH18/
C  HDDV3
     H 5.449, 5.449, 5.449, 5.449, 5.449, 5.449, 5.449, 5.449, 
     H 5.066, 4.738, 4.443, 4.443, 4.443, 4.226, 4.226, 4.226, 
     H 4.226, 4.226, 4.226, 4.226, 3.720, 3.720, 1.644, 1.643, 
     H 1.334, 1.204, 1.204, 1.204, 0.666, 0.666, 0.666, 0.443,
     H 0.331, 2*0.0,
     C 19.089, 19.089, 19.089, 19.089, 19.089, 19.089, 19.089, 
     C 19.089, 17.746, 16.598, 15.564, 15.564, 15.564, 20.286, 
     C 20.286, 20.286, 20.286, 20.286, 20.286, 20.286, 20.286, 
     C 20.286, 3.730, 3.727, 5.570, 1.230, 1.230, 1.230, 3.659, 
     C 3.659, 3.659, 0.369, 3*0.,
     N 17.629, 17.629, 17.629, 17.629, 17.629, 17.629, 17.629, 
     N 17.629, 16.389, 15.329, 14.374, 14.374, 14.374, 14.250, 
     N 14.250, 14.250, 14.250, 14.250, 14.250, 14.250, 14.250, 
     N 14.250,  5.547,  5.542, 6.189, 5.585, 5.585, 5.585, 5.202, 
     N 5.202, 5.202, 4.157, 2.689, 1.452, 0.230,
C  HDDV4
     H 5.449, 5.449, 5.449, 5.449, 5.449, 5.449, 5.449, 5.449, 
     H 5.066, 4.738, 4.443, 4.443, 4.443, 4.226, 4.226, 4.226, 
     H 4.226, 4.226, 4.226, 4.226, 3.720, 3.720, 1.963, 1.956, 
     H 1.584, 1.427, 1.422, 1.418, 0.782, 0.780, 0.777, 0.517,
     H 0.386, 2*0.0,
     C 19.089, 19.089, 19.089, 19.089, 19.089, 19.089, 19.089, 
     C 19.089, 17.746, 16.598, 15.564, 15.564, 15.564, 20.286, 
     C 20.286, 20.286, 20.286, 20.286, 20.286, 20.286, 20.286, 
     C 20.286, 4.453, 4.438, 6.617, 1.457, 1.452, 1.448, 4.294, 
     C 4.283, 4.268, 0.430, 3*0.,
     N 17.629, 17.629, 17.629, 17.629, 17.629, 17.629, 17.629, 
     N 17.629, 16.389, 15.329, 14.374, 14.374, 14.374, 14.250, 
     N 14.250, 14.250, 14.250, 14.250, 14.250, 14.250, 14.250, 
     N 14.250,  6.622,  6.600,  7.351,  6.617,  6.594,  6.576,
     N  6.105,  6.088,  6.068,  4.848,  3.136,  1.694,  0.268/
C
        DATA ZH20/
C  HDDV5
     H 5.449, 5.449, 5.449, 5.449, 5.449, 5.449, 5.449, 5.449, 
     H 5.066, 4.738, 4.443, 4.443, 4.443, 4.226, 4.226, 4.226, 
     H 4.226, 4.226, 4.226, 4.226, 3.720, 3.720, 2.199, 2.181, 
     H 1.758, 1.576, 1.564, 1.551, 0.851, 0.845, 0.838, 0.558,
     H 0.416, 2*0.0,
     C 19.089, 19.089, 19.089, 19.089, 19.089, 19.089, 19.089, 
     C 19.089, 17.746, 16.598, 15.564, 15.564, 15.564, 20.286, 
     C 20.286, 20.286, 20.286, 20.286, 20.286, 20.286, 20.286, 
     C 20.286,  4.989,  4.947,  7.342,  1.610,  1.597,  1.584,
     C  4.675,  4.640,  4.605,  0.464,  3*0.,
     N 17.629, 17.629, 17.629, 17.629, 17.629, 17.629, 17.629, 
     N 17.629, 16.389, 15.329, 14.374, 14.374, 14.374, 14.250, 
     N 14.250, 14.250, 14.250, 14.250, 14.250, 14.250, 14.250, 
     N 14.250,  7.419,  7.357,  8.158,  7.309,  7.251,  7.193,
     N  6.646,  6.596,  6.546,  5.231,  3.384,  1.827,  0.289,
C  HDDV6
     H 6.183, 6.183, 6.183, 6.309, 6.309, 6.440, 6.576, 6.576, 
     H 6.432, 6.158, 5.905, 5.807, 5.588, 5.121, 4.941, 4.778, 
     H 4.622, 4.584, 4.538, 4.502, 3.938, 3.938, 2.678, 2.671, 
     H 2.099, 1.610, 1.607, 1.603, 1.240, 1.237, 1.234, 0.659,
     H 0.514, 2*0.0,
     C 21.660, 21.660, 21.660, 22.101, 22.101, 22.561, 23.038, 
     C 23.038, 22.534, 21.571, 20.688, 20.343, 19.575, 24.580, 
     C 23.716, 22.933, 22.185, 22.001, 21.782, 21.610, 21.471, 
     C 21.471,  8.276,  8.255,  8.767,  6.088,  6.075,  6.060,
     C  4.080,  4.071,  4.061,  0.478, 3*0.,
     N 20.003, 20.003, 20.003, 20.411, 20.411, 20.835, 21.276, 
     N 21.276, 20.811, 19.922, 19.106, 18.788, 18.078, 17.267, 
     N 16.661, 16.111, 15.585, 15.456, 15.302, 15.181, 15.083, 
     N 15.083, 12.979, 12.947,  9.741,  9.075,  9.056,  9.033,
     N  9.174,  9.155,  9.132,  7.309,  4.163,  2.240,  0.357/

C
        DATA ZH22/
C  HDDV7
     H 6.533, 6.669, 6.669, 6.669, 6.811, 6.811, 6.811, 6.959, 
     H 6.997, 7.010, 6.959, 6.942, 6.596, 5.785, 5.406, 5.346, 
     H 5.260, 5.219, 5.178, 5.140, 4.491, 4.491, 3.236, 3.239, 
     H 2.554, 1.966, 1.968, 1.970, 1.528, 1.530, 1.531, 0.817,
     H 0.637, 2*0.0,
     C 22.887, 23.364, 23.364, 23.364, 23.859, 23.859, 23.859, 
     C 24.380, 24.513, 24.557, 24.380, 24.318, 23.108, 27.769, 
     C 25.950, 25.662, 25.248, 25.052, 24.856, 24.672, 24.488, 
     C 24.488, 10.003, 10.012, 10.668,  7.433,  7.439,  7.448,
     C  5.029,  5.033,  5.037,  0.593,  3*0.,
     N 21.137, 21.578, 21.578, 21.578, 22.034, 22.034, 22.034, 
     N 22.516, 22.638, 22.679, 22.516, 22.459, 21.341, 19.507, 
     N 18.230, 18.027, 17.736, 17.599, 17.461, 17.332, 17.202, 
     N 17.202, 15.688, 15.701, 11.853, 11.080, 11.089, 11.103, 
     N 11.309, 11.318, 11.328,  9.067,  5.164,  2.779,  0.442,
C  HDDV8A
     H 7.174, 7.322, 7.322, 7.479, 7.479, 7.643, 7.643, 7.643, 
     H 7.827, 7.812, 7.958, 8.018, 7.882, 7.399, 7.344, 7.450, 
     H 7.409, 7.337, 7.279, 7.219, 6.307, 6.307, 2.838, 2.815, 
     H 3.089, 1.768, 1.753, 1.739, 1.266, 1.256, 1.246, 0.796,
     H 0.731, 2*0.0,
     C 25.131, 25.652, 25.652, 26.200, 26.200, 26.774, 26.774, 
     C 26.774, 27.419, 27.366, 27.878, 28.090, 27.613, 35.517, 
     C 35.252, 35.759, 35.563, 35.218, 34.941, 34.654, 34.389, 
     C 34.389,  9.711,  9.632, 12.904, 12.867, 12.764, 12.662,
     C  7.386,  7.328,  7.273,  0.816,  3*0.,
     N 23.209, 23.690, 23.690, 24.196, 24.196, 24.726, 24.726, 
     N 24.726, 25.322, 25.273, 25.746, 25.942, 25.501, 24.950, 
     N 24.764, 25.120, 24.983, 24.740, 24.546, 24.344, 24.158, 
     N 24.158, 18.871, 18.717, 14.336, 13.368, 13.261, 13.154, 
     N 13.194, 13.091, 12.992, 10.371,  5.607,  2.996,  0.507/
C
         DATA ZH24/
C  HDDV8B
     H 7.751, 7.912, 7.912, 8.081, 8.081, 8.258, 8.258, 8.258, 
     H 8.387, 8.318, 8.455, 8.578, 8.475, 7.932, 7.992, 7.807, 
     H 7.560, 7.555, 7.534, 7.526, 6.607, 6.607, 3.144, 3.113, 
     H 3.412, 1.950, 1.932, 1.914, 1.391, 1.379, 1.367, 0.873,
     H 0.802, 2*0.0,
     C 27.154, 27.719, 27.719, 28.311, 28.311, 28.929, 28.929, 
     C 28.929, 29.380, 29.141, 29.618, 30.051, 29.689, 38.073, 
     C 38.361, 37.474, 36.288, 36.265, 36.162, 36.127, 36.024, 
     C 36.024, 10.756, 10.651, 14.253, 14.197, 14.063, 13.938,
     C  8.120,  8.049,  7.978,  0.895,  3*0.,
     N 25.077, 25.599, 25.599, 26.146, 26.146, 26.717, 26.717,
     N 26.717, 27.133, 26.913, 27.353, 27.753, 27.419, 26.746,
     N 26.948, 26.325, 25.492, 25.476, 25.403, 25.379, 25.306,
     N 25.306, 20.901, 20.696, 15.835, 14.749, 14.609, 14.479,
     N 14.506, 14.379, 14.252, 11.377,  6.151,  3.286,  0.556,
C  MC 
     H 35*0.,
     C 35*0.,
     N 35*0./
C
         DATA ZH26/
C  HDGB (GASOLINE BUS) 
C      1966    1967    1968    1969    1970    1971    1972
     H 21.562, 21.562, 21.619, 21.584, 11.453, 11.453, 10.872,
C      1973    1974    1975    1976    1977    1978     1979
     H 10.891, 10.891, 10.965, 10.918, 10.918, 10.909,  5.815, 
C       1980    1981    1982    1983    1984    1985    1986
     H  5.628,  5.667,  5.697,  5.697,  5.697,  4.004,  3.560,  
C       1987    1988    1989    1990    1991    1992    1993
     H  2.768,  1.872,  1.878,  1.064,  1.007,  1.011,  1.015, 
C       1994    1995    2007    2008    NEYR    2*0000
     H  1.019,  1.023,  1.099,  0.241,  0.198,  2*0.0,
     C 345.492, 345.492, 346.406, 345.850, 257.504, 257.504, 244.453,
     C 244.867, 244.867, 246.524, 245.488, 245.488, 245.281, 119.111, 
     C 115.291, 116.095, 116.699, 116.699, 116.699,  82.788,  65.982, 
     C  64.412,  71.695,  71.915,  35.933,  37.164,  37.300,  37.458, 
     C  37.593,  37.752,  40.569,   4*0.0,
C      1966   1967   1968   1969   1970   1971   1972
     N 5.028, 5.028, 5.041, 5.033, 5.679, 5.679, 5.391,
C      1973   1974   1975   1976   1977   1978   1979
     N 5.400, 3.944, 3.971, 3.954, 3.954, 3.951, 4.585, 
C      1980   1981   1982   1983   1984   1985   1986
     N 4.438, 4.469, 4.492, 4.492, 4.492, 4.477, 4.516, 
C      1987   1988   1989   1990   1991   1992   1993
     N 7.682, 6.605, 6.626, 4.840, 4.360, 4.376, 4.394, 
C      1994   1995   1997   2007   2008   NEYR   0000
     N 4.410, 4.429, 4.759, 3.804, 0.468, 0.187, 0.0,
C  HDDBT (DIESEL TRANSIT BUS) 
     H 7.178, 7.178, 7.470, 7.616, 7.565, 7.565,
     H 7.565, 7.565, 7.565, 7.565, 7.565, 7.157,
     H 7.240, 6.896, 6.984, 7.207, 7.353, 7.353,
     H 7.353, 7.353, 6.473, 6.473, 3.862, 3.862,
     H 4.274, 5.097, 5.100, 2.469, 0.659, 0.659,
     H 0.66,  0.660, 3*0.0,
     C 25.144, 25.144, 26.169, 26.681, 26.500, 26.500,
     C 26.500, 26.500, 26.500, 26.500, 26.500, 25.074,
     C 25.365, 33.099, 33.525, 34.596, 35.292, 35.292,
     C 35.292, 35.292, 35.292, 35.292, 13.214, 13.214,
     C 17.853, 26.634, 26.651, 28.639, 10.474,  10.484,
     C 10.494,  1.089,  3*0.0,
     N 23.221, 23.221, 24.168, 24.641, 24.474, 24.474,
     N 24.474, 24.474, 24.474, 24.474, 24.474, 23.156,
     N 23.425, 23.252, 23.551, 24.303, 24.793, 24.793,
     N 24.793, 24.793, 24.793, 24.793, 25.677, 25.677,
     N 19.835, 18.610, 18.622, 17.444, 19.995, 20.012,
     N 20.032, 16.009,  9.072,  4.927,  0.739/
C
         DATA ZH28/
C  HDDBS (DIESEL SCHOOL BUS) 
     H 4.168, 4.168, 4.168, 4.168, 4.168, 4.168,
     H 4.168, 4.168, 4.168, 4.168, 4.168, 4.168,
     H 4.168, 3.965, 3.845, 3.862, 3.874, 3.874,
     H 3.874, 3.874, 3.410, 3.410, 3.617, 3.633, 
     H 2.875, 2.221, 2.272, 2.315, 1.828, 1.863,
     H 1.900, 1.014, 0.790, 2*0.0,
     C 14.602, 14.602, 14.602, 14.602, 14.602, 14.602,
     C 14.602, 14.602, 14.602, 14.602, 14.602, 14.602,
     C 14.602, 19.031, 18.455, 18.536, 18.593, 18.593,
     C 18.593, 18.593, 18.593, 18.593, 11.178, 11.229,
     C 12.009,  8.394,  8.589,  8.750,  6.016,  6.131,
     C  6.250,  0.735,  3*0.0,
     N 13.485, 13.485, 13.485, 13.485, 13.485, 13.485,
     N 13.485, 13.485, 13.485, 13.485, 13.485, 13.485,
     N 13.485, 13.369, 12.965, 13.021, 13.062, 13.062,
     N 13.062, 13.062, 13.062, 13.062, 17.531, 17.610,
     N 13.342, 12.513, 12.804, 13.044, 13.528, 13.787,
     N 14.055, 11.250,  6.407,  3.448,  0.549,
C  LDDT34
     H 35*0.,
     C 35*0.,
     N 35*0./
C
C  Hardcoded composite start & running deterioration rates
C
C  Low altitude region
C
        DATA DL02/
C  LDGV                          
     H 35*0.,
     C 35*0.,
     N 35*0.,
C  LDGT1
     H 35*0.,
     C 35*0.,
     N 35*0./
C
        DATA DL04/
C  LDGT2
     H 35*0.,
     C 35*0.,
     N 35*0.,
C  LDGT3
     H 35*0.,
     C 35*0.,
     N 35*0./
C
        DATA DL06/
C  LDGT4
     H 35*0.,
     C 35*0.,
     N 35*0.,
C  HDGV2B
C      1969   1973   1974   1975   1976   1977   1978   1979
     H 0.229, 0.260, 0.172, 0.168, 0.159, 0.156, 0.151, 0.149,
C      1980   1981,  1982,  1983,  1984,  1985,  1986,  1987,
     H 0.148, 0.146, 0.145, 0.145, 0.133, 0.045, 0.045, 0.025,
C      1988,  1989,  1990,  1991,  1992,  1993,  1994,  1995,
     H 0.025, 0.025, 0.025, 0.023, 0.023, 0.023, 0.023, 0.023,
C      2007   2008   NEYR,  8*0
     H 0.023, 0.007, 0.005, 8*0.0,
     C 3.567, 4.700, 4.406, 4.312, 4.213, 4.123, 4.029, 3.951,
     C 3.962, 3.886, 3.862, 3.857, 3.509, 0.787, 0.782, 0.759,
     C 0.263, 0.264, 0.229, 0.275, 0.276, 0.277, 0.278, 0.278,
     C 0.279, 10*0.0,
C      1969   1973   1974   1975   1976   1977   1978   1979
     N 0.000, 0.000, 0.059, 0.056, 0.051, 0.049, 0.050, 0.053,
C      1980   1981   1982   1983   1984   1985   1986   1987
     N 0.046, 0.046, 0.045, 0.045, 0.041, 0.027, 0.027, 0.036,
C      1988   1989   1990   1991   1992   1993   1994   1995
     N 0.047, 0.047, 0.028, 0.041, 0.041, 0.041, 0.041, 0.041,
C      1997   2007   2008   NEYR   7*0000
     N 0.042, 0.042, 0.005, 0.002, 7*0.0/
C
        DATA DL08/
C  HDGV3
C      1969   1973   1974   1975   1976   1977   1978   1979
     H 0.323, 0.366, 0.247, 0.246, 0.238, 0.238, 0.235, 0.235,
C      1980   1981   1982   1983   1984   1985   1986   1987
     H 0.239, 0.238, 0.241, 0.241, 0.221, 0.075, 0.076, 0.026,
C      1988   1989   1990   1991   1992   1993   1994   1995
     H 0.026, 0.026, 0.026, 0.024, 0.024, 0.024, 0.024, 0.024,
C      2007   2008   NEYR   8*0
     H 0.024, 0.005, 0.004, 8*0.0,
     C 5.028, 6.624, 6.337, 6.325, 6.305, 6.281, 6.255, 6.239,
     C 6.372, 6.353, 6.429, 6.424, 5.840, 1.310, 1.301, 0.819,
     C 0.283, 0.283, 0.245, 0.293, 0.293, 0.293, 0.293, 0.293,
     C 0.293, 10*0.0,
C     1969   1973   1974   1975   1976   1977   1978   1979
     N 0.000, 0.000, 0.086, 0.082, 0.076, 0.075, 0.078, 0.083,
C      1980   1981   1982   1983   1984   1985   1986   1987
     N 0.075, 0.074, 0.075, 0.075, 0.069, 0.045, 0.045, 0.038,
C      1988   1989   1990   1991   1992   1993   1994   1995
     N 0.051, 0.051, 0.030, 0.044, 0.044, 0.044, 0.044, 0.044,
C      1997   2007   2008   NEYR   7*0000
     N 0.044, 0.044, 0.005, 0.002, 7*0.0,
C  HDGV4
C       1969  1973   1974   1975   1976   1977   1978   1979
     H 0.323, 0.366, 0.247, 0.246, 0.238, 0.238, 0.235, 0.235,
C      1980   1981   1982   1983   1984   1985   1986   1987
     H 0.239, 0.238, 0.241, 0.241, 0.221, 0.075, 0.076, 0.027,
C      1988   1989   1990   1991   1992   1993   1994   1995
     H 0.027, 0.027, 0.026, 0.024, 0.024, 0.024, 0.024, 0.024,
C      2007   2008   NEYR    8*0
     H 0.024, 0.005, 0.004,  8*0.0,
     C 5.028, 6.624, 6.337, 6.325, 6.305, 6.281, 6.255, 6.239,
     C 6.372, 6.353, 6.429, 6.424, 5.840, 1.310, 1.303, 0.828,
     C 0.285, 0.284, 0.245, 0.293, 0.292, 0.291, 0.291, 0.290,
     C 0.289, 10*0.0,
C      1969   1973   1974   1975   1976   1977   1978   1979
     N 0.000, 0.000, 0.086, 0.082, 0.076, 0.075, 0.078, 0.083,
C      1980   1981   1982   1983   1984   1985   1986   1987
     N 0.075, 0.074, 0.075, 0.075, 0.069, 0.045, 0.045, 0.039,
C      1988   1989   1990   1991   1992   1993   1994   1995
     N 0.051, 0.051, 0.030, 0.044, 0.044, 0.043, 0.043, 0.043,
C      1997   2007   2008   NEYR   7*0000
     N 0.043, 0.043, 0.005, 0.002, 7*0.0/
C
        DATA DL10/
C  HDGV5
C      1969   1973   1974   1975   1976   1977   1978   1979
     H 0.323, 0.366, 0.247, 0.246, 0.238, 0.238, 0.235, 0.235,
C      1980   1981   1982   1983   1984   1985   1986   1987
     H 0.239, 0.238, 0.241, 0.241, 0.221, 0.075, 0.075, 0.030,
C      1988   1989   1990   1991   1992   1993   1994   1995
     H 0.030, 0.030, 0.030, 0.027, 0.027, 0.028, 0.028, 0.028,
C      2007   2008   NEYR   8*0
     H 0.028, 0.006, 0.005, 8*0.0,
     C 5.028, 6.624, 6.337, 6.325, 6.305, 6.281, 6.255, 6.239,
     C 6.372, 6.353, 6.429, 6.419, 5.831, 1.307, 1.297, 0.918,
     C 0.318, 0.319, 0.277, 0.333, 0.334, 0.335, 0.336, 0.337,
     C 0.338, 10*0.0,
C      1969   1973   1974   1975   1976   1977   1978   1979
     N 0.000, 0.000, 0.086, 0.082, 0.076, 0.075, 0.078, 0.083,
C      1980   1981   1982   1983   1984   1985   1986   1987
     N 0.075, 0.074, 0.075, 0.075, 0.069, 0.045, 0.045, 0.043,
C      1988   1989   1990   1991   1992   1993   1994   1995
     N 0.057, 0.057, 0.034, 0.050, 0.050, 0.050, 0.050, 0.050,
C      1997   2007   2008   NEYR   7*0000
     N 0.050, 0.050, 0.006, 0.002, 7*0.0,
C  HDGV6
C      1969   1973   1974   1975   1976   1977   1978   1979
     H 0.361, 0.410, 0.282, 0.285, 0.275, 0.274, 0.268, 0.264,
C      1980   1981   1982   1983   1984   1985   1986   1987
     H 0.258, 0.252, 0.241, 0.239, 0.218, 0.074, 0.074, 0.030,
C      1988   1989   1990   1991   1992   1993   1994   1995
     H 0.030, 0.030, 0.030, 0.027, 0.027, 0.027, 0.027, 0.028,
C      2007   2008   NEYR   8*0
     H 0.028, 0.006, 0.005, 8*0.0,
     C 5.623, 7.407, 7.234, 7.307, 7.292, 7.226, 7.129, 7.009,
     C 6.889, 6.732, 6.443, 6.391, 5.771, 1.287, 1.273, 0.932,
     C 0.322, 0.322, 0.279, 0.334, 0.334, 0.334, 0.334, 0.334,
     C 0.334, 10*0.0,
C      1969   1973   1974   1975   1976   1977   1978   1979
     N 0.000, 0.000, 0.098, 0.095, 0.088, 0.087, 0.089, 0.093,
C      1980   1981   1982   1983   1984   1985   1986   1987
     N 0.081, 0.079, 0.075, 0.075, 0.068, 0.044, 0.044, 0.044,
C      1988   1989   1990   1991   1992   1993   1994   1995
     N 0.058, 0.058, 0.034, 0.050, 0.050, 0.050, 0.050, 0.050,
C      1997   2007   2008   NEYR   7*0000
     N 0.050, 0.050, 0.006, 0.002, 7*0.0/
C
        DATA DL12/
C  HDGV7
C      1969   1973   1974   1975   1976   1977   1978   1979
     H 0.454, 0.515, 0.346, 0.346, 0.333, 0.332, 0.320, 0.310,
C      1980   1981   1982   1983   1984   1985   1986   1987
     H 0.303, 0.304, 0.305, 0.303, 0.276, 0.093, 0.094, 0.032,
C      1988   1989   1990   1991   1992   1993   1994   1995
     H 0.032, 0.032, 0.032, 0.030, 0.030, 0.030, 0.030, 0.030,
C      2007   2008   NEYR   8*0000
     H 0.030, 0.006, 0.005, 8*0.0,
     C 7.061, 9.302, 8.882, 8.873, 8.834, 8.759, 8.514, 8.226,
     C 8.094, 8.113, 8.132, 8.075, 7.303, 1.630, 1.612, 0.983,
     C 0.342, 0.343, 0.299, 0.359, 0.361, 0.363, 0.365, 0.367,
     C 0.369, 10*0.0,
C      1969   1973   1974   1975   1976   1977   1978   1979
     N 0.000, 0.000, 0.120, 0.115, 0.106, 0.105, 0.107, 0.109,
C      1980   1981   1982   1983   1984   1985   1986   1987
     N 0.095, 0.095, 0.095, 0.095, 0.086, 0.056, 0.056, 0.046,
C      1988   1989   1990   1991   1992   1993   1994   1995
     N 0.061, 0.061, 0.036, 0.054, 0.054, 0.054, 0.054, 0.055,
C      1997   2007   2008   NEYR   7*0000
     N 0.055, 0.055, 0.006, 0.003, 7*0.0,
C  HDGV8A
C       1969  1973   1974   1975   1976   1977   1978   1979
     H 0.490, 0.556, 0.365, 0.355, 0.350, 0.328, 0.316, 0.309,
C      1980   1981   1982   1983   1984   1985   1986   1987
     H 0.308, 0.301, 0.298, 0.295, 0.270, 0.091, 0.091, 0.035,
C      1988   1989   1990   1991   1992   1993   1994   1995
     H 0.035, 0.035, 0.035, 0.032, 0.032, 0.032, 0.032, 0.032,
C      2007   2008   NEYR   8*0000
     H 0.032, 0.007, 0.006, 8*0.0,
     C 7.625, 10.046, 9.352, 9.113, 9.276, 8.646, 8.406, 8.207,
     C 8.213, 8.023, 7.942, 7.885, 7.126, 1.590, 1.572, 1.069,
     C 0.371, 0.371, 0.322, 0.387, 0.388, 0.389, 0.390, 0.391,
     C 0.393, 10*0.0,
C      1969   1973   1974   1975   1976   1977   1978   1979
     N 0.000, 0.000, 0.126, 0.118, 0.111, 0.104, 0.105, 0.109,
C      1980   1981   1982   1983   1984   1985   1986   1987
     N 0.096, 0.094, 0.093, 0.092, 0.084, 0.055, 0.055, 0.050,
C      1988   1989   1990   1991   1992   1993   1994   1995
     N 0.066, 0.066, 0.039, 0.058, 0.058, 0.058, 0.058, 0.058,
C      1997   2007   2008   NEYR   7*0000
     N 0.059, 0.059, 0.007, 0.003, 7*0.0/
C
        DATA DL14/
C  HDGV8B
C      1969   1973   1974   1975   1976   1977   1978   1979
     H 0.620, 0.703, 0.455, 0.438, 0.407, 0.410, 0.405, 0.407,
C      1980   1981   1982   1983   1984   1985   1986   1987
     H 0.408, 0.408, 0.408, 0.408, 0.375, 0.128, 0.129, 0.049,
C      1988   1989   1990   1991   1992   1993   1994   1995
     H 0.049, 0.049, 0.049, 0.045, 0.045, 0.045, 0.045, 0.045,
C      2007   2008   NEYR   8*0000
     H 0.046, 0.007, 0.006, 8*0.0,
     C  9.651, 12.714, 11.677, 11.238, 10.795, 10.795, 10.782, 
     C 10.786, 10.893, 10.893, 10.893, 10.893,  9.910,  2.227, 
     C  2.219,  1.508,  0.523,  0.524,  0.455,  0.546,  0.547, 
     C  0.549,  0.551,  0.552,  0.554, 10*0.0,
C      1969   1973   1974   1975   1976   1977   1978   1979
     N 0.000, 0.000, 0.158, 0.146, 0.130, 0.129, 0.135, 0.144,
C      1980   1981,  1982   1983   1984   1985   1986   1987
     N 0.128, 0.128, 0.128, 0.128, 0.117, 0.077, 0.077, 0.071,
C      1988   1989   1990   1991   1992   1993   1994   1995
     N 0.094, 0.094, 0.056, 0.081, 0.082, 0.082, 0.082, 0.082,
C      1997   2007   2008   NEYR   7*0000
     N 0.083, 0.083, 0.007, 0.003, 7*0.0,
C
C  LDDV
     H 35*0.,
     C 35*0.,
     N 35*0./
C
        DATA DL16/
C  LDDT12
     H 35*0.,
     C 35*0.,
     N 35*0.,
C  HDDV2B
     H 0.020, 0.020, 0.020, 0.020, 0.020, 0.020, 0.020,
     H 0.020, 0.020, 0.020, 0.020, 0.020, 0.020, 0.000,
     H 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
     H 0.000, 0.002, 0.002, 0.001, 0.001, 0.001, 0.001,
     H 0.001, 0.001, 0.001, 0.001, 3*0.0,
     C 0.046, 0.046, 0.046, 0.046, 0.046, 0.046, 0.046,
     C 0.046, 0.046, 0.046, 0.046, 0.046, 0.046, 0.038,
     C 0.038, 0.040, 0.036, 0.038, 0.038, 0.038, 0.038,
     C 0.037, 0.024, 0.024, 0.013, 0.004, 0.004, 0.004,
     C 0.003, 0.003, 0.003, 4*0.,
     N 0.056, 0.056, 0.056, 0.056, 0.056, 0.056, 0.056,
     N 0.056, 0.056, 0.056, 0.056, 0.056, 0.056, 0.000,
     N 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
     N 0.000, 0.002, 0.002, 0.012, 0.003, 0.003, 0.003,
     N 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.000/
C
        DATA DL18/
C  HDDV3
     H 0.045, 0.045, 0.045, 0.045, 0.045, 0.045, 0.045,
     H 0.045, 0.042, 0.039, 0.037, 0.037, 0.037, 0.000,
     H 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
     H 0.000, 0.003, 0.003, 0.001, 0.001, 0.001, 0.001,
     H 0.001, 0.001, 0.001, 0.001, 3*0.0,
     C 0.105, 0.105, 0.105, 0.105, 0.105, 0.105, 0.105,
     C 0.105, 0.098, 0.092, 0.086, 0.086, 0.086, 0.070,
     C 0.072, 0.074, 0.070, 0.073, 0.072, 0.072, 0.073,
     C 0.070, 0.028, 0.028, 0.015, 0.005, 0.005, 0.005,
     C 0.004, 0.004, 0.004, 4*0.,
     N 0.128, 0.128, 0.128, 0.128, 0.128, 0.128, 0.128,
     N 0.128, 0.119, 0.111, 0.104, 0.104, 0.104, 0.000,
     N 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
     N 0.000, 0.003, 0.003, 0.014, 0.004, 0.004, 0.004,
     N 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.000,
C  HDDV4
     H 0.045, 0.045, 0.045, 0.045, 0.045, 0.045, 0.045,
     H 0.045, 0.042, 0.039, 0.037, 0.037, 0.037, 0.000,
     H 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
     H 0.000, 0.003, 0.003, 0.001, 0.001, 0.001, 0.001,
     H 0.001, 0.001, 0.001, 0.001, 3*0.0,
     C 0.105, 0.105, 0.105, 0.105, 0.105, 0.105, 0.105,
     C 0.105, 0.098, 0.092, 0.086, 0.086, 0.086, 0.070,
     C 0.072, 0.074, 0.070, 0.073, 0.072, 0.072, 0.073,
     C 0.070, 0.033, 0.033, 0.018, 0.006, 0.006, 0.006,
     C 0.004, 0.004, 0.004, 4*0.,
     N 0.128, 0.128, 0.128, 0.128, 0.128, 0.128, 0.128,
     N 0.128, 0.119, 0.111, 0.104, 0.104, 0.104, 0.000,
     N 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
     N 0.000, 0.003, 0.003, 0.016, 0.004, 0.004, 0.004,
     N 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.000/
C
        DATA DL20/
C  HDDV5
     H 0.045, 0.045, 0.045, 0.045, 0.045, 0.045, 0.045,
     H 0.045, 0.042, 0.039, 0.037, 0.037, 0.037, 0.000,
     H 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
     H 0.000, 0.003, 0.003, 0.002, 0.002, 0.002, 0.002,
     H 0.002, 0.002, 0.002, 0.002, 3*0.0,
     C 0.105, 0.105, 0.105, 0.105, 0.105, 0.105, 0.105,
     C 0.105, 0.098, 0.092, 0.086, 0.086, 0.086, 0.070,
     C 0.072, 0.074, 0.070, 0.073, 0.072, 0.072, 0.073,
     C 0.070, 0.037, 0.037, 0.020, 0.007, 0.006, 0.006,
     C 0.005, 0.005, 0.005, 4*0.,
     N 0.128, 0.128, 0.128, 0.128, 0.128, 0.128, 0.128,
     N 0.128, 0.119, 0.111, 0.104, 0.104, 0.104, 0.000,
     N 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
     N 0.000, 0.003, 0.003, 0.018, 0.005, 0.005, 0.005,
     N 0.002, 0.002, 0.002, 0.002, 0.002, 0.002, 0.000,
C  HDDV6
     H 0.051, 0.051, 0.051, 0.052, 0.052, 0.053, 0.054,
     H 0.054, 0.053, 0.051, 0.049, 0.048, 0.046, 0.000,
     H 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
     H 0.000, 0.004, 0.004, 0.002, 0.002, 0.002, 0.002,
     H 0.002, 0.002, 0.002, 0.002, 3*0.0,
     C 0.119, 0.119, 0.119, 0.122, 0.122, 0.124, 0.127,
     C 0.127, 0.124, 0.119, 0.114, 0.112, 0.108, 0.085,
     C 0.084, 0.084, 0.076, 0.079, 0.077, 0.076, 0.077,
     C 0.075, 0.036, 0.036, 0.014, 0.020, 0.020, 0.020,
     C 0.018, 0.018, 0.018, 4*0.,
     N 0.145, 0.145, 0.145, 0.148, 0.148, 0.151, 0.154,
     N 0.154, 0.151, 0.144, 0.139, 0.136, 0.131, 0.000,
     N 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
     N 0.000, 0.018, 0.018, 0.012, 0.014, 0.014, 0.014,
     N 0.002, 0.002, 0.002, 0.002, 0.002, 0.002, 0.000/
C
        DATA DL22/
C  HDDV7
     H 0.054, 0.055, 0.055, 0.055, 0.056, 0.056, 0.056,
     H 0.058, 0.058, 0.058, 0.058, 0.057, 0.055, 0.000,
     H 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
     H 0.000, 0.005, 0.005, 0.002, 0.002, 0.002, 0.002,
     H 0.002, 0.002, 0.002, 0.002, 3*0.0,
     C 0.126, 0.129, 0.129, 0.129, 0.132, 0.132, 0.132,
     C 0.134, 0.135, 0.135, 0.134, 0.134, 0.127, 0.096,
     C 0.091, 0.094, 0.087, 0.090, 0.088, 0.087, 0.088,
     C 0.085, 0.043, 0.043, 0.017, 0.024, 0.024, 0.024,
     C 0.022, 0.022, 0.022, 4*0.,
     N 0.153, 0.156, 0.156, 0.156, 0.160, 0.160, 0.160,
     N 0.163, 0.164, 0.164, 0.163, 0.163, 0.155, 0.000,
     N 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
     N 0.000, 0.022, 0.022, 0.014, 0.017, 0.017, 0.017,
     N 0.002, 0.002, 0.002, 0.002, 0.002, 0.002, 0.000,
C  HDDV8A
     H 0.059, 0.061, 0.061, 0.062, 0.062, 0.063, 0.063,
     H 0.063, 0.065, 0.065, 0.066, 0.066, 0.065, 0.000,
     H 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
     H 0.000, 0.003, 0.003, 0.000, 0.000, 0.000, 0.000,
     H 0.003, 0.003, 0.003, 0.003, 3*0.0,
     C 0.139, 0.141, 0.141, 0.144, 0.144, 0.148, 0.148,
     C 0.148, 0.151, 0.151, 0.154, 0.155, 0.152, 0.123,
     C 0.124, 0.131, 0.122, 0.127, 0.124, 0.123, 0.124,
     C 0.119, 0.236, 0.023, 0.014, 0.009, 0.009, 0.008,
     C 0.011, 0.011, 0.011, 4*0.,
     N 0.168, 0.172, 0.172, 0.175, 0.175, 0.179, 0.179,
     N 0.179, 0.184, 0.183, 0.187, 0.188, 0.185, 0.000,
     N 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
     N 0.000, 0.029, 0.029, 0.012, 0.011, 0.011, 0.011,
     N 0.008, 0.008, 0.008, 0.008, 0.008, 0.006, 0.000/
        DATA DL24/
C  HDDV8B
     H 0.064, 0.066, 0.066, 0.067, 0.067, 0.068, 0.068,
     H 0.068, 0.069, 0.069, 0.070, 0.071, 0.070, 0.000,
     H 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
     H 0.000, 0.003, 0.003, 0.000, 0.000, 0.000, 0.000,
     H 0.003, 0.003, 0.003, 0.003, 3*0.0,
     C 0.150, 0.153, 0.153, 0.156, 0.156, 0.160, 0.160,
     C 0.160, 0.162, 0.161, 0.163, 0.166, 0.164, 0.132,
     C 0.135, 0.137, 0.124, 0.131, 0.128, 0.128, 0.130,
     C 0.132, 0.261, 0.026, 0.016, 0.010, 0.009, 0.009,
     C 0.012, 0.012, 0.012, 4*0.,
     N 0.182, 0.186, 0.186, 0.190, 0.190, 0.194, 0.194,
     N 0.194, 0.197, 0.195, 0.198, 0.201, 0.199, 0.000,
     N 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
     N 0.000, 0.033, 0.032, 0.013, 0.013, 0.013, 0.012,
     N 0.009, 0.009, 0.009, 0.009, 0.009, 0.006, 0.000,
C  MC 
     H 35*0.,
     C 35*0.,
     N 35*0./
C
        DATA DL26/
C  HDGB (GASOLINE BUS) 
C      1966   1967   1968   1969   1970   1971
     H 0.296, 0.294, 0.297, 0.295, 0.337, 0.337,
C      1972   1973   1974   1975   1976   1977
     H 0.320, 0.320, 0.216, 0.218, 0.210, 0.211,
C      1978   1979   1980   1981   1982   1983
     H 0.209, 0.210, 0.204, 0.205, 0.206, 0.206,
C      1984   1985   1986   1987   1988   1989
     H 0.190, 0.065, 0.065, 0.037, 0.037, 0.038,
C      1990   1991   1992   1993   1994   1995
     H 0.038, 0.035, 0.035, 0.035, 0.035, 0.035,
C      2007   2008   NEYR   2*0000
     H 0.038, 0.008, 0.006, 2*0.0,
     C 4.614, 4.612, 4.627, 4.617, 6.086, 6.086, 
     C 5.777, 5.787, 5.552, 5.596, 5.571, 5.571, 
     C 5.560, 5.567, 5.442, 5.480, 5.508, 5.508, 
     C 5.011, 1.126, 1.122, 1.153, 0.400, 0.402, 
     C 0.349, 0.419, 0.421, 0.423, 0.424, 0.426,
     C 0.458, 0.458, 3*0.0,
C      1966   1967   1968   1969   1970   1971
     N 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
C      1972   1973   1974   1975   1976   1977
     N 0.000, 0.000, 0.075, 0.073, 0.067, 0.067,
C      1978   1979   1980   1981   1982   1983
     N 0.070, 0.074, 0.064, 0.064, 0.065, 0.065,
C      1984   1985   1986   1987   1988   1989
     N 0.059, 0.039, 0.039, 0.054, 0.072, 0.072,
C      1990   1991   1992   1993   1994   1995
     N 0.043, 0.063, 0.063, 0.063, 0.063, 0.063,
C      1997   2007   2008   NEYR   0000
     N 0.068, 0.068, 0.008, 0.003, 0.0,
C  HDDBT (DIESEL TRANSIT BUS)
C      1966    1967   1968   1969   1970   1971
     H 0.059, 0.059, 0.062, 0.063, 0.063, 0.063,
C      1972   1973   1974   1975   1976   1977
     H 0.063, 0.063, 0.063, 0.063, 0.063, 0.059,
C      1978   1979   1980   1981   1982   1983
     H 0.060, 0.000, 0.000, 0.000, 0.000, 0.000,
C      1984   1985   1986   1987   1988   1989
     H 0.000, 0.000, 0.000, 0.000, 0.004, 0.004,
C      1990   1991   1992   1993   1994   1995
     H 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
C      2006  NEYR,3*0000
     H 0.000, 4*0.0,
C      1966   1967   1968   1969   1970   1971
     C 0.139, 0.139, 0.144, 0.147, 0.146, 0.146,
C      1972   1973   1974   1975   1976   1977
     C 0.146, 0.146, 0.146, 0.146, 0.146, 0.138,
C      1978   1979   1980   1981   1982   1983
     C 0.140, 0.115, 0.118, 0.126, 0.121, 0.127,
C      1984   1985   1986   1987   1988   1989
     C 0.125, 0.125, 0.127, 0.127, 0.004, 0.004,
C      1990   1991   1992   1993   1994   1995
     C 0.020, 0.000, 0.000, 0.000, 0.000, 0.000,
C      2006  NEYR,3*0000
     C 0.000, 4*0.0,
C      1966   1967   1968   1969   1970   1971
     N 0.168, 0.168, 0.175, 0.179, 0.177, 0.177,
C      1972   1973   1974   1975   1976   1977
     N 0.177, 0.177, 0.177, 0.177, 0.177, 0.168,
C      1978   1979   1980   1981   1982   1983
     N 0.170, 0.000, 0.000, 0.000, 0.000, 0.000,
C      1984   1985   1986   1987   1988   1989
     N 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
C      1990   1991   1992   1993   1994   1995
     N 0.016, 0.000, 0.000, 0.000, 0.000, 0.000,
C      1997   2003   2006   2009   NEYR
     N 0.000, 0.000, 0.000, 0.008, 0.000/
C
        DATA DL28/
C  HDDBS (DIESEL SCHOOL BUS) 
     H 0.035, 0.035, 0.035, 0.035, 0.035, 0.035,
     H 0.035, 0.035, 0.035, 0.035, 0.035, 0.035,
     H 0.035, 0.000, 0.000, 0.000, 0.000, 0.000,
     H 0.000, 0.000, 0.000, 0.000, 0.005, 0.005,
     H 0.003, 0.003, 0.003, 0.003, 0.003, 0.003,
     H 0.003, 0.003, 3*0.0,
     C 0.081, 0.081, 0.081, 0.081, 0.081, 0.081,
     C 0.081, 0.081, 0.081, 0.081, 0.081, 0.081,
     C 0.081, 0.066, 0.065, 0.068, 0.064, 0.067,
     C 0.066, 0.066, 0.067, 0.067, 0.048, 0.048,
     C 0.019, 0.027, 0.028, 0.028, 0.026, 0.026,
     C 0.027, 4*0.0,
     N 0.098, 0.098, 0.098, 0.098, 0.098, 0.098,
     N 0.098, 0.098, 0.098, 0.098, 0.098, 0.098,
     N 0.098, 0.000, 0.000, 0.000, 0.000, 0.000,
     N 0.000, 0.000, 0.000, 0.000, 0.024, 0.024,
     N 0.016, 0.019, 0.019, 0.020, 0.003, 0.003,
     N 0.003, 0.003, 0.003, 0.003, 0.0,
C  LDDT34
     H 35*0.,
     C 35*0.,
     N 35*0./
C  High altitude region
C
        DATA DH02/
C  LDGV                                      
     H 35*0.,
     C 35*0.,
     N 35*0.,
C  LDGT1
     H 35*0.,
     C 35*0.,
     N 35*0./
C
      DATA DH04/
C  LDGT2
     H 35*0.,
     C 35*0.,
     N 35*0.,
C  LDGT3
     H 35*0.,
     C 35*0.,
     N 35*0./
C
       DATA DH06/
C  LDGT4
     H 35*0.,
     C 35*0.,
     N 35*0.,
C  HDGV2B
C      1969   1973   1974   1975   1976   1977   1978   1979
     H 0.312, 0.354, 0.234, 0.229, 0.217, 0.213, 0.206, 0.203,
C      1980   1981   1982   1983   1984   1985   1986   1987
     H 0.202, 0.198, 0.197, 0.197, 0.181, 0.061, 0.062, 0.046,
C      1988   1989   1990   1991   1992   1993   1994   1995
     H 0.046, 0.046, 0.046, 0.042, 0.042, 0.042, 0.042, 0.043,
C      2007   2008   NEYR   8*0000
     H 0.043, 0.013, 0.009, 8*0.0,
     C 6.396, 8.427, 7.900, 7.731, 7.553, 7.393, 7.224, 7.084,
     C 7.103, 6.967, 6.925, 6.916, 6.292, 1.410, 1.402, 2.417,
     C 0.838, 0.840, 0.729, 0.876, 0.878, 0.880, 0.884, 0.886,
     C 0.889, 10*0.0,
C      1969   1973   1974   1975   1976   1977   1978   1979
     N 0.000, 0.000, 0.040, 0.037, 0.034, 0.033, 0.034, 0.035,
C      1980   1981   1982   1983   1984   1985   1986   1987
     N 0.031, 0.030, 0.030, 0.030, 0.028, 0.018, 0.018, 0.029,
C      1988   1989   1990   1991   1992   1993   1994   1995
     N 0.039, 0.039, 0.023, 0.034, 0.034, 0.034, 0.034, 0.034,
C      1997   2007   2008   NEYR   7*0000
     N 0.034, 0.034, 0.004, 0.002, 7*0.0/
C
        DATA DH08/
C  HDGV3
C      1969   1973   1974   1975   1976   1977   1978   1979
     H 0.440, 0.499, 0.337, 0.336, 0.324, 0.325, 0.320, 0.321,
C      1980   1981   1982   1983   1984   1985   1986   1987
     H 0.325, 0.324, 0.328, 0.328, 0.301, 0.102, 0.103, 0.049,
C      1988   1989   1990   1991   1992   1993   1994   1995
     H 0.049, 0.049, 0.049, 0.045, 0.045, 0.045, 0.045, 0.045,
C      2007   2008   NEYR   8*0000
     H 0.045, 0.009, 0.007, 8*0.0,
     C 9.015, 11.877, 11.361, 11.340, 11.305, 11.262, 11.216,
     C 11.186, 11.425, 11.391, 11.527, 11.518, 10.471, 2.348,
     C 2.332, 2.607, 0.901, 0.900, 0.779, 0.932, 0.932, 0.932,
     C 0.932, 0.932, 0.932, 10*0.0,
C      1969   1973   1974   1975   1976   1977   1978   1979
     N 0.000, 0.000, 0.057, 0.055, 0.050, 0.050, 0.052, 0.055,
C      1980   1981   1982   1983   1984   1985   1986   1987
     N 0.050, 0.050, 0.050, 0.050, 0.046, 0.030, 0.030, 0.031,
C      1988   1989   1990   1991   1992   1993   1994   1995
     N 0.041, 0.041, 0.024, 0.036, 0.036, 0.036, 0.036, 0.036,
C      1997   2007   2008   NEYR   7*0000
     N 0.036, 0.036, 0.004, 0.002, 7*0.0,
C  HDGV4
C      1969   1973   1974   1975   1976   1977   1978   1979
     H 0.440, 0.499, 0.337, 0.336, 0.324, 0.325, 0.320, 0.321, 
C      1980   1981   1982   1983   1984   1985   1986   1987
     H 0.325, 0.324, 0.328, 0.328, 0.301, 0.102, 0.103, 0.049,
C      1988   1989   1990   1991   1992   1993   1994   1995
     H 0.049, 0.049, 0.049, 0.045, 0.045, 0.045, 0.044, 0.044,
C      2007   2008   NEYR   8*0000
     H 0.044, 0.009, 0.008, 8*0.0,
     C  9.015, 11.877, 11.361, 11.340, 11.305, 11.262, 11.216,
     C 11.186, 11.425, 11.391, 11.527, 11.518, 10.471, 2.350,
     C  2.335,  2.634,  0.908,  0.905,  0.781,  0.932, 0.930, 
     C  0.927,  0.925,  0.923,  0.920, 10*0.0,
C      1969   1973   1974   1975   1976   1977   1978   1979
     N 0.000, 0.000, 0.057, 0.055, 0.050, 0.050, 0.052, 0.055,
C      1980   1981   1982   1983   1984   1985   1986   1987
     N 0.050, 0.050, 0.050, 0.050, 0.046, 0.030, 0.030, 0.032,
C      1988   1989   1990   1991   1992   1993   1994   1995
     N 0.042, 0.042, 0.025, 0.036, 0.036, 0.036, 0.035, 0.035,
C      1997   2007   2008   NEYR   7*0000
     N 0.035, 0.035, 0.004, 0.002, 7*0.0/
C
        DATA DH10/
C  HDGV5
C       1969  1973   1974   1975   1976   1977   1978   1979
     H 0.440, 0.499, 0.337, 0.336, 0.324, 0.325, 0.320, 0.321,
C      1980   1981   1982   1983   1984   1985   1986   1987
     H 0.325, 0.324, 0.328, 0.328, 0.301, 0.102, 0.103, 0.055,
C      1988   1989   1990   1991   1992   1993   1994   1995
     H 0.055, 0.055, 0.056, 0.051, 0.051, 0.051, 0.051, 0.051,
C      2007   2008   NEYR   8*0000
     H 0.052, 0.010, 0.008, 8*0.0,
     C  9.015, 11.877, 11.361, 11.340, 11.305, 11.262, 11.216,
     C 11.186, 11.425, 11.391, 11.527, 11.510, 10.456,  2.343,
     C  2.325,  2.921,  1.013,  1.015,  0.882,  1.059,  1.061, 
     C  1.065,  1.068,  1.071,  1.074,  10*0.0,
C      1969   1973   1974   1975   1976   1977   1978   1979
     N 0.000, 0.000, 0.057, 0.055, 0.050, 0.050, 0.052, 0.055,
C      1980   1981   1982   1983   1984   1985   1986   1987
     N 0.050, 0.050, 0.050, 0.050, 0.046, 0.030, 0.030, 0.035,
C      1988   1989   1990   1991   1992   1993   1994   1995
     N 0.047, 0.047, 0.028, 0.041, 0.041, 0.041, 0.041, 0.041,
C      1997   2007   2008   NEYR   7*0000
     N 0.041, 0.041, 0.005, 0.002, 7*0.0,
C  HDGV6
C      1969   1973   1974   1975   1976   1977   1978   1979
     H 0.492, 0.559, 0.384, 0.388, 0.375, 0.374, 0.365, 0.360,
C      1980   1981   1982   1983   1984   1985   1986   1987
     H 0.352, 0.344, 0.329, 0.326, 0.298, 0.100, 0.101, 0.056,
C      1988   1989   1990   1991   1992   1993   1994   1995
     H 0.056, 0.056, 0.056, 0.051, 0.051, 0.051, 0.051, 0.051,
C      2007   2008   NEYR   8*0000
     H 0.051, 0.010, 0.008, 8*0.0,
     C 10.081, 13.281, 12.970, 13.102, 13.075, 12.957, 12.782,
     C 12.568, 12.352, 12.071, 11.552, 11.459, 10.347,  2.308,
     C  2.282,  2.966,  1.025,  1.025,  0.887,  1.062,  1.062, 
     C  1.062,  1.062,  1.063, 1.064, 10*0.0,
C      1969   1973   1974   1975   1976   1977   1978   1979
     N 0.000, 0.000, 0.065, 0.063, 0.058, 0.058, 0.059, 0.062,
C      1980   1981   1982   1983   1984   1985   1986   1987
     N 0.054, 0.053, 0.050, 0.050, 0.045, 0.029, 0.030, 0.036,
C      1988   1989   1990   1991   1992   1993   1994   1995
     N 0.047, 0.047, 0.028, 0.041, 0.041, 0.041, 0.041, 0.041,
C      1997   2007   2008   NEYR   7*0000
     N 0.041, 0.041, 0.005, 0.002, 7*0.0/
C
        DATA DH12/
C  HDGV7
C      1969   1973   1974   1975   1976   1977   1978   1979
     H 0.618, 0.701, 0.472, 0.471, 0.454, 0.453, 0.436, 0.423,
C      1980   1981   1982   1983   1984   1985   1986   1987
     H 0.413, 0.414, 0.415, 0.412, 0.377, 0.127, 0.128, 0.059,
C      1988   1989   1990   1991   1992   1993   1994   1995
     H 0.059, 0.060, 0.060, 0.055, 0.055, 0.055, 0.056, 0.056,
C      2007   2008   NEYR   8*0000
     H 0.056, 0.011, 0.009, 8*0.0,
     C 12.660, 16.679, 15.926, 15.910, 15.840, 15.705, 15.266,
     C 14.749, 14.513, 14.547, 14.581, 14.479, 13.095, 2.922,
     C  2.890,  3.129,  1.087,  1.092,  0.950,  1.143, 1.149, 
     C  1.155,  1.160,  1.167,  1.173, 10*0.0,
C      1969   1973   1974   1975   1976   1977   1978   1979
     N 0.000, 0.000, 0.080, 0.077, 0.071, 0.070, 0.071, 0.073,
C      1980   1981   1982   1983   1984   1985   1986   1987
     N 0.063, 0.063, 0.063, 0.063, 0.057, 0.037, 0.037, 0.038,
C      1988   1989   1990   1991   1992   1993   1994   1995
     N 0.050, 0.050, 0.030, 0.044, 0.044, 0.044, 0.044, 0.045,
C      1997   2007   2008   NEYR   7*0000
     N 0.045, 0.045, 0.005, 0.002, 7*0.0,
C  HDGV8A
C       1969  1973   1974   1975   1976   1977   1978   1979
     H 0.668, 0.757, 0.497, 0.484, 0.477, 0.447, 0.431, 0.422,
C       1980  1981   1982   1983   1984   1985   1986   1987
     H 0.419, 0.410, 0.406, 0.403, 0.367, 0.124, 0.125, 0.064,
C      1988   1989   1990   1991   1992   1993   1994   1995
     H 0.064, 0.064, 0.065, 0.059, 0.059, 0.059, 0.060, 0.060,
C      2007   2008   NEYR   8*0000
     H 0.060, 0.012, 0.010, 8*0.0,
     C 13.673, 18.013, 16.768, 16.340, 16.632, 15.503, 15.072,
     C 14.716, 14.725, 14.385, 14.240, 14.138, 12.777, 2.851,
     C  2.819,  3.401,  1.180,  1.182,  1.025,  1.231, 1.234, 
     C  1.238,  1.241,  1.246,  1.250, 10*0.0,
C      1969   1973   1974   1975   1976   1977   1978   1979
     N 0.000, 0.000, 0.084, 0.079, 0.074, 0.069, 0.070, 0.073,
C      1980   1981   1982   1983   1984   1985   1986   1987
     N 0.064, 0.063, 0.062, 0.061, 0.056, 0.036, 0.037, 0.041,
C      1988   1989   1990   1991   1992   1993   1994   1995
     N 0.054, 0.054, 0.032, 0.047, 0.047, 0.047, 0.048, 0.048,
C      1997   2007   2008   NEYR   7*0000
     N 0.048, 0.048, 0.006, 0.002, 7*0.0/
C
        DATA DH14/
C  HDGV8B
C      1969   1973   1974   1975   1976   1977   1978   1979
     H 0.845, 0.959, 0.620, 0.597, 0.555, 0.558, 0.552, 0.554,
C      1980   1981   1982   1983   1984   1985   1986   1987
     H 0.556, 0.556, 0.556, 0.556, 0.511, 0.174, 0.176, 0.091,
C      1988   1989   1990   1991   1992   1993   1994   1995
     H 0.091, 0.091, 0.091, 0.083, 0.084, 0.084, 0.084, 0.084,
C      2007   2008   NEYR    8*0000
     H 0.085, 0.012, 0.010,  8*0.0,
     C 17.304, 22.797, 20.937, 20.151, 19.355, 19.355, 19.332,
     C 19.340, 19.532, 19.532, 19.532, 19.532, 17.769, 3.993,
     C 3.978,   4.799,  1.665,  1.668,  1.447,  1.737, 1.742, 
     C 1.747,   1.752,  1.758,  1.763, 10*0.0,
C      1969   1973   1974   1975   1976   1977   1978   1979
     N 0.000, 0.000, 0.105, 0.097, 0.086, 0.086, 0.090, 0.096,
C      1980   1981   1982   1983   1984   1985   1986   1987
     N 0.085, 0.085, 0.085, 0.085, 0.078, 0.051, 0.052, 0.058,
C      1988   1989   1990   1991   1992   1993   1994   1995
     N 0.077, 0.077, 0.045, 0.067, 0.067, 0.067, 0.067, 0.067,
C      1997   2007   2008   NEYR   7*0000
     N 0.068, 0.068, 0.006, 0.002, 7*0.0,
C
C  LDDV
     H 35*0.,
     C 35*0.,
     N 35*0./
C
        DATA DH16/
C  LDDT12
     H 35*0.,
     C 35*0.,
     N 35*0.,
C  HDDV2B
     H 0.040, 0.040, 0.040, 0.040, 0.040, 0.040, 0.040,
     H 0.040, 0.040, 0.040, 0.040, 0.040, 0.040, 0.000,
     H 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
     H 0.000, 0.005, 0.005, 0.002, 0.002, 0.002, 0.002,
     H 0.002, 0.002, 0.002, 4*0.,
     C 0.113, 0.113, 0.113, 0.113, 0.113, 0.113, 0.113,
     C 0.113, 0.113, 0.113, 0.113, 0.113, 0.113, 0.093,
     C 0.094, 0.097, 0.090, 0.094, 0.093, 0.092, 0.094,
     C 0.090, 0.060, 0.060, 0.032, 0.011, 0.011, 0.011,
     C 0.008, 0.008, 0.008, 4*0.,
     N 0.057, 0.057, 0.057, 0.057, 0.057, 0.057, 0.057,
     N 0.057, 0.057, 0.057, 0.057, 0.057, 0.057, 0.000,
     N 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
     N 0.000, 0.002, 0.002, 0.012, 0.003, 0.003, 0.003,
     N 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.0/
C
        DATA DH18/
C  HDDV3
     H 0.092, 0.092, 0.092, 0.092, 0.092, 0.092, 0.092,
     H 0.092, 0.086, 0.080, 0.075, 0.075, 0.075, 0.000,
     H 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
     H 0.000, 0.005, 0.005, 0.003, 0.003, 0.003, 0.003,
     H 0.003, 0.003, 0.003, 4*0.,
     C 0.259, 0.259, 0.259, 0.259, 0.259, 0.259, 0.259,
     C 0.259, 0.241, 0.225, 0.211, 0.211, 0.211, 0.173,
     C 0.176, 0.182, 0.171, 0.180, 0.177, 0.177, 0.180,
     C 0.173, 0.068, 0.068, 0.037, 0.012, 0.012, 0.012,
     C 0.009, 0.009, 0.009, 4*0.,
     N 0.130, 0.130, 0.130, 0.130, 0.130, 0.130, 0.130,
     N 0.130, 0.121, 0.113, 0.106, 0.106, 0.106, 0.000,
     N 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
     N 0.000, 0.003, 0.003, 0.014, 0.004, 0.004, 0.004, 
     N 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.0,
C  HDDV4
     H 0.092, 0.092, 0.092, 0.092, 0.092, 0.092, 0.092,
     H 0.092, 0.086, 0.080, 0.075, 0.075, 0.075, 0.000,
     H 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
     H 0.000, 0.006, 0.006, 0.003, 0.003, 0.003, 0.003,
     H 0.003, 0.003, 0.003, 4*0.,
     C 0.259, 0.259, 0.259, 0.259, 0.259, 0.259, 0.259,
     C 0.259, 0.241, 0.225, 0.211, 0.211, 0.211, 0.173,
     C 0.176, 0.182, 0.171, 0.180, 0.177, 0.177, 0.180,
     C 0.173, 0.081, 0.081, 0.044, 0.015, 0.015, 0.014,
     C 0.011, 0.011, 0.011, 4*0.,
     N 0.130, 0.130, 0.130, 0.130, 0.130, 0.130, 0.130,
     N 0.130, 0.121, 0.113, 0.106, 0.106, 0.106, 0.000,
     N 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
     N 0.000, 0.003, 0.003, 0.017, 0.005, 0.005, 0.005,
     N 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.0/
C
        DATA DH20/
C  HDDV5
     H 0.092, 0.092, 0.092, 0.092, 0.092, 0.092, 0.092,
     H 0.092, 0.086, 0.080, 0.075, 0.075, 0.075, 0.000,
     H 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
     H 0.000, 0.007, 0.007, 0.003, 0.003, 0.003, 0.003,
     H 0.003, 0.003, 0.003, 4*0.,
     C 0.259, 0.259, 0.259, 0.259, 0.259, 0.259, 0.259,
     C 0.259, 0.241, 0.225, 0.211, 0.211, 0.211, 0.173,
     C 0.176, 0.182, 0.171, 0.180, 0.177, 0.177, 0.180,
     C 0.173, 0.091, 0.090, 0.049, 0.016, 0.016, 0.016,
     C 0.012, 0.012, 0.012, 4*0.,
     N 0.130, 0.130, 0.130, 0.130, 0.130, 0.130, 0.130,
     N 0.130, 0.121, 0.113, 0.106, 0.106, 0.106, 0.000,
     N 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
     N 0.000, 0.003, 0.003, 0.019, 0.005, 0.005, 0.005,
     N 0.002, 0.002, 0.002, 0.002, 0.002, 0.002, 0.0,
C  HDDV6
     H 0.105, 0.105, 0.105, 0.107, 0.107, 0.109, 0.112,
     H 0.112, 0.109, 0.105, 0.100, 0.099, 0.095, 0.000,
     H 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
     H 0.000, 0.008, 0.008, 0.004, 0.004, 0.004, 0.004,
     H 0.004, 0.004, 0.004, 4*0.,
     C 0.294, 0.294, 0.294, 0.300, 0.300, 0.306, 0.313,
     C 0.313, 0.306, 0.293, 0.281, 0.276, 0.266, 0.210,
     C 0.206, 0.206, 0.187, 0.195, 0.190, 0.188, 0.190,
     C 0.184, 0.088, 0.087, 0.034, 0.048, 0.048, 0.048,
     C 0.043, 0.043, 0.043, 4*0.,
     N 0.148, 0.148, 0.148, 0.151, 0.151, 0.154, 0.157,
     N 0.157, 0.154, 0.147, 0.141, 0.139, 0.134, 0.000,
     N 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
     N 0.000, 0.018, 0.018, 0.012, 0.014, 0.014, 0.014,
     N 0.002, 0.002, 0.002, 0.002, 0.002, 0.002, 0.0/
C
        DATA DH22/
C  HDDV7
     H 0.111, 0.113, 0.113, 0.113, 0.116, 0.116, 0.116,
     H 0.118, 0.119, 0.119, 0.118, 0.118, 0.112, 0.000, 
     H 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 
     H 0.000, 0.010, 0.010, 0.005, 0.005, 0.005, 0.005, 
     H 0.005, 0.005, 0.005, 4*0.0,
     C 0.310, 0.317, 0.317, 0.317, 0.324, 0.324, 0.324,
     C 0.331, 0.333, 0.333, 0.331, 0.330, 0.313, 0.237,
     C 0.225, 0.230, 0.213, 0.222, 0.217, 0.215, 0.217,
     C 0.209, 0.106, 0.106, 0.041, 0.059, 0.059, 0.059,
     C 0.053, 0.053, 0.053, 4*0.,
     N 0.156, 0.160, 0.160, 0.160, 0.163, 0.163, 0.163,
     N 0.167, 0.167, 0.168, 0.167, 0.166, 0.158, 0.000,
     N 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
     N 0.000, 0.022, 0.022, 0.015, 0.017, 0.017, 0.017,
     N 0.002, 0.002, 0.002, 0.002, 0.002, 0.002, 0.0,
C  HDDV8A
     H 0.122, 0.124, 0.124, 0.127, 0.127, 0.130, 0.130,
     H 0.130, 0.133, 0.133, 0.135, 0.136, 0.134, 0.000,
     H 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
     H 0.000, 0.006, 0.006, 0.000, 0.000, 0.000, 0.000,
     H 0.006, 0.006, 0.006, 4*0.,
     C 0.341, 0.348, 0.348, 0.355, 0.355, 0.363, 0.363,
     C 0.363, 0.372, 0.371, 0.378, 0.381, 0.375, 0.304,
     C 0.306, 0.321, 0.300, 0.312, 0.305, 0.302, 0.305,
     C 0.293, 0.580, 0.058, 0.036, 0.021, 0.021, 0.021,
     C 0.028, 0.027, 0.027, 4*0.,
     N 0.172, 0.175, 0.175, 0.179, 0.179, 0.183, 0.183,
     N 0.183, 0.187, 0.187, 0.190, 0.192, 0.189, 0.000,
     N 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
     N 0.000, 0.030, 0.030, 0.012, 0.012, 0.012, 0.012, 
     N 0.009, 0.009, 0.008, 0.008, 0.008, 0.006, 0.0/
C
        DATA DH24/
C  HDDV8B
     H 0.132, 0.134, 0.134, 0.137, 0.137, 0.140,
     H 0.140, 0.140, 0.142, 0.141, 0.144, 0.146,
     H 0.144, 0.000, 0.000, 0.000, 0.000, 0.000,
     H 0.000, 0.000, 0.000, 0.000, 0.007, 0.007,
     H 0.000, 0.000, 0.000, 0.000, 0.006, 0.006,
     H 0.006, 4*0.0,
     C 0.368, 0.376, 0.376, 0.384, 0.384, 0.392,
     C 0.392, 0.392, 0.399, 0.395, 0.402, 0.408,
     C 0.403, 0.325, 0.333, 0.336, 0.306, 0.322,
     C 0.316, 0.314, 0.319, 0.325, 0.642, 0.064,
     C 0.039, 0.023, 0.023, 0.023, 0.030, 0.030,
     C 0.030, 4*0.0,
     N 0.185, 0.189, 0.189, 0.193, 0.193, 0.198, 
     N 0.198, 0.198, 0.201, 0.199, 0.202, 0.205, 
     N 0.203, 0.000, 0.000, 0.000, 0.000, 0.000, 
     N 0.000, 0.000, 0.000, 0.000, 0.033, 0.033, 
     N 0.013, 0.013, 0.013, 0.013, 0.009, 0.009, 
     N 0.009, 0.009, 0.009, 0.006, 0.0,
C  MC 
     H 35*0.,
     C 35*0.,
     N 35*0./
C
        DATA DH26/
C  HDGB (GASOLINE BUS)
C      1966   1967   1968   1969   1970   1971
     H 0.404, 0.401, 0.405, 0.402, 0.459, 0.459,
C      1972   1973   1974   1975   1976   1977
     H 0.436, 0.436, 0.295, 0.297, 0.287, 0.288, 
C      1978   1979   1980   1981   1982   1983
     H 0.285, 0.286, 0.278, 0.280, 0.281, 0.281, 
C      1984   1985   1986   1987   1988   1989
     H 0.258, 0.088, 0.089, 0.069, 0.069, 0.070, 
C      1990   1991   1992   1993   1994   1995
     H 0.070, 0.064, 0.064, 0.065, 0.065, 0.065,
C      2007   2008   NEYR   2*0000
     H 0.070, 0.014, 0.012, 2*0.0,
     C  8.274,  8.269, 8.295,  8.277, 10.911, 10.911, 
     C 10.358, 10.376, 9.955, 10.033,  9.990,  9.990, 
     C  9.969,  9.982, 9.757,  9.825,  9.876,  9.876, 
     C  8.985,  2.019, 2.012,  3.670,  1.274,  1.278, 
     C  1.111,  1.335, 1.340,  1.345,  1.350,  1.356,
     C  1.457,  1.457, 3*0.0,
C       1966    1967   1968    1969    1970    1971
     N  0.000,  0.000, 0.000,  0.000,  0.000,  0.000, 
C       1972    1973   1974    1975    1976    1977
     N  0.000,  0.000, 0.050,  0.048,  0.045,  0.044, 
C       1978    1979   1980    1981    1982    1983
     N  0.046,  0.049, 0.042,  0.043,  0.043,  0.043, 
C       1984    1985   1986    1987    1988    1989
     N  0.039,  0.026, 0.026,  0.044,  0.059,  0.059, 
C       1990    1991   1992    1993    1994    1995
     N  0.035,  0.051, 0.051,  0.052,  0.052,  0.052,
C       1997    2007   2008    NEYR   0000
     N  0.056,  0.056, 0.006,  0.003, 0.0,
C  HDDBT (DIESEL TRANSIT BUS)
C      1966   1967   1968   1969   1970   1971
     H 0.122, 0.122, 0.127, 0.129, 0.128, 0.128,
C      1972   1973   1974   1975   1976   1977
     H 0.128, 0.128, 0.128, 0.128, 0.128, 0.121,
C      1978   1979   1980   1981   1982   1983
     H 0.123, 0.000, 0.000, 0.000, 0.000, 0.000,
C      1984   1985   1986   1987   1988   1989
     H 0.000, 0.000, 0.000, 0.000, 0.008, 0.008,
C      1990   1991   1992   1993   1994   1995
     H 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
C      2006  NEYR,3*0000
     H 0.000, 4*0.0,
C      1966   1967   1968   1969   1970   1971
     C 0.341, 0.341, 0.355, 0.362, 0.359, 0.359,
C      1972   1973   1974   1975   1976   1977
     C 0.359, 0.359, 0.359, 0.359, 0.359, 0.340,
C      1978   1979   1980   1981   1982   1983
     C 0.344, 0.283, 0.291, 0.311, 0.298, 0.313,
C      1984   1985   1986   1987   1988   1989
     C 0.309, 0.307, 0.313, 0.313, 0.010, 0.010,
C      1990   1991   1992   1993   1994   1995
     C 0.049, 0.000, 0.000, 0.000, 0.000, 0.000,
C      2006  NEYR,3*0000
     C 0.000, 4*0.0,
C      1966   1967   1968   1969   1970   1971
     N 0.172, 0.172, 0.179, 0.182, 0.181, 0.181,
C      1972   1973   1974   1975   1976   1977
     N 0.181, 0.181, 0.181, 0.181, 0.181, 0.171,
C      1978   1979   1980   1981   1982   1983
     N 0.173, 0.000, 0.000, 0.000, 0.000, 0.000,
C      1984   1985   1986   1987   1988   1989
     N 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
C      1990   1991   1992   1993   1994   1995
     N 0.016, 0.000, 0.000, 0.000, 0.000, 0.000,
C      1997   2003   2006   2009   NEYR
     N 0.000, 0.000, 0.000, 0.008, 0.0/
C
        DATA DH28/
C  HDDBS (DIESEL SCHOOL BUS)
     H 0.071, 0.071, 0.071, 0.071, 0.071, 0.071,
     H 0.071, 0.071, 0.071, 0.071, 0.071, 0.071,
     H 0.071, 0.000, 0.000, 0.000, 0.000, 0.000,
     H 0.000, 0.000, 0.000, 0.000, 0.011, 0.011,
     H 0.006, 0.006, 0.006, 0.006, 0.006, 0.006,
     H 0.006, 0.006, 0.000, 2*0.0,
     C 0.198, 0.198, 0.198, 0.198, 0.198, 0.198,
     C 0.198, 0.198, 0.198, 0.198, 0.198, 0.198,
     C 0.198, 0.163, 0.160, 0.166, 0.157, 0.165,
     C 0.163, 0.162, 0.165, 0.165, 0.118, 0.119,
     C 0.046, 0.067, 0.068, 0.069, 0.064, 0.065,
     C 0.066, 4*0.0,
     N 0.100, 0.100, 0.100, 0.100, 0.100, 0.100,
     N 0.100, 0.100, 0.100, 0.100, 0.100, 0.100,
     N 0.100, 0.000, 0.000, 0.000, 0.000, 0.000,
     N 0.000, 0.000, 0.000, 0.000, 0.025, 0.025,
     N 0.017, 0.019, 0.020, 0.020, 0.003, 0.003,
     N 0.003, 0.003, 0.003, 0.003, 0.0,
C  LDDT34
     H 35*0.,
     C 35*0.,
     N 35*0./
C
C
C  Hardcoded zero mile engine start exhaust levels
C
C  Low altitude region
C
        DATA SZL02/
C  LDGV
     H 8.799,6.762,5.092,7.558,5.339,2.466,29*0.0,
     C 229.196,195.003,154.481,155.909,93.751,48.830,29*0.0,
     N 1.686,4.824,10.371,6.938,5.695,1.775,29*0.0,
C  LDGT1
     H 24.869,15.196,10.291,11.525,6.174,3.830,29*0.0,
     C 371.439,267.368,200.123,193.526,116.505,72.849,29*0.0,
     N 4.898,6.194,4.086,3.844,2.328,30*0.0/
C
        DATA SZL04/
C  LDGT2
     H 24.869,15.196,10.291,11.525,6.174,3.830,29*0.0,
     C 371.439,267.368,200.123,193.526,116.505,72.849,29*0.0,
     N 4.898,6.194,4.086,3.844,2.328,30*0.0,
C  LDGT3
     H 24.248,15.912,15.912,3.372,31*0.0,
     C 510.242,326.190,326.190,69.588,31*0.0,
     N 3.346,3.967,2.835,3.082,31*0.0/
C
        DATA  SZL06/
C  LDGT4
     H 24.248,15.912,15.912,3.372,31*0.0,
     C 510.242,326.190,326.190,69.588,31*0.0,
     N 3.346,3.967,2.835,3.082,31*0.0,
C  HDGV2B 
     H 35*0.,
     C 35*0.,
     n 35*0./
C
        DATA  SZL08/
C  HDGV3
     H 35*0.,
     C 35*0.,
     n 35*0.,
C  HDGV4
     H 35*0.,
     C 35*0.,
     n 35*0./
C
        DATA SZL10/
C  HDGV5
     H 35*0.,
     C 35*0.,
     n 35*0.,
C  HDGV6
     H 35*0.,
     C 35*0.,
     n 35*0./
C
        DATA  SZL12/
C  HDGV7
     H 35*0.,
     C 35*0.,
     n 35*0.,
C  HDGV8A
     H 35*0.,
     C 35*0.,
     n 35*0./
C
        DATA SZL14/
C  HDGV8B
     H 35*0.,
     C 35*0.,
     n 35*0.,
C  LDDV
     H 2.156,0.691,0.477,32*0.,
     C 7.091,3.062,3.009,32*0.,
     N 0.129,0.124,0.116,0.077,31*0.0/
C
        DATA SZL16/
C  LDDT12
     H 1.416,1.416,0.708,32*0.0,
     C 5.155,5.155,3.480,32*0.0,
     N 0.162,0.162,0.131,0.094,0.091,30*0.0,
C  HDDV2B
     H 35*0.,
     C 35*0.,
     N 35*0./
C
        DATA SZL18/
C  HDDV3
     H 35*0.,
     C 35*0.,
     n 35*0.,
C  HDDV4
     H 35*0.,
     C 35*0.,
     n 35*0./
C
        DATA SZL20/
C  HDDV5
     H 35*0.,
     C 35*0.,
     n 35*0.,
C  HDDV6
     H 35*0.,
     C 35*0.,
     n 35*0./
C
        DATA SZL22/
C  HDDV7
     H 35*0.,
     C 35*0.,
     n 35*0.,
C  HDDV8A
     H 35*0.,
     C 35*0.,
     n 35*0./
C
        DATA SZL24/
C  HDDV8B
     H 35*0.,
     C 35*0.,
     n 35*0.,
C  MC 
     H 18.643, 5.096, 4.098, 3.503, 2.782, 2.548,29*0.0,
     C 76.612,55.911,40.140,39.888,31*0.0,
     N 0.627, 1.705, 2.132,32*0.0/
C
        DATA SZL26/
C  HDGB (GASOLINE BUS) 
     H 35*0.,
     C 35*0.,
     n 35*0.,

C  HDDBT (DIESEL TRANSIT BUS) 
     H 35*0.,
     C 35*0.,
     n 35*0./
C
        DATA SZL28/
C  HDDBS (DIESEL SCHOOL BUS)
     H 35*0.,
     C 35*0.,
     n 35*0.,
C  LDDT34
     H 1.416,1.416,0.708,32*0.,
     C 5.155,5.155,3.480,32*0.,
     N 0.162,0.162,0.131,0.094,0.091,30*0./
C
C  High altitude region
C
        DATA SZH02/
C  LDGV
     H 19.917,15.578,13.104,8.595,6.104,5.299,7.898,5.732,27*0.0,
     C 425.443,354.961,337.061,253.750,199.524,114.670,204.371,
     C 139.225,27*0.0,
     N 0.995,3.581,7.922,6.776,8.511,2.373,1.281,28*0.0,
C  LDGT1
     H 33.948,20.332,16.629,16.629,12.345,5.809,12.817,5.560,27*0.0,
     C 541.504,393.545,366.401,347.952,266.887,
     C 105.172,246.460,196.060,27*0.0,
     N 3.069,4.557,2.991,2.944,3.523,2.944,1.871,28*0.0/
C
        DATA SZH04/
C  LDGT2
     H 33.948,20.332,16.629,16.629,12.345,5.809,12.817,5.560,27*0.0,
     C 541.504,393.545,366.401,347.952,266.887,
     C 105.172,246.460,196.060,27*0.0,
     N 3.069,4.557,2.991,2.944,3.523,2.944,1.871,28*0.0,
C  LDGT3
     H 32.967,22.850,22.850,11.755,31*0.0,
     C 554.639,422.679,422.679,300.935,31*0.0,
     N 1.634,2.277,1.618,2.270,31*0.0/
C
         DATA SZH06/
C  LDGT4
     H 32.967,22.850,22.850,11.755,31*0.0,
     C 554.639,422.679,422.679,300.935,31*0.0,
     N 1.634,2.277,1.618,2.270,31*0.0,
C  HDGV2B
     H 35*0.,
     C 35*0.,
     n 35*0./
C
        DATA SZH08/
C  HDGV3
     H 35*0.,
     C 35*0.,
     n 35*0.,
C  HDGV4
     H 35*0.,
     C 35*0.,
     n 35*0./
C
        DATA SZH10/
C  HDGV5
     H 35*0.,
     C 35*0.,
     n 35*0.,
C  HDGV6
     H 35*0.,
     C 35*0.,
     n 35*0./
C
        DATA SZH12/
C  HDGV7
     H 35*0.,
     C 35*0.,
     n 35*0.,
C  HDGV8A
     H 35*0.,
     C 35*0.,
     n 35*0./
C
         DATA SZH14/
C  HDGV8B
     H 35*0.,
     C 35*0.,
     n 35*0.,
C  LDDV
     H 4.955,1.597,1.103,0.658,0.477,30*0.0,
     C 12.403,5.364,5.260,3.009,31*0.0,
     N 0.129,0.124,0.116,0.077,31*0.0/
C
         DATA SZH16/
C  LDDT12
     H 3.259,1.630,0.889,0.708,31*0.0,
     C 9.028,6.097,3.480,32*0.0,
     N 0.162,0.131,0.094,0.091,0.091,30*0.0,
C  HDDV2B
     H 35*0.,
     C 35*0.,
     n 35*0./
C
        DATA SZH18/
C  HDDV3
     H 35*0.,
     C 35*0.,
     n 35*0.,
C  HDDV4
     H 35*0.,
     C 35*0.,
     n 35*0./
C
        DATA SZH20/
C  HDDV5
     H 35*0.,
     C 35*0.,
     n 35*0.,
C  HDDV6
     H 35*0.,
     C 35*0.,
     n 35*0./
C
        DATA SZH22/
C  HDDV7
     H 35*0., 
     C 35*0.,
     n 35*0.,
C  HDDV8A
     H 35*0., 
     C 35*0.,
     n 35*0./
C
         DATA SZH24/
C  HDDV8B
     H 35*0., 
     C 35*0.,
     n 35*0.,
C  MC
     H 24.269,6.412,6.264,5.351,4.247,3.907,29*0.0,
     C 114.918,84.979,75.855,75.397,31*0.0,
     N 0.351,1.128,1.429,32*0.0/
C
         DATA SZH26/
C  HDGB (GASOLINE BUS) 
     H 35*0.,
     C 35*0.,
     n 35*0.,
C  HDDBT (DIESEL TRANSIT BUS)
     H 35*0.,
     C 35*0.,
     n 35*0./
C
         DATA SZH28/
C  HDDBS (DIESEL SCHOOL BUS) 
     H 35*0.,
     C 35*0.,
     n 35*0.,
C  LDDT34
     H 3.259,1.630,0.889,0.708,31*0.0,
     C 9.028,6.097,3.480,32*0.0,
     N 0.162,0.131,0.094,0.091,0.091,30*0.0/
C
C  Hardcoded engine start deterioration rates
C
C  Low altitude region
C
        DATA SDL02/
C  LDGV                        
     H 0.218,0.382,0.628,0.358,1.410,1.404,29*0.0,
     C 6.589,8.826,11.466,8.949,13.015,15.699,29*0.0,
     N 0.000,0.000,0.181,0.114,0.350,0.121,29*0.0,
C  LDGT1
     H 0.617,0.858,1.269,0.583,0.926,1.233,29*0.0,
     C 10.678,12.101,14.854,11.579,12.291,14.415,29*0.0,
     N 0.000,0.000,0.057,0.043,0.079,30*0.0/
C
        DATA SDL04/
C  LDGT2
     H 0.617,0.858,1.269,0.583,0.926,1.233,29*0.0,
     C 10.678,12.101,14.854,11.579,12.291,14.415,29*0.0,
     N 0.000,0.000,0.057,0.043,0.079,30*0.0,
C  LDGT3
     H 0.456,0.633,0.431,1.085,31*0.0,
     C 12.216,13.845,13.247,13.770,31*0.0,
     N 0.000,0.000,0.025,0.104,31*0.0/
C
        DATA SDL06/
C  LDGT4
     H 0.456,0.633,0.431,1.085,31*0.0,
     C 12.216,13.845,13.247,13.770,31*0.0,
     N 0.000,0.000,0.025,0.104,31*0.0,
C  HDGV2B
     H 35*0., 
     C 35*0.,
     n 35*0./
C
        DATA SDL08/
C  HDGV3
     H 35*0., 
     C 35*0.,
     n 35*0.,
C  HDGV4
     H 35*0., 
     C 35*0.,
     n 35*0./
C
        DATA SDL10/
C  HDGV5
     H 35*0., 
     C 35*0.,
     n 35*0.,
C  HDGV6
     H 35*0., 
     C 35*0.,
     n 35*0./
C
        DATA SDL12/
C  HDGV7
     H 35*0., 
     C 35*0.,
     n 35*0.,
C  HDGV8A
     H 35*0., 
     C 35*0.,
     n 35*0./
C
        DATA SDL14/
C  HDGV8B
     H 35*0., 
     C 35*0.,
     n 35*0.,
C  LDDV
     H 0.132,0.115,0.049,32*0.0,
     C 0.340,0.236,0.105,32*0.0,
     N 0.004,0.004,0.003,0.003,31*0.0/
C
        DATA SDL16/
C  LDDT12
     H 0.132,0.132,0.066,32*0.0,
     C 0.262,0.262,0.105,32*0.0,
     N 0.007,0.007,0.003,0.003,0.003,30*0.0,
C  HDDV2B
     H 35*0., 
     C 35*0.,
     n 35*0./
C
        DATA SDL18/
C  HDDV3
     H 35*0., 
     C 35*0.,
     n 35*0.,
C  HDDV4
     H 35*0., 
     C 35*0.,
     n 35*0./
C
        DATA SDL20/
C  HDDV5
     H 35*0., 
     C 35*0.,
     n 35*0.,
C  HDDV6
     H 35*0., 
     C 35*0.,
     n 35*0./
C
        DATA SDL22/
C  HDDV7
     H 35*0., 
     C 35*0.,
     n 35*0.,
C  HDDV8A
     H 35*0., 
     C 35*0.,
     n 35*0./
         DATA SDL24/
C  HDDV8B
     H 35*0., 
     C 35*0.,
     n 35*0.,
C  MC
     H 1.592, 3.058, 2.442, 2.017, 1.592, 1.486,29*0.,
     C 7.382, 8.161, 5.800, 5.639, 31*0.,
     N 0.075, 0.00, 0.00, 32*0./
C
        DATA SDL26/
C  HDGB (GASOLINE BUS)
     H 35*0.,
     C 35*0.,
     n 35*0.,

C  HDDBT (DIESEL TRANSIT BUS) 
     H 35*0.,
     C 35*0.,
     n 35*0./
C
        DATA SDL28/
C  HDDBS (DIESEL SCHOOL BUS) 
     H 35*0.,
     C 35*0.,
     n 35*0.,

C  LDDT34 
     H 0.132,0.132,0.066,32*0.0,
     C 0.262,0.262,0.105,32*0.0,
     N 0.007,0.007,0.003,0.003,0.003,30*0.0/
C
C  High altitude region
C
        DATA SDH02/
C  LDGV        
     H 0.383,0.695,1.059,0.298,0.855,1.595,1.063,1.506,27*0.0,
     C 8.133,10.582,13.247,7.879,10.437,14.370,12.019,11.956,27*0.0,
     N 0.000,0.000,0.206,0.159,0.683,0.269,0.159,28*0.0,
C  LDGT1
     H 0.654,0.908,1.343,0.617,0.980,0.980,0.980,0.938,27*0.0,
     C 10.352,10.352,14.400,11.226,11.916,
     C 11.916,11.916,10.767,27*0.0,
     N 0.000,0.000,0.063,0.047,0.047,0.047,0.116,28*0.0/
C
      DATA SDH04/
C  LDGT2
     H 0.654,0.908,1.343,0.617,0.980,0.980,0.980,0.938,27*0.0,
     C 10.352,10.352,14.400,11.226,11.916,
     C 11.916,11.916,10.767,27*0.0,
     N 0.000,0.000,0.063,0.047,0.047,0.047,0.116,28*0.0,
C  LDGT3
     H 0.480,0.667,0.454,1.983,31*0.0,
     C 8.829,10.006,9.574,16.526,31*0.0,
     N 0.000,0.000,0.021,0.140,31*0.0/
C
       DATA SDH06/
C  LDGT4
     H 0.480,0.667,0.454,1.983,31*0.0,
     C 8.829,10.006,9.574,16.526,31*0.0,
     N 0.000,0.000,0.021,0.140,31*0.0,
C  HDGVB2
     H 35*0., 
     C 35*0.,
     N 35*0./
C
        DATA SDH08/
C  HDGV3
     H 35*0., 
     C 35*0.,
     N 35*0.,
C  HDGV4
     H 35*0., 
     C 35*0.,
     N 35*0./
C
        DATA SDH10/
C  HDGV5
     H 35*0., 
     C 35*0.,
     N 35*0.,
C  HDGV6
     H 35*0., 
     C 35*0.,
     N 35*0./
C
        DATA SDH12/
C  HDGV7
     H 35*0., 
     C 35*0.,
     N 35*0.,
C  HDGV8A
     H 35*0., 
     C 35*0.,
     N 35*0./
C
        DATA SDH14/
C  HDGV8B
     H 35*0., 
     C 35*0.,
     n 35*0.,
C  LDDV
     H 0.132,0.115,0.049,0.049,0.049,30*0.0,
     C 0.340,0.236,0.105,0.105,31*0.0,
     N 0.004,0.004,0.003,0.003,31*0.0/
C
        DATA SDH16/
C  LDDT12
     H 0.132,0.066,0.066,0.066,31*0.0,
     C 0.262,0.105,0.105,32*0.0,
     N 0.005,0.003,0.003,0.003,0.003,30*0.0,
C  HDDV2B
     H 35*0., 
     C 35*0.,
     n 35*0./
C
        DATA SDH18/
C  HDDV3
     H 35*0., 
     C 35*0.,
     n 35*0.,
C  HDDV4
     H 35*0., 
     C 35*0.,
     n 35*0./
C
        DATA SDH20/
C  HDDV5
     H 35*0., 
     C 35*0.,
     n 35*0.,
C  HDDV6
     H 35*0., 
     C 35*0.,
     n 35*0./
C
        DATA SDH22/
C  HDDV7
     H 35*0., 
     C 35*0.,
     n 35*0.,
C  HDDV8A
     H 35*0., 
     C 35*0.,
     n 35*0./
C
        DATA SDH24/
C  HDDV8B
     H 35*0., 
     C 35*0.,
     n 35*0.,
C  MC
     H 1.592,3.058,2.442,2.017,1.592,1.486,29*0.0,
     C 7.382,8.161,5.800,5.639,31*0.0,
     N 0.075,0.000,0.000,32*0.0/
C
        DATA SDH26/
C  HDGB (GASOLINE BUS) 
     H 35*0.,
     C 35*0.,
     n 35*0.,
C  HDDBT (DIESEL TRANSIT BUS)
     H 35*0.,
     C 35*0.,
     n 35*0./
C
        DATA SDH28/
C  HDDBS (DIESEL SCHOOL BUS) 
     H 35*0.,
     C 35*0.,
     n 35*0.,
C  LDDT34
     H 0.132,0.066,0.066,0.066,31*0.0,
     C 0.262,0.105,0.105,32*0.0,
     N 0.005,0.003,0.003,0.003,0.003,30*0.0/
C
C  Hardcoded zero mile running exhaust levels
C
C  Low altitude region
C
        DATA RZL02/
C  LDGV
     H 6.361,3.781,2.506,2.722,0.642,0.193,29*0.0,
     C 51.815,36.929,27.453,26.279,10.191,2.558,29*0.0,
     N 3.127,3.823,2.079,1.906,1.374,1.319,29*0.0,
C  LDGT1
     H 5.356,3.273,2.216,2.482,1.330,0.583,29*0.0,
     C 46.784,33.676,25.206,24.375,14.674,6.319,29*0.0,
     N 2.877,3.638,2.400,2.258,1.518,30*0.0/
C
        DATA RZL04/
C  LDGT2
     H 5.356,3.273,2.216,2.482,1.330,0.583,29*0.0,
     C 46.784,33.676,25.206,24.375,14.674,6.319,29*0.0,
     N 2.877,3.638,2.400,2.258,1.518,30*0.0,
C  LDGT3
     H 7.746,5.083,5.083,0.623,31*0.0,
     C 53.707,34.334,34.334,6.509,31*0.0,
     N 4.744,5.625,4.020,1.429,31*0.0/
C
        DATA RZL06/
C  LDGT4
     H 7.746,5.083,5.083,0.623,31*0.0,
     C 53.707,34.334,34.334,6.509,31*0.0,
     N 4.744,5.625,4.020,1.429,31*0.0,
C  HDGV2B 
     H 35*0., 
     C 35*0.,
     n 35*0./
C
        DATA RZL08/
C  HDGV3
     H 35*0., 
     C 35*0.,
     n 35*0.,
C  HDGV4
     H 35*0., 
     C 35*0.,
     n 35*0./
C
        DATA RZL10/
C  HDGV5
     H 35*0., 
     C 35*0.,
     n 35*0.,
C  HDGV6
     H 35*0., 
     C 35*0.,
     n 35*0./
C
        DATA RZL12/
C  HDGV7
     H 35*0., 
     C 35*0.,
     n 35*0.,
C  HDGV8A
     H 35*0., 
     C 35*0.,
     n 35*0./
C
        DATA RZL14/
C  HDGV8B
     H 35*0., 
     C 35*0.,
     n 35*0.,
C  LDDV
     H 1.089,0.349,0.241,32*0.0,
     C 1.920,0.829,0.815,32*0.0,
     N 1.462,1.402,1.312,0.871,31*0.0/
C
        DATA RZL16/
C  LDDT12
     H 0.715,0.715,0.358,32*0.0,
     C 1.396,1.396,0.943,32*0.0,
     N 1.832,1.832,1.482,1.071,1.031,30*0.0,
C  HDDV2B
     H 35*0., 
     C 35*0.,
     N 35*0./
C
        DATA RZL18/
C  HDDV3
     H 35*0., 
     C 35*0.,
     N 35*0.,
C  HDDV4
     H 35*0., 
     C 35*0.,
     N 35*0./
C
        DATA RZL20/
C  HDDV5
     H 35*0., 
     C 35*0.,
     N 35*0.,
C  HDDV6
     H 35*0., 
     C 35*0.,
     N 35*0./
C
        DATA RZL22/
C  HDDV7
     H 35*0., 
     C 35*0.,
     N 35*0.,
C  HDDV8A
     H 35*0., 
     C 35*0.,
     N 35*0./
C
        DATA RZL24/
C  HDDV8B
     H 35*0., 
     C 35*0.,
     N 35*0.,
C  MC
     H 6.952,1.900,1.528,1.306,1.037,0.950,29*0.0,
     C 21.272,15.524,11.145,11.075,31*0.0,
     N 0.190,0.517,0.647,32*0.0/
C
        DATA RZL26/
C  HDGB (GASOLINE BUS) 
     H 35*0.,
     C 35*0.,
     N 35*0.,
C  HDDBT (DIESEL TRANSIT BUS)
     H 35*0.,
     C 35*0.,
     N 35*0./
C
        DATA RZL28/
C  HDDBS (DIESEL SCHOOL BUS) 
     H 35*0.,
     C 35*0.,
     N 35*0.,
C  LDDT34
     H 0.715,0.715,0.358,32*0.0,
     C 1.396,1.396,0.943,32*0.0,
     N 1.832,1.832,1.482,1.071,1.031,30*0.0/
C
C  High altitude region
C
        DATA RZH02/
C  LDGV
     H 7.758,4.397,3.557,3.738,1.491,0.552,1.491,0.400,27*0.0,
     C 70.100,49.183,45.165,46.153,26.573,9.686,22.194,10.507,27*0.0,
     N 1.767,2.544,1.363,1.226,0.827,0.774,0.699,28*0.0,
C  LDGT1
     H 6.569,3.934,3.218,3.218,2.389,1.124,2.480,1.211,27*0.0,
     C 64.839,47.123,43.873,41.664,31.957,
     C 12.593,29.511,23.121,27*0.0,
     N 1.620,2.406,1.579,1.554,1.860,1.554,0.798,28*0.0/
C
        DATA RZH04/
C  LDGT2
     H 6.569,3.934,3.218,3.218,2.389,1.124,2.480,1.211,27*0.0,
     C 64.839,47.123,43.873,41.664,31.957,
     C 12.593,29.511,23.121,27*0.0,
     N 1.620,2.406,1.579,1.554,1.860,1.554,0.798,28*0.0,
C  LDGT3
     H 9.821,6.807,6.807,0.782,31*0.0,
     C 85.729,65.333,65.333,16.461,31*0.0,
     N 2.682,3.738,2.656,0.796,31*0.0/
C
         DATA RZH06/
C  LDGT4
     H 9.821,6.807,6.807,0.782,31*0.0,
     C 85.729,65.333,65.333,16.461,31*0.0,
     N 2.682,3.738,2.656,0.796,31*0.0,
C  HDGV2B
     H 35*0., 
     C 35*0.,
     N 35*0./
C
        DATA RZH08/
C  HDGV3
     H 35*0., 
     C 35*0.,
     N 35*0.,
C  HDGV4
     H 35*0., 
     C 35*0.,
     N 35*0./
C
        DATA RZH10/
C  HDGV5
     H 35*0., 
     C 35*0.,
     N 35*0.,
C  HDGV6
     H 35*0., 
     C 35*0.,
     N 35*0./
C
        DATA RZH12/
C  HDGV7
     H 35*0., 
     C 35*0.,
     N 35*0.,
C  HDGV8A
     H 35*0., 
     C 35*0.,
     N 35*0./
C
         DATA RZH14/
C  HDGV8B
     H 35*0., 
     C 35*0.,
     N 35*0.,
C  LDDV
     H 2.503,0.807,0.557,0.333,0.241,30*0.0,
     C 3.359,1.453,1.424,0.815,31*0.0,
     N 1.462,1.402,1.312,0.871,31*0.0/
C
         DATA RZH16/
C  LDDT12
     H 1.646,0.823,0.449,0.358,31*0.0,
     C 2.445,1.651,0.943,32*0.0,
     N 1.832,1.482,1.071,1.031,1.031,30*0.0,
C  HDDV2B
     H 35*0., 
     C 35*0.,
     N 35*0./
C
        DATA RZH18/
C  HDDV3
     H 35*0., 
     C 35*0.,
     N 35*0.,
C  HDDV4
     H 35*0., 
     C 35*0.,
     N 35*0./
C
        DATA RZH20/
C  HDDV5
     H 35*0., 
     C 35*0.,
     N 35*0.,
C  HDDV6
     H 35*0., 
     C 35*0.,
     N 35*0./
C
        DATA RZH22/
C  HDDV7
     H 35*0., 
     C 35*0.,
     N 35*0.,
C  HDDV8A
     H 35*0., 
     C 35*0.,
     N 35*0./
C
         DATA RZH24/
C  HDDV8B
     H 35*0., 
     C 35*0.,
     N 35*0.,
C  MC
     H 9.050,2.391,2.336,1.995,1.583,1.457,29*0.0,
     C 31.908,23.595,21.062,20.935,31*0.0,
     N 0.107,0.342,0.434,32*0.0/
C
         DATA RZH26/
C  HDGB (GASOLINE BUS)
     H 35*0.,
     C 35*0.,
     N 35*0.,
C  HDDBT (DIESEL TRANSIT BUS)
     H 35*0.,
     C 35*0.,
     N 35*0./
C
         DATA RZH28/
C  HDDBS (DIESEL SCHOOL BUS) 
     H 35*0.,
     C 35*0.,
     N 35*0.,
C  LDDT34
     H 1.646,0.823,0.449,0.358,31*0.0,
     C 2.445,1.651,0.943,32*0.0,
     N 1.832,1.482,1.071,1.031,1.031,30*0.0/
C
C  Hardcoded running deterioration rates
C
C  Low altitude region
C
        DATA RDL02/
C  LDGV                          
     H 0.158,0.213,0.309,0.129,0.170,0.110,29*0.0,
     C 1.490,1.671,2.038,1.508,1.415,0.823,29*0.0,
     N 0.000,0.000,0.036,0.031,0.084,0.090,29*0.0,
C  LDGT1
     H 0.133,0.185,0.273,0.126,0.199,0.187,29*0.0,
     C 1.345,1.524,1.871,1.458,1.548,1.250,29*0.0,
     N 0.000,0.000,0.033,0.025,0.051,30*0.0/
C
        DATA RDL04/
C  LDGT2
     H 0.133,0.185,0.273,0.126,0.199,0.187,29*0.0,
     C 1.345,1.524,1.871,1.458,1.548,1.250,29*0.0,
     N 0.000,0.000,0.033,0.025,0.051,30*0.0,
C  LDGT3
     H 0.146,0.202,0.138,0.200,31*0.0,
     C 1.286,1.457,1.394,1.288,31*0.0,
     N 0.000,0.000,0.035,0.048,31*0.0/
C
        DATA RDL06/
C  LDGT4
     H 0.146,0.202,0.138,0.200,31*0.0,
     C 1.286,1.457,1.394,1.288,31*0.0,
     N 0.000,0.000,0.035,0.048,31*0.0,
C  HDGV2B
     H 35*0., 
     C 35*0.,
     N 35*0./
C
        DATA RDL08/
C  HDGV3
     H 35*0., 
     C 35*0.,
     N 35*0.,
C  HDGV4
     H 35*0., 
     C 35*0.,
     N 35*0./
C
        DATA RDL10/
C  HDGV5
     H 35*0., 
     C 35*0.,
     N 35*0.,
C  HDGV6
     H 35*0., 
     C 35*0.,
     N 35*0./
C
        DATA RDL12/
C  HDGV7
     H 35*0., 
     C 35*0.,
     N 35*0.,
C  HDGV8A
     H 35*0., 
     C 35*0.,
     N 35*0./
C
        DATA RDL14/
C  HDGV8B
     H 35*0., 
     C 35*0.,
     N 35*0.,
C  LDDV
     H 0.067,0.058,0.025,32*0.0,
     C 0.092,0.064,0.028,32*0.0,
     N 0.040,0.040,0.030,0.030,31*0.0/
C
        DATA RDL16/
C  LDDT12
     H 0.067,0.067,0.033,32*0.0,
     C 0.071,0.071,0.028,32*0.0,
     N 0.080,0.080,0.030,0.030,0.030,30*0.0,
C  HDDV2B
     H 35*0., 
     C 35*0.,
     N 35*0./
C
        DATA RDL18/
C  HDDV3
     H 35*0., 
     C 35*0.,
     N 35*0.,
C  HDDV4
     H 35*0., 
     C 35*0.,
     N 35*0./
C
        DATA RDL20/
C  HDDV5
     H 35*0., 
     C 35*0.,
     N 35*0.,
C  HDDV6
     H 35*0., 
     C 35*0.,
     N 35*0./
C
        DATA RDL22/
C  HDDV7
     H 35*0., 
     C 35*0.,
     N 35*0.,
C  HDDV8A
     H 35*0., 
     C 35*0.,
     N 35*0./
        DATA RDL24/
C  HDDV8B
     H 35*0., 
     C 35*0.,
     N 35*0.,
C  MC
     H 0.594,1.140,0.911,0.752,0.594,0.554,29*0.0,
     C 2.050,2.266,1.610,1.566,31*0.0,
     N 0.023,0.000,0.000,32*0.0/
C
        DATA RDL26/
C  HDGB (GASOLINE BUS)
     H 35*0.,
     C 35*0.,
     N 35*0.,
C  HDDBT (DIESEL TRANSIT BUS)
     H 35*0.,
     C 35*0.,
     N 35*0./
C
        DATA RDL28/
C  HDDBS (DIESEL SCHOOL BUS) 
     H 35*0.,
     C 35*0.,
     N 35*0.,
C  LDDT34
     H 0.067,0.067,0.033,32*0.0,
     C 0.071,0.071,0.028,32*0.0,
     N 0.080,0.080,0.030,0.030,0.030,30*0.0/
C
C  High altitude region
C
        DATA RDH02/
C  LDGV                                  
     H 0.149,0.196,0.287,0.129,0.209,0.166,0.201,0.105,27*0.0,
     C 1.340,1.466,1.775,1.433,1.390,1.214,1.305,0.902,27*0.0,
     N 0.000,0.000,0.035,0.029,0.066,0.088,0.087,28*0.0,
C  LDGT1
     H 0.126,0.176,0.260,0.119,0.190,0.190,0.190,0.204,27*0.0,
     C 1.239,1.239,1.724,1.344,1.427,1.427,1.427,1.270,27*0.0,
     N 0.000,0.000,0.033,0.025,0.025,0.025,0.049,28*0.0/
C
      DATA RDH04/
C  LDGT2
     H 0.126,0.176,0.260,0.119,0.190,0.190,0.190,0.204,27*0.0,
     C 1.239,1.239,1.724,1.344,1.427,1.427,1.427,1.270,27*0.0,
     N 0.000,0.000,0.033,0.025,0.025,0.025,0.049,28*0.0,
C  LDGT3
     H 0.143,0.199,0.135,0.132,31*0.0,
     C 1.365,1.547,1.480,0.904,31*0.0,
     N 0.000,0.000,0.035,0.049,31*0.0/
C
       DATA RDH06/
C  LDGT4
     H 0.143,0.199,0.135,0.132,31*0.0,
     C 1.365,1.547,1.480,0.904,31*0.0,
     N 0.000,0.000,0.035,0.049,31*0.0,
C  HDGV2B
     H 35*0., 
     C 35*0.,
     N 35*0./
C
        DATA RDH08/
C  HDGV3
     H 35*0., 
     C 35*0.,
     N 35*0.,
C  HDGV4
     H 35*0., 
     C 35*0.,
     N 35*0./
C
        DATA RDH10/
C  HDGV5
     H 35*0., 
     C 35*0.,
     N 35*0.,
C  HDGV6
     H 35*0., 
     C 35*0.,
     N 35*0./
C
        DATA RDH12/
C  HDGV7
     H 35*0., 
     C 35*0.,
     N 35*0.,
C  HDGV8A
     H 35*0., 
     C 35*0.,
     N 35*0./
C
        DATA RDH14/
C  HDGV8B
     H 35*0., 
     C 35*0.,
     N 35*0.,
C  LDDV
     H 0.067,0.058,0.025,0.025,0.025,30*0.,
     C 0.092,0.064,0.028,0.028,31*0.,
     N 0.040,0.040,0.030,0.030,31*0./
C
        DATA RDH16/
C  LDDT12
     H 0.067,0.033,0.033,0.033,31*0.0,
     C 0.071,0.028,0.028,32*0.0,
     N 0.060,0.030,0.030,0.030,0.030,30*0.0,
C  HDDV2B
     H 35*0., 
     C 35*0.,
     N 35*0./
C
        DATA RDH18/
C  HDDV3
     H 35*0., 
     C 35*0.,
     N 35*0.,
C  HDDV4
     H 35*0., 
     C 35*0.,
     N 35*0./
C
        DATA RDH20/
C  HDDV5
     H 35*0., 
     C 35*0.,
     N 35*0.,
C  HDDV6
     H 35*0., 
     C 35*0.,
     N 35*0./
C
        DATA RDH22/
C  HDDV7
     H 35*0., 
     C 35*0.,
     N 35*0.,
C  HDDV8A
     H 35*0., 
     C 35*0.,
     N 35*0./
C
        DATA RDH24/
C  HDDV8B
     H 35*0., 
     C 35*0.,
     N 35*0.,
C  MC
     H 0.594,1.140,0.911,0.752,0.594,0.554,29*0.0,
     C 2.050,2.266,1.610,1.566,31*0.0,
     N 0.023,0.000,0.000,32*0.0/
C
        DATA RDH26/
C  HDGB (GASOLINE BUS) 
     H 35*0.,
     C 35*0.,
     N 35*0.,
C  HDDBT (DIESEL TRANSIT BUS)
     H 35*0.,
     C 35*0.,
     N 35*0./
C
        DATA RDH28/
C  HDDBS (DIESEL SCHOOL BUS) 
     H 35*0.,
     C 35*0.,
     N 35*0.,
C  LDDT34
     H 0.067,0.033,0.033,0.033,31*0.0,
     C 0.071,0.028,0.028,32*0.0,
     N 0.060,0.030,0.030,0.030,0.030,30*0.0/
C
C  /BASEQ5/:
C
C
C  User supplied zero mile levels and deterioration rates arrays are
C  initialized to all zeroes.
C
      DATA ERUZML/5880*0.0/,ERUDR/5880*0.0/
      DATA ESUZML/5880*0.0/,ESUDR/5880*0.0/
      DATA EMFAC/2880*0.0/
C
      END
