      BLOCK DATA BD05 
C 
C  BLOCK DATA Subprogram 05: /BASEQ9/, /BASE10/ 
C 
C  BLOCK DATA 05 initializes the zero mile levels and deterioration rates 
C  (intercepts & slopes) of the base LEV and TIER1 - Low Emitting Vehicles 
C  and TIER1 exhaust emission rate equations. 
C 
C  Changes : (Last change first) 
C 
C  23 Jan 01 @EPA-bag Bug308 RFG maximum sulfur levels set to 
C            Eastern CG maximum levels 
C  10 Jul 00 @EPA-ddj Bug184 Added GLFUEL_P. 
C  22 Jun 00 @EPS-ddj bug157 Increased USSCF array IV dimension 
C                     USSCF(4,2,2,4,2)-->USSCF(4,2,2,4,3) 
C  16 May 00 @EPS-ddj         Revised Tier2 S_FUEL numbers 
C  02 May 00 @DynTel-ddj E-7, Changed pre-2000 default sulfur from 
C            339 ppm to 300 ppm.  Added data values for S_FUEL (array 
C            of post-1999 estimated sulfur levels).  Added GLS_PPM. 
C  30 Dec 99 @DynTel-ddj 1-021, Changed LEVIMP values for post-2003.   
C            For post-2003 model years, Tier2 set to 1.0 and all  
C            other standards set to 0.0. 
C   7 Jul 99 @DynTel-MLA 2-694  Changed the LEVIMP values from the old 
C            default (California LEV program) to the new NLEV values. 
C  16 Jul 99 @DynTel-DDJ 2-699  Sulfur correction factor parameters. 
C  22 Jun 99 @DynTel-MLA 2-694  Removed P94REF (unused in Mobile6). 
C 
C  Common block array subscripts: 
C 
C  LEVIMP(11,MAXLYR,5) -  LEVIMP ( ILEV, MAXLYR, IV ) 
C  S_COEF(4,2,4,2,2)   -  S_COEF ( IP, ISR, ISTD, INH, IV ) 
C  S_FUEL(2,4,16,2)    -  S_FUEL ( LEVEL, IFUEL, ICY/MY, TIER2) 
C  USSCF(4,2,2,4,3)    -  USSCF  ( ISTD, ISR, INH, IP, IV ) 
C  LDTAB(2,2)          -  LDTAB ( ILDGT12/34, VVLDGT12/34 ) 
C  ZEVTF(25,5)         -  ZEVTF ( IDX, IV ) 
C  P94AR(3)            -  P94AR ( I ) 
C 
C  Common block dictionary: 
C 
C   Name   Type              Description 
C  ------  ----  -------------------------------------------- 
C 
C  /BASEQ9/: 
C 
C  LEVIMP   R    Hardcoded data for implemented LEVs   
C  MAXLYR   I    the  LEV years range 
C 
C  /BASEQ10/: 
C 
C  ZEVTF    R    TF data for ZEV vehicles by IDX     
C  ZEVTOT   R    total TF for ZEV   
C 
C  /P94INF/ 
C 
C  P94AR    C    store all names of 94P+LDG phase-in data files. 
C 
C  /S_DATA/: 
C 
C  S_COEF   R    Regression coefficients for sulfur correction factor. 
C  S_PPM    R    Gasoline sulfur content (ppm). 
C  GLS_PPM  R    Global gasoline sulfur content (ppm). 
C  GLFUEL_P I    Global sulfur fuel program. 
C  IH_S_PPM R    Gasoline sulfur content (ppm), in-house only. 
C 
C  Notes: 
C 
C  BD05 was modified to include kinked EFs for LDGT in MOBILE5. 
C  BD05 was modified for post release MOBILE5 for LEV phase in 
C  correction. 
C  24-August-1994 @CSC-pme request 2-446 include file BASE12.I,  
C  and CAPIV1 and CAPIV2 variables were removed.  
C  12-December-1994 @ CSC-ked Request 2-479  Fix BD05 LDGT2 
C  Fix LDGT2 LEV phase-in and emission values. 
C  15-October-1997 @DynTel-id Request 2-643. TIER2, TIER1-inter., 
C  were included in LEVIMP and TIER2,TIER1-inter, TIER1 were 
C  included in  P94STD arrays.  
C 
C  25-February-1998 @DynTel-ID 2-643. Expanded arrays LEVIMP  
C  and P94REF. Added TIER0.    
C 
C 23 Jul 98  @DynTel-MLA 2-000  Changed LDGT names to conform to 
C            certification naming conventions. 
C 
      IMPLICIT NONE 
      INCLUDE 'BASEQ9.I' 
      INCLUDE 'BASE10.I' 
      INCLUDE 'P94INF.I' 
      INCLUDE 'SULFUR.I' 
C 
      REAL LEVLDG, LEVGT1, LEVGT2, LEVGT3, LEVGT4 
C 
      DIMENSION LEVLDG(11,32), LEVGT1(11,32), LEVGT2(11,32) 
      DIMENSION LEVGT3(11,32), LEVGT4(11,32) 
C 
      EQUIVALENCE  (LEVIMP(1,1,1),LEVLDG(1,1)) 
      EQUIVALENCE  (LEVIMP(1,1,2),LEVGT1(1,1)) 
      EQUIVALENCE  (LEVIMP(1,1,3),LEVGT2(1,1)) 
      EQUIVALENCE  (LEVIMP(1,1,4),LEVGT3(1,1)) 
      EQUIVALENCE  (LEVIMP(1,1,5),LEVGT4(1,1)) 
C 
C 
C  MOBILE5 Processes the California Emission Standards for 
C  the LEV, Low Emission Vehicles. 
C 
C  Hardcoded FTP ER equation zero mile levels and deterioration (per 10000 
C  miles) rates are blocked by vehicle class.  Within each block, the 
C  continuation code is the pollutant type: H = HC, C = CO and N = NOx. 
C  There are up to 2 lines and 20 cases per pollutant per vehicle class per 
C  region per equation parameter. 
C 
C 
C     Arrays for LDGV, LDGT12, and LDGT34 Vehicles as 
C     low emission vehicles ( LEV's ) equivalenced into LEVIMP 
C 
C     LDGV   -> LEVLDG(11,MAXLYR) 
C     LDGT1  -> LEVGT1(11,MAXLYR) 
C     LDGT2  -> LEVGT2(11,MAXLYR) 
C     LDGT3  -> LEVGT3(11,MAXLYR) 
C     LDGT4  -> LEVGT4(11,MAXLYR) 
C 
C   The original data for the phase in for Tier1 is 
C 
C   Tier1 Phase In Schedule 
C   LDGV & LDGT (1,2,3,4) 
C   Phase In (as a fraction of sales) 
C   Model 
C   Year  Tier0  ITier1  Tier1 
C   1994   0.6    0.4     0.0   
C   1995   0.2    0.8     0.0 
C   1996   0.0    0.6     0.4 
C   1997   0.0    0.2     0.8 
C   1998   0.0    0.0     1.0 
C 
C    LEVLDG(11,MAXLYR)  LDGV - LEV - IMPLEMENTATION Phase In 
C 
      DATA LEVLDG  / 
C MYR  T0   T1   T1   T2   TLEV TLEV LEV  LEV  ULEV ULEV ZEV 
C           INT            INT       INT       INT 
     & 0.6, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.2, 0.8, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.6, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.2, 0.8, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 / 
C 
      DATA LEVGT1  / 
C MYR  T0   T1   T1   T2   TLEV TLEV LEV  LEV  ULEV ULEV ZEV 
C           INT            INT       INT       INT 
     & 0.6, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.2, 0.8, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.6, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.2, 0.8, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 / 
C 
      DATA LEVGT2 / 
C MYR  T0   T1   T1   T2   TLEV TLEV LEV  LEV  ULEV ULEV ZEV 
C           INT            INT       INT       INT 
     & 0.6, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.2, 0.8, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.6, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.2, 0.8, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 / 
C 
      DATA LEVGT3  / 
C MYR  T0   T1   T1   T2   TLEV TLEV LEV  LEV  ULEV ULEV ZEV 
C           INT            INT       INT       INT 
     & 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.5, 0.0, 0.5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 / 
C 
      DATA LEVGT4  / 
C MYR  T0   T1   T1   T2   TLEV TLEV LEV  LEV  ULEV ULEV ZEV 
C           INT            INT       INT       INT 
     & 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.5, 0.0, 0.5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 
     & 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 / 
C 
C     initilize the TF for ZEV, Zero Emission Vehicles 
C 
      DATA ZEVTF / 125*0.0 / 
      DATA ZEVTOT/  5*0.0 / 
C 
C    LDTAB  R  Weighting fraction for light and heavy duty 
C              LDGT1/LDGT2 and LDGT3/LDGT4 
C 
C                 (1,1) (2,1) (1,2) (2,2) 
      DATA LDTAB / 0.57, 0.65, 0.43, 0.35 / 
C 
      DATA P94AR /3* ' '/ 
C 
      DATA IH_S_PPM, S_PPM, GLS_PPM/ 3*300.0/ 
      DATA GLFUEL_P/ 1/ 
C 
      DATA S_COEF/ 
C 
C   NORMAL EMITTING VEHICLES 
C    TIER0   HC          NMHC          CO          NOx 
     R   1.526E-01,   1.519E-01,   1.909E-01,   0.208E-01, 
     S   0.270E-02,   0.370E-02,  -0.180E-01,   0.477E-01, 
C    TIER1 
     R   2.460E-03,   2.900E-03,   1.750E-03,   6.340E-04, 
     S   0.952E-04,   0.917E-04,  -0.234E-03,   0.802E-03, 
C    LEV 
     R   0.168E+00,   0.160E+00,   0.236E+00,   0.351E+00, 
     S   0.168E+00,   0.160E+00,   0.236E+00,   0.351E+00, 
C    ULEV 
     R   0.168E+00,   0.160E+00,   0.236E+00,   0.351E+00, 
     S   0.168E+00,   0.160E+00,   0.236E+00,   0.351E+00, 
C   HIGH EMITTING VEHICLES 
C    TIER0   HC          NMHC          CO          NOx 
     R   1.1380E-04,  9.6140E-05,  1.1110E-04,  2.8480E-04, 
     S  -2.2270E-04, -1.8240E-04, -5.3360E-04,  2.5190E-04, 
C    TIER1 
     R   1.1380E-04,  9.6140E-05,  1.1110E-04,  2.8480E-04, 
     S  -2.2270E-04, -1.8240E-04, -5.3360E-04,  2.5190E-04, 
C    LEV 
     R   1.1380E-04,  9.6140E-05,  1.1110E-04,  2.8480E-04, 
     S  -2.2270E-04, -1.8240E-04, -5.3360E-04,  2.5190E-04, 
C    ULEV 
     R   1.1380E-04,  9.6140E-05,  1.1110E-04,  2.8480E-04, 
     S  -2.2270E-04, -1.8240E-04, -5.3360E-04,  2.5190E-04, 
C   NORMAL EMITTING TRUCKS 
C    TIER0   HC          NMHC          CO          NOx 
     R   1.526E-01,   1.519E-01,   1.909E-01,   0.208E-01, 
     S   0.270E-02,   0.370E-02,  -0.180E-01,   0.477E-01, 
C    TIER1 
     R   2.460E-03,   2.900E-03,   1.750E-03,   6.340E-04, 
     S   0.952E-04,   0.917E-04,  -0.234E-03,   0.802E-03, 
C    LEV 
     R   0.125E+00,   0.090E+00,   0.151E+00,   0.146E+00, 
     S   0.125E+00,   0.090E+00,   0.151E+00,   0.146E+00, 
C    ULEV 
     R   0.125E+00,   0.090E+00,   0.151E+00,   0.146E+00, 
     S   0.125E+00,   0.090E+00,   0.151E+00,   0.146E+00, 
C   HIGH EMITTING TRUCKS 
C    TIER0   HC          NMHC          CO          NOx 
     R   1.1380E-04,  9.6140E-05,  1.1110E-04,  2.8480E-04, 
     S  -2.2270E-04, -1.8240E-04, -5.3360E-04,  2.5190E-04, 
C    TIER1 
     R   1.1380E-04,  9.6140E-05,  1.1110E-04,  2.8480E-04, 
     S  -2.2270E-04, -1.8240E-04, -5.3360E-04,  2.5190E-04, 
C    LEV 
     R   1.1380E-04,  9.6140E-05,  1.1110E-04,  2.8480E-04, 
     S  -2.2270E-04, -1.8240E-04, -5.3360E-04,  2.5190E-04, 
C    ULEV 
     R   1.1380E-04,  9.6140E-05,  1.1110E-04,  2.8480E-04, 
     S  -2.2270E-04, -1.8240E-04, -5.3360E-04,  2.5190E-04 / 
C 
      DATA USSCF/ 192*1.0/ 
C 
      DATA SUL_FLAG/ 1/ 
C 
      DATA LONGTERM/2.50, 2.36, 1.47/ 
C 
C     Average Data runs from CY2000 to CY2015+ 
C     Maximum Data runs from MY2000 to MY2015+ 
C 
      DATA S_FUEL/ 
C  NO   Eastern CG       RFG       Western CG   Alternate 
C TIER2 ave    max    ave   max    ave   max    ave   max 
     O  300., 1000.,  150., 1000.,  300.,1000.,  150., 500., 
     1  300., 1000.,  150., 1000.,  300.,1000.,  150., 500., 
     2  300., 1000.,  150., 1000.,  300.,1000.,  150., 500., 
     3  300., 1000.,  150., 1000.,  300.,1000.,  150., 500., 
     4  300., 1000.,  150., 1000.,  300.,1000.,  150., 500., 
     5  300., 1000.,  150., 1000.,  300.,1000.,  150., 500., 
     6  300., 1000.,  150., 1000.,  300.,1000.,  150., 500., 
     7  300., 1000.,  150., 1000.,  300.,1000.,  150., 500., 
     8  300., 1000.,  150., 1000.,  300.,1000.,  150., 500., 
     9  300., 1000.,  150., 1000.,  300.,1000.,  150., 500., 
     O  300., 1000.,  150., 1000.,  300.,1000.,  150., 500., 
     1  300., 1000.,  150., 1000.,  300.,1000.,  150., 500., 
     2  300., 1000.,  150., 1000.,  300.,1000.,  150., 500., 
     3  300., 1000.,  150., 1000.,  300.,1000.,  150., 500., 
     4  300., 1000.,  150., 1000.,  300.,1000.,  150., 500., 
     5  300., 1000.,  150., 1000.,  300.,1000.,  150., 500., 
C 
C       Eastern CG       RFG       Western CG   Alternate 
C TIER2 ave    max    ave   max    ave   max    ave   max 
     O  300., 1000.,  150.,1000.,  300.,1000.,  150., 500., 
     1  299., 1000.,  149.,1000.,  299.,1000.,  149., 500., 
     2  279., 1000.,  129.,1000.,  279.,1000.,  129., 500., 
     3  259., 1000.,  120.,1000.,  263.,1000.,  120., 500., 
     4  121.,  303.,  120., 303.,  160., 325.,  120., 300., 
     5   92.,  303.,   90., 303.,  160., 325.,   90., 300., 
     6   33.,   87.,   30.,  87.,  160., 325.,   30.,  80., 
     7   33.,   87.,   30.,  87.,   60., 142.,   30.,  80., 
     8   30.,   80.,   30.,  80.,   30.,  80.,   30.,  80., 
     9   30.,   80.,   30.,  80.,   30.,  80.,   30.,  80., 
     O   30.,   80.,   30.,  80.,   30.,  80.,   30.,  80., 
     1   30.,   80.,   30.,  80.,   30.,  80.,   30.,  80., 
     2   30.,   80.,   30.,  80.,   30.,  80.,   30.,  80., 
     3   30.,   80.,   30.,  80.,   30.,  80.,   30.,  80., 
     4   30.,   80.,   30.,  80.,   30.,  80.,   30.,  80., 
     5   30.,   80.,   30.,  80.,   30.,  80.,   30.,  80./ 
      END 
