      BLOCK DATA BD10 
C 
C  BLOCK DATA Subprogram 10: /NMETH1/,/NMETH2/ 
C 
C  BLOCK DATA 10 initializes methane offset ZML and DR values. 
C 
C  Changes: (Last change first) 
C 
C   2 Feb 00 @DynTel-ddj 1-032  Changed LDDT to LDDT12 and created 
C            LDDT34 by copying LDDT12 data to place holder for 
C            vehicle type 28. 
C  22 Oct. 98 @DynTel-HXQ 2-680 to replace the vtcomml bus data with 
C              school bus data.  
C  11 Aug 98 @DynTel-MLA 2-000  Changed HDG and HDD names to conform to 
C            new naming conventions. 
C 
C 
C  Common block array subscripts: 
C 
C  ZDMTH1(2,3,2,7,5,2) -  ZDMTH1 ( IZMDR, IB, IFDS, MTHMYG, IV, IR ) 
C  ZDMTH2(2,7,10,2)    -  ZDMTH2 ( IZMDR, MTHMYG, IVTEMP, IR ) 
C  ZDMTH3(7,13,2)      -  ZDMTH3 ( MTHMYG, IV-4, IR ) 
C  MYGMTH(7,28,2)      -  MTHMYG ( IG, IV, IR ) 
C 
C  Common block dictionary: 
C 
C   Name   Type              Description 
C  ------  ----  --------------------------------------------- 
C  /NMETH1/: 
C 
C  ZDMTH1   R    methane offset ZMLs and DRs for LDGV and LDGT by bag, 
C                fuel delivery system, myg and region 
C  ZDMTH2   R    methane offset ZMLs and DRs for HDGV and MC by myg and 
C                region 
C  ZDMTH3   R    methane offsets for LDDV, LDDT12, LDDT34 and HDDV by 
C                myg and region 
C  ZDMTH4   R    methane offsets for BUS by myg and region 
C 
C  /NMETH2/: 
C 
C  MYGMTH   I    methane offset model year groupts 
C  MTHMYG   I    index into myg dimension of ZDMTHi arrays 
C 
C  Local array subscripts: 
C 
C  MLDGVL(2,3,2,7) -  MLDGVL ( IZMDR, IB, IFDS, MTHMYG ) 
C  MGT1AL(2,3,2,7) -  MGT1AL ( IZMDR, IB, IFDS, MTHMYG ) 
C  MGT1BL(2,3,2,7) -  MGT1BL ( IZMDR, IB, IFDS, MTHMYG ) 
C  MGT2AL(2,3,2,7) -  MGT2AL ( IZMDR, IB, IFDS, MTHMYG ) 
C  MGT2BL(2,3,2,7) -  MGT2BL ( IZMDR, IB, IFDS, MTHMYG ) 
C  MLDGVH(2,3,2,7) -  MLDGVH ( IZMDR, IB, IFDS, MTHMYG ) 
C  MGT1AH(2,3,2,7) -  MGT1AH ( IZMDR, IB, IFDS, MTHMYG ) 
C  MGT1BH(2,3,2,7) -  MGT1BH ( IZMDR, IB, IFDS, MTHMYG ) 
C  MGT2AH(2,3,2,7) -  MGT2AH ( IZMDR, IB, IFDS, MTHMYG ) 
C  MGT2BH(2,3,2,7) -  MGT2BH ( IZMDR, IB, IFDS, MTHMYG ) 
C 
C  Local array dictionary: 
C 
C   Name    Type              Description 
C  ------   ----  --------------------------------------- 
C  MLDGVL    R    low altitude methane offset ZML and DR for LDGV 
C  MLGT1AL   R    low altitude methane offset ZML and DR for LDGT1 
C  MLGT1BL   R    low altitude methane offset ZML and DR for LDGT2 
C  MLGT2AL   R    low altitude methane offset ZML and DR for LDGT3 
C  MLGT2BL   R    low altitude methane offset ZML and DR for LDGT4 
C  MLDGVH    R    high altitude methane offset ZML and DR for LDGV 
C  MLGT1AH   R    high altitude methane offset ZML and DR for LDGT1 
C  MLGT1BH   R    high altitude methane offset ZML and DR for LDGT2 
C  MLGT2AH   R    high altitude methane offset ZML and DR for LDGT3 
C  MLGT2BH   R    high altitude methane offset ZML and DR for LDGT4 
C 
C  Notes: 
C 
C  BD10 updated in MOBILE4.1 to include Zero Mile Levels & Deterioration Rates. 
C 
C 15 Nov 96 DynTel@MLA 2-622  Expanded the arrays to accomodate the new Heavy 
C           Duty Gasoline, Heavy Duty Diesel, and LDGT vehicle categories. 
C 
C  2 Apr 97 DynTel@MLA 2-622  Added ZDMTH4 for the BUS vehicle category and 
C           added entries for BUS to MYGMTH. 
C 
C 23 Jul 98 @DynTel-MLA 2-000  Changed LDGT names to conform to 
C           certification naming conventions. 
C 
      IMPLICIT NONE 
      INCLUDE 'NMETH1.I' 
      INCLUDE 'NMETH2.I' 
      INCLUDE 'PARAME.I' 
C 
      REAL MLDGVL(2,3,2,7),MGT1AL(2,3,2,7),MGT1BL(2,3,2,7), 
     *     MGT2AL(2,3,2,7),MGT2BL(2,3,2,7), 
     *     MLDGVH(2,3,2,7),MGT1AH(2,3,2,7),MGT1BH(2,3,2,7), 
     *     MGT2AH(2,3,2,7),MGT2BH(2,3,2,7) 
C 
      EQUIVALENCE 
     *   (ZDMTH1(1,1,1,1,1,1),MLDGVL(1,1,1,1)), 
     *   (ZDMTH1(1,1,1,1,2,1),MGT1AL(1,1,1,1)), 
     *   (ZDMTH1(1,1,1,1,3,1),MGT1BL(1,1,1,1)), 
     *   (ZDMTH1(1,1,1,1,4,1),MGT2AL(1,1,1,1)), 
     *   (ZDMTH1(1,1,1,1,5,1),MGT2BL(1,1,1,1)), 
     *   (ZDMTH1(1,1,1,1,1,2),MLDGVH(1,1,1,1)), 
     *   (ZDMTH1(1,1,1,1,2,2),MGT1AH(1,1,1,1)), 
     *   (ZDMTH1(1,1,1,1,3,2),MGT1BH(1,1,1,1)), 
     *   (ZDMTH1(1,1,1,1,4,2),MGT2AH(1,1,1,1)), 
     *   (ZDMTH1(1,1,1,1,5,2),MGT2BH(1,1,1,1)) 
C 
C  The continuation code for ZMLs and DRs is methane myg. 
C  The first myg line is for CARB, the second is for FINJ. 
C 
C              Bag 1         Bag 2         Bag 3 
C           ZML     DR    ZML     DR    ZML     DR 
C LDGV-LO 
      DATA MLDGVL/ 
     1     .366 , .0108, .282 , .0057, .207 , .0046, 
     1     .000 , .0000, .000 , .0000, .000 , .0000, 
     2     .196 , .0108, .132 , .0057, .097 , .0046, 
     2     .000 , .0000, .000 , .0000, .000 , .0000, 
     3     .086 , .0108, .062 , .0057, .057 , .0046, 
     3     .000 , .0000, .000 , .0000, .000 , .0000, 
     4     .1152, .0108, .0835, .0057, .0694, .0046, 
     4     .0491, .0072, .0262, .0049, .0260, .0044, 
     5     .0819, .0089, .0596, .0037, .0563, .0025, 
     5     .0533, .0072, .0251, .0099, .0318, .0058, 
     6     .000 , .0000, .000 , .0000, .000 , .0000, 
     6     .000 , .0000, .000 , .0000, .000 , .0000, 
     7     .000 , .0000, .000 , .0000, .000 , .0000, 
     7     .000 , .0000, .000 , .0000, .000 , .0000/ 
C LDGT1-LO 
      DATA MGT1AL/ 
     1     .366 , .0108, .282 , .0057, .207 , .0046, 
     1     .000 , .0000, .000 , .0000, .000 , .0000, 
     2     .206 , .0108, .132 , .0057, .107 , .0046, 
     2     .000 , .0000, .000 , .0000, .000 , .0000, 
     3     .1942, .0108, .1129, .0057, .0954, .0046, 
     3     .0551, .0072, .0587, .0049, .0406, .0044, 
     4     .1609, .0089, .1126, .0037, .0987, .0025, 
     4     .0551, .0072, .0287, .0099, .0322, .0058, 
     5     .000 , .0000, .000 , .0000, .000 , .0000, 
     5     .000 , .0000, .000 , .0000, .000 , .0000, 
     6     .000 , .0000, .000 , .0000, .000 , .0000, 
     6     .000 , .0000, .000 , .0000, .000 , .0000, 
     7     .000 , .0000, .000 , .0000, .000 , .0000, 
     7     .000 , .0000, .000 , .0000, .000 , .0000/ 
C LDGT2-LO 
      DATA MGT1BL/ 
     1     .366 , .0108, .282 , .0057, .207 , .0046, 
     1     .000 , .0000, .000 , .0000, .000 , .0000, 
     2     .206 , .0108, .132 , .0057, .107 , .0046, 
     2     .000 , .0000, .000 , .0000, .000 , .0000, 
     3     .1942, .0108, .1129, .0057, .0954, .0046, 
     3     .0551, .0072, .0587, .0049, .0406, .0044, 
     4     .1609, .0089, .1126, .0037, .0987, .0025, 
     4     .0551, .0072, .0287, .0099, .0322, .0058, 
     5     .000 , .0000, .000 , .0000, .000 , .0000, 
     5     .000 , .0000, .000 , .0000, .000 , .0000, 
     6     .000 , .0000, .000 , .0000, .000 , .0000, 
     6     .000 , .0000, .000 , .0000, .000 , .0000, 
     7     .000 , .0000, .000 , .0000, .000 , .0000, 
     7     .000 , .0000, .000 , .0000, .000 , .0000/ 
C LDGT3-LO 
      DATA MGT2AL/ 
     1     .366 , .0108, .282 , .0057, .207 , .0046, 
     1     .000 , .0000, .000 , .0000, .000 , .0000, 
     2     .206 , .0108, .132 , .0057, .107 , .0046, 
     2     .000 , .0000, .000 , .0000, .000 , .0000, 
     3     .1942, .0108, .1129, .0057, .0954, .0046, 
     3     .0551, .0072, .0587, .0049, .0406, .0044, 
     4     .1609, .0089, .1126, .0037, .0987, .0025, 
     4     .0551, .0072, .0287, .0099, .0322, .0058, 
     5     .000 , .0000, .000 , .0000, .000 , .0000, 
     5     .000 , .0000, .000 , .0000, .000 , .0000, 
     6     .000 , .0000, .000 , .0000, .000 , .0000, 
     6     .000 , .0000, .000 , .0000, .000 , .0000, 
     7     .000 , .0000, .000 , .0000, .000 , .0000, 
     7     .000 , .0000, .000 , .0000, .000 , .0000/ 
C LDGT4-LO 
      DATA MGT2BL/ 
     1     .366 , .0108, .282 , .0057, .207 , .0046, 
     1     .000 , .0000, .000 , .0000, .000 , .0000, 
     2     .206 , .0108, .132 , .0057, .107 , .0046, 
     2     .000 , .0000, .000 , .0000, .000 , .0000, 
     3     .1942, .0108, .1129, .0057, .0954, .0046, 
     3     .0551, .0072, .0587, .0049, .0406, .0044, 
     4     .1609, .0089, .1126, .0037, .0987, .0025, 
     4     .0551, .0072, .0287, .0099, .0322, .0058, 
     5     .000 , .0000, .000 , .0000, .000 , .0000, 
     5     .000 , .0000, .000 , .0000, .000 , .0000, 
     6     .000 , .0000, .000 , .0000, .000 , .0000, 
     6     .000 , .0000, .000 , .0000, .000 , .0000, 
     7     .000 , .0000, .000 , .0000, .000 , .0000, 
     7     .000 , .0000, .000 , .0000, .000 , .0000/ 
C LDGV-HI 
      DATA MLDGVH/ 
     1     .494 , .0146, .381 , .0077, .279 , .0062, 
     1     .000 , .0000, .000 , .0000, .000 , .0000, 
     2     .368 , .0203, .248 , .0107, .182 , .0086, 
     2     .000 , .0000, .000 , .0000, .000 , .0000, 
     3     .172 , .0095, .116 , .0050, .085 , .0040, 
     3     .000 , .0000, .000 , .0000, .000 , .0000, 
     4     .382 , .0211, .257 , .0111, .189 , .0090, 
     4     .000 , .0000, .000 , .0000, .000 , .0000, 
     5     .186 , .0233, .134 , .0123, .123 , .0099, 
     5     .000 , .0000, .000 , .0000, .000 , .0000, 
     6     .190 , .0178, .138 , .0094, .115 , .0076, 
     6     .081 , .0119, .043 , .0081, .043 , .0073, 
     7     .115 , .0108, .084 , .0057, .069 , .0046, 
     7     .049 , .0049, .026 , .0049, .026 , .0044/ 
C LDGT1-HI 
      DATA MGT1AH/ 
     1     .497 , .0146, .382 , .0077, .279 , .0062, 
     1     .000 , .0000, .000 , .0000, .000 , .0000, 
     2     .487 , .0108, .332 , .0077, .239 , .0062, 
     2     .000 , .0000, .000 , .0000, .000 , .0000, 
     3     .427 , .0146, .272 , .0077, .219 , .0062, 
     3     .000 , .0000, .000 , .0000, .000 , .0000, 
     4     .292 , .0146, .155 , .0077, .139 , .0062, 
     4     .000 , .0000, .000 , .0000, .000 , .0000, 
     5     .205 , .0133, .140 , .0055, .127 , .0037, 
     5     .000 , .0000, .000 , .0000, .000 , .0000, 
     6     .153 , .0111, .105 , .0046, .097 , .0031, 
     6     .000 , .0000, .000 , .0000, .000 , .0000, 
     7     .161 , .0089, .113 , .0037, .099 , .0025, 
     7     .055 , .0072, .029 , .0099, .032 , .0058/ 
C LDGT2-HI 
      DATA MGT1BH/ 
     1     .497 , .0146, .382 , .0077, .279 , .0062, 
     1     .000 , .0000, .000 , .0000, .000 , .0000, 
     2     .487 , .0108, .332 , .0077, .239 , .0062, 
     2     .000 , .0000, .000 , .0000, .000 , .0000, 
     3     .427 , .0146, .272 , .0077, .219 , .0062, 
     3     .000 , .0000, .000 , .0000, .000 , .0000, 
     4     .292 , .0146, .155 , .0077, .139 , .0062, 
     4     .000 , .0000, .000 , .0000, .000 , .0000, 
     5     .205 , .0133, .140 , .0055, .127 , .0037, 
     5     .000 , .0000, .000 , .0000, .000 , .0000, 
     6     .153 , .0111, .105 , .0046, .097 , .0031, 
     6     .000 , .0000, .000 , .0000, .000 , .0000, 
     7     .161 , .0089, .113 , .0037, .099 , .0025, 
     7     .055 , .0072, .029 , .0099, .032 , .0058/ 
C LDGT3-HI 
      DATA MGT2AH/ 
     1     .497 , .0146, .382 , .0077, .279 , .0062, 
     1     .000 , .0000, .000 , .0000, .000 , .0000, 
     2     .497 , .0146, .382 , .0077, .279 , .0062, 
     2     .000 , .0000, .000 , .0000, .000 , .0000, 
     3     .427 , .0146, .272 , .0077, .219 , .0062, 
     3     .000 , .0000, .000 , .0000, .000 , .0000, 
     4     .292 , .0146, .155 , .0077, .139 , .0062, 
     4     .000 , .0000, .000 , .0000, .000 , .0000, 
     5     .205 , .0133, .140 , .0055, .127 , .0037, 
     5     .000 , .0000, .000 , .0000, .000 , .0000, 
     6     .153 , .0111, .105 , .0046, .097 , .0031, 
     6     .000 , .0000, .000 , .0000, .000 , .0000, 
     7     .161 , .0089, .113 , .0037, .099 , .0025, 
     7     .055 , .0072, .029 , .0099, .032 , .0058/ 
C LDGT4-HI 
      DATA MGT2BH/ 
     1     .497 , .0146, .382 , .0077, .279 , .0062, 
     1     .000 , .0000, .000 , .0000, .000 , .0000, 
     2     .497 , .0146, .382 , .0077, .279 , .0062, 
     2     .000 , .0000, .000 , .0000, .000 , .0000, 
     3     .427 , .0146, .272 , .0077, .219 , .0062, 
     3     .000 , .0000, .000 , .0000, .000 , .0000, 
     4     .292 , .0146, .155 , .0077, .139 , .0062, 
     4     .000 , .0000, .000 , .0000, .000 , .0000, 
     5     .205 , .0133, .140 , .0055, .127 , .0037, 
     5     .000 , .0000, .000 , .0000, .000 , .0000, 
     6     .153 , .0111, .105 , .0046, .097 , .0031, 
     6     .000 , .0000, .000 , .0000, .000 , .0000, 
     7     .161 , .0089, .113 , .0037, .099 , .0025, 
     7     .055 , .0072, .029 , .0099, .032 , .0058/ 
C 
C  The continuation code for ZDMTH2 is the old Mobile5 IV number (4=HDGV, 
C  8=MC). The new code B is for gasoline-powered buses. 
C 
C        MYG:    1            2            3          4-7 
C           ZML    DR    ZML    DR    ZML    DR    ZML    DR 
      DATA ZDMTH2/ 
C HDGV2B-LO 
     4     .600, .014 , .225, .017 , .095, .017 , 4*.0, 4*.0, 
C HDGV3-LO 
     4     .600, .014 , .225, .017 , .095, .017 , 4*.0, 4*.0, 
C HDGV4-LO 
     4     .600, .014 , .225, .017 , .095, .017 , 4*.0, 4*.0, 
C HDGV5-LO 
     4     .600, .014 , .225, .017 , .095, .017 , 4*.0, 4*.0, 
C HDGV6-LO 
     4     .600, .014 , .225, .017 , .095, .017 , 4*.0, 4*.0, 
C HDGV7-LO 
     4     .600, .014 , .225, .017 , .095, .017 , 4*.0, 4*.0, 
C HDGV8A-LO 
     4     .600, .014 , .225, .017 , .095, .017 , 4*.0, 4*.0, 
C HDGV8B-LO 
     4     .600, .014 , .225, .017 , .095, .017 , 4*.0, 4*.0, 
C MC-LO 
     8     .511, .0108, .251, .0108, .221, .0108, 4*.0, 4*.0, 
C GAS BUS-LO 
     B     .600, .014 , .225, .017 , .095, .017 , 4*.0, 4*.0, 
C HDGV2B-HI 
     4     .816, .019 , .437, .033 , .184, .033 , 4*.0, 4*.0, 
C HDGV3-HI 
     4     .816, .019 , .437, .033 , .184, .033 , 4*.0, 4*.0, 
C HDGV4-HI 
     4     .816, .019 , .437, .033 , .184, .033 , 4*.0, 4*.0, 
C HDGV5-HI 
     4     .816, .019 , .437, .033 , .184, .033 , 4*.0, 4*.0, 
C HDGV6-HI 
     4     .816, .019 , .437, .033 , .184, .033 , 4*.0, 4*.0, 
C HDGV7-HI 
     4     .816, .019 , .437, .033 , .184, .033 , 4*.0, 4*.0, 
C HDGV8B-HI 
     4     .816, .019 , .437, .033 , .184, .033 , 4*.0, 4*.0, 
C HDGV8B-HI 
     4     .816, .019 , .437, .033 , .184, .033 , 4*.0, 4*.0, 
C MC-HI 
     8     .511, .0108, .251, .0108, .221, .0108, 4*.0, 4*.0, 
C GAS BUS-HI 
     B     .816, .019 , .437, .033 , .184, .033 , 4*.0, 4*.0/ 
C 
C  The continuation code for ZDMTH3 is the old Mobile5 IV number (4=HDGV, 
C  8=MC). The new code B is for Diesel-powered buses (commercial, urban, 
C  and school buses). 
C 
C        MYG: 1     2     3     4   5-7 
      DATA ZDMTH3/ 
C LDDV-LO 
     5     .043, .011, .011, .000, 3*.0, 
C LDDT12-LO 
     6     .034, .034, .017, .000, 3*.0, 
C HDDV2B-LO 
     7     .145, .145, .118, .100, 3*.0, 
C HDDV3-LO 
     7     .145, .145, .118, .100, 3*.0, 
C HDDV4-LO 
     7     .145, .145, .118, .100, 3*.0, 
C HDDV5-LO 
     7     .145, .145, .118, .100, 3*.0, 
C HDDV6-LO 
     7     .145, .145, .118, .100, 3*.0, 
C HDDV7-LO 
     7     .145, .145, .118, .100, 3*.0, 
C HDDV8A-LO 
     7     .145, .145, .118, .100, 3*.0, 
C HDDV8B-LO 
     7     .145, .145, .118, .100, 3*.0, 
C URBAN BUS-LO 
     B     .145, .145, .118, .100, 3*.0, 
C SCHOOL BUS-LO 
     B     .145, .145, .118, .100, 3*.0, 
C LDDT34-LO 
     6     .034, .034, .017, .000, 3*.0, 
C LDDV-HI 
     5     .099, .025, .025, .000, 3*.0, 
C LDDT12-HI 
     6     .079, .079, .040, .022, 3*.0, 
C HDDV2B-HI 
     7     .333, .333, .271, .230, 3*.0, 
C HDDV3-HI 
     7     .333, .333, .271, .230, 3*.0, 
C HDDV4-HI 
     7     .333, .333, .271, .230, 3*.0, 
C HDDV5-HI 
     7     .333, .333, .271, .230, 3*.0, 
C HDDV6-HI 
     7     .333, .333, .271, .230, 3*.0, 
C HDDV7-HI 
     7     .333, .333, .271, .230, 3*.0, 
C HDDV8A-HI 
     7     .333, .333, .271, .230, 3*.0, 
C HDDV8B-HI 
     7     .333, .333, .271, .230, 3*.0, 
C URBAN BUS-HI 
     B     .333, .333, .271, .230, 3*.0, 
C SCHOOL BUS-HI 
     B     .333, .333, .271, .230, 3*.0, 
C LDDT34-HI 
     6     .079, .079, .040, .022, 3*.0/ 
C 
C  The continuation code for methane myg is the old Mobile5 IV number 
C  (1=LDGV, 2=LDGT12, 3=LDGT34, 4=HDGV, 5=LDDV, 6=LDDT12 or LDDT34, 
C  7=HDDV, 8=MC). 
C  The continuation code B is used for the three BUS categories. 
C 
C        MYG: 1     2     3     4     5     6     7 
      DATA MYGMTH/ 
C LO 
     1     1974, 1979, 1980, 1982, NEYR, 0000, 0000, 
     2     1978, 1980, 1982, NEYR, 0000, 0000, 0000, 
     2     1978, 1980, 1982, NEYR, 0000, 0000, 0000, 
     3     1978, 1980, 1982, NEYR, 0000, 0000, 0000, 
     3     1978, 1980, 1982, NEYR, 0000, 0000, 0000, 
     4     1978, 1986, NEYR, 0000, 0000, 0000, 0000, 
     4     1978, 1986, NEYR, 0000, 0000, 0000, 0000, 
     4     1978, 1986, NEYR, 0000, 0000, 0000, 0000, 
     4     1978, 1986, NEYR, 0000, 0000, 0000, 0000, 
     4     1978, 1986, NEYR, 0000, 0000, 0000, 0000, 
     4     1978, 1986, NEYR, 0000, 0000, 0000, 0000, 
     4     1978, 1986, NEYR, 0000, 0000, 0000, 0000, 
     4     1978, 1986, NEYR, 0000, 0000, 0000, 0000, 
     5     1974, 1979, NEYR, 0000, 0000, 0000, 0000, 
     6     1977, 1980, NEYR, 0000, 0000, 0000, 0000, 
     7     1977, 1981, 1987, NEYR, 0000, 0000, 0000, 
     7     1977, 1981, 1987, NEYR, 0000, 0000, 0000, 
     7     1977, 1981, 1987, NEYR, 0000, 0000, 0000, 
     7     1977, 1981, 1987, NEYR, 0000, 0000, 0000, 
     7     1977, 1981, 1987, NEYR, 0000, 0000, 0000, 
     7     1977, 1981, 1987, NEYR, 0000, 0000, 0000, 
     7     1977, 1981, 1987, NEYR, 0000, 0000, 0000, 
     7     1977, 1981, 1987, NEYR, 0000, 0000, 0000, 
     8     1977, 1979, NEYR, 0000, 0000, 0000, 0000, 
     B     1978, 1986, NEYR, 0000, 0000, 0000, 0000, 
     B     1977, 1981, 1987, NEYR, 0000, 0000, 0000, 
     B     1977, 1981, 1987, NEYR, 0000, 0000, 0000, 
     6     1977, 1980, NEYR, 0000, 0000, 0000, 0000, 
C HI 
     1     1974, 1976, 1977, 1979, 1980, 1982, NEYR, 
     2     1974, 1978, 1980, 1983, 1984, 1985, NEYR, 
     2     1974, 1978, 1980, 1983, 1984, 1985, NEYR, 
     3     1973, 1978, 1980, 1983, 1984, 1985, NEYR, 
     3     1973, 1978, 1980, 1983, 1984, 1985, NEYR, 
     4     1978, 1986, NEYR, 0000, 0000, 0000, 0000, 
     4     1978, 1986, NEYR, 0000, 0000, 0000, 0000, 
     4     1978, 1986, NEYR, 0000, 0000, 0000, 0000, 
     4     1978, 1986, NEYR, 0000, 0000, 0000, 0000, 
     4     1978, 1986, NEYR, 0000, 0000, 0000, 0000, 
     4     1978, 1986, NEYR, 0000, 0000, 0000, 0000, 
     4     1978, 1986, NEYR, 0000, 0000, 0000, 0000, 
     4     1978, 1986, NEYR, 0000, 0000, 0000, 0000, 
     5     1974, 1979, NEYR, 0000, 0000, 0000, 0000, 
     6     1978, 1980, 1983, NEYR, 0000, 0000, 0000, 
     7     1977, 1981, 1987, NEYR, 0000, 0000, 0000, 
     7     1977, 1981, 1987, NEYR, 0000, 0000, 0000, 
     7     1977, 1981, 1987, NEYR, 0000, 0000, 0000, 
     7     1977, 1981, 1987, NEYR, 0000, 0000, 0000, 
     7     1977, 1981, 1987, NEYR, 0000, 0000, 0000, 
     7     1977, 1981, 1987, NEYR, 0000, 0000, 0000, 
     7     1977, 1981, 1987, NEYR, 0000, 0000, 0000, 
     7     1977, 1981, 1987, NEYR, 0000, 0000, 0000, 
     8     1977, 1979, NEYR, 0000, 0000, 0000, 0000, 
     B     1978, 1986, NEYR, 0000, 0000, 0000, 0000, 
     B     1977, 1981, 1987, NEYR, 0000, 0000, 0000, 
     B     1977, 1981, 1987, NEYR, 0000, 0000, 0000, 
     6     1978, 1980, 1983, NEYR, 0000, 0000, 0000/ 
C 
      END 
