      BLOCK DATA BD20 
C 
C  BLOCK DATA Subprogram 20: /MYRSAV/,/VMXCOM/ 
C 
C  BLOCK DATA 20 initializes fleet characterization data: 
C  (1) annual mileage accumulation rates by relative (to evaluation year) 
C      model year (JDX) and vehicle type (IV) 
C  (2) July 1 registration distributions, also by JDX and IV 
C  (3) vehicle miles travelled (vmt) mix, by IV 
C  (4) registration (reg) mix, by IV 
C  (5) vehicle count (VCOUNT) , by ICY and IV 
C 
C  Changes: (Last change first) 
C 
C 
C  10 Sep 01 @EPA-djb Bug 332, Corrected VCOUNT values for HDGV 
C  30 Nov 00 @EPA-djb Bug 305, Corrected VCOUNT values for the 1983 and 
C            1995 calendar years for LDT4 (V06COU). 
C  12 Sep 00 @EPA-djb Bug 237, Initialized GLVMTMIX. 
C  07 Apr 00 @EPA-djb Replaced AMAR, JULMYR and VCOUNT arrays with 
C                     final numbers and added VMTUSR array initialization. 
C   2 Feb 00 @DynTel-ddj 1-032  Changed LDDT to LDDT12 and created 
C            LDDT34 by copying LDDT12 data to place holder for 
C            vehicle type 28. 
C  22 Oct 98 @DynTel-HXQ 2-680 replace the vtcomml bus data with the school bus data. 
C  11 Aug 98 @DynTel-MLA 2-000  Changed HDG and HDD names to conform to 
C            new naming conventions. 
C  20 Nov 96 DynTel@MLA 2-226 Expanded the arrays to accomodate the new Heavy 
C            Duty Gasoline, Heavy Duty Diesel, and LDGT vehicle categories. 
C 
C   7 Apr 97 DynTel@MLA 2-226  Expanded all the arrays - AMAR, JULMYR, REGMIX, 
C            TFNORM, VCOUNT, and VMTMIX - to accomodate the new BUS vehicle 
C            types. 
C 
C  23 Jul 98 @DynTel-MLA 2-000  Changed LDGT names to conform to 
C            certification naming conventions. 
C 
C  Common block array subscripts: 
C 
C  AMAR(25,28)   -  AMAR   ( JDX, IV ) 
C  JULMYR(25,16) -  JULMYR ( JDX, IV ) 
C  REGMIX(28)    -  REGMIX ( IV ) 
C  TFNORM(28)    -  TFNORM ( IV ) 
C  VCOUNT(39,28) -  VCOUNT ( ICY, IV ) 
C  VMTMIX(28)    -  VMTMIX ( IV ) 
C 
C  Common block dictionary: 
C 
C   Name   Type              Description 
C  ------  ----  ------------------------------------------------ 
C  /MYRSAV/: 
C 
C  NEWCUM   I    cumulative model year mileage recalculation flag 
C  AMAR     R    annual mileage accumulation rates 
C  JULMYR   R    July 1 registration (age) distributions 
C 
C  /VMXCOM/: 
C 
C  REGMIX   R    normalized registration mix (registration percentage by IV) 
C  TFNORM   R    for each IV, the sum across its 20 model year window of 
C                registrations times mileage accrual rate 
C  VCOUNT   R    vehicle count by calender year (ICY) and vehicle type (IV) 
C  VMTMIX   R    normalized vehicle miles traveled mix (vmt percentage by IV) 
C  VMTUSR   R    user input of daily VMT distribution by vehicle type (gas+diesel) 
C 
C  Local array subscripts: 
C 
C  V02MAR(25,2)  -  V02MAR (JDX, IV ) 
C  V04MAR(25,2)  -  V04MAR (JDX, IV ) 
C  V06MAR(25,2)  -  V06MAR (JDX, IV ) 
C  V08MAR(25,2)  -  V08MAR (JDX, IV ) 
C  V10MAR(25,2)  -  V10MAR (JDX, IV ) 
C  V12MAR(25,2)  -  V12MAR (JDX, IV ) 
C  V14MAR(25,2)  -  V14MAR (JDX, IV ) 
C  V16MAR(25,2)  -  V16MAR (JDX, IV ) 
C  V18MAR(25,2)  -  V18MAR (JDX, IV ) 
C  V20MAR(25,2)  -  V20MAR (JDX, IV ) 
C  V22MAR(25,2)  -  V22MAR (JDX, IV ) 
C  V24MAR(25,2)  -  V24MAR (JDX, IV ) 
C  V26MAR(25,2)  -  V26MAR (JDX, IV ) 
C  V28MAR(25,2)  -  V28MAR (JDX, IV ) 
C 
C  Local array dictionary: 
C 
C   Name   Type                Descriptions 
C  ------  ----  ------------------------------------------------------ 
C  JULMY1   R    july registration distributions 
C  JULMY2   R    july registration distributions 
C  V02MAR   R    annual mileage accumulation rates for LDGVs and LDGT1s 
C  V04MAR   R    annual mileage accumulation rates for LDGT2s and LDGT3s 
C  V06MAR   R    annual mileage accumulation rates for LDGT4s and HDGV2Bs 
C  V08MAR   R    annual mileage accumulation rates for HDGV3s and HDGV4s 
C  V10MAR   R    annual mileage accumulation rates for HDGV5s and HDGV6s 
C  V12MAR   R    annual mileage accumulation rates for HDGV7S and HDGV8As 
C  V14MAR   R    annual mileage accumulation rates for HDGV8BS and LDDVs 
C  V16MAR   R    annual mileage accumulation rates for LDDT12s and HDDV2Bs 
C  V18MAR   R    annual mileage accumulation rates for HDDV3s and HDDV4s 
C  V20MAR   R    annual mileage accumulation rates for HDDV5s and HDDV6s 
C  V22MAR   R    annual mileage accumulation rates for HDDV7s and HDDV8As 
C  V24MAR   R    annual mileage accumulation rates for HDDV8Bs and MCs 
C  V26MAR   R    annual mileage accumulation rates for HDGB and HDDBT 
C  V28MAR   R    annual mileage accumulation rates for HDDBS and LDDT34s 
C  VXXCOU   R    vehicle count by vehicle class (XX) same as VXXMAR. 
C 
C 
C  Notes: 
C 
C  The model year mileage recalculation flag "NEWCUM" is initialized here. 
C 
C 
      IMPLICIT NONE 
      INCLUDE 'MYRSAV.I' 
      INCLUDE 'VMXCOM.I' 
C 
      REAL JULMY1, JULMY2 
C 
      REAL V02MAR(25,2),V04MAR(25,2),V06MAR(25,2),V08MAR(25,2), 
     *          V10MAR(25,2),V12MAR(25,2),V14MAR(25,2),V16MAR(25,2), 
     *          V18MAR(25,2),V20MAR(25,2),V22MAR(25,2),V24MAR(25,2), 
     *          V26MAR(25,2),V28MAR(25,2) 
      DIMENSION JULMY1(25,8),JULMY2(25,8) 
      REAL V02COU(39,2),V04COU(39,2),V06COU(39,2),V08COU(39,2), 
     *          V10COU(39,2),V12COU(39,2),V14COU(39,2),V16COU(39,2) 
C 
      EQUIVALENCE 
     *(AMAR(1, 1),V02MAR(1,1)), 
     *(AMAR(1, 3),V04MAR(1,1)), 
     *(AMAR(1, 5),V06MAR(1,1)), 
     *(AMAR(1, 7),V08MAR(1,1)), 
     *(AMAR(1, 9),V10MAR(1,1)), 
     *(AMAR(1,11),V12MAR(1,1)), 
     *(AMAR(1,13),V14MAR(1,1)), 
     *(AMAR(1,15),V16MAR(1,1)), 
     *(AMAR(1,17),V18MAR(1,1)), 
     *(AMAR(1,19),V20MAR(1,1)), 
     *(AMAR(1,21),V22MAR(1,1)), 
     *(AMAR(1,23),V24MAR(1,1)), 
     *(AMAR(1,25),V26MAR(1,1)), 
     *(AMAR(1,27),V28MAR(1,1)) 
C 
      EQUIVALENCE 
     *(JULMYR(1, 1),JULMY1(1,1)), 
     *(JULMYR(1, 9),JULMY2(1,1)) 
C 
      EQUIVALENCE 
     *(VCOUNT(1, 1),V02COU(1,1)), 
     *(VCOUNT(1, 3),V04COU(1,1)), 
     *(VCOUNT(1, 5),V06COU(1,1)), 
     *(VCOUNT(1, 7),V08COU(1,1)), 
     *(VCOUNT(1, 9),V10COU(1,1)), 
     *(VCOUNT(1,11),V12COU(1,1)), 
     *(VCOUNT(1,13),V14COU(1,1)), 
     *(VCOUNT(1,15),V16COU(1,1)) 
C 
C  Initialize NEWCUM. 
C 
      DATA NEWCUM /1/ 
C 
C  Initialize REGMIX and TFNORM. 
C 
      DATA REGMIX,TFNORM /56*0.0/ 
C 
C  The vehicle miles traveled distribution by vehicle class. 
C  The vmt mix is either computed in TFCALX or supplied by user: 
C 
      DATA VMTMIX/ 28*0.0 / 
      DATA VMTUSR/ 16*0.0 / 
      DATA GLVMTMIX/ 16*0.0 / 
C 
C  Annual average mileage accumulation rates (divided by 100000) 
C 
      DATA V02MAR/ 
C  LDGV 
     *0.14910,0.14174,0.13475,0.12810,0.12178, 
     *0.11577,0.11006,0.10463,0.09947,0.09456, 
     *0.08989,0.08546,0.08124,0.07723,0.07342, 
     *0.06980,0.06636,0.06308,0.05997,0.05701, 
     *0.05420,0.05152,0.04898,0.04656,0.04427, 
C  LDGT1 
     *0.19496,0.18384,0.17308,0.16267,0.15260, 
     *0.14289,0.13352,0.12451,0.11584,0.10752, 
     *0.09955,0.09194,0.08467,0.07775,0.07118, 
     *0.06496,0.05909,0.05356,0.04839,0.04357, 
     *0.03909,0.03497,0.03120,0.02777,0.02470/ 
      DATA V04MAR/ 
C  LDGT2 
     *0.19496,0.18384,0.17308,0.16267,0.15260, 
     *0.14289,0.13352,0.12451,0.11584,0.10752, 
     *0.09955,0.09194,0.08467,0.07775,0.07118, 
     *0.06496,0.05909,0.05356,0.04839,0.04357, 
     *0.03909,0.03497,0.03120,0.02777,0.02470, 
C  LDGT3 
     *0.21331,0.19865,0.18500,0.17228,0.16044, 
     *0.14942,0.13915,0.12959,0.12068,0.11239, 
     *0.10466,0.09747,0.09077,0.08453,0.07872, 
     *0.07331,0.06827,0.06358,0.05921,0.05514, 
     *0.05135,0.04782,0.04454,0.04148,0.03863/ 
      DATA V06MAR/ 
C  LDGT4 
     *0.21331,0.19865,0.18500,0.17228,0.16044, 
     *0.14942,0.13915,0.12959,0.12068,0.11239, 
     *0.10466,0.09747,0.09077,0.08453,0.07872, 
     *0.07331,0.06827,0.06358,0.05921,0.05514, 
     *0.05135,0.04782,0.04454,0.04148,0.03863, 
C  HDGV2B 
     *0.19977,0.18779,0.17654,0.16596,0.15601, 
     *0.14666,0.13787,0.12961,0.12184,0.11454, 
     *0.10768,0.10122,0.09516,0.08946,0.08409, 
     *0.07905,0.07432,0.06986,0.06568,0.06174, 
     *0.05804,0.05456,0.05129,0.04822,0.04533/ 
      DATA V08MAR/ 
C  HDGV3 
     *0.19977,0.18779,0.17654,0.16596,0.15601, 
     *0.14666,0.13787,0.12961,0.12184,0.11454, 
     *0.10768,0.10122,0.09516,0.08946,0.08409, 
     *0.07905,0.07432,0.06986,0.06568,0.06174, 
     *0.05804,0.05456,0.05129,0.04822,0.04533, 
C HDGV4 
     *0.21394,0.19692,0.18125,0.16683,0.15356, 
     *0.14134,0.13010,0.11975,0.11022,0.10145, 
     *0.09338,0.08595,0.07911,0.07282,0.06703, 
     *0.06169,0.05679,0.05227,0.04811,0.04428, 
     *0.04076,0.03752,0.03453,0.03178,0.02926/ 
      DATA V10MAR/ 
C  HDGV5 
     *0.21394,0.19692,0.18125,0.16683,0.15356, 
     *0.14134,0.13010,0.11975,0.11022,0.10145, 
     *0.09338,0.08595,0.07911,0.07282,0.06703, 
     *0.06169,0.05679,0.05227,0.04811,0.04428, 
     *0.04076,0.03752,0.03453,0.03178,0.02926, 
C  HDGV6 
     *0.21394,0.19692,0.18125,0.16683,0.15356, 
     *0.14134,0.13010,0.11975,0.11022,0.10145, 
     *0.09338,0.08595,0.07911,0.07282,0.06703, 
     *0.06169,0.05679,0.05227,0.04811,0.04428, 
     *0.04076,0.03752,0.03453,0.03178,0.02926/ 
      DATA V12MAR/ 
C  HDGV7 
     *0.21394,0.19692,0.18125,0.16683,0.15356, 
     *0.14134,0.13010,0.11975,0.11022,0.10145, 
     *0.09338,0.08595,0.07911,0.07282,0.06703, 
     *0.06169,0.05679,0.05227,0.04811,0.04428, 
     *0.04076,0.03752,0.03453,0.03178,0.02926, 
C  HDGV8A 
     *0.21394,0.19692,0.18125,0.16683,0.15356, 
     *0.14134,0.13010,0.11975,0.11022,0.10145, 
     *0.09338,0.08595,0.07911,0.07282,0.06703, 
     *0.06169,0.05679,0.05227,0.04811,0.04428, 
     *0.04076,0.03752,0.03453,0.03178,0.02926/ 
      DATA V14MAR/ 
C  HDGV8B 
     *0.21394,0.19692,0.18125,0.16683,0.15356, 
     *0.14134,0.13010,0.11975,0.11022,0.10145, 
     *0.09338,0.08595,0.07911,0.07282,0.06703, 
     *0.06169,0.05679,0.05227,0.04811,0.04428, 
     *0.04076,0.03752,0.03453,0.03178,0.02926, 
C  LDDV 
     *0.14910,0.14174,0.13475,0.12810,0.12178, 
     *0.11577,0.11006,0.10463,0.09947,0.09456, 
     *0.08989,0.08546,0.08124,0.07723,0.07342, 
     *0.06980,0.06636,0.06308,0.05997,0.05701, 
     *0.05420,0.05152,0.04898,0.04656,0.04427/ 
      DATA V16MAR/ 
C LDDT12 
     *0.27059,0.24384,0.21973,0.19801,0.17843, 
     *0.16079,0.14490,0.13057,0.11766,0.10603, 
     *0.09555,0.08610,0.07759,0.06992,0.06301, 
     *0.05678,0.05116,0.04610,0.04155,0.03744, 
     *0.03374,0.03040,0.02740,0.02469,0.02225, 
C HDDV2B 
     *0.27137,0.24831,0.22721,0.20791,0.19024, 
     *0.17407,0.15928,0.14575,0.13336,0.12203, 
     *0.11166,0.10217,0.09349,0.08555,0.07828, 
     *0.07163,0.06554,0.05997,0.05488,0.05021, 
     *0.04595,0.04204,0.03847,0.03520,0.03221/ 
      DATA V18MAR/ 
C HDDV3 
     *0.32751,0.28984,0.25650,0.22699,0.20088, 
     *0.17778,0.15733,0.13923,0.12321,0.10904, 
     *0.09650,0.08540,0.07557,0.06688,0.05919, 
     *0.05238,0.04635,0.04102,0.03630,0.03213, 
     *0.02843,0.02516,0.02227,0.01971,0.01744, 
C HDDV4 
     *0.30563,0.28622,0.26805,0.25103,0.23509, 
     *0.22016,0.20618,0.19309,0.18083,0.16935, 
     *0.15860,0.14853,0.13910,0.13026,0.12199, 
     *0.11425,0.10699,0.10020,0.09384,0.08788, 
     *0.08230,0.07707,0.07218,0.06760,0.06331/ 
      DATA V20MAR/ 
C HDDV5 
     *0.30563,0.28622,0.26805,0.25103,0.23509, 
     *0.22016,0.20618,0.19309,0.18083,0.16935, 
     *0.15860,0.14853,0.13910,0.13026,0.12199, 
     *0.11425,0.10699,0.10020,0.09384,0.08788, 
     *0.08230,0.07707,0.07218,0.06760,0.06331, 
C HDDV6 
     *0.40681,0.36872,0.33420,0.30291,0.27455, 
     *0.24885,0.22555,0.20443,0.18529,0.16795, 
     *0.15222,0.13797,0.12505,0.11335,0.10273, 
     *0.09312,0.08440,0.07650,0.06933,0.06284, 
     *0.05696,0.05163,0.04679,0.04241,0.03844/ 
      DATA V22MAR/ 
C HDDV7 
     *0.40681,0.36872,0.33420,0.30291,0.27455, 
     *0.24885,0.22555,0.20443,0.18529,0.16795, 
     *0.15222,0.13797,0.12505,0.11335,0.10273, 
     *0.09312,0.08440,0.07650,0.06933,0.06284, 
     *0.05696,0.05163,0.04679,0.04241,0.03844, 
C HDDT8A 
     *0.87821,0.78257,0.69735,0.62141,0.55374, 
     *0.49343,0.43970,0.39181,0.34915,0.31112, 
     *0.27724,0.24705,0.22015,0.19617,0.17481, 
     *0.15577,0.13881,0.12369,0.11022,0.09822, 
     *0.08752,0.07799,0.06950,0.06193,0.05518/ 
      DATA V24MAR/ 
C HDDT8B 
     *1.24208,1.12590,1.02060,0.92514,0.83861, 
     *0.76017,0.68907,0.62462,0.56620,0.51324, 
     *0.46523,0.42172,0.38228,0.34652,0.31411, 
     *0.28473,0.25810,0.23396,0.21208,0.19224, 
     *0.17426,0.15796,0.14319,0.12979,0.11765, 
C    MC 
     *0.04786,0.04475,0.04164,0.03853,0.03543, 
     *0.03232,0.02921,0.02611,0.02300,0.01989, 
     *0.01678,0.01368,0.01368,0.01368,0.01368, 
     *0.01368,0.01368,0.01368,0.01368,0.01368, 
     *0.01368,0.01368,0.01368,0.01368,0.01368/ 
      DATA V26MAR/ 
C HDGB 
     *0.09939,0.09939,0.09939,0.09939,0.09939, 
     *0.09939,0.09939,0.09939,0.09939,0.09939, 
     *0.09939,0.09939,0.09939,0.09939,0.09939, 
     *0.09939,0.09939,0.09939,0.09939,0.09939, 
     *0.09939,0.09939,0.09939,0.09939,0.09939, 
C HDDBT 
     *0.45171,0.43731,0.42337,0.40987,0.39681, 
     *0.38416,0.37191,0.36005,0.34857,0.33746, 
     *0.32670,0.31629,0.30620,0.29644,0.28699, 
     *0.27784,0.26898,0.26041,0.25211,0.24407, 
     *0.23629,0.22875,0.22146,0.21440,0.20757/ 
      DATA V28MAR/ 
C HDDBS 
     *0.09939,0.09939,0.09939,0.09939,0.09939, 
     *0.09939,0.09939,0.09939,0.09939,0.09939, 
     *0.09939,0.09939,0.09939,0.09939,0.09939, 
     *0.09939,0.09939,0.09939,0.09939,0.09939, 
     *0.09939,0.09939,0.09939,0.09939,0.09939, 
C LDDT34 
     *0.26040,0.24018,0.22154,0.20434,0.18848, 
     *0.17385,0.16036,0.14791,0.13643,0.12584, 
     *0.11607,0.10706,0.09875,0.09109,0.08402, 
     *0.07749,0.07148,0.06593,0.06081,0.05609, 
     *0.05174,0.04772,0.04402,0.04060,0.03745/ 
C 
C  Vehicle registration (age) distributions (as of July) 
C 
      DATA JULMY1/ 
C  LDV 
     *0.0530,0.0706,0.0706,0.0705,0.0703,0.0698,0.0689,0.0676, 
     *0.0655,0.0627,0.0588,0.0539,0.0458,0.0363,0.0288,0.0228, 
     *0.0181,0.0144,0.0114,0.0090,0.0072,0.0057,0.0045,0.0036,0.0103, 
C  LDT1 
     *0.0581,0.0774,0.0769,0.0760,0.0745,0.0723,0.0693,0.0656, 
     *0.0610,0.0557,0.0498,0.0436,0.0372,0.0309,0.0249,0.0195, 
     *0.0147,0.0107,0.0085,0.0081,0.0078,0.0075,0.0072,0.0069,0.0360, 
C  LDT2 
     *0.0581,0.0774,0.0769,0.0760,0.0745,0.0723,0.0693,0.0656, 
     *0.0610,0.0557,0.0498,0.0436,0.0372,0.0309,0.0249,0.0195, 
     *0.0147,0.0107,0.0085,0.0081,0.0078,0.0075,0.0072,0.0069,0.0360, 
C  LDT3 
     *0.0594,0.0738,0.0688,0.0640,0.0597,0.0556,0.0518,0.0482, 
     *0.0449,0.0419,0.0390,0.0363,0.0338,0.0315,0.0294,0.0274, 
     *0.0255,0.0237,0.0221,0.0206,0.0192,0.0179,0.0167,0.0155,0.0732, 
C  LDT4 
     *0.0594,0.0738,0.0688,0.0640,0.0597,0.0556,0.0518,0.0482, 
     *0.0449,0.0419,0.0390,0.0363,0.0338,0.0315,0.0294,0.0274, 
     *0.0255,0.0237,0.0221,0.0206,0.0192,0.0179,0.0167,0.0155,0.0732, 
C  HDV2B 
     *0.0503,0.0916,0.0833,0.0758,0.0690,0.0627,0.0571,0.0519, 
     *0.0472,0.0430,0.0391,0.0356,0.0324,0.0294,0.0268,0.0244, 
     *0.0222,0.0202,0.0184,0.0167,0.0152,0.0138,0.0126,0.0114,0.0499, 
C  HDV3 
     *0.0503,0.0916,0.0833,0.0758,0.0690,0.0627,0.0571,0.0519, 
     *0.0472,0.0430,0.0391,0.0356,0.0324,0.0294,0.0268,0.0244, 
     *0.0222,0.0202,0.0184,0.0167,0.0152,0.0138,0.0126,0.0114,0.0499, 
C  HDV4 
     *0.0388,0.0726,0.0679,0.0635,0.0594,0.0556,0.0520,0.0486, 
     *0.0455,0.0425,0.0398,0.0372,0.0348,0.0326,0.0304,0.0285, 
     *0.0266,0.0249,0.0233,0.0218,0.0204,0.0191,0.0178,0.0167,0.0797/ 
      DATA JULMY2/ 
C  HDV5 
     *0.0388,0.0726,0.0679,0.0635,0.0594,0.0556,0.0520,0.0486, 
     *0.0455,0.0425,0.0398,0.0372,0.0348,0.0326,0.0304,0.0285, 
     *0.0266,0.0249,0.0233,0.0218,0.0204,0.0191,0.0178,0.0167,0.0797, 
C  HDV6 
     *0.0388,0.0726,0.0679,0.0635,0.0594,0.0556,0.0520,0.0486, 
     *0.0455,0.0425,0.0398,0.0372,0.0348,0.0326,0.0304,0.0285, 
     *0.0266,0.0249,0.0233,0.0218,0.0204,0.0191,0.0178,0.0167,0.0797, 
C  HDV7 
     *0.0388,0.0726,0.0679,0.0635,0.0594,0.0556,0.0520,0.0486, 
     *0.0455,0.0425,0.0398,0.0372,0.0348,0.0326,0.0304,0.0285, 
     *0.0266,0.0249,0.0233,0.0218,0.0204,0.0191,0.0178,0.0167,0.0797, 
C  HDV8A 
     *0.0388,0.0726,0.0679,0.0635,0.0594,0.0556,0.0520,0.0486, 
     *0.0455,0.0425,0.0398,0.0372,0.0348,0.0326,0.0304,0.0285, 
     *0.0266,0.0249,0.0233,0.0218,0.0204,0.0191,0.0178,0.0167,0.0797, 
C  HDV8B 
     *0.0388,0.0726,0.0679,0.0635,0.0594,0.0556,0.0520,0.0486, 
     *0.0455,0.0425,0.0398,0.0372,0.0348,0.0326,0.0304,0.0285, 
     *0.0266,0.0249,0.0233,0.0218,0.0204,0.0191,0.0178,0.0167,0.0797, 
C  HDBS (School Bus) 
     *0.0393,0.0734,0.0686,0.0641,0.0599,0.0559,0.0522,0.0488, 
     *0.0456,0.0426,0.0398,0.0372,0.0347,0.0324,0.0303,0.0283, 
     *0.0264,0.0247,0.0231,0.0216,0.0201,0.0188,0.0176,0.0164,0.0781, 
C  HDBT (Transit Bus) 
     *0.0307,0.0614,0.0614,0.0614,0.0614,0.0614,0.0614,0.0614, 
     *0.0614,0.0613,0.0611,0.0607,0.0595,0.0568,0.0511,0.0406, 
     *0.0254,0.0121,0.0099,0.0081,0.0066,0.0054,0.0044,0.0037,0.0115, 
C  MC 
     *0.1440,0.1680,0.1350,0.1090,0.0880,0.0700,0.0560,0.0450, 
     *0.0360,0.0290,0.0230,0.0970,0.0000,0.0000,0.0000,0.0000, 
     *0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000/ 
C 
C VCOUNT - is the vehicle count by vehicle class (IV), scaled by / 10**6. 
C 
C Calender Years run from 1982 to 2020, 39 Calender Years total. 
C 1982 Vcounts are used for all pre-1982 Vehicles Counts 
C 2020 Vcounts are used for all post-2020 Vehicles Counts 
C IV = 24 (MC) Motor Cycles is a constant 4.219 in all calendar years. 
C 
C  LDV 
      DATA V02COU/ 
     * 106.867, 108.960, 112.018, 114.662, 117.268, 119.849, 121.519, 
     * 122.758, 124.658, 123.917, 123.176, 122.436, 121.695, 120.954, 
     * 120.213, 118.774, 117.096, 115.194, 113.163, 112.067, 110.950, 
     * 109.439, 107.899, 105.955, 103.575, 101.041,  98.431,  96.043, 
     *  93.587,  91.291,  89.345,  87.504,  85.918,  84.384,  82.972, 
     *  81.806,  80.793,  79.950,  79.436, 
C  LDT1 
     *   4.801,  4.857,  5.066,  5.337,  5.677,  6.006,  6.343, 
     *   6.760,  7.059,  7.496,  7.933,  8.369,  8.806,  9.243, 
     *   9.566, 10.415, 11.280, 12.163, 13.071, 13.799, 14.512, 
     *  15.275, 16.026, 16.685, 17.411, 18.156, 18.906, 19.613, 
     *  20.229, 20.817, 21.346, 21.857, 22.324, 22.696, 23.052, 
     *  23.372, 23.670, 23.944, 24.166/ 
C  LDT2 
      DATA V04COU/ 
     *  15.984, 16.169, 16.864, 17.765, 18.897, 19.996, 21.117, 
     *  22.504, 23.499, 24.953, 26.408, 27.862, 29.316, 30.770, 
     *  31.846, 34.670, 37.553, 40.490, 43.513, 45.938, 48.312, 
     *  50.850, 53.349, 55.544, 57.961, 60.440, 62.939, 65.292, 
     *  67.342, 69.301, 71.061, 72.762, 74.318, 75.555, 76.741, 
     *  77.804, 78.797, 79.709, 80.448, 
C  LDT3 
     *  6.970,  7.154,  7.495,  7.677,  8.142,  8.481,  9.160, 
     *  9.549,  9.640,  9.662,  9.684,  9.707,  9.729,  9.751, 
     *  10.111, 11.008, 11.923, 12.856, 13.815, 14.585, 15.339, 
     *  16.145, 16.938, 17.635, 18.403, 19.190, 19.983, 20.730, 
     *  21.381, 22.003, 22.562, 23.102, 23.596, 23.989, 24.365, 
     *  24.703, 25.018, 25.308, 25.542/ 
C  LDT4 
      DATA  V06COU/ 
     *   3.205,  3.290,  3.447,  3.530,  3.744,  3.900,  4.212, 
     *   4.391,  4.433,  4.443,  4.453,  4.464,  4.474,  4.484, 
     *   4.650,  5.062,  5.483,  5.912,  6.353,  6.707,  7.054, 
     *   7.424,  7.789,  8.110,  8.463,  8.825,  9.189,  9.533, 
     *   9.832, 10.118, 10.375, 10.624, 10.851, 11.031, 11.204, 
     *  11.360, 11.505, 11.638, 11.746, 
C  HDV2B 
     *  3.025,  3.350,  3.650,  4.057,  4.201,  4.498,  4.715, 
     *  5.018,  5.173,  5.307,  5.440,  5.573,  5.706,  5.839, 
     *  5.973,  6.235,  6.496,  6.755,  6.929,  7.103,  7.278, 
     *  7.453,  7.628,  7.730,  7.835,  7.943,  8.055,  8.169, 
     *  8.226,  8.290,  8.359,  8.433,  8.512,  8.553,  8.602, 
     *  8.656,  8.717,  8.782,  8.853/ 
C  HDV3 
      DATA V08COU/ 
     *  0.268,  0.297,  0.323,  0.359,  0.372,  0.398,  0.417, 
     *  0.444,  0.458,  0.470,  0.481,  0.493,  0.505,  0.517, 
     *  0.529,  0.552,  0.575,  0.598,  0.613,  0.629,  0.644, 
     *  0.660,  0.675,  0.684,  0.693,  0.703,  0.713,  0.723, 
     *  0.728,  0.734,  0.740,  0.746,  0.753,  0.757,  0.761, 
     *  0.766,  0.771,  0.777,  0.784, 
C  HDV4 
     *  0.198,  0.220,  0.239,  0.266,  0.275,  0.295,  0.309, 
     *  0.329,  0.339,  0.348,  0.357,  0.365,  0.374,  0.383, 
     *  0.391,  0.409,  0.426,  0.443,  0.454,  0.466,  0.477, 
     *  0.488,  0.500,  0.507,  0.513,  0.521,  0.528,  0.535, 
     *  0.539,  0.543,  0.548,  0.553,  0.558,  0.561,  0.564, 
     *  0.567,  0.571,  0.576,  0.580/ 
C  HDV5 
      DATA V10COU/ 
     *  0.177,  0.196,  0.213,  0.237,  0.245,  0.263,  0.275, 
     *  0.293,  0.302,  0.310,  0.317,  0.325,  0.333,  0.341, 
     *  0.349,  0.364,  0.379,  0.394,  0.404,  0.415,  0.425, 
     *  0.435,  0.445,  0.451,  0.457,  0.464,  0.470,  0.477, 
     *  0.480,  0.484,  0.488,  0.492,  0.497,  0.499,  0.502, 
     *  0.505,  0.509,  0.513,  0.517, 
C  HDV6 
     *  0.552,  0.611,  0.666,  0.740,  0.766,  0.820,  0.860, 
     *  0.915,  0.943,  0.968,  0.992,  1.016,  1.041,  1.065, 
     *  1.089,  1.137,  1.184,  1.232,  1.263,  1.295,  1.327,   
     *  1.359,  1.391,  1.409,  1.429,  1.448,  1.469,  1.490, 
     *  1.500,  1.512,  1.524,  1.538,  1.552,  1.560,  1.568, 
     *  1.578,  1.589,  1.601,  1.614/ 
C  HDV7 
      DATA V12COU/ 
     *  0.581,  0.644,  0.701,  0.780,  0.807,  0.864,  0.906, 
     *  0.964,  0.994,  1.020,  1.045,  1.071,  1.097,  1.122,                                     
     *  1.148,  1.198,  1.248,  1.298,  1.332,  1.365,  1.399, 
     *  1.432,  1.466,  1.485,  1.506,  1.526,  1.548,  1.570, 
     *  1.581,  1.593,  1.606,  1.621,  1.636,  1.644,  1.653, 
     *  1.663,  1.675,  1.688,  1.701, 
C  HDV8A 
     *  0.299,  0.331,  0.361,  0.401,  0.415,  0.444,  0.466, 
     *  0.496,  0.511,  0.524,  0.537,  0.550,  0.564,  0.577, 
     *  0.590,  0.616,  0.642,  0.667,  0.684,  0.702,  0.719, 
     *  0.736,  0.753,  0.763,  0.774,  0.784,  0.795,  0.807, 
     *  0.812,  0.819,  0.826,  0.833,  0.841,  0.845,  0.850, 
     *  0.855,  0.861,  0.867,  0.874/  
C  HDV8B 
      DATA V14COU/ 
     *  0.689,  0.763,  0.831,  0.924,  0.957,  1.025,  1.074, 
     *  1.143,  1.178,  1.209,  1.239,  1.269,  1.300,  1.330, 
     *  1.360,  1.420,  1.479,  1.539,  1.578,  1.618,  1.658, 
     *  1.697,  1.737,  1.761,  1.784,  1.809,  1.835,  1.861, 
     *  1.874,  1.888,  1.904,  1.921,  1.939,  1.948,  1.959, 
     *  1.972,  1.985,  2.000,  2.016, 
C  HDBS 
     *  0.210,  0.232,  0.253,  0.281,  0.291,  0.312,  0.327, 
     *  0.348,  0.358,  0.368,  0.377,  0.386,  0.395,  0.405, 
     *  0.414,  0.432,  0.450,  0.468,  0.480,  0.492,  0.504, 
     *  0.516,  0.529,  0.536,  0.543,  0.550,  0.558,  0.566, 
     *  0.570,  0.574,  0.579,  0.584,  0.590,  0.593,  0.596, 
     *  0.600,  0.604,  0.608,  0.613/ 
      DATA V16COU/ 
C  HDDBT 
     *  0.028,  0.031,  0.034,  0.038,  0.039,  0.042,  0.044, 
     *  0.047,  0.048,  0.050,  0.051,  0.052,  0.053,  0.055, 
     *  0.056,  0.058,  0.061,  0.063,  0.065,  0.066,  0.068, 
     *  0.070,  0.071,  0.072,  0.073,  0.074,  0.075,  0.076, 
     *  0.077,  0.078,  0.078,  0.079,  0.080,  0.080,  0.080, 
     *  0.081,  0.082,  0.082,  0.083, 
C  MC 
     *  4.219,  4.219,  4.219,  4.219,  4.219,  4.219,  4.219, 
     *  4.219,  4.219,  4.219,  4.219,  4.219,  4.219,  4.219, 
     *  4.219,  4.219,  4.219,  4.219,  4.219,  4.219,  4.219, 
     *  4.219,  4.219,  4.219,  4.219,  4.219,  4.219,  4.219, 
     *  4.219,  4.219,  4.219,  4.219,  4.219,  4.219,  4.219, 
     *  4.219,  4.219,  4.219,  4.219/ 
C 
      END 
