      BLOCK DATA BD28
C
C  BLOCK DATA Subprogram 28: /RLCOM1/,/RLCOM2/,/RLCOM3/
C
C  BLOCK DATA 28 defines the refueling loss HC emission factor common blocks.
C
C  Changes: (Last change first)
C
C 20 Aug 02 AIR Task 37: Updated data to values supplied in AIR Task 37.csv
C 15 Jan 02 AIR Task 27: Updated data to values supplied in MPG1.CSV and
C                        reformatted to get around Lahey Compiler bugs.
C 06 Nov 01 AIR Task 27: Updated all road fuel economies.
C 26 Feb 01 @EPA-djb Added HDGV2b to the ORVR arrays (OBIPY & OBPIP).
C 19 Oct 00 - @EPA-bag    Removed obsolete IOBMY and IVOB
C   2 Jun 99 @DynTel-MLA 2-694  Removed obsolete variable OBDF.
C  19 Feb 99 @DynTel-ddj 2-696 Added hourly indices to RLRATE.
C  11 Aug 98 @DynTel-MLA 2-000  Changed HDG and HDD names to conform to
C            new naming conventions.
C
C  Common block array subscripts:
C
C  RLRATE(25,14,24) -  RLRATE ( IDX, IVTAM, IH )
C  ROADFE(99,28,2)  -  ROADFE ( MDX, IV, IM6U )
C  S2EFF(14)        -  S2EFF  ( IVTAM )
C
C  Common block dictionary:
C
C   Name   Tlied parameters for refueling loss calculation
C
C  ROADFE   R    road fuel economy rates, in miles per gallon, supplied via
C                MOBILE6 (IM6U=1), or by the user (IM6U=2). MY1952-2050.
C  DISPL    R    HC displacement component of refueling loss, in GPG.
C  SPILL    R    HC spillage component of refueling loss, in GPG.
C  OBED     R    Onboard VRS displacement loss reduction efficiency percentage
C  OBES     R    Onboard VRS spillage loss reduction efficiency percentage
C  OBPIY    I    Onboard VRS phase-in years
C  OBPIP    R    Onboard VRS phase-in percentages
C  MPGFLAG  L    False=Use default MOBILE6 MPG, True=Use User-supplied MPG data
C
C  /RLCOM2/ user supplied parameters for refueling loss calculation:
C
C  IS2SY    I    Stage II vrs controls start year.
C  NPHASE   I    Number of years in the phase-in period of Stage II vrs
C                controls.
C  S2EFF    R    Stage II effciency = percentage of refueling losses removed
C                by S2 installation, assuming 100% installation.
C
C  /RLCOM3/ calculated refueling loss rates for current scenario:
C
C  RLRATE   R    refueling loss HC rates for current scenario, as determined by
C                subprogram REFUEL.  The loss rates are weighted by ICY's
C                corresponding TF's and summed to get a scenario's REFL_GM_MI.
C
C  Notes:
C
C    5-May-1994 @ CSC-tmm request 2-411
C       Added data items to handle phase-in of onboard fuel recovery systems
C
C  11 Jun 97 DynTel@MLA 2-622  Modified the arrays to accomodate the new
C            vehicle types that were introduced in Mobile6.
C
C 23 Jul 98 @DynTel-MLA 2-000  Changed LDGT names to conform to
C           certification naming conventions.
C
C
C  The MDX mapping to MY for ROADFE is: 1=1952-, 99=2050+
C
      IMPLICIT NONE
      INCLUDE 'PARAME.I'
      INCLUDE 'RLCOM1.I'
      INCLUDE 'RLCOM2.I'
      INCLUDE 'RLCOM3.I'
C
      REAL ROADFE01(99), ROADFE02(99), ROADFE03(99), ROADFE04(99)
      REAL ROADFE05(99), ROADFE06(99), ROADFE07(99), ROADFE08(99)
      REAL ROADFE09(99), ROADFE10(99), ROADFE11(99), ROADFE12(99)
      REAL ROADFE13(99), ROADFE14(99), ROADFE15(99), ROADFE16(99)
      REAL ROADFE17(99), ROADFE18(99), ROADFE19(99), ROADFE20(99)
      REAL ROADFE21(99), ROADFE22(99), ROADFE23(99), ROADFE24(99)
      REAL ROADFE25(99), ROADFE26(99), ROADFE27(99), ROADFE28(99)
C
      EQUIVALENCE 
     *  (ROADFE(1, 1,1),ROADFE01(1)), (ROADFE(1, 2,1),ROADFE02(1)),
     *  (ROADFE(1, 3,1),ROADFE03(1)), (ROADFE(1, 4,1),ROADFE04(1)),
     *  (ROADFE(1, 5,1),ROADFE05(1)), (ROADFE(1, 6,1),ROADFE06(1)),
     *  (ROADFE(1, 7,1),ROADFE07(1)), (ROADFE(1, 8,1),ROADFE08(1)),
     *  (ROADFE(1, 9,1),ROADFE09(1)), (ROADFE(1,10,1),ROADFE10(1)),
     *  (ROADFE(1,11,1),ROADFE11(1)), (ROADFE(1,12,1),ROADFE12(1)),
     *  (ROADFE(1,13,1),ROADFE13(1)), (ROADFE(1,14,1),ROADFE14(1)),
     *  (ROADFE(1,15,1),ROADFE15(1)), (ROADFE(1,16,1),ROADFE16(1)),
     *  (ROADFE(1,17,1),ROADFE17(1)), (ROADFE(1,18,1),ROADFE18(1)),
     *  (ROADFE(1,19,1),ROADFE19(1)), (ROADFE(1,20,1),ROADFE20(1)),
     *  (ROADFE(1,21,1),ROADFE21(1)), (ROADFE(1,22,1),ROADFE22(1)),
     *  (ROADFE(1,23,1),ROADFE23(1)), (ROADFE(1,24,1),ROADFE24(1)),
     *  (ROADFE(1,25,1),ROADFE25(1)), (ROADFE(1,26,1),ROADFE26(1)),
     *  (ROADFE(1,27,1),ROADFE27(1)), (ROADFE(1,28,1),ROADFE28(1))
C
C  /RLCOM1/:
C
C  Road fuel economy by vehicle class, MY1952-2050
C
C  LDGV    0     1     2     3     4     5     6     7     8     9      MY          
      DATA ROADFE01/
     *             13.40,13.40,13.40,13.40,13.40,13.40,13.40,13.40, ! 1952-59
     * 13.40,13.40,13.40,13.40,13.40,13.40,13.40,13.40,13.40,13.40, ! 1960-69
     * 13.40,13.40,13.40,13.40,13.40,13.40,14.80,15.50,16.80,17.10, ! 1970-79
     * 19.80,21.20,22.00,21.90,22.20,22.90,23.70,23.80,24.30,23.90, ! 1980-89
     * 23.60,23.80,23.50,24.00,23.90,24.10,24.10,24.20,24.30,24.00, ! 1990-99
     * 24.10,24.10,24.10,24.10,24.10,24.10,24.10,24.10,24.10,24.10, ! 2000-09
     * 24.10,24.10,24.10,24.10,24.10,24.10,24.10,24.10,24.10,24.10, ! 2010-19
     * 24.10,24.10,24.10,24.10,24.10,24.10,24.10,24.10,24.10,24.10, ! 2020-29
     * 24.10,24.10,24.10,24.10,24.10,24.10,24.10,24.10,24.10,24.10, ! 2030-39
     * 24.10,24.10,24.10,24.10,24.10,24.10,24.10,24.10,24.10,24.10, ! 2040-49
     * 24.10/                                                       ! 2050
C
C  LDGT1   0     1     2     3     4     5     6     7     8     9      MY
      DATA ROADFE02/
     *             12.00,12.00,12.00,12.00,12.00,12.00,12.00,12.00, ! 1952-59
     * 12.00,12.00,12.00,12.00,12.00,12.00,12.00,12.00,12.00,12.00, ! 1960-69
     * 12.00,12.00,12.00,12.00,12.00,12.00,13.00,14.20,13.90,13.40, ! 1970-79
     * 16.80,18.00,18.30,18.90,18.60,18.70,19.60,19.70,19.30,19.10, ! 1980-89
     * 18.90,19.40,19.00,19.10,18.90,18.70,19.00,18.80,19.00,18.70, ! 1990-99
     * 18.70,18.50,18.50,18.50,18.50,18.50,18.50,18.50,18.50,18.50, ! 2000-09
     * 18.50,18.50,18.50,18.50,18.50,18.50,18.50,18.50,18.50,18.50, ! 2010-19
     * 18.50,18.50,18.50,18.50,18.50,18.50,18.50,18.50,18.50,18.50, ! 2020-29
     * 18.50,18.50,18.50,18.50,18.50,18.50,18.50,18.50,18.50,18.50, ! 2030-39
     * 18.50,18.50,18.50,18.50,18.50,18.50,18.50,18.50,18.50,18.50, ! 2040-49
     * 18.50/                                                       ! 2050
C
C  LDGT2   0     1     2     3     4     5     6     7     8     9      MY
      DATA ROADFE03/
     *             12.00,12.00,12.00,12.00,12.00,12.00,12.00,12.00, ! 1952-59
     * 12.00,12.00,12.00,12.00,12.00,12.00,12.00,12.00,12.00,12.00, ! 1960-69
     * 12.00,12.00,12.00,12.00,12.00,12.00,13.00,14.20,13.90,13.40, ! 1970-79
     * 16.80,18.00,18.30,18.90,18.60,18.70,19.60,19.70,19.30,19.10, ! 1980-89
     * 18.90,19.40,19.00,19.10,18.90,18.70,19.00,18.80,19.00,18.70, ! 1990-99
     * 18.70,18.50,18.50,18.50,18.50,18.50,18.50,18.50,18.50,18.50, ! 2000-09
     * 18.50,18.50,18.50,18.50,18.50,18.50,18.50,18.50,18.50,18.50, ! 2010-19
     * 18.50,18.50,18.50,18.50,18.50,18.50,18.50,18.50,18.50,18.50, ! 2020-29
     * 18.50,18.50,18.50,18.50,18.50,18.50,18.50,18.50,18.50,18.50, ! 2030-39
     * 18.50,18.50,18.50,18.50,18.50,18.50,18.50,18.50,18.50,18.50, ! 2040-49
     * 18.50/                                                       ! 2050
C
C  LDGT3   0     1     2     3     4     5     6     7     8     9      MY
      DATA ROADFE04/
     *              9.30, 9.30, 9.30, 9.30, 9.30, 9.30, 9.30, 9.30, ! 1952-59
     *  9.30, 9.30, 9.30, 9.30, 9.30, 9.30, 9.30, 9.30, 9.30, 9.30, ! 1960-69
     *  9.30, 9.30, 9.30, 9.30, 9.30, 9.30,10.00,10.90,10.70,10.30, ! 1970-79
     * 12.90,13.80,14.10,14.50,14.30,14.40,15.00,15.20,14.80,14.70, ! 1980-89
     * 14.60,14.90,14.60,14.70,14.60,14.40,14.60,14.50,14.60,14.40, ! 1990-99
     * 14.40,14.20,14.20,14.20,14.20,14.20,14.20,14.20,14.20,14.20, ! 2000-09
     * 14.20,14.20,14.20,14.20,14.20,14.20,14.20,14.20,14.20,14.20, ! 2010-19
     * 14.20,14.20,14.20,14.20,14.20,14.20,14.20,14.20,14.20,14.20, ! 2020-29
     * 14.20,14.20,14.20,14.20,14.20,14.20,14.20,14.20,14.20,14.20, ! 2030-39
     * 14.20,14.20,14.20,14.20,14.20,14.20,14.20,14.20,14.20,14.20, ! 2040-49
     * 14.20/                                                       ! 2050
C
C  LDGT4   0     1     2     3     4     5     6     7     8     9      MY          
      DATA ROADFE05/
     *              9.30, 9.30, 9.30, 9.30, 9.30, 9.30, 9.30, 9.30, ! 1952-59
     *  9.30, 9.30, 9.30, 9.30, 9.30, 9.30, 9.30, 9.30, 9.30, 9.30, ! 1960-69
     *  9.30, 9.30, 9.30, 9.30, 9.30, 9.30,10.00,10.90,10.70,10.30, ! 1970-79
     * 12.90,13.80,14.10,14.50,14.30,14.40,15.00,15.20,14.80,14.70, ! 1980-89
     * 14.60,14.90,14.60,14.70,14.60,14.40,14.60,14.50,14.60,14.40, ! 1990-99
     * 14.40,14.20,14.20,14.20,14.20,14.20,14.20,14.20,14.20,14.20, ! 2000-09
     * 14.20,14.20,14.20,14.20,14.20,14.20,14.20,14.20,14.20,14.20, ! 2010-19
     * 14.20,14.20,14.20,14.20,14.20,14.20,14.20,14.20,14.20,14.20, ! 2020-29
     * 14.20,14.20,14.20,14.20,14.20,14.20,14.20,14.20,14.20,14.20, ! 2030-39
     * 14.20,14.20,14.20,14.20,14.20,14.20,14.20,14.20,14.20,14.20, ! 2040-49
     * 14.20/                                                       ! 2050
C
C  HDGV2B  0     1     2     3     4     5     6     7     8     9      MY
      DATA ROADFE06/
     *              8.81, 8.81, 8.81, 8.81, 8.81, 8.81, 8.81, 8.81, ! 1952-59
     *  8.81, 8.81, 8.81, 8.81, 8.81, 8.81, 8.81, 8.81, 8.81, 8.81, ! 1960-69
     *  8.81, 8.81, 8.81, 8.81, 8.81, 8.81, 8.81, 8.81, 8.81, 8.81, ! 1970-79
     *  8.81, 8.81, 8.81, 8.81, 8.91, 9.01, 9.11, 9.22, 9.32, 9.42, ! 1980-89
     *  9.52, 9.62, 9.73, 9.83, 9.93,10.03,10.13,10.13,10.13,10.13, ! 1990-99
     * 10.13,10.13,10.13,10.13,10.13,10.13,10.13,10.13,10.13,10.13, ! 2000-09
     * 10.13,10.13,10.13,10.13,10.13,10.13,10.13,10.13,10.13,10.13, ! 2010-19
     * 10.13,10.13,10.13,10.13,10.13,10.13,10.13,10.13,10.13,10.13, ! 2020-29
     * 10.13,10.13,10.13,10.13,10.13,10.13,10.13,10.13,10.13,10.13, ! 2030-39
     * 10.13,10.13,10.13,10.13,10.13,10.13,10.13,10.13,10.13,10.13, ! 2040-49
     * 10.13/                                                       ! 2050
C
C  HDGV3   0     1     2     3     4     5     6     7     8     9      MY
      DATA ROADFE07/        
     *              8.16, 8.16, 8.16, 8.16, 8.16, 8.16, 8.16, 8.16, ! 1952-59
     *  8.16, 8.16, 8.16, 8.16, 8.16, 8.16, 8.16, 8.16, 8.16, 8.16, ! 1960-69
     *  8.16, 8.16, 8.16, 8.16, 8.16, 8.16, 8.16, 8.16, 8.16, 8.16, ! 1970-79
     *  8.16, 8.16, 8.16, 8.16, 8.26, 8.35, 8.45, 8.54, 8.63, 8.73, ! 1980-89
     *  8.82, 8.92, 9.01, 9.11, 9.20, 9.30, 9.39, 9.39, 9.39, 9.39, ! 1990-99
     *  9.39, 9.39, 9.39, 9.39, 9.39, 9.39, 9.39, 9.39, 9.39, 9.39, ! 2000-09
     *  9.39, 9.39, 9.39, 9.39, 9.39, 9.39, 9.39, 9.39, 9.39, 9.39, ! 2010-19
     *  9.39, 9.39, 9.39, 9.39, 9.39, 9.39, 9.39, 9.39, 9.39, 9.39, ! 2020-29
     *  9.39, 9.39, 9.39, 9.39, 9.39, 9.39, 9.39, 9.39, 9.39, 9.39, ! 2030-39
     *  9.39, 9.39, 9.39, 9.39, 9.39, 9.39, 9.39, 9.39, 9.39, 9.39, ! 2040-49
     *  9.39/                                                       ! 2050
C
C  HDGV4   0     1     2     3     4     5     6     7     8     9      MY
      DATA ROADFE08/
     *              7.87, 7.87, 7.87, 7.87, 7.87, 7.87, 7.87, 7.87, ! 1952-59
     *  7.87, 7.87, 7.87, 7.87, 7.87, 7.87, 7.87, 7.87, 7.87, 7.87, ! 1960-69
     *  7.87, 7.87, 7.87, 7.87, 7.87, 7.87, 7.87, 7.87, 7.87, 7.87, ! 1970-79
     *  7.87, 7.87, 7.87, 7.87, 7.98, 8.09, 8.21, 8.32, 8.43, 8.55, ! 1980-89
     *  8.66, 8.78, 8.89, 9.01, 9.12, 9.24, 9.35, 9.35, 9.35, 9.35, ! 1990-99
     *  9.35, 9.35, 9.35, 9.35, 9.35, 9.35, 9.35, 9.35, 9.35, 9.35, ! 2000-09
     *  9.35, 9.35, 9.35, 9.35, 9.35, 9.35, 9.35, 9.35, 9.35, 9.35, ! 2010-19
     *  9.35, 9.35, 9.35, 9.35, 9.35, 9.35, 9.35, 9.35, 9.35, 9.35, ! 2020-29
     *  9.35, 9.35, 9.35, 9.35, 9.35, 9.35, 9.35, 9.35, 9.35, 9.35, ! 2030-39
     *  9.35, 9.35, 9.35, 9.35, 9.35, 9.35, 9.35, 9.35, 9.35, 9.35, ! 2040-49
     *  9.35/                                                       ! 2050
C
C  HDGV5   0     1     2     3     4     5     6     7     8     9      MY
      DATA ROADFE09/        
     *              7.30, 7.30, 7.30, 7.30, 7.30, 7.30, 7.30, 7.30, ! 1952-59
     *  7.30, 7.30, 7.30, 7.30, 7.30, 7.30, 7.30, 7.30, 7.30, 7.30, ! 1960-69
     *  7.30, 7.30, 7.30, 7.30, 7.30, 7.30, 7.30, 7.30, 7.30, 7.30, ! 1970-79
     *  7.30, 7.30, 7.30, 7.30, 7.35, 7.41, 7.47, 7.52, 7.58, 7.63, ! 1980-89
     *  7.68, 7.74, 7.79, 7.85, 7.90, 7.95, 8.01, 8.01, 8.01, 8.01, ! 1990-99
     *  8.01, 8.01, 8.01, 8.01, 8.01, 8.01, 8.01, 8.01, 8.01, 8.01, ! 2000-09
     *  8.01, 8.01, 8.01, 8.01, 8.01, 8.01, 8.01, 8.01, 8.01, 8.01, ! 2010-19
     *  8.01, 8.01, 8.01, 8.01, 8.01, 8.01, 8.01, 8.01, 8.01, 8.01, ! 2020-29
     *  8.01, 8.01, 8.01, 8.01, 8.01, 8.01, 8.01, 8.01, 8.01, 8.01, ! 2030-39
     *  8.01, 8.01, 8.01, 8.01, 8.01, 8.01, 8.01, 8.01, 8.01, 8.01, ! 2040-49
     *  8.01/                                                       ! 2050
C
C  HDGV6   0     1     2     3     4     5     6     7     8     9      MY
      DATA ROADFE10/
     *              6.83, 6.83, 6.83, 6.83, 6.83, 6.83, 6.83, 6.83, ! 1952-59
     *  6.83, 6.83, 6.83, 6.83, 6.83, 6.83, 6.83, 6.83, 6.83, 6.83, ! 1960-69
     *  6.83, 6.83, 6.83, 6.83, 6.83, 6.83, 6.83, 6.83, 6.83, 6.83, ! 1970-79
     *  6.83, 6.83, 6.83, 6.83, 6.93, 7.03, 7.13, 7.23, 7.33, 7.43, ! 1980-89
     *  7.53, 7.63, 7.73, 7.84, 7.94, 8.04, 8.14, 8.14, 8.14, 8.14, ! 1990-99
     *  8.14, 8.14, 8.14, 8.14, 8.14, 8.14, 8.14, 8.14, 8.14, 8.14, ! 2000-09
     *  8.14, 8.14, 8.14, 8.14, 8.14, 8.14, 8.14, 8.14, 8.14, 8.14, ! 2010-19
     *  8.14, 8.14, 8.14, 8.14, 8.14, 8.14, 8.14, 8.14, 8.14, 8.14, ! 2020-29
     *  8.14, 8.14, 8.14, 8.14, 8.14, 8.14, 8.14, 8.14, 8.14, 8.14, ! 2030-39
     *  8.14, 8.14, 8.14, 8.14, 8.14, 8.14, 8.14, 8.14, 8.14, 8.14, ! 2040-49
     *  8.14/                                                       ! 2050
C
C  HDGV7   0     1     2     3     4     5     6     7     8     9      MY          
      DATA ROADFE11/        
     *              6.54, 6.54, 6.54, 6.54, 6.54, 6.54, 6.54, 6.54, ! 1952-59
     *  6.54, 6.54, 6.54, 6.54, 6.54, 6.54, 6.54, 6.54, 6.54, 6.54, ! 1960-69
     *  6.54, 6.54, 6.54, 6.54, 6.54, 6.54, 6.54, 6.54, 6.54, 6.54, ! 1970-79
     *  6.54, 6.54, 6.54, 6.54, 6.62, 6.69, 6.76, 6.83, 6.89, 6.96, ! 1980-89
     *  7.03, 7.10, 7.17, 7.24, 7.31, 7.38, 7.45, 7.45, 7.45, 7.45, ! 1990-99
     *  7.45, 7.45, 7.45, 7.45, 7.45, 7.45, 7.45, 7.45, 7.45, 7.45, ! 2000-09
     *  7.45, 7.45, 7.45, 7.45, 7.45, 7.45, 7.45, 7.45, 7.45, 7.45, ! 2010-19
     *  7.45, 7.45, 7.45, 7.45, 7.45, 7.45, 7.45, 7.45, 7.45, 7.45, ! 2020-29
     *  7.45, 7.45, 7.45, 7.45, 7.45, 7.45, 7.45, 7.45, 7.45, 7.45, ! 2030-39
     *  7.45, 7.45, 7.45, 7.45, 7.45, 7.45, 7.45, 7.45, 7.45, 7.45, ! 2040-49
     *  7.45/                                                       ! 2050
C
C  HDGV8A  0     1     2     3     4     5     6     7     8     9      MY          
      DATA ROADFE12/
     *              6.09, 6.09, 6.09, 6.09, 6.09, 6.09, 6.09, 6.09, ! 1952-59
     *  6.09, 6.09, 6.09, 6.09, 6.09, 6.09, 6.09, 6.09, 6.09, 6.09, ! 1960-69
     *  6.09, 6.09, 6.09, 6.09, 6.09, 6.09, 6.09, 6.09, 6.09, 6.09, ! 1970-79
     *  6.09, 6.09, 6.09, 6.09, 6.17, 6.24, 6.32, 6.39, 6.47, 6.54, ! 1980-89
     *  6.62, 6.70, 6.77, 6.85, 6.92, 7.00, 7.07, 7.07, 7.07, 7.07, ! 1990-99
     *  7.07, 7.07, 7.07, 7.07, 7.07, 7.07, 7.07, 7.07, 7.07, 7.07, ! 2000-09
     *  7.07, 7.07, 7.07, 7.07, 7.07, 7.07, 7.07, 7.07, 7.07, 7.07, ! 2010-19
     *  7.07, 7.07, 7.07, 7.07, 7.07, 7.07, 7.07, 7.07, 7.07, 7.07, ! 2020-29
     *  7.07, 7.07, 7.07, 7.07, 7.07, 7.07, 7.07, 7.07, 7.07, 7.07, ! 2030-39
     *  7.07, 7.07, 7.07, 7.07, 7.07, 7.07, 7.07, 7.07, 7.07, 7.07, ! 2040-49
     *  7.07/                                                       ! 2050
C
C  HDGV8B  0     1     2     3     4     5     6     7     8     9      MY
      DATA ROADFE13/        
     *              5.43, 5.43, 5.43, 5.43, 5.43, 5.43, 5.43, 5.43, ! 1952-59
     *  5.43, 5.43, 5.43, 5.43, 5.43, 5.43, 5.43, 5.43, 5.43, 5.43, ! 1960-69
     *  5.43, 5.43, 5.43, 5.43, 5.43, 5.43, 5.43, 5.43, 5.43, 5.43, ! 1970-79
     *  5.43, 5.43, 5.43, 5.43, 5.55, 5.64, 5.75, 5.91, 6.00, 6.09, ! 1980-89
     *  6.19, 6.29, 6.38, 6.47, 6.57, 6.67, 6.76, 6.76, 6.76, 6.76, ! 1990-99
     *  6.76, 6.76, 6.76, 6.76, 6.76, 6.76, 6.76, 6.76, 6.76, 6.76, ! 2000-09
     *  6.76, 6.76, 6.76, 6.76, 6.76, 6.76, 6.76, 6.76, 6.76, 6.76, ! 2010-19
     *  6.76, 6.76, 6.76, 6.76, 6.76, 6.76, 6.76, 6.76, 6.76, 6.76, ! 2020-29
     *  6.76, 6.76, 6.76, 6.76, 6.76, 6.76, 6.76, 6.76, 6.76, 6.76, ! 2030-39
     *  6.76, 6.76, 6.76, 6.76, 6.76, 6.76, 6.76, 6.76, 6.76, 6.76, ! 2040-49
     *  6.76/                                                       ! 2050
C
C  LDDV    0     1     2     3     4     5     6     7     8     9      MY          
      DATA ROADFE14/
     *             24.00,24.00,24.00,24.00,24.00,24.00,24.00,24.00, ! 1952-59
     * 24.00,24.00,24.00,24.00,24.00,24.00,24.00,24.00,24.00,24.00, ! 1960-69
     * 24.00,24.00,24.00,24.00,24.00,24.00,24.00,24.00,25.00,23.00, ! 1970-79
     * 25.50,25.40,26.00,26.20,30.90,29.10,34.40,25.90,31.80,37.70, ! 1980-89
     * 32.40,32.40,32.40,32.40,32.40,32.40,32.40,32.40,32.40,32.40, ! 1990-99
     * 32.40,32.40,32.40,32.40,32.40,32.40,32.40,32.40,32.40,32.40, ! 2000-09
     * 32.40,32.40,32.40,32.40,32.40,32.40,32.40,32.40,32.40,32.40, ! 2010-19
     * 32.40,32.40,32.40,32.40,32.40,32.40,32.40,32.40,32.40,32.40, ! 2020-29
     * 32.40,32.40,32.40,32.40,32.40,32.40,32.40,32.40,32.40,32.40, ! 2030-39
     * 32.40,32.40,32.40,32.40,32.40,32.40,32.40,32.40,32.40,32.40, ! 2040-49
     * 32.40/                                                       ! 2050
C
C  LDDT12  0     1     2     3     4     5     6     7     8     9      MY          
      DATA ROADFE15/        
     *             19.40,19.40,19.40,19.40,19.40,19.40,19.40,19.40, ! 1952-59
     * 19.40,19.40,19.40,19.40,19.40,19.40,19.40,19.40,19.40,19.40, ! 1960-69
     * 19.40,19.40,19.40,19.40,19.40,19.40,19.40,19.40,19.40,19.30, ! 1970-79
     * 22.20,29.20,24.70,24.70,25.00,23.80,24.40,23.40,20.30,20.70, ! 1980-89
     * 22.10,22.10,22.10,22.10,22.10,22.10,22.10,22.10,22.10,22.10, ! 1990-99
     * 22.10,22.10,22.10,22.10,22.10,22.10,22.10,22.10,22.10,22.10, ! 2000-09
     * 22.10,22.10,22.10,22.10,22.10,22.10,22.10,22.10,22.10,22.10, ! 2010-19
     * 22.10,22.10,22.10,22.10,22.10,22.10,22.10,22.10,22.10,22.10, ! 2020-29
     * 22.10,22.10,22.10,22.10,22.10,22.10,22.10,22.10,22.10,22.10, ! 2030-39
     * 22.10,22.10,22.10,22.10,22.10,22.10,22.10,22.10,22.10,22.10, ! 2040-49
     * 22.10/                                                       ! 2050
C
C  HDDV2B  0     1     2     3     4     5     6     7     8     9      MY          
      DATA ROADFE16/
     *             11.13,11.13,11.13,11.13,11.13,11.13,11.13,11.13, ! 1952-59
     * 11.13,11.13,11.13,11.13,11.13,11.13,11.13,11.13,11.13,11.13, ! 1960-69
     * 11.13,11.13,11.13,11.13,11.13,11.13,11.13,11.13,11.13,11.13, ! 1970-79
     * 11.13,11.13,11.13,11.13,11.27,11.41,11.55,11.69,11.83,11.97, ! 1980-89
     * 12.11,12.26,12.40,12.54,12.68,12.82,12.96,12.96,12.96,12.96, ! 1990-99
     * 12.96,12.96,12.96,12.96,12.96,12.96,12.96,12.96,12.96,12.96, ! 2000-09
     * 12.96,12.96,12.96,12.96,12.96,12.96,12.96,12.96,12.96,12.96, ! 2010-19
     * 12.96,12.96,12.96,12.96,12.96,12.96,12.96,12.96,12.96,12.96, ! 2020-29
     * 12.96,12.96,12.96,12.96,12.96,12.96,12.96,12.96,12.96,12.96, ! 2030-39
     * 12.96,12.96,12.96,12.96,12.96,12.96,12.96,12.96,12.96,12.96, ! 2040-49
     * 12.96/                                                       ! 2050
C
C  HDDV3   0     1     2     3     4     5     6     7     8     9      MY          
      DATA ROADFE17/        
     *             10.01,10.01,10.01,10.01,10.01,10.01,10.01,10.01, ! 1952-59
     * 10.01,10.01,10.01,10.01,10.01,10.01,10.01,10.01,10.01,10.01, ! 1960-69
     * 10.01,10.01,10.01,10.01,10.01,10.01,10.01,10.01,10.01,10.01, ! 1970-79
     * 10.01,10.01,10.01,10.01,10.14,10.27,10.39,10.52,10.65,10.77, ! 1980-89
     * 10.90,11.03,11.15,11.28,11.41,11.53,11.66,11.66,11.66,11.66, ! 1990-99
     * 11.66,11.66,11.66,11.66,11.66,11.66,11.66,11.66,11.66,11.66, ! 2000-09
     * 11.66,11.66,11.66,11.66,11.66,11.66,11.66,11.66,11.66,11.66, ! 2010-19
     * 11.66,11.66,11.66,11.66,11.66,11.66,11.66,11.66,11.66,11.66, ! 2020-29
     * 11.66,11.66,11.66,11.66,11.66,11.66,11.66,11.66,11.66,11.66, ! 2030-39
     * 11.66,11.66,11.66,11.66,11.66,11.66,11.66,11.66,11.66,11.66, ! 2040-49
     * 11.66/                                                       ! 2050
C
C  HDDV4   0     1     2     3     4     5     6     7     8     9      MY          
      DATA ROADFE18/
     *              9.27, 9.27, 9.27, 9.27, 9.27, 9.27, 9.27, 9.27, ! 1952-59
     *  9.27, 9.27, 9.27, 9.27, 9.27, 9.27, 9.27, 9.27, 9.27, 9.27, ! 1960-69
     *  9.27, 9.27, 9.27, 9.27, 9.27, 9.27, 9.27, 9.27, 9.27, 9.27, ! 1970-79
     *  9.27, 9.27, 9.27, 9.27, 9.34, 9.41, 9.49, 9.56, 9.63, 9.70, ! 1980-89
     *  9.77, 9.85, 9.92, 9.99,10.06,10.13,10.20,10.20,10.20,10.20, ! 1990-99
     * 10.20,10.20,10.20,10.20,10.20,10.20,10.20,10.20,10.20,10.20, ! 2000-09
     * 10.20,10.20,10.20,10.20,10.20,10.20,10.20,10.20,10.20,10.20, ! 2010-19
     * 10.20,10.20,10.20,10.20,10.20,10.20,10.20,10.20,10.20,10.20, ! 2020-29
     * 10.20,10.20,10.20,10.20,10.20,10.20,10.20,10.20,10.20,10.20, ! 2030-39
     * 10.20,10.20,10.20,10.20,10.20,10.20,10.20,10.20,10.20,10.20, ! 2040-49
     * 10.20/                                                       ! 2050
C
C  HDDV5   0     1     2     3     4     5     6     7     8     9      MY          
      DATA ROADFE19/        
     *              8.78, 8.78, 8.78, 8.78, 8.78, 8.78, 8.78, 8.78, ! 1952-59
     *  8.78, 8.78, 8.78, 8.78, 8.78, 8.78, 8.78, 8.78, 8.78, 8.78, ! 1960-69
     *  8.78, 8.78, 8.78, 8.78, 8.78, 8.78, 8.78, 8.78, 8.78, 8.78, ! 1970-79
     *  8.78, 8.78, 8.78, 8.78, 8.87, 8.95, 9.04, 9.12, 9.21, 9.29, ! 1980-89
     *  9.38, 9.46, 9.54, 9.63, 9.71, 9.80, 9.88, 9.88, 9.88, 9.88, ! 1990-99
     *  9.88, 9.88, 9.88, 9.88, 9.88, 9.88, 9.88, 9.88, 9.88, 9.88, ! 2000-09
     *  9.88, 9.88, 9.88, 9.88, 9.88, 9.88, 9.88, 9.88, 9.88, 9.88, ! 2010-19
     *  9.88, 9.88, 9.88, 9.88, 9.88, 9.88, 9.88, 9.88, 9.88, 9.88, ! 2020-29
     *  9.88, 9.88, 9.88, 9.88, 9.88, 9.88, 9.88, 9.88, 9.88, 9.88, ! 2030-39
     *  9.88, 9.88, 9.88, 9.88, 9.88, 9.88, 9.88, 9.88, 9.88, 9.88, ! 2040-49
     *  9.88/                                                       ! 2050
C
C  HDDV6   0     1     2     3     4     5     6     7     8     9      MY          
      DATA ROADFE20/
     *              7.96, 7.96, 7.96, 7.96, 7.96, 7.96, 7.96, 7.96, ! 1952-59
     *  7.96, 7.96, 7.96, 7.96, 7.96, 7.96, 7.96, 7.96, 7.96, 7.96, ! 1960-69
     *  7.96, 7.96, 7.96, 7.96, 7.96, 7.96, 7.96, 7.96, 7.96, 7.96, ! 1970-79
     *  7.96, 7.96, 7.96, 7.96, 8.02, 8.08, 8.14, 8.20, 8.25, 8.31, ! 1980-89
     *  8.37, 8.42, 8.48, 8.54, 8.59, 8.65, 8.71, 8.71, 8.71, 8.71, ! 1990-99
     *  8.71, 8.71, 8.71, 8.71, 8.71, 8.71, 8.71, 8.71, 8.71, 8.71, ! 2000-09
     *  8.71, 8.71, 8.71, 8.71, 8.71, 8.71, 8.71, 8.71, 8.71, 8.71, ! 2010-19
     *  8.71, 8.71, 8.71, 8.71, 8.71, 8.71, 8.71, 8.71, 8.71, 8.71, ! 2020-29
     *  8.71, 8.71, 8.71, 8.71, 8.71, 8.71, 8.71, 8.71, 8.71, 8.71, ! 2030-39
     *  8.71, 8.71, 8.71, 8.71, 8.71, 8.71, 8.71, 8.71, 8.71, 8.71, ! 2040-49
     *  8.71/                                                       ! 2050
C
C  HDDV7   0     1     2     3     4     5     6     7     8     9      MY          
      DATA ROADFE21/        
     *              7.38, 7.38, 7.38, 7.38, 7.38, 7.38, 7.38, 7.38, ! 1952-59
     *  7.38, 7.38, 7.38, 7.38, 7.38, 7.38, 7.38, 7.38, 7.38, 7.38, ! 1960-69
     *  7.38, 7.38, 7.38, 7.38, 7.38, 7.38, 7.38, 7.38, 7.38, 7.38, ! 1970-79
     *  7.38, 7.38, 7.38, 7.38, 7.39, 7.40, 7.41, 7.43, 7.44, 7.45, ! 1980-89
     *  7.46, 7.47, 7.48, 7.49, 7.51, 7.52, 7.53, 7.53, 7.53, 7.53, ! 1990-99
     *  7.53, 7.53, 7.53, 7.53, 7.53, 7.53, 7.53, 7.53, 7.53, 7.53, ! 2000-09
     *  7.53, 7.53, 7.53, 7.53, 7.53, 7.53, 7.53, 7.53, 7.53, 7.53, ! 2010-19
     *  7.53, 7.53, 7.53, 7.53, 7.53, 7.53, 7.53, 7.53, 7.53, 7.53, ! 2020-29
     *  7.53, 7.53, 7.53, 7.53, 7.53, 7.53, 7.53, 7.53, 7.53, 7.53, ! 2030-39
     *  7.53, 7.53, 7.53, 7.53, 7.53, 7.53, 7.53, 7.53, 7.53, 7.53, ! 2040-49
     *  7.53/                                                       ! 2050
C
C  HDDV8A  0     1     2     3     4     5     6     7     8     9      MY          
      DATA ROADFE22/
     *              5.79, 5.79, 5.79, 5.79, 5.79, 5.79, 5.79, 5.79, ! 1952-59
     *  5.79, 5.79, 5.79, 5.79, 5.79, 5.79, 5.79, 5.79, 5.79, 5.79, ! 1960-69
     *  5.79, 5.79, 5.79, 5.79, 5.79, 5.79, 5.79, 5.79, 5.79, 5.79, ! 1970-79
     *  5.79, 5.79, 5.79, 5.79, 5.84, 5.90, 5.96, 5.96, 6.03, 6.10, ! 1980-89
     *  6.17, 6.24, 6.31, 6.38, 6.45, 6.52, 6.59, 6.59, 6.59, 6.59, ! 1990-99
     *  6.59, 6.59, 6.59, 6.59, 6.59, 6.59, 6.59, 6.59, 6.59, 6.59, ! 2000-09
     *  6.59, 6.59, 6.59, 6.59, 6.59, 6.59, 6.59, 6.59, 6.59, 6.59, ! 2010-19
     *  6.59, 6.59, 6.59, 6.59, 6.59, 6.59, 6.59, 6.59, 6.59, 6.59, ! 2020-29
     *  6.59, 6.59, 6.59, 6.59, 6.59, 6.59, 6.59, 6.59, 6.59, 6.59, ! 2030-39
     *  6.59, 6.59, 6.59, 6.59, 6.59, 6.59, 6.59, 6.59, 6.59, 6.59, ! 2040-49
     *  6.59/                                                       ! 2050
C
C  HDDV8B  0     1     2     3     4     5     6     7     8     9      MY          
      DATA ROADFE23/        
     *              5.16, 5.16, 5.16, 5.16, 5.16, 5.16, 5.16, 5.16, ! 1952-59
     *  5.16, 5.16, 5.16, 5.16, 5.16, 5.16, 5.16, 5.16, 5.16, 5.16, ! 1960-69
     *  5.16, 5.16, 5.16, 5.16, 5.16, 5.16, 5.16, 5.16, 5.16, 5.16, ! 1970-79
     *  5.16, 5.16, 5.16, 5.16, 5.25, 5.33, 5.42, 5.51, 5.59, 5.68, ! 1980-89
     *  5.77, 5.86, 5.95, 6.03, 6.12, 6.21, 6.30, 6.30, 6.30, 6.30, ! 1990-99
     *  6.30, 6.30, 6.30, 6.30, 6.30, 6.30, 6.30, 6.30, 6.30, 6.30, ! 2000-09
     *  6.30, 6.30, 6.30, 6.30, 6.30, 6.30, 6.30, 6.30, 6.30, 6.30, ! 2010-19
     *  6.30, 6.30, 6.30, 6.30, 6.30, 6.30, 6.30, 6.30, 6.30, 6.30, ! 2020-29
     *  6.30, 6.30, 6.30, 6.30, 6.30, 6.30, 6.30, 6.30, 6.30, 6.30, ! 2030-39
     *  6.30, 6.30, 6.30, 6.30, 6.30, 6.30, 6.30, 6.30, 6.30, 6.30, ! 2040-49
     *  6.30/                                                       ! 2050
C
C  MC      0     1     2     3     4     5     6     7     8     9      MY          
      DATA ROADFE24/
     *             50.00,50.00,50.00,50.00,50.00,50.00,50.00,50.00, ! 1952-59
     * 50.00,50.00,50.00,50.00,50.00,50.00,50.00,50.00,50.00,50.00, ! 1960-69
     * 50.00,50.00,50.00,50.00,50.00,50.00,50.00,50.00,50.00,50.00, ! 1970-79
     * 50.00,50.00,50.00,50.00,50.00,50.00,50.00,50.00,50.00,50.00, ! 1980-89
     * 50.00,50.00,50.00,50.00,50.00,50.00,50.00,50.00,50.00,50.00, ! 1990-99
     * 50.00,50.00,50.00,50.00,50.00,50.00,50.00,50.00,50.00,50.00, ! 2000-09
     * 50.00,50.00,50.00,50.00,50.00,50.00,50.00,50.00,50.00,50.00, ! 2010-19
     * 50.00,50.00,50.00,50.00,50.00,50.00,50.00,50.00,50.00,50.00, ! 2020-29
     * 50.00,50.00,50.00,50.00,50.00,50.00,50.00,50.00,50.00,50.00, ! 2030-39
     * 50.00,50.00,50.00,50.00,50.00,50.00,50.00,50.00,50.00,50.00, ! 2040-49
     * 50.00/                                                       ! 2050
C
C  GASBUS  0     1     2     3     4     5     6     7     8     9      MY          
      DATA ROADFE25/        
     *              6.18, 6.18, 6.18, 6.18, 6.18, 6.18, 6.18, 6.18, ! 1952-59
     *  6.18, 6.18, 6.18, 6.18, 6.18, 6.18, 6.18, 6.18, 6.18, 6.18, ! 1960-69
     *  6.18, 6.18, 6.18, 6.18, 6.18, 6.18, 6.18, 6.18, 6.18, 6.18, ! 1970-79
     *  6.18, 6.18, 6.18, 6.18, 6.18, 6.18, 6.18, 6.18, 6.21, 6.24, ! 1980-89
     *  6.27, 6.30, 6.33, 6.37, 6.40, 6.42, 6.45, 6.45, 6.45, 6.45, ! 1990-99
     *  6.45, 6.45, 6.45, 6.45, 6.45, 6.45, 6.45, 6.45, 6.45, 6.45, ! 2000-09
     *  6.45, 6.45, 6.45, 6.45, 6.45, 6.45, 6.45, 6.45, 6.45, 6.45, ! 2010-19
     *  6.45, 6.45, 6.45, 6.45, 6.45, 6.45, 6.45, 6.45, 6.45, 6.45, ! 2020-29
     *  6.45, 6.45, 6.45, 6.45, 6.45, 6.45, 6.45, 6.45, 6.45, 6.45, ! 2030-39
     *  6.45, 6.45, 6.45, 6.45, 6.45, 6.45, 6.45, 6.45, 6.45, 6.45, ! 2040-49
     *  6.45/                                                       ! 2050
C
C  URBANBUS      1     2     3     4     5     6     7     8     9      MY          
      DATA ROADFE26/
     *              3.94, 3.94, 3.94, 3.94, 3.94, 3.94, 3.94, 3.94, ! 1952-59
     *  3.94, 3.94, 3.94, 3.94, 3.94, 3.94, 3.94, 3.94, 3.94, 3.94, ! 1960-69
     *  3.94, 3.94, 3.94, 3.94, 3.94, 3.94, 3.94, 3.94, 3.94, 3.94, ! 1970-79
     *  3.94, 3.94, 3.94, 3.94, 3.94, 3.94, 3.94, 3.94, 3.99, 4.04, ! 1980-89
     *  4.08, 4.13, 4.17, 4.22, 4.26, 4.31, 4.36, 4.36, 4.36, 4.36, ! 1990-99
     *  4.36, 4.36, 4.36, 4.36, 4.36, 4.36, 4.36, 4.36, 4.36, 4.36, ! 2000-09
     *  4.36, 4.36, 4.36, 4.36, 4.36, 4.36, 4.36, 4.36, 4.36, 4.36, ! 2010-19
     *  4.36, 4.36, 4.36, 4.36, 4.36, 4.36, 4.36, 4.36, 4.36, 4.36, ! 2020-29
     *  4.36, 4.36, 4.36, 4.36, 4.36, 4.36, 4.36, 4.36, 4.36, 4.36, ! 2030-39
     *  4.36, 4.36, 4.36, 4.36, 4.36, 4.36, 4.36, 4.36, 4.36, 4.36, ! 2040-49
     *  4.36/                                                       ! 2050
C
C  SCHOOLBUS     1     2     3     4     5     6     7     8     9      MY          
      DATA ROADFE27/        
     *              6.29, 6.29, 6.29, 6.29, 6.29, 6.29, 6.29, 6.29, ! 1952-59
     *  6.29, 6.29, 6.29, 6.29, 6.29, 6.29, 6.29, 6.29, 6.29, 6.29, ! 1960-69
     *  6.29, 6.29, 6.29, 6.29, 6.29, 6.29, 6.29, 6.29, 6.29, 6.29, ! 1970-79
     *  6.29, 6.29, 6.29, 6.29, 6.29, 6.29, 6.29, 6.29, 6.28, 6.27, ! 1980-89
     *  6.25, 6.24, 6.23, 6.22, 6.20, 6.19, 6.18, 6.18, 6.18, 6.18, ! 1990-99
     *  6.18, 6.18, 6.18, 6.18, 6.18, 6.18, 6.18, 6.18, 6.18, 6.18, ! 2000-09
     *  6.18, 6.18, 6.18, 6.18, 6.18, 6.18, 6.18, 6.18, 6.18, 6.18, ! 2010-19
     *  6.18, 6.18, 6.18, 6.18, 6.18, 6.18, 6.18, 6.18, 6.18, 6.18, ! 2020-29
     *  6.18, 6.18, 6.18, 6.18, 6.18, 6.18, 6.18, 6.18, 6.18, 6.18, ! 2030-39
     *  6.18, 6.18, 6.18, 6.18, 6.18, 6.18, 6.18, 6.18, 6.18, 6.18, ! 2040-49
     *  6.18/                                                       ! 2050
C
C  LDDT34  0     1     2     3     4     5     6     7     8     9      MY          
      DATA ROADFE28/
     *             14.90,14.90,14.90,14.90,14.90,14.90,14.90,14.90, ! 1952-59
     * 14.90,14.90,14.90,14.90,14.90,14.90,14.90,14.90,14.90,14.90, ! 1960-69
     * 14.90,14.90,14.90,14.90,14.90,14.90,14.90,14.90,14.90,14.80, ! 1970-79
     * 17.10,22.50,19.00,19.00,19.30,18.30,18.80,18.00,15.60,15.90, ! 1980-89
     * 17.00,17.00,17.00,17.00,17.00,17.00,17.00,17.00,17.00,17.00, ! 1990-99
     * 17.00,17.00,17.00,17.00,17.00,17.00,17.00,17.00,17.00,17.00, ! 2000-09
     * 17.00,17.00,17.00,17.00,17.00,17.00,17.00,17.00,17.00,17.00, ! 2010-19
     * 17.00,17.00,17.00,17.00,17.00,17.00,17.00,17.00,17.00,17.00, ! 2020-29
     * 17.00,17.00,17.00,17.00,17.00,17.00,17.00,17.00,17.00,17.00, ! 2030-39
     * 17.00,17.00,17.00,17.00,17.00,17.00,17.00,17.00,17.00,17.00, ! 2040-49
     * 17.00/                                                       ! 2050
C
      DATA MPGFLAG/.FALSE./  ! False means use default, instead of user, MPG data.
C
C
      DATA DISPL/5.46/,SPILL/.31/,OBED/.98/,OBES/.50/
C
C    5-May-1994 @ CSC-tmm request 2-411
C       Added data items to handle phase-in of onboard fuel recovery systems
C
      DATA OBPIY/
C  LDGV
     1 1998, 1999, 2000,
C  LDGT1
     2 2001, 2002, 2003,
C  LDGT2
     3 2001, 2002, 2003,
C  LDGT3
     4 2004, 2005, 2006,
C  LDGT4
     5 2004, 2005, 2006,
C  HDGV2b
     6 2004, 2005, 2006/
C
      DATA OBPIP/
C  LDGV
     1 0.40, 0.80, 1.00,
C  LDGT1
     2 0.40, 0.80, 1.00,
C  LDGT2
     3 0.40, 0.80, 1.00,
C  LDGT3
     4 0.40, 0.80, 1.00,
C  LDGT4
     5 0.40, 0.80, 1.00,
C  HDGV2b
     6 0.00, 0.80, 1.00/
C
C
C  /RLCOM2/:
C
      DATA IS2SY/NEYR/,NPHASE/4/,S2EFF/14*0.0/
C
C  /RLCOM3/:
C
      DATA RLRATE/8400*0.0/
C
      END
