      BLOCK DATA BD34 
C 
C  BLOCK DATA Subprogram 34: /RUNLS1/,/RUNSL2/,/RUNLS3/,/RESTLS/,/RESTLS1/ 
C 
C  BLOCK DATA initializes running and resting loss HC emissions data. 
C 
C  Changes: (Last change first) 
C 
C  04 Jan 02 @EPA-bag BUG336 fix typo in TLVMT array for 41-50 min. travel 
C            time interval (0.8335 changed to 0.08335) 
C  18 Jan 01 @EPA-bag  2007 rule for heavy duty vehicles 
C  30 Oct 00 @EPA-djb Bug295, Reverted to MOBILE5 default values for TLVMT. 
C  08 Aug 00 @EPA-elg Added NO_EVAPCALC to shut down evap calculations. 
C  28 Jul 00 AIR Task 06: Removed unused PTOPN1/2 and PTCLS1/2. 
C  20 Jul 00 @EPA-bag running loss: removed unused PTGRST array; added NO_RSTLOS 
C            for zeroing resting losses 
C  26 Jun 00 @EPA-bag bug168   weekend TLVMT data fix(value for IH=23 and 
C                     travel length period 31-40 minutes was off by a decimal 
C                     point/ a factor of 10) 
C  14 Jan 00 @Dyntel-JWR 1-017 Made RSTLSS_EF the hourly rest loss total 
C  19 Nov 99 @Dyntel-jwr 1-017 Expanded RSTLS1 to (4,4,2) to account for 4 pressure 
C            purge test outcomes and extra model year range. 
C  13 Dec 99 @DynTel-bag 1-006 Added include file, RESTLS1.I, to carry r 
C  12 Jan 99 @DynTel-bag 2-664 Added hourly running loss model parameters, TRPS_PR_DA 
C            and HRVMTU; Removed old resting loss parameters, RESTA and RESTB. Expanded 
C            TLVMT array to include indices for 14 hourly intervals of each day and the 
C            time of the week (weekday and weekends). 
C  30 Oct 98 @DynTel-bag 2-677 Added hourly resting loss model parameters, 
C            RSTLS1(model year range,pressure /purge pass/fail,fuel delivery system). 
C  11 Aug 98 @DynTel-MLA 2-000  Changed HDG and HDD names to conform to 
C            new naming conventions. 
C 
C  Common block array subscripts: 
C 
C  MYGRNL(4,14)        -  MYGRNL ( IGTL, IVTL ) 
C  RSTLS1(4,4,2)       -  RSTLS1 ( MYRNG,PTST, RIFDS ) 
C  RSTLS2(4,4)         -  RSTLS2 ( MYRNG,PTST ) 
C  RNLRVP(4)           -  RNLRVP ( ITLR ) 
C  RNLTEM(4)           -  RNLTEM ( ITLT ) 
C  RNLSPD(3)           -  RNLSPD ( ISPD ) 
C  TLEMI(6,3,4,4,4,14) -  TLEMI  ( ITL, ISPD, ITLR, ITLT, IGTL, IVTL ) 
C  TLFAIL(6,4,4)       -  TLFAIL ( ITL, ITLR, ITLT ) 
C  TLVMT(6,14,2)       -  TLVMT  ( ITL, IH, IWEEK ) 
C 
C  Common block dictionary: 
C 
C   Name   Type             Description 
C  ------  ----  ------------------------------------------------- 
C  /RUNLS1/: 
C 
C  MAXTL       I    maximum number of trip length cases 
C  TLVMT       R    Urban type normalized %VMT by trip length (driving cycle case) 
C  TLVMTU      R    user input %VMT trip length values; must sum to 1.0. 
C 
C  /RUNLS2/: 
C 
C  TLEMI       R    g/mi running loss emissions, by trip length, RVP, temperature, 
C                   MYG and vehicle class; pressure/purge test pass vehicles 
C  TLFAIL      R    running losses of canister pressure/purge test fail 
C                   vehicles, by RVP and temperature 
C 
C  /RUNLS3/: 
C 
C  MYGRNL    I   running loss emission HC rate MYGs 
C  MAXRNL    I   maximum number of running loss HC emission rate MYGs 
C  RNLRVP    R   running loss HC RVP measurement values 
C  RNLTEM    R   running loss HC temperature measurement values 
C  RNLSPD    R   running loss HC speed measurement values 
C 
C  /RESTLS/: 
C 
C  RSTLS1    R   parameter array for MOBILE6 resting loss emissions from 
C                light duty gas vehicles (cars and trucks)  
C  RSTLS2    R   parameter array for MOBILE6 resting loss emissions from 
C                light duty gas vehicles (cars and trucks)  
C 
C  /RESTLS1/: 
C 
C  RSTLSS_EF  R  hourly resting loss in vapor state determined in RSTLOS.FOR 
C                 and passed between evaporative emissions routines for 
C                 subtraction of resting losses 
C 
C 
C 
C 
C  Local array subscripts: 
C 
C  TL<I><J><K>(18,4)  -  TL<I><J><K> ( ITL*ISPD, ITLR ) 
C 
C  where I = ITLT, J = IGTL and K = IVTL 
C 
C  RNLB1<K>(4,4,4)  -  RNLB1<K> ( ITLR, ITLT, IGTL ) 
C 
C  where K = IVTL 
C 
C  Local array dictionary: 
C 
C  The TL<I><J><K> arrays are the IGTL x IVTL subsets (16) of the 
C  by trip length running loss emission impact rates stored in TLEMI, 
C  broken out into the four temperature groups also for MOBILE4.1: 
C 
C  TLEMI(1,1,1,<I>,<J>,<K>) EQU to TL<I><J><K>(1,1,1) 
C 
C  Notes: 
C 
C  Composite emission factors arrays RNLBAS, RNLCAN and RNLCAP removed 
C  and trip-length based versions in TLEMI, TLCAN, and TLCAP activated 
C  for use in new version of RNLOSS implemented in MOBILE4.1, v.D02. 
C  Added /RESTLS/ for resting loss HC calculations for MOBILE4.1, vD03 
C  Combined /RUNLS4/ and /RUNLS5/ to replace old /RUNLS3/ in vD03. 
C  Replaced TLCAN and TLCAP with TLFAIL associated with new evap. code 
C  in MOBILE4.1,vD05.  Also, for TLEMI only the first 2 MYGs are used. 
C  RNLOSS code now uses TLFAIL for precontrolled group (group 1.) 
C  Updated on December 7, 1992 to handle two roundoff errors. 
C 
C  6 Dec 96 DynTel@MLA 2-622  Expanded the arrays to accomodate the new  
C           Heavy Duty Gasoline, Heavy Duty Diesel, LDGT, and BUS vehicle  
C           categories. 
C 
C 23 Jul 98 @DynTel-MLA 2-000  Changed LDGT names to conform to 
C           certification naming conventions. 
C 
      IMPLICIT NONE 
      INCLUDE 'PARAME.I' 
      INCLUDE 'RUNLS1.I' 
      INCLUDE 'RUNLS2.I' 
      INCLUDE 'RUNLS3.I' 
      INCLUDE 'RESTLS.I' 
      INCLUDE 'RESTLS1.I' 
C 
      REAL 
     *  TL1101(18,4),TL1102(18,4),TL1103(18,4),TL1104(18,4), 
     *  TL1105(18,4),TL1106(18,4),TL1107(18,4),TL1108(18,4), 
     *  TL1109(18,4),TL1110(18,4),TL1111(18,4),TL1112(18,4), 
     *  TL1113(18,4),TL1114(18,4) 
      REAL 
     *  TL1201(18,4),TL1202(18,4),TL1203(18,4),TL1204(18,4), 
     *  TL1205(18,4),TL1206(18,4),TL1207(18,4),TL1208(18,4), 
     *  TL1209(18,4),TL1210(18,4),TL1211(18,4),TL1212(18,4), 
     *  TL1213(18,4),TL1214(18,4) 
      REAL 
     *  TL1301(18,4),TL1302(18,4),TL1303(18,4),TL1304(18,4), 
     *  TL1305(18,4),TL1306(18,4),TL1307(18,4),TL1308(18,4), 
     *  TL1309(18,4),TL1310(18,4),TL1311(18,4),TL1312(18,4), 
     *  TL1313(18,4),TL1314(18,4) 
      REAL 
     *  TL1401(18,4),TL1402(18,4),TL1403(18,4),TL1404(18,4), 
     *  TL1405(18,4),TL1406(18,4),TL1407(18,4),TL1408(18,4), 
     *  TL1409(18,4),TL1410(18,4),TL1411(18,4),TL1412(18,4), 
     *  TL1413(18,4),TL1414(18,4) 
      REAL 
     *  TL2101(18,4),TL2102(18,4),TL2103(18,4),TL2104(18,4), 
     *  TL2105(18,4),TL2106(18,4),TL2107(18,4),TL2108(18,4), 
     *  TL2109(18,4),TL2110(18,4),TL2111(18,4),TL2112(18,4), 
     *  TL2113(18,4),TL2114(18,4) 
      REAL 
     *  TL2201(18,4),TL2202(18,4),TL2203(18,4),TL2204(18,4), 
     *  TL2205(18,4),TL2206(18,4),TL2207(18,4),TL2208(18,4), 
     *  TL2209(18,4),TL2210(18,4),TL2211(18,4),TL2212(18,4), 
     *  TL2213(18,4),TL2214(18,4) 
      REAL 
     *  TL2301(18,4),TL2302(18,4),TL2303(18,4),TL2304(18,4), 
     *  TL2305(18,4),TL2306(18,4),TL2307(18,4),TL2308(18,4), 
     *  TL2309(18,4),TL2310(18,4),TL2311(18,4),TL2312(18,4), 
     *  TL2313(18,4),TL2314(18,4) 
      REAL 
     *  TL2401(18,4),TL2402(18,4),TL2403(18,4),TL2404(18,4), 
     *  TL2405(18,4),TL2406(18,4),TL2407(18,4),TL2408(18,4), 
     *  TL2409(18,4),TL2410(18,4),TL2411(18,4),TL2412(18,4), 
     *  TL2413(18,4),TL2414(18,4) 
      REAL 
     *  TL3101(18,4),TL3102(18,4),TL3103(18,4),TL3104(18,4), 
     *  TL3105(18,4),TL3106(18,4),TL3107(18,4),TL3108(18,4), 
     *  TL3109(18,4),TL3110(18,4),TL3111(18,4),TL3112(18,4), 
     *  TL3113(18,4),TL3114(18,4) 
      REAL 
     *  TL3201(18,4),TL3202(18,4),TL3203(18,4),TL3204(18,4), 
     *  TL3205(18,4),TL3206(18,4),TL3207(18,4),TL3208(18,4), 
     *  TL3209(18,4),TL3210(18,4),TL3211(18,4),TL3212(18,4), 
     *  TL3213(18,4),TL3214(18,4) 
      REAL 
     *  TL3301(18,4),TL3302(18,4),TL3303(18,4),TL3304(18,4), 
     *  TL3305(18,4),TL3306(18,4),TL3307(18,4),TL3308(18,4), 
     *  TL3309(18,4),TL3310(18,4),TL3311(18,4),TL3312(18,4), 
     *  TL3313(18,4),TL3314(18,4) 
      REAL 
     *  TL3401(18,4),TL3402(18,4),TL3403(18,4),TL3404(18,4), 
     *  TL3405(18,4),TL3406(18,4),TL3407(18,4),TL3408(18,4), 
     *  TL3409(18,4),TL3410(18,4),TL3411(18,4),TL3412(18,4), 
     *  TL3413(18,4),TL3414(18,4) 
      REAL 
     *  TL4101(18,4),TL4102(18,4),TL4103(18,4),TL4104(18,4), 
     *  TL4105(18,4),TL4106(18,4),TL4107(18,4),TL4108(18,4), 
     *  TL4109(18,4),TL4110(18,4),TL4111(18,4),TL4112(18,4), 
     *  TL4113(18,4),TL4114(18,4) 
      REAL 
     *  TL4201(18,4),TL4202(18,4),TL4203(18,4),TL4204(18,4), 
     *  TL4205(18,4),TL4206(18,4),TL4207(18,4),TL4208(18,4), 
     *  TL4209(18,4),TL4210(18,4),TL4211(18,4),TL4212(18,4), 
     *  TL4213(18,4),TL4214(18,4) 
      REAL 
     *  TL4301(18,4),TL4302(18,4),TL4303(18,4),TL4304(18,4), 
     *  TL4305(18,4),TL4306(18,4),TL4307(18,4),TL4308(18,4), 
     *  TL4309(18,4),TL4310(18,4),TL4311(18,4),TL4312(18,4), 
     *  TL4313(18,4),TL4314(18,4) 
      REAL 
     *  TL4401(18,4),TL4402(18,4),TL4403(18,4),TL4404(18,4), 
     *  TL4405(18,4),TL4406(18,4),TL4407(18,4),TL4408(18,4), 
     *  TL4409(18,4),TL4410(18,4),TL4411(18,4),TL4412(18,4), 
     *  TL4413(18,4),TL4414(18,4) 
C 
      EQUIVALENCE 
     *(TLEMI(1,1,1,1,1, 1),TL1101(1,1)), 
     *(TLEMI(1,1,1,1,1, 2),TL1102(1,1)), 
     *(TLEMI(1,1,1,1,1, 3),TL1103(1,1)), 
     *(TLEMI(1,1,1,1,1, 4),TL1104(1,1)), 
     *(TLEMI(1,1,1,1,1, 5),TL1105(1,1)), 
     *(TLEMI(1,1,1,1,1, 6),TL1106(1,1)), 
     *(TLEMI(1,1,1,1,1, 7),TL1107(1,1)), 
     *(TLEMI(1,1,1,1,1, 8),TL1108(1,1)), 
     *(TLEMI(1,1,1,1,1, 9),TL1109(1,1)), 
     *(TLEMI(1,1,1,1,1,10),TL1110(1,1)), 
     *(TLEMI(1,1,1,1,1,11),TL1111(1,1)), 
     *(TLEMI(1,1,1,1,1,12),TL1112(1,1)), 
     *(TLEMI(1,1,1,1,1,13),TL1113(1,1)), 
     *(TLEMI(1,1,1,1,1,14),TL1114(1,1)) 
      EQUIVALENCE 
     *(TLEMI(1,1,1,1,2, 1),TL1201(1,1)), 
     *(TLEMI(1,1,1,1,2, 2),TL1202(1,1)), 
     *(TLEMI(1,1,1,1,2, 3),TL1203(1,1)), 
     *(TLEMI(1,1,1,1,2, 4),TL1204(1,1)), 
     *(TLEMI(1,1,1,1,2, 5),TL1205(1,1)), 
     *(TLEMI(1,1,1,1,2, 6),TL1206(1,1)), 
     *(TLEMI(1,1,1,1,2, 7),TL1207(1,1)), 
     *(TLEMI(1,1,1,1,2, 8),TL1208(1,1)), 
     *(TLEMI(1,1,1,1,2, 9),TL1209(1,1)), 
     *(TLEMI(1,1,1,1,2,10),TL1210(1,1)), 
     *(TLEMI(1,1,1,1,2,11),TL1211(1,1)), 
     *(TLEMI(1,1,1,1,2,12),TL1212(1,1)), 
     *(TLEMI(1,1,1,1,2,13),TL1213(1,1)), 
     *(TLEMI(1,1,1,1,2,14),TL1214(1,1)) 
      EQUIVALENCE 
     *(TLEMI(1,1,1,1,3, 1),TL1301(1,1)), 
     *(TLEMI(1,1,1,1,3, 2),TL1302(1,1)), 
     *(TLEMI(1,1,1,1,3, 3),TL1303(1,1)), 
     *(TLEMI(1,1,1,1,3, 4),TL1304(1,1)), 
     *(TLEMI(1,1,1,1,3, 5),TL1305(1,1)), 
     *(TLEMI(1,1,1,1,3, 6),TL1306(1,1)), 
     *(TLEMI(1,1,1,1,3, 7),TL1307(1,1)), 
     *(TLEMI(1,1,1,1,3, 8),TL1308(1,1)), 
     *(TLEMI(1,1,1,1,3, 9),TL1309(1,1)), 
     *(TLEMI(1,1,1,1,3,10),TL1310(1,1)), 
     *(TLEMI(1,1,1,1,3,11),TL1311(1,1)), 
     *(TLEMI(1,1,1,1,3,12),TL1312(1,1)), 
     *(TLEMI(1,1,1,1,3,13),TL1313(1,1)), 
     *(TLEMI(1,1,1,1,3,14),TL1314(1,1)) 
      EQUIVALENCE 
     *(TLEMI(1,1,1,1,4, 1),TL1401(1,1)), 
     *(TLEMI(1,1,1,1,4, 2),TL1402(1,1)), 
     *(TLEMI(1,1,1,1,4, 3),TL1403(1,1)), 
     *(TLEMI(1,1,1,1,4, 4),TL1404(1,1)), 
     *(TLEMI(1,1,1,1,4, 5),TL1405(1,1)), 
     *(TLEMI(1,1,1,1,4, 6),TL1406(1,1)), 
     *(TLEMI(1,1,1,1,4, 7),TL1407(1,1)), 
     *(TLEMI(1,1,1,1,4, 8),TL1408(1,1)), 
     *(TLEMI(1,1,1,1,4, 9),TL1409(1,1)), 
     *(TLEMI(1,1,1,1,4,10),TL1410(1,1)), 
     *(TLEMI(1,1,1,1,4,11),TL1411(1,1)), 
     *(TLEMI(1,1,1,1,4,12),TL1412(1,1)), 
     *(TLEMI(1,1,1,1,4,13),TL1413(1,1)), 
     *(TLEMI(1,1,1,1,4,14),TL1414(1,1)) 
      EQUIVALENCE 
     *(TLEMI(1,1,1,2,1, 1),TL2101(1,1)), 
     *(TLEMI(1,1,1,2,1, 2),TL2102(1,1)), 
     *(TLEMI(1,1,1,2,1, 3),TL2103(1,1)), 
     *(TLEMI(1,1,1,2,1, 4),TL2104(1,1)), 
     *(TLEMI(1,1,1,2,1, 5),TL2105(1,1)), 
     *(TLEMI(1,1,1,2,1, 6),TL2106(1,1)), 
     *(TLEMI(1,1,1,2,1, 7),TL2107(1,1)), 
     *(TLEMI(1,1,1,2,1, 8),TL2108(1,1)), 
     *(TLEMI(1,1,1,2,1, 9),TL2109(1,1)), 
     *(TLEMI(1,1,1,2,1,10),TL2110(1,1)), 
     *(TLEMI(1,1,1,2,1,11),TL2111(1,1)), 
     *(TLEMI(1,1,1,2,1,12),TL2112(1,1)), 
     *(TLEMI(1,1,1,2,1,13),TL2113(1,1)), 
     *(TLEMI(1,1,1,2,1,14),TL2114(1,1)) 
      EQUIVALENCE 
     *(TLEMI(1,1,1,2,2, 1),TL2201(1,1)), 
     *(TLEMI(1,1,1,2,2, 2),TL2202(1,1)), 
     *(TLEMI(1,1,1,2,2, 3),TL2203(1,1)), 
     *(TLEMI(1,1,1,2,2, 4),TL2204(1,1)), 
     *(TLEMI(1,1,1,2,2, 5),TL2205(1,1)), 
     *(TLEMI(1,1,1,2,2, 6),TL2206(1,1)), 
     *(TLEMI(1,1,1,2,2, 7),TL2207(1,1)), 
     *(TLEMI(1,1,1,2,2, 8),TL2208(1,1)), 
     *(TLEMI(1,1,1,2,2, 9),TL2209(1,1)), 
     *(TLEMI(1,1,1,2,2,10),TL2210(1,1)), 
     *(TLEMI(1,1,1,2,2,11),TL2211(1,1)), 
     *(TLEMI(1,1,1,2,2,12),TL2212(1,1)), 
     *(TLEMI(1,1,1,2,2,13),TL2213(1,1)), 
     *(TLEMI(1,1,1,2,2,14),TL2214(1,1)) 
      EQUIVALENCE 
     *(TLEMI(1,1,1,2,3, 1),TL2301(1,1)), 
     *(TLEMI(1,1,1,2,3, 2),TL2302(1,1)), 
     *(TLEMI(1,1,1,2,3, 3),TL2303(1,1)), 
     *(TLEMI(1,1,1,2,3, 4),TL2304(1,1)), 
     *(TLEMI(1,1,1,2,3, 5),TL2305(1,1)), 
     *(TLEMI(1,1,1,2,3, 6),TL2306(1,1)), 
     *(TLEMI(1,1,1,2,3, 7),TL2307(1,1)), 
     *(TLEMI(1,1,1,2,3, 8),TL2308(1,1)), 
     *(TLEMI(1,1,1,2,3, 9),TL2309(1,1)), 
     *(TLEMI(1,1,1,2,3,10),TL2310(1,1)), 
     *(TLEMI(1,1,1,2,3,11),TL2311(1,1)), 
     *(TLEMI(1,1,1,2,3,12),TL2312(1,1)), 
     *(TLEMI(1,1,1,2,3,13),TL2313(1,1)), 
     *(TLEMI(1,1,1,2,3,14),TL2314(1,1)) 
      EQUIVALENCE 
     *(TLEMI(1,1,1,2,4, 1),TL2401(1,1)), 
     *(TLEMI(1,1,1,2,4, 2),TL2402(1,1)), 
     *(TLEMI(1,1,1,2,4, 3),TL2403(1,1)), 
     *(TLEMI(1,1,1,2,4, 4),TL2404(1,1)), 
     *(TLEMI(1,1,1,2,4, 5),TL2405(1,1)), 
     *(TLEMI(1,1,1,2,4, 6),TL2406(1,1)), 
     *(TLEMI(1,1,1,2,4, 7),TL2407(1,1)), 
     *(TLEMI(1,1,1,2,4, 8),TL2408(1,1)), 
     *(TLEMI(1,1,1,2,4, 9),TL2409(1,1)), 
     *(TLEMI(1,1,1,2,4,10),TL2410(1,1)), 
     *(TLEMI(1,1,1,2,4,11),TL2411(1,1)), 
     *(TLEMI(1,1,1,2,4,12),TL2412(1,1)), 
     *(TLEMI(1,1,1,2,4,13),TL2413(1,1)), 
     *(TLEMI(1,1,1,2,4,14),TL2414(1,1)) 
      EQUIVALENCE 
     *(TLEMI(1,1,1,3,1, 1),TL3101(1,1)), 
     *(TLEMI(1,1,1,3,1, 2),TL3102(1,1)), 
     *(TLEMI(1,1,1,3,1, 3),TL3103(1,1)), 
     *(TLEMI(1,1,1,3,1, 4),TL3104(1,1)), 
     *(TLEMI(1,1,1,3,1, 5),TL3105(1,1)), 
     *(TLEMI(1,1,1,3,1, 6),TL3106(1,1)), 
     *(TLEMI(1,1,1,3,1, 7),TL3107(1,1)), 
     *(TLEMI(1,1,1,3,1, 8),TL3108(1,1)), 
     *(TLEMI(1,1,1,3,1, 9),TL3109(1,1)), 
     *(TLEMI(1,1,1,3,1,10),TL3110(1,1)), 
     *(TLEMI(1,1,1,3,1,11),TL3111(1,1)), 
     *(TLEMI(1,1,1,3,1,12),TL3112(1,1)), 
     *(TLEMI(1,1,1,3,1,13),TL3113(1,1)), 
     *(TLEMI(1,1,1,3,1,14),TL3114(1,1)) 
      EQUIVALENCE 
     *(TLEMI(1,1,1,3,2, 1),TL3201(1,1)), 
     *(TLEMI(1,1,1,3,2, 2),TL3202(1,1)), 
     *(TLEMI(1,1,1,3,2, 3),TL3203(1,1)), 
     *(TLEMI(1,1,1,3,2, 4),TL3204(1,1)), 
     *(TLEMI(1,1,1,3,2, 5),TL3205(1,1)), 
     *(TLEMI(1,1,1,3,2, 6),TL3206(1,1)), 
     *(TLEMI(1,1,1,3,2, 7),TL3207(1,1)), 
     *(TLEMI(1,1,1,3,2, 8),TL3208(1,1)), 
     *(TLEMI(1,1,1,3,2, 9),TL3209(1,1)), 
     *(TLEMI(1,1,1,3,2,10),TL3210(1,1)), 
     *(TLEMI(1,1,1,3,2,11),TL3211(1,1)), 
     *(TLEMI(1,1,1,3,2,12),TL3212(1,1)), 
     *(TLEMI(1,1,1,3,2,13),TL3213(1,1)), 
     *(TLEMI(1,1,1,3,2,14),TL3214(1,1)) 
      EQUIVALENCE 
     *(TLEMI(1,1,1,3,3, 1),TL3301(1,1)), 
     *(TLEMI(1,1,1,3,3, 2),TL3302(1,1)), 
     *(TLEMI(1,1,1,3,3, 3),TL3303(1,1)), 
     *(TLEMI(1,1,1,3,3, 4),TL3304(1,1)), 
     *(TLEMI(1,1,1,3,3, 5),TL3305(1,1)), 
     *(TLEMI(1,1,1,3,3, 6),TL3306(1,1)), 
     *(TLEMI(1,1,1,3,3, 7),TL3307(1,1)), 
     *(TLEMI(1,1,1,3,3, 8),TL3308(1,1)), 
     *(TLEMI(1,1,1,3,3, 9),TL3309(1,1)), 
     *(TLEMI(1,1,1,3,3,10),TL3310(1,1)), 
     *(TLEMI(1,1,1,3,3,11),TL3311(1,1)), 
     *(TLEMI(1,1,1,3,3,12),TL3312(1,1)), 
     *(TLEMI(1,1,1,3,3,13),TL3313(1,1)), 
     *(TLEMI(1,1,1,3,3,14),TL3314(1,1)) 
      EQUIVALENCE 
     *(TLEMI(1,1,1,3,4, 1),TL3401(1,1)), 
     *(TLEMI(1,1,1,3,4, 2),TL3402(1,1)), 
     *(TLEMI(1,1,1,3,4, 3),TL3403(1,1)), 
     *(TLEMI(1,1,1,3,4, 4),TL3404(1,1)), 
     *(TLEMI(1,1,1,3,4, 5),TL3405(1,1)), 
     *(TLEMI(1,1,1,3,4, 6),TL3406(1,1)), 
     *(TLEMI(1,1,1,3,4, 7),TL3407(1,1)), 
     *(TLEMI(1,1,1,3,4, 8),TL3408(1,1)), 
     *(TLEMI(1,1,1,3,4, 9),TL3409(1,1)), 
     *(TLEMI(1,1,1,3,4,10),TL3410(1,1)), 
     *(TLEMI(1,1,1,3,4,11),TL3411(1,1)), 
     *(TLEMI(1,1,1,3,4,12),TL3412(1,1)), 
     *(TLEMI(1,1,1,3,4,13),TL3413(1,1)), 
     *(TLEMI(1,1,1,3,4,14),TL3414(1,1)) 
      EQUIVALENCE 
     *(TLEMI(1,1,1,4,1, 1),TL4101(1,1)), 
     *(TLEMI(1,1,1,4,1, 2),TL4102(1,1)), 
     *(TLEMI(1,1,1,4,1, 3),TL4103(1,1)), 
     *(TLEMI(1,1,1,4,1, 4),TL4104(1,1)), 
     *(TLEMI(1,1,1,4,1, 5),TL4105(1,1)), 
     *(TLEMI(1,1,1,4,1, 6),TL4106(1,1)), 
     *(TLEMI(1,1,1,4,1, 7),TL4107(1,1)), 
     *(TLEMI(1,1,1,4,1, 8),TL4108(1,1)), 
     *(TLEMI(1,1,1,4,1, 9),TL4109(1,1)), 
     *(TLEMI(1,1,1,4,1,10),TL4110(1,1)), 
     *(TLEMI(1,1,1,4,1,11),TL4111(1,1)), 
     *(TLEMI(1,1,1,4,1,12),TL4112(1,1)), 
     *(TLEMI(1,1,1,4,1,13),TL4113(1,1)), 
     *(TLEMI(1,1,1,4,1,14),TL4114(1,1)) 
      EQUIVALENCE 
     *(TLEMI(1,1,1,4,2, 1),TL4201(1,1)), 
     *(TLEMI(1,1,1,4,2, 2),TL4202(1,1)), 
     *(TLEMI(1,1,1,4,2, 3),TL4203(1,1)), 
     *(TLEMI(1,1,1,4,2, 4),TL4204(1,1)), 
     *(TLEMI(1,1,1,4,2, 5),TL4205(1,1)), 
     *(TLEMI(1,1,1,4,2, 6),TL4206(1,1)), 
     *(TLEMI(1,1,1,4,2, 7),TL4207(1,1)), 
     *(TLEMI(1,1,1,4,2, 8),TL4208(1,1)), 
     *(TLEMI(1,1,1,4,2, 9),TL4209(1,1)), 
     *(TLEMI(1,1,1,4,2,10),TL4210(1,1)), 
     *(TLEMI(1,1,1,4,2,11),TL4211(1,1)), 
     *(TLEMI(1,1,1,4,2,12),TL4212(1,1)), 
     *(TLEMI(1,1,1,4,2,13),TL4213(1,1)), 
     *(TLEMI(1,1,1,4,2,14),TL4214(1,1)) 
      EQUIVALENCE 
     *(TLEMI(1,1,1,4,3, 1),TL4301(1,1)), 
     *(TLEMI(1,1,1,4,3, 2),TL4302(1,1)), 
     *(TLEMI(1,1,1,4,3, 3),TL4303(1,1)), 
     *(TLEMI(1,1,1,4,3, 4),TL4304(1,1)), 
     *(TLEMI(1,1,1,4,3, 5),TL4305(1,1)), 
     *(TLEMI(1,1,1,4,3, 6),TL4306(1,1)), 
     *(TLEMI(1,1,1,4,3, 7),TL4307(1,1)), 
     *(TLEMI(1,1,1,4,3, 8),TL4308(1,1)), 
     *(TLEMI(1,1,1,4,3, 9),TL4309(1,1)), 
     *(TLEMI(1,1,1,4,3,10),TL4310(1,1)), 
     *(TLEMI(1,1,1,4,3,11),TL4311(1,1)), 
     *(TLEMI(1,1,1,4,3,12),TL4312(1,1)), 
     *(TLEMI(1,1,1,4,3,13),TL4313(1,1)), 
     *(TLEMI(1,1,1,4,3,14),TL4314(1,1)) 
      EQUIVALENCE 
     *(TLEMI(1,1,1,4,4, 1),TL4401(1,1)), 
     *(TLEMI(1,1,1,4,4, 2),TL4402(1,1)), 
     *(TLEMI(1,1,1,4,4, 3),TL4403(1,1)), 
     *(TLEMI(1,1,1,4,4, 4),TL4404(1,1)), 
     *(TLEMI(1,1,1,4,4, 5),TL4405(1,1)), 
     *(TLEMI(1,1,1,4,4, 6),TL4406(1,1)), 
     *(TLEMI(1,1,1,4,4, 7),TL4407(1,1)), 
     *(TLEMI(1,1,1,4,4, 8),TL4408(1,1)), 
     *(TLEMI(1,1,1,4,4, 9),TL4409(1,1)), 
     *(TLEMI(1,1,1,4,4,10),TL4410(1,1)), 
     *(TLEMI(1,1,1,4,4,11),TL4411(1,1)), 
     *(TLEMI(1,1,1,4,4,12),TL4412(1,1)), 
     *(TLEMI(1,1,1,4,4,13),TL4413(1,1)), 
     *(TLEMI(1,1,1,4,4,14),TL4414(1,1)) 
C 
C  /RUNLS1/: default trip length data - optional user input goes into 
C            TLVMTU:  TLVMT is never changed. 
C 
C  Initialize working version of TLVMT so RNLOSS will copy TLVMT, 
C  unless, of course, WTLRNL has read values in first! 
C 
      DATA TLVMTU/168*-1/ 
C 
C weekday 
C 
      DATA TLVMT/ 
C          
C        ITL, travel duration ( minutes ): 
C        0-10    11-20    21-30    31-40    41-50    51+ 
C   IH    |        |        |        |        |       | 
C    |    |        |        |        |        |       | 
     1 0.06744, 0.18507, 0.16775, 0.13108, 0.08335, 0.36531, 
     2 0.06744, 0.18507, 0.16775, 0.13108, 0.08335, 0.36531, 
     3 0.06744, 0.18507, 0.16775, 0.13108, 0.08335, 0.36531, 
     4 0.06744, 0.18507, 0.16775, 0.13108, 0.08335, 0.36531, 
     5 0.06744, 0.18507, 0.16775, 0.13108, 0.08335, 0.36531, 
     6 0.06744, 0.18507, 0.16775, 0.13108, 0.08335, 0.36531, 
     7 0.06744, 0.18507, 0.16775, 0.13108, 0.08335, 0.36531, 
     8 0.06744, 0.18507, 0.16775, 0.13108, 0.08335, 0.36531, 
     9 0.06744, 0.18507, 0.16775, 0.13108, 0.08335, 0.36531, 
     T 0.06744, 0.18507, 0.16775, 0.13108, 0.08335, 0.36531, 
     1 0.06744, 0.18507, 0.16775, 0.13108, 0.08335, 0.36531, 
     2 0.06744, 0.18507, 0.16775, 0.13108, 0.08335, 0.36531, 
     3 0.06744, 0.18507, 0.16775, 0.13108, 0.08335, 0.36531, 
     4 0.06744, 0.18507, 0.16775, 0.13108, 0.08335, 0.36531, 
C 
C weekend 
C 
     1 0.06744, 0.18507, 0.16775, 0.13108, 0.08335, 0.36531, 
     2 0.06744, 0.18507, 0.16775, 0.13108, 0.08335, 0.36531, 
     3 0.06744, 0.18507, 0.16775, 0.13108, 0.08335, 0.36531, 
     4 0.06744, 0.18507, 0.16775, 0.13108, 0.08335, 0.36531, 
     5 0.06744, 0.18507, 0.16775, 0.13108, 0.08335, 0.36531, 
     6 0.06744, 0.18507, 0.16775, 0.13108, 0.08335, 0.36531, 
     7 0.06744, 0.18507, 0.16775, 0.13108, 0.08335, 0.36531, 
     8 0.06744, 0.18507, 0.16775, 0.13108, 0.08335, 0.36531, 
     9 0.06744, 0.18507, 0.16775, 0.13108, 0.08335, 0.36531, 
     T 0.06744, 0.18507, 0.16775, 0.13108, 0.08335, 0.36531, 
     1 0.06744, 0.18507, 0.16775, 0.13108, 0.08335, 0.36531, 
     2 0.06744, 0.18507, 0.16775, 0.13108, 0.08335, 0.36531, 
     3 0.06744, 0.18507, 0.16775, 0.13108, 0.08335, 0.36531, 
     4 0.06744, 0.18507, 0.16775, 0.13108, 0.08335, 0.36531/ 
C 
      DATA MAXTL/6/ 
C 
C 
C 
C  /RUNLS2/: vehicles running loss data for pressure/purge test pass, 
C            TLEMI's, and fail, TLFAIL's 
C 
C 
C  The continuation line code for TLEMI is ITLR( i.e., RVP or 
C  Reid vapor pressure): 
C 
C  1 : RVP = 7.0    2 : RVP = 9.0    3 : RVP = 10.4    4 : RVP = 11.7 
C 
C  NOTE: Unlike many of the IVGAS arrays, there is no entry in TLEMI  
C  for MC. There is an entry for GAS BUS, however. The index for GAS 
C  BUS (here only) is 14! 
C 
C  LDGV - 1972-77,1978-80,1981+ 
C 
      DATA TL1101/ 
C  80 degrees 
     1 0.30,0.30,0.31,0.32,0.34,0.40,0.09,0.11,0.12,0.12,0.13,0.15, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.33,0.41,0.48,0.59,0.66,0.86,0.10,0.13,0.14,0.17,0.19,0.24, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.36,0.56,0.81,1.14,1.44,1.91,0.11,0.17,0.18,0.26,0.34,0.49, 
     3 0.02,0.02,0.02,0.02,0.02,0.02, 
     4 0.62,1.06,1.67,2.84,3.92,5.16,0.14,0.31,0.37,0.57,0.70,0.91, 
     4 0.02,0.02,0.02,0.02,0.02,0.02/ 
       DATA TL2101/ 
C  87 degrees 
     1 0.32,0.36,0.36,0.39,0.42,0.52,0.09,0.13,0.13,0.14,0.15,0.18, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.35,0.52,0.73,0.99,1.23,1.61,0.10,0.16,0.17,0.23,0.29,0.41, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.62,1.05,1.63,2.77,3.81,5.01,0.14,0.31,0.37,0.57,0.69,0.88, 
     3 0.02,0.02,0.02,0.02,0.02,0.02, 
     4 0.77,1.70,3.81,7.07,9.91,12.24,0.14,0.35,0.56,1.22,1.71,2.36, 
     4 0.05,0.03,0.03,0.03,0.03,0.03/ 
      DATA TL3101/ 
C  95 degrees 
     1 0.34,0.44,0.54,0.71,0.83,1.14,0.10,0.14,0.15,0.20,0.23,0.32, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.61,1.01,1.48,2.46,3.38,4.50,0.14,0.30,0.35,0.51,0.61,0.77, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.79,1.79,4.10,7.66,10.73,13.15,0.15,0.36,0.59,1.32,1.87,2.56, 
     3 0.08,0.02,0.02,0.02,0.02,0.02, 
     4 0.97,2.53,6.66,12.76,17.65,21.12,0.16,0.42,0.84,2.15,3.05,4.18, 
     4 0.09,0.05,0.04,0.03,0.03,0.03/ 
      DATA TL4101/ 
C  105 degrees 
     1 0.37,0.61,0.95,1.40,1.80,2.38,0.11,0.18,0.20,0.31,0.41,0.61, 
     1 0.06,0.02,0.02,0.02,0.02,0.02, 
     2 0.83,1.93,4.58,8.61,12.07,14.73,0.15,0.37,0.63,1.46,2.09,2.88, 
     2 0.09,0.02,0.02,0.02,0.02,0.02, 
     3 1.05,2.86,7.81,15.09,20.24,24.26,0.16,0.45,0.98,2.56,3.46,4.81, 
     3 0.09,0.03,0.03,0.03,0.03,0.03, 
     4 1.26,3.74,10.94,20.17,27.34,32.36,0.18,0.53,1.33,3.26,4.55, 
     4 6.35,0.09,0.05,0.04,0.03,0.03,0.03/ 
C 
C  LDGV - has only one MY group beyond the precontrolled. 
C 
      DATA TL1201/72*0.0/ 
      DATA TL2201/72*0.0/ 
      DATA TL3201/72*0.0/ 
      DATA TL4201/72*0.0/ 
      DATA TL1301/72*0.0/ 
      DATA TL2301/72*0.0/ 
      DATA TL3301/72*0.0/ 
      DATA TL4301/72*0.0/ 
      DATA TL1401/72*0.0/ 
      DATA TL2401/72*0.0/ 
      DATA TL3401/72*0.0/ 
      DATA TL4401/72*0.0/ 
C 
C  LDGT1 - 1972-77,1978-80 (same as 1981+ LDGT for MOBILE4.1) 
C 
      DATA TL1102/ 
C  80 degrees 
     1 0.45,0.41,0.34,0.29,0.29,0.32,0.12,0.14,0.11,0.07,0.06,0.05, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.61,0.61,0.77,0.85,0.99,1.21,0.12,0.12,0.11,0.12,0.11,0.11, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.62,0.56,0.66,0.74,0.88,1.05,0.15,0.15,0.13,0.14,0.14,0.16, 
     3 0.02,0.02,0.02,0.02,0.02,0.02, 
     4 0.66,0.57,0.72,0.82,1.11,1.66,0.17,0.12,0.10,0.09,0.08,0.11, 
     4 0.02,0.02,0.02,0.02,0.02,0.02/ 
      DATA TL2102/ 
C  87 degrees 
     1 0.49,0.45,0.41,0.37,0.39,0.44,0.13,0.14,0.11,0.08,0.07,0.07, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.60,0.54,0.62,0.67,0.78,0.93,0.10,0.10,0.09,0.09,0.09,0.11, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.71,0.63,0.86,1.07,1.34,1.66,0.16,0.15,0.14,0.18,0.20,0.24, 
     3 0.02,0.02,0.02,0.02,0.02,0.02, 
     4 0.77,0.74,1.23,1.96,2.78,3.80,0.16,0.16,0.19,0.41,0.57,0.95, 
     4 0.05,0.03,0.03,0.03,0.03,0.03/ 
      DATA TL3102/ 
C  95 degrees 
     1 0.55,0.50,0.48,0.45,0.43,0.42,0.14,0.18,0.16,0.15,0.14,0.13, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.56,0.46,0.53,0.61,0.71,0.78,0.10,0.10,0.09,0.09,0.09,0.11, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.80,0.71,1.14,1.57,2.08,2.67,0.18,0.16,0.16,0.24,0.28,0.39, 
     3 0.08,0.02,0.02,0.02,0.02,0.02, 
     4 0.89,0.90,1.74,3.09,4.40,5.93,0.16,0.16,0.23,0.53,0.74,1.07, 
     4 0.09,0.05,0.04,0.03,0.03,0.03/ 
      DATA TL4102/ 
C  105 degrees 
     1 0.63,0.55,0.62,0.79,1.09,1.48,0.23,0.25,0.22,0.23,0.26,0.32, 
     1 0.06,0.02,0.02,0.02,0.02,0.02, 
     2 1.10,0.88,1.76,2.31,2.98,3.51,0.25,0.18,0.15,0.28,0.35,0.51, 
     2 0.09,0.02,0.02,0.02,0.02,0.02, 
     3 0.83,0.73,1.20,1.70,2.29,2.96,0.18,0.16,0.16,0.26,0.31,0.43, 
     3 0.09,0.03,0.03,0.03,0.03,0.03, 
     4 1.23,1.07,2.73,5.32,8.55,12.24,0.23,0.16,0.21,0.58,0.91,1.72, 
     4 0.09,0.05,0.04,0.03,0.03,0.03/ 
C 
C  LDGT1 - 1981+ 
C 
      DATA TL1202/ 
C  80 degrees 
     1 0.45,0.41,0.34,0.29,0.29,0.32,0.12,0.14,0.11,0.07,0.06,0.05, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.61,0.61,0.77,0.85,0.99,1.21,0.12,0.12,0.11,0.12,0.11,0.11, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.62,0.56,0.66,0.74,0.88,1.05,0.15,0.15,0.13,0.14,0.14,0.16, 
     3 0.02,0.02,0.02,0.02,0.02,0.02, 
     4 0.66,0.57,0.72,0.82,1.11,1.66,0.17,0.12,0.10,0.09,0.08,0.11, 
     4 0.02,0.02,0.02,0.02,0.02,0.02/ 
      DATA TL2202/ 
C  87 degrees 
     1 0.49,0.45,0.41,0.37,0.39,0.44,0.13,0.14,0.11,0.08,0.07,0.07, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.60,0.54,0.62,0.67,0.78,0.93,0.10,0.10,0.09,0.09,0.09,0.11, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.71,0.63,0.86,1.07,1.34,1.66,0.16,0.15,0.14,0.18,0.20,0.24, 
     3 0.02,0.02,0.02,0.02,0.02,0.02, 
     4 0.77,0.74,1.23,1.96,2.78,3.80,0.16,0.16,0.19,0.41,0.57,0.95, 
     4 0.05,0.03,0.03,0.03,0.03,0.03/ 
      DATA TL3202/ 
C  95 degrees 
     1 0.55,0.50,0.48,0.45,0.43,0.42,0.14,0.18,0.16,0.15,0.14,0.13, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.56,0.46,0.53,0.61,0.71,0.78,0.10,0.10,0.09,0.09,0.09,0.11, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.80,0.71,1.14,1.57,2.08,2.67,0.18,0.16,0.16,0.24,0.28,0.39, 
     3 0.08,0.02,0.02,0.02,0.02,0.02, 
     4 0.89,0.90,1.74,3.09,4.40,5.93,0.16,0.16,0.23,0.53,0.74,1.07, 
     4 0.09,0.05,0.04,0.03,0.03,0.03/ 
      DATA TL4202/ 
C  105 degrees 
     1 0.63,0.55,0.62,0.79,1.09,1.48,0.23,0.25,0.22,0.23,0.26,0.32, 
     1 0.06,0.02,0.02,0.02,0.02,0.02, 
     2 1.10,0.88,1.76,2.31,2.98,3.51,0.25,0.18,0.15,0.28,0.35,0.51, 
     2 0.09,0.02,0.02,0.02,0.02,0.02, 
     3 0.83,0.73,1.20,1.70,2.29,2.96,0.18,0.16,0.16,0.26,0.31,0.43, 
     3 0.09,0.03,0.03,0.03,0.03,0.03, 
     4 1.23,1.07,2.73,5.32,8.55,12.24,0.23,0.16,0.21,0.58,0.91,1.72, 
     4 0.09,0.05,0.04,0.03,0.03,0.03/ 
C 
C  LDGT1 - has only two MY groups beyond the precontrolled. 
C 
      DATA TL1302/72*0.0/ 
      DATA TL2302/72*0.0/ 
      DATA TL3302/72*0.0/ 
      DATA TL4302/72*0.0/ 
      DATA TL1402/72*0.0/ 
      DATA TL2402/72*0.0/ 
      DATA TL3402/72*0.0/ 
      DATA TL4402/72*0.0/ 
C 
C  LDGT2 - 1972-77,1978-80 (same as 1981+ LDGT for MOBILE4.1) 
C 
      DATA TL1103/ 
C  80 degrees 
     1 0.45,0.41,0.34,0.29,0.29,0.32,0.12,0.14,0.11,0.07,0.06,0.05, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.61,0.61,0.77,0.85,0.99,1.21,0.12,0.12,0.11,0.12,0.11,0.11, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.62,0.56,0.66,0.74,0.88,1.05,0.15,0.15,0.13,0.14,0.14,0.16, 
     3 0.02,0.02,0.02,0.02,0.02,0.02, 
     4 0.66,0.57,0.72,0.82,1.11,1.66,0.17,0.12,0.10,0.09,0.08,0.11, 
     4 0.02,0.02,0.02,0.02,0.02,0.02/ 
      DATA TL2103/ 
C  87 degrees 
     1 0.49,0.45,0.41,0.37,0.39,0.44,0.13,0.14,0.11,0.08,0.07,0.07, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.60,0.54,0.62,0.67,0.78,0.93,0.10,0.10,0.09,0.09,0.09,0.11, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.71,0.63,0.86,1.07,1.34,1.66,0.16,0.15,0.14,0.18,0.20,0.24, 
     3 0.02,0.02,0.02,0.02,0.02,0.02, 
     4 0.77,0.74,1.23,1.96,2.78,3.80,0.16,0.16,0.19,0.41,0.57,0.95, 
     4 0.05,0.03,0.03,0.03,0.03,0.03/ 
      DATA TL3103/ 
C  95 degrees 
     1 0.55,0.50,0.48,0.45,0.43,0.42,0.14,0.18,0.16,0.15,0.14,0.13, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.56,0.46,0.53,0.61,0.71,0.78,0.10,0.10,0.09,0.09,0.09,0.11, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.80,0.71,1.14,1.57,2.08,2.67,0.18,0.16,0.16,0.24,0.28,0.39, 
     3 0.08,0.02,0.02,0.02,0.02,0.02, 
     4 0.89,0.90,1.74,3.09,4.40,5.93,0.16,0.16,0.23,0.53,0.74,1.07, 
     4 0.09,0.05,0.04,0.03,0.03,0.03/ 
      DATA TL4103/ 
C  105 degrees 
     1 0.63,0.55,0.62,0.79,1.09,1.48,0.23,0.25,0.22,0.23,0.26,0.32, 
     1 0.06,0.02,0.02,0.02,0.02,0.02, 
     2 1.10,0.88,1.76,2.31,2.98,3.51,0.25,0.18,0.15,0.28,0.35,0.51, 
     2 0.09,0.02,0.02,0.02,0.02,0.02, 
     3 0.83,0.73,1.20,1.70,2.29,2.96,0.18,0.16,0.16,0.26,0.31,0.43, 
     3 0.09,0.03,0.03,0.03,0.03,0.03, 
     4 1.23,1.07,2.73,5.32,8.55,12.24,0.23,0.16,0.21,0.58,0.91,1.72, 
     4 0.09,0.05,0.04,0.03,0.03,0.03/ 
C 
C  LDGT2 - 1981+ 
C 
      DATA TL1203/ 
C  80 degrees 
     1 0.45,0.41,0.34,0.29,0.29,0.32,0.12,0.14,0.11,0.07,0.06,0.05, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.61,0.61,0.77,0.85,0.99,1.21,0.12,0.12,0.11,0.12,0.11,0.11, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.62,0.56,0.66,0.74,0.88,1.05,0.15,0.15,0.13,0.14,0.14,0.16, 
     3 0.02,0.02,0.02,0.02,0.02,0.02, 
     4 0.66,0.57,0.72,0.82,1.11,1.66,0.17,0.12,0.10,0.09,0.08,0.11, 
     4 0.02,0.02,0.02,0.02,0.02,0.02/ 
      DATA TL2203/ 
C  87 degrees 
     1 0.49,0.45,0.41,0.37,0.39,0.44,0.13,0.14,0.11,0.08,0.07,0.07, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.60,0.54,0.62,0.67,0.78,0.93,0.10,0.10,0.09,0.09,0.09,0.11, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.71,0.63,0.86,1.07,1.34,1.66,0.16,0.15,0.14,0.18,0.20,0.24, 
     3 0.02,0.02,0.02,0.02,0.02,0.02, 
     4 0.77,0.74,1.23,1.96,2.78,3.80,0.16,0.16,0.19,0.41,0.57,0.95, 
     4 0.05,0.03,0.03,0.03,0.03,0.03/ 
      DATA TL3203/ 
C  95 degrees 
     1 0.55,0.50,0.48,0.45,0.43,0.42,0.14,0.18,0.16,0.15,0.14,0.13, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.56,0.46,0.53,0.61,0.71,0.78,0.10,0.10,0.09,0.09,0.09,0.11, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.80,0.71,1.14,1.57,2.08,2.67,0.18,0.16,0.16,0.24,0.28,0.39, 
     3 0.08,0.02,0.02,0.02,0.02,0.02, 
     4 0.89,0.90,1.74,3.09,4.40,5.93,0.16,0.16,0.23,0.53,0.74,1.07, 
     4 0.09,0.05,0.04,0.03,0.03,0.03/ 
      DATA TL4203/ 
C  105 degrees 
     1 0.63,0.55,0.62,0.79,1.09,1.48,0.23,0.25,0.22,0.23,0.26,0.32, 
     1 0.06,0.02,0.02,0.02,0.02,0.02, 
     2 1.1 ,0.88,1.76,2.31,2.98,3.51,0.25,0.18,0.15,0.28,0.35,0.51, 
     2 0.09,0.02,0.02,0.02,0.02,0.02, 
     3 0.83,0.73,1.20,1.70,2.29,2.96,0.18,0.16,0.16,0.26,0.31,0.43, 
     3 0.09,0.03,0.03,0.03,0.03,0.03, 
     4 1.23,1.07,2.73,5.32,8.55,12.24,0.23,0.16,0.21,0.58,0.91,1.72, 
     4 0.09,0.05,0.04,0.03,0.03,0.03/ 
C 
C  LDGT2 - has only two MY groups beyond the precontrolled. 
C 
      DATA TL1303/72*0.0/ 
      DATA TL2303/72*0.0/ 
      DATA TL3303/72*0.0/ 
      DATA TL4303/72*0.0/ 
      DATA TL1403/72*0.0/ 
      DATA TL2403/72*0.0/ 
      DATA TL3403/72*0.0/ 
      DATA TL4403/72*0.0/ 
C 
C  LDGT3 - 1979-80 (same as LDGT12 1981+ for MOBILE4.1) 
C 
      DATA TL1104/ 
C  80 degrees 
     1 0.45,0.41,0.34,0.29,0.29,0.32,0.12,0.14,0.11,0.07,0.06,0.05, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.61,0.61,0.77,0.85,0.99,1.21,0.12,0.12,0.11,0.12,0.11,0.11, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.62,0.56,0.66,0.74,0.88,1.05,0.15,0.15,0.13,0.14,0.14,0.16, 
     3 0.02,0.02,0.02,0.02,0.02,0.02, 
     4 0.66,0.57,0.72,0.82,1.11,1.66,0.17,0.12,0.10,0.09,0.08,0.11, 
     4 0.02,0.02,0.02,0.02,0.02,0.02/ 
      DATA TL2104/ 
C  87 degrees 
     1 0.49,0.45,0.41,0.37,0.39,0.44,0.13,0.14,0.11,0.08,0.07,0.07, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.60,0.54,0.62,0.67,0.78,0.93,0.10,0.10,0.09,0.09,0.09,0.11, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.71,0.63,0.86,1.07,1.34,1.66,0.16,0.15,0.14,0.18,0.20,0.24, 
     3 0.02,0.02,0.02,0.02,0.02,0.02, 
     4 0.77,0.74,1.23,1.96,2.78,3.80,0.16,0.16,0.19,0.41,0.57,0.95, 
     4 0.05,0.03,0.03,0.03,0.03,0.03/ 
      DATA TL3104/ 
C  95 degrees 
     1 0.55,0.50,0.48,0.45,0.43,0.42,0.14,0.18,0.16,0.15,0.14,0.13, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.56,0.46,0.53,0.61,0.71,0.78,0.10,0.10,0.09,0.09,0.09,0.11, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.80,0.71,1.14,1.57,2.08,2.67,0.18,0.16,0.16,0.24,0.28,0.39, 
     3 0.08,0.02,0.02,0.02,0.02,0.02, 
     4 0.89,0.90,1.74,3.09,4.40,5.93,0.16,0.16,0.23,0.53,0.74,1.07, 
     4 0.09,0.05,0.04,0.03,0.03,0.03/ 
      DATA TL4104/ 
C  105 degrees 
     1 0.63,0.55,0.62,0.79,1.09,1.48,0.23,0.25,0.22,0.23,0.26,0.32, 
     1 0.06,0.02,0.02,0.02,0.02,0.02, 
     2 1.10,0.88,1.76,2.31,2.98,3.51,0.25,0.18,0.15,0.28,0.35,0.51, 
     2 0.09,0.02,0.02,0.02,0.02,0.02, 
     3 0.83,0.73,1.20,1.70,2.29,2.96,0.18,0.16,0.16,0.26,0.31,0.43, 
     3 0.09,0.03,0.03,0.03,0.03,0.03, 
     4 1.23,1.07,2.73,5.32,8.55,12.24,0.23,0.16,0.21,0.58,0.91,1.72, 
     4 0.09,0.05,0.04,0.03,0.03,0.03/ 
C 
C  LDGT3 - 1981+ (same as LDGT12 1981+ for MOBILE4.1) 
C 
      DATA TL1204/ 
C  80 degrees 
     1 0.45,0.41,0.34,0.29,0.29,0.32,0.12,0.14,0.11,0.07,0.06,0.05, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.61,0.61,0.77,0.85,0.99,1.21,0.12,0.12,0.11,0.12,0.11,0.11, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.62,0.56,0.66,0.74,0.88,1.05,0.15,0.15,0.13,0.14,0.14,0.16, 
     3 0.02,0.02,0.02,0.02,0.02,0.02, 
     4 0.66,0.57,0.72,0.82,1.11,1.66,0.17,0.12,0.10,0.09,0.08,0.11, 
     4 0.02,0.02,0.02,0.02,0.02,0.02/ 
      DATA TL2204/ 
C  87 degrees 
     1 0.49,0.45,0.41,0.37,0.39,0.44,0.13,0.14,0.11,0.08,0.07,0.07, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.60,0.54,0.62,0.67,0.78,0.93,0.10,0.10,0.09,0.09,0.09,0.11, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.71,0.63,0.86,1.07,1.34,1.66,0.16,0.15,0.14,0.18,0.20,0.24, 
     3 0.02,0.02,0.02,0.02,0.02,0.02, 
     4 0.77,0.74,1.23,1.96,2.78,3.80,0.16,0.16,0.19,0.41,0.57,0.95, 
     4 0.05,0.03,0.03,0.03,0.03,0.03/ 
      DATA TL3204/ 
C  95 degrees 
     1 0.55,0.50,0.48,0.45,0.43,0.42,0.14,0.18,0.16,0.15,0.14,0.13, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.56,0.46,0.53,0.61,0.71,0.78,0.10,0.10,0.09,0.09,0.09,0.11, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.80,0.71,1.14,1.57,2.08,2.67,0.18,0.16,0.16,0.24,0.28,0.39, 
     3 0.08,0.02,0.02,0.02,0.02,0.02, 
     4 0.89,0.90,1.74,3.09,4.40,5.93,0.16,0.16,0.23,0.53,0.74,1.07, 
     4 0.09,0.05,0.04,0.03,0.03,0.03/ 
      DATA TL4204/ 
C  105 degrees 
     1 0.63,0.55,0.62,0.79,1.09,1.48,0.23,0.25,0.22,0.23,0.26,0.32, 
     1 0.06,0.02,0.02,0.02,0.02,0.02, 
     2 1.10,0.88,1.76,2.31,2.98,3.51,0.25,0.18,0.15,0.28,0.35,0.51, 
     2 0.09,0.02,0.02,0.02,0.02,0.02, 
     3 0.83,0.73,1.20,1.70,2.29,2.96,0.18,0.16,0.16,0.26,0.31,0.43, 
     3 0.09,0.03,0.03,0.03,0.03,0.03, 
     4 1.23,1.07,2.73,5.32,8.55,12.24,0.23,0.16,0.21,0.58,0.91,1.72, 
     4 0.09,0.05,0.04,0.03,0.03,0.03/ 
C 
C  LDGT3 - has only two MY groups beyond the precontrolled. 
C 
      DATA TL1304/72*0.0/ 
      DATA TL2304/72*0.0/ 
      DATA TL3304/72*0.0/ 
      DATA TL4304/72*0.0/ 
      DATA TL1404/72*0.0/ 
      DATA TL2404/72*0.0/ 
      DATA TL3404/72*0.0/ 
      DATA TL4404/72*0.0/ 
C 
C  LDGT4 - 1979-80 (same as LDGT12 1981+ for MOBILE4.1) 
C 
      DATA TL1105/ 
C  80 degrees 
     1 0.45,0.41,0.34,0.29,0.29,0.32,0.12,0.14,0.11,0.07,0.06,0.05, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.61,0.61,0.77,0.85,0.99,1.21,0.12,0.12,0.11,0.12,0.11,0.11, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.62,0.56,0.66,0.74,0.88,1.05,0.15,0.15,0.13,0.14,0.14,0.16, 
     3 0.02,0.02,0.02,0.02,0.02,0.02, 
     4 0.66,0.57,0.72,0.82,1.11,1.66,0.17,0.12,0.10,0.09,0.08,0.11, 
     4 0.02,0.02,0.02,0.02,0.02,0.02/ 
      DATA TL2105/ 
C  87 degrees 
     1 0.49,0.45,0.41,0.37,0.39,0.44,0.13,0.14,0.11,0.08,0.07,0.07, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.60,0.54,0.62,0.67,0.78,0.93,0.10,0.10,0.09,0.09,0.09,0.11, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.71,0.63,0.86,1.07,1.34,1.66,0.16,0.15,0.14,0.18,0.20,0.24, 
     3 0.02,0.02,0.02,0.02,0.02,0.02, 
     4 0.77,0.74,1.23,1.96,2.78,3.80,0.16,0.16,0.19,0.41,0.57,0.95, 
     4 0.05,0.03,0.03,0.03,0.03,0.03/ 
      DATA TL3105/ 
C  95 degrees 
     1 0.55,0.50,0.48,0.45,0.43,0.42,0.14,0.18,0.16,0.15,0.14,0.13, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.56,0.46,0.53,0.61,0.71,0.78,0.10,0.10,0.09,0.09,0.09,0.11, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.80,0.71,1.14,1.57,2.08,2.67,0.18,0.16,0.16,0.24,0.28,0.39, 
     3 0.08,0.02,0.02,0.02,0.02,0.02, 
     4 0.89,0.90,1.74,3.09,4.40,5.93,0.16,0.16,0.23,0.53,0.74,1.07, 
     4 0.09,0.05,0.04,0.03,0.03,0.03/ 
      DATA TL4105/ 
C  105 degrees 
     1 0.63,0.55,0.62,0.79,1.09,1.48,0.23,0.25,0.22,0.23,0.26,0.32, 
     1 0.06,0.02,0.02,0.02,0.02,0.02, 
     2 1.10,0.88,1.76,2.31,2.98,3.51,0.25,0.18,0.15,0.28,0.35,0.51, 
     2 0.09,0.02,0.02,0.02,0.02,0.02, 
     3 0.83,0.73,1.20,1.70,2.29,2.96,0.18,0.16,0.16,0.26,0.31,0.43, 
     3 0.09,0.03,0.03,0.03,0.03,0.03, 
     4 1.23,1.07,2.73,5.32,8.55,12.24,0.23,0.16,0.21,0.58,0.91,1.72, 
     4 0.09,0.05,0.04,0.03,0.03,0.03/ 
C 
C  LDGT4 - 1981+ (same as LDGT12 1981+ for MOBILE4.1) 
C 
      DATA TL1205/ 
C  80 degrees 
     1 0.45,0.41,0.34,0.29,0.29,0.32,0.12,0.14,0.11,0.07,0.06,0.05, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.61,0.61,0.77,0.85,0.99,1.21,0.12,0.12,0.11,0.12,0.11,0.11, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.62,0.56,0.66,0.74,0.88,1.05,0.15,0.15,0.13,0.14,0.14,0.16, 
     3 0.02,0.02,0.02,0.02,0.02,0.02, 
     4 0.66,0.57,0.72,0.82,1.11,1.66,0.17,0.12,0.10,0.09,0.08,0.11, 
     4 0.02,0.02,0.02,0.02,0.02,0.02/ 
      DATA TL2205/ 
C  87 degrees 
     1 0.49,0.45,0.41,0.37,0.39,0.44,0.13,0.14,0.11,0.08,0.07,0.07, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.60,0.54,0.62,0.67,0.78,0.93,0.10,0.10,0.09,0.09,0.09,0.11, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.71,0.63,0.86,1.07,1.34,1.66,0.16,0.15,0.14,0.18,0.20,0.24, 
     3 0.02,0.02,0.02,0.02,0.02,0.02, 
     4 0.77,0.74,1.23,1.96,2.78,3.80,0.16,0.16,0.19,0.41,0.57,0.95, 
     4 0.05,0.03,0.03,0.03,0.03,0.03/ 
      DATA TL3205/ 
C  95 degrees 
     1 0.55,0.50,0.48,0.45,0.43,0.42,0.14,0.18,0.16,0.15,0.14,0.13, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.56,0.46,0.53,0.61,0.71,0.78,0.10,0.10,0.09,0.09,0.09,0.11, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.80,0.71,1.14,1.57,2.08,2.67,0.18,0.16,0.16,0.24,0.28,0.39, 
     3 0.08,0.02,0.02,0.02,0.02,0.02, 
     4 0.89,0.90,1.74,3.09,4.40,5.93,0.16,0.16,0.23,0.53,0.74,1.07, 
     4 0.09,0.05,0.04,0.03,0.03,0.03/ 
      DATA TL4205/ 
C  105 degrees 
     1 0.63,0.55,0.62,0.79,1.09,1.48,0.23,0.25,0.22,0.23,0.26,0.32, 
     1 0.06,0.02,0.02,0.02,0.02,0.02, 
     2 1.10,0.88,1.76,2.31,2.98,3.51,0.25,0.18,0.15,0.28,0.35,0.51, 
     2 0.09,0.02,0.02,0.02,0.02,0.02, 
     3 0.83,0.73,1.20,1.70,2.29,2.96,0.18,0.16,0.16,0.26,0.31,0.43, 
     3 0.09,0.03,0.03,0.03,0.03,0.03, 
     4 1.23,1.07,2.73,5.32,8.55,12.24,0.23,0.16,0.21,0.58,0.91,1.72, 
     4 0.09,0.05,0.04,0.03,0.03,0.03/ 
C 
C  LDGT4 - has only two MY groups beyond the precontrolled. 
C 
      DATA TL1305/72*0.0/ 
      DATA TL2305/72*0.0/ 
      DATA TL3305/72*0.0/ 
      DATA TL4305/72*0.0/ 
      DATA TL1405/72*0.0/ 
      DATA TL2405/72*0.0/ 
      DATA TL3405/72*0.0/ 
      DATA TL4405/72*0.0/ 
C 
C  HDGV2B - 1985+ (same as 1981+ LDGV for MOBILE4.1) 
C 
      DATA TL1106/ 
C  80 degrees 
     1 0.30,0.30,0.31,0.32,0.34,0.40,0.09,0.11,0.12,0.12,0.13,0.15, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.33,0.41,0.48,0.59,0.66,0.86,0.10,0.13,0.14,0.17,0.19,0.24, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.36,0.56,0.81,1.14,1.44,1.91,0.11,0.16,0.18,0.26,0.34,0.49, 
     3 0.02,0.02,0.02,0.02,0.02,0.02, 
     4 0.62,1.06,1.67,2.84,3.92,5.16,0.14,0.31,0.37,0.57,0.70,0.91, 
     4 0.02,0.02,0.02,0.02,0.02,0.02/ 
       DATA TL2106/ 
C  87 degrees 
     1 0.32,0.36,0.36,0.39,0.42,0.52,0.09,0.13,0.13,0.14,0.15,0.18, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.35,0.52,0.73,0.99,1.23,1.61,0.10,0.16,0.17,0.23,0.29,0.41, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.62,1.05,1.63,2.77,3.81,5.01,0.14,0.31,0.37,0.57,0.69,0.88, 
     3 0.02,0.02,0.02,0.02,0.02,0.02, 
     4 0.77,1.70,3.81,7.07,9.91,12.24,0.14,0.35,0.56,1.22,1.71,2.36, 
     4 0.05,0.03,0.03,0.03,0.03,0.03/ 
      DATA TL3106/ 
C  95 degrees 
     1 0.34,0.44,0.54,0.71,0.83,1.14,0.10,0.14,0.15,0.20,0.23,0.32, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.61,1.01,1.48,2.46,3.38,4.50,0.14,0.30,0.35,0.51,0.61,0.77, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.79,1.79,4.10,7.66,10.73,13.15,0.15,0.36,0.59,1.32,1.87,2.56, 
     3 0.08,0.02,0.02,0.02,0.02,0.02, 
     4 0.97,2.53,6.66,12.76,17.65,21.12,0.16,0.42,0.84,2.15,3.05,4.18, 
     4 0.09,0.05,0.04,0.03,0.03,0.03/ 
      DATA TL4106/ 
C  105 degrees 
     1 0.37,0.61,0.95,1.40,1.80,2.38,0.11,0.18,0.20,0.31,0.41,0.61, 
     1 0.06,0.02,0.02,0.02,0.02,0.02, 
     2 0.83,1.93,4.58,8.6,12.07,14.73,0.15,0.37,0.63,1.46,2.09,2.88, 
     2 0.09,0.02,0.02,0.02,0.02,0.02, 
     3 1.05,2.86,7.81,15.09,20.24,24.26,0.16,0.45,0.98,2.56,3.46,4.81, 
     3 0.09,0.03,0.03,0.03,0.03,0.03, 
     4 1.26,3.74,10.94,20.17,27.34,32.36,0.18,0.53,1.33,3.26,4.55, 
     4 6.35,0.09,0.05,0.04,0.03,0.03,0.03/ 
C 
C  HDGV2B - has only one MY group beyond the precontrolled. 
C 
      DATA TL1206/72*0.0/ 
      DATA TL2206/72*0.0/ 
      DATA TL3206/72*0.0/ 
      DATA TL4206/72*0.0/ 
      DATA TL1306/72*0.0/ 
      DATA TL2306/72*0.0/ 
      DATA TL3306/72*0.0/ 
      DATA TL4306/72*0.0/ 
      DATA TL1406/72*0.0/ 
      DATA TL2406/72*0.0/ 
      DATA TL3406/72*0.0/ 
      DATA TL4406/72*0.0/ 
C 
C  HDGV3 - 1985+ (same as 1981+ LDGV for MOBILE4.1) 
C 
      DATA TL1107/ 
C  80 degrees 
     1 0.30,0.30,0.31,0.32,0.34,0.40,0.09,0.11,0.12,0.12,0.13,0.15, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.33,0.41,0.48,0.59,0.66,0.86,0.10,0.13,0.14,0.17,0.19,0.24, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.36,0.56,0.81,1.14,1.44,1.91,0.11,0.16,0.18,0.26,0.34,0.49, 
     3 0.02,0.02,0.02,0.02,0.02,0.02, 
     4 0.62,1.06,1.67,2.84,3.92,5.16,0.14,0.31,0.37,0.57,0.70,0.91, 
     4 0.02,0.02,0.02,0.02,0.02,0.02/ 
       DATA TL2107/ 
C  87 degrees 
     1 0.32,0.36,0.36,0.39,0.42,0.52,0.09,0.13,0.13,0.14,0.15,0.18, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.35,0.52,0.73,0.99,1.23,1.61,0.10,0.16,0.17,0.23,0.29,0.41, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.62,1.05,1.63,2.77,3.81,5.01,0.14,0.31,0.37,0.57,0.69,0.88, 
     3 0.02,0.02,0.02,0.02,0.02,0.02, 
     4 0.77,1.70,3.81,7.07,9.91,12.24,0.14,0.35,0.56,1.22,1.71,2.36, 
     4 0.05,0.03,0.03,0.03,0.03,0.03/ 
      DATA TL3107/ 
C  95 degrees 
     1 0.34,0.44,0.54,0.71,0.83,1.14,0.10,0.14,0.15,0.20,0.23,0.32, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.61,1.01,1.48,2.46,3.38,4.50,0.14,0.30,0.35,0.51,0.61,0.77, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.79,1.79,4.10,7.66,10.73,13.15,0.15,0.36,0.59,1.32,1.87,2.56, 
     3 0.08,0.02,0.02,0.02,0.02,0.02, 
     4 0.97,2.53,6.66,12.76,17.65,21.12,0.16,0.42,0.84,2.15,3.05,4.18, 
     4 0.09,0.05,0.04,0.03,0.03,0.03/ 
      DATA TL4107/ 
C  105 degrees 
     1 0.37,0.61,0.95,1.40,1.80,2.38,0.11,0.18,0.20,0.31,0.41,0.61, 
     1 0.06,0.02,0.02,0.02,0.02,0.02, 
     2 0.83,1.93,4.58,8.6,12.07,14.73,0.15,0.37,0.63,1.46,2.09,2.88, 
     2 0.09,0.02,0.02,0.02,0.02,0.02, 
     3 1.05,2.86,7.81,15.09,20.24,24.26,0.16,0.45,0.98,2.56,3.46,4.81, 
     3 0.09,0.03,0.03,0.03,0.03,0.03, 
     4 1.26,3.74,10.94,20.17,27.34,32.36,0.18,0.53,1.33,3.26,4.55, 
     4 6.35,0.09,0.05,0.04,0.03,0.03,0.03/ 
C 
C  HDGV3 - has only one MY group beyond the precontrolled. 
C 
      DATA TL1207/72*0.0/ 
      DATA TL2207/72*0.0/ 
      DATA TL3207/72*0.0/ 
      DATA TL4207/72*0.0/ 
      DATA TL1307/72*0.0/ 
      DATA TL2307/72*0.0/ 
      DATA TL3307/72*0.0/ 
      DATA TL4307/72*0.0/ 
      DATA TL1407/72*0.0/ 
      DATA TL2407/72*0.0/ 
      DATA TL3407/72*0.0/ 
      DATA TL4407/72*0.0/ 
C 
C  HDGV4 - 1985+ (same as 1981+ LDGV for MOBILE4.1) 
C 
      DATA TL1108/ 
C  80 degrees 
     1 0.30,0.30,0.31,0.32,0.34,0.40,0.09,0.11,0.12,0.12,0.13,0.15, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.33,0.41,0.48,0.59,0.66,0.86,0.10,0.13,0.14,0.17,0.19,0.24, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.36,0.56,0.81,1.14,1.44,1.91,0.11,0.16,0.18,0.26,0.34,0.49, 
     3 0.02,0.02,0.02,0.02,0.02,0.02, 
     4 0.62,1.06,1.67,2.84,3.92,5.16,0.14,0.31,0.37,0.57,0.70,0.91, 
     4 0.02,0.02,0.02,0.02,0.02,0.02/ 
       DATA TL2108/ 
C  87 degrees 
     1 0.32,0.36,0.36,0.39,0.42,0.52,0.09,0.13,0.13,0.14,0.15,0.18, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.35,0.52,0.73,0.99,1.23,1.61,0.10,0.16,0.17,0.23,0.29,0.41, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.62,1.05,1.63,2.77,3.81,5.01,0.14,0.31,0.37,0.57,0.69,0.88, 
     3 0.02,0.02,0.02,0.02,0.02,0.02, 
     4 0.77,1.70,3.81,7.07,9.91,12.24,0.14,0.35,0.56,1.22,1.71,2.36, 
     4 0.05,0.03,0.03,0.03,0.03,0.03/ 
      DATA TL3108/ 
C  95 degrees 
     1 0.34,0.44,0.54,0.71,0.83,1.14,0.10,0.14,0.15,0.20,0.23,0.32, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.61,1.01,1.48,2.46,3.38,4.50,0.14,0.30,0.35,0.51,0.61,0.77, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.79,1.79,4.10,7.66,10.73,13.15,0.15,0.36,0.59,1.32,1.87,2.56, 
     3 0.08,0.02,0.02,0.02,0.02,0.02, 
     4 0.97,2.53,6.66,12.76,17.65,21.12,0.16,0.42,0.84,2.15,3.05,4.18, 
     4 0.09,0.05,0.04,0.03,0.03,0.03/ 
      DATA TL4108/ 
C  105 degrees 
     1 0.37,0.61,0.95,1.40,1.80,2.38,0.11,0.18,0.20,0.31,0.41,0.61, 
     1 0.06,0.02,0.02,0.02,0.02,0.02, 
     2 0.83,1.93,4.58,8.6,12.07,14.73,0.15,0.37,0.63,1.46,2.09,2.88, 
     2 0.09,0.02,0.02,0.02,0.02,0.02, 
     3 1.05,2.86,7.81,15.09,20.24,24.26,0.16,0.45,0.98,2.56,3.46,4.81, 
     3 0.09,0.03,0.03,0.03,0.03,0.03, 
     4 1.26,3.74,10.94,20.17,27.34,32.36,0.18,0.53,1.33,3.26,4.55, 
     4 6.35,0.09,0.05,0.04,0.03,0.03,0.03/ 
C 
C  HDGV4 - has only one MY group beyond the precontrolled. 
C 
      DATA TL1208/72*0.0/ 
      DATA TL2208/72*0.0/ 
      DATA TL3208/72*0.0/ 
      DATA TL4208/72*0.0/ 
      DATA TL1308/72*0.0/ 
      DATA TL2308/72*0.0/ 
      DATA TL3308/72*0.0/ 
      DATA TL4308/72*0.0/ 
      DATA TL1408/72*0.0/ 
      DATA TL2408/72*0.0/ 
      DATA TL3408/72*0.0/ 
      DATA TL4408/72*0.0/ 
C 
C  HDGV5 - 1985+ (same as 1981+ LDGV for MOBILE4.1) 
C 
      DATA TL1109/ 
C  80 degrees 
     1 0.30,0.30,0.31,0.32,0.34,0.40,0.09,0.11,0.12,0.12,0.13,0.15, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.33,0.41,0.48,0.59,0.66,0.86,0.10,0.13,0.14,0.17,0.19,0.24, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.36,0.56,0.81,1.14,1.44,1.91,0.11,0.16,0.18,0.26,0.34,0.49, 
     3 0.02,0.02,0.02,0.02,0.02,0.02, 
     4 0.62,1.06,1.67,2.84,3.92,5.16,0.14,0.31,0.37,0.57,0.70,0.91, 
     4 0.02,0.02,0.02,0.02,0.02,0.02/ 
      DATA TL2109/ 
C  87 degrees 
     1 0.32,0.36,0.36,0.39,0.42,0.52,0.09,0.13,0.13,0.14,0.15,0.18, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.35,0.52,0.73,0.99,1.23,1.61,0.10,0.16,0.17,0.23,0.29,0.41, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.62,1.05,1.63,2.77,3.81,5.01,0.14,0.31,0.37,0.57,0.69,0.88, 
     3 0.02,0.02,0.02,0.02,0.02,0.02, 
     4 0.77,1.70,3.81,7.07,9.91,12.24,0.14,0.35,0.56,1.22,1.71,2.36, 
     4 0.05,0.03,0.03,0.03,0.03,0.03/ 
      DATA TL3109/ 
C  95 degrees 
     1 0.34,0.44,0.54,0.71,0.83,1.14,0.10,0.14,0.15,0.20,0.23,0.32, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.61,1.01,1.48,2.46,3.38,4.50,0.14,0.30,0.35,0.51,0.61,0.77, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.79,1.79,4.10,7.66,10.73,13.15,0.15,0.36,0.59,1.32,1.87,2.56, 
     3 0.08,0.02,0.02,0.02,0.02,0.02, 
     4 0.97,2.53,6.66,12.76,17.65,21.12,0.16,0.42,0.84,2.15,3.05,4.18, 
     4 0.09,0.05,0.04,0.03,0.03,0.03/ 
      DATA TL4109/ 
C  105 degrees 
     1 0.37,0.61,0.95,1.40,1.80,2.38,0.11,0.18,0.20,0.31,0.41,0.61, 
     1 0.06,0.02,0.02,0.02,0.02,0.02, 
     2 0.83,1.93,4.58,8.6,12.07,14.73,0.15,0.37,0.63,1.46,2.09,2.88, 
     2 0.09,0.02,0.02,0.02,0.02,0.02, 
     3 1.05,2.86,7.81,15.09,20.24,24.26,0.16,0.45,0.98,2.56,3.46,4.81, 
     3 0.09,0.03,0.03,0.03,0.03,0.03, 
     4 1.26,3.74,10.94,20.17,27.34,32.36,0.18,0.53,1.33,3.26,4.55, 
     4 6.35,0.09,0.05,0.04,0.03,0.03,0.03/ 
C 
C  HDGV5 - has only one MY group beyond the precontrolled. 
C 
      DATA TL1209/72*0.0/ 
      DATA TL2209/72*0.0/ 
      DATA TL3209/72*0.0/ 
      DATA TL4209/72*0.0/ 
      DATA TL1309/72*0.0/ 
      DATA TL2309/72*0.0/ 
      DATA TL3309/72*0.0/ 
      DATA TL4309/72*0.0/ 
      DATA TL1409/72*0.0/ 
      DATA TL2409/72*0.0/ 
      DATA TL3409/72*0.0/ 
      DATA TL4409/72*0.0/ 
C 
C  HDGV6 - 1985+ (same as 1981+ LDGV for MOBILE4.1) 
C 
      DATA TL1110/ 
C  80 degrees 
     1 0.30,0.30,0.31,0.32,0.34,0.40,0.09,0.11,0.12,0.12,0.13,0.15, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.33,0.41,0.48,0.59,0.66,0.86,0.10,0.13,0.14,0.17,0.19,0.24, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.36,0.56,0.81,1.14,1.44,1.91,0.11,0.16,0.18,0.26,0.34,0.49, 
     3 0.02,0.02,0.02,0.02,0.02,0.02, 
     4 0.62,1.06,1.67,2.84,3.92,5.16,0.14,0.31,0.37,0.57,0.70,0.91, 
     4 0.02,0.02,0.02,0.02,0.02,0.02/ 
       DATA TL2110/ 
C  87 degrees 
     1 0.32,0.36,0.36,0.39,0.42,0.52,0.09,0.13,0.13,0.14,0.15,0.18, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.35,0.52,0.73,0.99,1.23,1.61,0.10,0.16,0.17,0.23,0.29,0.41, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.62,1.05,1.63,2.77,3.81,5.01,0.14,0.31,0.37,0.57,0.69,0.88, 
     3 0.02,0.02,0.02,0.02,0.02,0.02, 
     4 0.77,1.70,3.81,7.07,9.91,12.24,0.14,0.35,0.56,1.22,1.71,2.36, 
     4 0.05,0.03,0.03,0.03,0.03,0.03/ 
      DATA TL3110/ 
C  95 degrees 
     1 0.34,0.44,0.54,0.71,0.83,1.14,0.10,0.14,0.15,0.20,0.23,0.32, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.61,1.01,1.48,2.46,3.38,4.50,0.14,0.30,0.35,0.51,0.61,0.77, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.79,1.79,4.10,7.66,10.73,13.15,0.15,0.36,0.59,1.32,1.87,2.56, 
     3 0.08,0.02,0.02,0.02,0.02,0.02, 
     4 0.97,2.53,6.66,12.76,17.65,21.12,0.16,0.42,0.84,2.15,3.05,4.18, 
     4 0.09,0.05,0.04,0.03,0.03,0.03/ 
      DATA TL4110/ 
C  105 degrees 
     1 0.37,0.61,0.95,1.40,1.80,2.38,0.11,0.18,0.20,0.31,0.41,0.61, 
     1 0.06,0.02,0.02,0.02,0.02,0.02, 
     2 0.83,1.93,4.58,8.6,12.07,14.73,0.15,0.37,0.63,1.46,2.09,2.88, 
     2 0.09,0.02,0.02,0.02,0.02,0.02, 
     3 1.05,2.86,7.81,15.09,20.24,24.26,0.16,0.45,0.98,2.56,3.46,4.81, 
     3 0.09,0.03,0.03,0.03,0.03,0.03, 
     4 1.26,3.74,10.94,20.17,27.34,32.36,0.18,0.53,1.33,3.26,4.55, 
     4 6.35,0.09,0.05,0.04,0.03,0.03,0.03/ 
C 
C  HDGV6 - has only one MY group beyond the precontrolled. 
C 
      DATA TL1210/72*0.0/ 
      DATA TL2210/72*0.0/ 
      DATA TL3210/72*0.0/ 
      DATA TL4210/72*0.0/ 
      DATA TL1310/72*0.0/ 
      DATA TL2310/72*0.0/ 
      DATA TL3310/72*0.0/ 
      DATA TL4310/72*0.0/ 
      DATA TL1410/72*0.0/ 
      DATA TL2410/72*0.0/ 
      DATA TL3410/72*0.0/ 
      DATA TL4410/72*0.0/ 
C 
C  HDGV7 - 1985+ (same as 1981+ LDGV for MOBILE4.1) 
C 
      DATA TL1111/ 
C  80 degrees 
     1 0.30,0.30,0.31,0.32,0.34,0.40,0.09,0.11,0.12,0.12,0.13,0.15, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.33,0.41,0.48,0.59,0.66,0.86,0.10,0.13,0.14,0.17,0.19,0.24, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.36,0.56,0.81,1.14,1.44,1.91,0.11,0.16,0.18,0.26,0.34,0.49, 
     3 0.02,0.02,0.02,0.02,0.02,0.02, 
     4 0.62,1.06,1.67,2.84,3.92,5.16,0.14,0.31,0.37,0.57,0.70,0.91, 
     4 0.02,0.02,0.02,0.02,0.02,0.02/ 
       DATA TL2111/ 
C  87 degrees 
     1 0.32,0.36,0.36,0.39,0.42,0.52,0.09,0.13,0.13,0.14,0.15,0.18, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.35,0.52,0.73,0.99,1.23,1.61,0.10,0.16,0.17,0.23,0.29,0.41, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.62,1.05,1.63,2.77,3.81,5.01,0.14,0.31,0.37,0.57,0.69,0.88, 
     3 0.02,0.02,0.02,0.02,0.02,0.02, 
     4 0.77,1.70,3.81,7.07,9.91,12.24,0.14,0.35,0.56,1.22,1.71,2.36, 
     4 0.05,0.03,0.03,0.03,0.03,0.03/ 
      DATA TL3111/ 
C  95 degrees 
     1 0.34,0.44,0.54,0.71,0.83,1.14,0.10,0.14,0.15,0.20,0.23,0.32, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.61,1.01,1.48,2.46,3.38,4.50,0.14,0.30,0.35,0.51,0.61,0.77, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.79,1.79,4.10,7.66,10.73,13.15,0.15,0.36,0.59,1.32,1.87,2.56, 
     3 0.08,0.02,0.02,0.02,0.02,0.02, 
     4 0.97,2.53,6.66,12.76,17.65,21.12,0.16,0.42,0.84,2.15,3.05,4.18, 
     4 0.09,0.05,0.04,0.03,0.03,0.03/ 
      DATA TL4111/ 
C  105 degrees 
     1 0.37,0.61,0.95,1.40,1.80,2.38,0.11,0.18,0.20,0.31,0.41,0.61, 
     1 0.06,0.02,0.02,0.02,0.02,0.02, 
     2 0.83,1.93,4.58,8.6,12.07,14.73,0.15,0.37,0.63,1.46,2.09,2.88, 
     2 0.09,0.02,0.02,0.02,0.02,0.02, 
     3 1.05,2.86,7.81,15.09,20.24,24.26,0.16,0.45,0.98,2.56,3.46,4.81, 
     3 0.09,0.03,0.03,0.03,0.03,0.03, 
     4 1.26,3.74,10.94,20.17,27.34,32.36,0.18,0.53,1.33,3.26,4.55, 
     4 6.35,0.09,0.05,0.04,0.03,0.03,0.03/ 
C 
C  HDGV7 - has only one MY group beyond the precontrolled. 
C 
      DATA TL1211/72*0.0/ 
      DATA TL2211/72*0.0/ 
      DATA TL3211/72*0.0/ 
      DATA TL4211/72*0.0/ 
      DATA TL1311/72*0.0/ 
      DATA TL2311/72*0.0/ 
      DATA TL3311/72*0.0/ 
      DATA TL4311/72*0.0/ 
      DATA TL1411/72*0.0/ 
      DATA TL2411/72*0.0/ 
      DATA TL3411/72*0.0/ 
      DATA TL4411/72*0.0/ 
C 
C  HDGV8A - 1985+ (same as 1981+ LDGV for MOBILE4.1) 
C 
      DATA TL1112/ 
C  80 degrees 
     1 0.30,0.30,0.31,0.32,0.34,0.40,0.09,0.11,0.12,0.12,0.13,0.15, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.33,0.41,0.48,0.59,0.66,0.86,0.10,0.13,0.14,0.17,0.19,0.24, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.36,0.56,0.81,1.14,1.44,1.91,0.11,0.16,0.18,0.26,0.34,0.49, 
     3 0.02,0.02,0.02,0.02,0.02,0.02, 
     4 0.62,1.06,1.67,2.84,3.92,5.16,0.14,0.31,0.37,0.57,0.70,0.91, 
     4 0.02,0.02,0.02,0.02,0.02,0.02/ 
       DATA TL2112/ 
C  87 degrees 
     1 0.32,0.36,0.36,0.39,0.42,0.52,0.09,0.13,0.13,0.14,0.15,0.18, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.35,0.52,0.73,0.99,1.23,1.61,0.10,0.16,0.17,0.23,0.29,0.41, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.62,1.05,1.63,2.77,3.81,5.01,0.14,0.31,0.37,0.57,0.69,0.88, 
     3 0.02,0.02,0.02,0.02,0.02,0.02, 
     4 0.77,1.70,3.81,7.07,9.91,12.24,0.14,0.35,0.56,1.22,1.71,2.36, 
     4 0.05,0.03,0.03,0.03,0.03,0.03/ 
      DATA TL3112/ 
C  95 degrees 
     1 0.34,0.44,0.54,0.71,0.83,1.14,0.10,0.14,0.15,0.20,0.23,0.32, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.61,1.01,1.48,2.46,3.38,4.50,0.14,0.30,0.35,0.51,0.61,0.77, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.79,1.79,4.10,7.66,10.73,13.15,0.15,0.36,0.59,1.32,1.87,2.56, 
     3 0.08,0.02,0.02,0.02,0.02,0.02, 
     4 0.97,2.53,6.66,12.76,17.65,21.12,0.16,0.42,0.84,2.15,3.05,4.18, 
     4 0.09,0.05,0.04,0.03,0.03,0.03/ 
      DATA TL4112/ 
C  105 degrees 
     1 0.37,0.61,0.95,1.40,1.80,2.38,0.11,0.18,0.20,0.31,0.41,0.61, 
     1 0.06,0.02,0.02,0.02,0.02,0.02, 
     2 0.83,1.93,4.58,8.6,12.07,14.73,0.15,0.37,0.63,1.46,2.09,2.88, 
     2 0.09,0.02,0.02,0.02,0.02,0.02, 
     3 1.05,2.86,7.81,15.09,20.24,24.26,0.16,0.45,0.98,2.56,3.46,4.81, 
     3 0.09,0.03,0.03,0.03,0.03,0.03, 
     4 1.26,3.74,10.94,20.17,27.34,32.36,0.18,0.53,1.33,3.26,4.55, 
     4 6.35,0.09,0.05,0.04,0.03,0.03,0.03/ 
C 
C  HDGV8A - has only one MY group beyond the precontrolled. 
C 
      DATA TL1212/72*0.0/ 
      DATA TL2212/72*0.0/ 
      DATA TL3212/72*0.0/ 
      DATA TL4212/72*0.0/ 
      DATA TL1312/72*0.0/ 
      DATA TL2312/72*0.0/ 
      DATA TL3312/72*0.0/ 
      DATA TL4312/72*0.0/ 
      DATA TL1412/72*0.0/ 
      DATA TL2412/72*0.0/ 
      DATA TL3412/72*0.0/ 
      DATA TL4412/72*0.0/ 
C 
C  HDGV8B - 1985+ (same as 1981+ LDGV for MOBILE4.1) 
C 
      DATA TL1113/ 
C  80 degrees 
     1 0.30,0.30,0.31,0.32,0.34,0.40,0.09,0.11,0.12,0.12,0.13,0.15, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.33,0.41,0.48,0.59,0.66,0.86,0.10,0.13,0.14,0.17,0.19,0.24, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.36,0.56,0.81,1.14,1.44,1.91,0.11,0.16,0.18,0.26,0.34,0.49, 
     3 0.02,0.02,0.02,0.02,0.02,0.02, 
     4 0.62,1.06,1.67,2.84,3.92,5.16,0.14,0.31,0.37,0.57,0.70,0.91, 
     4 0.02,0.02,0.02,0.02,0.02,0.02/ 
       DATA TL2113/ 
C  87 degrees 
     1 0.32,0.36,0.36,0.39,0.42,0.52,0.09,0.13,0.13,0.14,0.15,0.18, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.35,0.52,0.73,0.99,1.23,1.61,0.10,0.16,0.17,0.23,0.29,0.41, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.62,1.05,1.63,2.77,3.81,5.01,0.14,0.31,0.37,0.57,0.69,0.88, 
     3 0.02,0.02,0.02,0.02,0.02,0.02, 
     4 0.77,1.70,3.81,7.07,9.91,12.24,0.14,0.35,0.56,1.22,1.71,2.36, 
     4 0.05,0.03,0.03,0.03,0.03,0.03/ 
      DATA TL3113/ 
C  95 degrees 
     1 0.34,0.44,0.54,0.71,0.83,1.14,0.10,0.14,0.15,0.20,0.23,0.32, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.61,1.01,1.48,2.46,3.38,4.50,0.14,0.30,0.35,0.51,0.61,0.77, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.79,1.79,4.10,7.66,10.73,13.15,0.15,0.36,0.59,1.32,1.87,2.56, 
     3 0.08,0.02,0.02,0.02,0.02,0.02, 
     4 0.97,2.53,6.66,12.76,17.65,21.12,0.16,0.42,0.84,2.15,3.05,4.18, 
     4 0.09,0.05,0.04,0.03,0.03,0.03/ 
      DATA TL4113/ 
C  105 degrees 
     1 0.37,0.61,0.95,1.40,1.80,2.38,0.11,0.18,0.20,0.31,0.41,0.61, 
     1 0.06,0.02,0.02,0.02,0.02,0.02, 
     2 0.83,1.93,4.58,8.6,12.07,14.73,0.15,0.37,0.63,1.46,2.09,2.88, 
     2 0.09,0.02,0.02,0.02,0.02,0.02, 
     3 1.05,2.86,7.81,15.09,20.24,24.26,0.16,0.45,0.98,2.56,3.46,4.81, 
     3 0.09,0.03,0.03,0.03,0.03,0.03, 
     4 1.26,3.74,10.94,20.17,27.34,32.36,0.18,0.53,1.33,3.26,4.55, 
     4 6.35,0.09,0.05,0.04,0.03,0.03,0.03/ 
C 
C  HDGV8B - has only one MY group beyond the precontrolled. 
C 
      DATA TL1213/72*0.0/ 
      DATA TL2213/72*0.0/ 
      DATA TL3213/72*0.0/ 
      DATA TL4213/72*0.0/ 
      DATA TL1313/72*0.0/ 
      DATA TL2313/72*0.0/ 
      DATA TL3313/72*0.0/ 
      DATA TL4313/72*0.0/ 
      DATA TL1413/72*0.0/ 
      DATA TL2413/72*0.0/ 
      DATA TL3413/72*0.0/ 
      DATA TL4413/72*0.0/ 
C 
C  GAS BUS - 1985+ (same as 1981+ LDGV for MOBILE4.1) 
C 
      DATA TL1114/ 
C  80 degrees 
     1 0.30,0.30,0.31,0.32,0.34,0.40,0.09,0.11,0.12,0.12,0.13,0.15, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.33,0.41,0.48,0.59,0.66,0.86,0.10,0.13,0.14,0.17,0.19,0.24, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.36,0.56,0.81,1.14,1.44,1.91,0.11,0.16,0.18,0.26,0.34,0.49, 
     3 0.02,0.02,0.02,0.02,0.02,0.02, 
     4 0.62,1.06,1.67,2.84,3.92,5.16,0.14,0.31,0.37,0.57,0.70,0.91, 
     4 0.02,0.02,0.02,0.02,0.02,0.02/ 
       DATA TL2114/ 
C  87 degrees 
     1 0.32,0.36,0.36,0.39,0.42,0.52,0.09,0.13,0.13,0.14,0.15,0.18, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.35,0.52,0.73,0.99,1.23,1.61,0.10,0.16,0.17,0.23,0.29,0.41, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.62,1.05,1.63,2.77,3.81,5.01,0.14,0.31,0.37,0.57,0.69,0.88, 
     3 0.02,0.02,0.02,0.02,0.02,0.02, 
     4 0.77,1.70,3.81,7.07,9.91,12.24,0.14,0.35,0.56,1.22,1.71,2.36, 
     4 0.05,0.03,0.03,0.03,0.03,0.03/ 
      DATA TL3114/ 
C  95 degrees 
     1 0.34,0.44,0.54,0.71,0.83,1.14,0.10,0.14,0.15,0.20,0.23,0.32, 
     1 0.02,0.02,0.02,0.02,0.02,0.02, 
     2 0.61,1.01,1.48,2.46,3.38,4.50,0.14,0.30,0.35,0.51,0.61,0.77, 
     2 0.02,0.02,0.02,0.02,0.02,0.02, 
     3 0.79,1.79,4.10,7.66,10.73,13.15,0.15,0.36,0.59,1.32,1.87,2.56, 
     3 0.08,0.02,0.02,0.02,0.02,0.02, 
     4 0.97,2.53,6.66,12.76,17.65,21.12,0.16,0.42,0.84,2.15,3.05,4.18, 
     4 0.09,0.05,0.04,0.03,0.03,0.03/ 
      DATA TL4114/ 
C  105 degrees 
     1 0.37,0.61,0.95,1.40,1.80,2.38,0.11,0.18,0.20,0.31,0.41,0.61, 
     1 0.06,0.02,0.02,0.02,0.02,0.02, 
     2 0.83,1.93,4.58,8.6,12.07,14.73,0.15,0.37,0.63,1.46,2.09,2.88, 
     2 0.09,0.02,0.02,0.02,0.02,0.02, 
     3 1.05,2.86,7.81,15.09,20.24,24.26,0.16,0.45,0.98,2.56,3.46,4.81, 
     3 0.09,0.03,0.03,0.03,0.03,0.03, 
     4 1.26,3.74,10.94,20.17,27.34,32.36,0.18,0.53,1.33,3.26,4.55, 
     4 6.35,0.09,0.05,0.04,0.03,0.03,0.03/ 
C 
C  GAS BUS - has only one MY group beyond the precontrolled. 
C 
      DATA TL1214/72*0.0/ 
      DATA TL2214/72*0.0/ 
      DATA TL3214/72*0.0/ 
      DATA TL4214/72*0.0/ 
      DATA TL1314/72*0.0/ 
      DATA TL2314/72*0.0/ 
      DATA TL3314/72*0.0/ 
      DATA TL4314/72*0.0/ 
      DATA TL1414/72*0.0/ 
      DATA TL2414/72*0.0/ 
      DATA TL3414/72*0.0/ 
      DATA TL4414/72*0.0/ 
C 
C  The continuation line code for TLFAIL is ITLR: 
C 
C  1 = 7.0    2 = 9.0    3 = 10.4    4 = 11.7 
C 
C  Unlike TLEMI, these values are cumulative by bag in grams. 
C 
      DATA TLFAIL/ 
C  80 degrees 
     1  1.08,  4.91,  5.20,  5.20,  5.20,  5.20, 
     2  2.20,  8.85, 15.88, 24.45, 32.34, 40.21, 
     3  3.03, 11.76, 23.74, 45.69, 60.06, 82.22, 
     4  4.04, 20.13, 40.19, 70.04, 96.17,128.70, 
C  87 degrees 
     1  1.63,  6.85, 10.47, 10.47, 13.18, 11.14, 
     2  2.88, 11.24, 22.32, 41.86, 55.05, 74.61, 
     3  3.99, 19.84, 39.52, 68.66, 94.18,126.01, 
     4  5.84, 30.58, 64.14,118.01,164.53,219.78, 
C  95 degrees 
     1  2.34,  9.35, 17.20, 27.99, 36.95, 47.17, 
     2  3.88, 19.21, 38.05, 65.68, 89.90,120.26, 
     3  6.05, 31.82, 66.96,123.65,172.52,230.39, 
     4  8.13, 43.83, 94.44,178.65,250.83,334.66, 
C  105 degrees 
     1  3.36, 15.55, 30.37, 51.83, 70.03, 93.51, 
     2  6.48, 34.29, 72.58,134.85,188.43,251.53, 
     3  8.99, 48.78,105.72,201.18,282.84,377.19, 
     4 11.38, 62.53,137.11,263.89,372.01,495.78/ 
C 
C 
C 
C 
C  /RUNLS3/: The continuation line code for MYGRNL is the old Mobile5  
C     IVTL code (1=LDGV, 2=LDGT12, 3=LDGT34, 4=HDGV). B is used for GAS BUS. 
C 
      DATA MYGRNL/ 
     1 1971,NEYR,0000,0000, 
     2 1971,1980,NEYR,0000, 
     2 1971,1980,NEYR,0000, 
     3 1978,1980,NEYR,0000, 
     3 1978,1980,NEYR,0000, 
     4 1984,NEYR,0000,0000, 
     4 1984,NEYR,0000,0000, 
     4 1984,NEYR,0000,0000, 
     4 1984,NEYR,0000,0000, 
     4 1984,NEYR,0000,0000, 
     4 1984,NEYR,0000,0000, 
     4 1984,NEYR,0000,0000, 
     4 1984,NEYR,0000,0000, 
     B 1984,NEYR,0000,0000/ 
C 
      DATA MAXRNL/4/ 
C 
      DATA RNLRVP/7.0,9.0,10.4,11.7/ 
      DATA RNLTEM/80.0,87.0,95.0,105.0/ 
      DATA RNLSPD/7.1,19.6,47.9/ 
C 
C  /RESTLS/: 
C 
C Parameters for the equations for hourly resting loss  
C emission in grams (from appendix F of M6.EVP.002) 
C RSTLS1(MYRNG=1-4,PTST=1-4,RIFDS=1-2)  
C 
C             1 (pass pressure pass purge test)   
C          /  2 (pass pressure fail purge test) 
C  PTST = | 
C          \  3 (fail pressure  pass purge test) 
C             4 (fail pressure  fail purge test) 
C                
C 
C *************** 
C 
        DATA RSTLS1/ 
C 
C RIFDS = 1 (carbureted) 
C         MYRNG   < 1980    1980-1985    1986-1995   1999+ 
C  PPTST 
C 
     1            5.53E-2,   -5.957E-2,   -7.551E-2,  -2.786E-2, 
     2            5.53E-2,   -5.957E-2,   -7.551E-2,  -7.654E-2, 
     3            7.454E-2,  -2.163E-2,    5.044E-2,  -7.654E-2, 
     4            7.454E-2,  -2.163E-2,    5.044E-2,  -7.654E-2, 
C 
C RIFDS = 2 (fuel injected) 
C 
     1            5.53E-2,   -9.867E-2,   -1.4067E-1,  -2.786E-2, 
     2            5.53E-2,   -9.867E-2,   -1.4067E-1,  -7.654E-2, 
     3            7.454E-2,   2.565E-2 ,  -1.0924E-1,  -7.654E-2,  
     4            7.454E-2,   2.565E-2 ,  -1.0924E-1,  -7.654E-2/ 
C 
C 
C 
        DATA RSTLS2/ 
C 
C  
C         MYRNG   < 1980    1980-1985    1986-1995   1996+ 
C  PPTST 
C 
     1            2.812E-3,    2.812E-3,    2.812E-3,   5.14E-4, 
     2            2.812E-3,    2.812E-3,    2.812E-3,   1.603E-3, 
     3            2.812E-3,    2.812E-3,    2.812E-3,   1.603E-3, 
     4            2.812E-3,    2.812E-3,    2.812E-3,   1.603E-3/ 
C 
C 
C 
C  /RESTLS1/: 
C 
      DATA NO_RSTLOS/0/ 
      DATA RSTLSS_EF/0.0/ 
      DATA NO_EVAPCALC/0/ 
      DATA RSTLOS_FR_RNLOSS/0.0/ 
C 
C 
      END 
