      BLOCK DATA BD36 
C 
C  BLOCK DATA Subprogram 36: /OXY1/, /OXY2/ 
C 
C  BLOCK DATA 36 initializes oxy fuel model year groups and adjustment factors. 
C 
C  Changes: (Last change first) 
C 
C  21 Dec 98 @DynTel-HXQ 2-667  Fuel Oxygen Effects on Exchaust Co Emission 
C 
C  Common block array subscripts: 
C 
C  OXYBF(25,18,4)          -  OXYBF( IG, IGOXY, IPOXY ) 
C  OXYVAL(25,18,4)         -  OXYVAL( IG, IGOXY, IPOXY ) 
C  OXYCNT(2)               -  OXYCNT( IFUEL-1 ) 
C  OXYFAC(3,2)             -  OXYFAC(IP,2) 
C  SHRMKT(3)               -  SHRMKT( IFUEL ) 
C 
C  Common block dictionary: 
C 
C   Name   Type               Description 
C  ------  ----  -------------------------------------------- 
C  /OXY1/: 
C 
C  IGASHW   I    RVP waiver for gashol switch: 1=no waiver, 2=with waiver. 
C  OXYCNT   R    Oxygen content adjustment for ether blend and alcohol blend. 
C  SHRMKT   R    Market share for gasoline, ether blend, and alcohol blend. 
C  OXYFAC   R    oxy exhaust effects of blends percent change from gasoline 
C                for non catalyst and open loop vehicles. 
C 
C  /OXY2/: 
C 
C  MAXOXY   I    Maximum number of oxy value groups. 
C  MXOXMY   I    Maximum number of oxy model year group years. 
C  NFUEL    I    Num. of oxy fuels: 1=gasoline, 2=ether blend, 3=alcohol blend. 
C  OXYBF    R    Oxy fuel benefit factors. 
C 
C  Local array subscripts: 
C 
C  OXYBF1(25,6)  -  OXYBF1 ( IG, IGOXY ) 
C  OXYBF2(25,6)  -  OXYBF2 ( IG, IGOXY ) 
C  OXYBF3(25,6)  -  OXYBF3 ( IG, IGOXY ) 
C  OXYBF4(25,6)  -  OXYBF4 ( IG, IGOXY ) 
C  OXYBF5(25,6)  -  OXYBF5 ( IG, IGOXY ) 
C  OXYBF6(25,6)  -  OXYBF6 ( IG, IGOXY ) 
C  OXYBFA(25,6)  -  OXYBFA ( IG, IGOXY ) 
C  OXYBFB(25,6)  -  OXYBFB ( IG, IGOXY ) 
C  OXYBFC(25,6)  -  OXYBFC ( IG, IGOXY ) 
C  OXYHC1(25,6)  -  OXYHC1 ( IG, IGOXY ) 
C  OXYHC2(25,6)  -  OXYHC2 ( IG, IGOXY ) 
C  OXYHC3(25,6)  -  OXYHC3 ( IG, IGOXY ) 
C  OXYHC4(25,6)  -  OXYHC4 ( IG, IGOXY ) 
C  OXYHC5(25,6)  -  OXYHC5 ( IG, IGOXY ) 
C  OXYHC6(25,6)  -  OXYHC6 ( IG, IGOXY ) 
C  OXYNX1(25,6)  -  OXYNX1 ( IG, IGOXY ) 
C  OXYNX2(25,6)  -  OXYNX2 ( IG, IGOXY ) 
C  OXYNX3(25,6)  -  OXYNX3 ( IG, IGOXY ) 
C 
C  Local array dictionary: 
C 
C   Name   Type              Description 
C  ------  ----  ----------------------------------------------- 
C  OXYBF1   R    HC ether benefit factors for 1981-1986 
C  OXYBF2   R    HC ether benefit factors for 1987-1992 
C  OXYBF3   R    HC ether benefit factors for 1993-1998 
C  OXYBF4   R    HC alcohol benefit factors for 1981-1986 
C  OXYBF5   R    HC alcohol benefit factors for 1987-1992 
C  OXYBF6   R    HC alcohol benefit factors for 1993-1998 
C  OXYBFA   R    NOx benefit factors for 1981-1986 
C  OXYBFB   R    NOx benefit factors for 1987-1992 
C  OXYBFC   R    NOx benefit factors for 1993-1998 
C  OXYHC1   R    HC ether interpolation values for 1981-1986 
C  OXYHC2   R    HC ether interpolation values for 1987-1992 
C  OXYHC3   R    HC ether interpolation values for 1993-1998 
C  OXYHC4   R    HC alcohol interpolation values for 1981-1986 
C  OXYHC5   R    HC alcohol interpolation values for 1987-1992 
C  OXYHC6   R    HC alcohol interpolation values for 1993-1998 
C  OXYNX1   R    NOx interpolation values for 1981-1986 
C  OXYNX2   R    NOx interpolation values for 1987-1992 
C  OXYNX3   R    NOx interpolation values for 1993-1998 
C 
C 
C  Notes: 
C 
C  BD36 was added for MOBILE4.1. 
C  BD36 was modified to include HC (ether and alcohol) and NOx in MOBILE5 v03. 
C 
C  26-Feb-1997 @DynTel-yc Request #2-633 The default settings for detergent 
C               gas parameters were removed to avoid confusion with the 
C               parameters in RDCITY. 
C  10-October-1997 @ Dyntel-gjr Request 2-000 Deleted unnecessary comments 
C 
      IMPLICIT NONE 
      INCLUDE 'OXY1.I' 
      INCLUDE 'OXY2.I' 
C 
      REAL OXYHC1(25,6),OXYHC2(25,6),OXYBF1(25,6),OXYBF2(25,6) 
      REAL OXYHC3(25,6),OXYHC4(25,6),OXYBF3(25,6),OXYBF4(25,6) 
      REAL OXYHC5(25,6),OXYHC6(25,6),OXYBF5(25,6),OXYBF6(25,6) 
      REAL OXYNX1(25,6),OXYNX2(25,6),OXYBFA(25,6),OXYBFB(25,6) 
      REAL OXYNX3(25,6),OXYBFC(25,6) 
C 
      EQUIVALENCE 
     *     (OXYVAL(1,1,1), OXYHC1(1,1)), 
     *     (OXYVAL(1,7,1), OXYHC2(1,1)), 
     *     (OXYVAL(1,13,1),OXYHC3(1,1)), 
     *     (OXYVAL(1,1,2), OXYHC4(1,1)), 
     *     (OXYVAL(1,7,2), OXYHC5(1,1)), 
     *     (OXYVAL(1,13,2),OXYHC6(1,1)) 
C 
      EQUIVALENCE 
     *     (OXYVAL(1,1,3), OXYNX1(1,1)), 
     *     (OXYVAL(1,7,3), OXYNX2(1,1)), 
     *     (OXYVAL(1,13,3),OXYNX3(1,1)) 
C 
      EQUIVALENCE 
     *     (OXYBF(1,1,1), OXYBF1(1,1)), 
     *     (OXYBF(1,7,1), OXYBF2(1,1)), 
     *     (OXYBF(1,13,1),OXYBF3(1,1)), 
     *     (OXYBF(1,1,2), OXYBF4(1,1)), 
     *     (OXYBF(1,7,2), OXYBF5(1,1)), 
     *     (OXYBF(1,13,2),OXYBF6(1,1)) 
C 
      EQUIVALENCE 
     *     (OXYBF(1,1,3), OXYBFA(1,1)), 
     *     (OXYBF(1,7,3), OXYBFB(1,1)), 
     *     (OXYBF(1,13,3),OXYBFC(1,1)) 
C 
C  /OXY1/: 
C 
      DATA IGASHW /1/ 
      DATA SHRMKT /3*0./ 
      DATA OXYCNT /2*0./ 
      DATA OXYFAC /1.57, 7.00, 0.00, 
     *             4.46, 9.97, 0.00/ 
C 
C  /OXY2/: 
C 
C  Number of fuels, oxy my groups, and value groups. 
C 
      DATA NFUEL,MXOXMY,MAXOXY/3,18,25/ 
C 
C  Oxy HC ether interpolation values. 
C  (Continuation line is MY (1981-1998).) 
C 
      DATA OXYHC1/ 
     1  0.38, 0.52, 0.68, 0.86, 1.08, 1.32, 1.58, 1.85, 2.13, 2.48, 
     1  2.76, 3.02, 3.28, 3.51, 3.66, 3.81, 3.95, 4.08, 4.21, 4.33, 
     1  4.44, 4.54, 4.65, 4.74, 4.83, 
     2  0.39, 0.53, 0.69, 0.88, 1.09, 1.33, 1.57, 1.82, 2.09, 2.41, 
     2  2.67, 2.91, 3.15, 3.37, 3.52, 3.67, 3.81, 3.94, 4.07, 4.19, 
     2  4.30, 4.41, 4.52, 4.61, 4.71, 
     3  0.33, 0.44, 0.59, 0.75, 0.96, 1.20, 1.45, 1.70, 1.97, 2.33, 
     3  2.59, 2.84, 3.08, 3.30, 3.47, 3.63, 3.77, 3.91, 4.04, 4.16, 
     3  4.28, 4.39, 4.50, 4.60, 4.70, 
     4  0.32, 0.41, 0.53, 0.65, 0.87, 1.10, 1.36, 1.63, 1.91, 2.33, 
     4  2.61, 2.87, 3.12, 3.36, 3.53, 3.69, 3.84, 3.98, 4.11, 4.23, 
     4  4.35, 4.46, 4.57, 4.67, 4.77, 
     5  0.33, 0.43, 0.55, 0.68, 0.89, 1.13, 1.39, 1.66, 1.94, 2.36, 
     5  2.63, 2.90, 3.16, 3.40, 3.60, 3.79, 3.95, 4.08, 4.21, 4.33, 
     5  4.44, 4.55, 4.65, 4.75, 4.85, 
     6  0.33, 0.42, 0.53, 0.64, 0.86, 1.10, 1.35, 1.62, 1.90, 2.34, 
     6  2.61, 2.88, 3.14, 3.38, 3.59, 3.80, 3.97, 4.10, 4.23, 4.35, 
     6  4.46, 4.57, 4.68, 4.78, 4.87/ 
C 
      DATA OXYHC2/ 
     7  0.33, 0.42, 0.52, 0.64, 0.85, 1.08, 1.32, 1.58, 1.85, 2.27, 
     7  2.53, 2.78, 3.03, 3.27, 3.47, 3.68, 3.85, 3.98, 4.11, 4.24, 
     7  4.35, 4.47, 4.58, 4.68, 4.78, 
     8  0.33, 0.42, 0.53, 0.64, 0.84, 1.07, 1.31, 1.56, 1.82, 2.24, 
     8  2.49, 2.73, 2.98, 3.22, 3.44, 3.66, 3.85, 3.98, 4.11, 4.23, 
     8  4.35, 4.46, 4.57, 4.68, 4.77, 
     9  0.33, 0.43, 0.54, 0.66, 0.87, 1.10, 1.36, 1.62, 1.89, 2.32, 
     9  2.59, 2.85, 3.11, 3.36, 3.60, 3.83, 4.02, 4.15, 4.27, 4.39, 
     9  4.50, 4.61, 4.71, 4.81, 4.90, 
     *  0.34, 0.44, 0.55, 0.67, 0.88, 1.12, 1.38, 1.64, 1.91, 2.35, 
     *  2.61, 2.88, 3.14, 3.41, 3.66, 3.92, 4.12, 4.24, 4.36, 4.48, 
     *  4.59, 4.69, 4.79, 4.88, 4.97, 
     1  0.34, 0.44, 0.55, 0.67, 0.89, 1.13, 1.38, 1.65, 1.92, 2.36, 
     1  2.63, 2.89, 3.16, 3.43, 3.69, 3.95, 4.15, 4.28, 4.39, 4.51, 
     1  4.62, 4.72, 4.82, 4.91, 5.00, 
     2  0.34, 0.44, 0.55, 0.67, 0.89, 1.13, 1.39, 1.66, 1.93, 2.37, 
     2  2.64, 2.91, 3.18, 3.45, 3.71, 3.97, 4.17, 4.30, 4.42, 4.53, 
     2  4.64, 4.74, 4.84, 4.93, 5.02/ 
C 
C 
      DATA OXYHC3/ 
     3  0.34, 0.44, 0.55, 0.67, 0.89, 1.13, 1.39, 1.66, 1.93, 2.37, 
     3  2.64, 2.91, 3.18, 3.45, 3.71, 3.97, 4.17, 4.30, 4.42, 4.53, 
     3  4.64, 4.74, 4.84, 4.93, 5.02, 
     4  0.32, 0.42, 0.53, 0.65, 0.87, 1.10, 1.36, 1.62, 1.89, 2.33, 
     4  2.59, 2.86, 3.13, 3.39, 3.65, 3.91, 4.11, 4.24, 4.36, 4.47, 
     4  4.58, 4.68, 4.78, 4.87, 4.96, 
     5  0.31, 0.40, 0.51, 0.63, 0.84, 1.07, 1.32, 1.58, 1.85, 2.29, 
     5  2.55, 2.81, 3.08, 3.34, 3.60, 3.85, 4.06, 4.18, 4.30, 4.41, 
     5  4.52, 4.63, 4.73, 4.82, 4.91, 
     6  0.28, 0.38, 0.49, 0.60, 0.81, 1.04, 1.29, 1.55, 1.82, 2.25, 
     6  2.51, 2.77, 3.03, 3.29, 3.55, 3.81, 4.01, 4.13, 4.26, 4.37, 
     6  4.48, 4.58, 4.68, 4.77, 4.86, 
     7  0.27, 0.36, 0.47, 0.59, 0.80, 1.03, 1.27, 1.53, 1.80, 2.24, 
     7  2.49, 2.75, 3.02, 3.28, 3.54, 3.79, 3.99, 4.12, 4.24, 4.35, 
     7  4.46, 4.57, 4.66, 4.76, 4.85, 
     8  0.26, 0.35, 0.46, 0.58, 0.79, 1.02, 1.26, 1.52, 1.79, 2.23, 
     8  2.49, 2.75, 3.01, 3.27, 3.53, 3.78, 3.98, 4.11, 4.23, 4.34, 
     8  4.45, 4.56, 4.66, 4.75, 4.84/ 
C 
C  Oxy HC alcohol interpolation values. 
C  (Continuation line is MY (1981-1998).) 
C 
      DATA OXYHC4/ 
     1  0.38, 0.52, 0.68, 0.86, 1.08, 1.32, 1.58, 1.85, 2.13, 2.48, 
     1  2.76, 3.02, 3.28, 3.51, 3.66, 3.81, 3.95, 4.08, 4.21, 4.33, 
     1  4.44, 4.54, 4.65, 4.74, 4.83, 
     2  0.39, 0.53, 0.69, 0.88, 1.09, 1.33, 1.57, 1.82, 2.09, 2.41, 
     2  2.67, 2.91, 3.15, 3.37, 3.52, 3.67, 3.81, 3.94, 4.07, 4.19, 
     2  4.30, 4.41, 4.52, 4.61, 4.71, 
     3  0.33, 0.44, 0.59, 0.75, 0.96, 1.20, 1.45, 1.70, 1.97, 2.33, 
     3  2.59, 2.84, 3.08, 3.30, 3.47, 3.63, 3.77, 3.91, 4.04, 4.16, 
     3  4.28, 4.39, 4.50, 4.60, 4.70, 
     4  0.32, 0.41, 0.53, 0.65, 0.87, 1.10, 1.36, 1.63, 1.91, 2.33, 
     4  2.61, 2.87, 3.12, 3.36, 3.53, 3.69, 3.84, 3.98, 4.11, 4.23, 
     4  4.35, 4.46, 4.57, 4.67, 4.77, 
     5  0.33, 0.43, 0.55, 0.68, 0.89, 1.13, 1.39, 1.66, 1.94, 2.36, 
     5  2.63, 2.90, 3.16, 3.40, 3.60, 3.79, 3.95, 4.08, 4.21, 4.33, 
     5  4.44, 4.55, 4.65, 4.75, 4.85, 
     6  0.33, 0.42, 0.53, 0.64, 0.86, 1.10, 1.35, 1.62, 1.90, 2.34, 
     6  2.61, 2.88, 3.14, 3.38, 3.59, 3.80, 3.97, 4.10, 4.23, 4.35, 
     6  4.46, 4.57, 4.68, 4.78, 4.87/ 
C 
      DATA OXYHC5/ 
     7  0.33, 0.42, 0.52, 0.64, 0.85, 1.08, 1.32, 1.58, 1.85, 2.27, 
     7  2.53, 2.78, 3.03, 3.27, 3.47, 3.68, 3.85, 3.98, 4.11, 4.24, 
     7  4.35, 4.47, 4.58, 4.68, 4.78, 
     8  0.33, 0.42, 0.53, 0.64, 0.84, 1.07, 1.31, 1.56, 1.82, 2.24, 
     8  2.49, 2.73, 2.98, 3.22, 3.44, 3.66, 3.85, 3.98, 4.11, 4.23, 
     8  4.35, 4.46, 4.57, 4.68, 4.77, 
     9  0.33, 0.43, 0.54, 0.66, 0.87, 1.10, 1.36, 1.62, 1.89, 2.32, 
     9  2.59, 2.85, 3.11, 3.36, 3.60, 3.83, 4.02, 4.15, 4.27, 4.39, 
     9  4.50, 4.61, 4.71, 4.81, 4.90, 
     *  0.34, 0.44, 0.55, 0.67, 0.88, 1.12, 1.38, 1.64, 1.91, 2.35, 
     *  2.61, 2.88, 3.14, 3.41, 3.66, 3.92, 4.12, 4.24, 4.36, 4.48, 
     *  4.59, 4.69, 4.79, 4.88, 4.97, 
     1  0.34, 0.44, 0.55, 0.67, 0.89, 1.13, 1.38, 1.65, 1.92, 2.36, 
     1  2.63, 2.89, 3.16, 3.43, 3.69, 3.95, 4.15, 4.28, 4.39, 4.51, 
     1  4.62, 4.72, 4.82, 4.91, 5.00, 
     2  0.34, 0.44, 0.55, 0.67, 0.89, 1.13, 1.39, 1.66, 1.93, 2.37, 
     2  2.64, 2.91, 3.18, 3.45, 3.71, 3.97, 4.17, 4.30, 4.42, 4.53, 
     2  4.64, 4.74, 4.84, 4.93, 5.02/ 
C 
      DATA OXYHC6/ 
     3  0.34, 0.44, 0.55, 0.67, 0.89, 1.13, 1.39, 1.66, 1.93, 2.37, 
     3  2.64, 2.91, 3.18, 3.45, 3.71, 3.97, 4.17, 4.30, 4.42, 4.53, 
     3  4.64, 4.74, 4.84, 4.93, 5.02, 
     4  0.32, 0.42, 0.53, 0.65, 0.87, 1.10, 1.36, 1.62, 1.89, 2.33, 
     4  2.59, 2.86, 3.13, 3.39, 3.65, 3.91, 4.11, 4.24, 4.36, 4.47, 
     4  4.58, 4.68, 4.78, 4.87, 4.96, 
     5  0.31, 0.40, 0.51, 0.63, 0.84, 1.07, 1.32, 1.58, 1.85, 2.29, 
     5  2.55, 2.81, 3.08, 3.34, 3.60, 3.85, 4.06, 4.18, 4.30, 4.41, 
     5  4.52, 4.63, 4.73, 4.82, 4.91, 
     6  0.28, 0.38, 0.49, 0.60, 0.81, 1.04, 1.29, 1.55, 1.82, 2.25, 
     6  2.51, 2.77, 3.03, 3.29, 3.55, 3.81, 4.01, 4.13, 4.26, 4.37, 
     6  4.48, 4.58, 4.68, 4.77, 4.86, 
     7  0.27, 0.36, 0.47, 0.59, 0.80, 1.03, 1.27, 1.53, 1.80, 2.24, 
     7  2.49, 2.75, 3.02, 3.28, 3.54, 3.79, 3.99, 4.12, 4.24, 4.35, 
     7  4.46, 4.57, 4.66, 4.76, 4.85, 
     8  0.26, 0.35, 0.46, 0.58, 0.79, 1.02, 1.26, 1.52, 1.79, 2.23, 
     8  2.49, 2.75, 3.01, 3.27, 3.53, 3.78, 3.98, 4.11, 4.23, 4.34, 
     8  4.45, 4.56, 4.66, 4.75, 4.84/ 
C 
C 
C  Oxy NOx interpolation values. 
C  (Continuation line is MY (1981-1998).) 
C 
      DATA OXYNX1/ 
     1  0.73, 0.81, 0.89, 0.96, 1.15, 1.34, 1.53, 1.72, 1.90, 2.06, 
     1  2.24, 2.40, 2.55, 2.68, 2.81, 2.92, 3.03, 3.12, 3.15, 3.19, 
     1  3.22, 3.26, 3.29, 3.31, 3.34, 
     2  0.72, 0.81, 0.89, 0.96, 1.15, 1.34, 1.53, 1.72, 1.90, 2.05, 
     2  2.22, 2.38, 2.52, 2.65, 2.77, 2.88, 2.99, 3.06, 3.11, 3.15, 
     2  3.19, 3.22, 3.26, 3.29, 3.32, 
     3  0.66, 0.75, 0.83, 0.92, 1.11, 1.31, 1.51, 1.70, 1.89, 2.06, 
     3  2.24, 2.40, 2.56, 2.69, 2.82, 2.93, 3.04, 3.12, 3.16, 3.20, 
     3  3.24, 3.28, 3.32, 3.35, 3.38, 
     4  0.57, 0.67, 0.77, 0.86, 1.08, 1.30, 1.52, 1.74, 1.96, 2.14, 
     4  2.35, 2.54, 2.71, 2.87, 3.01, 3.14, 3.26, 3.34, 3.39, 3.43, 
     4  3.48, 3.52, 3.56, 3.59, 3.63, 
     5  0.57, 0.67, 0.77, 0.86, 1.07, 1.28, 1.49, 1.69, 1.89, 2.06, 
     5  2.25, 2.43, 2.59, 2.74, 2.87, 2.99, 3.11, 3.20, 3.25, 3.31, 
     5  3.36, 3.41, 3.45, 3.50, 3.54, 
     6  0.53, 0.63, 0.74, 0.84, 1.05, 1.27, 1.48, 1.68, 1.88, 2.06, 
     6  2.25, 2.43, 2.59, 2.74, 2.87, 3.00, 3.12, 3.20, 3.26, 3.32, 
     6  3.38, 3.44, 3.49, 3.54, 3.59/ 
C 
      DATA OXYNX2/ 
     *  0.54, 0.64, 0.74, 0.84, 1.05, 1.27, 1.48, 1.68, 1.88, 2.05, 
     *  2.24, 2.42, 2.58, 2.72, 2.85, 2.97, 3.08, 3.16, 3.22, 3.28, 
     *  3.34, 3.39, 3.44, 3.49, 3.54, 
     *  0.58, 0.68, 0.78, 0.87, 1.08, 1.29, 1.49, 1.68, 1.87, 2.03, 
     *  2.21, 2.37, 2.53, 2.66, 2.78, 2.89, 3.00, 3.07, 3.14, 3.21, 
     *  3.27, 3.33, 3.39, 3.44, 3.50, 
     *  0.58, 0.68, 0.79, 0.89, 1.09, 1.29, 1.48, 1.67, 1.86, 2.01, 
     *  2.18, 2.35, 2.50, 2.63, 2.76, 2.87, 2.98, 3.06, 3.14, 3.20, 
     *  3.27, 3.33, 3.39, 3.45, 3.50, 
     *  0.57, 0.67, 0.78, 0.88, 1.07, 1.27, 1.45, 1.63, 1.80, 1.95, 
     *  2.11, 2.26, 2.41, 2.54, 2.66, 2.78, 2.88, 2.97, 3.05, 3.12, 
     *  3.19, 3.26, 3.33, 3.39, 3.45, 
     *  0.57, 0.68, 0.78, 0.88, 1.08, 1.27, 1.45, 1.63, 1.80, 1.94, 
     1  2.10, 2.25, 2.40, 2.53, 2.65, 2.77, 2.87, 2.96, 3.04, 3.11, 
     1  3.19, 3.26, 3.33, 3.39, 3.45, 
     2  0.57, 0.68, 0.78, 0.89, 1.08, 1.27, 1.45, 1.63, 1.80, 1.94, 
     2  2.10, 2.25, 2.39, 2.52, 2.64, 2.76, 2.86, 2.95, 3.03, 3.11, 
     2  3.19, 3.26, 3.33, 3.39, 3.45/ 
C 
      DATA OXYNX3/ 
     3  0.57, 0.68, 0.78, 0.89, 1.08, 1.27, 1.45, 1.63, 1.80, 1.94, 
     3  2.10, 2.25, 2.39, 2.52, 2.64, 2.76, 2.86, 2.95, 3.03, 3.11, 
     3  3.19, 3.26, 3.33, 3.39, 3.45, 
     4  0.47, 0.58, 0.68, 0.78, 0.98, 1.17, 1.36, 1.54, 1.71, 1.85, 
     4  2.01, 2.17, 2.31, 2.44, 2.57, 2.69, 2.79, 2.88, 2.96, 3.04, 
     4  3.12, 3.19, 3.26, 3.33, 3.39, 
     5  0.35, 0.45, 0.56, 0.66, 0.86, 1.06, 1.25, 1.43, 1.61, 1.75, 
     5  1.91, 2.07, 2.22, 2.35, 2.48, 2.60, 2.71, 2.80, 2.89, 2.97, 
     5  3.05, 3.12, 3.19, 3.26, 3.32, 
     6  0.28, 0.39, 0.50, 0.60, 0.80, 1.00, 1.19, 1.38, 1.55, 1.70, 
     6  1.87, 2.02, 2.17, 2.31, 2.44, 2.56, 2.67, 2.76, 2.85, 2.93, 
     6  3.01, 3.08, 3.15, 3.22, 3.29, 
     *  0.28, 0.39, 0.50, 0.60, 0.80, 1.00, 1.19, 1.38, 1.55, 1.70, 
     *  1.87, 2.02, 2.17, 2.31, 2.44, 2.56, 2.67, 2.76, 2.85, 2.93, 
     *  3.01, 3.08, 3.15, 3.22, 3.29, 
     *  0.28, 0.39, 0.50, 0.60, 0.80, 1.00, 1.19, 1.38, 1.55, 1.70, 
     *  1.87, 2.02, 2.17, 2.31, 2.44, 2.56, 2.67, 2.76, 2.85, 2.93, 
     *  3.01, 3.08, 3.15, 3.22, 3.29/ 
C 
C  Oxy HC ether benefit factors. 
C  (Continuation line is MY (1981-1998).) 
C 
      DATA OXYBF1/ 
     1  5.40, 5.36, 5.34, 5.34, 5.45, 5.55, 5.65, 5.73, 5.80, 5.91, 
     1  5.96, 6.00, 6.02, 6.04, 6.04, 6.05, 6.05, 6.04, 6.04, 6.04, 
     1  6.04, 6.03, 6.03, 6.03, 6.03, 
     2  5.11, 5.09, 5.10, 5.11, 5.23, 5.35, 5.46, 5.55, 5.63, 5.75, 
     2  5.81, 5.85, 5.88, 5.90, 5.91, 5.92, 5.92, 5.92, 5.92, 5.92, 
     2  5.92, 5.92, 5.92, 5.92, 5.92, 
     3  4.99, 5.04, 5.10, 5.17, 5.35, 5.49, 5.61, 5.72, 5.81, 5.94, 
     3  6.00, 6.04, 6.08, 6.09, 6.10, 6.11, 6.11, 6.11, 6.11, 6.11, 
     3  6.11, 6.11, 6.11, 6.11, 6.11, 
     4  4.97, 5.09, 5.22, 5.36, 5.60, 5.77, 5.90, 6.02, 6.12, 6.24, 
     4  6.30, 6.35, 6.39, 6.41, 6.42, 6.43, 6.43, 6.44, 6.44, 6.45, 
     4  6.45, 6.46, 6.46, 6.46, 6.47, 
     5  4.77, 4.90, 5.05, 5.21, 5.47, 5.67, 5.82, 5.96, 6.08, 6.22, 
     5  6.28, 6.33, 6.36, 6.38, 6.40, 6.41, 6.42, 6.42, 6.42, 6.43, 
     5  6.43, 6.43, 6.43, 6.43, 6.44, 
     6  4.52, 4.70, 4.91, 5.13, 5.45, 5.68, 5.86, 6.02, 6.16, 6.30, 
     6  6.37, 6.42, 6.46, 6.49, 6.51, 6.52, 6.53, 6.54, 6.54, 6.55, 
     6  6.55, 6.56, 6.56, 6.56, 6.57/ 
C 
      DATA OXYBF2/ 
     *  4.29, 4.49, 4.71, 4.94, 5.30, 5.56, 5.76, 5.93, 6.08, 6.24, 
     *  6.32, 6.38, 6.42, 6.45, 6.47, 6.49, 6.51, 6.51, 6.52, 6.53, 
     *  6.53, 6.54, 6.54, 6.55, 6.55, 
     *  3.97, 4.19, 4.45, 4.72, 5.14, 5.43, 5.66, 5.86, 6.03, 6.21, 
     *  6.30, 6.36, 6.42, 6.45, 6.48, 6.50, 6.52, 6.52, 6.53, 6.54, 
     *  6.55, 6.55, 6.56, 6.56, 6.57, 
     *  4.15, 4.36, 4.61, 4.87, 5.25, 5.52, 5.74, 5.93, 6.10, 6.27, 
     *  6.35, 6.41, 6.45, 6.48, 6.50, 6.52, 6.54, 6.54, 6.55, 6.55, 
     *  6.56, 6.56, 6.56, 6.57, 6.57, 
     *  4.01, 4.24, 4.51, 4.78, 5.18, 5.48, 5.71, 5.92, 6.10, 6.28, 
     *  6.36, 6.42, 6.46, 6.49, 6.52, 6.54, 6.55, 6.56, 6.56, 6.56, 
     *  6.57, 6.57, 6.57, 6.57, 6.58, 
     *  4.00, 4.23, 4.50, 4.78, 5.18, 5.48, 5.72, 5.92, 6.10, 6.29, 
     *  6.37, 6.42, 6.46, 6.49, 6.52, 6.54, 6.56, 6.56, 6.56, 6.57, 
     *  6.57, 6.57, 6.57, 6.58, 6.58, 
     *  4.01, 4.25, 4.52, 4.79, 5.19, 5.48, 5.72, 5.93, 6.11, 6.30, 
     *  6.38, 6.43, 6.47, 6.50, 6.52, 6.55, 6.56, 6.56, 6.57, 6.57, 
     *  6.57, 6.57, 6.58, 6.58, 6.58/ 
C 
      DATA OXYBF3/ 
     3  4.01, 4.25, 4.52, 4.79, 5.19, 5.48, 5.72, 5.93, 6.11, 6.30, 
     3  6.38, 6.43, 6.47, 6.50, 6.52, 6.55, 6.56, 6.56, 6.57, 6.57, 
     3  6.57, 6.57, 6.58, 6.58, 6.58, 
     4  4.01, 4.24, 4.49, 4.76, 5.17, 5.46, 5.70, 5.90, 6.08, 6.27, 
     4  6.36, 6.43, 6.47, 6.50, 6.52, 6.55, 6.56, 6.56, 6.57, 6.57, 
     4  6.57, 6.57, 6.58, 6.58, 6.58, 
     5  4.00, 4.23, 4.47, 4.73, 5.14, 5.43, 5.67, 5.87, 6.05, 6.24, 
     5  6.35, 6.43, 6.47, 6.50, 6.52, 6.55, 6.56, 6.56, 6.57, 6.57, 
     5  6.57, 6.57, 6.58, 6.58, 6.58, 
     6  4.01, 4.23, 4.47, 4.72, 5.12, 5.42, 5.65, 5.85, 6.03, 6.22, 
     6  6.34, 6.43, 6.47, 6.50, 6.52, 6.55, 6.56, 6.56, 6.57, 6.57, 
     6  6.57, 6.57, 6.58, 6.58, 6.58, 
     *  4.01, 4.23, 4.47, 4.72, 5.12, 5.42, 5.65, 5.85, 6.02, 6.21, 
     *  6.34, 6.44, 6.47, 6.50, 6.52, 6.55, 6.56, 6.56, 6.57, 6.57, 
     *  6.57, 6.57, 6.58, 6.58, 6.58, 
     *  4.02, 4.24, 4.48, 4.72, 5.12, 5.42, 5.65, 5.85, 6.02, 6.21, 
     *  6.33, 6.44, 6.47, 6.50, 6.53, 6.55, 6.56, 6.56, 6.57, 6.57, 
     *  6.57, 6.57, 6.58, 6.58, 6.58/ 
C 
C  Oxy HC alcohol benefit factors. 
C  (Continuation line is MY (1981-1998).) 
C 
      DATA OXYBF4/ 
     1  5.40, 5.36, 5.34, 5.34, 5.45, 5.55, 5.65, 5.73, 5.80, 5.91, 
     1  5.96, 6.00, 6.02, 6.04, 6.04, 6.05, 6.05, 6.04, 6.04, 6.04, 
     1  6.04, 6.03, 6.03, 6.03, 6.03, 
     2  5.11, 5.09, 5.10, 5.11, 5.23, 5.35, 5.46, 5.55, 5.63, 5.75, 
     2  5.81, 5.85, 5.88, 5.90, 5.91, 5.92, 5.92, 5.92, 5.92, 5.92, 
     2  5.92, 5.92, 5.92, 5.92, 5.92, 
     3  4.99, 5.04, 5.10, 5.17, 5.35, 5.49, 5.61, 5.72, 5.81, 5.94, 
     3  6.00, 6.04, 6.08, 6.09, 6.10, 6.11, 6.11, 6.11, 6.11, 6.11, 
     3  6.11, 6.11, 6.11, 6.11, 6.11, 
     4  4.97, 5.09, 5.22, 5.36, 5.60, 5.77, 5.90, 6.02, 6.12, 6.24, 
     4  6.30, 6.35, 6.39, 6.41, 6.42, 6.43, 6.43, 6.44, 6.44, 6.45, 
     4  6.45, 6.46, 6.46, 6.46, 6.47, 
     5  4.77, 4.90, 5.05, 5.21, 5.47, 5.67, 5.82, 5.96, 6.08, 6.22, 
     5  6.28, 6.33, 6.36, 6.38, 6.40, 6.41, 6.42, 6.42, 6.42, 6.43, 
     5  6.43, 6.43, 6.43, 6.43, 6.44, 
     6  4.52, 4.70, 4.91, 5.13, 5.45, 5.68, 5.86, 6.02, 6.16, 6.30, 
     6  6.37, 6.42, 6.46, 6.49, 6.51, 6.52, 6.53, 6.54, 6.54, 6.55, 
     6  6.55, 6.56, 6.56, 6.56, 6.57/ 
C 
      DATA OXYBF5/ 
     *  4.29, 4.49, 4.71, 4.94, 5.30, 5.56, 5.76, 5.93, 6.08, 6.24, 
     *  6.32, 6.38, 6.42, 6.45, 6.47, 6.49, 6.51, 6.51, 6.52, 6.53, 
     *  6.53, 6.54, 6.54, 6.55, 6.55, 
     *  3.97, 4.19, 4.45, 4.72, 5.14, 5.43, 5.66, 5.86, 6.03, 6.21, 
     *  6.30, 6.36, 6.42, 6.45, 6.48, 6.50, 6.52, 6.52, 6.53, 6.54, 
     *  6.55, 6.55, 6.56, 6.56, 6.57, 
     *  4.15, 4.36, 4.61, 4.87, 5.25, 5.52, 5.74, 5.93, 6.10, 6.27, 
     *  6.35, 6.41, 6.45, 6.48, 6.50, 6.52, 6.54, 6.54, 6.55, 6.55, 
     *  6.56, 6.56, 6.56, 6.57, 6.57, 
     *  4.01, 4.24, 4.51, 4.78, 5.18, 5.48, 5.71, 5.92, 6.10, 6.28, 
     *  6.36, 6.42, 6.46, 6.49, 6.52, 6.54, 6.55, 6.56, 6.56, 6.56, 
     *  6.57, 6.57, 6.57, 6.57, 6.58, 
     *  4.00, 4.23, 4.50, 4.78, 5.18, 5.48, 5.72, 5.92, 6.10, 6.29, 
     *  6.37, 6.42, 6.46, 6.49, 6.52, 6.54, 6.56, 6.56, 6.56, 6.57, 
     *  6.57, 6.57, 6.57, 6.58, 6.58, 
     *  4.01, 4.25, 4.52, 4.79, 5.19, 5.48, 5.72, 5.93, 6.11, 6.30, 
     *  6.38, 6.43, 6.47, 6.50, 6.52, 6.55, 6.56, 6.56, 6.57, 6.57, 
     *  6.57, 6.57, 6.58, 6.58, 6.58/ 
C 
      DATA OXYBF6/ 
     3  4.01, 4.25, 4.52, 4.79, 5.19, 5.48, 5.72, 5.93, 6.11, 6.30, 
     3  6.38, 6.43, 6.47, 6.50, 6.52, 6.55, 6.56, 6.56, 6.57, 6.57, 
     3  6.57, 6.57, 6.58, 6.58, 6.58, 
     4  4.01, 4.24, 4.49, 4.76, 5.17, 5.46, 5.70, 5.90, 6.08, 6.27, 
     4  6.36, 6.43, 6.47, 6.50, 6.52, 6.55, 6.56, 6.56, 6.57, 6.57, 
     4  6.57, 6.57, 6.58, 6.58, 6.58, 
     5  4.00, 4.23, 4.47, 4.73, 5.14, 5.43, 5.67, 5.87, 6.05, 6.24, 
     5  6.35, 6.43, 6.47, 6.50, 6.52, 6.55, 6.56, 6.56, 6.57, 6.57, 
     5  6.57, 6.57, 6.58, 6.58, 6.58, 
     6  4.01, 4.23, 4.47, 4.72, 5.12, 5.42, 5.65, 5.85, 6.03, 6.22, 
     6  6.34, 6.43, 6.47, 6.50, 6.52, 6.55, 6.56, 6.56, 6.57, 6.57, 
     6  6.57, 6.57, 6.58, 6.58, 6.58, 
     *  4.01, 4.23, 4.47, 4.72, 5.12, 5.42, 5.65, 5.85, 6.02, 6.21, 
     *  6.34, 6.44, 6.47, 6.50, 6.52, 6.55, 6.56, 6.56, 6.57, 6.57, 
     *  6.57, 6.57, 6.58, 6.58, 6.58, 
     *  4.02, 4.24, 4.48, 4.72, 5.12, 5.42, 5.65, 5.85, 6.02, 6.21, 
     *  6.33, 6.44, 6.47, 6.50, 6.53, 6.55, 6.56, 6.56, 6.57, 6.57, 
     *  6.57, 6.57, 6.58, 6.58, 6.58/ 
C 
C  Oxy NOx benefit factors. 
C  (Continuation line is MY (1981-1998).) 
C 
      DATA OXYBFA/ 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00/ 
C 
      DATA OXYBFB/ 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00/ 
C 
C 
      DATA OXYBFC/ 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 
     *  0.00, 0.00, 0.00, 0.00, 0.00/ 
C 
      END 
                     
