      BLOCK DATA BD41 
C 
C  BLOCK DATA Subprogram 41 : /SKDIST/, /SOAK/ 
C 
C  BLOCK DATA 41 initializes the weekday and weekend soak distributions. 
C 
C  Changes: (Last change first) 
C 
C  22 Nov 00 @EPA-bag bug300: removed SSOAKDIST; replaced with VA021 in save08.i 
C  26 Jul 00 AIR Task 07: Added initialization of SSOAKDIST. 
C  21 May 99 @DynTel-ddj, Added values for array RATIO_A(3). 
C   3 May 99 @DynTel-bag  2-650 Made both weekday and weekend SOAKDIST both 
C            fractions rather than weekday SOAKDIST percentages and weekend 
C            SOAKDIST fractions; added MINUTES array rather than determining 
C            it in SOAKFCN for each ST_INDX and IP. Also, increased the size 
C            of the hourly index on SOAKDIST to 24. 
C  20 January 99 @DynTel-ZK 2-000 Explicit Typing 
C  22 Oct 98 @DynTel-bag  Restructured soak time corrections calculations. 
C            Moved fit parameters from subroutines to SOAK common blocks, 
C            removed SOAKCF array, and reduced SOAKFUN to a two dimensional 
C            array dependent on soak time and catalyst type. 
C 
C  Common block array subscripts: 
C 
C  CSA(2,3,2)            -  CSA(             CN,     IP,      IECT  ) 
C  CSB(2,3,2)            -  CSB(             CN,     IP,      IECT  ) 
C  CSC(2,3,2)            -  CSC(             CN,     IP,      IECT  ) 
C  SOAKDIST(24,70,2)     -  SOAKDIST(        IH,     ST_INDX, IWEEK ) 
C  SOAKFUN(70,2)         -  SOAKFUN(         ISOAK,  IECT           ) 
C  UPR_RANG_LO_LMT(3,2)  -  UPR_RANG_LO_LMT( IP,     IECT           ) 
C  MINUTES(70)           -  MINUTES(         ST_INDX                ) 
C  RATIO(3)              -  RATIO(           IP                     ) 
C 
C  Common block dictionary: 
C 
C   Name   Type              Description 
C  ------  ----  -------------------------------------------- 
C 
C  /SKDIST/: 
C 
C  SOAKDIST  R   Soak distribution array 
C 
C  /SOAK/: 
C 
C  CSA                R   constant   coefficient in CARB 
C  CSB                R   SOK_TIME   coefficient in CARB 
C  CSC                R   SOK_TIME^2 coefficient in CARB 
C  SOK_TIME           R   soak time in minutes 
C  RATIO              R   ratio in EPA correction to CARB function (SEE p.7 M6.STE.003) 
C  SOAKCF             R   Final soak time correction factors. 
C  SOAKFUN            R   The California soak function corrected for EPA use. 
C  LO_RANG_UP_LMT     I   fixes domains for curves 1 and 2 in CARB soak function 
C 
C 
C  Local array subscripts: 
C 
C  Jm(14,10)  -  Jm (IH,ST_INDX) 
C 
C  where J = SDY (applies to weekdays) and J = SND (applies to weekends) 
C        m = 1 when  1 .LE. ST_INDX .LE. 10 
C        m = 2 when 11 .LE. ST_INDX .LE. 20 
C        m = 3 when 21 .LE. ST_INDX .LE. 30 
C        m = 4 when 31 .LE. ST_INDX .LE. 40 
C        m = 5 when 41 .LE. ST_INDX .LE. 50 
C        m = 6 when 51 .LE. ST_INDX .LE. 60 
C        m = 7 when 61 .LE. ST_INDX .LE. 70 
C 
C 
C  Local array dictionary: 
C 
C   Name      Type                Descriptions 
C  ---------  ----  -------------------------------------------------------- 
C  SDY1         R      as defined above 
C    .          R            " " 
C    .          R            " " 
C    .          R            " " 
C  SDY7         R      as defined above 
C  SND1         R      as defined above 
C    .          R            " " 
C    .          R            " " 
C    .          R            " " 
C  SND7         R      as defined above 
C 
C  Notes: 
C 
C 23 Mar 98 @DynTel-RJD 2-650 Created BD41 for STARTS program. 
C 
      IMPLICIT NONE 
      INCLUDE 'SKDIST.I' 
      INCLUDE 'SOAK.I' 
C 
      REAL SDY1, SDY2, SDY3, SDY4, SDY5, SDY6, SDY7, SND1, SND2, SND3, 
     *SND4, SND5, SND6, SND7 
C 
      DIMENSION SDY1(24,10),SDY2(24,10),SDY3(24,10),SDY4(24,10) 
      DIMENSION SDY5(24,10),SDY6(24,10),SDY7(24,10) 
C 
      DIMENSION SND1(24,10),SND2(24,10),SND3(24,10),SND4(24,10) 
      DIMENSION SND5(24,10),SND6(24,10),SND7(24,10) 
C 
      EQUIVALENCE 
     *  (SOAKDIST(1,1,1),SDY1(1,1)), 
     *  (SOAKDIST(1,11,1),SDY2(1,1)), 
     *  (SOAKDIST(1,21,1),SDY3(1,1)), 
     *  (SOAKDIST(1,31,1),SDY4(1,1)), 
     *  (SOAKDIST(1,41,1),SDY5(1,1)), 
     *  (SOAKDIST(1,51,1),SDY6(1,1)), 
     *  (SOAKDIST(1,61,1),SDY7(1,1)), 
     *  (SOAKDIST(1,1,2), SND1(1,1)), 
     *  (SOAKDIST(1,11,2),SND2(1,1)), 
     *  (SOAKDIST(1,21,2),SND3(1,1)), 
     *  (SOAKDIST(1,31,2),SND4(1,1)), 
     *  (SOAKDIST(1,41,2),SND5(1,1)), 
     *  (SOAKDIST(1,51,2),SND6(1,1)), 
     *  (SOAKDIST(1,61,2),SND7(1,1))  
C 
C  /SKDIST/: 
C 
C  Hardcoded soak distribution data for weekdays 
C 
C 
      DATA SDY1/ 
C 
C  ST_INDX = 1 - 10 
C 
     1  0.038759690,0.025139665,0.044270836,0.046822742,0.061728396, 
     1  0.018691588,0.049618319,0.038709678,0.048732944,0.038394414, 
     1  0.044198893,0.036144577,0.033766232,11*0.033985581, 
     2  0.031007752,0.061452512,0.041666664,0.050167222,0.061728396, 
     2  0.046728972,0.055343509,0.049462367,0.048732944,0.059336826, 
     2  0.046040516,0.060240965,0.036363635,11*0.037075181, 
     3  0.023255814,0.033519555,0.031250000,0.053511705,0.040123459, 
     3  0.049065422,0.049618319,0.038709678,0.046783622,0.047120418, 
     3  0.044198893,0.066265061,0.038961038,11*0.028836250, 
     4  0.015503876,0.030726256,0.023437500,0.026755853,0.040123459, 
     4  0.046728972,0.047709923,0.040860213,0.019493178,0.034904014, 
     4  0.034990791,0.036144577,0.031168830,11*0.022657054, 
     5  0.007751938,0.005586592,0.023437500,0.020066891,0.021604938, 
     5  0.032710280,0.024809159,0.032258064,0.046783622,0.036649216, 
     5  0.040515650,0.020080321,0.033766232,11*0.017507724, 
     6  0.007751938,0.008379888,0.033854168,0.023411371,0.033950616, 
     6  0.037383176,0.038167939,0.032258064,0.027290449,0.040139619, 
     6  0.023941068,0.022088354,0.038961038,11*0.015447992, 
     7  0.000000000,0.011173184,0.020833332,0.010033445,0.012345679, 
     7  0.032710280,0.020992365,0.021505374,0.031189084,0.026178010, 
     7  0.018416205,0.024096387,0.023376621,11*0.016477859, 
     8  0.015503876,0.005586592,0.013020832,0.013377926,0.006172840, 
     8  0.011682243,0.020992365,0.025806451,0.025341131,0.026178010, 
     8  0.020257825,0.018072288,0.031168830,11*0.007209063, 
     9  0.007751938,0.002793296,0.002604167,0.006688963,0.009259259, 
     9  0.030373834,0.017175574,0.021505374,0.023391811,0.017452007, 
     9  0.020257825,0.014056224,0.002597403,11*0.004119465, 
     Z  0.007751938,0.005586592,0.026041668,0.016722409,0.018518519, 
     Z  0.009345794,0.009541985,0.012903226,0.019493178,0.024432810, 
     Z  0.014732965,0.010040160,0.018181818,11*0.007209063/ 
C 
      DATA SDY2/ 
C 
C  ST_INDX = 11 - 20 
C 
     1  0.007751938,0.002793296,0.018229168,0.020066891,0.024691358, 
     1  0.018691588,0.019083969,0.025806451,0.017543860,0.015706806, 
     1  0.022099447,0.014056224,0.010389610,11*0.007209063, 
     2  0.000000000,0.005586592,0.013020832,0.026755853,0.012345679, 
     2  0.032710280,0.019083969,0.019354839,0.013645224,0.015706806, 
     2  0.009208103,0.010040160,0.020779220,11*0.007209063, 
     3  0.000000000,0.005586592,0.015625000,0.010033445,0.003086420, 
     3  0.009345794,0.005725191,0.012903226,0.017543860,0.012216405, 
     3  0.012891344,0.012048193,0.015584417,11*0.005149330, 
     4  0.000000000,0.005586592,0.010416668,0.006688963,0.012345679, 
     4  0.007009346,0.011450383,0.015053763,0.009746589,0.006980803, 
     4  0.005524862,0.010040160,0.007792208,11*0.009268795, 
     5  0.000000000,0.005586592,0.010416668,0.010033445,0.009259259, 
     5  0.011682243,0.015267176,0.015053763,0.003898635,0.010471204, 
     5  0.014732965,0.014056224,0.012987013,11*0.013388259, 
     6  0.000000000,0.000000000,0.005208333,0.013377926,0.006172840, 
     6  0.009345794,0.009541985,0.008602152,0.001949318,0.010471204, 
     6  0.009208103,0.008032129,0.018181818,11*0.006179197, 
     7  0.007751938,0.002793296,0.015625000,0.010033445,0.012345679, 
     7  0.014018692,0.011450383,0.008602152,0.013645224,0.003490401, 
     7  0.003683241,0.004016064,0.010389610,11*0.004119465, 
     8  0.000000000,0.008379888,0.010416668,0.003344482,0.012345679, 
     8  0.004672897,0.007633588,0.010752687,0.015594542,0.012216405, 
     8  0.011049723,0.008032129,0.000000000,11*0.011328527, 
     9  0.000000000,0.000000000,0.010416668,0.010033445,0.006172840, 
     9  0.007009346,0.019083969,0.017204301,0.003898635,0.006980803, 
     9  0.011049723,0.014056224,0.010389610,11*0.006179197, 
     Z  0.000000000,0.005586592,0.013020832,0.013377926,0.015432099, 
     Z  0.007009346,0.013358779,0.002150538,0.007797271,0.010471204, 
     Z  0.011049723,0.006024096,0.002597403,11*0.010298661/ 
C 
      DATA SDY3/ 
C 
C  ST_INDX = 21 - 30 
C 
     1  0.000000000,0.008379888,0.000000000,0.003344482,0.012345679, 
     1  0.011682243,0.009541985,0.012903226,0.003898635,0.008726004, 
     1  0.009208103,0.006024096,0.007792208,11*0.004119465, 
     2  0.000000000,0.000000000,0.007812500,0.010033445,0.006172840, 
     2  0.004672897,0.005725191,0.021505374,0.011695906,0.010471204, 
     2  0.005524862,0.004016064,0.010389610,11*0.007209063, 
     3  0.000000000,0.000000000,0.000000000,0.000000000,0.015432099, 
     3  0.014018692,0.007633588,0.002150538,0.007797271,0.010471204, 
     3  0.007366483,0.012048193,0.012987013,11*0.011328527, 
     4  0.000000000,0.000000000,0.007812500,0.023411371,0.006172840, 
     4  0.004672897,0.005725191,0.015053763,0.007797271,0.006980803, 
     4  0.011049723,0.012048193,0.002597403,11*0.008238929, 
     5  0.000000000,0.000000000,0.002604167,0.010033445,0.000000000, 
     5  0.004672897,0.003816794,0.012903226,0.005847953,0.006980803, 
     5  0.005524862,0.002008032,0.002597403,11*0.003089598, 
     6  0.000000000,0.000000000,0.005208333,0.006688963,0.009259259, 
     6  0.009345794,0.011450383,0.008602152,0.007797271,0.001745201, 
     6  0.009208103,0.008032129,0.002597403,11*0.003089598, 
     7  0.000000000,0.000000000,0.007812500,0.003344482,0.000000000, 
     7  0.004672897,0.005725191,0.002150538,0.011695906,0.003490401, 
     7  0.007366483,0.012048193,0.007792208,11*0.004119465, 
     8  0.000000000,0.002793296,0.002604167,0.003344482,0.000000000, 
     8  0.011682243,0.001908397,0.010752687,0.007797271,0.005235602, 
     8  0.005524862,0.008032129,0.005194805,11*0.004119465, 
     9  0.000000000,0.002793296,0.000000000,0.003344482,0.009259259, 
     9  0.002336449,0.005725191,0.008602152,0.001949318,0.003490401, 
     9  0.003683241,0.004016064,0.015584417,11*0.003089598, 
     Z  0.000000000,0.000000000,0.002604167,0.010033445,0.003086420, 
     Z  0.004672897,0.003816794,0.006451613,0.005847953,0.005235602, 
     Z  0.012891344,0.002008032,0.005194805,11*0.006179197/ 
C 
      DATA SDY4/ 
C 
C  ST_INDX = 31 - 40 
C 
     1  0.000000000,0.000000000,0.007812500,0.013377926,0.009259259, 
     1  0.016355140,0.011450383,0.006451613,0.013645224,0.012216405, 
     1  0.011049723,0.012048193,0.005194805,11*0.011328527, 
     2  0.007751938,0.005586592,0.007812500,0.003344482,0.006172840, 
     2  0.014018692,0.020992365,0.017204301,0.013645224,0.006980803, 
     2  0.007366483,0.016064256,0.007792208,11*0.008238929, 
     3  0.000000000,0.000000000,0.002604167,0.000000000,0.012345679, 
     3  0.011682243,0.013358779,0.008602152,0.017543860,0.003490401, 
     3  0.012891344,0.008032129,0.007792208,11*0.009268795, 
     4  0.000000000,0.002793296,0.010416668,0.006688963,0.003086420, 
     4  0.004672897,0.005725191,0.010752687,0.009746589,0.012216405, 
     4  0.005524862,0.008032129,0.007792208,11*0.005149330, 
     5  0.000000000,0.000000000,0.005208333,0.010033445,0.012345679, 
     5  0.014018692,0.007633588,0.006451613,0.009746589,0.013961606, 
     5  0.009208103,0.008032129,0.007792208,11*0.009268795, 
     6  0.000000000,0.000000000,0.000000000,0.013377926,0.009259259, 
     6  0.004672897,0.011450383,0.010752687,0.007797271,0.005235602, 
     6  0.007366483,0.010040160,0.007792208,11*0.002059732, 
     7  0.000000000,0.002793296,0.005208333,0.006688963,0.012345679, 
     7  0.014018692,0.009541985,0.006451613,0.005847953,0.010471204, 
     7  0.003683241,0.008032129,0.012987013,11*0.004119465, 
     8  0.000000000,0.000000000,0.000000000,0.000000000,0.006172840, 
     8  0.004672897,0.009541985,0.010752687,0.007797271,0.012216405, 
     8  0.007366483,0.004016064,0.005194805,11*0.007209063, 
     9  0.000000000,0.005586592,0.005208333,0.020066891,0.006172840, 
     9  0.009345794,0.003816794,0.004301075,0.017543860,0.003490401, 
     9  0.007366483,0.006024096,0.005194805,11*0.009268795, 
     Z  0.000000000,0.002793296,0.007812500,0.000000000,0.018518519, 
     Z  0.007009346,0.003816794,0.006451613,0.000000000,0.001745201, 
     Z  0.009208103,0.006024096,0.005194805,11*0.003089598/ 
C 
      DATA SDY5/ 
C 
C  ST_INDX = 41 - 50 
C 
     1  0.000000000,0.002793296,0.000000000,0.003344482,0.009259259, 
     1  0.004672897,0.007633588,0.008602152,0.005847953,0.003490401, 
     1  0.009208103,0.000000000,0.010389610,11*0.012358394, 
     2  0.000000000,0.000000000,0.000000000,0.003344482,0.006172840, 
     2  0.002336449,0.015267176,0.004301075,0.005847953,0.005235602, 
     2  0.005524862,0.010040160,0.010389610,11*0.009268795, 
     3  0.000000000,0.002793296,0.000000000,0.003344482,0.009259259, 
     3  0.007009346,0.007633588,0.004301075,0.009746589,0.008726004, 
     3  0.012891344,0.008032129,0.007792208,11*0.008238929, 
     4  0.000000000,0.000000000,0.002604167,0.006688963,0.003086420, 
     4  0.002336449,0.013358779,0.008602152,0.009746589,0.005235602, 
     4  0.003683241,0.002008032,0.007792208,11*0.008238929, 
     5  0.000000000,0.000000000,0.002604167,0.000000000,0.003086420, 
     5  0.000000000,0.003816794,0.000000000,0.003898635,0.001745201, 
     5  0.001841621,0.010040160,0.005194805,11*0.005149330, 
     6  0.000000000,0.000000000,0.013020832,0.060200669,0.074074075, 
     6  0.049065422,0.051526718,0.064516127,0.072124757,0.055846423, 
     6  0.066298343,0.054216865,0.109090909,11*0.084449023, 
     7  0.000000000,0.002793296,0.002604167,0.040133778,0.040123459, 
     7  0.049065422,0.022900762,0.019354839,0.046783622,0.040139619, 
     7  0.047882136,0.048192773,0.044155847,11*0.064881563, 
     8  0.000000000,0.000000000,0.002604167,0.023411371,0.018518519, 
     8  0.030373834,0.019083969,0.030107526,0.042884991,0.024432810, 
     8  0.025782689,0.022088354,0.057142857,11*0.058702368, 
     9  0.007751938,0.000000000,0.000000000,0.000000000,0.003086420, 
     9  0.030373834,0.022900762,0.019354839,0.023391811,0.031413611, 
     9  0.018416205,0.024096387,0.046753250,11*0.048403706, 
     Z  0.000000000,0.000000000,0.000000000,0.000000000,0.009259259, 
     Z  0.023364486,0.017175574,0.017204301,0.013645224,0.012216405, 
     Z  0.016574586,0.022088354,0.018181818,11*0.032955717/ 
C 
      DATA SDY6/ 
C 
C  ST_INDX = 51 - 60 
C 
     1  0.000000000,0.002793296,0.002604167,0.003344482,0.012345679, 
     1  0.028037384,0.028625954,0.021505374,0.013645224,0.010471204, 
     1  0.031307552,0.006024096,0.010389610,11*0.028836250, 
     2  0.000000000,0.000000000,0.000000000,0.003344482,0.003086420, 
     2  0.025700934,0.036259543,0.010752687,0.007797271,0.006980803, 
     2  0.012891344,0.024096387,0.018181818,11*0.016477859, 
     3  0.000000000,0.002793296,0.002604167,0.000000000,0.003086420, 
     3  0.000000000,0.022900762,0.010752687,0.009746589,0.005235602, 
     3  0.012891344,0.016064256,0.010389610,11*0.013388259, 
     4  0.000000000,0.002793296,0.000000000,0.000000000,0.006172840, 
     4  0.002336449,0.003816794,0.010752687,0.005847953,0.005235602, 
     4  0.005524862,0.006024096,0.002597403,11*0.021627188, 
     5  0.000000000,0.002793296,0.000000000,0.000000000,0.003086420, 
     5  0.000000000,0.007633588,0.002150538,0.001949318,0.010471204, 
     5  0.003683241,0.010040160,0.005194805,11*0.011328527, 
     6  0.000000000,0.002793296,0.000000000,0.003344482,0.003086420, 
     6  0.007009346,0.000000000,0.010752687,0.011695906,0.019197207, 
     6  0.003683241,0.002008032,0.005194805,11*0.009268795, 
     7  0.007751938,0.005586592,0.002604167,0.000000000,0.003086420, 
     7  0.002336449,0.000000000,0.006451613,0.009746589,0.015706806, 
     7  0.000000000,0.002008032,0.000000000,11*0.010298661, 
     8  0.007751938,0.013966480,0.002604167,0.003344482,0.000000000, 
     8  0.000000000,0.003816794,0.002150538,0.013645224,0.008726004, 
     8  0.001841621,0.000000000,0.002597403,11*0.007209063, 
     9  0.031007752,0.011173184,0.002604167,0.000000000,0.003086420, 
     9  0.002336449,0.003816794,0.002150538,0.001949318,0.015706806, 
     9  0.016574586,0.014056224,0.000000000,11*0.015447992, 
     Z  0.054263569,0.008379888,0.000000000,0.000000000,0.000000000, 
     Z  0.000000000,0.000000000,0.004301075,0.003898635,0.013961606, 
     Z  0.018416205,0.026104417,0.000000000,11*0.019567456/ 
C 
      DATA SDY7/ 
C 
C  ST_INDX = 61 - 67 
C 
     1  0.031007752,0.011173184,0.005208333,0.006688963,0.006172840, 
     1  0.000000000,0.000000000,0.006451613,0.007797271,0.038394414, 
     1  0.047882136,0.026104417,0.002597403,11*0.022657054, 
     2  0.023255814,0.027932961,0.018229168,0.006688963,0.006172840, 
     2  0.002336449,0.000000000,0.000000000,0.003898635,0.019197207, 
     2  0.009208103,0.032128513,0.007792208,11*0.009268795, 
     3  0.038759690,0.016759777,0.023437500,0.006688963,0.003086420, 
     3  0.000000000,0.000000000,0.004301075,0.000000000,0.001745201, 
     3  0.003683241,0.016064256,0.031168830,11*0.003089598, 
     4  0.015503876,0.055865921,0.007812500,0.010033445,0.006172840, 
     4  0.004672897,0.003816794,0.000000000,0.000000000,0.003490401, 
     4  0.001841621,0.014056224,0.002597403,11*0.006179197, 
     5  0.046511628,0.036312848,0.015625000,0.006688963,0.006172840, 
     5  0.004672897,0.000000000,0.000000000,0.001949318,0.000000000, 
     5  0.003683241,0.000000000,0.005194805,11*0.009268795, 
     6  0.046511628,0.039106146,0.015625000,0.020066891,0.012345679, 
     6  0.002336449,0.001908397,0.000000000,0.000000000,0.000000000, 
     6  0.000000000,0.000000000,0.007792208,11*0.006179197, 
     7  0.038759690,0.033519555,0.026041668,0.003344482,0.003086420, 
     7  0.000000000,0.000000000,0.000000000,0.000000000,0.000000000, 
     7  0.001841621,0.000000000,0.000000000,11*0.004119465, 
C 
C  720+ minutes 
C 
     8  0.457364351,0.427374303,0.351562500,0.240802690,0.151234567, 
     8  0.088785045,0.064885497,0.070967741,0.040935673,0.022687608, 
     8  0.020257825,0.014056224,0.015584417,11*0.041194644, 
C 
C  0.01 minutes 
C 
     9  0.015503876,0.025139665,0.028645832,0.006688963,0.015432099, 
     9  0.021028036,0.017175574,0.021505374,0.013645224,0.013961606, 
     9  0.020257825,0.026104417,0.012987013,11*0.017507724, 
C 
C  Stalls 
C 
     Z  0.000000000,0.000000000,0.000000000,0.000000000,0.000000000, 
     Z  0.000000000,0.000000000,0.000000000,0.000000000,0.000000000, 
     Z  0.000000000,0.000000000,0.000000000,11*0.000000000/ 
C 
C 
C  /SKDIST/: 
C 
C  Hardcoded soak distribution data for weekends 
C 
C 
      DATA SND1/ 
C 
C  ST_INDX = 1 - 10 
C 
     1  0.111111000,0.026316000,0.032786999,0.023622001,0.051470999, 
     1  0.025478000,0.055000000,0.041958001,0.062857002,0.062068999, 
     1  0.042253502,0.022727270,0.042372879,11*0.042968750, 
     2  0.055555999,0.078947000,0.016393000,0.055117998,0.051470999, 
     2  0.019107999,0.055000000,0.055943999,0.045713998,0.048276000, 
     2  0.035211299,0.037878789,0.050847460,11*0.054687500, 
     3  0.166666999,0.052632000,0.032786999,0.055117998,0.051470999, 
     3  0.050955001,0.035000000,0.041958001,0.028571000,0.062068999, 
     3  0.042253502,0.045454551,0.033898309,11*0.046875000, 
     4  0.055555999,0.000000000,0.065573998,0.007874000,0.036765002, 
     4  0.025478000,0.039999999,0.041958001,0.051429000,0.027586000, 
     4  0.042253502,0.030303029,0.025423730,11*0.050781250, 
     5  0.000000000,0.026316000,0.032786999,0.062991999,0.022058999, 
     5  0.038217001,0.039999999,0.013986000,0.022856999,0.034483001, 
     5  0.042253502,0.015151520,0.008474580,11*0.031250000, 
     6  0.055555999,0.000000000,0.016393000,0.000000000,0.036765002, 
     6  0.006369000,0.025000000,0.034965001,0.011429000,0.020690000, 
     6  0.028169001,0.015151520,0.000000000,11*0.027343750, 
     7  0.000000000,0.052632000,0.016393000,0.007874000,0.014706000, 
     7  0.019107999,0.045000002,0.020979000,0.028571000,0.013793000, 
     7  0.035211299,0.030303029,0.033898309,11*0.023437500, 
     8  0.000000000,0.000000000,0.016393000,0.015748000,0.029412000, 
     8  0.019107999,0.035000000,0.006993000,0.028571000,0.041379001, 
     8  0.028169001,0.007575760,0.016949151,11*0.003906250, 
     9  0.000000000,0.000000000,0.032786999,0.007874000,0.022058999, 
     9  0.031847000,0.015000000,0.006993000,0.017143000,0.034483001, 
     9  0.028169001,0.030303029,0.016949151,11*0.015625000, 
     Z  0.000000000,0.000000000,0.000000000,0.007874000,0.000000000, 
     Z  0.006369000,0.015000000,0.013986000,0.022856999,0.006897000, 
     Z  0.014084500,0.015151520,0.016949151,11*0.011718750/ 
C 
      DATA SND2/ 
C 
C  ST_INDX = 11 - 20 
C 
     1  0.000000000,0.000000000,0.000000000,0.007874000,0.000000000, 
     1  0.006369000,0.035000000,0.027972000,0.000000000,0.013793000, 
     1  0.007042300,0.007575760,0.016949151,11*0.019531250, 
     2  0.000000000,0.000000000,0.000000000,0.023622001,0.014706000, 
     2  0.025478000,0.015000000,0.013986000,0.011429000,0.000000000, 
     2  0.007042300,0.000000000,0.033898309,11*0.000000000, 
     3  0.000000000,0.000000000,0.000000000,0.007874000,0.014706000, 
     3  0.012739000,0.000000000,0.027972000,0.005714000,0.006897000, 
     3  0.021126799,0.007575760,0.000000000,11*0.000000000, 
     4  0.055555999,0.000000000,0.000000000,0.007874000,0.022058999, 
     4  0.012739000,0.015000000,0.000000000,0.000000000,0.000000000, 
     4  0.014084500,0.045454551,0.008474580,11*0.000000000, 
     5  0.000000000,0.000000000,0.000000000,0.000000000,0.014706000, 
     5  0.000000000,0.015000000,0.006993000,0.017143000,0.000000000, 
     5  0.000000000,0.030303029,0.008474580,11*0.000000000, 
     6  0.000000000,0.000000000,0.000000000,0.015748000,0.000000000, 
     6  0.000000000,0.005000000,0.006993000,0.011429000,0.020690000, 
     6  0.000000000,0.007575760,0.000000000,11*0.015625000, 
     7  0.000000000,0.000000000,0.016393000,0.023622001,0.007353000, 
     7  0.025478000,0.015000000,0.013986000,0.005714000,0.013793000, 
     7  0.007042300,0.030303029,0.016949151,11*0.003906250, 
     8  0.000000000,0.000000000,0.016393000,0.000000000,0.014706000, 
     8  0.006369000,0.005000000,0.013986000,0.005714000,0.013793000, 
     8  0.007042300,0.007575760,0.000000000,11*0.007812500, 
     9  0.000000000,0.000000000,0.016393000,0.007874000,0.000000000, 
     9  0.012739000,0.010000000,0.006993000,0.034286000,0.000000000, 
     9  0.028169001,0.007575760,0.016949151,11*0.003906250, 
     Z  0.000000000,0.000000000,0.000000000,0.007874000,0.007353000, 
     Z  0.006369000,0.015000000,0.006993000,0.011429000,0.006897000, 
     Z  0.014084500,0.007575760,0.008474580,11*0.003906250/ 
C 
      DATA SND3/ 
C 
C  ST_INDX = 21 - 30 
C 
     1  0.000000000,0.000000000,0.000000000,0.000000000,0.000000000, 
     1  0.006369000,0.010000000,0.000000000,0.011429000,0.013793000, 
     1  0.000000000,0.015151520,0.000000000,11*0.007812500, 
     2  0.000000000,0.000000000,0.000000000,0.023622001,0.000000000, 
     2  0.012739000,0.010000000,0.013986000,0.000000000,0.000000000, 
     2  0.007042300,0.030303029,0.016949151,11*0.000000000, 
     3  0.000000000,0.000000000,0.000000000,0.015748000,0.000000000, 
     3  0.012739000,0.000000000,0.006993000,0.005714000,0.006897000, 
     3  0.014084500,0.007575760,0.000000000,11*0.003906250, 
     4  0.000000000,0.000000000,0.000000000,0.000000000,0.000000000, 
     4  0.006369000,0.000000000,0.000000000,0.011429000,0.020690000, 
     4  0.014084500,0.007575760,0.008474580,11*0.007812500, 
     5  0.000000000,0.000000000,0.032786999,0.000000000,0.000000000, 
     5  0.006369000,0.015000000,0.000000000,0.005714000,0.000000000, 
     5  0.021126799,0.000000000,0.000000000,11*0.003906250, 
     6  0.000000000,0.000000000,0.000000000,0.000000000,0.007353000, 
     6  0.000000000,0.005000000,0.000000000,0.011429000,0.006897000, 
     6  0.000000000,0.000000000,0.000000000,11*0.000000000, 
     7  0.000000000,0.000000000,0.016393000,0.015748000,0.014706000, 
     7  0.012739000,0.005000000,0.013986000,0.005714000,0.000000000, 
     7  0.007042300,0.000000000,0.000000000,11*0.000000000, 
     8  0.000000000,0.000000000,0.000000000,0.007874000,0.000000000, 
     8  0.006369000,0.005000000,0.013986000,0.005714000,0.006897000, 
     8  0.014084500,0.000000000,0.008474580,11*0.000000000, 
     9  0.000000000,0.000000000,0.000000000,0.000000000,0.000000000, 
     9  0.006369000,0.000000000,0.013986000,0.005714000,0.006897000, 
     9  0.000000000,0.000000000,0.000000000,11*0.007812500, 
     Z  0.000000000,0.000000000,0.000000000,0.000000000,0.007353000, 
     Z  0.025478000,0.010000000,0.013986000,0.000000000,0.000000000, 
     Z  0.007042300,0.000000000,0.008474580,11*0.000000000/ 
C 
      DATA SND4/ 
C 
C  ST_INDX = 31 - 40 
C 
     1  0.000000000,0.000000000,0.000000000,0.007874000,0.022058999, 
     1  0.044585999,0.000000000,0.000000000,0.011429000,0.006897000, 
     1  0.021126799,0.015151520,0.016949151,11*0.007812500, 
     2  0.000000000,0.000000000,0.016393000,0.000000000,0.036765002, 
     2  0.000000000,0.005000000,0.020979000,0.017143000,0.006897000, 
     2  0.007042300,0.007575760,0.008474580,11*0.000000000, 
     3  0.000000000,0.000000000,0.016393000,0.015748000,0.007353000, 
     3  0.006369000,0.005000000,0.020979000,0.011429000,0.006897000, 
     3  0.000000000,0.000000000,0.008474580,11*0.000000000, 
     4  0.000000000,0.000000000,0.000000000,0.000000000,0.000000000, 
     4  0.006369000,0.025000000,0.013986000,0.000000000,0.027586000, 
     4  0.007042300,0.000000000,0.000000000,11*0.003906250, 
     5  0.000000000,0.000000000,0.000000000,0.015748000,0.029412000, 
     5  0.012739000,0.005000000,0.000000000,0.000000000,0.006897000, 
     5  0.042253502,0.022727270,0.000000000,11*0.011718750, 
     6  0.000000000,0.000000000,0.016393000,0.000000000,0.000000000, 
     6  0.006369000,0.000000000,0.013986000,0.017143000,0.020690000, 
     6  0.014084500,0.022727270,0.000000000,11*0.003906250, 
     7  0.000000000,0.000000000,0.000000000,0.000000000,0.000000000, 
     7  0.000000000,0.020000000,0.013986000,0.000000000,0.006897000, 
     7  0.000000000,0.015151520,0.025423730,11*0.003906250, 
     8  0.000000000,0.000000000,0.000000000,0.007874000,0.000000000, 
     8  0.000000000,0.015000000,0.013986000,0.005714000,0.006897000, 
     8  0.028169001,0.007575760,0.016949151,11*0.003906250, 
     9  0.000000000,0.000000000,0.016393000,0.000000000,0.000000000, 
     9  0.019107999,0.000000000,0.013986000,0.011429000,0.027586000, 
     9  0.000000000,0.000000000,0.000000000,11*0.007812500, 
     Z  0.000000000,0.000000000,0.000000000,0.007874000,0.007353000, 
     Z  0.012739000,0.000000000,0.013986000,0.005714000,0.006897000, 
     Z  0.000000000,0.022727270,0.000000000,11*0.003906250/ 
C 
      DATA SND5/ 
C 
C  ST_INDX = 41 - 50 
C 
     1  0.000000000,0.000000000,0.000000000,0.000000000,0.022058999, 
     1  0.012739000,0.000000000,0.006993000,0.017143000,0.006897000, 
     1  0.000000000,0.007575760,0.008474580,11*0.015625000, 
     2  0.000000000,0.000000000,0.000000000,0.000000000,0.007353000, 
     2  0.006369000,0.020000000,0.013986000,0.000000000,0.013793000, 
     2  0.021126799,0.015151520,0.000000000,11*0.003906250, 
     3  0.000000000,0.000000000,0.000000000,0.000000000,0.007353000, 
     3  0.000000000,0.005000000,0.000000000,0.017143000,0.006897000, 
     3  0.000000000,0.000000000,0.025423730,11*0.000000000, 
     4  0.000000000,0.000000000,0.016393000,0.007874000,0.000000000, 
     4  0.000000000,0.010000000,0.000000000,0.005714000,0.013793000, 
     4  0.021126799,0.000000000,0.000000000,11*0.003906250, 
     5  0.000000000,0.000000000,0.000000000,0.007874000,0.007353000, 
     5  0.006369000,0.005000000,0.013986000,0.000000000,0.000000000, 
     5  0.000000000,0.015151520,0.000000000,11*0.003906250, 
     6  0.000000000,0.000000000,0.032786999,0.031496000,0.044117998, 
     6  0.089171998,0.039999999,0.062936999,0.079999998,0.041379001, 
     6  0.091549300,0.090909094,0.093220338,11*0.089843750, 
     7  0.000000000,0.000000000,0.000000000,0.023622001,0.007353000, 
     7  0.019107999,0.035000000,0.048951000,0.045713998,0.048276000, 
     7  0.042253502,0.068181820,0.118644074,11*0.054687500, 
     8  0.000000000,0.000000000,0.000000000,0.007874000,0.007353000, 
     8  0.025478000,0.025000000,0.013986000,0.039999999,0.041379001, 
     8  0.028169001,0.030303029,0.059322029,11*0.054687500, 
     9  0.000000000,0.000000000,0.000000000,0.000000000,0.022058999, 
     9  0.000000000,0.025000000,0.034965001,0.022856999,0.034483001, 
     9  0.056338001,0.030303029,0.016949151,11*0.062500000, 
     Z  0.000000000,0.000000000,0.000000000,0.000000000,0.000000000, 
     Z  0.006369000,0.010000000,0.020979000,0.000000000,0.013793000, 
     Z  0.000000000,0.000000000,0.050847460,11*0.050781250/ 
C 
      DATA SND6/ 
C 
C  ST_INDX = 51 - 60 
C 
     1  0.000000000,0.000000000,0.000000000,0.015748000,0.000000000, 
     1  0.012739000,0.005000000,0.006993000,0.028571000,0.027586000, 
     1  0.021126799,0.015151520,0.016949151,11*0.027343750, 
     2  0.000000000,0.000000000,0.000000000,0.000000000,0.007353000, 
     2  0.000000000,0.000000000,0.006993000,0.000000000,0.006897000, 
     2  0.021126799,0.015151520,0.033898309,11*0.031250000, 
     3  0.000000000,0.026316000,0.000000000,0.000000000,0.000000000, 
     3  0.000000000,0.005000000,0.006993000,0.011429000,0.013793000, 
     3  0.014084500,0.015151520,0.016949151,11*0.046875000, 
     4  0.000000000,0.026316000,0.000000000,0.000000000,0.000000000, 
     4  0.006369000,0.010000000,0.006993000,0.005714000,0.000000000, 
     4  0.007042300,0.045454551,0.008474580,11*0.003906250, 
     5  0.055555999,0.000000000,0.000000000,0.000000000,0.000000000, 
     5  0.000000000,0.000000000,0.006993000,0.000000000,0.000000000, 
     5  0.000000000,0.030303029,0.000000000,11*0.007812500, 
     6  0.055555999,0.000000000,0.000000000,0.000000000,0.000000000, 
     6  0.000000000,0.000000000,0.000000000,0.000000000,0.000000000, 
     6  0.000000000,0.000000000,0.000000000,11*0.015625000, 
     7  0.000000000,0.000000000,0.000000000,0.000000000,0.000000000, 
     7  0.000000000,0.000000000,0.000000000,0.000000000,0.000000000, 
     7  0.000000000,0.015151520,0.008474580,11*0.023437500, 
     8  0.055555999,0.026316000,0.016393000,0.015748000,0.000000000, 
     8  0.000000000,0.000000000,0.000000000,0.000000000,0.000000000, 
     8  0.000000000,0.000000000,0.000000000,11*0.000000000, 
     9  0.000000000,0.026316000,0.000000000,0.007874000,0.000000000, 
     9  0.000000000,0.000000000,0.000000000,0.011429000,0.006897000, 
     9  0.014084500,0.000000000,0.000000000,11*0.003906250, 
     Z  0.055555999,0.026316000,0.000000000,0.007874000,0.014706000, 
     Z  0.000000000,0.005000000,0.000000000,0.005714000,0.006897000, 
     Z  0.007042300,0.000000000,0.025423730,11*0.019531250/ 
C 
      DATA SND7/ 
C 
C  ST_INDX = 61 - 70 
C 
     1  0.055555999,0.052632000,0.016393000,0.015748000,0.007353000, 
     1  0.000000000,0.000000000,0.000000000,0.000000000,0.006897000, 
     1  0.000000000,0.007575760,0.000000000,11*0.003906250, 
     2  0.000000000,0.000000000,0.049180001,0.023622001,0.007353000, 
     2  0.006369000,0.005000000,0.000000000,0.005714000,0.000000000, 
     2  0.000000000,0.007575760,0.008474580,11*0.003906250, 
     3  0.000000000,0.026316000,0.016393000,0.007874000,0.007353000, 
     3  0.006369000,0.000000000,0.000000000,0.000000000,0.000000000, 
     3  0.000000000,0.007575760,0.000000000,11*0.007812500, 
     4  0.000000000,0.000000000,0.016393000,0.031496000,0.007353000, 
     4  0.012739000,0.005000000,0.000000000,0.000000000,0.000000000, 
     4  0.000000000,0.000000000,0.000000000,11*0.007812500, 
     5  0.000000000,0.052632000,0.032786999,0.000000000,0.000000000, 
     5  0.006369000,0.000000000,0.000000000,0.000000000,0.006897000, 
     5  0.000000000,0.000000000,0.008474580,11*0.000000000, 
     6  0.000000000,0.000000000,0.000000000,0.007874000,0.000000000, 
     6  0.000000000,0.005000000,0.000000000,0.000000000,0.000000000, 
     6  0.000000000,0.000000000,0.000000000,11*0.003906250, 
     7  0.000000000,0.026316000,0.032786999,0.007874000,0.014706000, 
     7  0.000000000,0.000000000,0.006993000,0.005714000,0.000000000, 
     7  0.000000000,0.000000000,0.000000000,11*0.000000000, 
C 
C  720+ minutes 
C 
     8  0.222222000,0.421052992,0.344262004,0.275590986,0.264705986, 
     8  0.203822002,0.144999996,0.125873998,0.097143002,0.075861998, 
     8  0.000000000,0.000000000,0.000000000,11*0.000000000, 
C 
C  0.01 minutes 
C 
     9  0.000000000,0.052632000,0.000000000,0.039370000,0.000000000, 
     9  0.025478000,0.015000000,0.006993000,0.034286000,0.013793000, 
     9  0.007042300,0.007575760,0.025423730,11*0.011718750, 
C 
C  Stalls 
C 
     Z  0.000000000,0.000000000,0.000000000,0.000000000,0.000000000, 
     Z  0.000000000,0.000000000,0.000000000,0.000000000,0.000000000, 
     Z  0.000000000,0.000000000,0.000000000,11*0.000000000/ 
C 
C 
C /SOAK/: 
C 
      DATA SOAKFUN/ 140*0.0 / 
C 
      DATA CSA/ 0.3807,0.4363,0.4380,-0.08541,1.3157,2.4806, 
     *          0.0   ,0.5713,0.0   , 0.7064 ,0.1180,1.1298 / 
C 
C       electrically heated catalyst parameters 
C 
C    *  0.0,0.5064,0.0,0.4473,1.0502,1.3718/ 
C 
      DATA CSB/-0.00163,0.00078,-0.00998,0.00303,0.02752,-0.00018, 
     *          0.01272,0.00072, 0.01195,0.00033,0.02967, 2.21E-05/ 
C 
C       electrically heated catalyst parameters 
C 
C    *  0.00561,0.00069,0.00707,0.00162,0.00362,0.00027/ 
C 
      DATA CSC/6.64E-05 ,  0.0      ,  7.01E-05, -2.11E-06, -1.50E-04, 
     *        -2.60E-06 , -6.30E-05 , -1.76E-07, -4.76E-05,  1.00E-07, 
     *        -2.10E-04 , -3.04E-07 / 
C 
C       electrically heated catalyst parameters 
C 
C    *  -5.09E-06,0.0,-1.33E-05,-1.18E-06,-5.57E-06,-1.09E-06/           
C 
C 
      DATA UPR_RANG_LO_LMT/ 
C 
C   IECT    IP = 1(HC)   2(CO)   3(NOX) 
C 
     1            53,     120,     120, 
     2            90,     117,      62 / 
C  
C       electrically heated catalyst parameters 
C 
C    *                   118,108,114/ 
C 
      DATA RATIO/ 
C 
C           IP =   1(HC)   2(CO)   3(NOX) 
C 
     *            1.3234,  0.9718,  0.5182 / 
C 
C   Values for RATIO_A are the numerator portion only of RATIO as given 
C   on page 13 of M6.STE.003, revised June 30, 1998.  Using only the 
C   numerator portion of RATIO assumes that the California Soak Function 
C   is equal to one. 
C 
      DATA RATIO_A/ 
C 
C           IP =   1(HC)  2(CO)  3(NOX) 
C 
     *             0.160, 0.112, 0.204 / 
C 
C 
C 
      DATA SOK_TIME/ 
C 
C      ST_INDX = 1 - 10 
C 
     *   1.0,  2.0,  3.0,  4.0,  5.0,  6.0,  7.0,  8.0,  9.0 , 10.0, 
C 
C      ST_INDX = 11 - 20 
C 
     *  11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0 , 20.0, 
C 
C      ST_INDX = 21 - 30 
C 
     *  21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 
C 
C      ST_INDX = 31 - 40 
C 
     *  32.0, 34.0, 36.0, 38.0, 40.0, 42.0, 44.0, 46.0, 48.0, 50.0, 
C 
C      ST_INDX = 41 - 50 
C 
     *  52.0, 54.0, 56.0, 58.0, 60.0, 90.0,120.0,150.0,180.0,210.0, 
C 
C      ST_INDX = 51 - 60 
C 
     * 240.0,270.0,300.0,330.0,360.0,390.0,420.0,450.0,480.0,510.0, 
C 
C      ST_INDX = 61 - 70 
C 
     * 540.0,570.0,600.0,630.0,660.0,690.0,720.0,720.0,  0.01,  0.0/ 
C 
      END 
