      BLOCK DATA BDSPEED1 
C 
C  BLOCK DATA Subprogram 02: /SPEED2/,/SPEED3/,/SPEED4/,/SPEED5/,/SPEED6/, 
C                            /SPEED7/,/SPEED8/ 
C 
C  BLOCK DATA 02 defines the last years of the model year groups used for 
C  speed correction factor (scf) coefficients, variables and arrays used in the 
C  calculation of the scf, the high speed CO scf coefficent parameters, and 
C  the speed and optional features correction factor array generated by BIGSAL. 
C 
C  Changes : 
C 
C  19 Jul 01 @EPA-djb Wish235, Add SPEED0.I parameters. 
C   2 Feb 00 @DynTel-ddj 1-032  Changed LDDT to LDDT12 and created 
C            LDDT34 by copying LDDT12 data to place holder for 
C            vehicle type 28. 
C  Common block array subscripts: 
C 
C  GPBSCO(3,3,22)    -  GPBSCO ( ICOEF2, IP, IVB ) 
C  MAXHSP(5)         -  MAXHSP ( IVLDG ) 
C  MYGSMC(18,2,3)    -  MYGSMC ( IG, IR, IP ) 
C  MYGSP1(18,2,5)    -  MYGSP1 ( IG, IR, IV ) 
C  MYGSP2(3,5)       -  MYGSP2 ( IP, IVLDG ) 
C  MYHSPC(2,10)      -  MYHSPC ( IG,  IVLDG ) 
C  LB1STS(5)         -  LB1STS ( IVLDG ) 
C  SALHCF(25,3,28,2) -  SALHCF ( IDX, IP, IV, ISR ) 
C  SCUNA1(18,3,28)   -  SCUNA1 ( IG, IP, IV ) 
C  SIXT5(11,3,5)     -  SIXT5  ( MY, IP, IVA ) 
C 
C  Common block dictionary: 
C 
C   Name   Type             Description 
C  ------  ----  ------------------------------------------ 
C  /SPEED2/: 
C 
C  MYGSP1   I    scf myg last years for old equation for LDGV, and LDGT 
C  MYGSMC   I    scf myg last years for MC 
C  MYGSP2   I    1st myg ub model years for new scf equations for LDGV/T 
C 
C  /SPEED3/: 
C 
C  SADJ     R    FTP operating mode speeds weighted together by the vmt 
C                fraction for each to get scenario's average speed 
C  SCUNA1   R    speed correction factors, adjusting bef's, which are 
C                calculated at an assumed average speed of 19.6 mph, to 
C                ef's at the user entered scenario average speed 
C 
C  /SPEED4/: 
C 
C  MAXSP1   I    maximum no. of mygs for the old LDGV/T & MC scf equation coefs 
C  LB1STS   I    lb my of 1st myg using new scf equations (ex:A/X+B) for IVLDG 
C  LBLAST   I    lb my of last myg of the new LDGV/T scf equation coefs 
C  IVA,IVB       see Subscript Dictionary in source code header (1,999) 
C 
C  /SPEED5/: 
C 
C  MYHSPC   I    first my of first and last myg's of the high speed HC and CO 
C                scf A/X + B coefficents 
C  MAXHSP   I    maximum no. of mygs for the high speed HC and CO scf A/X + B 
C                coefs 
C 
C  /SPEED6/: 
C 
C  SALHCF   R    speed and optional correction factors to apply to basic 
C                emission factors. Speed correction is not applied to 
C                starts. 
C  SCFIDL   R    idle speed adjustment calculated at 2.5 mph and optional 
C                correction factors 
C  IDLYES   L    indicates to speed subroutines to use 2.5 mph 
C 
C  /SPEED7/: 
C 
C  GPBSCO   R    2nd degree polynomial IVB scf coefficients, unchanged since 
C                MOBILE2.  (MOBILE2 reduced HDGV cases from 3 to 1 myg) 
C 
C  /SPEED8/ 
C 
C  SIXT5    R    Correction factor at 65 mph MOBILE5 
C 
C  Local array subscripts: 
C 
C  ISPDY1(18,2) - ISPDY1( IG, IR ) 
C  ISPDY2(18,2) - ISPDY2( IG, IR ) 
C  ISPDY3(18,2) - ISPDY3( IG, IR ) 
C  ISPDY4(18,2) - ISPDY3( IG, IR ) 
C  ISPDY5(18,2) - ISPDY3( IG, IR ) 
C 
C  Local array dictionary: 
C 
C   Name   Type              Description 
C  ------  ----  ----------------------------------------------- 
C  ISPDY1   I    the last year of LDGV scf model year group 
C  ISPDY2   I    the last year of LDGT1 scf model year group 
C  ISPDY3   I    the last year of LDGT2 scf model year group 
C  ISPDY4   I    the last year of LDGT3 scf model year group 
C  ISPDY5   I    the last year of LDGT4 scf model year group 
C 
C  Notes: 
C 
C  The /SPEEDx/ CBs consolidate all speed cf related variables and arrays. 
C 
C  Variables whose values are assigned during the course of execution are 
C  initialized here to dummy zeroes or ones. 
C 
C  5 Nov 96 DynTel@MLA 2-622  Changed the last dimension of GPBSCO from 4 
C           to 18 to account for 7 new HDG and 7 new HDD vehicle types, and 
C           the last dimensions of MAXHSP, MYGSP1, MYGSP2, LB1STS, and SIXT5 
C           from 3 to 5, and the last dimension of MYHSPC from 6 to 10 
C           to accomodate the 2 new LDGT types (LDGT1A and LDGT1B replace 
C           LDGT1, and LDGT2A and LDGT2B replace LDGT2). Changed the last 
C           dimension of SCUNA1 and SALHCF from 8 to 24. These arrays 
C           include all of the new vehicle types. 
C 
C  2 Apr 97 DynTel@MLA 2-622  Expanded arrays GPBSCO, SALHCF, and SCUNA1 
C           to accomodate the new BUS vehicle categories. 
C 
C 21 Apr 98 @DynTel-RJD 2-654 Added an additional dimension to SALHCF to 
C           distinguish between start and running emissions. 
C 23 Jul 98 @DynTel-MLA 2-000  Changed LDGT names to conform to 
C           certification naming conventions. 
C 
      IMPLICIT NONE 
      INCLUDE 'PARAME.I' 
      INCLUDE 'SPEED0.I'      ! USRSPD,USRVMT,USRFAC,DEFAVG,AVGFLG 
      INCLUDE 'SPEED2.I' 
      INCLUDE 'SPEED3.I' 
      INCLUDE 'SPEED4.I' 
      INCLUDE 'SPEED5.I' 
      INCLUDE 'SPEED6.I' 
      INCLUDE 'SPEED7.I' 
      INCLUDE 'SPEED8.I' 
C 
      INTEGER ISPDY1(18,2),ISPDY2(18,2),ISPDY3(18,2), 
     &      ISPDY4(18,2),ISPDY5(18,2) 
C 
      EQUIVALENCE 
     *(MYGSP1(1,1,1),ISPDY1(1,1)), 
     *(MYGSP1(1,1,2),ISPDY2(1,1)), 
     *(MYGSP1(1,1,3),ISPDY3(1,1)), 
     *(MYGSP1(1,1,4),ISPDY4(1,1)), 
     *(MYGSP1(1,1,5),ISPDY5(1,1)) 
C 
C  /SPEED2/: 
C 
C  Myg upper bounds for 5th degree polynomial scf equation form coefficients. 
C 
      DATA ISPDY1/ 
C  Low 
     *   0000,1967,0000,1968,1969,1970,1971,0000,0000,0000, 
     *   0000,0000,0000,1972,0000,0000,1974,1976, 
C  High 
     *   1967,0000,0000,0000,0000,0000,0000,1968,1969,1970, 
     *   1971,1972,0000,0000,1974,0000,0000,1976/ 
C 
      DATA ISPDY2/ 
C  Low 
     *   0000,1967,0000,1968,1969,1970,1971,0000,0000,0000, 
     *   0000,0000,0000,1972,0000,0000,1974,1978, 
C  High 
     *   1967,0000,0000,0000,0000,0000,0000,1968,1969,1970, 
     *   1971,1972,0000,0000,1974,0000,0000,1978/ 
C 
      DATA ISPDY3/ 
C  Low 
     *   0000,1967,0000,1968,1969,1970,1971,0000,0000,0000, 
     *   0000,0000,0000,1972,0000,0000,1974,1978, 
C  High 
     *   1967,0000,0000,0000,0000,0000,0000,1968,1969,1970, 
     *   1971,1972,0000,0000,1974,0000,0000,1978/ 
C 
      DATA ISPDY4/ 
C  Low 
     *   0000,1969,0000,0000,1973,0000,0000,0000,0000,0000, 
     *   0000,0000,0000,0000,0000,0000,1978,0000, 
C  High 
     *   1969,0000,0000,0000,0000,0000,0000,0000,0000,0000, 
     *   0000,1973,0000,0000,1978,0000,0000,0000/ 
C 
      DATA ISPDY5/ 
C  Low 
     *   0000,1969,0000,0000,1973,0000,0000,0000,0000,0000, 
     *   0000,0000,0000,0000,0000,0000,1978,0000, 
C  High 
     *   1969,0000,0000,0000,0000,0000,0000,0000,0000,0000, 
     *   0000,1973,0000,0000,1978,0000,0000,0000/ 
C 
      DATA MYGSMC/ 
C  HC 
C  Low 
     L   0000,1977,0000,0000,1979,0000,NEYR,0000,0000,0000, 
     L   0000,0000,0000,0000,0000,0000,0000,0000, 
C  High 
     H   1977,0000,0000,0000,0000,0000,0000,0000,1979,0000, 
     H   NEYR,0000,0000,0000,0000,0000,0000,0000, 
C  CO 
C  Low 
     L   0000,1977,0000,0000,1979,0000,NEYR,0000,0000,0000, 
     L   0000,0000,0000,0000,0000,0000,0000,0000, 
C  High 
     H   1977,0000,0000,0000,0000,0000,0000,0000,1979,0000, 
     H   NEYR,0000,0000,0000,0000,0000,0000,0000, 
C  NOX 
C  Low 
     L   0000,1977,0000,0000,0000,0000,0000,0000,0000,0000, 
     L   0000,0000,0000,NEYR,0000,0000,0000,0000, 
C  High 
     H   1977,0000,0000,0000,0000,0000,0000,0000,0000,0000, 
     H   0000,NEYR,0000,0000,0000,0000,0000,0000/ 
C 
C  Myg upper bounds for the A/X+B & A+B*X+C*X**2 scf equation coefficients. 
C 
C                  HC    CO   NOX 
      DATA MYGSP2/ 
     1            1979, 1979, 1979, 
     2            1980, 1980, 1980, 
     3            1980, 1980, 1980, 
     4            1980, 1980, 1980, 
     5            1980, 1980, 1980/ 
C 
C  /SPEED3/: 
C 
C  All dummy zeroes. 
C 
      DATA SADJ/19.6/,SCUNA1/1512*0./ 
C 
C  /SPEED4/: 
C 
C  "True" scf parameters. 
C 
      DATA MAXSP1/18/,LB1STS/1977,4*1979/,LBLAST/1992/ 
C 
C  Dummy zeroes. 
C 
      DATA IVB,IVA/2*0/ 
C 
C  /SPEED5/: 
C 
C  MYGs for the high speed HC and CO scf coefficients for the new A/X + B 
C  equation. Originally had 6,3,3 myg, now have 1 myg each; This may change 
C  again. 
C 
      DATA MYHSPC/ 1977,1977,1979,1979,1979,1979,1979,1979,1979,1979/ 
      DATA MAXHSP/    1,        1,        1,        1,        1/ 
C 
C  /SPEED6/: 
C 
C  All dummy ones (instead of zeroes, since SALHCF is a multiplicative cf). 
C  For BYMY Version, revert to zeroes to allow output to differentiate 
C  between an uncalculated CF (due to TF=0.0) and a neutral CF (FTP 
C  conditions for speed and no "optional" ALUH CFs). 
C 
      DATA SALHCF/4200*0.0/ 
      DATA SCFIDL/1.0/ 
      DATA IDLYES/.FALSE./ 
C 
C  /SPEED7/: 
C 
C  The continuation line code for GPBSCO is the old IV number (4=HDGV, 
C  5=LDDV, 6=LDDT12 and LDDT34, 7=HDDV). New continuation code is B 
C  for BUS. 
C 
      DATA GPBSCO/ 
C               HC                    CO                  NOX 
C       -------------------  --------------------  ------------------ 
     4  1.608,-.097,.00083,  1.5200,-.098,.00110,  .824,.0088,.0, 
     4  1.608,-.097,.00083,  1.5200,-.098,.00110,  .824,.0088,.0, 
     4  1.608,-.097,.00083,  1.5200,-.098,.00110,  .824,.0088,.0, 
     4  1.608,-.097,.00083,  1.5200,-.098,.00110,  .824,.0088,.0, 
     4  1.608,-.097,.00083,  1.5200,-.098,.00110,  .824,.0088,.0, 
     4  1.608,-.097,.00083,  1.5200,-.098,.00110,  .824,.0088,.0, 
     4  1.608,-.097,.00083,  1.5200,-.098,.00110,  .824,.0088,.0, 
     4  1.608,-.097,.00083,  1.5200,-.098,.00110,  .824,.0088,.0, 
     5   .909,-.055,.00044,  1.3752,-.088,.00091,  .668,-.048,.00071, 
     6   .909,-.055,.00044,  1.3752,-.088,.00091,  .668,-.048,.00071, 
     7   .924,-.055,.00044,  1.3960,-.088,.00091,  .676,-.048,.00071, 
     7   .924,-.055,.00044,  1.3960,-.088,.00091,  .676,-.048,.00071, 
     7   .924,-.055,.00044,  1.3960,-.088,.00091,  .676,-.048,.00071, 
     7   .924,-.055,.00044,  1.3960,-.088,.00091,  .676,-.048,.00071, 
     7   .924,-.055,.00044,  1.3960,-.088,.00091,  .676,-.048,.00071, 
     7   .924,-.055,.00044,  1.3960,-.088,.00091,  .676,-.048,.00071, 
     7   .924,-.055,.00044,  1.3960,-.088,.00091,  .676,-.048,.00071, 
     7   .924,-.055,.00044,  1.3960,-.088,.00091,  .676,-.048,.00071, 
     B  1.608,-.097,.00083,  1.5200,-.098,.00110,  .824,.0088,.0, 
     B   .924,-.055,.00044,  1.3960,-.088,.00091,  .676,-.048,.00071, 
     B   .924,-.055,.00044,  1.3960,-.088,.00091,  .676,-.048,.00071, 
     6   .909,-.055,.00044,  1.3752,-.088,.00091,  .668,-.048,.00071/ 
C 
C  /SPEED8/: 
C 
C  Continuation code is IP 
C 
      DATA SIXT5/ 
C  LDGV 
     1  1.27,1.23,1.16,1.08,1.03,0.94,0.89,0.80,0.84,0.79,0.79, 
     2  2.80,2.66,2.44,2.19,2.01,1.73,1.57,1.29,1.39,1.23,1.21, 
     3  1.95,1.92,1.91,1.89,1.80,1.75,1.75,1.68,1.65,1.58,1.57, 
C  LDGT1 
     1  1.32,1.32,1.32,1.31,1.26,1.11,0.97,0.81,0.80,0.77,0.76, 
     2  2.96,2.96,2.96,2.93,2.75,2.28,1.83,1.34,1.29,1.19,1.15, 
     3  1.98,1.98,1.98,1.97,1.94,1.85,1.78,1.72,1.67,1.64,1.64, 
C  LDGT2 
     1  1.32,1.32,1.32,1.31,1.26,1.11,0.97,0.81,0.80,0.77,0.76, 
     2  2.96,2.96,2.96,2.93,2.75,2.28,1.83,1.34,1.29,1.19,1.15, 
     3  1.98,1.98,1.98,1.97,1.94,1.85,1.78,1.72,1.67,1.64,1.64, 
C  LDGT3 
     1  1.32,1.32,1.32,1.31,1.26,1.11,0.97,0.81,0.80,0.77,0.76, 
     2  2.96,2.96,2.96,2.93,2.75,2.28,1.83,1.34,1.29,1.19,1.15, 
     3  1.98,1.98,1.98,1.97,1.94,1.85,1.78,1.72,1.67,1.64,1.64, 
C  LDGT4 
     1  1.32,1.32,1.32,1.31,1.26,1.11,0.97,0.81,0.80,0.77,0.76, 
     2  2.96,2.96,2.96,2.93,2.75,2.28,1.83,1.34,1.29,1.19,1.15, 
     3  1.98,1.98,1.98,1.97,1.94,1.85,1.78,1.72,1.67,1.64,1.64/ 
C 
      DATA USRSPD / 27.6 / 
      DATA USRVMT / 0.342, 0.498, 0.130, 0.030 / 
      DATA USRFAC / 1 / 
      DATA DEFAVG /  36.5,  31.2,  12.9,  34.6 / 
      DATA AVGFLG / 0 / 
C 
      END 
