      BLOCK DATA BDSPEED2
C
C
C  BLOCK DATA BDSPEED initializes the speed correction data.
C 
C  Changes : (Last Change First)
C
C   26 Jun 02 @AIR-DK   Changed "SPEED9.i" to all caps, i.e., "SPEED9.I"
C   04 Jun 01 @EPA-djb  Bug324, Changed values for CO and NOx in array
C                       LOCAL and added comments.
C   13 Feb 00 @EPA-elg  Modified FVMT and GLFVMT for additional IV array dimension.
C                       Created new FVMTx equivalence arrays.
C   22 Nov 00 @EPA-bag bug301 added GHVMT, GFVMT to enable scenario and run level
C           user input
C   18 Sep 00 @EPA-djb Bug35, Changed SVMT2 to match worksheet (arterial
C             distribution now sums to one).
C   15 Jun 00 @EPA-bag bug147 The default value for AVSPR in BDSPEED2 (block data)
C             is 34.9 mph.  The correct value is 34.6 mph (See M6.SPD.002 Table 1). 
C   02 May 00 @EPA-ddj Bug51, Changed NOx quadratic constants for Local
C             speed corrections.
C   21 Apr 00 @EPA-BAG    SVMT, FVMT, and HVMT arrays were reindexed to map
C             IH=1 to the 6a.m.-7a.m. hourly interval
C   10 Feb 00 @DynTel-ddj 1-013, Added IMPLICIT NONE.
C   24 Aug 99 @DynTel-dj 2-698 Fixed typo in hour 5 SVMT
C
C
C     common blocks:
C     /SPEED9/ TVMT, HVMT, FVMT, SVMT, LOCAL, RAMP,
C              OCECO, OCY, OCX, LEVEL, EMSFC,
c              GLHVMT, GLFVMT, GLSVMT
C
C
      IMPLICIT NONE
C
      INCLUDE 'SPEED9.I'
      REAL
     *  SVMT1(2,14),  SVMT2(2,14),  SVMT3(2,14),  SVMT4(2,14),
     *  SVMT5(2,14),  SVMT6(2,14),  SVMT7(2,14),  SVMT8(2,14),
     *  SVMT9(2,14), SVMT10(2,14), SVMT11(2,14), SVMT12(2,14),
     * SVMT13(2,14), SVMT14(2,14), SVMT15(2,14), SVMT16(2,14),
     * SVMT17(2,14), SVMT18(2,14), SVMT19(2,14), SVMT20(2,14),
     * SVMT21(2,14), SVMT22(2,14), SVMT23(2,14), SVMT24(2,14)
C
      EQUIVALENCE
     *  (SVMT(1,  1, 1), SVMT1(1,1)), (SVMT(1, 1, 2), SVMT2(1,1)),
     *  (SVMT(1,  1, 3), SVMT3(1,1)), (SVMT(1, 1, 4), SVMT4(1,1)),
     *  (SVMT(1,  1, 5), SVMT5(1,1)), (SVMT(1, 1, 6), SVMT6(1,1)),
     *  (SVMT(1,  1, 7), SVMT7(1,1)), (SVMT(1, 1, 8), SVMT8(1,1)),
     *  (SVMT(1,  1, 9), SVMT9(1,1)),(SVMT(1, 1, 10),SVMT10(1,1)),
     *  (SVMT(1, 1, 11),SVMT11(1,1)),(SVMT(1, 1, 12),SVMT12(1,1)),
     *  (SVMT(1, 1, 13),SVMT13(1,1)),(SVMT(1, 1, 14),SVMT14(1,1)),
     *  (SVMT(1, 1, 15),SVMT15(1,1)),(SVMT(1, 1, 16),SVMT16(1,1)),
     *  (SVMT(1, 1, 17),SVMT17(1,1)),(SVMT(1, 1, 18),SVMT18(1,1)),
     *  (SVMT(1, 1, 19),SVMT19(1,1)),(SVMT(1, 1, 20),SVMT20(1,1)),
     *  (SVMT(1, 1, 21),SVMT21(1,1)),(SVMT(1, 1, 22),SVMT22(1,1)),
     *  (SVMT(1, 1, 23),SVMT23(1,1)),(SVMT(1, 1, 24),SVMT24(1,1))
C
      REAL
     *  FVMT1(4,24),  FVMT2(4,24),  FVMT3(4,24),  FVMT4(4,24),
     *  FVMT5(4,24),  FVMT6(4,24),  FVMT7(4,24),  FVMT8(4,24),
     *  FVMT9(4,24), FVMT10(4,24), FVMT11(4,24), FVMT12(4,24),
     * FVMT13(4,24), FVMT14(4,24), FVMT15(4,24), FVMT16(4,24),
     * FVMT17(4,24), FVMT18(4,24), FVMT19(4,24), FVMT20(4,24),
     * FVMT21(4,24), FVMT22(4,24), FVMT23(4,24), FVMT24(4,24),
     * FVMT25(4,24), FVMT26(4,24), FVMT27(4,24), FVMT28(4,24)
C
      EQUIVALENCE
     *  (FVMT(1,  1, 1), FVMT1(1,1)), (FVMT(1, 1, 2), FVMT2(1,1)),
     *  (FVMT(1,  1, 3), FVMT3(1,1)), (FVMT(1, 1, 4), FVMT4(1,1)),
     *  (FVMT(1,  1, 5), FVMT5(1,1)), (FVMT(1, 1, 6), FVMT6(1,1)),
     *  (FVMT(1,  1, 7), FVMT7(1,1)), (FVMT(1, 1, 8), FVMT8(1,1)),
     *  (FVMT(1,  1, 9), FVMT9(1,1)),(FVMT(1, 1, 10),FVMT10(1,1)),
     *  (FVMT(1, 1, 11),FVMT11(1,1)),(FVMT(1, 1, 12),FVMT12(1,1)),
     *  (FVMT(1, 1, 13),FVMT13(1,1)),(FVMT(1, 1, 14),FVMT14(1,1)),
     *  (FVMT(1, 1, 15),FVMT15(1,1)),(FVMT(1, 1, 16),FVMT16(1,1)),
     *  (FVMT(1, 1, 17),FVMT17(1,1)),(FVMT(1, 1, 18),FVMT18(1,1)),
     *  (FVMT(1, 1, 19),FVMT19(1,1)),(FVMT(1, 1, 20),FVMT20(1,1)),
     *  (FVMT(1, 1, 21),FVMT21(1,1)),(FVMT(1, 1, 22),FVMT22(1,1)),
     *  (FVMT(1, 1, 23),FVMT23(1,1)),(FVMT(1, 1, 24),FVMT24(1,1)),
     *  (FVMT(1, 1, 25),FVMT25(1,1)),(FVMT(1, 1, 26),FVMT26(1,1)),
     *  (FVMT(1, 1, 27),FVMT27(1,1)),(FVMT(1, 1, 28),FVMT28(1,1))
C
      DATA AVSPR,AVSPL/ 34.6, 12.9/
C
C    Average bin speeds for freeways and collectors.
C
      DATA AVESPD/
     1  2.5,  5.0, 10.0, 15.0, 20.0, 25.0, 30.0,
     1 35.0, 40.0, 45.0, 50.0, 55.0, 60.0, 65.0,
     2  2.5,  5.0, 10.0, 15.0, 20.0, 25.0, 30.0,
     2 35.0, 40.0, 45.0, 50.0, 55.0, 60.0, 65.0/
C
       DATA TVMT/
     1 0.342, 0.498, 0.130, 0.030/
C
C
        DATA HVMT/
C  IH =  1       2       3       4       5       6
     2 0.0569, 0.0740, 0.0656, 0.0555, 0.0540, 0.0582,
C  IH =  7       8       9      10      11      12
     3 0.0608, 0.0571, 0.0598, 0.0636, 0.0777, 0.0730,
C  IH = 13      14      15      16      17      18
     4 0.0501, 0.0389, 0.0308, 0.0264, 0.0194, 0.0144,
C  IH = 19      20      21      22      23      24
     1 0.0108, 0.0086, 0.0081, 0.0080, 0.0098, 0.0186/
C
C   VMT Distribution for facility type and vehicle type.
C
        DATA FVMT1/
C
C  LDGV  CLASS 1
C  24 Hour  Freeways  Arterials & Collectors Locals Ramps
C
C      Fways   A/C   Local  Ramp   Fways   A/C   Local  Ramp
C             ih =  1            |      ih =  2
     1 0.392, 0.457, 0.117, 0.034, 0.344, 0.497, 0.129, 0.030,
C             ih =  3            |      ih =  4
     1 0.338, 0.497, 0.135, 0.029, 0.349, 0.492, 0.129, 0.030,
C             ih =  5            |      ih =  6
     1 0.346, 0.497, 0.127, 0.030, 0.333, 0.509, 0.129, 0.029,
C             ih =  7            |      ih =  8
     1 0.324, 0.516, 0.132, 0.028, 0.334, 0.506, 0.131, 0.029,
C             ih =  9            |      ih = 10
     1 0.334, 0.506, 0.131, 0.029, 0.320, 0.519, 0.134, 0.028,
C             ih = 11            |      ih = 12
     1 0.330, 0.506, 0.135, 0.029, 0.312, 0.521, 0.140, 0.027,
C             ih = 13            |      ih = 14
     1 0.295, 0.538, 0.141, 0.026, 0.310, 0.527, 0.137, 0.027,
C             ih = 15            |      ih = 16
     1 0.329, 0.510, 0.133, 0.029, 0.343, 0.497, 0.131, 0.030,
C             ih = 17            |      ih = 18
     1 0.381, 0.460, 0.126, 0.033, 0.405, 0.437, 0.123, 0.035,
C             ih = 19            |      ih = 20
     1 0.426, 0.418, 0.118, 0.037, 0.443, 0.403, 0.115, 0.039,
C             ih = 21            |      ih = 22
     1 0.457, 0.394, 0.110, 0.040, 0.461, 0.391, 0.107, 0.040,
C             ih = 23            |      ih = 24
     1 0.453, 0.400, 0.108, 0.039, 0.418, 0.434, 0.112, 0.036/
C
        DATA FVMT2/
C
C  LDGT1  CLASS 2
C  24 Hour  Freeways  Arterials & Collectors Locals Ramps
C
C      Fways   A/C   Local  Ramp   Fways   A/C   Local  Ramp
C             ih =  1            |      ih =  2
     1 0.392, 0.457, 0.117, 0.034, 0.344, 0.497, 0.129, 0.030,
C             ih =  3            |      ih =  4
     1 0.338, 0.497, 0.135, 0.029, 0.349, 0.492, 0.129, 0.030,
C             ih =  5            |      ih =  6
     1 0.346, 0.497, 0.127, 0.030, 0.333, 0.509, 0.129, 0.029,
C             ih =  7            |      ih =  8
     1 0.324, 0.516, 0.132, 0.028, 0.334, 0.506, 0.131, 0.029,
C             ih =  9            |      ih = 10
     1 0.334, 0.506, 0.131, 0.029, 0.320, 0.519, 0.134, 0.028,
C             ih = 11            |      ih = 12
     1 0.330, 0.506, 0.135, 0.029, 0.312, 0.521, 0.140, 0.027,
C             ih = 13            |      ih = 14
     1 0.295, 0.538, 0.141, 0.026, 0.310, 0.527, 0.137, 0.027,
C             ih = 15            |      ih = 16
     1 0.329, 0.510, 0.133, 0.029, 0.343, 0.497, 0.131, 0.030,
C             ih = 17            |      ih = 18
     1 0.381, 0.460, 0.126, 0.033, 0.405, 0.437, 0.123, 0.035,
C             ih = 19            |      ih = 20
     1 0.426, 0.418, 0.118, 0.037, 0.443, 0.403, 0.115, 0.039,
C             ih = 21            |      ih = 22
     1 0.457, 0.394, 0.110, 0.040, 0.461, 0.391, 0.107, 0.040,
C             ih = 23            |      ih = 24
     1 0.453, 0.400, 0.108, 0.039, 0.418, 0.434, 0.112, 0.036/
C
        DATA FVMT3/
C
C  LDGT2  CLASS 3
C  24 Hour  Freeways  Arterials & Collectors Locals Ramps
C
C      Fways   A/C   Local  Ramp   Fways   A/C   Local  Ramp
C             ih =  1            |      ih =  2
     1 0.392, 0.457, 0.117, 0.034, 0.344, 0.497, 0.129, 0.030,
C             ih =  3            |      ih =  4
     1 0.338, 0.497, 0.135, 0.029, 0.349, 0.492, 0.129, 0.030,
C             ih =  5            |      ih =  6
     1 0.346, 0.497, 0.127, 0.030, 0.333, 0.509, 0.129, 0.029,
C             ih =  7            |      ih =  8
     1 0.324, 0.516, 0.132, 0.028, 0.334, 0.506, 0.131, 0.029,
C             ih =  9            |      ih = 10
     1 0.334, 0.506, 0.131, 0.029, 0.320, 0.519, 0.134, 0.028,
C             ih = 11            |      ih = 12
     1 0.330, 0.506, 0.135, 0.029, 0.312, 0.521, 0.140, 0.027,
C             ih = 13            |      ih = 14
     1 0.295, 0.538, 0.141, 0.026, 0.310, 0.527, 0.137, 0.027,
C             ih = 15            |      ih = 16
     1 0.329, 0.510, 0.133, 0.029, 0.343, 0.497, 0.131, 0.030,
C             ih = 17            |      ih = 18
     1 0.381, 0.460, 0.126, 0.033, 0.405, 0.437, 0.123, 0.035,
C             ih = 19            |      ih = 20
     1 0.426, 0.418, 0.118, 0.037, 0.443, 0.403, 0.115, 0.039,
C             ih = 21            |      ih = 22
     1 0.457, 0.394, 0.110, 0.040, 0.461, 0.391, 0.107, 0.040,
C             ih = 23            |      ih = 24
     1 0.453, 0.400, 0.108, 0.039, 0.418, 0.434, 0.112, 0.036/
C
        DATA FVMT4/
C
C  LDGT3  CLASS 4
C  24 Hour  Freeways  Arterials & Collectors Locals Ramps
C
C      Fways   A/C   Local  Ramp   Fways   A/C   Local  Ramp
C             ih =  1            |      ih =  2
     1 0.392, 0.457, 0.117, 0.034, 0.344, 0.497, 0.129, 0.030,
C             ih =  3            |      ih =  4
     1 0.338, 0.497, 0.135, 0.029, 0.349, 0.492, 0.129, 0.030,
C             ih =  5            |      ih =  6
     1 0.346, 0.497, 0.127, 0.030, 0.333, 0.509, 0.129, 0.029,
C             ih =  7            |      ih =  8
     1 0.324, 0.516, 0.132, 0.028, 0.334, 0.506, 0.131, 0.029,
C             ih =  9            |      ih = 10
     1 0.334, 0.506, 0.131, 0.029, 0.320, 0.519, 0.134, 0.028,
C             ih = 11            |      ih = 12
     1 0.330, 0.506, 0.135, 0.029, 0.312, 0.521, 0.140, 0.027,
C             ih = 13            |      ih = 14
     1 0.295, 0.538, 0.141, 0.026, 0.310, 0.527, 0.137, 0.027,
C             ih = 15            |      ih = 16
     1 0.329, 0.510, 0.133, 0.029, 0.343, 0.497, 0.131, 0.030,
C             ih = 17            |      ih = 18
     1 0.381, 0.460, 0.126, 0.033, 0.405, 0.437, 0.123, 0.035,
C             ih = 19            |      ih = 20
     1 0.426, 0.418, 0.118, 0.037, 0.443, 0.403, 0.115, 0.039,
C             ih = 21            |      ih = 22
     1 0.457, 0.394, 0.110, 0.040, 0.461, 0.391, 0.107, 0.040,
C             ih = 23            |      ih = 24
     1 0.453, 0.400, 0.108, 0.039, 0.418, 0.434, 0.112, 0.036/
C
        DATA FVMT5/
C
C  LDGT4  CLASS 5
C  24 Hour  Freeways  Arterials & Collectors Locals Ramps
C
C      Fways   A/C   Local  Ramp   Fways   A/C   Local  Ramp
C             ih =  1            |      ih =  2
     1 0.392, 0.457, 0.117, 0.034, 0.344, 0.497, 0.129, 0.030,
C             ih =  3            |      ih =  4
     1 0.338, 0.497, 0.135, 0.029, 0.349, 0.492, 0.129, 0.030,
C             ih =  5            |      ih =  6
     1 0.346, 0.497, 0.127, 0.030, 0.333, 0.509, 0.129, 0.029,
C             ih =  7            |      ih =  8
     1 0.324, 0.516, 0.132, 0.028, 0.334, 0.506, 0.131, 0.029,
C             ih =  9            |      ih = 10
     1 0.334, 0.506, 0.131, 0.029, 0.320, 0.519, 0.134, 0.028,
C             ih = 11            |      ih = 12
     1 0.330, 0.506, 0.135, 0.029, 0.312, 0.521, 0.140, 0.027,
C             ih = 13            |      ih = 14
     1 0.295, 0.538, 0.141, 0.026, 0.310, 0.527, 0.137, 0.027,
C             ih = 15            |      ih = 16
     1 0.329, 0.510, 0.133, 0.029, 0.343, 0.497, 0.131, 0.030,
C             ih = 17            |      ih = 18
     1 0.381, 0.460, 0.126, 0.033, 0.405, 0.437, 0.123, 0.035,
C             ih = 19            |      ih = 20
     1 0.426, 0.418, 0.118, 0.037, 0.443, 0.403, 0.115, 0.039,
C             ih = 21            |      ih = 22
     1 0.457, 0.394, 0.110, 0.040, 0.461, 0.391, 0.107, 0.040,
C             ih = 23            |      ih = 24
     1 0.453, 0.400, 0.108, 0.039, 0.418, 0.434, 0.112, 0.036/
C
        DATA FVMT6/
C
C  2B HEAVYD-DUTY GAS    CLASS 6
C  24 Hour  Freeways  Arterials & Collectors Locals Ramps
C
C      Fways   A/C   Local  Ramp   Fways   A/C   Local  Ramp
C             ih =  1            |      ih =  2
     1 0.392, 0.457, 0.117, 0.034, 0.344, 0.497, 0.129, 0.030,
C             ih =  3            |      ih =  4
     1 0.338, 0.497, 0.135, 0.029, 0.349, 0.492, 0.129, 0.030,
C             ih =  5            |      ih =  6
     1 0.346, 0.497, 0.127, 0.030, 0.333, 0.509, 0.129, 0.029,
C             ih =  7            |      ih =  8
     1 0.324, 0.516, 0.132, 0.028, 0.334, 0.506, 0.131, 0.029,
C             ih =  9            |      ih = 10
     1 0.334, 0.506, 0.131, 0.029, 0.320, 0.519, 0.134, 0.028,
C             ih = 11            |      ih = 12
     1 0.330, 0.506, 0.135, 0.029, 0.312, 0.521, 0.140, 0.027,
C             ih = 13            |      ih = 14
     1 0.295, 0.538, 0.141, 0.026, 0.310, 0.527, 0.137, 0.027,
C             ih = 15            |      ih = 16
     1 0.329, 0.510, 0.133, 0.029, 0.343, 0.497, 0.131, 0.030,
C             ih = 17            |      ih = 18
     1 0.381, 0.460, 0.126, 0.033, 0.405, 0.437, 0.123, 0.035,
C             ih = 19            |      ih = 20
     1 0.426, 0.418, 0.118, 0.037, 0.443, 0.403, 0.115, 0.039,
C             ih = 21            |      ih = 22
     1 0.457, 0.394, 0.110, 0.040, 0.461, 0.391, 0.107, 0.040,
C             ih = 23            |      ih = 24
     1 0.453, 0.400, 0.108, 0.039, 0.418, 0.434, 0.112, 0.036/
C
        DATA FVMT7/
C
C  3 HEAVY-DUTY GAS    CLASS 7
C  24 Hour  Freeways  Arterials & Collectors Locals Ramps
C
C      Fways   A/C   Local  Ramp   Fways   A/C   Local  Ramp
C             ih =  1            |      ih =  2
     1 0.392, 0.457, 0.117, 0.034, 0.344, 0.497, 0.129, 0.030,
C             ih =  3            |      ih =  4
     1 0.338, 0.497, 0.135, 0.029, 0.349, 0.492, 0.129, 0.030,
C             ih =  5            |      ih =  6
     1 0.346, 0.497, 0.127, 0.030, 0.333, 0.509, 0.129, 0.029,
C             ih =  7            |      ih =  8
     1 0.324, 0.516, 0.132, 0.028, 0.334, 0.506, 0.131, 0.029,
C             ih =  9            |      ih = 10
     1 0.334, 0.506, 0.131, 0.029, 0.320, 0.519, 0.134, 0.028,
C             ih = 11            |      ih = 12
     1 0.330, 0.506, 0.135, 0.029, 0.312, 0.521, 0.140, 0.027,
C             ih = 13            |      ih = 14
     1 0.295, 0.538, 0.141, 0.026, 0.310, 0.527, 0.137, 0.027,
C             ih = 15            |      ih = 16
     1 0.329, 0.510, 0.133, 0.029, 0.343, 0.497, 0.131, 0.030,
C             ih = 17            |      ih = 18
     1 0.381, 0.460, 0.126, 0.033, 0.405, 0.437, 0.123, 0.035,
C             ih = 19            |      ih = 20
     1 0.426, 0.418, 0.118, 0.037, 0.443, 0.403, 0.115, 0.039,
C             ih = 21            |      ih = 22
     1 0.457, 0.394, 0.110, 0.040, 0.461, 0.391, 0.107, 0.040,
C             ih = 23            |      ih = 24
     1 0.453, 0.400, 0.108, 0.039, 0.418, 0.434, 0.112, 0.036/
C
        DATA FVMT8/
C
C  4 HEAVY-DUTY GAS    CLASS 8
C  24 Hour  Freeways  Arterials & Collectors Locals Ramps
C
C      Fways   A/C   Local  Ramp   Fways   A/C   Local  Ramp
C             ih =  1            |      ih =  2
     1 0.392, 0.457, 0.117, 0.034, 0.344, 0.497, 0.129, 0.030,
C             ih =  3            |      ih =  4
     1 0.338, 0.497, 0.135, 0.029, 0.349, 0.492, 0.129, 0.030,
C             ih =  5            |      ih =  6
     1 0.346, 0.497, 0.127, 0.030, 0.333, 0.509, 0.129, 0.029,
C             ih =  7            |      ih =  8
     1 0.324, 0.516, 0.132, 0.028, 0.334, 0.506, 0.131, 0.029,
C             ih =  9            |      ih = 10
     1 0.334, 0.506, 0.131, 0.029, 0.320, 0.519, 0.134, 0.028,
C             ih = 11            |      ih = 12
     1 0.330, 0.506, 0.135, 0.029, 0.312, 0.521, 0.140, 0.027,
C             ih = 13            |      ih = 14
     1 0.295, 0.538, 0.141, 0.026, 0.310, 0.527, 0.137, 0.027,
C             ih = 15            |      ih = 16
     1 0.329, 0.510, 0.133, 0.029, 0.343, 0.497, 0.131, 0.030,
C             ih = 17            |      ih = 18
     1 0.381, 0.460, 0.126, 0.033, 0.405, 0.437, 0.123, 0.035,
C             ih = 19            |      ih = 20
     1 0.426, 0.418, 0.118, 0.037, 0.443, 0.403, 0.115, 0.039,
C             ih = 21            |      ih = 22
     1 0.457, 0.394, 0.110, 0.040, 0.461, 0.391, 0.107, 0.040,
C             ih = 23            |      ih = 24
     1 0.453, 0.400, 0.108, 0.039, 0.418, 0.434, 0.112, 0.036/
C
        DATA FVMT9/
C
C  5 HEAVY-DUTY GAS    CLASS 9
C  24 Hour  Freeways  Arterials & Collectors Locals Ramps
C
C      Fways   A/C   Local  Ramp   Fways   A/C   Local  Ramp
C             ih =  1            |      ih =  2
     1 0.392, 0.457, 0.117, 0.034, 0.344, 0.497, 0.129, 0.030,
C             ih =  3            |      ih =  4
     1 0.338, 0.497, 0.135, 0.029, 0.349, 0.492, 0.129, 0.030,
C             ih =  5            |      ih =  6
     1 0.346, 0.497, 0.127, 0.030, 0.333, 0.509, 0.129, 0.029,
C             ih =  7            |      ih =  8
     1 0.324, 0.516, 0.132, 0.028, 0.334, 0.506, 0.131, 0.029,
C             ih =  9            |      ih = 10
     1 0.334, 0.506, 0.131, 0.029, 0.320, 0.519, 0.134, 0.028,
C             ih = 11            |      ih = 12
     1 0.330, 0.506, 0.135, 0.029, 0.312, 0.521, 0.140, 0.027,
C             ih = 13            |      ih = 14
     1 0.295, 0.538, 0.141, 0.026, 0.310, 0.527, 0.137, 0.027,
C             ih = 15            |      ih = 16
     1 0.329, 0.510, 0.133, 0.029, 0.343, 0.497, 0.131, 0.030,
C             ih = 17            |      ih = 18
     1 0.381, 0.460, 0.126, 0.033, 0.405, 0.437, 0.123, 0.035,
C             ih = 19            |      ih = 20
     1 0.426, 0.418, 0.118, 0.037, 0.443, 0.403, 0.115, 0.039,
C             ih = 21            |      ih = 22
     1 0.457, 0.394, 0.110, 0.040, 0.461, 0.391, 0.107, 0.040,
C             ih = 23            |      ih = 24
     1 0.453, 0.400, 0.108, 0.039, 0.418, 0.434, 0.112, 0.036/
C
        DATA FVMT10/
C
C  6 HEAVY-DUTY GAS    CLASS 10
C  24 Hour  Freeways  Arterials & Collectors Locals Ramps
C
C      Fways   A/C   Local  Ramp   Fways   A/C   Local  Ramp
C             ih =  1            |      ih =  2
     1 0.392, 0.457, 0.117, 0.034, 0.344, 0.497, 0.129, 0.030,
C             ih =  3            |      ih =  4
     1 0.338, 0.497, 0.135, 0.029, 0.349, 0.492, 0.129, 0.030,
C             ih =  5            |      ih =  6
     1 0.346, 0.497, 0.127, 0.030, 0.333, 0.509, 0.129, 0.029,
C             ih =  7            |      ih =  8
     1 0.324, 0.516, 0.132, 0.028, 0.334, 0.506, 0.131, 0.029,
C             ih =  9            |      ih = 10
     1 0.334, 0.506, 0.131, 0.029, 0.320, 0.519, 0.134, 0.028,
C             ih = 11            |      ih = 12
     1 0.330, 0.506, 0.135, 0.029, 0.312, 0.521, 0.140, 0.027,
C             ih = 13            |      ih = 14
     1 0.295, 0.538, 0.141, 0.026, 0.310, 0.527, 0.137, 0.027,
C             ih = 15            |      ih = 16
     1 0.329, 0.510, 0.133, 0.029, 0.343, 0.497, 0.131, 0.030,
C             ih = 17            |      ih = 18
     1 0.381, 0.460, 0.126, 0.033, 0.405, 0.437, 0.123, 0.035,
C             ih = 19            |      ih = 20
     1 0.426, 0.418, 0.118, 0.037, 0.443, 0.403, 0.115, 0.039,
C             ih = 21            |      ih = 22
     1 0.457, 0.394, 0.110, 0.040, 0.461, 0.391, 0.107, 0.040,
C             ih = 23            |      ih = 24
     1 0.453, 0.400, 0.108, 0.039, 0.418, 0.434, 0.112, 0.036/
C
        DATA FVMT11/
C
C  7 HEAVY-DUTY GAS    CLASS 11
C  24 Hour  Freeways  Arterials & Collectors Locals Ramps
C
C      Fways   A/C   Local  Ramp   Fways   A/C   Local  Ramp
C             ih =  1            |      ih =  2
     1 0.392, 0.457, 0.117, 0.034, 0.344, 0.497, 0.129, 0.030,
C             ih =  3            |      ih =  4
     1 0.338, 0.497, 0.135, 0.029, 0.349, 0.492, 0.129, 0.030,
C             ih =  5            |      ih =  6
     1 0.346, 0.497, 0.127, 0.030, 0.333, 0.509, 0.129, 0.029,
C             ih =  7            |      ih =  8
     1 0.324, 0.516, 0.132, 0.028, 0.334, 0.506, 0.131, 0.029,
C             ih =  9            |      ih = 10
     1 0.334, 0.506, 0.131, 0.029, 0.320, 0.519, 0.134, 0.028,
C             ih = 11            |      ih = 12
     1 0.330, 0.506, 0.135, 0.029, 0.312, 0.521, 0.140, 0.027,
C             ih = 13            |      ih = 14
     1 0.295, 0.538, 0.141, 0.026, 0.310, 0.527, 0.137, 0.027,
C             ih = 15            |      ih = 16
     1 0.329, 0.510, 0.133, 0.029, 0.343, 0.497, 0.131, 0.030,
C             ih = 17            |      ih = 18
     1 0.381, 0.460, 0.126, 0.033, 0.405, 0.437, 0.123, 0.035,
C             ih = 19            |      ih = 20
     1 0.426, 0.418, 0.118, 0.037, 0.443, 0.403, 0.115, 0.039,
C             ih = 21            |      ih = 22
     1 0.457, 0.394, 0.110, 0.040, 0.461, 0.391, 0.107, 0.040,
C             ih = 23            |      ih = 24
     1 0.453, 0.400, 0.108, 0.039, 0.418, 0.434, 0.112, 0.036/
C
        DATA FVMT12/
C
C  8A HEAVY-DUTY GAS    CLASS 12
C  24 Hour  Freeways  Arterials & Collectors Locals Ramps
C
C      Fways   A/C   Local  Ramp   Fways   A/C   Local  Ramp
C             ih =  1            |      ih =  2
     1 0.392, 0.457, 0.117, 0.034, 0.344, 0.497, 0.129, 0.030,
C             ih =  3            |      ih =  4
     1 0.338, 0.497, 0.135, 0.029, 0.349, 0.492, 0.129, 0.030,
C             ih =  5            |      ih =  6
     1 0.346, 0.497, 0.127, 0.030, 0.333, 0.509, 0.129, 0.029,
C             ih =  7            |      ih =  8
     1 0.324, 0.516, 0.132, 0.028, 0.334, 0.506, 0.131, 0.029,
C             ih =  9            |      ih = 10
     1 0.334, 0.506, 0.131, 0.029, 0.320, 0.519, 0.134, 0.028,
C             ih = 11            |      ih = 12
     1 0.330, 0.506, 0.135, 0.029, 0.312, 0.521, 0.140, 0.027,
C             ih = 13            |      ih = 14
     1 0.295, 0.538, 0.141, 0.026, 0.310, 0.527, 0.137, 0.027,
C             ih = 15            |      ih = 16
     1 0.329, 0.510, 0.133, 0.029, 0.343, 0.497, 0.131, 0.030,
C             ih = 17            |      ih = 18
     1 0.381, 0.460, 0.126, 0.033, 0.405, 0.437, 0.123, 0.035,
C             ih = 19            |      ih = 20
     1 0.426, 0.418, 0.118, 0.037, 0.443, 0.403, 0.115, 0.039,
C             ih = 21            |      ih = 22
     1 0.457, 0.394, 0.110, 0.040, 0.461, 0.391, 0.107, 0.040,
C             ih = 23            |      ih = 24
     1 0.453, 0.400, 0.108, 0.039, 0.418, 0.434, 0.112, 0.036/
C
        DATA FVMT13/
C
C  8B HEAVY-DUTY GAS    CLASS 13
C  24 Hour  Freeways  Arterials & Collectors Locals Ramps
C
C      Fways   A/C   Local  Ramp   Fways   A/C   Local  Ramp
C             ih =  1            |      ih =  2
     1 0.392, 0.457, 0.117, 0.034, 0.344, 0.497, 0.129, 0.030,
C             ih =  3            |      ih =  4
     1 0.338, 0.497, 0.135, 0.029, 0.349, 0.492, 0.129, 0.030,
C             ih =  5            |      ih =  6
     1 0.346, 0.497, 0.127, 0.030, 0.333, 0.509, 0.129, 0.029,
C             ih =  7            |      ih =  8
     1 0.324, 0.516, 0.132, 0.028, 0.334, 0.506, 0.131, 0.029,
C             ih =  9            |      ih = 10
     1 0.334, 0.506, 0.131, 0.029, 0.320, 0.519, 0.134, 0.028,
C             ih = 11            |      ih = 12
     1 0.330, 0.506, 0.135, 0.029, 0.312, 0.521, 0.140, 0.027,
C             ih = 13            |      ih = 14
     1 0.295, 0.538, 0.141, 0.026, 0.310, 0.527, 0.137, 0.027,
C             ih = 15            |      ih = 16
     1 0.329, 0.510, 0.133, 0.029, 0.343, 0.497, 0.131, 0.030,
C             ih = 17            |      ih = 18
     1 0.381, 0.460, 0.126, 0.033, 0.405, 0.437, 0.123, 0.035,
C             ih = 19            |      ih = 20
     1 0.426, 0.418, 0.118, 0.037, 0.443, 0.403, 0.115, 0.039,
C             ih = 21            |      ih = 22
     1 0.457, 0.394, 0.110, 0.040, 0.461, 0.391, 0.107, 0.040,
C             ih = 23            |      ih = 24
     1 0.453, 0.400, 0.108, 0.039, 0.418, 0.434, 0.112, 0.036/
C
        DATA FVMT14/
C
C  LDDV    CLASS 14
C  24 Hour  Freeways  Arterials & Collectors Locals Ramps
C
C      Fways   A/C   Local  Ramp   Fways   A/C   Local  Ramp
C             ih =  1            |      ih =  2
     1 0.392, 0.457, 0.117, 0.034, 0.344, 0.497, 0.129, 0.030,
C             ih =  3            |      ih =  4
     1 0.338, 0.497, 0.135, 0.029, 0.349, 0.492, 0.129, 0.030,
C             ih =  5            |      ih =  6
     1 0.346, 0.497, 0.127, 0.030, 0.333, 0.509, 0.129, 0.029,
C             ih =  7            |      ih =  8
     1 0.324, 0.516, 0.132, 0.028, 0.334, 0.506, 0.131, 0.029,
C             ih =  9            |      ih = 10
     1 0.334, 0.506, 0.131, 0.029, 0.320, 0.519, 0.134, 0.028,
C             ih = 11            |      ih = 12
     1 0.330, 0.506, 0.135, 0.029, 0.312, 0.521, 0.140, 0.027,
C             ih = 13            |      ih = 14
     1 0.295, 0.538, 0.141, 0.026, 0.310, 0.527, 0.137, 0.027,
C             ih = 15            |      ih = 16
     1 0.329, 0.510, 0.133, 0.029, 0.343, 0.497, 0.131, 0.030,
C             ih = 17            |      ih = 18
     1 0.381, 0.460, 0.126, 0.033, 0.405, 0.437, 0.123, 0.035,
C             ih = 19            |      ih = 20
     1 0.426, 0.418, 0.118, 0.037, 0.443, 0.403, 0.115, 0.039,
C             ih = 21            |      ih = 22
     1 0.457, 0.394, 0.110, 0.040, 0.461, 0.391, 0.107, 0.040,
C             ih = 23            |      ih = 24
     1 0.453, 0.400, 0.108, 0.039, 0.418, 0.434, 0.112, 0.036/
C
        DATA FVMT15/
C
C  LDDT1,2    CLASS 15
C  24 Hour  Freeways  Arterials & Collectors Locals Ramps
C
C      Fways   A/C   Local  Ramp   Fways   A/C   Local  Ramp
C             ih =  1            |      ih =  2
     1 0.392, 0.457, 0.117, 0.034, 0.344, 0.497, 0.129, 0.030,
C             ih =  3            |      ih =  4
     1 0.338, 0.497, 0.135, 0.029, 0.349, 0.492, 0.129, 0.030,
C             ih =  5            |      ih =  6
     1 0.346, 0.497, 0.127, 0.030, 0.333, 0.509, 0.129, 0.029,
C             ih =  7            |      ih =  8
     1 0.324, 0.516, 0.132, 0.028, 0.334, 0.506, 0.131, 0.029,
C             ih =  9            |      ih = 10
     1 0.334, 0.506, 0.131, 0.029, 0.320, 0.519, 0.134, 0.028,
C             ih = 11            |      ih = 12
     1 0.330, 0.506, 0.135, 0.029, 0.312, 0.521, 0.140, 0.027,
C             ih = 13            |      ih = 14
     1 0.295, 0.538, 0.141, 0.026, 0.310, 0.527, 0.137, 0.027,
C             ih = 15            |      ih = 16
     1 0.329, 0.510, 0.133, 0.029, 0.343, 0.497, 0.131, 0.030,
C             ih = 17            |      ih = 18
     1 0.381, 0.460, 0.126, 0.033, 0.405, 0.437, 0.123, 0.035,
C             ih = 19            |      ih = 20
     1 0.426, 0.418, 0.118, 0.037, 0.443, 0.403, 0.115, 0.039,
C             ih = 21            |      ih = 22
     1 0.457, 0.394, 0.110, 0.040, 0.461, 0.391, 0.107, 0.040,
C             ih = 23            |      ih = 24
     1 0.453, 0.400, 0.108, 0.039, 0.418, 0.434, 0.112, 0.036/
C
        DATA FVMT16/
C
C  2B HEAVY-DUTY DIESEL   CLASS 16
C  24 Hour  Freeways  Arterials & Collectors Locals Ramps
C
C      Fways   A/C   Local  Ramp   Fways   A/C   Local  Ramp
C             ih =  1            |      ih =  2
     1 0.392, 0.457, 0.117, 0.034, 0.344, 0.497, 0.129, 0.030,
C             ih =  3            |      ih =  4
     1 0.338, 0.497, 0.135, 0.029, 0.349, 0.492, 0.129, 0.030,
C             ih =  5            |      ih =  6
     1 0.346, 0.497, 0.127, 0.030, 0.333, 0.509, 0.129, 0.029,
C             ih =  7            |      ih =  8
     1 0.324, 0.516, 0.132, 0.028, 0.334, 0.506, 0.131, 0.029,
C             ih =  9            |      ih = 10
     1 0.334, 0.506, 0.131, 0.029, 0.320, 0.519, 0.134, 0.028,
C             ih = 11            |      ih = 12
     1 0.330, 0.506, 0.135, 0.029, 0.312, 0.521, 0.140, 0.027,
C             ih = 13            |      ih = 14
     1 0.295, 0.538, 0.141, 0.026, 0.310, 0.527, 0.137, 0.027,
C             ih = 15            |      ih = 16
     1 0.329, 0.510, 0.133, 0.029, 0.343, 0.497, 0.131, 0.030,
C             ih = 17            |      ih = 18
     1 0.381, 0.460, 0.126, 0.033, 0.405, 0.437, 0.123, 0.035,
C             ih = 19            |      ih = 20
     1 0.426, 0.418, 0.118, 0.037, 0.443, 0.403, 0.115, 0.039,
C             ih = 21            |      ih = 22
     1 0.457, 0.394, 0.110, 0.040, 0.461, 0.391, 0.107, 0.040,
C             ih = 23            |      ih = 24
     1 0.453, 0.400, 0.108, 0.039, 0.418, 0.434, 0.112, 0.036/
C
        DATA FVMT17/
C
C  3 HEAVY-DUTY DIESEL   CLASS 17
C  24 Hour  Freeways  Arterials & Collectors Locals Ramps
C
C      Fways   A/C   Local  Ramp   Fways   A/C   Local  Ramp
C             ih =  1            |      ih =  2
     1 0.392, 0.457, 0.117, 0.034, 0.344, 0.497, 0.129, 0.030,
C             ih =  3            |      ih =  4
     1 0.338, 0.497, 0.135, 0.029, 0.349, 0.492, 0.129, 0.030,
C             ih =  5            |      ih =  6
     1 0.346, 0.497, 0.127, 0.030, 0.333, 0.509, 0.129, 0.029,
C             ih =  7            |      ih =  8
     1 0.324, 0.516, 0.132, 0.028, 0.334, 0.506, 0.131, 0.029,
C             ih =  9            |      ih = 10
     1 0.334, 0.506, 0.131, 0.029, 0.320, 0.519, 0.134, 0.028,
C             ih = 11            |      ih = 12
     1 0.330, 0.506, 0.135, 0.029, 0.312, 0.521, 0.140, 0.027,
C             ih = 13            |      ih = 14
     1 0.295, 0.538, 0.141, 0.026, 0.310, 0.527, 0.137, 0.027,
C             ih = 15            |      ih = 16
     1 0.329, 0.510, 0.133, 0.029, 0.343, 0.497, 0.131, 0.030,
C             ih = 17            |      ih = 18
     1 0.381, 0.460, 0.126, 0.033, 0.405, 0.437, 0.123, 0.035,
C             ih = 19            |      ih = 20
     1 0.426, 0.418, 0.118, 0.037, 0.443, 0.403, 0.115, 0.039,
C             ih = 21            |      ih = 22
     1 0.457, 0.394, 0.110, 0.040, 0.461, 0.391, 0.107, 0.040,
C             ih = 23            |      ih = 24
     1 0.453, 0.400, 0.108, 0.039, 0.418, 0.434, 0.112, 0.036/
C
        DATA FVMT18/
C
C  4 HEAVY-DUTY DIESEL   CLASS 18
C  24 Hour  Freeways  Arterials & Collectors Locals Ramps
C
C      Fways   A/C   Local  Ramp   Fways   A/C   Local  Ramp
C             ih =  1            |      ih =  2
     1 0.392, 0.457, 0.117, 0.034, 0.344, 0.497, 0.129, 0.030,
C             ih =  3            |      ih =  4
     1 0.338, 0.497, 0.135, 0.029, 0.349, 0.492, 0.129, 0.030,
C             ih =  5            |      ih =  6
     1 0.346, 0.497, 0.127, 0.030, 0.333, 0.509, 0.129, 0.029,
C             ih =  7            |      ih =  8
     1 0.324, 0.516, 0.132, 0.028, 0.334, 0.506, 0.131, 0.029,
C             ih =  9            |      ih = 10
     1 0.334, 0.506, 0.131, 0.029, 0.320, 0.519, 0.134, 0.028,
C             ih = 11            |      ih = 12
     1 0.330, 0.506, 0.135, 0.029, 0.312, 0.521, 0.140, 0.027,
C             ih = 13            |      ih = 14
     1 0.295, 0.538, 0.141, 0.026, 0.310, 0.527, 0.137, 0.027,
C             ih = 15            |      ih = 16
     1 0.329, 0.510, 0.133, 0.029, 0.343, 0.497, 0.131, 0.030,
C             ih = 17            |      ih = 18
     1 0.381, 0.460, 0.126, 0.033, 0.405, 0.437, 0.123, 0.035,
C             ih = 19            |      ih = 20
     1 0.426, 0.418, 0.118, 0.037, 0.443, 0.403, 0.115, 0.039,
C             ih = 21            |      ih = 22
     1 0.457, 0.394, 0.110, 0.040, 0.461, 0.391, 0.107, 0.040,
C             ih = 23            |      ih = 24
     1 0.453, 0.400, 0.108, 0.039, 0.418, 0.434, 0.112, 0.036/
C
        DATA FVMT19/
C
C  5 HEAVY-DUTY DIESEL   CLASS 19
C  24 Hour  Freeways  Arterials & Collectors Locals Ramps
C
C      Fways   A/C   Local  Ramp   Fways   A/C   Local  Ramp
C             ih =  1            |      ih =  2
     1 0.392, 0.457, 0.117, 0.034, 0.344, 0.497, 0.129, 0.030,
C             ih =  3            |      ih =  4
     1 0.338, 0.497, 0.135, 0.029, 0.349, 0.492, 0.129, 0.030,
C             ih =  5            |      ih =  6
     1 0.346, 0.497, 0.127, 0.030, 0.333, 0.509, 0.129, 0.029,
C             ih =  7            |      ih =  8
     1 0.324, 0.516, 0.132, 0.028, 0.334, 0.506, 0.131, 0.029,
C             ih =  9            |      ih = 10
     1 0.334, 0.506, 0.131, 0.029, 0.320, 0.519, 0.134, 0.028,
C             ih = 11            |      ih = 12
     1 0.330, 0.506, 0.135, 0.029, 0.312, 0.521, 0.140, 0.027,
C             ih = 13            |      ih = 14
     1 0.295, 0.538, 0.141, 0.026, 0.310, 0.527, 0.137, 0.027,
C             ih = 15            |      ih = 16
     1 0.329, 0.510, 0.133, 0.029, 0.343, 0.497, 0.131, 0.030,
C             ih = 17            |      ih = 18
     1 0.381, 0.460, 0.126, 0.033, 0.405, 0.437, 0.123, 0.035,
C             ih = 19            |      ih = 20
     1 0.426, 0.418, 0.118, 0.037, 0.443, 0.403, 0.115, 0.039,
C             ih = 21            |      ih = 22
     1 0.457, 0.394, 0.110, 0.040, 0.461, 0.391, 0.107, 0.040,
C             ih = 23            |      ih = 24
     1 0.453, 0.400, 0.108, 0.039, 0.418, 0.434, 0.112, 0.036/
C
        DATA FVMT20/
C
C  6 HEAVY-DUTY DIESEL   CLASS 20
C  24 Hour  Freeways  Arterials & Collectors Locals Ramps
C
C      Fways   A/C   Local  Ramp   Fways   A/C   Local  Ramp
C             ih =  1            |      ih =  2
     1 0.392, 0.457, 0.117, 0.034, 0.344, 0.497, 0.129, 0.030,
C             ih =  3            |      ih =  4
     1 0.338, 0.497, 0.135, 0.029, 0.349, 0.492, 0.129, 0.030,
C             ih =  5            |      ih =  6
     1 0.346, 0.497, 0.127, 0.030, 0.333, 0.509, 0.129, 0.029,
C             ih =  7            |      ih =  8
     1 0.324, 0.516, 0.132, 0.028, 0.334, 0.506, 0.131, 0.029,
C             ih =  9            |      ih = 10
     1 0.334, 0.506, 0.131, 0.029, 0.320, 0.519, 0.134, 0.028,
C             ih = 11            |      ih = 12
     1 0.330, 0.506, 0.135, 0.029, 0.312, 0.521, 0.140, 0.027,
C             ih = 13            |      ih = 14
     1 0.295, 0.538, 0.141, 0.026, 0.310, 0.527, 0.137, 0.027,
C             ih = 15            |      ih = 16
     1 0.329, 0.510, 0.133, 0.029, 0.343, 0.497, 0.131, 0.030,
C             ih = 17            |      ih = 18
     1 0.381, 0.460, 0.126, 0.033, 0.405, 0.437, 0.123, 0.035,
C             ih = 19            |      ih = 20
     1 0.426, 0.418, 0.118, 0.037, 0.443, 0.403, 0.115, 0.039,
C             ih = 21            |      ih = 22
     1 0.457, 0.394, 0.110, 0.040, 0.461, 0.391, 0.107, 0.040,
C             ih = 23            |      ih = 24
     1 0.453, 0.400, 0.108, 0.039, 0.418, 0.434, 0.112, 0.036/
C
        DATA FVMT21/
C
C  7 HEAVY-DUTY DIESEL   CLASS 21
C  24 Hour  Freeways  Arterials & Collectors Locals Ramps
C
C      Fways   A/C   Local  Ramp   Fways   A/C   Local  Ramp
C             ih =  1            |      ih =  2
     1 0.392, 0.457, 0.117, 0.034, 0.344, 0.497, 0.129, 0.030,
C             ih =  3            |      ih =  4
     1 0.338, 0.497, 0.135, 0.029, 0.349, 0.492, 0.129, 0.030,
C             ih =  5            |      ih =  6
     1 0.346, 0.497, 0.127, 0.030, 0.333, 0.509, 0.129, 0.029,
C             ih =  7            |      ih =  8
     1 0.324, 0.516, 0.132, 0.028, 0.334, 0.506, 0.131, 0.029,
C             ih =  9            |      ih = 10
     1 0.334, 0.506, 0.131, 0.029, 0.320, 0.519, 0.134, 0.028,
C             ih = 11            |      ih = 12
     1 0.330, 0.506, 0.135, 0.029, 0.312, 0.521, 0.140, 0.027,
C             ih = 13            |      ih = 14
     1 0.295, 0.538, 0.141, 0.026, 0.310, 0.527, 0.137, 0.027,
C             ih = 15            |      ih = 16
     1 0.329, 0.510, 0.133, 0.029, 0.343, 0.497, 0.131, 0.030,
C             ih = 17            |      ih = 18
     1 0.381, 0.460, 0.126, 0.033, 0.405, 0.437, 0.123, 0.035,
C             ih = 19            |      ih = 20
     1 0.426, 0.418, 0.118, 0.037, 0.443, 0.403, 0.115, 0.039,
C             ih = 21            |      ih = 22
     1 0.457, 0.394, 0.110, 0.040, 0.461, 0.391, 0.107, 0.040,
C             ih = 23            |      ih = 24
     1 0.453, 0.400, 0.108, 0.039, 0.418, 0.434, 0.112, 0.036/
C
        DATA FVMT22/
C
C  8A HEAVY-DUTY DIESEL   CLASS 22
C  24 Hour  Freeways  Arterials & Collectors Locals Ramps
C
C      Fways   A/C   Local  Ramp   Fways   A/C   Local  Ramp
C             ih =  1            |      ih =  2
     1 0.392, 0.457, 0.117, 0.034, 0.344, 0.497, 0.129, 0.030,
C             ih =  3            |      ih =  4
     1 0.338, 0.497, 0.135, 0.029, 0.349, 0.492, 0.129, 0.030,
C             ih =  5            |      ih =  6
     1 0.346, 0.497, 0.127, 0.030, 0.333, 0.509, 0.129, 0.029,
C             ih =  7            |      ih =  8
     1 0.324, 0.516, 0.132, 0.028, 0.334, 0.506, 0.131, 0.029,
C             ih =  9            |      ih = 10
     1 0.334, 0.506, 0.131, 0.029, 0.320, 0.519, 0.134, 0.028,
C             ih = 11            |      ih = 12
     1 0.330, 0.506, 0.135, 0.029, 0.312, 0.521, 0.140, 0.027,
C             ih = 13            |      ih = 14
     1 0.295, 0.538, 0.141, 0.026, 0.310, 0.527, 0.137, 0.027,
C             ih = 15            |      ih = 16
     1 0.329, 0.510, 0.133, 0.029, 0.343, 0.497, 0.131, 0.030,
C             ih = 17            |      ih = 18
     1 0.381, 0.460, 0.126, 0.033, 0.405, 0.437, 0.123, 0.035,
C             ih = 19            |      ih = 20
     1 0.426, 0.418, 0.118, 0.037, 0.443, 0.403, 0.115, 0.039,
C             ih = 21            |      ih = 22
     1 0.457, 0.394, 0.110, 0.040, 0.461, 0.391, 0.107, 0.040,
C             ih = 23            |      ih = 24
     1 0.453, 0.400, 0.108, 0.039, 0.418, 0.434, 0.112, 0.036/
C
        DATA FVMT23/
C
C  8B HEAVY-DUTY DIESEL   CLASS 23
C  24 Hour  Freeways  Arterials & Collectors Locals Ramps
C
C      Fways   A/C   Local  Ramp   Fways   A/C   Local  Ramp
C             ih =  1            |      ih =  2
     1 0.392, 0.457, 0.117, 0.034, 0.344, 0.497, 0.129, 0.030,
C             ih =  3            |      ih =  4
     1 0.338, 0.497, 0.135, 0.029, 0.349, 0.492, 0.129, 0.030,
C             ih =  5            |      ih =  6
     1 0.346, 0.497, 0.127, 0.030, 0.333, 0.509, 0.129, 0.029,
C             ih =  7            |      ih =  8
     1 0.324, 0.516, 0.132, 0.028, 0.334, 0.506, 0.131, 0.029,
C             ih =  9            |      ih = 10
     1 0.334, 0.506, 0.131, 0.029, 0.320, 0.519, 0.134, 0.028,
C             ih = 11            |      ih = 12
     1 0.330, 0.506, 0.135, 0.029, 0.312, 0.521, 0.140, 0.027,
C             ih = 13            |      ih = 14
     1 0.295, 0.538, 0.141, 0.026, 0.310, 0.527, 0.137, 0.027,
C             ih = 15            |      ih = 16
     1 0.329, 0.510, 0.133, 0.029, 0.343, 0.497, 0.131, 0.030,
C             ih = 17            |      ih = 18
     1 0.381, 0.460, 0.126, 0.033, 0.405, 0.437, 0.123, 0.035,
C             ih = 19            |      ih = 20
     1 0.426, 0.418, 0.118, 0.037, 0.443, 0.403, 0.115, 0.039,
C             ih = 21            |      ih = 22
     1 0.457, 0.394, 0.110, 0.040, 0.461, 0.391, 0.107, 0.040,
C             ih = 23            |      ih = 24
     1 0.453, 0.400, 0.108, 0.039, 0.418, 0.434, 0.112, 0.036/
C
        DATA FVMT24/
C
C  MOTORCYCLES   CLASS 24
C  24 Hour  Freeways  Arterials & Collectors Locals Ramps
C
C      Fways   A/C   Local  Ramp   Fways   A/C   Local  Ramp
C             ih =  1            |      ih =  2
     1 0.392, 0.457, 0.117, 0.034, 0.344, 0.497, 0.129, 0.030,
C             ih =  3            |      ih =  4
     1 0.338, 0.497, 0.135, 0.029, 0.349, 0.492, 0.129, 0.030,
C             ih =  5            |      ih =  6
     1 0.346, 0.497, 0.127, 0.030, 0.333, 0.509, 0.129, 0.029,
C             ih =  7            |      ih =  8
     1 0.324, 0.516, 0.132, 0.028, 0.334, 0.506, 0.131, 0.029,
C             ih =  9            |      ih = 10
     1 0.334, 0.506, 0.131, 0.029, 0.320, 0.519, 0.134, 0.028,
C             ih = 11            |      ih = 12
     1 0.330, 0.506, 0.135, 0.029, 0.312, 0.521, 0.140, 0.027,
C             ih = 13            |      ih = 14
     1 0.295, 0.538, 0.141, 0.026, 0.310, 0.527, 0.137, 0.027,
C             ih = 15            |      ih = 16
     1 0.329, 0.510, 0.133, 0.029, 0.343, 0.497, 0.131, 0.030,
C             ih = 17            |      ih = 18
     1 0.381, 0.460, 0.126, 0.033, 0.405, 0.437, 0.123, 0.035,
C             ih = 19            |      ih = 20
     1 0.426, 0.418, 0.118, 0.037, 0.443, 0.403, 0.115, 0.039,
C             ih = 21            |      ih = 22
     1 0.457, 0.394, 0.110, 0.040, 0.461, 0.391, 0.107, 0.040,
C             ih = 23            |      ih = 24
     1 0.453, 0.400, 0.108, 0.039, 0.418, 0.434, 0.112, 0.036/
C
        DATA FVMT25/
C
C  GASOLINE BUS   CLASS 25
C  24 Hour  Freeways  Arterials & Collectors Locals Ramps
C
C      Fways   A/C   Local  Ramp   Fways   A/C   Local  Ramp
C             ih =  1            |      ih =  2
     1 0.392, 0.457, 0.117, 0.034, 0.344, 0.497, 0.129, 0.030,
C             ih =  3            |      ih =  4
     1 0.338, 0.497, 0.135, 0.029, 0.349, 0.492, 0.129, 0.030,
C             ih =  5            |      ih =  6
     1 0.346, 0.497, 0.127, 0.030, 0.333, 0.509, 0.129, 0.029,
C             ih =  7            |      ih =  8
     1 0.324, 0.516, 0.132, 0.028, 0.334, 0.506, 0.131, 0.029,
C             ih =  9            |      ih = 10
     1 0.334, 0.506, 0.131, 0.029, 0.320, 0.519, 0.134, 0.028,
C             ih = 11            |      ih = 12
     1 0.330, 0.506, 0.135, 0.029, 0.312, 0.521, 0.140, 0.027,
C             ih = 13            |      ih = 14
     1 0.295, 0.538, 0.141, 0.026, 0.310, 0.527, 0.137, 0.027,
C             ih = 15            |      ih = 16
     1 0.329, 0.510, 0.133, 0.029, 0.343, 0.497, 0.131, 0.030,
C             ih = 17            |      ih = 18
     1 0.381, 0.460, 0.126, 0.033, 0.405, 0.437, 0.123, 0.035,
C             ih = 19            |      ih = 20
     1 0.426, 0.418, 0.118, 0.037, 0.443, 0.403, 0.115, 0.039,
C             ih = 21            |      ih = 22
     1 0.457, 0.394, 0.110, 0.040, 0.461, 0.391, 0.107, 0.040,
C             ih = 23            |      ih = 24
     1 0.453, 0.400, 0.108, 0.039, 0.418, 0.434, 0.112, 0.036/
C
        DATA FVMT26/
C
C  DIESEL TRANSIT BUS   CLASS 26
C  24 Hour  Freeways  Arterials & Collectors Locals Ramps
C
C      Fways   A/C   Local  Ramp   Fways   A/C   Local  Ramp
C             ih =  1            |      ih =  2
     1 0.392, 0.457, 0.117, 0.034, 0.344, 0.497, 0.129, 0.030,
C             ih =  3            |      ih =  4
     1 0.338, 0.497, 0.135, 0.029, 0.349, 0.492, 0.129, 0.030,
C             ih =  5            |      ih =  6
     1 0.346, 0.497, 0.127, 0.030, 0.333, 0.509, 0.129, 0.029,
C             ih =  7            |      ih =  8
     1 0.324, 0.516, 0.132, 0.028, 0.334, 0.506, 0.131, 0.029,
C             ih =  9            |      ih = 10
     1 0.334, 0.506, 0.131, 0.029, 0.320, 0.519, 0.134, 0.028,
C             ih = 11            |      ih = 12
     1 0.330, 0.506, 0.135, 0.029, 0.312, 0.521, 0.140, 0.027,
C             ih = 13            |      ih = 14
     1 0.295, 0.538, 0.141, 0.026, 0.310, 0.527, 0.137, 0.027,
C             ih = 15            |      ih = 16
     1 0.329, 0.510, 0.133, 0.029, 0.343, 0.497, 0.131, 0.030,
C             ih = 17            |      ih = 18
     1 0.381, 0.460, 0.126, 0.033, 0.405, 0.437, 0.123, 0.035,
C             ih = 19            |      ih = 20
     1 0.426, 0.418, 0.118, 0.037, 0.443, 0.403, 0.115, 0.039,
C             ih = 21            |      ih = 22
     1 0.457, 0.394, 0.110, 0.040, 0.461, 0.391, 0.107, 0.040,
C             ih = 23            |      ih = 24
     1 0.453, 0.400, 0.108, 0.039, 0.418, 0.434, 0.112, 0.036/
C
        DATA FVMT27/
C
C  DIESEL SCHOOL BUS  CLASS 27
C  24 Hour  Freeways  Arterials & Collectors Locals Ramps
C
C      Fways   A/C   Local  Ramp   Fways   A/C   Local  Ramp
C             ih =  1            |      ih =  2
     1 0.392, 0.457, 0.117, 0.034, 0.344, 0.497, 0.129, 0.030,
C             ih =  3            |      ih =  4
     1 0.338, 0.497, 0.135, 0.029, 0.349, 0.492, 0.129, 0.030,
C             ih =  5            |      ih =  6
     1 0.346, 0.497, 0.127, 0.030, 0.333, 0.509, 0.129, 0.029,
C             ih =  7            |      ih =  8
     1 0.324, 0.516, 0.132, 0.028, 0.334, 0.506, 0.131, 0.029,
C             ih =  9            |      ih = 10
     1 0.334, 0.506, 0.131, 0.029, 0.320, 0.519, 0.134, 0.028,
C             ih = 11            |      ih = 12
     1 0.330, 0.506, 0.135, 0.029, 0.312, 0.521, 0.140, 0.027,
C             ih = 13            |      ih = 14
     1 0.295, 0.538, 0.141, 0.026, 0.310, 0.527, 0.137, 0.027,
C             ih = 15            |      ih = 16
     1 0.329, 0.510, 0.133, 0.029, 0.343, 0.497, 0.131, 0.030,
C             ih = 17            |      ih = 18
     1 0.381, 0.460, 0.126, 0.033, 0.405, 0.437, 0.123, 0.035,
C             ih = 19            |      ih = 20
     1 0.426, 0.418, 0.118, 0.037, 0.443, 0.403, 0.115, 0.039,
C             ih = 21            |      ih = 22
     1 0.457, 0.394, 0.110, 0.040, 0.461, 0.391, 0.107, 0.040,
C             ih = 23            |      ih = 24
     1 0.453, 0.400, 0.108, 0.039, 0.418, 0.434, 0.112, 0.036/
C
        DATA FVMT28/
C
C  LDDT3,4   CLASS 28
C  24 Hour  Freeways  Arterials & Collectors Locals Ramps
C
C      Fways   A/C   Local  Ramp   Fways   A/C   Local  Ramp
C             ih =  1            |      ih =  2
     1 0.392, 0.457, 0.117, 0.034, 0.344, 0.497, 0.129, 0.030,
C             ih =  3            |      ih =  4
     1 0.338, 0.497, 0.135, 0.029, 0.349, 0.492, 0.129, 0.030,
C             ih =  5            |      ih =  6
     1 0.346, 0.497, 0.127, 0.030, 0.333, 0.509, 0.129, 0.029,
C             ih =  7            |      ih =  8
     1 0.324, 0.516, 0.132, 0.028, 0.334, 0.506, 0.131, 0.029,
C             ih =  9            |      ih = 10
     1 0.334, 0.506, 0.131, 0.029, 0.320, 0.519, 0.134, 0.028,
C             ih = 11            |      ih = 12
     1 0.330, 0.506, 0.135, 0.029, 0.312, 0.521, 0.140, 0.027,
C             ih = 13            |      ih = 14
     1 0.295, 0.538, 0.141, 0.026, 0.310, 0.527, 0.137, 0.027,
C             ih = 15            |      ih = 16
     1 0.329, 0.510, 0.133, 0.029, 0.343, 0.497, 0.131, 0.030,
C             ih = 17            |      ih = 18
     1 0.381, 0.460, 0.126, 0.033, 0.405, 0.437, 0.123, 0.035,
C             ih = 19            |      ih = 20
     1 0.426, 0.418, 0.118, 0.037, 0.443, 0.403, 0.115, 0.039,
C             ih = 21            |      ih = 22
     1 0.457, 0.394, 0.110, 0.040, 0.461, 0.391, 0.107, 0.040,
C             ih = 23            |      ih = 24
     1 0.453, 0.400, 0.108, 0.039, 0.418, 0.434, 0.112, 0.036/
C
C   VMT Distribution for speed at different facility type
C   Speed distribution:
        DATA speed/
     1         2.5,  5.0, 10.0, 15.0, 20.0,
     2        25.0, 30.0, 35.0, 40.0, 45.0,
     3        50.0, 55.0, 60.0, 65.0, 70.0/
C
C  Hour  Freeways  Arterials & Collectors 
C
        DATA SVMT1/
C       IH = 1
     1   0.0083, 0.0004, 
     2   0.0272, 0.0052,
     3   0.0210, 0.0061, 
     4   0.0224, 0.0053,
     5   0.0217, 0.0158, 
     6   0.0381, 0.0854, 
     7   0.0344, 0.3210,
     8   0.0536, 0.1382,
     9   0.0614, 0.2804,
     o   0.0700, 0.0595, 
     1   0.2507, 0.0628,
     2   0.1150, 0.0103, 
     3   0.2550, 0.0095, 
     4   0.0212, 0.0001/
C
        DATA SVMT2/
C       IH = 2
     1   0.0260, 0.0036, 
     2   0.0066, 0.0029,  
     3   0.0076, 0.0059, 
     4   0.0156, 0.0234,
     5   0.0282, 0.0735, 
     6   0.0326, 0.1114, 
     7   0.0344, 0.2842,
     8   0.0361, 0.0950, 
     9   0.0360, 0.2633, 
     o   0.0435, 0.0396, 
     1   0.2453, 0.0698, 
     2   0.1729, 0.0107,
     3   0.3023, 0.0167,
     4   0.0129, 0.0000/
C
        DATA SVMT3/
C       IH = 3
     1   0.0259, 0.0033,
     2   0.0033, 0.0021, 
     3   0.0064, 0.0032, 
     4   0.0057, 0.0085, 
     5   0.0126, 0.0436, 
     6   0.0281, 0.1130, 
     7   0.0342, 0.2914, 
     8   0.0349, 0.1076, 
     9   0.0407, 0.2835, 
     o   0.0369, 0.0424, 
     1   0.2181, 0.0719,
     2   0.1066, 0.0091, 
     3   0.4339, 0.0204,
     4   0.0127, 0.0000/
C
        DATA SVMT4/
C       IH = 4
     1   0.0145, 0.0030,
     2   0.0096, 0.0015, 
     3   0.0021, 0.0011, 
     4   0.0022, 0.0015, 
     5   0.0041, 0.0183, 
     6   0.0166, 0.1001, 
     7   0.0232, 0.2910, 
     8   0.0373, 0.1246,
     9   0.0418, 0.3013, 
     o   0.0449, 0.0535, 
     1   0.2248, 0.0743, 
     2   0.1190, 0.0094, 
     3   0.4422, 0.0204, 
     4   0.0177, 0.0000/
C
        DATA SVMT5/
C       IH = 5
     1   0.0083, 0.0030,
     2   0.0086, 0.0014, 
     3   0.0052, 0.0005, 
     4   0.0032, 0.0017, 
     5   0.0040, 0.0181,
     6   0.0163, 0.1008, 
     7   0.0232, 0.2898, 
     8   0.0364, 0.1246,
     9   0.0375, 0.3015, 
     o   0.0420, 0.0537, 
     1   0.2352, 0.0751,
     2   0.1170, 0.0094,
     3   0.4454, 0.0204, 
     4   0.0177, 0.0000/
C
        DATA SVMT6/
C       IH = 6
     1   0.0072, 0.0034,
     2   0.0034, 0.0017,  
     3   0.0042, 0.0021, 
     4   0.0098, 0.0049,
     5   0.0121, 0.0344, 
     6   0.0244, 0.1091, 
     7   0.0289, 0.2894, 
     8   0.0327, 0.1125, 
     9   0.0401, 0.2932, 
     o   0.0392, 0.0460, 
     1   0.2294, 0.0735, 
     2   0.1011, 0.0093, 
     3   0.4538, 0.0205, 
     4   0.0137, 0.0000/
C
        DATA SVMT7/
C       IH = 7
     1   0.0103, 0.0040,
     2   0.0023, 0.0021, 
     3   0.0064, 0.0027, 
     4   0.0087, 0.0078, 
     5   0.0147, 0.0427, 
     6   0.0281, 0.1134, 
     7   0.0335, 0.2857, 
     8   0.0328, 0.1083, 
     9   0.0345, 0.2886,
     o   0.0354, 0.0427, 
     1   0.2294, 0.0724, 
     2   0.0964, 0.0091, 
     3   0.4547, 0.0205, 
     4   0.0128, 0.0000/
C
        DATA SVMT8/
C       IH = 8
     1   0.0083, 0.0038,
     2   0.0075, 0.0025,  
     3   0.0052, 0.0020,
     4   0.0043, 0.0022, 
     5   0.0054, 0.0216, 
     6   0.0182, 0.1034, 
     7   0.0257, 0.2834, 
     8   0.0381, 0.1243, 
     9   0.0380, 0.3020, 
     o   0.0421, 0.0515, 
     1   0.2258, 0.0736, 
     2   0.1118, 0.0094, 
     3   0.4512, 0.0203, 
     4   0.0184, 0.0000/
C
        DATA SVMT9/
C       IH = 9
     1   0.0113, 0.0041,
     2   0.0065, 0.0024,  
     3   0.0052, 0.0020,
     4   0.0023, 0.0034, 
     5   0.0039, 0.0249,
     6   0.0206, 0.1049, 
     7   0.0279, 0.2844, 
     8   0.0358, 0.1215, 
     9   0.0383, 0.2986, 
     o   0.0517, 0.0489, 
     1   0.2147, 0.0751, 
     2   0.1151, 0.0093, 
     3   0.4484, 0.0205, 
     4   0.0183, 0.0000/
C
        DATA SVMT10/
C       IH = 10
     1   0.0155, 0.0052,
     2   0.0075, 0.0027,  
     3   0.0034, 0.0032, 
     4   0.0042, 0.0085, 
     5   0.0081, 0.0450, 
     6   0.0272, 0.1151, 
     7   0.0324, 0.2822, 
     8   0.0363, 0.1024, 
     9   0.0315, 0.2835, 
     o   0.0390, 0.0419, 
     1   0.2124, 0.0777, 
     2   0.0644, 0.0096, 
     3   0.5000, 0.0230, 
     4   0.0181, 0.0000/
C
        DATA SVMT11/
C       IH = 11
     1   0.0156, 0.0049,
     2   0.0411, 0.0165, 
     3   0.0225, 0.0087, 
     4   0.0199, 0.0224, 
     5   0.0284, 0.0652, 
     6   0.0316, 0.1222, 
     7   0.0500, 0.2809,
     8   0.0488, 0.0959, 
     9   0.0446, 0.2557, 
     o   0.0555, 0.0405, 
     1   0.2223, 0.0651, 
     2   0.1092, 0.0095, 
     3   0.2957, 0.0125, 
     4   0.0148, 0.0000/
C
        DATA SVMT12/
C       IH = 12
     1   0.0186, 0.0055,
     2   0.0113, 0.0071, 
     3   0.0046, 0.0082, 
     4   0.0110, 0.0219, 
     5   0.0183, 0.0675, 
     6   0.0261, 0.1169, 
     7   0.0488, 0.2771, 
     8   0.0383, 0.0915, 
     9   0.0314, 0.2637, 
     o   0.0534, 0.0394, 
     1   0.2235, 0.0712,
     2   0.1237, 0.0106,
     3   0.3736, 0.0194, 
     4   0.0174, 0.0000/
C
        DATA SVMT13/
C       IH = 13
     1   0.0176, 0.0043,
     2   0.0064, 0.0024, 
     3   0.0010, 0.0016, 
     4   0.0024, 0.0038,
     5   0.0034, 0.0255, 
     6   0.0155, 0.1005, 
     7   0.0191, 0.2849, 
     8   0.0315, 0.1205, 
     9   0.0357, 0.2996, 
     o   0.0515, 0.0497, 
     1   0.2134, 0.0761,
     2   0.0674, 0.0100, 
     3   0.5178, 0.0211, 
     4   0.0173, 0.0000/
C
        DATA SVMT14/
C       IH = 14
     1   0.0135, 0.0038,
     2   0.0043, 0.0021,  
     3   0.0031, 0.0018, 
     4   0.0010, 0.0015, 
     5   0.0012, 0.0115, 
     6   0.0094, 0.0734, 
     7   0.0177, 0.2923, 
     8   0.0258, 0.1219, 
     9   0.0264, 0.3170,
     o   0.0550, 0.0641, 
     1   0.2060, 0.0794, 
     2   0.0980, 0.0100, 
     3   0.5209, 0.0211, 
     4   0.0177, 0.0001/
C
        DATA SVMT15/
C       IH = 15
     1   0.0094, 0.0037,
     2   0.0031, 0.0017,  
     3   0.0025, 0.0012, 
     4   0.0007, 0.0019, 
     5   0.0012, 0.0103,
     6   0.0069, 0.0558, 
     7   0.0166, 0.3040, 
     8   0.0216, 0.1067,
     9   0.0257, 0.3309, 
     o   0.0476, 0.0702, 
     1   0.2169, 0.0824, 
     2   0.1048, 0.0100, 
     3   0.5228, 0.0211,
     4   0.0202, 0.0001/
C
        DATA SVMT16/
C       IH = 16
     1   0.0054, 0.0036,
     2   0.0018, 0.0018,  
     3   0.0018, 0.0009, 
     4   0.0004, 0.0012,
     5   0.0011, 0.0109,
     6   0.0045, 0.0530, 
     7   0.0155, 0.3056, 
     8   0.0175, 0.1064, 
     9   0.0250, 0.3320,
     o   0.0401, 0.0707, 
     1   0.2277, 0.0827, 
     2   0.1117, 0.0100, 
     3   0.5246, 0.0211, 
     4   0.0229, 0.0001/
C
        DATA SVMT17/
C       IH = 17
     1   0.0027, 0.0034,
     2   0.0010, 0.0009, 
     3   0.0014, 0.0007, 
     4   0.0002, 0.0015,
     5   0.0011, 0.0104, 
     6   0.0028, 0.0531, 
     7   0.0147, 0.3065, 
     8   0.0147, 0.1064, 
     9   0.0245, 0.3325, 
     o   0.0352, 0.0706, 
     1   0.2350, 0.0829, 
     2   0.1162, 0.0100, 
     3   0.5259, 0.0211, 
     4   0.0246, 0.0000/
C
        DATA SVMT18/
C       IH = 18
     1   0.0013, 0.0030,
     2   0.0006, 0.0013,  
     3   0.0012, 0.0016, 
     4   0.0001, 0.0018, 
     5   0.0011, 0.0103, 
     6   0.0020, 0.0528, 
     7   0.0144, 0.3057, 
     8   0.0133, 0.1061, 
     9   0.0242, 0.3327, 
     o   0.0327, 0.0704, 
     1   0.2386, 0.0831, 
     2   0.1185, 0.0100, 
     3   0.5265, 0.0211, 
     4   0.0255, 0.0001/
C
        DATA SVMT19/
C       IH = 19
     1   0.0000, 0.0000,
     2   0.0001, 0.0000, 
     3   0.0010, 0.0000, 
     4   0.0000, 0.0003,
     5   0.0011, 0.0087,
     6   0.0012, 0.0502,
     7   0.0140, 0.3303,
     8   0.0119, 0.1054,
     9   0.0240, 0.3306, 
     o   0.0302, 0.0699, 
     1   0.2422, 0.0733, 
     2   0.1208, 0.0100, 
     3   0.5271, 0.0211, 
     4   0.0264, 0.0002/
C
        DATA SVMT20/
C       IH = 20
     1   0.0000, 0.0001,
     2   0.0013, 0.0000, 
     3   0.0000, 0.0000,
     4   0.0000, 0.0000, 
     5   0.0000, 0.0082, 
     6   0.0010, 0.0496, 
     7   0.0115, 0.3302,
     8   0.0097, 0.1057,
     9   0.0200, 0.3293,
     o   0.0241, 0.0696, 
     1   0.2450, 0.0757, 
     2   0.1285, 0.0101, 
     3   0.5271, 0.0211, 
     4   0.0318, 0.0004/
C
        DATA SVMT21/
C       IH = 21
     1   0.0000, 0.0000,
     2   0.0003, 0.0000,  
     3   0.0010, 0.0000, 
     4   0.0000, 0.0000, 
     5   0.0000, 0.0081, 
     6   0.0008, 0.0491,
     7   0.0103, 0.3306, 
     8   0.0086, 0.1060,
     9   0.0181, 0.3298, 
     o   0.0206, 0.0693, 
     1   0.2464, 0.0755, 
     2   0.1321, 0.0101, 
     3   0.5271, 0.0211, 
     4   0.0347, 0.0004/
C
        DATA SVMT22/
C       IH = 22
     1   0.0000, 0.0000,
     2   0.0013, 0.0000, 
     3   0.0000, 0.0000, 
     4   0.0000, 0.0000, 
     5   0.0000, 0.0077, 
     6   0.0008, 0.0489, 
     7   0.0107, 0.3291, 
     8   0.0081, 0.1060, 
     9   0.0170, 0.3316, 
     o   0.0199, 0.0692, 
     1   0.2451, 0.0758, 
     2   0.1341, 0.0101, 
     3   0.5271, 0.0211, 
     4   0.0359, 0.0005/
C
        DATA SVMT23/
C       IH = 23
     1   0.0021, 0.0000,
     2   0.0003, 0.0000, 
     3   0.0000, 0.0000,
     4   0.0010, 0.0000,
     5   0.0000, 0.0082,
     6   0.0010, 0.0497,
     7   0.0118, 0.3286, 
     8   0.0100, 0.1056,
     9   0.0205, 0.3311,
     o   0.0224, 0.0697, 
     1   0.2452, 0.0756, 
     2   0.1274, 0.0101, 
     3   0.5271, 0.0211,
     4   0.0312, 0.0003/
C
        DATA SVMT24/
C       IH = 24
     1   0.0031, 0.0000,
     2   0.0003, 0.0000,
     3   0.0000, 0.0000,
     4   0.0010, 0.0000,
     5   0.0001, 0.0085,
     6   0.0011, 0.0502,
     7   0.0134, 0.3271, 
     8   0.0124, 0.1054, 
     9   0.0240, 0.3324, 
     o   0.0267, 0.0699, 
     1   0.2404, 0.0752, 
     2   0.1226, 0.0100, 
     3   0.5271, 0.0211,
     4   0.0278, 0.0002/
C    
C    H   THC
C    C   CO
C    N   NOx
C    M   NMHC
C
        DATA LOCAL/
C
C       LOCAL ROADWAY COEFFICIENTS -- Table 13
C
C       Intercept   g/hr   g/hr**2
     H     0.0000, 1.0319, -0.0007,
     C     0.0000, 0.7405,  0.0000,
     N     0.0000, 0.8156, -0.0005,
     M     0.0000, 1.1097, -0.0015/
C
        DATA RAMP/
C
C       FREE RAMP COEEFFICIENTS  -- Table 13
C
C       Intercept   g/hr   g/hr**2
C
     H     4.5600, 2.0463, -0.0036,
     C   224.3330, 2.0397, -0.0001,
     N     5.3530, 2.8629, -0.0101,
     M     4.3680, 2.0135, -0.0039/
C
C
        DATA OCECO/
C
C       OFF-Cycle Effect Coefficients  -- Table 14
C       (Results using these coefficients are not used,
C        see subroutine OFFCYCLE)
C
C       intercept  slope
C
     H     0.2590, 0.9824,
     C     0.5000, 0.8861, 
     N     0.2220, 0.9122, 
     M     0.2280, 0.9472/

        DATA OCY/
C
C       OFF-Cycle Effect Coefficients 
C       (Results using these coefficients are not used,
C        see subroutine OFFCYCLE)
C
C       LEVEL1  LEVEL2  LEVEL3
C
     H     -0.006944,  0.024519, -0.554838,
     C     -0.126227,  0.478643, -8.877953,
     N     -0.055696, -0.060773, -0.401224,
     M     -0.006650,  0.015016, -0.342478/

        DATA OCX/
C
C       OFF-Cycle Effect Coefficients 
C       (Results using these coefficients are not used,
C        see subroutine OFFCYCLE)  Same values as LEVEL.
C
C       LEVEL1  LEVEL2  LEVEL3
C
     H     0.041894,  0.290231,  3.475821,
     C     1.362680,  5.567153, 73.102330,
     N     0.220318,  0.712469,  3.253383,
     M     0.023701,  0.233063,  3.152718/

C
        DATA LEVEL/
C
C       Basic Freeway Emission Levels for -- Table 16
C       determination of Interpolation Weighting Factors.
C
C         Level1   Level2  Level3
C
     H     0.0420, 0.2900,  3.4760,
     C     1.3630, 5.5670, 73.1020,
     N     0.2200, 0.7120,  3.2530,
     M     0.0240, 0.2330,  3.1530/

        DATA EMSCF/
C
C       Speed Correction Factors For Freeways
C      Level1          Level2          Level3
C      intercept Slope intercept Slope intercept Slope
C
C     THC
     A 0.690,   0.0166,  4.891,  0.0807, 44.557,  1.2025,
     L 1.034,  -0.0319,  6.672, -0.1702, 44.557,  1.2025,
     I 0.202,   0.0316,  1.931,  0.1917, 44.557,  1.2025,  
     H 0.0187,  0.000552, 0.315, -0.0023,  3.193, -0.0241,   
C
C     CO
     A 10.036, 0.9413, 36.128, 3.8765,  863.641, 38.5631,
     L 14.730, 0.2802, 46.679, 2.3905, 1206.641, -9.7467,
     I  1.655, 1.2782, 15.271, 4.7880,  365.821, 54.4380,   
     H  0.246, 0.0320,  2.398, 0.0872,   64.691, -0.0269, 
C
C     NO
     A  2.325,  0.1696,  5.122,  0.5675, 14.608, 2.8122,
     L  4.625, -0.1544,  9.312, -0.0226, 24.888, 1.3642,
     I -0.855,  0.2640, -0.957,  0.7613,  0.423, 3.2318,   
     H  0.126,  0.0031,  0.594,  0.0037,  2.981, 0.0051,  
C
C     NMHC
     A 0.399,    0.0118,   4.110,  0.0617, 40.178,  1.1028,
     L 0.685,   -0.0285,   5.796, -0.1758, 40.178,  1.1028,
     I 0.00266,  0.0236,   1.326,  0.1654, 40.178,  1.1028,  
     H 0.00475,  0.000592, 0.259, -0.0019,  2.899, -0.0220/  
C
C
      DATA GLHVMT/24*0.0/
      DATA GLFVMT/2688*0.0/
      DATA GLSVMT/672*0.0/
C
      END
