      BLOCK DATA BD_TIER2 
C 
C   BD_TIER2 contains coefficients used in determining the start 
C   and running basic emission factors for Tier2 vehicle classes. 
C  
C   Changes (Last change first): 
C  18 Jan 01 @EPA-bag 2007 rule for heavy duty vehicles; increased 
C             size of T2_EVAP array for heavy duty vehicles 
C   15 Sep 00 @EPA-elg Updated value in T2_RED per Tier2 evap rule. 
C   18 Aug 00 @EPA-bag bug#206 updated TIER2_50K and T2_BIN_FRAC 
C   12 May 00 @EPA-djb TIER2_50K, NOx #6 set to all 0.110 values. 
C    2 Feb 00 @DynTel-ddj 1-032, Added array T2CRT50K. 
C   14 Jan 00 @Dyntel- jwr - 1-017 Added T2_EVAP and T2_RED for 
C                            the evaporative emissions phase-ins 
C   30 Dec 99 @DynTel-ddj 1-021  New block data. 
C 
C   Common block array subscripts: 
C 
C    /TIER2/    T2_BIN_FRAC (MY, IBIN, IP, IV) 
C               TIER2_50K   (IV, IBIN, IP) 
C               T2CRT5OK    (IV, IP,   IDX) 
C    /T2_EVAP/  T2_EVAP     (MY, IVGAS) 
C    /T2_RED/   T2_RED      (IVGAS) 
C 
C 
C   Common block array dictionary: 
C 
C   Name       Type              Description 
C  ------      ----  --------------------------------------------- 
C  T2_BIN_FRAC  R    Tier2 phase-in bin fractions. 
C  TIER2_50K    R    50K Certification Standards for light duty 
C                    gasoline vehicles and trucks for each of 12 bins 
C                    and each pollutant. 
C  T2CRT50K     R    Tier2 50K Certification Standards for LDDVs and 
C                    LDDTs. 
C  T2_EVAP      R    Evap Tier2 phase-in fractions 
C  T2_RED       R    Tier2 reduction factors 
C 
C  Local array  dictionary: 
C 
C    /T2CCHC/    T2CCHC(MY, IBIN) 
C    /T2CCCO/    T2CCHC(MY, IBIN) 
C    /T2CCNO/    T2CCNO(MY, IBIN) 
C    /T2T1HC/    T2T1HC(MY, IBIN) 
C    /T2T1CO/    T2T1CO(MY, IBIN) 
C    /T2T1NO/    T2T1NO(MY, IBIN) 
C    /T2T2HC/    T2T2HC(MY, IBIN) 
C    /T2T2CO/    T2T2CO(MY, IBIN) 
C    /T2T2NO/    T2T2NO(MY, IBIN) 
C    /T2T3HC/    T2T3HC(MY, IBIN) 
C    /T2T3CO/    T2T3CO(MY, IBIN) 
C    /T2T3NO/    T2T3NO(MY, IBIN) 
C    /T2T4HC/    T2T4HC(MY, IBIN) 
C    /T2T4CO/    T2T4CO(MY, IBIN) 
C    /T2T4NO/    T2T4NO(MY, IBIN) 
C 
C 
C  Local array subscripts: 
C 
C      Name       Type              Description 
C  ------------   ----  --------------------------------------------- 
C T2CCHC(MY,IBIN)  R    HC 50K Certification standards for cars. 
C T2CCCO(MY,IBIN)  R    CO 50K Certification standards for cars. 
C T2CCNO(MY,IBIN)  R    NOx 50K Certification standards for cars. 
C T2T1HC(MY,IBIN)  R    HC 50K Certification standards for LDGT1. 
C T2T1CO(MY,IBIN)  R    CO 50K Certification standards for LDGT1. 
C T2T1NO(MY,IBIN)  R    NOx 50K Certification standards for LDGT1. 
C T2T2HC(MY,IBIN)  R    HC 50K Certification standards for LDGT2. 
C T2T2CO(MY,IBIN)  R    CO 50K Certification standards for LDGT2. 
C T2T2NO(MY,IBIN)  R    NOx 50K Certification standards for LDGT2. 
C T2T3HC(MY,IBIN)  R    HC 50K Certification standards for LDGT3. 
C T2T3CO(MY,IBIN)  R    CO 50K Certification standards for LDGT3. 
C T2T3NO(MY,IBIN)  R    NOx 50K Certification standards for LDGT3. 
C T2T4HC(MY,IBIN)  R    HC 50K Certification standards for LDGT4. 
C T2T4CO(MY,IBIN)  R    CO 50K Certification standards for LDGT4. 
C T2T4NO(MY,IBIN)  R    NOx 50K Certification standards for LDGT4. 
C 
C 
C  Notes: 
C 
C 
C 
      IMPLICIT NONE 
C 
      INCLUDE 'TIER2.I' 
C 
      REAL T2CCHC(12,12) 
      REAL T2CCCO(12,12) 
      REAL T2CCNO(12,12) 
      REAL T2T1HC(12,12) 
      REAL T2T1CO(12,12) 
      REAL T2T1NO(12,12) 
      REAL T2T2HC(12,12) 
      REAL T2T2CO(12,12) 
      REAL T2T2NO(12,12) 
      REAL T2T3HC(12,12) 
      REAL T2T3CO(12,12) 
      REAL T2T3NO(12,12) 
      REAL T2T4HC(12,12) 
      REAL T2T4CO(12,12) 
      REAL T2T4NO(12,12) 
C 
      EQUIVALENCE 
     *  (T2_BIN_FRAC(1,1,1,1), T2CCHC(1,1)), 
     *  (T2_BIN_FRAC(1,1,2,1), T2CCCO(1,1)), 
     *  (T2_BIN_FRAC(1,1,3,1), T2CCNO(1,1)), 
     *  (T2_BIN_FRAC(1,1,1,2), T2T1HC(1,1)), 
     *  (T2_BIN_FRAC(1,1,2,2), T2T1CO(1,1)), 
     *  (T2_BIN_FRAC(1,1,3,2), T2T1NO(1,1)), 
     *  (T2_BIN_FRAC(1,1,1,3), T2T2HC(1,1)), 
     *  (T2_BIN_FRAC(1,1,2,3), T2T2CO(1,1)), 
     *  (T2_BIN_FRAC(1,1,3,3), T2T2NO(1,1)), 
     *  (T2_BIN_FRAC(1,1,1,4), T2T3HC(1,1)), 
     *  (T2_BIN_FRAC(1,1,2,4), T2T3CO(1,1)), 
     *  (T2_BIN_FRAC(1,1,3,4), T2T3NO(1,1)), 
     *  (T2_BIN_FRAC(1,1,1,5), T2T4HC(1,1)), 
     *  (T2_BIN_FRAC(1,1,2,5), T2T4CO(1,1)), 
     *  (T2_BIN_FRAC(1,1,3,5), T2T4NO(1,1)) 
       
C 
      DATA T2CRT50K/ 375*0.0 / 
C 
      DATA T2CCHC/ 
C  LDV 
C HC   2004  2005  2006 2007 2008 2009 2010 2011 2012 2013 2014 2015 
     1 0.000,0.000,0.0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     2 0.000,0.000,0.0,0.10,0.10,0.25,0.25,0.25,0.25,0.25,0.25,0.25, 
     3 0.000,0.000,0.0,0.30,0.30,0.55,0.55,0.55,0.55,0.55,0.55,0.55, 
     4 0.000,0.000,0.0,0.20,0.20,0.10,0.10,0.10,0.10,0.10,0.10,0.10, 
     5 0.386,0.787,1.0,0.40,0.40,0.10,0.10,0.10,0.10,0.10,0.10,0.10, 
     6 0.000,0.000,0.0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     7 0.000,0.000,0.0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     8 0.000,0.000,0.0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     9 0.614,0.213,0.0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     O 0.000,0.000,0.0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     1 0.000,0.000,0.0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     2 0.000,0.000,0.0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00/ 
C 
      DATA T2CCCO/ 
C  LDV 
C CO   2004  2005  2006 2007 2008 2009 2010 2011 2012 2013 2014 2015 
     1 0.000,0.000,0.0,0.000,0.0,0.00,0.000,0.00,0.00,0.00,0.00,0.00, 
     2 0.000,0.000,0.0,0.100,0.1,0.25,0.250,0.25,0.25,0.25,0.25,0.25, 
     3 0.000,0.000,0.0,0.300,0.3,0.55,0.550,0.55,0.55,0.55,0.55,0.55, 
     4 0.000,0.000,0.0,0.200,0.2,0.10,0.100,0.10,0.10,0.10,0.10,0.10, 
     5 0.386,0.787,1.0,0.400,0.4,0.10,0.100,0.10,0.10,0.10,0.10,0.10, 
     6 0.000,0.000,0.0,0.000,0.0,0.00,0.000,0.00,0.00,0.00,0.00,0.00, 
     7 0.000,0.000,0.0,0.000,0.0,0.00,0.000,0.00,0.00,0.00,0.00,0.00, 
     8 0.000,0.000,0.0,0.000,0.0,0.00,0.000,0.00,0.00,0.00,0.00,0.00, 
     9 0.614,0.213,0.0,0.000,0.0,0.00,0.000,0.00,0.00,0.00,0.00,0.00, 
     O 0.000,0.000,0.0,0.000,0.0,0.00,0.000,0.00,0.00,0.00,0.00,0.00, 
     1 0.000,0.000,0.0,0.000,0.0,0.00,0.000,0.00,0.00,0.00,0.00,0.00, 
     2 0.000,0.000,0.0,0.000,0.0,0.00,0.000,0.00,0.00,0.00,0.00,0.00/ 
C 
      DATA T2CCNO/ 
C  LDV 
C NOX  2004  2005  2006 2007 2008 2009 2010 2011 2012 2013 2014 2015 
     1 0.000,0.000,0.0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     2 0.000,0.000,0.0,0.10,0.10,0.25,0.25,0.25,0.25,0.25,0.25,0.25, 
     3 0.000,0.000,0.0,0.30,0.30,0.55,0.55,0.55,0.55,0.55,0.55,0.55, 
     4 0.000,0.000,0.0,0.20,0.20,0.10,0.10,0.10,0.10,0.10,0.10,0.10, 
     5 0.386,0.787,1.0,0.40,0.40,0.10,0.10,0.10,0.10,0.10,0.10,0.10, 
     6 0.000,0.000,0.0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     7 0.000,0.000,0.0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     8 0.000,0.000,0.0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     9 0.614,0.213,0.0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     O 0.000,0.000,0.0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     1 0.000,0.000,0.0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     2 0.000,0.000,0.0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00/ 
C 
      DATA T2T1HC/ 
C  LDT1 
C HC   2004  2005  2006 2007 2008 2009 2010 2011 2012 2013 2014 2015 
     1 0.000,0.000,0.0,0.000,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     2 0.000,0.000,0.0,0.100,0.10,0.25,0.25,0.25,0.25,0.25,0.25,0.25, 
     3 0.000,0.000,0.0,0.300,0.30,0.55,0.55,0.55,0.55,0.55,0.55,0.55, 
     4 0.000,0.000,0.0,0.200,0.20,0.10,0.10,0.10,0.10,0.10,0.10,0.10, 
     5 0.386,0.787,1.0,0.400,0.40,0.10,0.10,0.10,0.10,0.10,0.10,0.10, 
     6 0.000,0.000,0.0,0.000,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     7 0.000,0.000,0.0,0.000,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     8 0.000,0.000,0.0,0.000,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     9 0.614,0.213,0.0,0.000,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     O 0.000,0.000,0.0,0.000,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     1 0.000,0.000,0.0,0.000,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     2 0.000,0.000,0.0,0.000,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00/ 
C 
      DATA T2T1CO/ 
C  LDT1 
C CO   2004  2005  2006 2007 2008 2009 2010 2011 2012 2013 2014 2015 
     1 0.000,0.000,0.0, 0.0, 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     2 0.000,0.000,0.0, 0.1, 0.10,0.25,0.25,0.25,0.25,0.25,0.25,0.25, 
     3 0.000,0.000,0.0, 0.3, 0.30,0.55,0.55,0.55,0.55,0.55,0.55,0.55, 
     4 0.000,0.000,0.0, 0.2, 0.20,0.10,0.10,0.10,0.10,0.10,0.10,0.10, 
     5 0.386,0.787,1.0, 0.4, 0.40,0.10,0.10,0.10,0.10,0.10,0.10,0.10, 
     6 0.000,0.000,0.0, 0.0, 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     7 0.000,0.000,0.0, 0.0, 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     8 0.000,0.000,0.0, 0.0, 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     9 0.614,0.213,0.0, 0.0, 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     O 0.000,0.000,0.0, 0.0, 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     1 0.000,0.000,0.0, 0.0, 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     2 0.000,0.000,0.0, 0.0, 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00/ 
C 
      DATA T2T1NO/ 
C  LDT1 
C NOX  2004  2005  2006 2007 2008 2009 2010 2011 2012 2013 2014 2015 
     1 0.000,0.000,0.0, 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     2 0.000,0.000,0.0, 0.10,0.10,0.25,0.25,0.25,0.25,0.25,0.25,0.25, 
     3 0.000,0.000,0.0, 0.30,0.30,0.55,0.55,0.55,0.55,0.55,0.55,0.55, 
     4 0.000,0.000,0.0, 0.20,0.20,0.10,0.10,0.10,0.10,0.10,0.10,0.10, 
     5 0.386,0.787,1.0, 0.40,0.40,0.10,0.10,0.10,0.10,0.10,0.10,0.10, 
     6 0.000,0.000,0.0, 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     7 0.000,0.000,0.0, 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     8 0.000,0.000,0.0, 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     9 0.614,0.213,0.0, 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     O 0.000,0.000,0.0, 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     1 0.000,0.000,0.0, 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     2 0.000,0.000,0.0, 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00/ 
C 
      DATA T2T2HC/ 
C  LDT2 
C HC   2004 2005 2006  2007 2008 2009 2010 2011 2012 2013 2014 2015 
     1 0.00,0.00,0.000,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     2 0.00,0.00,0.000,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     3 0.00,0.00,0.000,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     4 0.00,0.00,0.000,0.00,0.00,0.20,0.20,0.20,0.20,0.20,0.20,0.20, 
     5 0.00,0.00,0.337,0.40,0.40,0.20,0.20,0.20,0.20,0.20,0.20,0.20, 
     6 0.00,0.00,0.000,0.30,0.30,0.30,0.30,0.30,0.30,0.30,0.30,0.30, 
     7 0.00,0.00,0.000,0.30,0.30,0.30,0.30,0.30,0.30,0.30,0.30,0.30, 
     8 0.00,0.00,0.000,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     9 1.00,1.00,0.663,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     O 0.00,0.00,0.000,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     1 0.00,0.00,0.000,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     2 0.00,0.00,0.000,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00/ 
C 
      DATA T2T2CO/ 
C  LDT2 
C CO   2004 2005 2006  2007 2008 2009 2010 2011 2012 2013 2014 2015 
     1 0.00,0.00,0.000,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     2 0.00,0.00,0.000,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     3 0.00,0.00,0.000,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     4 0.00,0.00,0.000,0.00,0.00,0.20,0.20,0.20,0.20,0.20,0.20,0.20, 
     5 0.00,0.00,0.337,0.40,0.40,0.20,0.20,0.20,0.20,0.20,0.20,0.20, 
     6 0.00,0.00,0.000,0.30,0.30,0.30,0.30,0.30,0.30,0.30,0.30,0.30, 
     7 0.00,0.00,0.000,0.30,0.30,0.30,0.30,0.30,0.30,0.30,0.30,0.30, 
     8 0.00,0.00,0.000,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     9 1.00,1.00,0.663,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     O 0.00,0.00,0.000,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     1 0.00,0.00,0.000,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     2 0.00,0.00,0.000,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00/ 
C 
      DATA T2T2NO/ 
C  LDT2 
C NOX  2004 2005 2006  2007 2008 2009 2010 2011 2012 2013 2014 2015 
     1 0.00,0.00,0.000,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     2 0.00,0.00,0.000,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     3 0.00,0.00,0.000,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     4 0.00,0.00,0.000,0.00,0.00,0.20,0.20,0.20,0.20,0.20,0.20,0.20, 
     5 0.00,0.00,0.337,0.40,0.40,0.20,0.20,0.20,0.20,0.20,0.20,0.20, 
     6 0.00,0.00,0.000,0.30,0.30,0.30,0.30,0.30,0.30,0.30,0.30,0.30, 
     7 0.00,0.00,0.000,0.30,0.30,0.30,0.30,0.30,0.30,0.30,0.30,0.30, 
     8 0.00,0.00,0.000,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     9 1.00,1.00,0.663,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     O 0.00,0.00,0.000,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     1 0.00,0.00,0.000,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     2 0.00,0.00,0.000,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00/ 
C 
      DATA T2T3HC/ 
C  LDT3 
C HC   2004 2005 2006 2007 2008 2009 2010 2011 2012 2013 2014 2015 
     1 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     2 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     3 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     4 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     5 0.00,0.00,0.00,0.00,0.74,0.74,0.74,0.74,0.74,0.74,0.74,0.74, 
     6 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     7 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     8 0.37,0.74,1.00,1.00,0.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     9 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     O 0.63,0.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     1 0.00,0.00,0.00,0.00,0.00,0.26,0.26,0.26,0.26,0.26,0.26,0.26, 
     2 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00/ 
C 
      DATA T2T3CO/ 
C  LDT3 
C CO   2004 2005 2006 2007 2008 2009 2010 2011 2012 2013 2014 2015 
     1 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     2 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     3 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     4 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     5 0.00,0.00,0.00,0.00,0.74,0.74,0.74,0.74,0.74,0.74,0.74,0.74, 
     6 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     7 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     8 0.37,0.74,1.00,1.00,0.26,0.26,0.26,0.26,0.26,0.26,0.26,0.26, 
     9 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     O 0.63,0.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     1 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     2 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00/ 
C 
      DATA T2T3NO/ 
C  LDT3 
C NOX  2004 2005 2006 2007 2008 2009 2010 2011 2012 2013 2014 2015 
     1 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     2 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     3 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     4 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     5 0.00,0.00,0.00,0.00,0.74,0.74,0.74,0.74,0.74,0.74,0.74,0.74, 
     6 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     7 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     8 0.37,0.74,1.00,1.00,0.26,0.26,0.26,0.26,0.26,0.26,0.26,0.26, 
     9 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     O 0.63,0.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     1 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     2 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00/ 
C 
      DATA T2T4HC/ 
C  LDT4 
C HC   2004 2005 2006 2007 2008 2009 2010 2011 2012 2013 2014 2015 
     1 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     2 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     3 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     4 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     5 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     6 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     7 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     8 0.00,0.00,0.22,1.00,1.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     9 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     O 1.00,1.00,0.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     1 0.00,0.00,0.00,0.00,0.00,1.00,1.00,1.00,1.00,1.00,1.00,1.00, 
     2 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00/ 
C 
      DATA T2T4CO/ 
C  LDT4 
C CO   2004 2005 2006 2007 2008 2009 2010 2011 2012 2013 2014 2015 
     1 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     2 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     3 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     4 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     5 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     6 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     7 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     8 0.00,0.00,0.22,1.00,1.00,1.00,1.00,1.00,1.00,1.00,1.00,1.00, 
     9 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     O 1.00,1.00,0.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     1 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     2 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00/ 
C 
      DATA T2T4NO/ 
C  LDT4 
C NOX  2004 2005 2006 2007 2008 2009 2010 2011 2012 2013 2014 2015 
     1 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     2 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     3 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     4 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     5 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     6 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     7 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     8 0.00,0.00,0.22,1.00,1.00,1.00,1.00,1.00,1.00,1.00,1.00,1.00, 
     9 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     O 1.00,1.00,0.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     1 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     2 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00/ 
C 
      DATA TIER2_50K/ 
C HC    LDV   LDT1   LDT2   LDT3   LDT4 
     1 0.000, 0.000, 0.000, 0.000, 0.000, 
     2 0.007, 0.007, 0.007, 0.007, 0.007, 
     3 0.040, 0.040, 0.040, 0.040, 0.040, 
     4 0.051, 0.051, 0.051, 0.051, 0.051, 
     5 0.075, 0.075, 0.075, 0.075, 0.075, 
     6 0.075, 0.075, 0.075, 0.075, 0.075, 
     7 0.075, 0.075, 0.075, 0.075, 0.075, 
     8 0.100, 0.100, 0.100, 0.125, 0.125, 
     9 0.075, 0.075, 0.100, 0.140, 0.140, 
     O 0.125, 0.125, 0.125, 0.160, 0.195, 
     1 0.000, 0.000, 0.000, 0.100, 0.100, 
     2 0.000, 0.000, 0.000, 0.000, 0.000, 
C CO    LDV   LDT1   LDT2   LDT3   LDT4 
     1 0.000, 0.000, 0.000, 0.000, 0.000, 
     2 1.700, 1.700, 1.700, 1.700, 1.700, 
     3 1.700, 1.700, 1.700, 1.700, 1.700, 
     4 1.700, 1.700, 1.700, 1.700, 1.700, 
     5 3.400, 3.400, 3.400, 3.400, 3.400, 
     6 3.400, 3.400, 3.400, 3.400, 3.400, 
     7 3.400, 3.400, 3.400, 3.400, 3.400, 
     8 3.400, 3.400, 3.400, 3.400, 3.400, 
     9 3.400, 3.400, 3.400, 3.400, 3.400, 
     O 3.400, 3.400, 3.400, 4.400, 4.400, 
     1 0.000, 0.000, 0.000, 0.000, 0.000, 
     2 0.000, 0.000, 0.000, 0.000, 0.000, 
C NOx 
     1 0.000, 0.000, 0.000, 0.000, 0.000, 
     2 0.014, 0.014, 0.014, 0.014, 0.014, 
     3 0.021, 0.021, 0.021, 0.021, 0.021, 
     4 0.029, 0.029, 0.029, 0.029, 0.029, 
     5 0.050, 0.050, 0.050, 0.050, 0.050, 
     6 0.080, 0.080, 0.080, 0.080, 0.080, 
     7 0.110, 0.110, 0.110, 0.110, 0.110, 
     8 0.140, 0.140, 0.140, 0.140, 0.140, 
     9 0.200, 0.200, 0.200, 0.200, 0.200, 
     O 0.400, 0.400, 0.400, 0.400, 0.400, 
     1 0.000, 0.000, 0.000, 0.000, 0.000, 
     2 0.000, 0.000, 0.000, 0.000, 0.000/ 
C 
      DATA T2_EVAP/ 
C      2004 2005 2006 2007 2008 2009 2010 2011 2012 2013 2014 2015 
     1 0.25,0.50,0.75,1.00,1.00,1.00,1.00,1.00,1.00,1.00,1.00,1.00, 
     2 0.25,0.50,0.75,1.00,1.00,1.00,1.00,1.00,1.00,1.00,1.00,1.00, 
     3 0.25,0.50,0.75,1.00,1.00,1.00,1.00,1.00,1.00,1.00,1.00,1.00, 
     4 0.00,0.00,0.00,0.00,0.50,1.00,1.00,1.00,1.00,1.00,1.00,1.00, 
     5 0.00,0.00,0.00,0.00,0.50,1.00,1.00,1.00,1.00,1.00,1.00,1.00, 
     6 0.00,0.00,0.00,0.00,0.50,1.00,1.00,1.00,1.00,1.00,1.00,1.00, 
     7 0.00,0.00,0.00,0.00,0.50,1.00,1.00,1.00,1.00,1.00,1.00,1.00, 
     8 0.00,0.00,0.00,0.00,0.50,1.00,1.00,1.00,1.00,1.00,1.00,1.00, 
     9 0.00,0.00,0.00,0.00,0.50,1.00,1.00,1.00,1.00,1.00,1.00,1.00, 
     O 0.00,0.00,0.00,0.00,0.50,1.00,1.00,1.00,1.00,1.00,1.00,1.00, 
     1 0.00,0.00,0.00,0.00,0.50,1.00,1.00,1.00,1.00,1.00,1.00,1.00, 
     2 0.00,0.00,0.00,0.00,0.50,1.00,1.00,1.00,1.00,1.00,1.00,1.00, 
     3 0.00,0.00,0.00,0.00,0.50,1.00,1.00,1.00,1.00,1.00,1.00,1.00, 
     4 0.00,0.00,0.00,0.00,0.50,1.00,1.00,1.00,1.00,1.00,1.00,1.00, 
     5 0.00,0.00,0.00,0.00,0.50,1.00,1.00,1.00,1.00,1.00,1.00,1.00/ 
C 
      DATA T2_RED/ 
C 
C IVGAS   1     2     3     4     5     6    7    8     9     10 
     &  0.750,0.675,0.675,0.550,0.550,0.533,0.533,0.525,0.525,0.525, 
C IVGAS   11    12    13    14    15 
     &  0.525,0.525,0.525,0.525,0.525/ 
C 
      END 
