      BLOCK DATA BD_T2PM 
C 
C   BD_T2PM contains coefficients used in determining the basic 
C   PM emission factors for Tier2 vehicle classes. 
C  
C   Changes (Last change first): 
C   09 Mar 08 AIR TAsk 12: Updated the T2PM_50K array to the 
C             Federal Register based values (see AIR12.WPD) 
C   14 Jan 02 AIR Task 12: Reformatted data to use EQUIVALENCE to 
C                          get around LAHEY compiler bugs. 
C   27 Apr 01 AIR Task 12: New Block Data 
C 
C   Common block array subscripts: 
C 
C    /TIER2PM/    T2PM_FRAC (MY, IBIN, IV) 
C                 T2PM_50K      (IV, IBIN) 
C 
C 
C   Common block array dictionary: 
C 
C   Name          Type              Description 
C  ------         ----  --------------------------------------------- 
C  T2PM_FRAC       R    Tier2 phase-in bin fractions for PM. 
C  T2PM_50K        R    PM 50K Certification Standards for LDGV, LDGT1, 
C                       LDGT2, LDGT3, LDGT4, LDDV, LDDT12 and LDDT34 for 
C                       each of 12 bins. All values are in g/mi. 
C 
C  Notes: 
C 
C 
C 
      IMPLICIT NONE 
C 
      INCLUDE 'TIER2PM.I' 
C 
      REAL FRAC1(12,12) ! LDGV 
      REAL FRAC2(12,12) ! LDGT1 
      REAL FRAC3(12,12) ! LDGT2 
      REAL FRAC4(12,12) ! LDGT3 
      REAL FRAC5(12,12) ! LDGT4 
      REAL FRAC6(12,12) ! LDDV 
      REAL FRAC7(12,12) ! LDDT12 
      REAL FRAC8(12,12) ! LDDT34 
C 
      EQUIVALENCE  
     *  (T2PM_FRAC(1,1,1), FRAC1(1,1)), ! LDGV 
     *  (T2PM_FRAC(1,1,2), FRAC2(1,1)), ! LDGT1 
     *  (T2PM_FRAC(1,1,3), FRAC3(1,1)), ! LDGT2 
     *  (T2PM_FRAC(1,1,4), FRAC4(1,1)), ! LDGT3 
     *  (T2PM_FRAC(1,1,5), FRAC5(1,1)), ! LDGT4 
     *  (T2PM_FRAC(1,1,6), FRAC6(1,1)), ! LDDV 
     *  (T2PM_FRAC(1,1,7), FRAC7(1,1)), ! LDDT12 
     *  (T2PM_FRAC(1,1,8), FRAC8(1,1))  ! LDDT34 
C 
      DATA FRAC1/ 
C  LDGV 
C PM   2004  2005  2006 2007 2008 2009 2010 2011 2012 2013 2014 2015 
     1 0.000,0.000,0.0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     2 0.000,0.000,0.0,0.10,0.10,0.25,0.25,0.25,0.25,0.25,0.25,0.25, 
     3 0.000,0.000,0.0,0.30,0.30,0.55,0.55,0.55,0.55,0.55,0.55,0.55, 
     4 0.000,0.000,0.0,0.20,0.20,0.10,0.10,0.10,0.10,0.10,0.10,0.10, 
     5 0.386,0.787,1.0,0.40,0.40,0.10,0.10,0.10,0.10,0.10,0.10,0.10, 
     6 0.000,0.000,0.0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     7 0.000,0.000,0.0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     8 0.000,0.000,0.0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     9 0.614,0.213,0.0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     * 0.000,0.000,0.0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     1 0.000,0.000,0.0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     2 0.000,0.000,0.0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00/ 
C 
      DATA FRAC2/ 
C  LDGT1 
C PM   2004  2005  2006 2007 2008 2009 2010 2011 2012 2013 2014 2015 
     1 0.000,0.000,0.0, 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     2 0.000,0.000,0.0, 0.10,0.10,0.25,0.25,0.25,0.25,0.25,0.25,0.25, 
     3 0.000,0.000,0.0, 0.30,0.30,0.55,0.55,0.55,0.55,0.55,0.55,0.55, 
     4 0.000,0.000,0.0, 0.20,0.20,0.10,0.10,0.10,0.10,0.10,0.10,0.10, 
     5 0.386,0.787,1.0, 0.40,0.40,0.10,0.10,0.10,0.10,0.10,0.10,0.10, 
     6 0.000,0.000,0.0, 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     7 0.000,0.000,0.0, 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     8 0.000,0.000,0.0, 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     9 0.614,0.213,0.0, 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     * 0.000,0.000,0.0, 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     1 0.000,0.000,0.0, 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     2 0.000,0.000,0.0, 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00/ 
C 
      DATA FRAC3/ 
C  LDGT2 
C PM   2004 2005 2006  2007 2008 2009 2010 2011 2012 2013 2014 2015 
     1 0.00,0.00,0.000,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     2 0.00,0.00,0.000,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     3 0.00,0.00,0.000,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     4 0.00,0.00,0.000,0.00,0.00,0.20,0.20,0.20,0.20,0.20,0.20,0.20, 
     5 0.00,0.00,0.337,0.40,0.40,0.20,0.20,0.20,0.20,0.20,0.20,0.20, 
     6 0.00,0.00,0.000,0.30,0.30,0.30,0.30,0.30,0.30,0.30,0.30,0.30, 
     7 0.00,0.00,0.000,0.30,0.30,0.30,0.30,0.30,0.30,0.30,0.30,0.30, 
     8 0.00,0.00,0.000,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     9 1.00,1.00,0.663,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     * 0.00,0.00,0.000,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     1 0.00,0.00,0.000,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     2 0.00,0.00,0.000,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00/ 
C 
      DATA FRAC4/ 
C  LDGT3 
C PM   2004 2005 2006 2007 2008 2009 2010 2011 2012 2013 2014 2015 
     1 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     2 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     3 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     4 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     5 0.00,0.00,0.00,0.00,0.74,0.74,0.74,0.74,0.74,0.74,0.74,0.74, 
     6 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     7 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     8 0.37,0.74,1.00,1.00,0.26,0.26,0.26,0.26,0.26,0.26,0.26,0.26, 
     9 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     * 0.63,0.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     1 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     2 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00/ 
C 
      DATA FRAC5/ 
C  LDGT4 
C PM   2004 2005 2006 2007 2008 2009 2010 2011 2012 2013 2014 2015 
     1 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     2 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     3 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     4 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     5 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     6 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     7 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     8 0.00,0.00,0.22,1.00,1.00,1.00,1.00,1.00,1.00,1.00,1.00,1.00, 
     9 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     * 1.00,1.00,0.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     1 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     2 0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00/ 
C 
      DATA FRAC6/ 
C  LDDV 
C PM   2004  2005  2006 2007 2008 2009 2010 2011 2012 2013 2014 2015 
     1 0.000,0.000,0.0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     2 0.000,0.000,0.0,0.10,0.10,0.25,0.25,0.25,0.25,0.25,0.25,0.25, 
     3 0.000,0.000,0.0,0.30,0.30,0.55,0.55,0.55,0.55,0.55,0.55,0.55, 
     4 0.000,0.000,0.0,0.20,0.20,0.10,0.10,0.10,0.10,0.10,0.10,0.10, 
     5 0.386,0.787,1.0,0.40,0.40,0.10,0.10,0.10,0.10,0.10,0.10,0.10, 
     6 0.000,0.000,0.0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     7 0.000,0.000,0.0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     8 0.000,0.000,0.0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     9 0.614,0.213,0.0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     * 0.000,0.000,0.0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     1 0.000,0.000,0.0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     2 0.000,0.000,0.0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00/ 
C 
      DATA FRAC7/ 
C  LDDT12 
C PM   2004  2005  2006 2007 2008 2009 2010 2011 2012 2013 2014 2015 
     1 0.000,0.000,0.0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     2 0.000,0.000,0.0,0.10,0.10,0.25,0.25,0.25,0.25,0.25,0.25,0.25, 
     3 0.000,0.000,0.0,0.30,0.30,0.55,0.55,0.55,0.55,0.55,0.55,0.55, 
     4 0.000,0.000,0.0,0.20,0.20,0.10,0.10,0.10,0.10,0.10,0.10,0.10, 
     5 0.386,0.787,1.0,0.40,0.40,0.10,0.10,0.10,0.10,0.10,0.10,0.10, 
     6 0.000,0.000,0.0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     7 0.000,0.000,0.0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     8 0.000,0.000,0.0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     9 0.614,0.213,0.0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     * 0.000,0.000,0.0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     1 0.000,0.000,0.0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     2 0.000,0.000,0.0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00/ 
C 
      DATA FRAC8/ 
C  LDDT34 
C PM   2004  2005  2006 2007 2008 2009 2010 2011 2012 2013 2014 2015 
     1 0.000,0.000,0.0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     2 0.000,0.000,0.0,0.10,0.10,0.25,0.25,0.25,0.25,0.25,0.25,0.25, 
     3 0.000,0.000,0.0,0.30,0.30,0.55,0.55,0.55,0.55,0.55,0.55,0.55, 
     4 0.000,0.000,0.0,0.20,0.20,0.10,0.10,0.10,0.10,0.10,0.10,0.10, 
     5 0.386,0.787,1.0,0.40,0.40,0.10,0.10,0.10,0.10,0.10,0.10,0.10, 
     6 0.000,0.000,0.0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     7 0.000,0.000,0.0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     8 0.000,0.000,0.0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     9 0.614,0.213,0.0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     * 0.000,0.000,0.0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     1 0.000,0.000,0.0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00, 
     2 0.000,0.000,0.0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00/ 
C 
      DATA T2PM_50K/ 
C PM     LDGV   LDGT1   LDGT2   LDGT3   LDGT4    LDDV  LDDT12  LDDT34 
     1 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000,  
     2 0.0043, 0.0043, 0.0043, 0.0043, 0.0043, 0.0092, 0.0092, 0.0092,  
     3 0.0043, 0.0043, 0.0043, 0.0043, 0.0043, 0.0092, 0.0092, 0.0092,  
     4 0.0043, 0.0043, 0.0043, 0.0043, 0.0043, 0.0092, 0.0092, 0.0092,  
     5 0.0043, 0.0043, 0.0043, 0.0043, 0.0043, 0.0092, 0.0092, 0.0092,  
     6 0.0043, 0.0043, 0.0043, 0.0043, 0.0043, 0.0092, 0.0092, 0.0092,  
     7 0.0043, 0.0043, 0.0043, 0.0043, 0.0043, 0.0184, 0.0184, 0.0184,  
     8 0.0043, 0.0043, 0.0043, 0.0043, 0.0043, 0.0184, 0.0184, 0.0184,  
     9 0.0043, 0.0043, 0.0043, 0.0043, 0.0043, 0.0552, 0.0552, 0.0552,  
     * 0.0043, 0.0043, 0.0043, 0.0043, 0.0043, 0.0736, 0.0736, 0.0736,  
     1 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.1104, 0.1104, 0.1104, 
     2 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000/ 
C 
      END 
