      SUBROUTINE GETSPCO(INPREC,INERR,RC) 
C 
C  GETSPCO reads in, validates and stores speed coefficient 
C 
C  Called by DSPTCH. 
C 
C  Calls QUITER. 
C 
C 11 Apr 00 AIR Task 01: Replaced all occurences IOUASK with IOUIN and IOUOUT 
C           so that Lahey Standard for keyboard/monitor I/O is followed. 
C 28 Jul 99 @DynTel-MLA 2-000 Removed the USE LABELS statement. The 
C           module subroutine CHKLAB was removed from that module 
C           and converted to an ordinary external procedure. 
C 11 May 99 @DynTel-MLA 2-674  Modified calls to CHKLAB because the 
C           calling sequence for that subroutine was changed. 
C  1 March 1999 @DynTel-HQ 2-698 Read in speed correction coefficient 
C                          from user input 
C 
C  Input on call: 
C 
C    argument list: INERR 
C    common blocks: 
C    /IOUCOM/ IOUALT,IOUOUT,IOUGEN 
C 
C  Output on return: 
C 
C    argument list: INERR 
C    common blocks: 
C    /FLAGS1/ SPCOFLG 
C    /BSPEED1/ LOCAL, RAMP, OCECO, OCY, OCX, LEVEL, EMSFC  
C   
C 
C  Local variable / array dictionary: 
C  Name    Type  Description 
C  ------- ----  --------------------------------------------------- 
C  SECTION  I    Dummy argument for CHKLAB. 
C  STDLAB   C    Dummy argument for CHKLAB. 
C 
C  Notes: 
C 
      IMPLICIT NONE 
      INCLUDE 'FLAGS1.I' 
      INCLUDE 'IOUCOM.I' 
      INCLUDE 'SPEED9.I' 
C 
      INTEGER, EXTERNAL :: JUNIT   
C 
      CHARACTER   INPREC*(*) 
      INTEGER     INERR 
      INTEGER     RC 
      INTEGER     SPCOFAT 
C 
      LOGICAL     EXTDATA 
      CHARACTER   FILENAME*80 
      CHARACTER   LABEL*19 
      INTEGER     LABTYPE 
      CHARACTER   LASTREC*150 
      CHARACTER   M6REC*150 
      INTEGER     SECTION 
      INTEGER     SOURCE 
      CHARACTER   STDLAB*40 
      INTEGER  I, J, K, M 
      
ccs   Add declarations of M6DIR and M6FILE
      CHARACTER(LEN=200) M6DIR
      CHARACTER(LEN=280) M6FILE
C 
      RC = 0 
      IF (SPCOFLG.EQ.1) THEN 
        SPCOFLG = 2 
      ELSE 
        GOTO 96 
      ENDIF 
C 
C     Find out whether we are reading from an external data file. 
C 
      IF (INPREC(20:20).EQ.'@') THEN 
        EXTDATA = .FALSE. 
        SOURCE = IOUGEN 
        M6REC = INPREC 
      ELSE 
C 
C       Read the data from an external data file. 
C 
        EXTDATA = .TRUE. 
        SOURCE = JUNIT() 
C 
C       Find the token number of the record label that must appear 
C       on a record somewhere in the header of the external data file. 
C 
        CALL CHKLAB('SPEED COEFFICIENT',STDLAB,SPCOFAT,SECTION) 
C       The next two assignment statements are present solely to suppress 
C       compiler generated warnings. They have no functional importance. 
        LABEL = STDLAB(1:1) 
        LABTYPE = SECTION 
C 
C       Open the external data file. 
C 

ccs        CALL UCCOMP(INPREC(21:), FILENAME) 
        CALL LJCOMP(INPREC(21:), FILENAME)

ccs     All M6 input files live in SMK_M6PATH
        CALL GETENV( "SMK_M6PATH", M6DIR )
        M6FILE = M6DIR( 1:LEN_TRIM( M6DIR ) ) // '/' // FILENAME

        OPEN(SOURCE,FILE=M6FILE,STATUS='OLD',ACTION='READ', 
     *       IOSTAT=RC,ERR=80) 
        WRITE(IOUREP,200) FILENAME 
  200   FORMAT(/'* Reading non-default SPEED VMT from the ', 
     &          'following external',/'* data file: ',A) 
C 
C       Read the required header line from the file. 
C 
        CALL NXTREC(SOURCE,IOUREP,M6REC,INERR,RC) 
        IF (RC.NE.0) THEN 
          GOTO 85 
        ENDIF 
C 
C       Check for a valid labeled input record. 
C 
        CALL UCCOMP(M6REC(1:19),LABEL) 
        CALL CHKLAB(LABEL,STDLAB,LABTYPE,SECTION) 
        IF (LABTYPE.NE.SPCOFAT) THEN 
          GOTO 90 
        ENDIF 
C 
      ENDIF 
C 
C     Read the data field from the input record. 
C     Find the first data line. 
C 
      CALL NXTREC(SOURCE,IOUREP,M6REC,INERR,RC) 
      IF (RC.NE.0) GOTO 98 
      BACKSPACE(SOURCE) 
C 
C 
C     WE READ IN DATA HERE. 
C 
  100 FORMAT(3F8.4) 
  101 FORMAT(3F10.6) 
  102 FORMAT(6F11.6) 
C 
      DO 300 I=1, 4 
      READ(SOURCE, 100, END=98, IOSTAT=RC)  
     * (LOCAL(K,I), k=1,3) 
  300 CONTINUE 
C 
      DO 301 I=1, 4 
      READ(SOURCE, 100, END=98, IOSTAT=RC)  
     * (RAMP(K,I), k=1,3) 
  301 CONTINUE 
C 
      DO 302 I=1, 4 
      READ(SOURCE, 100, END=98, IOSTAT=RC)  
     * (OCECO(K,I), k=1,2) 
  302 CONTINUE 
C 
      DO 303 I=1, 4 
      READ(SOURCE, 101, END=98, IOSTAT=RC)  
     * (OCY(K,I), k=1,3) 
  303 CONTINUE 
C 
      DO 304 I=1, 4 
      READ(SOURCE, 101, END=98, IOSTAT=RC)  
     * (OCX(K,I), k=1,3) 
  304 CONTINUE 
C 
      DO 305 I=1, 4 
      READ(SOURCE, 100, END=98, IOSTAT=RC)  
     * (LEVEL(K,I), k=1,3) 
  305 CONTINUE 
C 
      DO 311 I=1, 4 
      DO 310 J=1,4 
      READ(SOURCE, 102, END=98, IOSTAT=RC)  
     * ((EMSCF(M,K,J,I), M=1,2), k=1,3) 
  310 CONTINUE 
  311 CONTINUE 
C 
C 
      IF (EXTDATA) CLOSE(SOURCE) 
C 
   40 GOTO 99 
C 
C     Error opening the external data file. 
C 
   80 WRITE(IOUERR,280) FILENAME 
  280 FORMAT(/'*** ERROR: unable to open the following external ', 
     &        'data file:',/'*** ',A) 
      INERR = INERR + 1 
      GOTO 99 
C 
C     Error reading the header of the external data file. 
C 
   85 SELECT CASE (RC) 
        CASE (:-1) 
          WRITE(IOUERR,285) FILENAME 
  285     FORMAT(/'*** ERROR: no header record was found in ', 
     &            'the following external data file:',/'***',A) 
          RC = 1 
          INERR = INERR + 1 
        CASE (1:) 
          WRITE(IOUERR,286) FILENAME 
  286     FORMAT(/'*** ERROR reading the header of the ', 
     &            'following external data file:',/'*** ',A) 
        CASE DEFAULT 
      END SELECT 
      GOTO 99 
C 
C     Invalid label on the header record. 
C 
   90 WRITE(IOUERR,290) M6REC 
  290 FORMAT(/'*** ERROR: the following record is not allowed in ', 
     &        'the header of the external data file:', 
     &      /'*** ',A) 
      RC = 2   
      INERR = INERR + 1 
      GOTO 99 
C 
C     Error: alternate speed VMT have been 
C            read in. 
C     
   96 WRITE(IOUERR,296) 
  296 FORMAT(/'*** ERROR: Alternate Speed Coefficient', 
     &        'have already been read in this run.', 
     &       /'*** Only one set of Speed Coefficient', 
     &        'can be entered in one run.'/) 
CCC  &      /'*** The factors entered here will replace the ', 
CCC  &       'rates that were entered previously.'/) 
      RC = 3   
      INERR = INERR + 1 
      GOTO 99 
C 
   98 CALL QUITER(0.,0,126,INERR) 
      IF (RC.LT.0) THEN 
        WRITE(IOUERR,298) 
  298   FORMAT('*** (Unexpected end of file.)') 
      ELSE 
        BACKSPACE(SOURCE) 
        READ(SOURCE,199,ERR=99,END=99) LASTREC 
  199   FORMAT(A) 
        WRITE(IOUERR,299) LASTREC 
  299   FORMAT('*** The following record caused the error:', 
     &        /'*** ',A) 
      ENDIF 
C 
   99 RETURN 
      END 
