      SUBROUTINE ININVEH() 
C 
C    This module initializes the variables for hourly diurnal calculations 
C       
C    This data includes the vehicle activity fractions and parameters 
C    for diurnal fractions and daily diurnals 
C 
C  Called by DIRNLINI 
C 
C 
C  Changes:  (Last change first) 
C 
C  07 JUL 00 @EPA-bg BUG166   Replaced activity fractions 
C  07 Jan 00 @Dyntel-bg 1-005 updated diurnal code(new) 
C 
C  Input on call: 
C 
C    Constants:  
C 
C    argument list: 
C    function : 
C    common blocks: 
C    modules      : 
c 
C  Output on return: 
C 
C    argument list: 
C    common blocks: 
C    modules      : 
C       DIRNLDAT.FOR - NVHCLES_SOAKING 
C 
C 
C  MODULE dictionary: 
C 
C     Name           Type              Description 
C    ------          ----  --------------------------------------------- 
C   NVHCLES_SOAKING   R    The activity weight/fraction is a normalized 
C                          distribution of vehicles soaking for a given hour 
C                          of the day and the length of the soak time. 
C 
C  Local array subscripts: 
C 
C  NVHCLES_SOAKING(18,72) -    ( IH   , IHR_SOAK     ) 
C 
C 
      USE DIRNLDAT, ONLY : NVHCLES_SOAKING 
      IMPLICIT NONE 
C 
C    IHR : 6-7a.m.   7-8a.m.   8-9a.m.   9-10a.m.  10-11a.m.  11a.m.-12p.m. 
C          12-1p.m.  1-2p.m.   2-3P.M.   3-4p.m.   4-5p.m.    5-6p.m. 
C          6-7p.m.   7-8p.m.   8-9p.m.   9-10p.m.  10-11p.m.  11p.m.-12a.m. 
C IHR_SOAK 
C 
      NVHCLES_SOAKING(1:18,1) = 
     1   (/0.0089,   0.0226,   0.0634,   0.1668,   0.2166,   0.1100, 
     1     0.0627,   0.0519,   0.0860,   0.0794,   0.0940,   0.1133, 
     1     0.1321,   0.1321,   0.1321,   0.1321,   0.1321,   0.1321/)
C 
      NVHCLES_SOAKING(1:18,2) = 
     2   (/0.0071,   0.0047,   0.0040,   0.0040,   0.0217,   0.1003, 
     2     0.1136,   0.1041,   0.0811,   0.0783,   0.0579,   0.0646, 
     2     0.0789,   0.0789,   0.0789,   0.0789,   0.0789,   0.0789/) 
C 
      NVHCLES_SOAKING(1:18,3) = 
     3   (/0.0160,   0.0103,   0.0082,   0.0076,   0.0242,   0.0629, 
     3     0.0679,   0.0689,   0.0655,   0.0629,   0.0560,   0.0566, 
     3     0.0665,   0.0665,   0.0665,   0.0665,   0.0665,   0.0665/)
C 
      NVHCLES_SOAKING(1:18,4) =  
     4   (/0.0271,   0.0172,   0.0130,   0.0114,   0.0252,   0.0451, 
     4     0.0470,   0.0500,   0.0528,   0.0502,   0.0495,   0.0469, 
     4     0.0537,   0.0537,   0.0537,   0.0537,   0.0537,   0.0537/)
C  
      NVHCLES_SOAKING(1:18,5) = 
     5   (/0.0392,   0.0247,   0.0181,   0.0152,   0.0253,   0.0345, 
     5     0.0349,   0.0380,   0.0426,   0.0400,   0.0417,   0.0377, 
     5     0.0422,   0.0422,   0.0422,   0.0422,   0.0422,   0.0422/)
C  
      NVHCLES_SOAKING(1:18,6) = 
     6   (/0.0512,   0.0324,   0.0231,   0.0187,   0.0248,   0.0275, 
     6     0.0272,   0.0298,   0.0343,   0.0318,   0.0338,   0.0297, 
     6     0.0326,   0.0326,   0.0326,   0.0326,   0.0326,   0.0326/)
C  
      NVHCLES_SOAKING(1:18,7) = 
     7   (/0.0621,   0.0395,   0.0276,   0.0218,   0.0239,   0.0226, 
     7     0.0218,   0.0239,   0.0276,   0.0252,   0.0267,   0.0230, 
     7     0.0249,   0.0249,   0.0249,   0.0249,   0.0249,   0.0249/)
C  
      NVHCLES_SOAKING(1:18,8) = 
     8   (/0.0707,   0.0456,   0.0314,   0.0243,   0.0227,   0.0189, 
     8     0.0178,   0.0194,   0.0222,   0.0200,   0.0206,   0.0176, 
     8     0.0188,   0.0188,   0.0188,   0.0188,   0.0188,   0.0188/)
C  
      NVHCLES_SOAKING(1:18,9) = 
     9   (/0.0763,   0.0501,   0.0343,   0.0261,   0.0214,   0.0161, 
     9     0.0149,   0.0160,   0.0179,   0.0158,   0.0156,   0.0133, 
     9     0.0141,   0.0141,   0.0141,   0.0141,   0.0141,   0.0141/)
C 
C IHR_SOAK = 10 
C  
      NVHCLES_SOAKING(1:18,10) = 
     Z   (/0.0781,   0.0527,   0.0361,   0.0271,   0.0199,   0.0138, 
     Z     0.0126,   0.0133,   0.0144,   0.0125,   0.0116,   0.0100, 
     Z     0.0105,   0.0105,   0.0105,   0.0105,   0.0105,   0.0105/)
      
      NVHCLES_SOAKING(1:18,11) = 
     1   (/0.0763,   0.0532,   0.0366,   0.0274,   0.0184,   0.0120, 
     1     0.0108,   0.0111,   0.0116,   0.0099,   0.0085,   0.0074, 
     1     0.0077,   0.0077,   0.0077,   0.0077,   0.0077,   0.0077/)
C  
      NVHCLES_SOAKING(1:18,12) = 
     2   (/0.0711,   0.0517,   0.0360,   0.0269,   0.0170,   0.0106, 
     2     0.0093,   0.0094,   0.0093,   0.0078,   0.0061,   0.0055, 
     2     0.0057,   0.0057,   0.0057,   0.0057,   0.0057,   0.0057/)
C  
      NVHCLES_SOAKING(1:18,13) = 
     3   (/0.0633,   0.0483,   0.0344,   0.0257,   0.0155,   0.0093, 
     3     0.0081,   0.0080,   0.0075,   0.0062,   0.0044,   0.0040, 
     3     0.0041,   0.0041,   0.0041,   0.0041,   0.0041,   0.0041/)
C  
      NVHCLES_SOAKING(1:18,14) = 
     4   (/0.0538,   0.0435,   0.0318,   0.0240,   0.0141,   0.0083, 
     4     0.0071,   0.0068,   0.0060,   0.0049,   0.0031,   0.0029, 
     4     0.0030,   0.0030,   0.0030,   0.0030,   0.0030,   0.0030/)
C  
      NVHCLES_SOAKING(1:18,15) = 
     5   (/0.0436,   0.0378,   0.0286,   0.0219,   0.0127,   0.0074, 
     5     0.0063,   0.0059,   0.0049,   0.0039,   0.0022,   0.0021, 
     5     0.0022,   0.0022,   0.0022,   0.0022,   0.0022,   0.0022/)
C  
      NVHCLES_SOAKING(1:18,16) = 
     6   (/0.0338,   0.0316,   0.0250,   0.0195,   0.0115,   0.0067, 
     6     0.0056,   0.0051,   0.0039,   0.0030,   0.0015,   0.0015, 
     6     0.0016,   0.0016,   0.0016,   0.0016,   0.0016,   0.0016/)
C  
      NVHCLES_SOAKING(1:18,17) = 
     7   (/0.0249,   0.0255,   0.0212,   0.0170,   0.0103,   0.0060, 
     7     0.0050,   0.0044,   0.0031,   0.0024,   0.0010,   0.0011, 
     7     0.0011,   0.0011,   0.0011,   0.0011,   0.0011,   0.0011/)
C  
      NVHCLES_SOAKING(1:18,18) = 
     8   (/0.0175,   0.0198,   0.0174,   0.0145,   0.0092,   0.0055, 
     8     0.0045,   0.0038,   0.0025,   0.0019,   0.0007,   0.0008, 
     8     0.0008,   0.0008,   0.0008,   0.0008,   0.0008,   0.0008/)
C  
      NVHCLES_SOAKING(1:18,19) = 
     9   (/0.0117,   0.0148,   0.0140,   0.0121,   0.0082,   0.0050, 
     9     0.0040,   0.0033,   0.0020,   0.0015,   0.0005,   0.0006, 
     9     0.0006,   0.0006,   0.0006,   0.0006,   0.0006,   0.0006/)
C 
C IHR_SOAK = 20 
C  
      NVHCLES_SOAKING(1:18,20) = 
     Z   (/0.0075,   0.0106,   0.0109,   0.0098,   0.0073,   0.0045, 
     Z     0.0036,   0.0029,   0.0016,   0.0012,   0.0003,   0.0004, 
     Z     0.0004,   0.0004,   0.0004,   0.0004,   0.0004,   0.0004/)
      
      NVHCLES_SOAKING(1:18,21) = 
     1   (/0.0045,   0.0073,   0.0082,   0.0079,   0.0064,   0.0042, 
     1     0.0033,   0.0025,   0.0013,   0.0009,   0.0002,   0.0003, 
     1     0.0003,   0.0003,   0.0003,   0.0003,   0.0003,   0.0003/)
C  
      NVHCLES_SOAKING(1:18,22) = 
     2   (/0.0026,   0.0049,   0.0060,   0.0061,   0.0057,   0.0038, 
     2     0.0030,   0.0022,   0.0011,   0.0007,   0.0001,   0.0002, 
     2     0.0002,   0.0002,   0.0002,   0.0002,   0.0002,   0.0002/)
C  
      NVHCLES_SOAKING(1:18,23) = 
     3   (/0.0014,   0.0031,   0.0043,   0.0047,   0.0050,   0.0035, 
     3     0.0027,   0.0020,   0.0009,   0.0006,   0.0001,   0.0001, 
     3     0.0001,   0.0001,   0.0001,   0.0001,   0.0001,   0.0001/)
C  
      NVHCLES_SOAKING(1:18,24) = 
     4   (/0.0007,   0.0019,   0.0030,   0.0035,   0.0044,   0.0032, 
     4     0.0025,   0.0017,   0.0007,   0.0005,   0.0001,   0.0001, 
     4     0.0001,   0.0001,   0.0001,   0.0001,   0.0001,   0.0001/)
C  
      NVHCLES_SOAKING(1:18,25) = 
     5   (/0.0004,   0.0011,   0.0020,   0.0026,   0.0038,   0.0030, 
     5     0.0023,   0.0015,   0.0006,   0.0004,   0.0000,   0.0001, 
     5     0.0001,   0.0001,   0.0001,   0.0001,   0.0001,   0.0001/)
C  
      NVHCLES_SOAKING(1:18,26) = 
     6   (/0.0002,   0.0006,   0.0013,   0.0018,   0.0033,   0.0028, 
     6     0.0021,   0.0014,   0.0004,   0.0003,   0.0000,   0.0000, 
     6     0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000/)
C  
      NVHCLES_SOAKING(1:18,27) = 
     7   (/0.0001,   0.0003,   0.0008,   0.0013,   0.0029,   0.0026, 
     7     0.0019,   0.0012,   0.0004,   0.0002,   0.0000,   0.0000, 
     7     0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000/)
C  
      NVHCLES_SOAKING(1:18,28) = 
     8   (/0.0000,   0.0002,   0.0005,   0.0009,   0.0025,   0.0024, 
     8     0.0018,   0.0011,   0.0003,   0.0002,   0.0000,   0.0000, 
     8     0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000/)
C  
      NVHCLES_SOAKING(1:18,29) = 
     9   (/0.0000,   0.0001,   0.0003,   0.0006,   0.0022,   0.0022, 
     9     0.0016,   0.0010,   0.0002,   0.0001,   0.0000,   0.0000, 
     9     0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000/)
C 
C IHR_SOAK = 30 
C  
      NVHCLES_SOAKING(1:18,30) = 
     Z   (/0.0000,   0.0000,   0.0002,   0.0004,   0.0019,   0.0021, 
     Z     0.0015,   0.0009,   0.0002,   0.0001,   0.0000,   0.0000, 
     Z     0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000/)
      
      NVHCLES_SOAKING(1:18,31) = 
     1   (/0.0000,   0.0000,   0.0001,   0.0002,   0.0016,   0.0019, 
     1     0.0014,   0.0008,   0.0001,   0.0001,   0.0000,   0.0000, 
     1     0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000/)
C  
      NVHCLES_SOAKING(1:18,32) = 
     2   (/0.0000,   0.0000,   0.0001,   0.0002,   0.0014,   0.0018, 
     2     0.0013,   0.0007,   0.0001,   0.0001,   0.0000,   0.0000, 
     2     0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000/)
C  
      NVHCLES_SOAKING(1:18,33) = 
     3   (/0.0000,   0.0000,   0.0000,   0.0001,   0.0012,   0.0017, 
     3     0.0012,   0.0006,   0.0001,   0.0001,   0.0000,   0.0000, 
     3     0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000/)
C  
      NVHCLES_SOAKING(1:18,34) = 
     4   (/0.0000,   0.0000,   0.0000,   0.0001,   0.0010,   0.0016, 
     4     0.0011,   0.0006,   0.0001,   0.0000,   0.0000,   0.0000, 
     4     0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000/)
C  
      NVHCLES_SOAKING(1:18,35) = 
     5   (/0.0000,   0.0000,   0.0000,   0.0000,   0.0009,   0.0015, 
     5     0.0010,   0.0005,   0.0001,   0.0000,   0.0000,   0.0000, 
     5     0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000/)
C  
      NVHCLES_SOAKING(1:18,36) = 
     6   (/0.0000,   0.0000,   0.0000,   0.0000,   0.0007,   0.0014, 
     6     0.0010,   0.0004,   0.0001,   0.0000,   0.0000,   0.0000, 
     6     0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000/)
C  
      NVHCLES_SOAKING(1:18,37) = 
     7   (/0.0000,   0.0000,   0.0000,   0.0000,   0.0006,   0.0013, 
     7     0.0009,   0.0004,   0.0000,   0.0000,   0.0000,   0.0000, 
     7     0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000/)
C  
      NVHCLES_SOAKING(1:18,38) = 
     8   (/0.0000,   0.0000,   0.0000,   0.0000,   0.0005,   0.0012, 
     8     0.0008,   0.0004,   0.0000,   0.0000,   0.0000,   0.0000, 
     8     0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000/)
C  
      NVHCLES_SOAKING(1:18,39) = 
     9   (/0.0000,   0.0000,   0.0000,   0.0000,   0.0005,   0.0012, 
     9     0.0008,   0.0003,   0.0000,   0.0000,   0.0000,   0.0000, 
     9     0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000/)
C 
C IHR_SOAK = 40 
C  
      NVHCLES_SOAKING(1:18,40) = 
     Z   (/0.0000,   0.0000,   0.0000,   0.0000,   0.0004,   0.0011, 
     Z     0.0007,   0.0003,   0.0000,   0.0000,   0.0000,   0.0000, 
     Z     0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000/)
      
      NVHCLES_SOAKING(1:18,41) = 
     1   (/0.0000,   0.0000,   0.0000,   0.0000,   0.0003,   0.0010, 
     1     0.0007,   0.0003,   0.0000,   0.0000,   0.0000,   0.0000, 
     1     0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000/)
C  
      NVHCLES_SOAKING(1:18,42) = 
     2   (/0.0000,   0.0000,   0.0000,   0.0000,   0.0003,   0.0010, 
     2     0.0006,   0.0002,   0.0000,   0.0000,   0.0000,   0.0000, 
     2     0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000/)
C  
      NVHCLES_SOAKING(1:18,43) = 
     3   (/0.0000,   0.0000,   0.0000,   0.0000,   0.0002,   0.0009, 
     3     0.0006,   0.0002,   0.0000,   0.0000,   0.0000,   0.0000, 
     3     0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000/)
C  
      NVHCLES_SOAKING(1:18,44) = 
     4   (/0.0000,   0.0000,   0.0000,   0.0000,   0.0002,   0.0009, 
     4     0.0006,   0.0002,   0.0000,   0.0000,   0.0000,   0.0000, 
     4     0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000/)
C  
      NVHCLES_SOAKING(1:18,45) = 
     5   (/0.0000,   0.0000,   0.0000,   0.0000,   0.0002,   0.0008, 
     5     0.0005,   0.0002,   0.0000,   0.0000,   0.0000,   0.0000, 
     5     0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000/)
C  
      NVHCLES_SOAKING(1:18,46) = 
     6   (/0.0000,   0.0000,   0.0000,   0.0000,   0.0001,   0.0008, 
     6     0.0005,   0.0002,   0.0000,   0.0000,   0.0000,   0.0000, 
     6     0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000/)
C  
      NVHCLES_SOAKING(1:18,47) = 
     7   (/0.0000,   0.0000,   0.0000,   0.0000,   0.0001,   0.0007, 
     7     0.0005,   0.0001,   0.0000,   0.0000,   0.0000,   0.0000, 
     7     0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000/)
C  
      NVHCLES_SOAKING(1:18,48) = 
     8   (/0.0000,   0.0000,   0.0000,   0.0000,   0.0001,   0.0007, 
     8     0.0005,   0.0001,   0.0000,   0.0000,   0.0000,   0.0000, 
     8     0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000/)
C  
      NVHCLES_SOAKING(1:18,49) = 
     9   (/0.0000,   0.0000,   0.0000,   0.0000,   0.0001,   0.0007, 
     9     0.0004,   0.0001,   0.0000,   0.0000,   0.0000,   0.0000, 
     9     0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000/)
C 
C IHR_SOAK = 50 
C  
      NVHCLES_SOAKING(1:18,50) = 
     Z   (/0.0000,   0.0000,   0.0000,   0.0000,   0.0001,   0.0006, 
     Z     0.0004,   0.0001,   0.0000,   0.0000,   0.0000,   0.0000, 
     Z     0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000/)
      
      NVHCLES_SOAKING(1:18,51) = 
     1   (/0.0000,   0.0000,   0.0000,   0.0000,   0.0001,   0.0006, 
     1     0.0004,   0.0001,   0.0000,   0.0000,   0.0000,   0.0000, 
     1     0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000/)
C  
      NVHCLES_SOAKING(1:18,52) = 
     2   (/0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0006, 
     2     0.0004,   0.0001,   0.0000,   0.0000,   0.0000,   0.0000, 
     2     0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000/)
C  
      NVHCLES_SOAKING(1:18,53) = 
     3   (/0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0005, 
     3     0.0003,   0.0001,   0.0000,   0.0000,   0.0000,   0.0000, 
     3     0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000/)
C  
      NVHCLES_SOAKING(1:18,54) = 
     4   (/0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0005, 
     4     0.0003,   0.0001,   0.0000,   0.0000,   0.0000,   0.0000, 
     4     0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000/)
C  
      NVHCLES_SOAKING(1:18,55) = 
     5   (/0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0005, 
     5     0.0003,   0.0001,   0.0000,   0.0000,   0.0000,   0.0000, 
     5     0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000/)
C  
      NVHCLES_SOAKING(1:18,56) = 
     6   (/0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0005, 
     6     0.0003,   0.0001,   0.0000,   0.0000,   0.0000,   0.0000, 
     6     0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000/)
C  
      NVHCLES_SOAKING(1:18,57) = 
     7   (/0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0005, 
     7     0.0003,   0.0001,   0.0000,   0.0000,   0.0000,   0.0000, 
     7     0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000/)
C  
      NVHCLES_SOAKING(1:18,58) = 
     8   (/0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0004, 
     8     0.0003,   0.0001,   0.0000,   0.0000,   0.0000,   0.0000, 
     8     0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000/)
C  
      NVHCLES_SOAKING(1:18,59) = 
     9   (/0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0004, 
     9     0.0002,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000, 
     9     0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000/)
C 
C IHR_SOAK = 60
C  
      NVHCLES_SOAKING(1:18,60) = 
     Z   (/0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0004, 
     Z     0.0002,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000, 
     Z     0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000/)
      
      NVHCLES_SOAKING(1:18,61) = 
     1   (/0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0004, 
     1     0.0002,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000, 
     1     0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000/)
C  
      NVHCLES_SOAKING(1:18,62) = 
     2   (/0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0004, 
     2     0.0002,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000, 
     2     0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000/)
C  
      NVHCLES_SOAKING(1:18,63) = 
     3   (/0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0003, 
     3     0.0002,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000, 
     3     0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000/)
C  
      NVHCLES_SOAKING(1:18,64) = 
     4   (/0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0003, 
     4     0.0002,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000, 
     4     0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000/)
C  
      NVHCLES_SOAKING(1:18,65) = 
     5   (/0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0003, 
     5     0.0002,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000, 
     5     0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000/)
C  
      NVHCLES_SOAKING(1:18,66) = 
     6   (/0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0003, 
     6     0.0002,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000, 
     6     0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000/)
C  
      NVHCLES_SOAKING(1:18,67) = 
     7   (/0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0003, 
     7     0.0002,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000, 
     7     0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000/)
C  
      NVHCLES_SOAKING(1:18,68) = 
     8   (/0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0003, 
     8     0.0002,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000, 
     8     0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000/)
C 
      NVHCLES_SOAKING(1:18,69) =  
     9   (/0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0003, 
     9     0.0002,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000, 
     9     0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000/)
C 
C IHR_SOAK = 70 
C  
      NVHCLES_SOAKING(1:18,70) = 
     Z   (/0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0003, 
     Z     0.0001,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000, 
     Z     0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000/)
      
      NVHCLES_SOAKING(1:18,71) = 
     1   (/0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0002, 
     1     0.0001,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000, 
     1     0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000/)
C  
      NVHCLES_SOAKING(1:18,72) = 
     2   (/0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0002, 
     2     0.0001,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000, 
     2     0.0000,   0.0000,   0.0000,   0.0000,   0.0000,   0.0000/)
C 
      RETURN 
      END SUBROUTINE ININVEH 
 
