      SUBROUTINE INITAP 
C 
C  INITAP is use to repeatedly re-initialize the AER array 
C 
C  Called by REINIT, and TAMPER 
C 
C  Changes: (Last change first) 
C 
C  20 Nov 98 @DynTel-ZK 2-000 Explicit Typing 
C 
C  Input on call: 
C 
C    Common blocks: 
C    /EGSCAL/ AER 
C 
C  Output on return: 
C 
C    Common blocks: 
C    /EGSCAL/ AER 
C 
C 
C  Notes: 
C 
C  This subroutine was added to MOBILE5.3 to facilitate the IM240 catalyst 
C  check.  It is called to flip back and forth from ATP to IM240 cases. 
C 
      IMPLICIT NONE  
C 
      INCLUDE 'EGSCAL.I' 
C 
      INTEGER IAY, IHG, IC2, IC1 
C       
      DO 40 IAY=1,2 
        DO 30 IHG=1,2 
          DO 20 IC2=1,11 
            DO 10 IC1=1,11 
              AER(IC1,IC2,IHG,IAY)=0.0 
              IF(IC1.EQ.IC2) AER(IC1,IC2,IHG,IAY)=1.0 
   10       CONTINUE 
   20     CONTINUE 
C 
   30   CONTINUE 
   40 CONTINUE 
      RETURN 
      END 
