#!/bin/tcsh
#PBS -j oe
#PBS -r n

limit stacksize unlimited

## Manually set directory names [**change**]
setenv INSTALL_DIR "/garnet/work/cvy/package"
setenv MET_ROOT "/garnet/oaqps/met/MCIP_v3.4b4/MM5_2005b_14aL" # Change to point to your MCIP

setenv CASE "2017ct_ref_05b"
setenv RUN_MONTHS "1 2 3 4 5 6 7 8 9 10 11 12"
setenv SPINUP_DURATION "0"

## Grid parameters
setenv REGION_ABBREV "12WUS1"
setenv REGION_IOAPI_GRIDNAME "12WUS1_213X192"

## Derived directory and filenames
setenv OUT_ROOT "$INSTALL_DIR"
setenv PROJECT_ROOT "$INSTALL_DIR/tier3_prop"
setenv IMD_ROOT "$PROJECT_ROOT/$CASE/intermed"
setenv DAT_ROOT $INSTALL_DIR
setenv SMK_HOME "$INSTALL_DIR/smoke"
set caseinputs  = "$PROJECT_ROOT/$CASE/inputs"
set ge_dat = "$INSTALL_DIR/ge_dat"
set casescripts = "$INSTALL_DIR/tier3_prop/2017ct_ref_05b/scripts"
set runscripts = "$INSTALL_DIR/smoke/smoke2.7/scripts"
setenv RUNSET "$casescripts/run_settings_2017ct_ref_05b.txt"
setenv ASSIGNS_FILE "$INSTALL_DIR/smoke/smoke2.7/assigns/ASSIGNS.emf"

## EMF Command line client -- source environment variables needed and setup EMF JAVACMDLINE to java executable and EMF_PYTHON to python cmd line
setenv EMF_CLIENT false

## Parameters -- from Case summary 
setenv MODEL_LABEL "SMOKE2.7"
setenv EMF_AQM "CMAQ v4.7 N5c"
setenv EMF_SPC "cmaq_cb05_tx"
setenv BASE_YEAR "2005"
setenv EPI_STDATE_TIME "2005-01-01 00:00:00.0"
setenv EPI_ENDATE_TIME "2005-12-31 23:59:00.0"

## EMF specific variables - leave alone
setenv EMF_JOBID "7544"
setenv EMF_JOBNAME "Annual_ptipm_12WUS1_${CASE}"
setenv EMF_USER "bte"
setenv EMF_SCRIPTDIR "${casescripts}"
setenv EMF_SCRIPTNAME "${casescripts}/${EMF_JOBNAME}.csh"
setenv EMF_LOGNAME "${casescripts}/logs/$EMF_SCRIPTNAME.log"
setenv EMF_JOBKEY "7544_1237404676635"

## Ancillary files unlikely to change between sectors
setenv GRIDDESC "${ge_dat}/griddesc_lambertonly_20jul2011_v40.txt"
setenv COSTCY "${ge_dat}/costcy_for_2002_21oct2010_v5.txt"
setenv ORISDESC "${ge_dat}/orisdesc_04dec2006_v0.txt"
setenv PSTK "${ge_dat}/pstk_20nov2006_v0.txt"
setenv AGREF "${ge_dat}/amgref_us_can_mex_revised_29jul2011_v13.txt"
setenv MGREF "${ge_dat}/amgref_us_can_mex_revised_29jul2011_v13.txt"
setenv ATREF "${ge_dat}/amptref_v3_3_revised_17may2011_v12.txt"
setenv MTREF "${ge_dat}/amptref_v3_3_revised_17may2011_v12.txt"
setenv PTREF "${ge_dat}/amptref_v3_3_revised_17may2011_v12.txt"
setenv ATPRO "${ge_dat}/amptpro_2005_us_can_revised_10jan2011_v2.txt"
setenv MTPRO "${ge_dat}/amptpro_2005_us_can_revised_10jan2011_v2.txt"
setenv PTPRO "${ge_dat}/amptpro_2005_us_can_revised_10jan2011_v2.txt"
setenv SICDESC "${ge_dat}/sic_desc_04oct2006_v0.txt"
setenv SCCDESC "${ge_dat}/sccdesc_pf31_16may2011_v12.txt"
setenv ARTOPNT "${ge_dat}/artopnt_2002detroit_12jul2007_v0.txt"
setenv HOLIDAYS "${ge_dat}/holidays_04may2006_v0.txt"
setenv MCODES "${ge_dat}/mcodes_21nov2008_v1.txt"
setenv MACTDESC "${ge_dat}/mactdesc_2002v3_23apr2008_v1.txt"
setenv NAICSDESC "${ge_dat}/naicsdesc_02jan2008_v0.txt"
setenv GSPROTMP_A "${ge_dat}/spec_parts/gspro_cmaq_cb05_tx_2005ct_05b_nf.txt"
setenv GSREFTMP_A "${ge_dat}/spec_parts/gsref_cmaq_cb05_tx_2017ct_ref_05b_29jul2011.txt"
setenv GSCNV "${ge_dat}/gscnv_cb05_soa_29jul2011_v3.txt"
setenv GSPRO_COMBO "${ge_dat}/gspro_combo_2005_23feb2011_v6.txt"
setenv SRGDESC "${ge_dat}/srgdesc_36km_revised_17mar2009_v1.txt"
setenv MRGDATE_FILES "${runscripts}/smk_dates/2005/smk_merge_dates_200412.txt"
setenv INVTABLE "${ge_dat}/invtable_hapcap_cb05soa_18may2011_v12.txt"
setenv PELVCONFIG "${ge_dat}/pelvconfig_inline_allpts_26apr2010_v1.txt"
setenv REPCONFIG_INV "${ge_dat}/repconfig/repconfig_area_inv_caphap_08aug2008_v0.txt"
setenv REPCONFIG_INV2 "${ge_dat}/repconfig/repconfig_area_inv2_02jan2008_v0.txt"
setenv REPCONFIG_GRID "${ge_dat}/repconfig/repconfig_area_invgrid_caphap_05sep2008_v1.txt"

## Ancillary files likely to change between sectors
setenv INVTABLE "${ge_dat}/invtable_hapcap_cb05_no_bafm_11feb2011_v3.txt"
setenv PTREF "${ge_dat}/ptref_ptipm_us_29nov2006_v0.txt"
#setenv PELVCONFIG "${dirinputs}/ge_dat/pelvconfig_seca_c3_22jul2010_v1.txt"
setenv REPCONFIG_INV "${ge_dat}/repconfig/repconfig_point_inv_caphap_17aug2008_v0.txt"
setenv REPCONFIG_INV2 "${ge_dat}/repconfig/repconfig_point_inv2_13feb2008_v0.txt"
setenv REPCONFIG_GRID "${ge_dat}/repconfig/repconfig_point_invgrid_caphap_05sep2008_v1.txt"
setenv EMISINV_A "${caseinputs}/ptipm/ptinv_PTINV_EPA410FINAL_BC_58_summer_2020_21MAY2011_ORL_06jun2011_v0_orl.txt"
setenv EMISDAY_MULTI_A "${caseinputs}/ptipm/ptday/work/ptday_ptipm_caphap_noncem_2017ct_05b_28feb_ida.txt"
setenv EMISDAY_MULTI_B "${caseinputs}/ptipm/ptday/work/ptday_ptipm_caphap_cem_2017ct_05b_28feb_ida.txt"
#setenv NHAPEXCLUDE "${ge_dat}/nhapexclude_ptnonipm_include_30125010_19may2011_v0.txt"
#setenv ATREF "${ge_dat}/amptref_v3_3_revised_13mar2009_v1.txt"
#etenv GSPRO_COMBO "${ge_dat}/gspro_combo_tier3_2005_base_nonpt_v2_26may2011_v2.txt"
#setenv GSPROTMP_A "${ge_dat}/spec_parts/gspro_nonpt_cmaq_cb05_tx_2005ct_05b_23may2011.txt"
#setenv SRGDESC "${ge_dat}/srgdesc_12km_07jun2010_v2.txt"
#setenv GSREFTMP_A "${ge_dat}/spec_parts/gsref_ptipm_cmaq_cb05_tx_2005ct_05b_07jun2011.txt"

## Ancillary files likely to change between grids
setenv SECTORLIST "${casescripts}/sectorlist_2017ct_ref_05b_02aug2011_v0"

## Parameters -- from job tab
setenv SECTOR "ptipm"

## Parameters -- all regions, all sectors, all jobs 
setenv EMF_QUEUE_OPTIONS "-A mobile -q romo -W group_list=romo -W umask=022"
setenv PROJECT "tier3_prop"
setenv SMK_EMLAYS "10"
setenv SPC "$EMF_SPC"
setenv PLATFORM "v4.3"
setenv EGU_TYPE "model_performance"
setenv MCIPNAME "MCIP_v3.4beta4"
setenv RUN_PYTHON_ANNUAL "Y"
setenv INLINE_MODE "both"
setenv SMK_PING_METHOD "0"
setenv SMK_SPECELEV_YN "Y"
setenv RAW_DUP_CHECK "Y"
setenv M_TYPE "mwdss"
setenv L_TYPE "mwdss"
setenv RUN_HOLIDAYS "Y"
setenv FULLSCC_ONLY "Y"
setenv SMK_MAXERROR "10000"
setenv SMK_MAXWARNING "10"
setenv SMK_AVEDAY_YN "N"
setenv REPORT_DEFAULTS "Y"
setenv SMK_DEFAULT_SRGID "100"
setenv SMKINVEN_FORMULA "PMC=PM10-PM2_5"
setenv FILL_ANNUAL "N"
setenv MRG_MARKETPEN_YN "N"
setenv WEST_HSPHERE "Y"
setenv ALL_MONTHS "1 2 3 4 5 6 7 8 9 10 11 12"
setenv MRG_REPCNY_YN "N"
setenv EMF_LOGGERPYTHONDIR "$EMF_SCRIPTDIR/case_logs_python"
setenv OUTZONE "0"
setenv RENORM_TPROF "Y"
setenv POLLUTANT_CONVERSION "Y"
setenv IOAPI_ISPH "19"
setenv MRG_REPSTA_YN "Y"
setenv SMKMERGE_CUSTOM_OUTPUT "Y"
setenv OUTPUT_FORMAT "$EMF_AQM"

## Parameters -- sector-specific
setenv L_TYPE "all"
setenv M_TYPE "all"
#setenv RUN_HOLIDAYS "N"
#setenv SMK_DEFAULT_SRGID "340"
#setenv NONHAP_TYPE "VOC"
#setenv SMKINVEN_FORMULA "EXH__PMC=EXH__PM10-EXH__PM2_5"
setenv SORT_LIST_EVS "Y"
#setenv SMK_PROCESS_HAPS "PARTIAL"
#setenv SMK_ARTOPNT_YN "Y"
#setenv FILL_ANNUAL "Y"
setenv RAW_DUP_CHECK "N"
#setenv NO_SPC_ZERO_EMIS "Y"
setenv ZIPOUT "Y"
#setenv MRG_BYDAY "P"
setenv NAMEBREAK_DAILY "9" # [**Note 1P**]
setenv DAY_SPECIFIC_YN "Y"
setenv WRITE_ANN_ZERO "Y"

if ($REGION_ABBREV == "36US1") then
   setenv SRGPRO "${ge_dat}/36US1_surg/"
else
   setenv SRGPRO "${ge_dat}/12km_surg_revised/"
endif

## job executable
$runscripts/emf/smk_pt_daily_emf.csh $REGION_ABBREV $REGION_IOAPI_GRIDNAME -m "$RUN_MONTHS" $SPINUP_DURATION all
if ( $status != 0 ) then
	 $EMF_CLIENT -k $EMF_JOBKEY -s 'Failed' -m "ERROR running Job: $EMF_JOBNAME" -t 'e' 
	 exit(1)
else
	 $EMF_CLIENT -k $EMF_JOBKEY -s 'Completed' -m "Completed job: $EMF_JOBNAME"
endif

