#!/bin/csh -f
#PBS -j oe
#PBS -r n

limit stacksize unlimited
## Manually set directory names [**change**]
setenv INSTALL_DIR "/garnet/work/ozl/packages"
setenv MET_ROOT "/garnet/oaqps/met/MCIP_v3.4b4/MM5_2005b_14aL" # Change to point to your MCIP

setenv CASE "2007ee_v5_07c"
setenv RUN_MONTHS "1 2 3 4 5 6 7 8 9 10 11 12"
setenv SPINUP_DURATION "10"

## Grid parameters
setenv REGION_ABBREV "12US1"
setenv REGION_IOAPI_GRIDNAME "12US1_459X299"


## Derived directory and filenames
setenv PROJECT "2007ee_v5_07c"

setenv OUT_ROOT "$INSTALL_DIR"
setenv PROJECT_ROOT "$INSTALL_DIR/2007ee_v5_07c"
setenv IMD_ROOT "$PROJECT_ROOT/$PROJECT/intermed"
setenv DAT_ROOT $PROJECT_ROOT/$CASE
setenv SMK_HOME "$INSTALL_DIR/smoke"
set caseinputs  = "$PROJECT_ROOT/$CASE/inputs"
set ge_dat = "$INSTALL_DIR/2007ee_v5_07c/ge_dat"
set casescripts = "$INSTALL_DIR/2007ee_v5_07c/scripts"
set runscripts = "$INSTALL_DIR/smoke/smoke3.1/scripts"
setenv RUNSET "$casescripts/run_settings_2007ee_v5_07c.txt"
setenv ASSIGNS_FILE "$INSTALL_DIR/smoke/smoke3.1/assigns/ASSIGNS.emf"

## EMF Command line client -- source environment variables needed and setup EMF JAVACMDLINE to java executable and EMF_PYTHON to python cmd line
setenv EMF_CLIENT false

## Parameters -- from Case summary 
setenv MODEL_LABEL "SMOKE3.1"
setenv EMF_AQM "CMAQ v4.7 N1c"
setenv EMF_SPC "cmaq_cb05_soa"
setenv BASE_YEAR "2007"
setenv EPI_STDATE_TIME "2007-01-01 00:00:00.0"
setenv EPI_ENDATE_TIME "2007-12-31 23:59:00.0"

## EMF specific variables - leave alone
setenv EMF_JOBNAME "Annual_area"
setenv EMF_SCRIPTDIR "${casescripts}"
setenv EMF_SCRIPTNAME "${casescripts}/${EMF_JOBNAME}.csh"
setenv EMF_LOGNAME "${casescripts}/logs/$EMF_SCRIPTNAME.log"
setenv EMF_JOBKEY "28310_1312400444602"

## Ancillary files unlikely to change between sectors
setenv GRIDDESC "${ge_dat}/griddesc_lambertonly_06apr2012_v45.txt"
setenv NAICSDESC "${ge_dat}/naicsdesc_02jan2008_v0.txt"
setenv COSTCY "${ge_dat}/costcy_for_2007platform_16feb2012_nf_v3.txt"
setenv HOLIDAYS "${ge_dat}/holidays_04may2006_v0.txt"
setenv MACTDESC "${ge_dat}/mactdesc_2002v3_23apr2008_v1.txt"
setenv GSCNV "${ge_dat}/speciation/${CASE}/gscnv_nonpt_cmaq_cb05_soa_2007ee_v5_07c_12nov2009.txt"
setenv INVTABLE "${ge_dat}/invtable_hapcapintegate_cb05soa_nomp_nohg_09feb2012_v8.txt"
setenv MGREF "${ge_dat}/amgref_us_can_mex_revised_28jun2012_nf_v20.txt"
setenv AGREF "${ge_dat}/amgref_us_can_mex_revised_20jul2012_v21.txt"
setenv PELVCONFIG "${ge_dat}/pelvconfig_inline_allpts_26apr2010_v1.txt"
setenv SICDESC "${ge_dat}/sic_desc_04oct2006_v0.txt"
setenv ATPRO "${ge_dat}/amptpro_2008aa_us_can_revised_21jun2012_v2.txt"
setenv MTPRO "${ge_dat}/amptpro_2008aa_us_can_revised_21jun2012_v2.txt"
setenv MCODES "${ge_dat}/mcodes_22nov2011_nf_v4.txt"
setenv SRGDESC "${ge_dat}/srgdesc_CONUS12_2010_03jul2012_v3.txt"
setenv PSTK "${ge_dat}/pstk_20nov2006_v0.txt"
setenv ARTOPNT "${ge_dat}/artopnt_2002detroit_12jul2007_v0.txt"
setenv AGREF "${ge_dat}/amgref_us_can_mex_revised_20jul2012_v21.txt"
setenv SCCDESC "${ge_dat}/sccdesc_pf31_28jun2012_nf_v15.txt"
setenv MTREF "${ge_dat}/Gentpro_TREF_agNH3_RWC_2007ee.txt"
setenv ORISDESC "${ge_dat}/orisdesc_04dec2006_v0.txt"
setenv MRGDATE_FILES "${ge_dat}/smk_dates/2007/smk_merge_dates_200612.txt"
setenv PTPRO "${ge_dat}/amptpro_2007ec_us_can_revised_15may2012_v0.txt"
setenv PTREF "${ge_dat}/Gentpro_TREF_agNH3_RWC_2007ee.txt"
setenv GSPRO_COMBO "${ge_dat}/gspro_combo_2005_09sep2008_v2.txt"

setenv NHAPEXCLUDE "${ge_dat}/nhapexclude_2008V2_nonpt_26jul2012_v4.txt"

setenv GSREFTMP_A "${ge_dat}/speciation/${CASE}/gsref_nonpt_cmaq_cb05_soa_2007ee_v5_07c_24jul2012.txt"
setenv GSPROTMP_A "${ge_dat}/speciation/${CASE}/gspro_nonpt_cmaq_cb05_soa_2007ee_v5_07c_17jul2012.txt"

setenv SECTOR "nonpt"
setenv REGION "Continental US 12km"

setenv REPCONFIG_GRID "${ge_dat}/repconfig/default/repconfig_area_invgrid_caphap_05sep2008_v1.txt"
setenv REPCONFIG_INV2 "${ge_dat}/repconfig/default/repconfig_area_inv2_02jan2008_v0.txt"

setenv REPCONFIG_INV "${ge_dat}/repconfig/default/repconfig_alm_inv_caphap_01sep2008_v0.txt"
setenv GSPRO_COMBO "${ge_dat}/gspro_combo_2007platform_2007eb_nonpt_09apr2012_v7.txt"
setenv TPRO_DAY "${ge_dat}/Gentpro_TPRO_DAY_DAILY_RWC.RWC_2007ed_v5_official.txt"
setenv ATREF "${ge_dat}/Gentpro_TREF_DAILY_RWC.RWC_2007ed.txt"
setenv EMISINV_A "$caseinputs/${SECTOR}/2008NEI_v2_NONPOINT_nonpt_remaining_run5_fixed_OHH_ff10_25jul2012_v0.csv"
setenv EMISINV_C "$caseinputs/${SECTOR}/2008NEI_v2_NONPOINT_PFC_08mar2012_v1.csv"
setenv EMISINV_B "$caseinputs/${SECTOR}/2008_agburn_fromdaily_FF10_22feb2012_23feb2012_v0.csv"
setenv EMISINV_E "$caseinputs/${SECTOR}/2006_WRAP_PhaseIII_OIL_GAS_Area_20jul2012_v1.csv"
setenv EMISINV_F "$caseinputs/${SECTOR}/openburning_landclearing_FLGA_sesarm2007_ff10_09jul2012_v2.csv"
setenv EMISINV_G "$caseinputs/${SECTOR}/RWC_3SCCs_LADCO2008_fixed_ff10_25jul2012_v0.csv"
setenv EMISINV_I "$caseinputs/${SECTOR}/SESARM_RWC_2007_fixed_ff10_25jul2012_v0.csv"
setenv EMISINV_J "$caseinputs/${SECTOR}/MARAMA_open_burning_2007_22jun2012_v0.csv"
setenv EMISINV_H "$caseinputs/${SECTOR}/NYPA_RWC_2007_fixed_ff10_25jul2012_v0.csv"






## Parameters -- all regions, all sectors, all jobs
setenv OUTZONE "0"
setenv MCIPNAME "MCIP_v3.6"
setenv ALL_MONTHS "1 2 3 4 5 6 7 8 9 10 11 12"
setenv REPORT_DEFAULTS "Y"
setenv FULLSCC_ONLY "Y"
setenv SMK_PING_METHOD "0"
setenv SMKINVEN_FORMULA "PMC=PM10-PM2_5"
setenv POLLUTANT_CONVERSION "Y"
setenv EMF_LOGGERPYTHONDIR "$EMF_SCRIPTDIR/case_logs_python"
setenv WEST_HSPHERE "Y"
setenv RENORM_TPROF "Y"
setenv PLATFORM "v5"
setenv EMF_QUEUE_OPTIONS "-A mobile -q romo -W group_list=romo -W umask=022"
#setenv SMK_SPECELEV_YN "Y"
setenv MRG_REPSTA_YN "Y"
setenv SMK_MAXWARNING "10"
setenv SPC "$EMF_SPC"
setenv RUN_PYTHON_ANNUAL "Y"
#setenv INLINE_MODE "both"
setenv EGU_TYPE "model_performance"
setenv OUTPUT_FORMAT "$EMF_AQM"
setenv IOAPI_ISPH "20"
setenv SMK_MAXERROR "10000"
setenv MRG_REPCNY_YN "N"
setenv SMK_EMLAYS "24"
setenv SMK_AVEDAY_YN "N"
setenv MRG_MARKETPEN_YN "N"




## Parameters -- sector/region/job specific
setenv RUN_HOLIDAYS "Y"
setenv SMK_DEFAULT_SRGID "100"
setenv FUTURE_YEAR "2007"
setenv SPINUP_DURATION "0"
setenv SMKMERGE_CUSTOM_OUTPUT "Y"
setenv SMK_ARTOPNT_YN "Y"
setenv TPRO_HOUR "${ge_dat}/Gentpro_TPRO_HOUR_HOURLY_AGNH3.agNH3_2007eb_7may2012.ncf"


setenv SPINUP_DURATION "0"
setenv FILL_ANNUAL "Y"
setenv SMK_ARTOPNT_YN "Y"
setenv L_TYPE "all"
setenv M_TYPE "all"
setenv RAW_DUP_CHECK "N"
setenv NONHAP_TYPE "VOC"
setenv SMK_PROCESS_HAPS "PARTIAL"
setenv NO_SPC_ZERO_EMIS "Y"
setenv HOURLY_TPROF_BASE "MONTH"


setenv SRGPRO "${ge_dat}/CONUS12_2010_v2_20120625/"


$runscripts/emf/smk_ar_monthly_emf.csh $REGION_ABBREV $REGION_IOAPI_GRIDNAME -m 1 $SPINUP_DURATION q1

if ( $status != 0 ) then
         $EMF_CLIENT -k $EMF_JOBKEY -s 'Failed' -m "ERROR running Job: $EMF_JOBNAME" -t 'e'
         exit(1)
else
         $EMF_CLIENT -k $EMF_JOBKEY -s 'Completed' -m "Completed job: $EMF_JOBNAME"
endif

