#!/bin/tcsh
#PBS -j oe
#PBS -r n

limit stacksize unlimited

## Manually set directory names [**change**]
setenv INSTALL_DIR "/garnet/work/ozl/packages/2007ee_v5_07c"
setenv MET_ROOT "/garnet/oaqps/met/MCIP_v3.6/WRF_2007c_24aL" # Change to point to your MCIP

setenv CASE "2007ee_v5_07c"
setenv RUN_MONTHS "1 2 3 4 5 6 7 8 9 10 11 12"
setenv SPINUP_DURATION "0"

## Grid parameters
setenv REGION_ABBREV "12US1"
setenv REGION_IOAPI_GRIDNAME "12US1_459X299"

## Derived directory and filenames
setenv OUT_ROOT "$INSTALL_DIR"
setenv PROJECT_ROOT "$INSTALL_DIR/2007platform"
setenv IMD_ROOT "$PROJECT_ROOT/$CASE/intermed"
setenv DAT_ROOT $INSTALL_DIR
setenv SMK_HOME "$INSTALL_DIR/smoke"
set caseinputs  = "$PROJECT_ROOT/$CASE/inputs"
set ge_dat = "$INSTALL_DIR/ge_dat"
set casescripts = "$INSTALL_DIR/2007platform/2007ee_v5_07c/scripts"
set runscripts = "$INSTALL_DIR/smoke/smoke3.1/scripts"
setenv RUNSET "$casescripts/run_settings_2007ee_v5_07c.txt"
setenv ASSIGNS_FILE "$INSTALL_DIR/smoke/smoke3.1/assigns/ASSIGNS.emf"

## EMF Command line client -- source environment variables needed and setup EMF JAVACMDLINE to java executable and EMF_PYTHON to python cmd line
setenv EMF_CLIENT false

## Parameters -- from Case summary 
setenv MODEL_LABEL "SMOKE3.1"
setenv EMF_AQM "CMAQ v4.7 N1c"
setenv EMF_SPC "cmaq_cb05_soa"
setenv BASE_YEAR "2007"
setenv EPI_STDATE_TIME "2007-01-01 00:00:00.0"
setenv EPI_ENDATE_TIME "2007-12-31 23:59:00.0"

## EMF specific variables - leave alone
setenv EMF_JOBNAME "Annual_point_onetime"
setenv EMF_SCRIPTDIR "${casescripts}"
setenv EMF_SCRIPTNAME "${casescripts}/${EMF_JOBNAME}.csh"
setenv EMF_LOGNAME "${casescripts}/logs/$EMF_SCRIPTNAME.log"
setenv EMF_JOBKEY "34019_1342533331044"

## Ancillary files unlikely to change between sectors
setenv ATREF "${ge_dat}/work/Gentpro_TREF_agNH3_RWC_2007ed.txt"
setenv NAICSDESC "${ge_dat}/naicsdesc_02jan2008_v0.txt"
setenv HOLIDAYS "${ge_dat}/holidays_04may2006_v0.txt"
setenv GRIDDESC "${ge_dat}/griddesc_lambertonly_06apr2012_v45.txt"
setenv MACTDESC "${ge_dat}/mactdesc_2002v3_23apr2008_v1.txt"
setenv GSREFTMP_A "${ge_dat}/../spec_parts/gsref_ptipm_cmaq_cb05_soa_2007ee_v5_10c_23aug2012.txt"
setenv ATPRO "${ge_dat}/amptpro_2008aa_us_can_revised_21jun2012_v2.txt"
setenv MGREF "${ge_dat}/amgref_us_can_mex_revised_28jun2012_nf_v20.txt"
setenv GSCNVTMP_C "${ge_dat}/gscnv_cmaq_cb05_hspace_toxic_12nov2009_v0.txt"
setenv GSCNVTMP_B "${ge_dat}/gscnv_cmaq_cb05_hspace_BAF_12nov2009_v0.txt"
setenv GSCNVTMP_A "${ge_dat}/gscnv_cmaq_cb05_tx_pf4_23aug2009_v3.txt"
setenv PELVCONFIG "${ge_dat}/pelvconfig_inline_allpts_26apr2010_v1.txt"
setenv SICDESC "${ge_dat}/sic_desc_04oct2006_v0.txt"
setenv ARTOPNT "${ge_dat}/artopnt_2002detroit_12jul2007_v0.txt"
setenv MTPRO "${ge_dat}/amptpro_2008aa_us_can_revised_21jun2012_v2.txt"
setenv MCODES "${ge_dat}/mcodes_22nov2011_nf_v4.txt"
setenv PTPRO "${ge_dat}/amptpro_2007ec_us_can_revised_15may2012_v0.txt"
setenv SRGDESC "${ge_dat}/srgdesc_CONUS12_2010_03jul2012_v3.txt"
setenv AGREF "${ge_dat}/amgref_us_can_mex_revised_28jun2012_nf_v20.txt"
setenv SCCDESC "${ge_dat}/sccdesc_pf31_28jun2012_nf_v15.txt"
setenv COSTCY "${ge_dat}/costcy_for_2007platform_16feb2012_nf_v3.txt"
setenv MTREF "${ge_dat}/work/Gentpro_TREF_agNH3_RWC_2007ed.txt"
setenv ORISDESC "${ge_dat}/orisdesc_04dec2006_v0.txt"
setenv MRGDATE_FILES "${ge_dat}/smk_dates/2007/smk_merge_dates_200612.txt"
setenv GSPROTMP_A "${ge_dat}/../spec_parts/gspro_ptipm_cmaq_cb05_soa_2007ee_v5_10c_17jul2012.txt"
setenv PSTK "${ge_dat}/pstk_20nov2006_v0.txt"
setenv GSPRO_COMBO "${ge_dat}/gspro_combo_2005_09sep2008_v2.txt"

## Ancillary files likely to change between sectors
setenv EMISHOUR_MULTI_A "/garnet/oaqps/em_v5/cem/2007_17mar2011/HOUR_UNIT_2006_12_31dec.txt"
setenv EMISDAY_MULTI_A "${caseinputs}/ptipm/ptday/work/ptday_ptipm_capcl_noncem_2007ee_28feb_ida.txt"
setenv CEMSUM "/garnet/work/ozl/CEM/2007_17mar2011/cemsum_2007_revised.dat"
setenv REPCONFIG_INV2 "${ge_dat}/repconfig/default/repconfig_point_inv2_13feb2008_v0.txt"
setenv REPCONFIG_GRID "${ge_dat}/repconfig/default/repconfig_point_invgrid_caphap_05sep2008_v1.txt"
setenv REPCONFIG_INV "${ge_dat}/repconfig/default/repconfig_point_inv_caphap_17aug2008_v0.txt"
setenv INVTABLE "${ge_dat}/invtable_hapcapnohapuse_cb05soa_nomp_nohg_09feb2012_v2.txt"
setenv EMISINV_A "${caseinputs}/ptipm/2008NEI_v2_POINT_20120202_for2007ee_ptipm_FF10_16jul2012_v0.csv"
setenv PTREF "${ge_dat}/ptref_ptipm_us_29nov2006_v0.txt"

## Ancillary files likely to change between grids
setenv SECTORLIST "${casescripts}/sectorlist_2007ec_v5_07c_29may2012_v2"

## Parameters -- from job tab
setenv SECTOR "ptipm"

## Parameters -- all regions, all sectors, all jobs
setenv PROJECT "2007platform"
setenv OUTZONE "0"
setenv MCIPNAME "MCIP_v3.6"
setenv ALL_MONTHS "1 2 3 4 5 6 7 8 9 10 11 12"
setenv REPORT_DEFAULTS "Y"
setenv SMKMERGE_CUSTOM_OUTPUT "Y"
setenv FULLSCC_ONLY "Y"
setenv SMK_PING_METHOD "0"
setenv SMKINVEN_FORMULA "PMC=PM10-PM2_5"
setenv POLLUTANT_CONVERSION "Y"
setenv FILL_ANNUAL "N"
setenv EMF_LOGGERPYTHONDIR "$EMF_SCRIPTDIR/case_logs_python"
setenv WEST_HSPHERE "Y"
setenv RENORM_TPROF "Y"
setenv PLATFORM "v5"
setenv EMF_QUEUE_OPTIONS "-A plateval -q romo -W group_list=romo -W umask=022"
setenv SMK_SPECELEV_YN "Y"
setenv MRG_REPSTA_YN "Y"
setenv SMK_MAXWARNING "10"
setenv SPC "$EMF_SPC"
setenv RUN_PYTHON_ANNUAL "Y"
setenv INLINE_MODE "both"
setenv EGU_TYPE "model_performance"
setenv OUTPUT_FORMAT "$EMF_AQM"
setenv RUN_HOLIDAYS "Y"
setenv IOAPI_ISPH "20"
setenv SMK_MAXERROR "10000"
setenv SMK_DEFAULT_SRGID "100"
setenv MRG_REPCNY_YN "N"
setenv SMK_EMLAYS "24"
setenv SMK_AVEDAY_YN "N"
setenv MRG_MARKETPEN_YN "N"

## Parameters -- sector/region/job specific
setenv NAMEBREAK_HOURLY "4"
setenv SORT_LIST_EVS "Y"
setenv M_TYPE "all"
setenv PARENT_CASE "2007ed_v5_07c"
setenv HOURLY_PREFIX "HOUR_UNIT"
setenv ZIPOUT "Y"
setenv RAW_DUP_CHECK "N"
setenv DAILY_CASE "2005ck"
setenv WRITE_ANN_ZERO "Y"
setenv L_TYPE "all"
setenv DAY_SPECIFIC_YN "N"
setenv NAMEBREAK_DAILY "8"
setenv FUTURE_YEAR "2007"
setenv SPINUP_DURATION "0"
setenv HOUR_SPECIFIC_YN "N"


if ($REGION_ABBREV == "36US1") then
   setenv SRGPRO "${ge_dat}/36US1_surg/"
else
   setenv SRGPRO "${ge_dat}/CONUS12_2010/"
endif


$runscripts/emf/smk_pt_annual_onetime_emf.csh $REGION_ABBREV $REGION_IOAPI_GRIDNAME onetime 
if ( $status != 0 ) then
         $EMF_CLIENT -k $EMF_JOBKEY -s 'Failed' -m "ERROR running Job: $EMF_JOBNAME" -t 'e'
         exit(1)
else
         $EMF_CLIENT -k $EMF_JOBKEY -s 'Completed' -m "Completed job: $EMF_JOBNAME"
endif

