#!/bin/csh -f
#PBS -j oe
#PBS -r n

limit stacksize unlimited
## Manually set directory names [**change**]
setenv INSTALL_DIR "/garnet/work/ozl/packages"
setenv MET_ROOT "/garnet/oaqps/met/MCIP_v3.6/WRF_2007c_24aL" # Change to point to your MCIP
 


setenv CASE "2020re_v5_07c"
#setenv RUN_MONTHS "1 2 3 4 5 6 7 8 9 10 11 12"
setenv RUN_MONTHS 1
setenv SPINUP_DURATION "10"

## Grid parameters
setenv REGION "Continental US 12km small"
setenv REGION_ABBREV "12US2"
setenv REGION_IOAPI_GRIDNAME "12US2"


## Derived directory and filenames
setenv PROJECT "2020re_v5_07c"

setenv OUT_ROOT "$INSTALL_DIR"
setenv PROJECT_ROOT "$INSTALL_DIR/2020re_v5_07c"
setenv IMD_ROOT "$PROJECT_ROOT/$PROJECT/intermed"
setenv DAT_ROOT $PROJECT_ROOT/$CASE
setenv SMK_HOME "$INSTALL_DIR/smoke"
set caseinputs  = "$PROJECT_ROOT/$CASE/inputs"
set ge_dat = "$INSTALL_DIR/2007ee_v5_07c/ge_dat"
set casescripts = "$INSTALL_DIR/2020re_v5_07c/scripts"
set runscripts = "$INSTALL_DIR/smoke/smoke3.1/scripts"
setenv RUNSET "$casescripts/run_settings_${CASE}.txt"
setenv ASSIGNS_FILE "$INSTALL_DIR/smoke/smoke3.1/assigns/ASSIGNS.emf"

## EMF Command line client -- source environment variables needed and setup EMF JAVACMDLINE to java executable and EMF_PYTHON to python cmd line
setenv EMF_CLIENT false


## Parameters -- from Case summary 
setenv MODEL_LABEL "SMOKE3.1"
setenv EMF_AQM "CMAQ v4.7 N1c"
setenv EMF_SPC "cmaq_cb05_soa"
setenv BASE_YEAR "2007"
setenv EPI_STDATE_TIME "2007-01-01 00:00:00.0"
setenv EPI_ENDATE_TIME "2007-12-31 23:59:00.0"

## EMF specific variables - leave alone
setenv EMF_JOBNAME "Annual_area"
setenv EMF_SCRIPTDIR "${casescripts}"
setenv EMF_SCRIPTNAME "${casescripts}/${EMF_JOBNAME}.csh"
setenv EMF_LOGNAME "${casescripts}/logs/$EMF_SCRIPTNAME.log"
setenv EMF_JOBKEY "28310_1312400444602"

## Ancillary files unlikely to change between sectors
setenv GRIDDESC "${ge_dat}/griddesc_lambertonly_06apr2012_v45.txt"
setenv NAICSDESC "${ge_dat}/naicsdesc_02jan2008_v0.txt"
setenv COSTCY "${ge_dat}/costcy_for_2007platform_16feb2012_nf_v3.txt"
setenv HOLIDAYS "${ge_dat}/holidays_04may2006_v0.txt"
setenv ATREF "${ge_dat}/Gentpro_TREF_agNH3_RWC_2007ed.txt"
setenv MACTDESC "${ge_dat}/mactdesc_2002v3_23apr2008_v1.txt"
setenv REPCONFIG_GRID "${ge_dat}/repconfig/default/repconfig_area_invgrid_caphap_scc7_22mar2012_v0.txt"
setenv GSCNV "${ge_dat}/gscnv_cb05_soa_29jul2011_v2.txt"
setenv GSREFTMP_A "${ge_dat}/speciation/${CASE}/gsref_afdust_cmaq_cb05_soa_2007ed_v5_07c_nf.txt"
setenv INVTABLE "${ge_dat}/invtable_hapcapintegate_cb05soa_nomp_nohg_09feb2012_v8.txt"
setenv MGREF "${ge_dat}/amgref_us_can_mex_revised_28jun2012_nf_v20.txt"
setenv AGREF "${ge_dat}/amgref_us_can_mex_revised_28jun2012_nf_v20.txt"
setenv REPCONFIG_INV2 "${ge_dat}/repconfig/default/repconfig_area_inv2_02jan2008_v0.txt"
setenv PELVCONFIG "${ge_dat}/pelvconfig_inline_allpts_26apr2010_v1.txt"
setenv SICDESC "${ge_dat}/sic_desc_04oct2006_v0.txt"
setenv ATPRO "${ge_dat}/amptpro_2008aa_us_can_revised_21jun2012_v2.txt"
setenv MTPRO "${ge_dat}/amptpro_2008aa_us_can_revised_21jun2012_v2.txt"
setenv MCODES "${ge_dat}/mcodes_22nov2011_nf_v4.txt"
setenv SRGDESC "${ge_dat}/srgdesc_CONUS12_2010_26jun2012_v2.txt"
setenv PSTK "${ge_dat}/pstk_20nov2006_v0.txt"
setenv ARTOPNT "${ge_dat}/artopnt_2002detroit_12jul2007_v0.txt"
setenv AGREF "${ge_dat}/amgref_us_can_mex_revised_28jun2012_nf_v20.txt"
setenv SCCDESC "${ge_dat}/sccdesc_pf31_28jun2012_nf_v15.txt"
setenv MTREF "${ge_dat}/Gentpro_TREF_agNH3_RWC_2007ed.txt"
setenv ORISDESC "${ge_dat}/orisdesc_04dec2006_v0.txt"
setenv MRGDATE_FILES "${ge_dat}/smk_dates/2007/smk_merge_dates_200612.txt"
setenv GSPROTMP_A "${ge_dat}/speciation/${CASE}/gspro_afdust_cmaq_cb05_soa_2007ed_v5_07c_04apr2012.txt"
setenv REPCONFIG_INV "${ge_dat}/repconfig/default/repconfig_alm_inv_caphap_01sep2008_v0.txt"
setenv PTPRO "${ge_dat}/amptpro_2007ec_us_can_revised_15may2012_v0.txt"
setenv PTREF "${ge_dat}/Gentpro_TREF_agNH3_RWC_2007ed.txt"
setenv GSPRO_COMBO "${ge_dat}/gspro_combo_2005_09sep2008_v2.txt"


setenv GSREFTMP_A "${ge_dat}/speciation/${CASE}/gsref_afdust_cmaq_cb05_soa_2020re_v5_07c_26jul2012.txt"
setenv GSPROTMP_A "${ge_dat}/speciation/${CASE}/gspro_afdust_cmaq_cb05_soa_2020re_v5_07c_23jul2012.txt"



setenv SECTOR afdust
setenv EMISINV_A "$caseinputs/${SECTOR}/2020re_from_2008NEI_v2_NONPOINT_afdust_nopavedroads_noRPO_FF10_01aug2012_v0.csv"
setenv REPCONFIG_GRID "${ge_dat}/repconfig/default/repconfig_area_invgrid_caphap_scc7_02aug2012_v1.txt"
setenv REPCONFIG_INV "${ge_dat}/repconfig/default/repconfig_alm_inv_caphap_01sep2008_v0.txt"
setenv EMISINV_B "$caseinputs/${SECTOR}/afdust_paved_roads_2008v17_noPRECIPadj_FF10_04jun2012_v0.csv"
setenv EMISINV_C "$caseinputs/${SECTOR}/2020re_from_marama_afdust_2007_Jan2012_for2007ed_01aug2012_v0.csv"
setenv EMISINV_D "$caseinputs/${SECTOR}/2020re_from_sesarm_afdust_semap_March2012_for2007ed_01aug2012_v0.csv"
setenv EMISINV_E "$caseinputs/${SECTOR}/2020re_from_2008NEI_v2_NONPOINT_afdust_NY_agproduction_ONLY_FF10_01aug2012_v0.csv"

## Inputs -- region (Continental US 12km small (12US2)) and  sector (afdust) and all jobs
setenv XPORTFRAC "$caseinputs/xportfrac.12US2.from4km.v2.ncf"

setenv SECTOR "afdust"
setenv REGION "Continental US 12km"


## Parameters -- all regions, all sectors, all jobs
setenv OUTZONE "0"
setenv MCIPNAME "MCIP_v3.6"
setenv ALL_MONTHS "1 2 3 4 5 6 7 8 9 10 11 12"
setenv REPORT_DEFAULTS "Y"
setenv FULLSCC_ONLY "Y"
setenv SMK_PING_METHOD "0"
setenv SMKINVEN_FORMULA "PMC=PM10-PM2_5"
setenv POLLUTANT_CONVERSION "Y"
setenv FILL_ANNUAL "N"
setenv EMF_LOGGERPYTHONDIR "$EMF_SCRIPTDIR/case_logs_python"
setenv WEST_HSPHERE "Y"
setenv RENORM_TPROF "Y"
setenv PLATFORM "v5"
setenv EMF_QUEUE_OPTIONS "-A mobile -q romo -W group_list=romo -W umask=022"
setenv SMK_SPECELEV_YN "Y"
setenv MRG_REPSTA_YN "Y"
setenv SMK_MAXWARNING "10"
setenv SPC "$EMF_SPC"
setenv RUN_PYTHON_ANNUAL "Y"
setenv INLINE_MODE "both"
setenv EGU_TYPE "model_performance"
setenv OUTPUT_FORMAT "$EMF_AQM"
setenv IOAPI_ISPH "20"
setenv SMK_MAXERROR "10000"
setenv MRG_REPCNY_YN "N"
setenv SMK_EMLAYS "24"
setenv RAW_DUP_CHECK "N"
setenv SMK_AVEDAY_YN "N"
setenv MRG_MARKETPEN_YN "N"

## Parameters -- sector/region/job specific
setenv M_TYPE "week"
setenv RUN_HOLIDAYS "Y"
setenv SMK_DEFAULT_SRGID "340"
setenv L_TYPE "week"
setenv FUTURE_YEAR "2007"
setenv SPINUP_DURATION "10"
setenv SMKMERGE_CUSTOM_OUTPUT "Y"

setenv SRGPRO "${ge_dat}/CONUS12_2010_v2_20120625/"


## job executable
#$runscripts/emf/afdust_adj_emf.csh -m "Running top level script for job: Afdust_adjustment"
$runscripts/emf/afdust_adj_emf.csh $REGION_ABBREV -q "1 2 3 4" 0

if ( $status != 0 ) then
	 $EMF_CLIENT -k $EMF_JOBKEY -s 'Failed' -m "ERROR running Job: $EMF_JOBNAME" -t 'e' 
	 exit(1)
else
	 $EMF_CLIENT -k $EMF_JOBKEY -s 'Completed' -m "Completed job: $EMF_JOBNAME"
endif

