#!/bin/csh -f
#PBS -j oe
#PBS -r n

limit stacksize unlimited

## EMF Command line client -- source environment variables needed and setup EMF JAVACMDLINE to java executable and EMF_PYTHON to python cmd line
source /garnet/oaqps/EMFClient/EmfCmdClientEnv.csh
setenv EMF_JAVACMDLINE "$JAVA_EXE -DUSER_PREFERENCES=$PREF_FILE -DEMF_HOME=$EMF_HOME -classpath $CLASSPATH gov.epa.emissions.framework.client.EMFCmdClient $TOMCAT_SERVER/emf/services  -r 3"
setenv EMF_CLIENT /garnet/oaqps/EMFClient/EMFCmdClient.py

## Job run file for job: Nonpt_Q1

## EMF specific variables
setenv EMF_JOBID "34235"
setenv EMF_JOBNAME "Nonpt_Q1"
setenv EMF_USER "cvy"
setenv EMF_SCRIPTDIR "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/scripts"
setenv EMF_SCRIPTNAME "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/scripts/Nonpt_Q1_12US2_2020re_v5_07c_20120806152928.csh"
setenv EMF_LOGNAME "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/scripts/logs/Nonpt_Q1_12US2_2020re_v5_07c_20120806152928.log"
setenv EMF_JOBKEY "34235_1344281369015"

## Inputs -- for all regions, all sectors and all jobs
setenv GSPROTMP_D  "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/spec_parts/gspro_tog_cb05_soa_2020re_pmnaaqsfinal_23jul2012_v1.txt"
setenv GSPROTMP_U "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/spec_parts/gspro_TOG_WRAP_PhaseIII_17jul2012_v3.txt"
setenv GSREFTMP_S "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/spec_parts/gsref_WRAP_PhaseIII_oil_gas_17jul2012_v3.txt"
setenv SRGPRO "/garnet/oaqps/em_v5/platform_setup/surrogates/CONUS12_2010/USA_100_FILL_NORM.txt"
setenv MRGDATE_FILES "/garnet/oaqps/em_v4/inputs/ge_dat/smk_dates/2007/smk_merge_dates_200612.txt"
setenv GSCNVTMP_C "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/gscnv_cmaq_cb05_hspace_toxic_12nov2009_v0.txt"
setenv GSCNVTMP_B "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/gscnv_cmaq_cb05_hspace_BAF_12nov2009_v0.txt"
setenv GSCNVTMP_A "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/gscnv_cmaq_cb05_tx_pf4_23jul2012_v4.txt"
setenv GSREFTMP_L "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/spec_parts/gsref_speciated_pm_20nov2009_v2.txt"
setenv GSPROTMP_L "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/spec_parts/gspro_speciated_pm_20nov2009_v3.txt"
setenv GSREFTMP_K "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/spec_parts/gsref_hg_13apr2010_v8.txt"
setenv GSREFTMP_J "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/spec_parts/gsref_static_integratehap_emv4_10feb2009_v2.txt"
setenv GSREFTMP_I "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/spec_parts/gsref_nonhapvoc_2020_pmnaaqsfinal_24jul2012_v1.txt"
setenv GSREFTMP_H "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/spec_parts/gsref_nonhapvoc_general_pmnaaqsfinal_24jul2012_v1.txt"
setenv GSREFTMP_G "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/spec_parts/gsref_voc_2020_pmnaaqsfinal_24jul2012_v1.txt"
setenv GSREFTMP_F "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/spec_parts/gsref_voc_general_pmnaaqsfinal_26jul2012_v2.txt"
setenv GSPROTMP_F "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/spec_parts/gspro_integratehaps_cb05_tx_pf4_13feb2012_v3.txt"
setenv GSPROTMP_G "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/spec_parts/gspro_nox_hono_pf4_06aug2008_v0.txt"
setenv GSPROTMP_H "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/spec_parts/gspro_hg_26nov2007_v2.txt"
setenv GSPROTMP_I "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/spec_parts/gspro_speciated_voc_06aug2012_v2.txt"
setenv SECTORLIST "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/mrggrid/sectorlist_2007ee_v5_07c_20jul2012_v0"
setenv GSPROTMP_E "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/spec_parts/gspro_nonhaptog_cb05_eprofiles_2020re_pmnaaqsfinal_notonroad_23jul2012_v0.txt"
setenv GSREFTMP_D "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/spec_parts/gsref_no_dieselpm_28jun2012_nf_v5.txt"
setenv GSREFTMP_E "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/spec_parts/gsref_pm25_pf4_nondiesel_17jul2012_nf_v23.txt"
setenv GSREFTMP_B "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/spec_parts/gsref_sulf_09jul2007_v0.txt"
setenv GSREFTMP_C "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/spec_parts/gsref_static_nox_hono_pf4_28jun2012_nf_v9.txt"
setenv GSREFTMP_A "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/spec_parts/gsref_static_cap_pf4_11feb2011_v1.txt"
setenv GSPROTMP_B  "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/spec_parts/gspro_sulf_29jun2007_v1.txt"
setenv GSPROTMP_C  "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/spec_parts/gspro_pm25_speciatedPMFINE_05oct2011_v1.txt"
setenv GSPROTMP_A  "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/spec_parts/gspro_static_cmaq_21feb2012_v13.txt"
setenv REPCONFIG_GRID "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/repconfig/default/repconfig_area_invgrid_caphap_05sep2008_v1.txt"
setenv REPCONFIG_INV2 "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/repconfig/default/repconfig_area_inv2_02jan2008_v0.txt"
setenv NAICSDESC "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/naicsdesc_02jan2008_v0.txt"
setenv MACTDESC "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/mactdesc_2002v3_23apr2008_v1.txt"
setenv PTPRO "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/amptpro_2007ec_us_can_revised_15may2012_v0.txt"
setenv MTREF "/garnet/oaqps/em_v5/ge_dat/work/Gentpro_TREF_agNH3_RWC_2007ed.txt"
setenv MTPRO "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/amptpro_2008aa_us_can_revised_21jun2012_v2.txt"
setenv PTREF "/garnet/oaqps/em_v5/ge_dat/work/Gentpro_TREF_agNH3_RWC_2007ed.txt"
setenv MGREF "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/amgref_us_can_mex_revised_17jul2012_v20.txt"
setenv REPCONFIG_INV "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/repconfig/default/repconfig_area_inv_caphap_08aug2008_v0.txt"
setenv AGREF "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/amgref_us_can_mex_revised_20jul2012_v21.txt"
setenv SICDESC "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/sic_desc_04oct2006_v0.txt"
setenv PSTK "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/pstk_20nov2006_v0.txt"
setenv ORISDESC "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/orisdesc_04dec2006_v0.txt"
setenv PELVCONFIG "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/pelvconfig_inline_allpts_26apr2010_v1.txt"
setenv MCODES "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/mcodes_22nov2011_nf_v4.txt"
setenv HOLIDAYS "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/holidays_04may2006_v0.txt"
setenv ARTOPNT "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/artopnt_2002detroit_12jul2007_v0.txt"
setenv SRGDESC "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/srgdesc_CONUS12_2010_03jul2012_v3.txt"
setenv ATREF "/garnet/oaqps/em_v5/ge_dat/work/Gentpro_TREF_agNH3_RWC_2007ed.txt"
setenv ATPRO "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/amptpro_2008aa_us_can_revised_21jun2012_v2.txt"
setenv SCCDESC "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/sccdesc_pf31_20jul2012_v15.txt"
setenv INVTABLE "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/invtable_hapcapintegate_cb05soa_nomp_nohg_09feb2012_v8.txt"
setenv COSTCY "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/costcy_for_2007platform_20jul2012_v3.txt"
setenv GRIDDESC "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/griddesc_lambertonly_06apr2012_v45.txt"

## Inputs -- region (Continental US 12km small (12US2)) and all sectors and all jobs

## Inputs -- all regions and  sector (nonpt) and all jobs
setenv EMISINV_A "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/nonpt/2020re_from_2008NEI_v2_NONPOINT_nonpt_remaining_run5_fixed_OHH_ff10_01aug2012_v0.csv"
setenv NHAPEXCLUDE "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/nhapexclude_2008V2_nonpt_02aug2012_v5.txt"
setenv REPCONFIG_INV "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/repconfig/default/repconfig_alm_inv_caphap_01sep2008_v0.txt"
setenv INVTABLE "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/invtable_hapcapintegate_cb05soa_nomp_nohg_02aug2012_nf_v9.txt"
setenv TPRO_HOUR "/garnet/oaqps/em_v5/2007platform/2007eb_v5_07c/scripts/ag_test/Gentpro_TPRO_HOUR_HOURLY_AGNH3.agNH3_2007eb_7may2012.ncf"
setenv TPRO_DAY "/garnet/oaqps/em_v5/ge_dat/work/Gentpro_TPRO_DAY_DAILY_RWC.RWC_2007ed_v5_official.txt"
setenv ATREF "/garnet/oaqps/em_v5/ge_dat/work/Gentpro_TREF_DAILY_RWC.RWC_2007ed.txt"
setenv EMISINV_C "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/nonpt/arinv_pfc_2020_pmnaaqs_23jul2012_v0_orl.txt"
setenv EMISINV_B "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/nonpt/2008_agburn_fromdaily_FF10_22feb2012_23feb2012_v0.csv"
setenv EMISINV_E "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/nonpt/2020re_from_2006_WRAP_PhaseIII_OIL_GAS_Area_01aug2012_v0.csv"
setenv EMISINV_F "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/nonpt/openburning_landclearing_FLGA_sesarm2007_ff10_09jul2012_v2.csv"
setenv EMISINV_G "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/nonpt/2020re_from_RWC_3SCCs_LADCO2008_fixed_ff10_01aug2012_v0.csv"
setenv EMISINV_I "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/nonpt/2020re_from_SESARM_RWC_2007_fixed_ff10_01aug2012_v0.csv"
setenv EMISINV_J "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/nonpt/MARAMA_open_burning_2007_22jun2012_v0.csv"
setenv EMISINV_H "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/nonpt/2020re_from_NYPA_RWC_2007_fixed_ff10_01aug2012_v0.csv"
setenv EMISINV_K "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/nonpt/Cellulosic_plants_2020_NONPOINT_ff10_24jul2012_v0.csv"
setenv EMISINV_L "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/nonpt/arinv_Ethanol_transport_vapor_2017ct_ref_caphap_25jul2011_25jul2011_v0_orl.txt"
setenv GSREFTMP_H "/garnet/oaqps/em_v5/pm_naaqs_ria/2020re_v5_07c/inputs/../../../ge_dat/spec_parts/gsref_nonhapvoc_general_pmnaaqsfinal_06aug2012_v2.txt"

## Inputs -- region (Continental US 12km small (12US2)) and  sector (nonpt) and all jobs

## Inputs -- all regions and  all sector and job (Nonpt Q1 (nonpt, 12US2))

## Inputs -- region (Continental US 12km small (12US2)) and  all sectors and job (Nonpt Q1 (nonpt, 12US2))

## Inputs -- all regions and  sector (nonpt) and job (Nonpt Q1)

## Inputs -- region (Continental US 12km small (12US2)) and  sector (nonpt) and job (Nonpt Q1)

## Parameters -- from Case summary 
setenv CASE "2020re_v5_07c"
setenv MODEL_LABEL "SMOKE3.1"
setenv EMF_AQM "CMAQ v4.7 N1c"
setenv EMF_SPC "cmaq_cb05_soa"
setenv BASE_YEAR "2007"
setenv FUTURE_YEAR "2020"
setenv EPI_STDATE_TIME "2007-01-01 00:00:00.0"
setenv EPI_ENDATE_TIME "2007-12-31 23:59:00.0"
setenv PARENT_CASE "2007re_v5_07c"

## Parameters -- from job tab
setenv SECTOR "nonpt"
setenv REGION "Continental US 12km small"
setenv REGION_ABBREV "12US2"
setenv REGION_IOAPI_GRIDNAME "12US2"

## Parameters -- all regions, all sectors, all jobs 
setenv EMF_QUEUE_OPTIONS "-A plateval -q romo -W group_list=romo -W umask=022"
setenv PROJECT "pm_naaqs_ria"
setenv PROJECT_ROOT "/garnet/oaqps/em_v5/pm_naaqs_ria"
setenv SPINUP_DURATION "10"
setenv SMK_EMLAYS "24"
setenv SPC "$EMF_SPC"
setenv PLATFORM "v5"
setenv EGU_TYPE "model_performance"
setenv MCIPNAME "MCIP_v3.6"
setenv OUT_ROOT "/terra/work/ROMO"
setenv MET_ROOT "/garnet/oaqps/met/MCIP_v3.6/WRF_2007c_24aL"
setenv IMD_ROOT "$PROJECT_ROOT/$CASE/intermed"
setenv DAT_ROOT "/garnet/oaqps/em_$PLATFORM"
setenv SMK_HOME "/garnet/oaqps/smoke"
setenv RUNSET "$EMF_SCRIPTDIR/run_settings_$CASE.txt"
setenv ASSIGNS_FILE "$SMK_HOME/smoke3.1/assigns/ASSIGNS.emf"
setenv RUN_PYTHON_ANNUAL "Y"
setenv INLINE_MODE "both"
setenv SMK_PING_METHOD "0"
setenv SMK_SPECELEV_YN "Y"
setenv RAW_DUP_CHECK "Y"
setenv M_TYPE "mwdss"
setenv L_TYPE "mwdss"
setenv RUN_HOLIDAYS "Y"
setenv FULLSCC_ONLY "Y"
setenv SMK_MAXERROR "10000"
setenv SMK_MAXWARNING "10"
setenv SMK_AVEDAY_YN "N"
setenv REPORT_DEFAULTS "Y"
setenv SMK_DEFAULT_SRGID "100"
setenv SMKINVEN_FORMULA "PMC=PM10-PM2_5"
setenv FILL_ANNUAL "N"
setenv MRG_MARKETPEN_YN "N"
setenv WEST_HSPHERE "Y"
setenv ALL_MONTHS "1 2 3 4 5 6 7 8 9 10 11 12"
setenv MRG_REPCNY_YN "Y"
setenv EMF_LOGGERPYTHONDIR "$EMF_SCRIPTDIR/case_logs_python"
setenv OUTZONE "0"
setenv RENORM_TPROF "Y"
setenv POLLUTANT_CONVERSION "Y"
setenv IOAPI_ISPH "20"
setenv MRG_REPSTA_YN "N"
setenv SMKMERGE_CUSTOM_OUTPUT "Y"
setenv OUTPUT_FORMAT "$EMF_AQM"

## Parameters -- region (Continental US 12km small (12US2)), all sectors, all jobs 

## Parameters -- all regions, sector (nonpt), all jobs 
setenv EMF_QUEUE_OPTIONS "-A plateval -q romo -W group_list=romo -W umask=022 -l walltime=36:00:00"
setenv SPINUP_DURATION "0"
setenv FILL_ANNUAL "Y"
setenv SMK_ARTOPNT_YN "Y"
setenv L_TYPE "all"
setenv M_TYPE "all"
setenv RAW_DUP_CHECK "N"
setenv NONHAP_TYPE "VOC"
setenv SMK_PROCESS_HAPS "PARTIAL"
setenv NO_SPC_ZERO_EMIS "Y"
setenv HOURLY_TPROF_BASE "MONTH"

## Parameters -- region (Continental US 12km small (12US2)), sector (nonpt), all jobs 

## Parameters -- all regions, all sectors, job (Nonpt Q1)

## Parameters -- region (Continental US 12km small (12US2)), all sectors, job (Nonpt Q1)

## Parameters -- all regions, sector (nonpt), all job (Nonpt Q1)

## Parameters -- region (Continental US 12km small (12US2)), sector (nonpt), job (Nonpt Q1)

## job executable
$EMF_CLIENT -k $EMF_JOBKEY -x $SMK_HOME/smoke3.1/scripts/emf/smk_ar_monthly_emf.csh -m "Running top level script for job: Nonpt_Q1"
$SMK_HOME/smoke3.1/scripts/emf/smk_ar_monthly_emf.csh $REGION_ABBREV $REGION_IOAPI_GRIDNAME -q 1 $SPINUP_DURATION q1
if ( $status != 0 ) then
	 $EMF_CLIENT -k $EMF_JOBKEY -s 'Failed' -m "ERROR running Job: $EMF_JOBNAME" -t 'e' 
	 exit(1)
else
	 $EMF_CLIENT -k $EMF_JOBKEY -s 'Completed' -m "Completed job: $EMF_JOBNAME"
endif

