#!/bin/csh -f
#PBS -W group_list=romo
#PBS -A plateval
#PBS -q romo
#PBS -l walltime=036:00:00
#PBS -l select=ncpus=1


setenv INSTALL_DIR "/garnet/work/ozl/packages"
setenv PROJECT "2020re_v5_07c"
setenv CASE "2020re_v5_07c"

setenv OUT_ROOT "$INSTALL_DIR"
setenv PROJECT_ROOT "$INSTALL_DIR/2020re_v5_07c"
setenv DAT_ROOT $PROJECT_ROOT/$CASE
setenv SMK_HOME "$INSTALL_DIR/smoke"
set caseinputs  = "$PROJECT_ROOT/$CASE/inputs"
set ge_dat = "$INSTALL_DIR/2007ee_v5_07c/ge_dat"
set casescripts = "$INSTALL_DIR/2020re_v5_07c/scripts"
set runscripts = "$INSTALL_DIR/smoke/smoke3.1/scripts"


setenv BASE_YEAR 2007
setenv GRID 12US2
setenv SECTOR onroad
setenv EMF_SPC cmaq_cb05_soa
setenv RATIO_PREFIX 2020re
setenv IMD_ROOT "$PROJECT_ROOT/$PROJECT/intermed"
setenv RATIO_PATH "$PROJECT_ROOT/$CASE/inputs/onroad/work"
setenv GRIDDESC "${ge_dat}/griddesc_lambertonly_06apr2012_v45.txt"

set months = (1)
set dimonths = (31 28 31 30 31 30 1 31 30 31 30 31)

set YYYY = $BASE_YEAR

foreach mon ($months)

	if ($mon < 10) then
		set MM = 0${mon}
	else
		set MM = ${mon}
	endif

	set day = 1

	if ($mon == 4) then
		set day = 28
	endif

	while ($day <= $dimonths[$mon])

		if ($day < 10) then
			set DD = 0${day}
		else
			set DD = ${day}
		endif

		setenv ESDATE ${YYYY}${MM}${DD}
		${runscripts}/run/onroad_calif_adj_nohaps.py

		@ day = $day + 1

	end # day loop

end # month loop 

