      subroutine header( ierr,
     &                        iflcnt )
c
c-----------------------------------------------------------------------
c
c    call the routines to read and check the headers for all of the
c    input files.
c    (assume the input files are already open.)
c    when finished, call the routine to write the new header.
c
c    Argument Declaration.
c     outputs:
c       ierr  i  error indicator
c     inputs:
c       iflcnt  i  number of files
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c      10/25/91  --hjt--  original development
c
c-----------------------------------------------------------------------
c    Include Files:
c-----------------------------------------------------------------------
c
      include 'param.inc'
      include 'mrguam.inc'
c
c-----------------------------------------------------------------------
c    Argument Declarations:
c-----------------------------------------------------------------------
c
      integer*4 ierr
      integer*4 iflcnt
c
c-----------------------------------------------------------------------
c    Subroutines Called:
c-----------------------------------------------------------------------
c
c   rduhdr  ---  read data and store in common (called for each input file)
c   ckhdr   ---  compare against control records (called for each input file)
c   wrthdr  ---  write final header
c
c-----------------------------------------------------------------------
c    Local Variables:
c-----------------------------------------------------------------------
c
c   jerr    i  error flag for subroutine calls
c   loop    i  loop variable
c   iounit  i  calculated for input files
c
      integer*4 jerr, loop, iounit
c
c-----------------------------------------------------------------------
c   Entry Point:
c-----------------------------------------------------------------------
c
c   --- assume failure ---
c
      ierr = IFAIL
c
      iounit=MXUNIT
      do 100 loop=1,iflcnt
          iounit=iounit+1
c
c  --- call routine to read header ---
c
          call rduhdr(jerr,iounit,loop)
          if(jerr .NE. ISUCES) goto 9999
c
c  --- call routine to check header for correct data ---
c
          call ckhdr(jerr,loop)
          if(jerr .NE. ISUCES) goto 9999
  100 continue
c
c  --- call routine to write the new header ---
c
      call wrthdr(jerr)
      if(jerr .NE. ISUCES) goto 9999
c
c  --- set error flag to sucess ---
c
      ierr = ISUCES
      goto 9999
c
c-----------------------------------------------------------------------
c   Return Point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
