      subroutine skphdr( ierr,
     &                         iounit )
c
c-----------------------------------------------------------------------
c
c    reads and skips the header data in an EMBR file.  no data is stored
c    written.
c
c    Argument declaration.
c     Outputs:
c       ierr   I error flag
c     Inputs:
c       iounit I logical unit number of file to read
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c      11/10/91  --gmw--  original development
c
c-----------------------------------------------------------------------
c    Include files:
c-----------------------------------------------------------------------
c
      include 'param.inc'
c
c-----------------------------------------------------------------------
c    Argument declarations:
c-----------------------------------------------------------------------
c
      integer*4          ierr
      integer*4          iounit
c
c-----------------------------------------------------------------------
c    local parameters:
c-----------------------------------------------------------------------
c
c   keydat  C   character string for /DATA/ keyword
c
       character*(KEYLEN) keydat
c
       parameter( keydat = '/DATA/' )
c
c-----------------------------------------------------------------------
c    Local variables:
c-----------------------------------------------------------------------
c
c   string  C   character string for temporary storage
c   tmpstr  C   character string for species names
c   tmpval  R   variable for molecular weights
c
      character*(LENREC) string
      character*10       tmpstr
      integer*4          irec, i
      real*4             tmpval
c
c-----------------------------------------------------------------------
c   Entry point:
c-----------------------------------------------------------------------
c
c   --- set error flag ---
c
      ierr = IFAIL
      irec = 0
c
c   --- read first part of header (constant part) ---
c
      irec = irec + 1
      read( iounit,END=7000,ERR=7000) string
      irec = irec + 1
      read( iounit,END=7000,ERR=7000) string
      irec = irec + 1
      read( iounit,ERR=7000) (tmpstr,tmpval,i=1,MXSPEC/2),
     &                              (tmpstr(1:1),i=MXSPEC/2*14+1,LENREC)
      irec = irec + 1
      read( iounit,ERR=7000) (tmpstr,tmpval,i=MXSPEC/2+1,MXSPEC),
     &                     (tmpstr(1:1),i=(MXSPEC-MXSPEC/2)*14+1,LENREC)
c
c   --- read rest of header until an /data/ is found ---
c
  111 continue
      irec = irec + 1
      read( iounit,END=7000,ERR=7000) string
      if( string(1:KEYLEN) .EQ. keydat ) goto 222
      goto 111
c
c   --- set error flag to sucess ---
c
  222 continue
      ierr = ISUCES
      goto 9999
c
c-----------------------------------------------------------------------
c   Error messages:
c-----------------------------------------------------------------------
c
 7000 continue
      write(IOWSTD,9000,ERR=9999) 'ERROR: Reading header of EMBR file ',
     &                                                'at record: ',irec
      goto 9999
c
c-----------------------------------------------------------------------
c   Format statements:
c-----------------------------------------------------------------------
c
 9000 format(/,1x,a,a,i5,/)
c
c-----------------------------------------------------------------------
c   Return point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
