#!/bin/csh -f
#PBS -j oe
#PBS -r n

limit stacksize unlimited
## Manually set directory names [**change**]
setenv INSTALL_DIR "/garnet/work/cvy/for_package"
setenv MET_ROOT "/garnet/oaqps/met/MCIP_v4.1.3/WRF_2011g_25aL" # Change to point to your MCIP

setenv CASE "2011eh_cb6v2_v6_11g"
setenv RUN_MONTHS "1 2 3 4 5 6 7 8 9 10 11 12"
setenv SPINUP_DURATION "10"

## Grid parameters
setenv REGION_ABBREV "12US2"
setenv REGION_IOAPI_GRIDNAME "12US2"

## Derived directory and filenames
setenv PROJECT "$CASE"

setenv OUT_ROOT "$INSTALL_DIR"
setenv PROJECT_ROOT "$INSTALL_DIR/$CASE"
setenv IMD_ROOT "$PROJECT_ROOT/intermed"
setenv DAT_ROOT $PROJECT_ROOT
setenv SMK_HOME "$INSTALL_DIR"
set caseinputs  = "$INSTALL_DIR/2011eh_cb05_v6_11g/inputs"
set ge_dat = "$INSTALL_DIR/ge_dat"
set casescripts = "$PROJECT_ROOT/scripts"
set runscripts = "$INSTALL_DIR/smoke3.6/scripts"
setenv RUNSET "$casescripts/run_settings.txt"
setenv ASSIGNS_FILE "$INSTALL_DIR/smoke3.6/assigns/ASSIGNS.emf"

## EMF Command line client -- source environment variables needed and setup EMF JAVACMDLINE to java executable and EMF_PYTHON to python cmd line
setenv EMF_CLIENT false

## Parameters -- from Case summary 
setenv MODEL_LABEL "SMOKE3.6"
setenv EMF_AQM "CMAQ v4.7 N1c"
setenv EMF_SPC "cmaq_cb6"
setenv BASE_YEAR "2011"
setenv EPI_STDATE_TIME "2011-01-01 00:00:00.0"
setenv EPI_ENDATE_TIME "2011-12-31 23:59:00.0"

## EMF specific variables - leave alone
setenv EMF_JOBNAME "Annual_area"
setenv EMF_SCRIPTDIR "${casescripts}"
setenv EMF_SCRIPTNAME "${casescripts}/${EMF_JOBNAME}.csh"
setenv EMF_LOGNAME "${casescripts}/logs/$EMF_SCRIPTNAME.log"
setenv EMF_JOBKEY "28310_1312400444602"

## Ancillary files for "All Sectors"
setenv AGREF "${ge_dat}/gridding/amgref_us_2011platform_05jan2015_v8.txt"
setenv ARTOPNT "${ge_dat}/artopnt_2002detroit_12jul2007_v0.txt"
setenv ATPRO_HOURLY "${ge_dat}/temporal/amptpro_general_2011platform_tpro_hourly_6nov2014_13nov2014_v1"
setenv ATPRO_MONTHLY "${ge_dat}/temporal/amptpro_general_2011platform_tpro_monthly_6nov2014_06nov2014_v0"
setenv ATPRO_WEEKLY "${ge_dat}/temporal/amptpro_general_2011platform_tpro_weekly_6nov2014_13nov2014_v1"
setenv MTPRO_HOURLY "${ge_dat}/temporal/mtpro_hourly_moves2014_23oct2014_13nov2014_v1"
setenv MTPRO_MONTHLY "${ge_dat}/temporal/amptpro_for_2011_platform_with_carb_mobile_2011CEM_moves_13aug2013_v0_tpro_monthly_13aug2014_v0"
setenv MTPRO_WEEKLY "${ge_dat}/temporal/mtpro_weekly_moves2014_17oct2014_13nov2014_v2"
setenv PTPRO_HOURLY "${ge_dat}/temporal/amptpro_general_2011platform_tpro_hourly_6nov2014_13nov2014_v1"
setenv PTPRO_MONTHLY "${ge_dat}/temporal/amptpro_general_2011platform_tpro_monthly_6nov2014_06nov2014_v0"
setenv PTPRO_WEEKLY "${ge_dat}/temporal/amptpro_general_2011platform_tpro_weekly_6nov2014_13nov2014_v1"
setenv ATREF "${ge_dat}/temporal/amptref_general_2011platform_tref_6nov2014_05jan2015_v3"
setenv MTREF "${ge_dat}/temporal/mtref_onroad_moves2014_23oct2014_13nov2014_v2"
setenv PTREF "${ge_dat}/temporal/amptref_general_2011platform_tref_6nov2014_05jan2015_v3"
setenv COSTCY "${ge_dat}/costcy_for_2007platform_05jan2015_v11.txt"
setenv EFTABLES "${caseinputs}/onroad/eftables/rateperdistance_10003_1_combined.csv"
setenv GRIDDESC "${ge_dat}/gridding/griddesc_lambertonly_18sep2014_v61.txt"
setenv GSCNV "${ge_dat}/speciation/gscnv_cmaq_cb6_2011eh_cb6v2_v6_11g_nf.txt"
setenv GSPROTMP_A "${ge_dat}/speciation/gspro_cmaq_cb6_2011eh_cb6v2_v6_11g_28feb2015.txt"
setenv GSREFTMP_A "${ge_dat}/speciation/gsref_2011eh_v6_11g_05jan2015.txt"
setenv HOLIDAYS "${ge_dat}/temporal/holidays_04may2006_v0.txt"
setenv INVTABLE "${ge_dat}/invtable_2011v2_platform_cb6_integrate_16dec2014_v0.txt"
setenv MRGDATE_FILES "${runscripts}/smk_dates/2011/smk_merge_dates_201012.txt"
setenv NAICSDESC "${ge_dat}/smkreport/naicsdesc_02jan2008_v0.txt"
setenv ORISDESC "${ge_dat}/smkreport/orisdesc_04dec2006_v0.txt"
setenv PELVCONFIG "${ge_dat}/point/pelvconfig_inline_20m_13nov2012_v0.txt"
setenv PSTK "${ge_dat}/point/pstk_20nov2006_v0.txt"
setenv REPCONFIG_GRID "${ge_dat}/smkreport/repconfig/repconfig_area_invgrid_2011platform_11aug2014_v0.txt"
setenv REPCONFIG_INV2 "${ge_dat}/smkreport/repconfig/repconfig_area_inv2_2011platform_11aug2014_v0.txt"
setenv REPCONFIG_INV "${ge_dat}/smkreport/repconfig/repconfig_area_inv_2011platform_11aug2014_v0.txt"
setenv SCCDESC "${ge_dat}/smkreport/sccdesc_pf31_05jan2015_v22.txt"
setenv SECTORLIST "${casescripts}/sectorlist_2011eh_cb6v2_v6_11g.txt"
setenv SRGDESC "${ge_dat}/gridding/srgdesc_CONUS12_2010_v5_12nov2014_v4.txt"
setenv SRGPRO "${ge_dat}/gridding/CONUS12_2010_v5_20141015/USA_100_FILL_NORM.txt"

# Sector-specific inputs
setenv CEMSUM "${caseinputs}/cem/cemsum_2011_corrected_2.1_Nov12_revised_partial_year.txt"
setenv EMISDAY_A "${caseinputs}/ptegu/ptipm_ff10_noncem_2011eg_Nov19_2014_29jan2015_v2"
setenv EMISDAY_B "${caseinputs}/ptegu/ptipm_ff10_noncem_2011eg_prevdec_Nov19_2014_29jan2015_v2"
setenv EMISHOUR_MULTI_A "${caseinputs}/cem/HOUR_UNIT_2010_12_31dec.txt"
setenv EMISINV_A "${caseinputs}/ptegu/2011NEIv2_POINT_ptegu_NOV_2014_29jan2015_v1.csv"
setenv GSPRO_COMBO "${ge_dat}/speciation/gspro_combo_2010cdc_2010ef_nonpt_12nov2012_v0.txt"
setenv INVTABLE "${ge_dat}/invtable_hapcap_cb05_no_bafm_12nov2014_v8.txt"
setenv REPCONFIG_GRID "${ge_dat}/smkreport/repconfig/repconfig_point_invgrid_2011platform_11aug2014_v0.txt"
setenv REPCONFIG_INV2 "${ge_dat}/smkreport/repconfig/repconfig_point_inv2_2011platform_11aug2014_v0.txt"
setenv REPCONFIG_INV "${ge_dat}/smkreport/repconfig/repconfig_point_inv_2011platform_11aug2014_v0.txt"
#setenv PTPRO_HOURLY "${ge_dat}/temporal/summer_diurnal_egu_tpro_2011_21nov2014_v0"
#setenv PTREF "${ge_dat}/temporal/summer_diurnal_egu_tref_2011_15jan2015_v1"
#setenv PTPRO_HOURLY "${ge_dat}/temporal/winter_diurnal_egu_tpro_2011_csv_21nov2014_v0"
#setenv PTREF "${ge_dat}/temporal/winter_diurnal_egu_tref_2011_15jan2015_v1"

# Case-wide parameters
setenv CASE "2011eh_cb6v2_v6_11g"
setenv MODEL_LABEL "SMOKE3.6"

setenv EMF_AQM "CMAQ v4.7 N1c"
setenv EMF_SPC "cmaq_cb6"
setenv BASE_YEAR "2011"
setenv FUTURE_YEAR "2011"
setenv EPI_STDATE_TIME "2011-01-01 00:00:00.0"
setenv EPI_ENDATE_TIME "2011-12-31 23:59:00.0"
setenv PARENT_CASE "2011eg_v6_11g"
setenv EMF_QUEUE_OPTIONS "-A plateval -q romo -W group_list=romo -W umask=022"
setenv SPC "$EMF_SPC"
setenv PLATFORM "v6.2"
setenv MTMP_OUTPUT_YN "N"
setenv RUN_PYTHON_ANNUAL "Y"
setenv INLINE_MODE "both"
setenv SMK_PING_METHOD "0"
setenv SMK_SPECELEV_YN "Y"
setenv RAW_DUP_CHECK "Y"
setenv M_TYPE "mwdss"
setenv L_TYPE "mwdss"
setenv RUN_HOLIDAYS "Y"
setenv FULLSCC_ONLY "Y"
setenv SMK_MAXERROR "10000"
setenv SMK_MAXWARNING "10"
setenv SMK_AVEDAY_YN "N"
setenv REPORT_DEFAULTS "Y"
setenv SMK_DEFAULT_SRGID "100"
setenv SMKINVEN_FORMULA "PMC=PM10-PM2_5"
setenv FILL_ANNUAL "N"
setenv MRG_MARKETPEN_YN "N"
setenv WEST_HSPHERE "Y"
setenv MRG_REPCNY_YN "Y"
setenv EMF_LOGGERPYTHONDIR "$EMF_SCRIPTDIR/case_logs_python"
setenv OUTZONE "0"
setenv RENORM_TPROF "Y"
setenv POLLUTANT_CONVERSION "Y"
setenv IOAPI_ISPH "20"
setenv MRG_REPSTA_YN "N"
setenv SMKMERGE_CUSTOM_OUTPUT "Y"
setenv OUTPUT_FORMAT "$EMF_AQM"

# Grid-specific parameters
setenv REGION "Continental US 12km small"

# Sector-specific parameters
setenv SECTOR "ptegu"
setenv DAY_SPECIFIC_YN "Y"
setenv HOUR_SPECIFIC_YN "Y"
setenv L_TYPE "all"
setenv M_TYPE "all"
#setenv NAMEBREAK_DAILY "8" # not used
setenv NAMEBREAK_HOURLY "6" # [**note**]
setenv RAW_DUP_CHECK "N"
setenv SORT_LIST_EVS "Y"
setenv USE_FF10_DAILY_POINT "Y"
setenv WRITE_ANN_ZERO "Y"
setenv ZIPOUT "Y"

$runscripts/emf/smk_pt_annual_onetime_emf.csh $REGION_ABBREV $REGION_IOAPI_GRIDNAME onetime

if ( $status != 0 ) then
         $EMF_CLIENT -k $EMF_JOBKEY -s 'Failed' -m "ERROR running Job: $EMF_JOBNAME" -t 'e'
         exit(1)
else
         $EMF_CLIENT -k $EMF_JOBKEY -s 'Completed' -m "Completed job: $EMF_JOBNAME"
endif

