c**** ctlgls.inc version 1.0 %m% %i% %g%
c
c   This include common block is used by the utility mkglos for
c   generating the direct access file.
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c       02/02/93  --mmj--  modified parameters to support tiers
c
c-----------------------------------------------------------------------
c    MKGLOS parameters:
c-----------------------------------------------------------------------
c
c   BLNK10  C   10 character BLANK
c   BLNK6   C   6 character BLANK
c   BLNK5   C   5 character BLANK
c   BLNK4   C   4 character BLANK
c   BLANK   C   1 character BLANK
c   PAD     C   ASCII PAD character for record = "X"
c   MXBLK   I   parameter maximum block size (32 * 256 = 8192)
c   MXCODE  I   parameter for maximum types of codes
c   MXHDR   I   parameter for record header length
c                 (begsic (A5) + begscc (1X,A10) + endsic (A5)
c                   + endscc (1X,A10) + ngrec (1X,I6,1X) = 40 )
c   MXGENT  I   somewhat arbitrary setting for number of glossary blocks
c                  (36,200/MXGREC)
c   MXGLEN  I   parameter for glossary entry length
c             (sic (A5) + SCC (A10) + iactcd (A6) + ictlcd (A6)
c                    + ipodcd (A6) + iprccd (A6) + itircd (A6) = 45)
c   MXGREC  I   parameter for number of glossary entries per block
c                 (int((MXBLK-MXHDR)/MXGLEN) = 181)
c   MXBLNK  I   number of trailing BLANKs on direct access record
c                  (MXBLK - MXHDR - (MXGREC*MXGLEN) = 7)
c   MXRLEN  I   length of direct access record
c                  (MXHDR + (MXGREC*MXGLEN) + MXBLNK = 8192)
c-----------------------------------------------------------------------
c
      character*10 BLNK10
      character*6  BLNK6
      character*5  BLNK5
      character*4  BLNK4
      character*1  BLANK
      character*1  PAD
      integer*4    MXBLK
      integer*4    MXCODE
      integer*4    MXGENT
      integer*4    MXGLEN
      integer*4    MXGREC
      integer*4    MXHDR
      integer*4    MXBLNK
      integer*4    MXRLEN
c
      parameter (BLNK10 = '          ')
      parameter (BLNK6 = '      ')
      parameter (BLNK5 = '     ')
      parameter (BLNK4 = '    ')
      parameter (BLANK = ' ')
      parameter (PAD = 'X')
      parameter (MXBLK = 32 * 256)
      parameter (MXCODE = 5)
      parameter (MXHDR = 40 )
      parameter (MXGLEN = 45 )
      parameter (MXGREC = 181 )
      parameter (MXGENT = 36200/MXGREC)
      parameter (MXBLNK = MXBLK-MXHDR-(MXGREC*MXGLEN))
      parameter (MXRLEN = MXHDR + (MXGREC*MXGLEN) + MXBLNK)
c
c-----------------------------------------------------------------------
c   Format statement parameters:
c-----------------------------------------------------------------------
c
c   FMTD1     C   record format direct access, part 1
c   FMTD2     C   record format direct access, part 2
c   FMTD3     C   record format direct access, part 3
c   FMTQ1     C   record format qa write, part 1
c   FMTQ2     C   record format qa write, part 2
c   FMTS1     C   record format sequential access, part 1
c   FMTS2     C   record format sequential access, part 2
c
      character*36 FMTD1
      character*14 FMTD2
      character*14 FMTD3
      character*17 FMTQ1
      character*6  FMTQ2
      character*14 FMTS1
      character*8  FMTS2
c
      parameter ( FMTD1 = '(1X,A4,1X,A10,1X,A4,1X,A10,1X,I6,1X,' )
      parameter ( FMTD2 = '(1X,A4,A10,' )
      parameter ( FMTD3 = '(A6)),42A1)' )
      parameter ( FMTQ1 = '(I7,4X,A4,1X,A10,' )
      parameter ( FMTQ2 = '(A10))' )
      parameter ( FMTS1 = '(5X,A4,1X,A10,' )
      parameter ( FMTS2 = '(4X,A6))' )
c
c-----------------------------------------------------------------------
c   Parameters for order of codes in arrays:
c-----------------------------------------------------------------------
c
c   IDXACT  I  index of activity code
c   IDXPRC  I  index of process code
c   IDXCSY  I  index of control strategy code
c   IDXPOD  I  index of POD code
c   IDXTRS  I  index of tier code
c
      integer*4 IDXACT
      integer*4 IDXPRC
      integer*4 IDXCSY
      integer*4 IDXPOD
      integer*4 IDXTRS
c
      parameter( IDXACT = 1 )
      parameter( IDXPRC = 2 )
      parameter( IDXCSY = 3 )
      parameter( IDXPOD = 4 )
      parameter( IDXTRS = 5 )
c
c-----------------------------------------------------------------------
c   Glossary data variables:
c-----------------------------------------------------------------------
c
c   bstscc   C   array of beginning SCC(ASC) used by programs which
c                access direct access file
c   bstsic   C   array of beginning SIC used by programs which
c                access direct access file
c   begscc   C   beginning SCC(ASC) of stored codes for retrieved block
c   begsic   C   beginning SIC of stored codes for retrieved block
c   estscc   C   array of ending SCC(ASC) used by programs which
c                access direct access file
c   estsic   C   array of ending SIC used by programs which
c                access direct access file
c   endscc   C   ending SCC(ASC) of stored codes for retrieved block
c   endsic   C   ending SCC(ASC) of stored codes for retrieved block
c   fmtdac   C   format for direct access file
c   fmtseq   C   format for sequential access file
c   fmtwqa   C   format for writing qa information
c   nglrec   I   number of glossary records (in file, or savcod)
c   savcod   C   array of stored codes for retrieved block
c   savscc   C   array of saved SCC(ASC)
c   savsic   C   array of saved SIC
c
      character*72  fmtdac
      character*72  fmtseq
      character*72  fmtwqa
      character*10  bstscc(MXGENT)
      character*10  begscc
      character*10  estscc(MXGENT)
      character*10  endscc
      character*10  savscc(MXGREC)
      character*4   begsic
      character*4   bstsic(MXGENT)
      character*4   endsic
      character*4   estsic(MXGENT)
      character*4   savsic(MXGREC)
      character*6   savcod(MXCODE,MXGREC)
      integer*4     nglrec
c
      common /mgldat/ nglrec
      common /mglchr/ begsic, begscc, endsic, endscc, savsic, savscc,
     &                savcod
      common /mglret/ bstsic, bstscc, estsic, estscc
      common /mglfrm/ fmtdac, fmtseq, fmtwqa
c
