      subroutine getime( cdate )
c
c-----------------------------------------------------------------------
c
c   Description:
c
c     This routine returns the actual length of a string, i.e. with no
c     trailing blanks.
c
c   Arguments:
c
c     Outputs:
c       cdate    C   date as character string
c
c-----------------------------------------------------------------------
c   LOG:
c-----------------------------------------------------------------------
c
c     11/10/91  -gmw-  original development
c
c-----------------------------------------------------------------------
c   Argument declaration:
c-----------------------------------------------------------------------
c
      character*(*) cdate
c
c-----------------------------------------------------------------------
c   Include files:
c-----------------------------------------------------------------------
c
      include 'param.inc'
c
c-----------------------------------------------------------------------
c   Local variables:
c-----------------------------------------------------------------------
c
      integer*4 imon, iday, iyear, ihr, imin, isec
      integer*4 iarray(3)
c
c-----------------------------------------------------------------------
c   Entry point:
c-----------------------------------------------------------------------
c
c   ---- call routine to get date/time as integers ---
c
      call idate( imon,iday,iyear )
      call itime(iarray)
      isec = iarray(3)
      imin = iarray(2)
      ihr = iarray(1)
      iyear = mod(iyear,100)
      write(cdate,9000,ERR=9999) imon, iday, iyear, ihr, imin, isec
c
      goto 9999
c
c-----------------------------------------------------------------------
c   Format statements:
c-----------------------------------------------------------------------
c
 9000 format(I2.2,'/',I2.2,'/',I2.2,1X,I2.2,':',I2.2,':',I2.2)
c
c-----------------------------------------------------------------------
c   Return point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
