      subroutine rgtjst(
     &                  string, ilen )
c
c-----------------------------------------------------------------------
c
c   description:
c
c     this routine right justifies a string, .ie. removes the trailing
c     BLANKs.
c
c   Arguments:
c
c     inputs/Outputs: (the string arguments serves as both input and
c                      output)
c       string   C   string to left justify
c       ilen     I   length of string (declared or actual)
c
c-----------------------------------------------------------------------
c   LOG:
c-----------------------------------------------------------------------
c
c     11/10/91  -gmw-  original development
c
c-----------------------------------------------------------------------
c   Argument declaration:
c-----------------------------------------------------------------------
c
      character*(*) string
      integer*4     ilen
c
c-----------------------------------------------------------------------
c   External functions:
c-----------------------------------------------------------------------
c
c   strlen  I   returns the actual length of a string
c
      integer*4 strlen
c
c-----------------------------------------------------------------------
c   local parameters:
c-----------------------------------------------------------------------
c
c       BLANK    C  BLANK character
c
      character*1 BLANK
      parameter(BLANK=' ')
c
c-----------------------------------------------------------------------
c   Local variables:
c-----------------------------------------------------------------------
c
c   ibeg  I   last non-BLANK character of string
c
      integer*4 iend, i
c
c-----------------------------------------------------------------------
c   Entry point:
c-----------------------------------------------------------------------
c
c   ---- already left justified so just return ----
c
      if( string(ilen:ilen) .NE. BLANK ) goto 9999
c
c   ---- find last non-BLANK character ---
c
      iend = strlen ( string, ilen )
      if( iend .LT. 1 ) goto 9999
c
c   ---- move all characters to end ---
c
      do 10 i=ilen,ilen-iend+1,-1
         string(i:i) = string(i-ilen+iend:i-ilen+iend)
   10 continue
c
c   ---- BLANK out leftmost characters ---
c
      do 20 i=1,ilen-iend
         string(i:i) = BLANK
   20 continue
      goto 9999
c
c-----------------------------------------------------------------------
c   Return point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
