      subroutine prcuam( ierr,
     &                          iflcnt, ladj)
c
c-----------------------------------------------------------------------
c
c    main processing routine,for each hour the hourly emissions from
c    each input file is read and adjusted if necessary.  the total
c    merged is then calculated and written to the new file in the
c    requested species order.
c
c    Argument Declaration.
c     outputs:
c       ierr   i  error flag
c     inputs:
c       iflcnt i number of files
c       ladj   l .TRUE. if adjustments need to be applied
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c      10/25/91  --hjt--  original development
c      12/01/92  --gmw--  added code to change the ending hour if zero.
c
c-----------------------------------------------------------------------
c    Include Files:
c-----------------------------------------------------------------------
c
      include 'param.inc'
      include 'uamcntl.inc'
      include 'mrguam.inc'
      include 'rdemis.inc'
c
c-----------------------------------------------------------------------
c    Argument Declarations:
c-----------------------------------------------------------------------
c
      integer*4 ierr
      integer*4 iflcnt
      logical*4 ladj
c
c-----------------------------------------------------------------------
c    Local Variables:
c-----------------------------------------------------------------------
c
      integer*4 ifile, iounit, ihour, ispc, ipos, ixloop, iyloop
      integer*4 ibegti, iendti, jerr
      logical*4 lfound
c
c-----------------------------------------------------------------------
c   Entry Point:
c-----------------------------------------------------------------------
c
c   --- assume failure
c
      ierr = IFAIL
c
c   --- initialize total ---
c
      do 20 ispc=1, nspecs
          do 10 ifile=1, iflcnt
              total(ifile, ispc) = 0.0
   10     continue
   20 continue
c
c   --- figure out hours, assume even hours ---
c
      ibegti = int(begtim/100) + 1
      iendti = int(endtim/100)
c
c    --- make sure the beginning hour is not 24 and the end hour
c        is not 0 ---
c
       if( ibegti .GE. 24) ibegti = abs(24 - ibegti) + 1
       if( iendti .EQ. 0) iendti = 24
c
c   --- loop over hours ---
c
      do 110 ihour=ibegti,iendti
c
c      --- initialize hrtot ---
c
          do 40 ispc=1,nspecs
              do 30 ifile=1,iflcnt
                  hrtot(ifile, ispc) = 0.0
   30         continue
   40     continue
c
c      --- initialize u1 ---
c
          do 70 ispc=1,nspecs
              do 60 iyloop=1,MXCEL
                  do 50 ixloop=1,MXCEL
                      u1(ixloop,iyloop,ispc)=0.0
   50             continue
   60         continue
   70     continue
c
c    ---- process all files ---
c
          iounit=MXUNIT
          lfound=.FALSE.
          do 100 ifile=1,iflcnt
              iounit=iounit+1
              call rdemis(jerr,ifile,iounit,ihour,ladj)
              if(jerr .EQ. IEOF) goto 100
              lfound=.TRUE.
              if(jerr .NE. ISUCES) then
                  ipos=ifile
                  goto 7000
              endif
  100     continue
          if(.NOT. lfound) then
              write(IOWMSG,9000,ERR=9999) ihour
              goto 9999
          endif
          call wrtout(jerr,ihour)
          if(jerr .NE. ISUCES) goto 9999
          call wrmmru(jerr,ihour,iflcnt,.FALSE.)
          if(jerr .NE. ISUCES) goto 9999
  110 continue
c
c    --- write totals ---
c
      call wrmmru(jerr,ihour,iflcnt,.TRUE.)
      if(jerr .NE. ISUCES) goto 9999
c
      ierr = ISUCES
      goto 9999
c
c-----------------------------------------------------------------------
c   Error Messages:
c-----------------------------------------------------------------------
c
 7000 continue
      write (IOWSTD,9010,ERR=9999) innm(ipos)
      goto 9999
c
c-----------------------------------------------------------------------
c   Format Statements:
c-----------------------------------------------------------------------
c
 9000 format(1x, 'Ending with hour ', i4)
 9010 format(1x, 'ERROR:  Reading emission file:', a)
c
c-----------------------------------------------------------------------
c   Return Point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
