      function caljul(idate)
      integer*4 caljul
c
c-----------------------------------------------------------------------
c
c    Converts calander date to julian date
c
c        Return value:   julian date.
c
c-----------------------------------------------------------------------
c   LOG:
c-----------------------------------------------------------------------
c
c    11/10/91   -gmw-    original development
c
c-----------------------------------------------------------------------
c   Argument declerations:
c-----------------------------------------------------------------------
c
      integer*4     idate
c
c-----------------------------------------------------------------------
c   Local variables:
c-----------------------------------------------------------------------
c
      integer*4 modays(2,12)
      integer*4 iyr, imon, iday, jdate, ipt, ileap, i
c
c-----------------------------------------------------------------------
c   Data statements:
c-----------------------------------------------------------------------
c
      data modays /31, 31, 28, 29, 31, 31, 30, 30, 31, 31, 30, 30,
     &             31, 31, 31, 31, 30, 30, 31, 31, 30, 30, 31, 31/
c
c-----------------------------------------------------------------------
c   Entry point:
c-----------------------------------------------------------------------
c
c   ----- get year, month, day ----
c
      jdate = 0
      iyr = idate/10000
      imon = (idate - iyr*10000)/100
      iday = idate - iyr*10000 - imon*100
c
c   ----- determine if it is leap year -----
c
      ileap = mod(iyr,4)
      if( ileap .EQ. 0 ) then
         ipt = 2
      else
         ipt = 1
      end if
c
c   ----- add up days in months, before this month ----
c
      do 10 i=1,imon-1
         jdate = jdate + modays(ipt,i)
   10 continue
c
c   ----- add days from this month ----
c
      jdate = jdate + iday
c
c   ----- return julian date ----
c
      caljul = iyr * 1000 + jdate
c
c-----------------------------------------------------------------------
c   Return point:
c-----------------------------------------------------------------------
c
      return
      end
