      function fndxrf(
     &                 fipin, plant, istack, scccd )
      integer*4 fndxrf
c
c-----------------------------------------------------------------------
c
c     This routine searches through the arrays of cross reference data
c     seaching for a match of the input data.  any match of global
c     codes is kept until the end and the closest match is used. it
c     is assumed that no exact matches to plant code can be applied
c     without an exact match of FIPS code and no exact match of a
c     stack code can be applied without an exact match of plant code.
c     the index of a match is stored in an array so that the higher
c     the array element the closer the match.  the matches are stored
c     as follows:
c                                FIPS     plant   stack   ASC-SCC
c                               -------------------------------
c               idxmch(1)       global    global  global  exact
c               idxmch(2)       state     global  global  exact
c               idxmch(3)       exact     global  global  exact
c               idxmch(4)       exact     exact   global  exact
c
c   Arguments:
c
c     Inputs:
c       fipin    C   FIPS code to match
c       plant    C   neds plant id code to match
c       istack   I   stack id code to match
c       scccd    C   ASC-SCC code to match
c
c-----------------------------------------------------------------------
c   LOG:
c-----------------------------------------------------------------------
c
c     11/10/91  -gmw-  original development
c
c-----------------------------------------------------------------------
c   Include files:
c-----------------------------------------------------------------------
c
      include 'param.inc'
      include 'sccxref.inc'
c
c-----------------------------------------------------------------------
c   Argument declaration:
c-----------------------------------------------------------------------

      character*5  fipin
      character*5  plant
      integer*4    istack
      character*10 scccd
c
c-----------------------------------------------------------------------
c   Local parameters:
c-----------------------------------------------------------------------
c
c    BLNPLT   C   BLANK string of smae length as plant id for comparison
c    BLNSCC   C   BLANK string of smae length as plant id for comparison
c
      character*10 BLNSCC
      character*5  BLNPLT
c
      parameter( BLNSCC = '          ' )
      parameter( BLNPLT = '     ' )
c
c-----------------------------------------------------------------------
c   Local variables:
c-----------------------------------------------------------------------
c
c   idxmch   I   array of indexes of matches
c   fipglb   C   character string for global FIPS code
c   fipst    C   character string for FIPS code for match of state
c
      character*5 fipglb, fipst
      integer*4   idxmch(4), i
c
c-----------------------------------------------------------------------
c   Data statements:
c-----------------------------------------------------------------------
c
      data fipglb /'00000'/
      data fipst  /'00000'/
c
c-----------------------------------------------------------------------
c   Entry point:
c-----------------------------------------------------------------------
c
c   ---- initialize return value, and value for matching state ----
c
      fndxrf = 0
      fipst(1:2) = fipin(1:2)
      do 10 i=1,4
        idxmch(i) = 0
   10 continue
c
c   ---- loop through the array of codes ---
c
      do 20 i=1,npfxrf
c
c   ---- check for match of ASC-SCC, if global ASC-SCC code then all
c        other codes must be exact ---
c
         if( scccd .NE. sccxrf(i) .OR. sccxrf(i) .EQ. BLNSCC ) goto 20
         if( sccxrf(i) .EQ. BLNSCC ) then
             if( plant .NE. facxrf(i) ) goto 20
             if( fipin .NE. fipxrf(i) ) goto 20
         endif
c
c   ---- check for match of FIPS code first global, the state then
c        exact ---
c
         if( fipglb .EQ. fipxrf(i) ) then
             idxmch(1) = i
             goto 20
         endif
         if( fipst .EQ. fipxrf(i) ) then
             idxmch(2) = i
             goto 20
         endif
         if( fipin .NE. fipxrf(i) ) goto 20
c
c   ---- FIPS is exact match so check the plant and stack codes,
c        first global plant, then exact plant ---
c
         if( facxrf(i) .EQ. BLNPLT ) then
             idxmch(3) = i
             goto 20
         endif
         if( plant .NE. facxrf(i) ) goto 20
         if( istxrf(i) .LT. 0 ) then
             idxmch(4) = i
             goto 20
         endif
         if( istxrf(i) .EQ. istack ) then
             fndxrf = i
             goto 9999
         endif
c
   20 continue
c
c   ---- loop through the array of matches for closest match ---
c
      do 30 i=4,1,-1
         if( idxmch(i) .GT. 0 ) then
             fndxrf = idxmch(i)
             goto 9999
         endif
   30 continue
      goto 9999
c
c-----------------------------------------------------------------------
c   Return point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
