      subroutine rdemar( ierr,
     &                         iounit, irec )
c
c-----------------------------------------------------------------------
c
c    Reads one record of the data section of EMAR using the variables
c    stored in common block of (embrdat)
c
c    Argument declaration.
c     Outputs:
c       ierr   I error flag
c     Inputs:
c       iounit I logical unit number of file to read
c       irec   I count of record for messages
c
c-----------------------------------------------------------------------
c    LOG:
c      12/10/91  --bss--  cannibalized from wremar.f
c-----------------------------------------------------------------------
c
c      11/10/91  --gmw--  original development
c      12/01/92  --gmw--  now does not need a /TRAILER/ section,  also
c                         changed error message.
c
c-----------------------------------------------------------------------
c    Include files:
c-----------------------------------------------------------------------
c
      include 'param.inc'
      include 'embrdat.inc'
c
c-----------------------------------------------------------------------
c    Argument declarations:
c-----------------------------------------------------------------------
c
      integer*4 ierr
      integer*4 iounit
      integer*4 irec
c
c-----------------------------------------------------------------------
c    function declarations:
c-----------------------------------------------------------------------
c
      integer*4 strlen
c
c-----------------------------------------------------------------------
c       Local variables:
c-----------------------------------------------------------------------
c
      character*(MXASCI) string
      character*(KEYLEN) keywrd
      integer*4          ilen, i, j, k
c
c-----------------------------------------------------------------------
c   Data statements:
c-----------------------------------------------------------------------
c
      data keywrd /'/TRAILER/'/
c
c-----------------------------------------------------------------------
c   Entry point:
c-----------------------------------------------------------------------
c
c   --- set error flag ---
c
      ierr = IFAIL
c
c   --- check for end of data records ---
c
      read(iounit,8000,ERR=7000,END=111 ) string
      ilen = strlen ( keywrd, KEYLEN )
      if( string(1:ilen) .EQ. keywrd(1:ilen) ) then
          ierr = IEOD
          goto 9999
      endif
c
c   --- read EMAR record ---
c
      read(string,8001,ERR=7000 ) fipin, sbrgn, siccd, scccd, rectyp,
     &                         emstyp, invbeg, invend, ijcell,
     &                         plant, facnox, facvoc, istack,
     &                         point, isegno, utme, utmn, iutmzn
      read(iounit,8002,ERR=7000 ) stkgev, stkdia, stktmp, stkhgt
      do 10 i=1,MXCRIT,3
          k = min(i+2,MXCRIT)
          read(iounit,8003,ERR=7000 ) (emin(j),iceqcd(j),ceqeff(j),
     &                              ruleff(j),rulpen(j),j=i,k)
  10  continue
      do 20 i=1,MXSPEC,10
          k = min(i+9,MXSPEC)
         read(iounit,8004,ERR=7000 ) (spcpol(j),j=i,k)
  20  continue
c
c   --- set error flag to success ---
c
      ierr = ISUCES
      goto 9999
c
c   --- end of file found, so write warning and set flag
c       to end of data ---
c
  111 continue
      write(IOWSTD,9000,ERR=9999) 'WARNONG: Input EMAR file contains ',
     &                    'no /TRAILER/ packet.'
      ierr = IEOF
      goto 9999
c
c-----------------------------------------------------------------------
c   Error messages:
c-----------------------------------------------------------------------
c
 7000 continue
      write(IOWSTD,9000,ERR=9999) 'ERROR: Reading data record from ',
     &                                       'EMAR file at record:',irec
      goto 9999
c
c-----------------------------------------------------------------------
c   Format statements:
c-----------------------------------------------------------------------
c
 8000 format(A)
 8001 format(A5,1X,A5,1X,A4,1X,A10,1X,A1,1X,A2,1X,I8,1X,I8,1X,I6,1X,A5,
     &       1X,e10.4,1X,e10.4,1X,I3,1X,A3,1X,I3,1X,F7.2,1X,F7.2,1X,I2)
 8002 format(5X,F6.2,1X,F6.2,1X,F6.1,1X,F6.2,2(1X,e10.4,1X,I3,1X,F6.2,
     &                                                1X,F6.2,1X,F6.2))
 8003 format(5X,3(e10.4,1X,I3,1X,F6.2,1X,F6.2,1X,F6.2,1X))
 8004 format(5X,10(1X,e10.4))
 9000 format(/,1X,A,A,I5,/)
c
c-----------------------------------------------------------------------
c   Return point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
