      subroutine setgls ( ierr, iounit )
c
c-----------------------------------------------------------------------
c
c    initializes the direct access glossary file arrays of beginning
c    and ending SIC/SCC codes on the direct access record.  the direct
c    access file is created by the mkglos utility.  each record contains
c    MXGREC sequential access records.
c
c    arguement declaration.
c     Inputs:
c       iounit I unit number of glossary file
c     Outputs:
c       ierr   I error flag
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c      11/14/91  --mmj--  original development
c                       -- much taken from the subroutine setact
c                       -- in centems module of EPS version 1.0
c      03/30/92  --gmw--  taken from rprtem
c
c-----------------------------------------------------------------------
c    Argument declarations:
c-----------------------------------------------------------------------
c
      integer*4 ierr
      integer*4 iounit
c
c-----------------------------------------------------------------------
c    Include files:
c-----------------------------------------------------------------------
c
      include 'param.inc'
      include 'ctlgls.inc'
c
c-----------------------------------------------------------------------
c    Local variables:
c-----------------------------------------------------------------------
c
c   dumchr  C   dummy character variable
c   I       i   loop variable
c   inrec   I   number of sequential access records on direct access
c               record
c   j       I   loop variable
c   rdbscc  C   beginning SCC/ASC of direct access record
c   rdbsic  C   beginning SIC of direct access record
c   rdescc  C   ending SCC/ASC of direct access record
c   rdesic  C   ending SIC of direct access record
c
      character*10 rdbscc, rdescc
      character*4  rdbsic, rdesic
      character*1  dumchr
      integer*4    inrec, i, j
c
c-----------------------------------------------------------------------
c   Entry point:
c-----------------------------------------------------------------------
c
c   --- assume fail ---
c
      ierr = IFAIL
c
c   --- initialize local variables needed for processing ---
c
      nglrec = 1
c
      write (fmtseq,9003,ERR=7002) FMTS1, MXCODE, FMTS2
      write (fmtwqa,9003,ERR=7002) FMTQ1, MXCODE, FMTQ2
      write (fmtdac,9004,ERR=7002) FMTD1, MXGREC, FMTD2, MXCODE, FMTD3
c
c   --- get and store first glossary record ---
c
      read (iounit,fmtdac,rec=nglrec,ERR=7000)
     &            begsic, begscc, endsic, endscc, inrec,
     &            (savsic(j), savscc(j), (savcod(i,j), i=1,MXCODE),
     &                                                 j=1,MXGREC),
     &            (dumchr,i=1,MXBLNK)
c
      if ( inrec .LE. 0 )  goto 7000
c
c   --- store beginning and ending SIC/SCC ---
c
      bstsic(nglrec) = begsic
      bstscc(nglrec) = begscc
      estsic(nglrec) = endsic
      estscc(nglrec) = endscc
c
c   --- continue reading beginning and ending sic/scc codes ---
c
  100 continue
         nglrec = nglrec + 1
         if ( nglrec .GT. MXGENT )  goto 7003
         read (iounit,fmtdac,rec=nglrec,ERR=7000) rdbsic, rdbscc,
     &                                          rdesic, rdescc, inrec
c
c   --- check eof, increment counter, check array dimensions, ---
c   --- store beginning and ending SIC/SCC ---
c
         if ( inrec .LE. 0 )  goto 500
c
         bstsic(nglrec) = rdbsic
         bstscc(nglrec) = rdbscc
         estsic(nglrec) = rdesic
         estscc(nglrec) = rdescc
c
         if ( inrec .LT. MXGREC ) go to 500
c
      goto 100
c
c     ----- end of glossary file
c
  500 continue
c
      write(IOWSTD,9000,ERR=9999) 'Number of glossary records read: ',
     &                            nglrec
c
      ierr = ISUCES
      goto 9999
c
c-----------------------------------------------------------------------
c   Error messages:
c-----------------------------------------------------------------------
c
 7000 continue
      write(IOWSTD,9001,ERR=9999) 'ERROR: Reading glossary file: ',
     &                                             ' at block ', nglrec
      go to 9999
c
 7002 continue
      write (IOWSTD,9002,ERR=9999) 'ERROR: On internal write.'
      goto 9999
c
 7003 continue
      write(IOWSTD,9002,ERR=9999)
     &      'ERROR: Exceed maximum number of glossary blocks ', MXGENT
      goto 9999
c
c-----------------------------------------------------------------------
c   Format statements:
c-----------------------------------------------------------------------
c
 9000 format (/,t10,a,i5)
 9001 format (1x,a,a,i5)
 9002 format (1x,a,i5)
 9003 format (a,i2,a)
 9004 format (a,i4,a,i2,a)
c
c-----------------------------------------------------------------------
c   Return point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
