#!/bin/csh
#PBS -W group_list=romo
#PBS -q romo
#PBS -A multipol
#PBS -j oe
#PBS -r n
#PBS -W umask=022

set grid = 12EUS1_279X240

setenv DEBUG_OUTPUT Y
setenv MIMS_PROCESSING ALLOCATE
setenv GRIDDESC /garnet/oaqps/em_v5/ge_dat/griddesc_lambertonly_18jan2013_nf_v52.txt
setenv INPUT_FILE_NAME /terra/work/MOD3EVAL/pou/xportfrac/xportfrac.8vars.beld3.4kmgrid.ncf
setenv INPUT_FILE_TYPE IoapiFile                        
setenv INPUT_FILE_MAP_PRJN "+proj=lambert"              
setenv INPUT_FILE_ELLIPSOID  "+a=6370997.00,+b=6370997.00"
setenv ALLOCATE_ATTRS ALL
setenv ALLOC_MODE_FILE ALL_AVERAGE 
setenv OUTPUT_FILE_NAME /garnet/home/cvy/tmp/xportfrac.$grid.from4km.ncf
if ( -e $OUTPUT_FILE_NAME) then 
  rm -f  $OUTPUT_FILE_NAME 
endif 
setenv OUTPUT_FILE_TYPE IoapiFile
setenv OUTPUT_GRID_NAME $grid
setenv OUTPUT_FILE_ELLIPSOID "+a=6370000.0,+b=6370000.0" 
#time /home/pou/spatial/src/allocator.exe
time /terra/work/MOD3APP/festc/sa_052011/bin/32bits/allocator.exe
