/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.cem.correct;

import edu.unc.cem.command.CommandLineHandler;
import edu.unc.cem.correct.Calculator;
import edu.unc.cem.correct.CemReader;
import edu.unc.cem.correct.CemWriter;
import edu.unc.cem.util.CemEvent;
import edu.unc.cem.util.CommaDelimitedTokenizer;
import edu.unc.cem.util.Constants;
import edu.unc.cem.util.PropertiesManager;
import edu.unc.cem.util.Tokenizer;
import edu.unc.cem.util.VersionInfo;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CemCorrect {
    private String configHome;
    private String configFile;
    private String inputHome;
    private String outputHome;
    private String rptPrefix;
    private String rptSuffix;
    private List<String> states;
    private Map<String, List<String>> inputFiles = new HashMap<String, List<String>>();
    private String events;
    private Map<String, CemEvent> eventMap;
    private PropertiesManager propertiesManager;
    private List<String> validStates = Arrays.asList(Constants.VALID_STATES);
    private Tokenizer tokenizer;

    public CemCorrect(Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    public void loadProperties(CommandLineHandler command) throws Exception {
        Object temp;
        if (command != null) {
            temp = command.getOption("config.home");
            if (temp != null && temp.get(0) != null) {
                this.configHome = temp.get(0).trim();
            }
            if ((temp = command.getOption("config.file")) != null && temp.get(0) != null) {
                this.configFile = temp.get(0).trim();
            }
            if ((temp = command.getOption("states.list")) != null && temp.get(0) != null) {
                this.states = temp;
            }
            if ((temp = command.getOption("input.dir")) != null && temp.get(0) != null) {
                this.inputHome = ((String)temp.get(0)).trim();
            }
            if ((temp = command.getOption("output.dir")) != null && temp.get(0) != null) {
                this.outputHome = temp.get(0).trim();
            }
            if ((temp = command.getOption("report.prefix")) != null && temp.get(0) != null) {
                this.rptPrefix = temp.get(0).trim();
            }
            if ((temp = command.getOption("report.suffix")) != null && temp.get(0) != null) {
                this.rptSuffix = temp.get(0).trim();
            }
        }
        if (this.configFile == null || this.configFile.isEmpty()) {
            this.configFile = "config/config.properties";
        }
        this.propertiesManager = new PropertiesManager(this.configHome == null || this.configHome.isEmpty() ? this.configFile : String.valueOf(this.configHome) + File.separator + this.configFile);
        if (this.states == null || this.states.size() == 0) {
            temp = this.propertiesManager.getProperty("states.list");
            if (temp == null || ((String)temp).trim().length() == 0) {
                temp = "ALL";
            }
            this.states = Arrays.asList(this.tokenizer.tokens((String)temp));
        }
        if (this.inputHome == null || this.inputHome.isEmpty()) {
            this.inputHome = this.propertiesManager.getProperty("input.dir");
        }
        if (this.outputHome == null || this.outputHome.isEmpty()) {
            this.outputHome = this.propertiesManager.getProperty("output.dir");
        }
        if (this.rptPrefix == null || this.rptPrefix.isEmpty()) {
            this.rptPrefix = this.propertiesManager.getProperty("report.prefix");
        }
        if (this.rptSuffix == null || this.rptSuffix.isEmpty()) {
            this.rptSuffix = this.propertiesManager.getProperty("report.suffix");
        }
        if (this.rptPrefix == null) {
            this.rptPrefix = "";
        }
        if (this.rptSuffix == null) {
            this.rptSuffix = "";
        }
        if (!this.rptPrefix.endsWith("_")) {
            this.rptPrefix = String.valueOf(this.rptPrefix) + "_";
        }
        if (!this.rptSuffix.startsWith("_")) {
            this.rptSuffix = "_" + this.rptSuffix;
        }
        this.registerInputFiles(this.states, command);
        this.registerInputFiles(this.states, this.propertiesManager);
        if (this.events == null) {
            this.events = this.propertiesManager.getProperty("events");
        }
        this.eventMap = this.propertiesManager.parseEvent(this.events);
        this.propertiesManager.printEventMap(this.eventMap);
        this.propertiesManager = null;
        command = null;
    }

    private void processStateFiles(String state) throws Exception {
        List<String> files = this.inputFiles.get(state);
        CemReader reader = null;
        CemWriter writer = null;
        Calculator calculator = new Calculator(this.tokenizer);
        calculator.setEventMap(this.eventMap);
        int index = 0;
        while (index < files.size()) {
            File inputfile = new File(String.valueOf(this.inputHome) + File.separator + files.get(index));
            reader = new CemReader(inputfile);
            reader.open();
            calculator.addRecords(reader.read(), inputfile);
            reader.close();
            reader.finalize();
            System.out.println(inputfile.getName());
            ++index;
        }
        calculator.calculateMeans();
        String fs = File.separator;
        File log = new File(String.valueOf(this.outputHome) + fs + "logs" + fs + state + "_" + "log.txt");
        File report = new File(String.valueOf(this.outputHome) + fs + "logs" + fs + this.rptPrefix + state + this.rptSuffix + ".csv");
        File sumReport = new File(String.valueOf(this.outputHome) + fs + "logs" + fs + this.rptPrefix + state + this.rptSuffix + "_anomalies.csv");
        if (log.exists()) {
            log.delete();
        }
        if (report.exists()) {
            report.delete();
        }
        if (sumReport.exists()) {
            sumReport.delete();
        }
        System.out.println("Writing:");
        int index2 = 0;
        while (index2 < files.size()) {
            File input = new File(String.valueOf(this.inputHome) + fs + files.get(index2));
            File output = new File(String.valueOf(this.outputHome) + fs + files.get(index2));
            writer = new CemWriter(input, output, log, report, sumReport);
            writer.write(calculator);
            writer.close();
            writer.finalize();
            System.out.println(output.getName());
            ++index2;
        }
    }

    public void process() {
        if (this.inputHome == null || this.inputHome.trim().isEmpty()) {
            System.out.println("Input directory is not specified.");
            System.exit(1);
        }
        for (String st : this.states) {
            try {
                if (st == null || st.isEmpty()) continue;
                this.processStateFiles(st);
            }
            catch (Exception e) {
                System.out.println("Error reading files for state: " + st + ".");
                e.printStackTrace();
            }
        }
    }

    public void generateReports() {
        System.out.println("Reports generated.");
    }

    private void registerInputFiles(List<String> sts, CommandLineHandler command) throws Exception {
        Class<Constants> cemConstants = Constants.class;
        Constants contnts = new Constants();
        for (String state : sts) {
            if (!this.validStates.contains(state = state.toUpperCase())) continue;
            System.out.println(state);
            String stateFilesId = (String)cemConstants.getField(state).get(contnts);
            System.out.println(stateFilesId);
            this.inputFiles.put(state, command.getOption(stateFilesId));
        }
    }

    private void registerInputFiles(List<String> sts, PropertiesManager manager) throws Exception {
        if (sts == null || sts.size() == 0 || manager == null) {
            return;
        }
        Class<Constants> cemConstants = Constants.class;
        Constants contnts = new Constants();
        for (String state : sts) {
            if (!this.validStates.contains(state = state.toUpperCase())) continue;
            String stateFilesId = (String)cemConstants.getField(state).get(contnts);
            String files = manager.getProperty(stateFilesId);
            if (this.inputFiles.get(state) != null) continue;
            this.inputFiles.put(state, Arrays.asList(this.tokenizer.tokens(files)));
        }
    }

    public void printProperties() {
        System.out.println("Loaded Properties =====>");
        System.out.println("config.home: " + this.configHome);
        System.out.println("config.file: " + this.configFile);
        System.out.println("input.dir: " + this.inputHome);
        System.out.println("output.dir: " + this.outputHome);
        System.out.println("states.list: " + this.states);
        Set<String> keys = this.inputFiles.keySet();
        for (String key : keys) {
            System.out.println(String.valueOf(key) + " files: " + this.inputFiles.get(key));
        }
    }

    public static void main(String[] args) {
        if (args.length > 0 && (args[0].equalsIgnoreCase("-v") || args[0].equalsIgnoreCase("-version"))) {
            System.out.println("CemCorrect version: " + VersionInfo.getVersion() + ", built on: " + VersionInfo.getDate() + ".");
            System.exit(0);
        }
        System.out.println("Running CemCorrect Program...\n");
        CommandLineHandler command = new CommandLineHandler(args);
        CemCorrect exe = new CemCorrect(new CommaDelimitedTokenizer());
        try {
            System.out.println("Loading config properties...\n");
            exe.loadProperties(command);
        }
        catch (Exception e) {
            System.out.print("Error fetching properties.");
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println("Started processing the input files...\n");
        exe.process();
        exe.generateReports();
    }
}

