/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.cem.util;

import edu.unc.cem.util.Constants;
import java.util.Date;

public class CemEvent {
    private Date start = null;
    private Date end = null;

    public CemEvent() {
    }

    public CemEvent(Date start) {
        this.start = start;
    }

    public CemEvent(Date start, Date end) throws Exception {
        this.start = start;
        this.end = end;
        this.validate();
    }

    public void setStart(Date start) throws Exception {
        this.start = start;
        this.validate();
    }

    public Date getStart() {
        return this.start;
    }

    public void setEnd(Date end) throws Exception {
        this.end = end;
        this.validate();
    }

    public Date getEnd() {
        return this.end;
    }

    public String toString() {
        return "Start: " + (this.start == null ? "null" : this.start.toLocaleString()) + "\n" + "End: " + (this.end == null ? "null" : this.end.toLocaleString());
    }

    private void validate() throws Exception {
        if (this.start != null && this.end != null) {
            if (this.start.getYear() != this.end.getYear()) {
                throw new Exception("Start and end date should be in the same year: \n" + this.toString());
            }
            if (this.start.equals(this.end) || this.start.after(this.end)) {
                throw new Exception("Start date should be before end date: \n" + this.toString());
            }
        }
    }

    public static int getNumPeriodsSO2(CemEvent event) throws Exception {
        if (event == null) {
            return 1;
        }
        int numPeriods = 1;
        Date start = event.getStart();
        Date end = event.getEnd();
        if (start == null) {
            throw new Exception("Event - " + event.toString() + " - start date is null!");
        }
        Date jan1 = new Date(start.getYear(), Constants.JAN, 1);
        numPeriods = start.equals(jan1) ? (end == null ? 1 : 2) : (end == null ? 2 : 3);
        return numPeriods;
    }

    public void testGetNumPeriodsSO2() {
        Date[] dates = new Date[]{new Date(107, 0, 1), new Date(107, 0, 2), new Date(107, 1, 4), new Date(107, 3, 30), new Date(107, 4, 1), new Date(107, 4, 2), new Date(107, 7, 1), new Date(107, 8, 30), new Date(107, 9, 1), new Date(107, 9, 2), new Date(107, 10, 1), new Date(107, 11, 31)};
        CemEvent event = null;
        try {
            if (CemEvent.getNumPeriodsSO2(event) != 1) {
                System.out.println("Wrong num SO2 periods for null event");
            }
            if (CemEvent.getNumPeriodsSO2(event = new CemEvent(dates[0])) != 1) {
                System.out.println("Wrong num SO2 periods for event: " + event.toString());
            }
            int numDates = dates.length;
            boolean num = false;
            int i = 1;
            while (i < numDates) {
                event = new CemEvent(dates[i]);
                if (CemEvent.getNumPeriodsSO2(event) != 2) {
                    System.out.println("Wrong num SO2 periods for event: " + event.toString());
                }
                ++i;
            }
            int j = 1;
            while (j < numDates) {
                event = new CemEvent(dates[0], dates[j]);
                if (CemEvent.getNumPeriodsSO2(event) != 2) {
                    System.out.println("Wrong num SO2 periods for event: " + event.toString());
                }
                ++j;
            }
            i = 1;
            while (i < numDates) {
                int j2 = i + 1;
                while (j2 < numDates) {
                    event = new CemEvent(dates[i], dates[j2]);
                    if (CemEvent.getNumPeriodsSO2(event) != 3) {
                        System.out.println("Wrong num SO2 periods for event: " + event.toString());
                    }
                    ++j2;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("===End of testing getNumPeriodsSO2!");
    }

    public static int getPeriodIndexSO2(CemEvent event, int month, int day) throws Exception {
        if (event == null) {
            return 0;
        }
        Date start = event.getStart();
        Date end = event.getEnd();
        if (start == null) {
            throw new Exception("Event - " + event.toString() + " - start date is null!");
        }
        Date jan1 = new Date(start.getYear(), Constants.JAN, 1);
        if (start.equals(jan1)) {
            if (end == null) {
                return 0;
            }
            if (month < end.getMonth() || month == end.getMonth() && day < end.getDate()) {
                return 0;
            }
            return 1;
        }
        if (end == null) {
            if (month < start.getMonth() || month == start.getMonth() && day < start.getDate()) {
                return 0;
            }
            return 1;
        }
        if (month < start.getMonth() || month == start.getMonth() && day < start.getDate()) {
            return 0;
        }
        if (month > end.getMonth() || month == end.getMonth() && day >= end.getDate()) {
            return 2;
        }
        return 1;
    }

    public void testGetPeriodIndexSO2() {
        Date[] dates = new Date[]{new Date(107, 0, 1), new Date(107, 0, 2), new Date(107, 1, 4), new Date(107, 3, 30), new Date(107, 4, 1), new Date(107, 4, 2), new Date(107, 7, 1), new Date(107, 8, 30), new Date(107, 9, 1), new Date(107, 9, 2), new Date(107, 10, 1), new Date(107, 11, 31)};
        CemEvent event = null;
        try {
            if (CemEvent.getPeriodIndexSO2(event, 0, 1) != 0) {
                System.out.println("Wrong getPeriodIndexSO2 for null event");
            }
            if (CemEvent.getPeriodIndexSO2(event = new CemEvent(dates[0]), 0, 1) != 0) {
                System.out.println("Wrong getPeriodIndexSO2 for event: " + event.toString() + " and mon=1, day=1");
            }
            if (CemEvent.getPeriodIndexSO2(event, 11, 31) != 0) {
                System.out.println("Wrong getPeriodIndexSO2 for event: " + event.toString() + " and mon=12, day=31");
            }
            if (CemEvent.getPeriodIndexSO2(event = new CemEvent(dates[1]), 0, 1) != 0) {
                System.out.println("Wrong getPeriodIndexSO2 for event: " + event.toString() + " and mon=1, day=1");
            }
            if (CemEvent.getPeriodIndexSO2(event, 0, 2) != 1) {
                System.out.println("Wrong getPeriodIndexSO2 for event: " + event.toString() + " and mon=1, day=2");
            }
            if (CemEvent.getPeriodIndexSO2(event, 11, 31) != 1) {
                System.out.println("Wrong getPeriodIndexSO2 for event: " + event.toString() + " and mon=12, day=31");
            }
            if (CemEvent.getPeriodIndexSO2(event = new CemEvent(dates[11]), 0, 1) != 0) {
                System.out.println("Wrong getPeriodIndexSO2 for event: " + event.toString() + " and mon=1, day=1");
            }
            if (CemEvent.getPeriodIndexSO2(event, 11, 30) != 0) {
                System.out.println("Wrong getPeriodIndexSO2 for event: " + event.toString() + " and mon=12, day=30");
            }
            if (CemEvent.getPeriodIndexSO2(event, 11, 31) != 1) {
                System.out.println("Wrong getPeriodIndexSO2 for event: " + event.toString() + " and mon=12, day=31");
            }
            if (CemEvent.getPeriodIndexSO2(event = new CemEvent(dates[0], dates[1]), 0, 1) != 0) {
                System.out.println("Wrong getPeriodIndexSO2 for event: " + event.toString() + " and mon=1, day=1");
            }
            if (CemEvent.getPeriodIndexSO2(event, 0, 2) != 1) {
                System.out.println("Wrong getPeriodIndexSO2 for event: " + event.toString() + " and mon=1, day=2");
            }
            if (CemEvent.getPeriodIndexSO2(event, 11, 31) != 1) {
                System.out.println("Wrong getPeriodIndexSO2 for event: " + event.toString() + " and mon=12, day=31");
            }
            if (CemEvent.getPeriodIndexSO2(event = new CemEvent(dates[0], dates[11]), 0, 1) != 0) {
                System.out.println("Wrong getPeriodIndexSO2 for event: " + event.toString() + " and mon=1, day=1");
            }
            if (CemEvent.getPeriodIndexSO2(event, 11, 30) != 0) {
                System.out.println("Wrong getPeriodIndexSO2 for event: " + event.toString() + " and mon=12, day=30");
            }
            if (CemEvent.getPeriodIndexSO2(event, 11, 31) != 1) {
                System.out.println("Wrong getPeriodIndexSO2 for event: " + event.toString() + " and mon=12, day=31");
            }
            if (CemEvent.getPeriodIndexSO2(event = new CemEvent(dates[1], dates[2]), 0, 1) != 0) {
                System.out.println("Wrong getPeriodIndexSO2 for event: " + event.toString() + " and mon=1, day=1");
            }
            if (CemEvent.getPeriodIndexSO2(event, 1, 3) != 1) {
                System.out.println("Wrong getPeriodIndexSO2 for event: " + event.toString() + " and mon=2, day=3");
            }
            if (CemEvent.getPeriodIndexSO2(event, 1, 4) != 2) {
                System.out.println("Wrong getPeriodIndexSO2 for event: " + event.toString() + " and mon=2, day=4");
            }
            if (CemEvent.getPeriodIndexSO2(event = new CemEvent(dates[2], dates[11]), 1, 3) != 0) {
                System.out.println("Wrong getPeriodIndexSO2 for event: " + event.toString() + " and mon=2, day=3");
            }
            if (CemEvent.getPeriodIndexSO2(event, 1, 4) != 1) {
                System.out.println("Wrong getPeriodIndexSO2 for event: " + event.toString() + " and mon=2, day=4");
            }
            if (CemEvent.getPeriodIndexSO2(event, 11, 30) != 1) {
                System.out.println("Wrong getPeriodIndexSO2 for event: " + event.toString() + " and mon=12, day=30");
            }
            if (CemEvent.getPeriodIndexSO2(event, 11, 31) != 2) {
                System.out.println("Wrong getPeriodIndexSO2 for event: " + event.toString() + " and mon=12, day=31");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("===End of testing testGetPeriodIndexSO2!");
    }

    public static int getNumPeriodsNOx(CemEvent event) throws Exception {
        if (event == null) {
            return 2;
        }
        int numPeriods = 2;
        Date start = event.getStart();
        Date end = event.getEnd();
        if (start == null) {
            throw new Exception("Event - " + event.toString() + " - start date is null!");
        }
        Date jan1 = new Date(start.getYear(), Constants.JAN, 1);
        Date may1 = new Date(start.getYear(), Constants.MAY, 1);
        Date oct1 = new Date(start.getYear(), Constants.OCT, 1);
        numPeriods = start.equals(jan1) ? (end == null ? 2 : (end.after(may1) && end.before(oct1) ? 4 : 3)) : (start.after(jan1) && start.before(may1) ? (end != null && end.after(may1) && end.before(oct1) ? 4 : 3) : (start.equals(may1) ? (end != null && end.equals(oct1) ? 2 : 3) : (start.after(may1) && start.before(oct1) ? (end != null && (end.before(oct1) || end.equals(oct1)) ? 3 : 4) : 3)));
        return numPeriods;
    }

    public void testGetNumPeriodsNOx() {
        Date[] dates = new Date[]{new Date(107, 0, 1), new Date(107, 0, 2), new Date(107, 1, 4), new Date(107, 3, 30), new Date(107, 4, 1), new Date(107, 4, 2), new Date(107, 7, 1), new Date(107, 8, 30), new Date(107, 9, 1), new Date(107, 9, 2), new Date(107, 10, 1), new Date(107, 11, 31)};
        CemEvent event = null;
        try {
            if (CemEvent.getNumPeriodsNOx(event) != 2) {
                System.out.println("Wrong num NOx periods for null event");
            }
            if (CemEvent.getNumPeriodsNOx(event = new CemEvent(dates[0])) != 2) {
                System.out.println("Wrong num NOx periods for event: " + event.toString());
            }
            if (CemEvent.getNumPeriodsNOx(event = new CemEvent(dates[3])) != 3) {
                System.out.println("Wrong num NOx periods for event: " + event.toString());
            }
            if (CemEvent.getNumPeriodsNOx(event = new CemEvent(dates[4])) != 3) {
                System.out.println("Wrong num NOx periods for event: " + event.toString());
            }
            if (CemEvent.getNumPeriodsNOx(event = new CemEvent(dates[7])) != 4) {
                System.out.println("Wrong num NOx periods for event: " + event.toString());
            }
            if (CemEvent.getNumPeriodsNOx(event = new CemEvent(dates[8])) != 3) {
                System.out.println("Wrong num NOx periods for event: " + event.toString());
            }
            if (CemEvent.getNumPeriodsNOx(event = new CemEvent(dates[11])) != 3) {
                System.out.println("Wrong num NOx periods for event: " + event.toString());
            }
            if (CemEvent.getNumPeriodsNOx(new CemEvent(dates[0], dates[1])) != 3 || CemEvent.getNumPeriodsNOx(new CemEvent(dates[0], dates[2])) != 3 || CemEvent.getNumPeriodsNOx(new CemEvent(dates[0], dates[3])) != 3 || CemEvent.getNumPeriodsNOx(new CemEvent(dates[0], dates[4])) != 3 || CemEvent.getNumPeriodsNOx(new CemEvent(dates[0], dates[5])) != 4 || CemEvent.getNumPeriodsNOx(new CemEvent(dates[0], dates[6])) != 4 || CemEvent.getNumPeriodsNOx(new CemEvent(dates[0], dates[7])) != 4 || CemEvent.getNumPeriodsNOx(new CemEvent(dates[0], dates[8])) != 3 || CemEvent.getNumPeriodsNOx(new CemEvent(dates[0], dates[9])) != 3 || CemEvent.getNumPeriodsNOx(new CemEvent(dates[0], dates[10])) != 3 || CemEvent.getNumPeriodsNOx(new CemEvent(dates[0], dates[11])) != 3 || CemEvent.getNumPeriodsNOx(new CemEvent(dates[1], dates[2])) != 3 || CemEvent.getNumPeriodsNOx(new CemEvent(dates[1], dates[3])) != 3 || CemEvent.getNumPeriodsNOx(new CemEvent(dates[1], dates[4])) != 3 || CemEvent.getNumPeriodsNOx(new CemEvent(dates[1], dates[5])) != 4 || CemEvent.getNumPeriodsNOx(new CemEvent(dates[1], dates[7])) != 4 || CemEvent.getNumPeriodsNOx(new CemEvent(dates[1], dates[8])) != 3 || CemEvent.getNumPeriodsNOx(new CemEvent(dates[1], dates[9])) != 3 || CemEvent.getNumPeriodsNOx(new CemEvent(dates[1], dates[11])) != 3 || CemEvent.getNumPeriodsNOx(new CemEvent(dates[3], dates[4])) != 3 || CemEvent.getNumPeriodsNOx(new CemEvent(dates[3], dates[5])) != 4 || CemEvent.getNumPeriodsNOx(new CemEvent(dates[3], dates[7])) != 4 || CemEvent.getNumPeriodsNOx(new CemEvent(dates[3], dates[8])) != 3 || CemEvent.getNumPeriodsNOx(new CemEvent(dates[3], dates[9])) != 3 || CemEvent.getNumPeriodsNOx(new CemEvent(dates[3], dates[11])) != 3 || CemEvent.getNumPeriodsNOx(new CemEvent(dates[4], dates[5])) != 3 || CemEvent.getNumPeriodsNOx(new CemEvent(dates[4], dates[7])) != 3 || CemEvent.getNumPeriodsNOx(new CemEvent(dates[4], dates[8])) != 2 || CemEvent.getNumPeriodsNOx(new CemEvent(dates[4], dates[9])) != 3 || CemEvent.getNumPeriodsNOx(new CemEvent(dates[4], dates[11])) != 3 || CemEvent.getNumPeriodsNOx(new CemEvent(dates[5], dates[7])) != 3 || CemEvent.getNumPeriodsNOx(new CemEvent(dates[5], dates[8])) != 3 || CemEvent.getNumPeriodsNOx(new CemEvent(dates[5], dates[9])) != 4 || CemEvent.getNumPeriodsNOx(new CemEvent(dates[5], dates[11])) != 4 || CemEvent.getNumPeriodsNOx(new CemEvent(dates[7], dates[8])) != 3 || CemEvent.getNumPeriodsNOx(new CemEvent(dates[7], dates[9])) != 4 || CemEvent.getNumPeriodsNOx(new CemEvent(dates[7], dates[11])) != 4 || CemEvent.getNumPeriodsNOx(new CemEvent(dates[8], dates[9])) != 3 || CemEvent.getNumPeriodsNOx(new CemEvent(dates[8], dates[11])) != 3 || CemEvent.getNumPeriodsNOx(new CemEvent(dates[9], dates[11])) != 3) {
                System.out.println("Wrong num NOx periods for event: ");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("===End of testing getNumPeriodsNOx!");
    }

    public static int getPeriodIndexNOx(CemEvent event, int month, int day) throws Exception {
        if (event == null) {
            if (month < Constants.MAY || month >= Constants.OCT) {
                return 0;
            }
            return 1;
        }
        Date start = event.getStart();
        Date end = event.getEnd();
        if (start == null) {
            throw new Exception("Event - " + event.toString() + " - start date is null!");
        }
        Date jan1 = new Date(start.getYear(), Constants.JAN, 1);
        Date may1 = new Date(start.getYear(), Constants.MAY, 1);
        Date oct1 = new Date(start.getYear(), Constants.OCT, 1);
        if (start.equals(jan1)) {
            if (end == null) {
                if (month < Constants.MAY || month >= Constants.OCT) {
                    return 0;
                }
                return 1;
            }
            if (end.equals(may1) || end.equals(oct1)) {
                if (month < Constants.MAY) {
                    return 0;
                }
                if (month >= Constants.OCT) {
                    return 2;
                }
                return 1;
            }
            if (end.before(may1)) {
                if (month < Constants.MAY) {
                    if (month < end.getMonth() || month == end.getMonth() && day < end.getDate()) {
                        return 0;
                    }
                    return 1;
                }
                if (month >= Constants.MAY && month < Constants.OCT) {
                    return 2;
                }
                return 1;
            }
            if (end.after(oct1)) {
                if (month < Constants.MAY) {
                    return 0;
                }
                if (month >= Constants.MAY && month < Constants.OCT) {
                    return 1;
                }
                if (month < end.getMonth() || month == end.getMonth() && day < end.getDate()) {
                    return 0;
                }
                return 2;
            }
            if (month < Constants.MAY) {
                return 0;
            }
            if (month >= Constants.MAY && month < Constants.OCT) {
                if (month < end.getMonth() || month == end.getMonth() && day < end.getDate()) {
                    return 1;
                }
                return 2;
            }
            return 3;
        }
        if (start.after(jan1) && start.before(may1)) {
            if (month < start.getMonth() || month == start.getMonth() && day < start.getDate()) {
                return 0;
            }
            if (end == null) {
                if (month < Constants.MAY) {
                    return 1;
                }
                if (month >= Constants.MAY && month < Constants.OCT) {
                    return 2;
                }
                return 1;
            }
            if (end.equals(may1) || end.equals(oct1)) {
                if (month < Constants.MAY) {
                    return 1;
                }
                if (month >= Constants.MAY && month < Constants.OCT) {
                    return 2;
                }
                return 0;
            }
            if (end.before(may1)) {
                if (month < Constants.MAY) {
                    if (month > end.getMonth() || month == end.getMonth() && day >= end.getDate()) {
                        return 0;
                    }
                    return 1;
                }
                if (month >= Constants.MAY && month < Constants.OCT) {
                    return 2;
                }
                return 0;
            }
            if (end.after(may1) && end.before(oct1)) {
                if (month < Constants.MAY) {
                    return 1;
                }
                if (month >= Constants.MAY && month < Constants.OCT) {
                    if (month < end.getMonth() || month == end.getMonth() && day < end.getDate()) {
                        return 2;
                    }
                    return 3;
                }
                return 0;
            }
            if (month < Constants.MAY) {
                return 1;
            }
            if (month >= Constants.MAY && month < Constants.OCT) {
                return 2;
            }
            if (month < end.getMonth() || month == end.getMonth() && day < end.getDate()) {
                return 1;
            }
            return 0;
        }
        if (start.equals(may1)) {
            if (month < Constants.MAY) {
                return 0;
            }
            if (end == null) {
                if (month >= Constants.MAY && month < Constants.OCT) {
                    return 1;
                }
                return 2;
            }
            if (end.equals(oct1)) {
                if (month >= Constants.MAY && month < Constants.OCT) {
                    return 1;
                }
                return 0;
            }
            if (end.before(oct1)) {
                if (month >= Constants.MAY && month < Constants.OCT) {
                    if (month < end.getMonth() || month == end.getMonth() && day < end.getDate()) {
                        return 1;
                    }
                    return 2;
                }
                return 0;
            }
            if (month >= Constants.MAY && month < Constants.OCT) {
                return 1;
            }
            if (month < end.getMonth() || month == end.getMonth() && day < end.getDate()) {
                return 2;
            }
            return 0;
        }
        if (start.after(may1) && start.before(oct1)) {
            if (Constants.DEBUG && start.getMonth() == 7) {
                System.out.print("");
            }
            if (month < Constants.MAY) {
                return 0;
            }
            if (end == null) {
                if (month >= Constants.MAY && month < Constants.OCT) {
                    if (month < start.getMonth() || month == start.getMonth() && day < start.getDate()) {
                        return 1;
                    }
                    return 2;
                }
                return 3;
            }
            if (end.equals(oct1)) {
                if (month >= Constants.MAY && month < Constants.OCT) {
                    if (month < start.getMonth() || month == start.getMonth() && day < start.getDate()) {
                        return 1;
                    }
                    return 2;
                }
                return 0;
            }
            if (end.before(oct1)) {
                if (month >= Constants.MAY && month < Constants.OCT) {
                    if (month < start.getMonth() || month == start.getMonth() && day < start.getDate()) {
                        return 1;
                    }
                    if (month > end.getMonth() || month == end.getMonth() && day >= end.getDate()) {
                        return 1;
                    }
                    return 2;
                }
                return 0;
            }
            if (month >= Constants.MAY && month < Constants.OCT) {
                if (month < start.getMonth() || month == start.getMonth() && day < start.getDate()) {
                    return 1;
                }
                return 2;
            }
            if (month > end.getMonth() || month == end.getMonth() && day >= end.getDate()) {
                return 0;
            }
            return 3;
        }
        if (start.equals(oct1)) {
            if (month < Constants.MAY) {
                return 0;
            }
            if (month >= Constants.MAY && month < Constants.OCT) {
                return 1;
            }
            if (end == null) {
                return 2;
            }
            if (month < end.getMonth() || month == end.getMonth() && day < end.getDate()) {
                return 2;
            }
            return 0;
        }
        if (month < Constants.MAY) {
            return 0;
        }
        if (month >= Constants.MAY && month < Constants.OCT) {
            return 1;
        }
        if (start.equals(oct1)) {
            if (end == null) {
                return 2;
            }
            if (month < end.getMonth() || month == end.getMonth() && day < end.getDate()) {
                return 2;
            }
            return 0;
        }
        if (end == null) {
            if (month < start.getMonth() || month == start.getMonth() && day < start.getDate()) {
                return 0;
            }
            return 2;
        }
        if (month < start.getMonth() || month == start.getMonth() && day < start.getDate()) {
            return 0;
        }
        if (month > end.getMonth() || month == end.getMonth() && day >= end.getDate()) {
            return 0;
        }
        return 2;
    }

    private void testIndexingHelper(CemEvent event) throws Exception {
        int numMonDayPairs = 11;
        int[] nArray = new int[11];
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 8;
        nArray[7] = 9;
        nArray[8] = 9;
        nArray[9] = 10;
        nArray[10] = 11;
        int[] mons = nArray;
        int[] days = new int[]{1, 2, 1, 30, 1, 1, 30, 1, 2, 1, 31};
        int i = 0;
        while (i < numMonDayPairs) {
            int index = CemEvent.getPeriodIndexNOx(event, mons[i], days[i]);
            this.printIndex(event, mons[i], days[i], index);
            ++i;
        }
    }

    public void testNOXIndexing() {
        Date[] dates = new Date[]{new Date(107, 0, 1), new Date(107, 0, 2), new Date(107, 1, 4), new Date(107, 3, 30), new Date(107, 4, 1), new Date(107, 4, 2), new Date(107, 7, 1), new Date(107, 8, 30), new Date(107, 9, 1), new Date(107, 9, 2), new Date(107, 10, 1), new Date(107, 11, 31)};
        try {
            int numDates = dates.length;
            int i = 0;
            while (i < numDates) {
                System.out.println("========");
                System.out.println("start: " + dates[i].getMonth() + "-" + dates[i].getDate());
                System.out.println("========");
                this.testIndexingHelper(new CemEvent(dates[i]));
                int j = i + 1;
                while (j < numDates) {
                    System.out.println("========");
                    this.testIndexingHelper(new CemEvent(dates[i], dates[j]));
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printIndex(CemEvent event, int mon, int day, int index) {
        System.out.print(String.valueOf(index) + ",");
    }

    public static void main(String[] args) {
        CemEvent cal = new CemEvent(null);
        cal.testGetNumPeriodsNOx();
        cal.testNOXIndexing();
    }
}

