      subroutine wremar( ierr,
     &                         iounit, irec )
c
c-----------------------------------------------------------------------
c
c    writes one record of the data section of EMAR using the variables
c    stored in common block
c
c    Argument declaration.
c     Outputs:
c       ierr   I error flag
c     Inputs:
c       iounit I logical unit number of file to read
c       irec   I count of record for messages
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c      11/10/91  --gmw--  original development
c
c-----------------------------------------------------------------------
c    Include files:
c-----------------------------------------------------------------------
c
      include 'param.inc'
      include 'embrdat.inc'
c
c-----------------------------------------------------------------------
c    Argument declarations:
c-----------------------------------------------------------------------
c
      integer*4 ierr
      integer*4 iounit
      integer*4 irec
c
c-----------------------------------------------------------------------
c    local parameters:
c-----------------------------------------------------------------------
c
c   keydat  C   parameter for /DATA/ keyword
c
      character*(KEYLEN) keydat
c
      parameter( keydat = '/DATA/' )
c
c-----------------------------------------------------------------------
c    Local variables:
c-----------------------------------------------------------------------
c
      integer*4          i, j, k
c
c-----------------------------------------------------------------------
c   Entry point:
c-----------------------------------------------------------------------
c
c   --- set error flag ---
c
      ierr = IFAIL
c
c   --- if this is the first record, write the /DATA/ keyword ---
c
      if( irec .EQ. 1 ) write(iounit,9000,ERR=7000) keydat
c
c   --- write EMBR record ---
c
      write(iounit,9001,ERR=7000 ) fipin, sbrgn, siccd, scccd, rectyp,
     &                         emstyp, invbeg, invend, ijcell,
     &                         plant, facnox, facvoc, istack,
     &                         point, isegno, utme, utmn, iutmzn
      write(iounit,9002,ERR=7000 ) stkgev, stkdia, stktmp, stkhgt
      do 10 i=1,MXCRIT,3
          k = min(i+2,MXCRIT)
          write(iounit,9003,ERR=7000 ) (emout(j),iceqcd(j),ceqeff(j),
     &                              ruleff(j),rulpen(j),j=i,k)
  10  continue
      do 20 i=1,MXSPEC,10
          k = min(i+9,MXSPEC)
         write(iounit,9004,ERR=7000 ) (spcout(j),j=i,k)
  20  continue
c
c   --- set error flag to success ---
c
      ierr = ISUCES
      goto 9999
c
c-----------------------------------------------------------------------
c   Error messages:
c-----------------------------------------------------------------------
c
 7000 continue
      write(IOWSTD,9005,ERR=9999) 'ERROR: Writing data record to ',
     &                                       'EMAR file at record:',irec
      goto 9999
c
c-----------------------------------------------------------------------
c   Format statements:
c-----------------------------------------------------------------------
c
 9000 format(a)
 9001 format(a5,1x,a5,1x,a4,1x,a10,1x,a1,1x,a2,1x,i8,1x,i8,1x,i6,1x,a5,
     &       1x,e10.4,1x,e10.4,1x,i3,1x,a3,1x,i3,1x,f7.2,1x,f7.2,1x,i2)
 9002 format(5x,f6.2,1x,f6.2,1x,f6.1,1x,f6.2,2(1x,e10.4,1x,i3,1x,f6.2,
     &                                                1x,f6.2,1x,f6.2))
 9003 format(5x,3(e10.4,1x,i3,1x,f6.2,1x,f6.2,1x,f6.2,1x))
 9004 format(5x,10(1x,e10.4))
 9005 format(/,1x,a,a,i5,/)
c
c-----------------------------------------------------------------------
c   Return point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
