      subroutine rdemis (ierr,
     &                  ifile, iounit, ihour, ladj)
c
c
c-----------------------------------------------------------------------
c
c    reads the currents hour's emissions from UAM file attached to file
c    unit "iounit".  the emissions are placed in the array in the order
c    of the ewquested species.
c
c-----------------------------------------------------------------------
c
c    Argument Declaration.
c     outputs:
c       ierr  i  error code
c     inputs:
c       ifile  i  file identifier
c       iounit i  unit number for reading file
c       ihour  i  hour (1-24)
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c     10/25/91  --hjt--  original development
c     12/01/92  --gmw--  changed calculation if hour index to ensure
c                        there is no array overflow.
c
c-----------------------------------------------------------------------
c    Include Files:
c-----------------------------------------------------------------------
c
      include 'param.inc'
      include 'mrguam.inc'
      include 'uamregn.inc'
      include 'rdemis.inc'
      include 'rdmrgu.inc'
c
c-----------------------------------------------------------------------
c  Argument Declaration
c-----------------------------------------------------------------------
c
      integer*4 ierr
      integer*4 ifile
      integer*4 iounit
      integer*4 ihour
      logical*4 ladj
c
c-----------------------------------------------------------------------
c    Local Variables:
c-----------------------------------------------------------------------
c
c   bt     r  beginning time
c   et     r  ending time
c   i      i  loop variable
c   ibd    i  beginning date
c   ied    i  ending date
c   inttmp i  temporary integer for type conversions
c   ispc   i  species loop
c   ispdex i  species index
c   itmpnm i  species name in integer format
c   ixloop i  loop for x coordinates
c   iyloop i  loop for y coordinates
c   j      i  loop variable
c   nseg   i  number of segments
c   string c  for holding species name
c   tempch c  single character
c
      integer*4 ibd, ied, ispc, ispdex, ixloop, iyloop, inttmp
      integer*4 itmpnm(10), nseg, i, j
      real*4    bt, et
c
c-----------------------------------------------------------------------
c   Entry Point:
c-----------------------------------------------------------------------
c
c   --- assume failure
c
      ierr = IFAIL
c
c   --- check for time record
c       et, converted to integer, should equal ihour
c       bt, converted to integer, should be 1 less
c       don't check ibd and ed, assume okay ---
c
      read (iounit,end=7020,ERR=7000) ibd, bt, ied, et
c
c   --- compare times ---
c
      inttmp = int(et)
      if( inttmp .EQ. 0 .AND. ibd .LT. ied ) inttmp = 24
      if(inttmp .NE. ihour) goto 7010
      inttmp = min(int(bt)+1,24)
      if(inttmp .NE. ihour) goto 7010
c
c   --- iscnt is number of species for each input file ---
c
      do 150 ispc = 1, iscnt(ifile)
          read (iounit,ERR=7000) nseg, (itmpnm(i),i=1,10),
     &        ((uin(i,j),i=1,nxcell), j=1,nycell)
          call bswap(itmpnm,10,0)
c
c   --- we know the species are in the same order
c       as the header records, so just take the next index ---
c
          ispdex = index(ifile, ispc)
          if(ispdex .EQ. -1) goto 150
c
          do 140 iyloop = 1, nycell
              do 130 ixloop = 1, nxcell
                  if(ladj)
     &                uin(ixloop,iyloop) = uin(ixloop,iyloop) *
     &                    adjfac(ifile,ispdex)
                  u1(ixloop,iyloop,ispdex) =
     &               u1(ixloop,iyloop,ispdex) + uin(ixloop,iyloop)
                  hrtot(ifile,ispdex) =
     &               hrtot(ifile,ispdex) + uin(ixloop,iyloop)
  130         continue
  140     continue
          total(ifile,ispdex) =
     &        total(ifile,ispdex) + hrtot(ifile,ispdex)
  150 continue
c
      ierr = ISUCES
      goto 9999
c
c-----------------------------------------------------------------------
c   Error Messages:
c-----------------------------------------------------------------------
c
 7000 continue
      write(IOWSTD,9000) innm(ifile)
      goto 9999
c
 7010 continue
      write(IOWSTD,9010) innm(ifile)
      goto 9999
c
 7020 continue
      iERR=IEOF
      goto 9999
c
c-----------------------------------------------------------------------
c   Format Statements:
c-----------------------------------------------------------------------
c
 8000 format(a1)
 9000 format(1x, 'ERROR:  Reading input emissions file ', a)
 9010 format(1x, 'ERROR:  Time mismatch in file ', a)
c
c-----------------------------------------------------------------------
c   Return Point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
