c*** embrdat.inc version 1.0 embrdat.inc 07/30/92
c
c
c-----------------------------------------------------------------------
c
c   Variables and common blocks for the EMBR data records.
c
c-----------------------------------------------------------------------
c   Log:
c-----------------------------------------------------------------------
c
c    10/25/91  --gmw--  original development
c
c-----------------------------------------------------------------------
c   /HEADER/ variables:
c-----------------------------------------------------------------------
c
c   dxrgn    R   cell width in x direction
c   dyrgn    R   cell width in y direction
c   filtyp   C   type of sources contained in file
c   irgzn    I   utm zone of region
c   ispcrt   I   array of indexes into criteria pollutant arrays
c   molwt    R   array of molecular weights for species
c   nspchd   I   number of species in header
c   nxrgn    I   number of cells in x direction
c   nyrgn    I   number of cells in y direction
c   rgutme   R   utm easting coordinate of region
c   rgutmn   R   utm northing coordinate of region
c   spclst   C   array for names of cbiv species
c   spcrit   C   array of criteria pollutants that produced cbiv species
c
      character*30 filtyp
      character*10 spclst(MXSPEC)
      character*5  spcrit(MXSPEC)
      integer*4    irgzn
      integer*4    ispcrt(MXSPEC)
      integer*4    nxrgn
      integer*4    nyrgn
      integer*4    nspchd
      real*4       dxrgn
      real*4       dyrgn
      real*4       molwt(MXSPEC)
      real*4       rgutme
      real*4       rgutmn
c
      common /hdrchr/ filtyp, spclst, spcrit
      common /hdrdat/ irgzn, nxrgn, nyrgn, nspchd, ispcrt, rgutme,
     &                rgutmn, dxrgn, dyrgn, molwt
c
c-----------------------------------------------------------------------
c   /DATA/ variables:
c-----------------------------------------------------------------------
c
c   ceqeff   R   array for control equipment effeciency for criteria pollutant
c   emin     R   array for emissions of criteria pollutants
c   emout    R   array for output emissions for criteria pollutants
c   emstyp   C   emissions inventory type
c   facnox   R   total NOx emissions for facility
c   facvoc   R   total VOC emissions for facility
c   fipin    C   FIPS state/county code
c   iceqcd   I   array for primary control equipment code for criteria pollutant
c   ijcell   I   cell location of gridded inventory
c   invbeg   I   beginning  date and time
c   invend   I   ending julian date and time
c   isegno   I   segment number
c   istack   I   stack number
c   iutmzn   I   utm zone
c   plant    C   neds plant identification code
c   point    C   point identification
c   rectyp   C   record type
c   ruleff   R   array for rule effectiveness for criteria pollutant
c   rulpeb   R   array for rule penetration for criteria pollutant
c   sbrgn    C   subregion code
c   scccd    C   SCC code
c   siccd    C   SIC code
c   spcout   R   array for output emissions of cbiv species
c   spcpol   R   array for emissions of cbiv species
c   stkdia   R   stack diameter
c   stkgev   R   stack gas exit velocity
c   stkhgt   R   stack height
c   stktmp   R   stack exit gas temperature
c   utme     R   utm easting coordinate
c   utmn     R   utm northing coordinate
c
      character*10 scccd
      character*5  fipin
      character*5  sbrgn
      character*5  plant
      character*4  siccd
      character*3  point
      character*2  emstyp
      character*1  rectyp
      integer*4    iceqcd(MXCRIT)
      integer*4    ijcell
      integer*4    invbeg
      integer*4    invend
      integer*4    isegno
      integer*4    istack
      integer*4    iutmzn
      real*4       ceqeff(MXCRIT)
      real*4       emin(MXCRIT)
      real*4       emout(MXCRIT)
      real*4       facnox
      real*4       facvoc
      real*4       ruleff(MXCRIT)
      real*4       rulpen(MXCRIT)
      real*4       spcout(MXSPEC)
      real*4       spcpol(MXSPEC)
      real*4       stkdia
      real*4       stkgev
      real*4       stkhgt
      real*4       stktmp
      real*4       utme
      real*4       utmn
c
      common /datchr/  fipin, sbrgn, siccd, scccd, rectyp, emstyp,
     &                 plant, point
      common /datdat/  invbeg, invend, ijcell, istack, isegno,
     &                 facvoc, facnox, iutmzn, iceqcd, utme, utmn,
     &                 stkgev, stkdia, stktmp, stkhgt, emin, ruleff,
     &                 rulpen, ceqeff, spcpol, emout, spcout
