      subroutine rdcntl( ierr,
     &                         iounit )
c
c-----------------------------------------------------------------------
c
c    Reads the user input file and stores the data in the /EPISODE/
c    packet in common variables
c
c    Arguemnt declaration.
c     Outputs:
c       ierr   I error flag
c     Inputs:
c       iounit I logical unit number of file to read
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c      11/10/91  --gmw--  original development
c
c-----------------------------------------------------------------------
c    Include files:
c-----------------------------------------------------------------------
c
      include 'param.inc'
      include 'uamcntl.inc'
c
c-----------------------------------------------------------------------
c    Argument declarations:
c-----------------------------------------------------------------------
c
      integer*4 ierr
      integer*4 iounit
c
c-----------------------------------------------------------------------
c    External functions:
c-----------------------------------------------------------------------
c
c   strlen   I   returns actual length of string
c
      integer*4 strlen
c
c
c-----------------------------------------------------------------------
c    Local variables:
c-----------------------------------------------------------------------
c
c   keywrd  C   keyword for packet as variable
c   nhours  I   number of hours in episode
c   string  C   character string for temporary storage
c   idxspc  I   index for species array
c   jerr    I   error flag for subroutine calls
c
      character*(KEYLEN) keywrd
      character*(MXSTR)  string
      integer*4          idxspc, nhours, ilen, irec, jerr
c
c-----------------------------------------------------------------------
c   Data statements:
c-----------------------------------------------------------------------
c
      data keywrd /'/EPISODE/'/
      data irec /0/
c
c-----------------------------------------------------------------------
c   Entry point:
c-----------------------------------------------------------------------
c
c   --- set error flag ---
c
      ierr = IFAIL
c
c   --- call routine to get to find packet identifier ---
c
      call fndkey( jerr,
     &                   iounit, keywrd )
      if( jerr .EQ. IRDERR ) goto 9999
      if( jerr .NE. ISUCES ) goto 7000
c
c   --- read file note (reading through unused data) ---
c
      irec = irec + 1
      read( iounit,8000,ERR=7001,END=7001 ) string
      irec = irec + 1
      read( iounit,8000,ERR=7001,END=7001 ) string
      irec = irec + 1
      read( iounit,8001,ERR=7001,END=7001 ) fnote
c
c   --- read species data (checking for array overflow) ---
c
      irec = irec + 1
      read( iounit,8002,ERR=7001,END=7001 ) nspecs
      irec = irec + 1
      read( iounit,8000,ERR=7001,END=7001 ) string
      irec = irec + 1
      read( iounit,8000,ERR=7001,END=7001 ) string
      irec = irec + 1
      read( iounit,8000,ERR=7001,END=7001 ) string
      irec = irec + 1
      read( iounit,8000,ERR=7001,END=7001 ) string
      if( nspecs .LE. 0 .OR. nspecs .GT. MXSPEC ) goto 7002
      do 10 idxspc=1,nspecs
         irec = irec + 1
         read( iounit,8003,ERR=7001,END=7001 ) spcnam(idxspc)
   10 continue
c
c   --- read time data (checking for valid data) ---
c
      irec = irec + 1
      read( iounit,8002,ERR=7001,END=7001 ) ibgdat,begtim,iendat,endtim
      if( ibgdat .GT. iendat ) goto 7003
      nhours = (iendat-ibgdat)*24 + int( (endtim-begtim)/100 )
      if( nhours .GT. MXHOUR ) goto 7004
c
c   --- set error flag to sucess ---
c
      ierr = ISUCES
      goto 9999
c
c-----------------------------------------------------------------------
c   Error messages:
c-----------------------------------------------------------------------
c
 7000 continue
      ilen = strlen ( keywrd, KEYLEN )
      write(IOWSTD,9000,ERR=9999) 'ERROR: This program requires the ',
     &                               keywrd(1:ilen),' packet of USERIN.'
      goto 9999
c
 7001 continue
      ilen = strlen ( keywrd, KEYLEN )
      write(IOWSTD,9000,ERR=9999) 'ERROR: Reading ',keywrd(1:ilen),
     &                         ' packet of USERIN file at line: ',irec
      goto 9999
c
 7002 continue
      write(IOWSTD,9001,ERR=9999) 'ERROR: Number of species: ',nspecs,
     &                                         ' exceeds max: ',MXSPEC
      goto 9999
c
 7003 continue
      write(IOWSTD,9001,ERR=9999)
     &             'ERROR: Invalid julian dates:  beginning: ',ibgdat,
     &                                              ' ending: ',iendat
      goto 9999
c
 7004 continue
      write(IOWSTD,9001,ERR=9999) 'ERROR: Number of hours: ',nhours,
     &                                         ' exceeds max: ',MXHOUR
      goto 9999
c
c-----------------------------------------------------------------------
c   Format statements:
c-----------------------------------------------------------------------
c
 8000 format(20X,A)
 8001 format(A60)
 8002 format(I10,F10.0,I10,F10.0)
 8003 format(A10)
 9000 format(/,1X,A,A,A,I5,/)
 9001 format(/,1X,A,I5,A,I5,/)
c
c-----------------------------------------------------------------------
c   Return point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
