      subroutine rdregn( ierr,
     &                         iounit)
c
c-----------------------------------------------------------------------
c
c    reads the user input file and stores the data in the /UAMREGN/
c    packet in common variables
c
c    Argument declaration.
c     Outputs:
c       ierr   I error flag
c     Inputs:
c       iounit I logical unit number of file to read
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c      11/10/91  --gmw--  original development
c
c-----------------------------------------------------------------------
c    Include files:
c-----------------------------------------------------------------------
c
      include 'param.inc'
      include 'uamregn.inc'
c
c-----------------------------------------------------------------------
c    Argument declerations:
c-----------------------------------------------------------------------
c
      integer*4 ierr
      integer*4 iounit
c
c-----------------------------------------------------------------------
c    External functions:
c-----------------------------------------------------------------------
c
c   strlen   I   returns the actual length of a string
c
      integer*4 strlen
c
c-----------------------------------------------------------------------
c    Local variables:
c-----------------------------------------------------------------------
c
c   keywrd  C   keyword for packet as variable
c   string  C   character string for temporary storage
c   jerr    I   error flag for subroutine calls
c
      character*(KEYLEN) keywrd
      character*(MXSTR)  string
      integer*4          ilen, irec, jerr
c
c-----------------------------------------------------------------------
c   Data statements:
c-----------------------------------------------------------------------
c
      data keywrd /'/UAMREGN/'/
      data irec /0/
c
c-----------------------------------------------------------------------
c   Entry point:
c-----------------------------------------------------------------------
c
c   --- set error flag ---
c
      ierr = IFAIL
c
c   --- call routine to get to find packet identifier ---
c
      call fndkey( jerr,
     &                   iounit, keywrd )
      if( jerr .EQ. IRDERR ) goto 9999
      if( jerr .NE. ISUCES ) goto 7000
c
c   --- read origin data (reading through unused data) ---
c
      irec = irec + 1
      read( iounit,8000,ERR=7001,END=7001 ) string
      irec = irec + 1
      read( iounit,8001,ERR=7001,END=7001 ) utmx, utmy, izone
      irec = irec + 1
      read( iounit,8001,ERR=7001,END=7001 ) xorig, yorig
c
c   --- read grid cell data (checking for array overflow) ---
c
      irec = irec + 1
      read( iounit,8001,ERR=7001,END=7001 ) dxcell, dycell
      irec = irec + 1
      read( iounit,8002,ERR=7001,END=7001 ) nxcell, nycell, nzcell
      if( nxcell .LE. 0 .OR. nxcell .GT. MXCEL .OR. nycell .LE. 0 .OR.
     &                                    nycell .GT. MXCEL ) goto 7002
      irec = irec + 1
      read( iounit,8003,ERR=7001,END=7001 ) nzlowr, nzuppr, htsur,
     &                                                 htlowr, htuppr
c
c   --- set error flag to success ---
c
      ierr = ISUCES
      goto 9999
c
c-----------------------------------------------------------------------
c   Error messages:
c-----------------------------------------------------------------------
c
 7000 continue
      ilen = strlen ( keywrd, KEYLEN )
      write(IOWSTD,9000,ERR=9999) 'ERROR: This program requires the ',
     &                               keywrd(1:ilen),' packet of USERIN.'
      goto 9999
c
 7001 continue
      ilen = strlen ( keywrd, KEYLEN )
      write(IOWSTD,9001,ERR=9999) 'ERROR: Reading ',keywrd(1:ilen),
     &                          ' packet of USERIN file at line: ',irec
      goto 9999
c
 7002 continue
      write(IOWSTD,9002,ERR=9999) 'ERROR: Number of grid cells: (',
     &      nxcell,',',nycell,') exceeds max: (',MXCEL,',',MXCEL,').'
      goto 9999
c
c-----------------------------------------------------------------------
c   Format statements:
c-----------------------------------------------------------------------
c
 8000 format(20x,a)
 8001 format(f10.0,f10.0,i10)
 8002 format(i10,i10,i10)
 8003 format(i10,i10,f10.0,f10.0,f10.0)
 9000 format(/,1x,a,a,a,/)
 9001 format(/,1x,a,a,a,i5,/)
 9002 format(/,1x,a,i5,a,i5,a,i5,a,i5,a,/)
c
c-----------------------------------------------------------------------
c   Return point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
