      subroutine wrmmru( ierr,
     &                        ihour, numfil, ltot)
c
c-----------------------------------------------------------------------
c
c    writes tables of emissions totals to the message file.
c
c    Argument Declaration.
c     outputs:
c       ierr   i  error flag
c     inputs:
c       ihour  i  a number between 1-24 indicating hour
c       numfil i  the number of input files
c       ltot   l  if .TRUE., then write total.  else write hour.
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c      10/25/91  --hjt--  original development
c
c-----------------------------------------------------------------------
c    Include Files:
c-----------------------------------------------------------------------
c
      include 'param.inc'
      include 'mrguam.inc'
      include 'uamcntl.inc'
      include 'rdemis.inc'
c
c-----------------------------------------------------------------------
c    Argument Declarations:
c-----------------------------------------------------------------------
c
      integer*4 ierr
      integer*4 ihour
      integer*4 numfil
      logical*4 ltot
c
c-----------------------------------------------------------------------
c    libraries called:
c-----------------------------------------------------------------------
c
c   wrctbl    ---   standardized table output
c
c-----------------------------------------------------------------------
c    Local Variables:
c-----------------------------------------------------------------------
c
      character*80 title
      character*20 units
      character*10 codnam(10), codtit
      character*2  strnum
      integer*4    i, jerr
c
c-----------------------------------------------------------------------
c   Entry Point:
c-----------------------------------------------------------------------
c
c
c   --- assume failure ---
c
      ierr = IFAIL
c
c   --- initialize ---
c
      units = 'moles'
      codtit = 'File'
      write(title, 9010, ERR=7000) ihour
      do 100 i = 1, numfil
          write(strnum, 9000, ERR=7000) i
          call lftjst(strnum, 2)
          codnam(i) = 'File'//strnum
  100 continue
c
c   --- call wrctbl ---
c
      if (ltot) then
          title = 'Totals'
          call wrctbl(jerr, IOWMSG, title, units, MXMRG, numfil, 10,
     &        codnam, codtit, nspecs, spcnam, total)
          if( jerr .NE. ISUCES ) goto 9999
      else
          call wrctbl(jerr, IOWMSG, title, units, MXMRG, numfil, 10,
     &        codnam, codtit, nspecs, spcnam, hrtot)
          if( jerr .NE. ISUCES ) goto 9999
      endif
c
      ierr = ISUCES
      goto 9999
c
c-----------------------------------------------------------------------
c   Error Messages:
c-----------------------------------------------------------------------
c
 7000 continue
      write (IOWSTD, 9020, ERR=9999)
     &                          'ERROR:  Writing output message file.'
      goto 9999
c
c-----------------------------------------------------------------------
c   Format Statements:
c-----------------------------------------------------------------------
c
 9000 format (i2)
 9010 format ('Totals for hour ', i2, 73x)
 9020 format (1x, a)
c
c-----------------------------------------------------------------------
c   Return Point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
