      subroutine wrtout( ierr ,
     &                         ihour)
c
c-----------------------------------------------------------------------
c
c    writes the merged emissions to the output file.
c
c    Argument Declaration.
c     outputs:
c       ierr   i  error flag
c     inputs:
c       ihour i  number between 1 and 24 for hour
c
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c      10/25/91  --hjt--  original development
c
c-----------------------------------------------------------------------
c    Include Files:
c-----------------------------------------------------------------------
c
      include 'param.inc'
      include 'mrguam.inc'
      include 'rdemis.inc'
      include 'uamcntl.inc'
      include 'uamregn.inc'
c
c-----------------------------------------------------------------------
c    Argument Declarations:
c-----------------------------------------------------------------------
c
      integer*4 ierr
      integer*4 ihour
c
c-----------------------------------------------------------------------
c    Local Variables:
c-----------------------------------------------------------------------
c
      integer*4 nseg, ispc, ichar, ix, iy
      real*4    bt, et
c
c-----------------------------------------------------------------------
c   data statements:
c-----------------------------------------------------------------------
c
c      data name /value/
c
c-----------------------------------------------------------------------
c   Entry Point:
c-----------------------------------------------------------------------
c
c   --- assume failure ---
c
      ierr = IFAIL
c
c   --- initialize ---
c
      nseg = 1
c
c   --- time record ---
c
      bt = ihour - 1.0
      et = ihour
      write(IOWUAM, ERR=7000) ibgdat, bt, iendat, et
c
c   --- loop through species.
c       the order is from the region packet ---
c
      do 120 ispc = 1, nspecs
          write(IOWUAM, ERR=7000)
     &        nseg,
     &        (intnam(ispc,ichar),ichar=1,10),
     &        ((u1(ix,iy,ispc),ix=1,nxcell), iy=1,nycell)
  120 continue
c
      ierr = ISUCES
      goto 9999
c
c-----------------------------------------------------------------------
c   Error Messages:
c-----------------------------------------------------------------------
c
 7000 continue
      write (IOWSTD,9000)
     &      'ERROR:  Writing emissions to output file at hour: ',ihour
      goto 9999
c
c-----------------------------------------------------------------------
c   Format Statements:
c-----------------------------------------------------------------------
c
 9000 format(1x,a,i6)
c
c-----------------------------------------------------------------------
c   Return Point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
