#!/bin/csh
#PBS -j oe
#PBS -r n
#PBS -q romo
#PBS -W group_list=romo
#PBS -W umask=022
#PBS -A mobile

# This script sets up environment variables and runs the Metcombine utility.
# Metcombine extracts data from 2D and the 1st layer of 3D meteorology files
# to create custom met files needed by Premobl.
#
# This script assumes that the meteorology files are named with the following
# convention:
#     METCRO2D_<YYYYDDD>
#     METCRO3D_<YYYYDDD>
#
# Script created by B.H. Baek, CEMPD (4/20/2010)
#
#*****************************************************************************

# Script settings
setenv PROMPTFLAG N                # Y prompts for input
setenv GRID   12US2
setenv METABBREV 11g

# Source category
setenv SMK_SOURCE M                # M : mobile sources

# Metcombine settings
setenv VARLIST "TEMP2, PRES, QV"   # list of variables to extract

# Base dir
setenv BASEDIR /garnet/oaqps/em_v6.2/2011platform/work/met_processing
setenv OUTDIR ${BASEDIR}/${GRID}_${METABBREV}

setenv MET_ROOT /garnet/oaqps/met/MCIP_v4.1.3/WRF_2011g_25aL/${GRID}/mcip_out/
setenv METLIST  $BASEDIR/metfile_list.${GRID}_${METABBREV}.txt

## year 2 digit
setenv YR 11

## Create output directory if doesn't exist
if ( ! -e $OUTDIR ) mkdir -p $OUTDIR

##############################################################################

# METLIST is set in Assign file
# Remove previous METLIST file that contains a list of METCOMBO files
rm -f $METLIST

# loop through METCRO2D files in METDAT directory
foreach month (1 2 3 4 5 6 7 8 9 10 11 12)

if( $month == 1) then 
    set date = 31
else if( $month == 3) then
    set date = 31
else if( $month == 5) then 
    set date = 31
else if( $month == 7) then
     set date = 31
else if( $month == 8) then
     set date = 31
else if( $month == 10) then
     set date = 31
else if( $month == 12) then
     set date = 31
else if( $month == 4) then
     set date = 30 
else if( $month == 6) then
     set date = 30 
else if( $month == 9) then
     set date = 30 
else if( $month == 11) then
     set date = 30 
else if( $month == 2) then
     set date = 28 ## leap year make 29, otherwise 28
endif

if( $month < 10 ) then
   setenv MON 0$month
else
   setenv MON $month
endif

set curdate = 1

while( $curdate <= $date)

   if( $curdate < 10 ) then
       setenv DATE 0$curdate
   else
       setenv DATE $curdate
   endif 

   setenv METFILE1  $MET_ROOT/METCRO2D_$YR$MON$DATE
   setenv METFILE2  $MET_ROOT/METCRO3D_$YR$MON$DATE
   setenv OUTFILE   $OUTDIR/METCOMBO_$YR$MON$DATE

/garnet/oaqps/smoke/smoke3.5/Linux2_x86_64ifort/metcombine

   @ curdate = $curdate + 1

   echo $OUTFILE >> $METLIST
end

end
end

