#!/bin/csh -f
#PBS -j oe
#PBS -r n

limit stacksize unlimited

setenv SECTOR "nonpt"

if ($?PBS_O_WORKDIR) then
  cd $PBS_O_WORKDIR
endif

## Definitions for case name, directory structures, etc, that are used
#  by every sector in the case
#  Anything defined in directory_definitions can be overridden here 
#  if desired
source ../directory_definitions.csh

## Months for emissions processing, and spinup duration
#  In the EPA emissions modeling platforms, the only sectors that use
#  SPINUP_DURATION are biogenics and the final sector merge (Mrggrid).
#  Elsewhere, SPINUP_DURATION = 0, and when Mrggrid runs for spinup days,
#  base year emissions are used for the spinup year for all sectors except
#  biogenics.
#  SPINUP_DURATION does not always work when the first month of the run
#  is not January. That will be a future fix.
setenv RUN_MONTHS "1 2 3 4 5 6 7 8 9 10 11 12"
setenv SPINUP_DURATION "0"
setenv SMK_SRCGROUP_OUTPUT_YN "N" # set to Y to create inline emissions files for source apportionment

## Emissions modeling year
#  (i.e. meteorological year, not necessarily the inventory year"
setenv BASE_YEAR "2011"
setenv EPI_STDATE_TIME "${BASE_YEAR}-01-01 00:00:00.0"
setenv EPI_ENDATE_TIME "${BASE_YEAR}-12-31 23:59:00.0"

## Inventory case name, if inventories are coming from a different case (they usually aren't)
#  CASEINPUTS is defined in directory_definitions and optionally overridden here
#setenv INVENTORY_CASE "2011ek_cb6v2_v6_11g"
#setenv CASEINPUTS "$INSTALL_DIR/$INVENTORY_CASE/inputs"

## Inputs for all sectors
setenv AGREF "${GE_DAT}/gridding/amgref_us_2011platform_28dec2015_v11.txt"
setenv ARTOPNT "${GE_DAT}/artopnt_30mar2012_v1.txt"
setenv ATPRO_HOURLY "${GE_DAT}/temporal/amptpro_general_2011platform_tpro_hourly_13nov2014_v1"
setenv ATPRO_MONTHLY "${GE_DAT}/temporal/amptpro_general_2011platform_tpro_monthly_01sep2016_nf_v4"
setenv ATPRO_WEEKLY "${GE_DAT}/temporal/amptpro_general_2011platform_tpro_weekly_13nov2014_v1"
setenv ATREF "${GE_DAT}/temporal/amptref_general_2011platform_tref_01sep2016_nf_v13"
setenv COSTCY "${GE_DAT}/costcy_for_2007platform_08dec2015_nf_v15.txt"
setenv EFTABLES "${CASEINPUTS}/onroad/eftables/rateperdistance_smoke_aq_cb6_saprc_nei2023_20160520_10003_1.csv"
setenv GRIDDESC "${GE_DAT}/gridding/griddesc_lambertonly_18sep2015_v64.txt"
setenv GSCNVTMP_A "${GE_DAT}/speciation/gscnv_2011v3_28apr2015.txt"
setenv GSPROTMP_A "${GE_DAT}/speciation/gspro_cmaq_cb6_2011ek_cb6v2_v6_11g_16dec2014.txt"
setenv GSREFTMP_A "${GE_DAT}/speciation/gsref_2023el_cb6v2_v6_11g_nf.txt"
setenv HOLIDAYS "${GE_DAT}/temporal/holidays_04may2006_v0.txt"
setenv INVTABLE "${GE_DAT}/invtable_2011v2_platform_integrate_15may2015_v3.txt"
setenv MRGDATE_FILES "${RUNSCRIPTS}/smk_dates/2011/smk_merge_dates_201012.txt"
setenv MTPRO_HOURLY "${GE_DAT}/temporal/mtpro_hourly_moves2014_13nov2014_v1"
setenv MTPRO_MONTHLY "${GE_DAT}/temporal/amptpro_general_2011platform_tpro_monthly_01sep2016_nf_v4"
setenv MTPRO_WEEKLY "${GE_DAT}/temporal/mtpro_weekly_moves2014_13nov2014_v2"
setenv MTREF "${GE_DAT}/temporal/mtref_onroad_moves2014_28jan2015_v3"
setenv NAICSDESC "${GE_DAT}/smkreport/naicsdesc_02jan2008_v0.txt"
setenv ORISDESC "${GE_DAT}/smkreport/orisdesc_04dec2006_v0.txt"
setenv PELVCONFIG "${GE_DAT}/point/pelvconfig_inline_20m_13nov2012_v0.txt"
setenv PSTK "${GE_DAT}/point/pstk_20nov2006_v0.txt"
setenv PTPRO_HOURLY "${GE_DAT}/temporal/amptpro_general_2011platform_tpro_hourly_13nov2014_v1"
setenv PTPRO_MONTHLY "${GE_DAT}/temporal/amptpro_general_2011platform_tpro_monthly_01sep2016_nf_v4"
setenv PTPRO_WEEKLY "${GE_DAT}/temporal/amptpro_general_2011platform_tpro_weekly_13nov2014_v1"
setenv PTREF "${GE_DAT}/temporal/amptref_general_2011platform_tref_01sep2016_nf_v13"
setenv REPCONFIG_GRID "${GE_DAT}/smkreport/repconfig/repconfig_area_invgrid_2011platform_11aug2014_v0.txt"
setenv REPCONFIG_INV2 "${GE_DAT}/smkreport/repconfig/repconfig_area_inv2_2011platform_11aug2014_v0.txt"
setenv REPCONFIG_INV "${GE_DAT}/smkreport/repconfig/repconfig_area_inv_2011platform_11aug2014_v0.txt"
setenv SCCDESC "${GE_DAT}/smkreport/sccdesc_pf31_08dec2015_nf_v24.txt"
setenv SECTORLIST "${CASESCRIPTS}/sectorlist_2023el_cb6v2_21oct2016_v0"
setenv SRGDESC "${GE_DAT}/gridding/srgdesc_CONUS12_2010_v5_16jan2015_v5.txt"
setenv SRGPRO "${GE_DAT}/gridding/CONUS12_2010_v5_20141015/USA_100_FILL_NORM.txt"
setenv SOURCE_GROUPS "${GE_DAT}/sa/smkmerge_groups_ussa_US_02apr2015_v1"

# Inputs specific to this sector
setenv GSPRO_COMBO "${GE_DAT}/speciation/gspro_combo_2023el_stationary_04oct2016_nf_v1.txt"
setenv INVTABLE "${GE_DAT}/invtable_2011v2_platform_integrate_15may2015_v2.txt"
setenv REPCONFIG_GRID "${GE_DAT}/smkreport/repconfig/repconfig_area_invgrid_2011platform_11aug2014_v1.txt"
setenv REPCONFIG_INV "${GE_DAT}/smkreport/repconfig/repconfig_area_inv_2011platform_11aug2014_v1.txt"
setenv REPCONFIG_INV2 "${GE_DAT}/smkreport/repconfig/repconfig_area_inv2_2011platform_11aug2014_v2.txt"
setenv NHAPEXCLUDE "${GE_DAT}/nhapexclude/nhapexclude_2011NEIv2_nonpt_csv_04oct2016_nf_v4.txt"
setenv EMISINV_C "$CASEINPUTS/nonpt/pfc_2025_2011v6_2_ff10_28jan2015_13sep2016_v2.csv"
setenv EMISINV_D "$CASEINPUTS/nonpt/cement_newkilns_year_2025_from_ISIS2013_NEI2011v1_NONPOINT_12sep2016_v3.csv"
setenv EMISINV_E "$CASEINPUTS/nonpt/2018_cellulosic_inventory_12sep2016_v2.csv"
setenv EMISINV_F "$CASEINPUTS/nonpt/cellulosic_new_Iowa_plants_from2018docket_2011v6_2_ff10_28jan2015_28jan2015_v0.csv"
setenv EMISINV_A "$CASEINPUTS/nonpt/2023el_MARAMA_nonpt_2011NEIv2_NONPOINT_20141108_mar_13sep2016_v1.csv"
setenv EMISINV_AA "$CASEINPUTS/nonpt/2023el_from_nonpt_2011NEIv2_NONPOINT_2_113907436_14sep2016_v1.csv"
setenv EMISINV_B "$CASEINPUTS/nonpt/2023el_MARAMA_from_refueling_2011NEIv2_NONPOINT_20141108_mar_13sep2016_v1.csv"
setenv EMISINV_BB "$CASEINPUTS/nonpt/2023el_from_refueling_2011NEIv2_NONPOINT_20141108_14sep2016_v1.csv"
setenv EMISINV_CC "$CASEINPUTS/nonpt/MARAMA_2023_from_pfc_2011NEIv2_NONPOINT_20141108_11nov2014_v0_14sep2016_v0.csv"
setenv EMISINV_G "$CASEINPUTS/nonpt/2023_MARAMA_Nonpoint_Offsets_13sep2016_v0.csv"
setenv GSPROTMP_A "${GE_DAT}/speciation/gspro_cmaq_cb6_2017ek_cb6v2_v6_11g_12mar2015.txt"

# Parameters for all sectors
setenv PLATFORM "v6.3"
setenv SPC "$EMF_SPC"
setenv MTMP_OUTPUT_YN "N"
setenv RUN_PYTHON_ANNUAL "Y"
setenv INLINE_MODE "both"
setenv SMK_PING_METHOD "0"
setenv SMK_SPECELEV_YN "Y"
#setenv RAW_DUP_CHECK "Y"
#setenv M_TYPE "mwdss"
#setenv L_TYPE "mwdss"
setenv RUN_HOLIDAYS "Y"
setenv FULLSCC_ONLY "Y"
setenv SMK_MAXERROR "10000"
setenv SMK_MAXWARNING "10"
setenv SMK_AVEDAY_YN "N"
setenv REPORT_DEFAULTS "Y"
setenv SMK_DEFAULT_SRGID "100"
setenv SMKINVEN_FORMULA "PMC=PM10-PM2_5"
#setenv FILL_ANNUAL "N"
setenv MRG_MARKETPEN_YN "N"
setenv WEST_HSPHERE "Y"
setenv MRG_REPCNY_YN "Y"
setenv OUTZONE "0"
setenv RENORM_TPROF "Y"
setenv POLLUTANT_CONVERSION "Y"
setenv IOAPI_ISPH "20"
setenv MRG_REPSTA_YN "N"
setenv SMKMERGE_CUSTOM_OUTPUT "Y"
setenv OUTPUT_FORMAT "$EMF_AQM"

# Sector-specific parameters
setenv FILL_ANNUAL "Y"
setenv HOURLY_TPROF_BASE "MONTH"
setenv L_TYPE "week"
setenv M_TYPE "week"
setenv NO_SPC_ZERO_EMIS "Y"
setenv NONHAP_TYPE "VOC"
setenv RAW_DUP_CHECK "N"
setenv SMK_ARTOPNT_YN "Y"
setenv SMK_PROCESS_HAPS "PARTIAL"

$RUNSCRIPTS/emf/smk_ar_monthly_emf.csh $REGION_ABBREV $REGION_IOAPI_GRIDNAME -m "$RUN_MONTHS" $SPINUP_DURATION all
