#!/bin/csh -f
#PBS -j oe
#PBS -r n

# NOTE: This requires processing beis under the 2011ek case.

# Convert from 2D emis to tag-ready ptsr

unset verbose

set SECTOR = beis

# Start and end dates (Julian dates)
set start_date = 2010356    
set end_date = 2011365
set YEAR = 2011

if ( $?PBS_JOBID ) then
 cd $PBS_O_WORKDIR
else
 set PBS_JOBID = $?
endif

#-----------------------------------------------------------------#

set CTM_2DEMIS = Y   ## Run the 2D / low-level emissions CMAQ to CAMx conversion

## Definitions for case name, directory structures, etc, that are used
#  by every sector in the case
#  Anything defined in directory_definitions can be overridden here 
#  if desired
source ../../../2011ek_cb6v2_v6_11g/scripts/directory_definitions.csh
set outcase = 2017ek_ussa_cb6v2_v6_11g   ## primary case name

set casescripts = $CASESCRIPTS/camx
set camxscripts = $INSTALL_DIR/camx

setenv GRID $REGION_ABBREV
setenv SPEC $EMF_SPC

if ($REGION_ABBREV == 12US2) then
  setenv XORG -2412.
  setenv YORG -1620.
  setenv NX 396
  setenv NY 246
  setenv DX 12.
  set LAYERS = 25  ## Number of layers to output
else
  echo "If not running 12US2, define grid parameters for your grid at the top of this script."
  exit (1)
endif

set EMIS_ROOT = $INSTALL_DIR  ## Model ready emissions SMOKE out platform root

# SECTORLIST 
set SECTORLIST = $CASESCRIPTS/sectorlist_2011ek_cb6v2_12feb2016_v3

set datefile = $camxscripts/dates/mergedates_${YEAR}.txt
set execroot = $camxscripts/bin # Root to cmaq2camx executables

set OUTPATH = $INSTALL_DIR/2017ek_cb6v2_v6_11g/smoke_out/${outcase}/${GRID}/camx/sector/$SECTOR

if ($SPEC == cmaq_cb6) then
	set SPECIES_MAPPING = $camxscripts/Species_Mapping_Tables/MAPTBL.CMAQ_CB6+AERO6_to_CAMXv6_CB6+CF+RTRACPM_2015feb17
else
	set SPECIES_MAPPING = $camxscripts/Species_Mapping_Tables/MAPTBL.CMAQ_CB05+AERO6_to_CAMXv6_CB05+CF+RTRACPM_2015feb17
endif


set QADIR = $casescripts/qatemp #location for QA files - domain totals and domain total 2D plots of point emissions
if (! -e $QADIR) then
	mkdir -p $QADIR
endif

set tempdir = $casescripts/work  ## Path for the temporary work directory
if (! -e $tempdir) then
	mkdir -p $tempdir
endif

setenv SCRIPTLOG cmaq2camx_${CASE}_${GRID}_${PBS_JOBID}.log  ## Name of script log 
if ( -e $casescripts/$SCRIPTLOG) then
	rm $casescripts/$SCRIPTLOG
endif

#-----------------------------------------------------------------#

set today = $start_date

## Run the CMAQ to CAMx conversion by loop over the specified date range 
while ($today <= $end_date )

	echo $today >> $casescripts/$SCRIPTLOG
	#-----------------------------------------------------------------#
	## Set up date values from Julian date
	set STDATE = $today

	set GDAY = (`$execroot/j2g $today`)
	set YYYY = `echo $GDAY | cut -c1-4`
	set YY = `echo $YYYY | cut -c3-4`
	set MM = `echo $GDAY | cut -c5-6`
	set DD = `echo $GDAY | cut -c7-8`
	set G_DAY = $YYYY$MM$DD
	set GS_DAY = $YY$MM$DD
	set YYDDD = `echo $today | cut -c3-8`

	set iday = `grep ^$STDATE $datefile`
	set dateheader = `grep ^Date $datefile`
	#---------------------------------------------------------------------------#

        # Find the representative date based on the date approach from the sectorlist
        set dateappr = `grep ^\"$SECTOR\" $SECTORLIST | cut -d, -f4 | sed 's/"//g'`

        set n = 1
        while ($n <= 9)
            set column = $dateheader[$n]
            if ($dateappr == $column) then
                    set repday = $iday[$n]
            endif
            @ n++
        end

	## Run the 2D / low-level cmaq to camx conversion
	if ($CTM_2DEMIS == Y) then ## 2D emissions preparation
		#need to combine these files, adjust species names, and add duplicate species

#		set PATHA = ${EMIS_ROOT}/${CASE}/${GRID}/${SPEC}
		set PATHA = ${EMIS_ROOT}/${CASE}/intermed/${SECTOR}
		set FILEA = emis_mole_${SECTOR}_${repday}_${GRID}_${SPEC}_${CASE}.ncf

		if (! -e $PATHA/$FILEA) then
			gunzip -c $PATHA/${FILEA}.gz > ${tempdir}/temp_${PBS_JOBID}.ncf
		else
			cp $PATHA/$FILEA ${tempdir}/temp_${PBS_JOBID}.ncf
		endif

		echo ${PATHA}/${FILEA} >> $casescripts/$SCRIPTLOG
		set OUTFILE = ptsr.${SECTOR}.$repday.$GRID.bin

                if (! -e $OUTPATH/$OUTFILE) then
                    if (! -e $OUTPATH) then
                            mkdir -p $OUTPATH
                    endif

                    rm -f ${tempdir}/tmp_emis_${PBS_JOBID}
                    ## Map the CMAQ species names to CAMx as specified in the MAPTBL
                    setenv INFILE  ${tempdir}/temp_${PBS_JOBID}.ncf
                    setenv OUTFILE ${tempdir}/tmp_emis_${PBS_JOBID}
                    setenv MAPTBL  $SPECIES_MAPPING
                    $execroot/spcmap

                    setenv CMAQEMIS ${tempdir}/tmp_emis_${PBS_JOBID}
                    rm -f ${tempdir}/tmp_low_${PBS_JOBID} $OUTPATH/$OUTFILE ${tempdir}/tmp_pnt_${PBS_JOBID}

## Convert from low-level cmaq model ready IOAPI 2D file to camx
$execroot/cmaq2uam-conv2dsat << EOF
File Type          |EMIS
OutFile1 (IC,BC,AR)|${tempdir}/tmp_low_${PBS_JOBID}
OutFile2 (TopC,PT) |${OUTPATH}/$OUTFILE
Output Timezone    |0
EOF

		rm -f ${tempdir}/tmp_low_${PBS_JOBID} 
		rm -f ${tempdir}/tmp_emis_${PBS_JOBID}

		rm -f ${tempdir}/qaemis.ptsr.${PBS_JOBID}.in
cat << ieof > ${tempdir}/qaemis.ptsr.${PBS_JOBID}.in
$OUTPATH/$OUTFILE
$QADIR/ptsr.${SECTOR}.$repday.$GRID.$CASE.camx.tot.txt
$QADIR/ptsr.${SECTOR}.$repday.$GRID.$CASE.camx.hrs.txt
$QADIR/ptsr.${SECTOR}.$repday.$GRID.$CASE.camx.pave.bin
ieof

                    ## Run low-level / 2D QA on camx file
                    $execroot/qaelev < ${tempdir}/qaemis.ptsr.${PBS_JOBID}.in
                    rm -f ${tempdir}/qaemis.ptsr.${PBS_JOBID}.in
                    rm -f ${tempdir}/temp_${PBS_JOBID}.ncf
                else
                    echo "WARNING $OUTPATH/$OUTFILE already exists. Will not overwrite."
                endif  # run if the sector file is not present
	endif ## end 2D emissions preparation

	@ today = $today + 1

	if ($today == 2010366) then
		set today = 2011001
	endif

end #loop back to next day

exit


