#!/bin/csh -f
#PBS -j oe
#PBS -r n

# Start and end dates (Julian dates)
set start_date = 2010356    
set end_date = 2011365 

## Definitions for case name, directory structures, etc, that are used
#  by every sector in the case
#  Anything defined in directory_definitions can be overridden here 
#  if desired
source ../../../2023el_cb6v2_v6_11g/scripts/directory_definitions.csh
set outcase = 2023el_ussa_cb6v2_v6_11g   ## primary case name
setenv NZ 25

setenv MET "/sol/work/ROMO/met/wrfcamx_v4.0/12US2.TZ0/2011_Kvmin0.1_cloud" # Change to point to your WRF

set GRID = $REGION_ABBREV
set camxscripts = $INSTALL_DIR/camx
set LUPATH = $camxscripts/land
set OUTPATH = $INSTALL_DIR/$CASE/smoke_out/$outcase/$GRID/camx
set EMISPATH = $OUTPATH
set execroot = $camxscripts/bin # Root to cmaq2camx executables
set tempdir = $CASESCRIPTS/camx/work  ## Path for the temporary work directory
if (! -e $tempdir) then
	mkdir -p $tempdir
endif

#mkdir -p $OUTPATH


#set today = 2010124

#-----------------------------------------------------------------#

setenv RESTART FALSE  #always FALSE on first day

set today = $start_date

while ($today <= $end_date )

@ jday = $today - 2000000

#-----------------------------------------------------------------#

set STDATE = $today

set GDAY = (`$execroot/j2g $today`)

set YYYY = `echo $GDAY | cut -c1-4`
set YY = `echo $GDAY | cut -c3-4`
set MM = `echo $GDAY | cut -c5-6`
set DD = `echo $GDAY | cut -c7-8`

set G_DAY = $YYYY$MM$DD
set GS_DAY = $YY$MM$DD


#-----------------------------------------------------------------------#

echo $GS_DAY
$camxscripts/seasalt/seasalt.lnx << IEOF
Julian date        :$jday
Time zone          :0
Method for open sea:GONG
Method for surfzone:GONG
Coastline length   :NONE
SS lower_limit     :0.0
SS upper limit     :2.5
Output emiss file  :${tempdir}/seasalt.camx
File identifier    :Sea Salt Emissions
Number of species  :4
Species name # 1   :PCL
Species name # 2   :NA
                   :SS
                   :PSO4
CAMx 3D file       :$MET/met3d.$GS_DAY.$GRID.25.wrf.camx
CAMx 2D file       :$MET/met2d.$GS_DAY.$GRID.25.wrf.camx
CAMx Land Use file :$MET/landuse.$GS_DAY.$GRID.zhang.camx
Saltwater mask     :$LUPATH/oceanmask.$GRID.txt
8 species halo-CH3 :.false.
DOC and CH3I(g)    :1.12e6, 6.55e-4
IEOF

#setenv OUTFILE $EMISPATH/ss.$G_DAY.$GRID.${CASE}+ss.camx
#rm -rf $OUTFILE

#/garnet/oaqps/smoke/cmaq2camx/seasalt/mrgspc.lnx << EOF
#Input File         |$EMISPATH/emis2d.$G_DAY.$GRID.$CASE.camx
#Input File         |$OUTPATH/seasalt.$today.$GRID.${NZ}.wrf_GONG.camx
#Input File         |END
#Output File        |$OUTFILE
#EOF

mv -f ${tempdir}/seasalt.camx $OUTPATH/seasalt.$today.$GRID.${NZ}.wrf_GONG.camx

@ today = $today + 1

end  #end loop over days
