#!/bin/csh
#PBS -j oe
#PBS -r n
#PBS -q emis
#PBS -W group_list=emis-hpc
#PBS -W umask=022
#PBS -l select=ncpus=1
#PBS -l walltime=24:00:00

setenv INSTALL_DIR /work/EMIS/users/cvy/for_package

setenv BASE_YEAR 2011
setenv GRID 12US2
setenv SECTOR onroad_catx
setenv EMF_SPC cmaq_cb6
setenv CASE 2011ek_cb6v2_v6_11g
setenv PROJECT_ROOT $INSTALL_DIR/tr_2008o3_final/$CASE
setenv MW $INSTALL_DIR/smoke3.7/scripts/annual_report/parameter_file_${EMF_SPC}.txt

mkdir $PROJECT_ROOT/reports/annual_report

smoke_moves2014_reports_28oct14.py -r RPH -l -w $MW
smoke_moves2014_reports_28oct14.py -d 7 -r RPP -l -w $MW
smoke_moves2014_reports_28oct14.py -d 7 -r RPV -l -w $MW
smoke_moves2014_reports_28oct14.py -d 7 -r RPD -l -w $MW

setenv SECTOR onroad

smoke_moves2014_reports_28oct14.py -r RPH -l -w $MW
smoke_moves2014_reports_28oct14.py -d 7 -r RPP -l -w $MW
smoke_moves2014_reports_28oct14.py -d 7 -r RPV -l -w $MW
smoke_moves2014_reports_28oct14.py -d 7 -r RPD -l -w $MW

setenv SECTOR onroad_catx_adj

smoke_moves2014_reports_28oct14.py -d 7 -r RPH -l -w $MW
smoke_moves2014_reports_28oct14.py -d 7 -r RPP -l -w $MW
smoke_moves2014_reports_28oct14.py -d 7 -r RPV -l -w $MW
smoke_moves2014_reports_28oct14.py -d 7 -r RPD -l -w $MW
