package gov.epa.surrogate.normalize;

import gov.epa.surrogate.qa.DoubleFormatter;

public class NormalizeSurrogateRow {

	private int surrogateID;

	private int countyID;

	private double ratio;

	private String comment;

	private int gridX;

	private int gridY;

	private String delimiter;

	private DoubleFormatter formatter;

	public NormalizeSurrogateRow(String[] tokens, int minimumTokens, String delimiter) {
		surrogateID = new Integer(tokens[0]).intValue();
		countyID = new Integer(tokens[1]).intValue();
		gridX = new Integer(tokens[2]).intValue();
		gridY = new Integer(tokens[3]).intValue();
		ratio = new Double(tokens[minimumTokens - 1]).doubleValue();
		if (tokens.length == minimumTokens + 1) {
			comment = tokens[minimumTokens];
		}
		this.delimiter = delimiter;
		this.formatter = new DoubleFormatter();
	}

	public String getComment() {
		return comment;
	}

	public int getCountyID() {
		return countyID;
	}

	public double getRatio() {
		return ratio;
	}

	public int getSurrogateID() {
		return surrogateID;
	}

	public String getLine() {
		StringBuffer sb = new StringBuffer();
		// TODO: formatting
		sb.append(surrogateID + delimiter);
		sb.append(countyID + delimiter);
		sb.append(gridX + delimiter);
		sb.append(gridY + delimiter);
		sb.append(format(ratio) + delimiter);
		sb.append("!" + delimiter + comment);
		return sb.toString();
	}

	protected String format(double value) {
		return formatter.format(value);
	}

	public void setRatio(double ratio) {
		this.ratio = ratio;
	}

}
