#!/bin/csh -f
#SBATCH --export=NONE

limit stacksize unlimited

setenv SECTOR "onroad_ca_adj_cb6orig"

if ($?SLURM_SUBMIT_DIR) then
  cd $SLURM_SUBMIT_DIR
endif

## Definitions for case name, directory structures, etc, that are used
#  by every sector in the case
#  Anything defined in directory_definitions can be overridden here 
#  if desired
source ../directory_definitions.csh

## Months for emissions processing, and spinup duration
#  In the EPA emissions modeling platforms, the only sectors that use
#    SPINUP_DURATION are biogenics and the final sector merge (Mrggrid).
#  Elsewhere, SPINUP_DURATION = 0, and when Mrggrid runs for spinup days,
#    base year emissions are used for the spinup year for all sectors except
#    biogenics.
#  Effective Jan 2019, SPINUP_DURATION now should work for all months.
#  SPINUP_MONTH_END (new for Jan 2019) specifies whether the last $SPINUP_DURATION 
#    days of quarter 2/3/4 should be run at the end of a quarter (Y), or at the start 
#    of the next quarter (N). For example, if runningwith SPINUP_DURATION = 10:
#    When N (old behavior), Q1 will include 10 day spinup and end on 3/21; Q2 will
#    cover 3/22 through 6/20. When Y, Q1 will include 10 day spinup and end on 3/31
#    (including all of March), remaining quarters will function as if spinup = 0.
setenv RUN_MONTHS "1 2 3 4 5 6 7 8 9 10 11 12"
setenv SPINUP_DURATION "0"
setenv SPINUP_MONTH_END "Y"

## Emissions modeling year
#  (i.e. meteorological year, not necessarily the inventory year"
setenv BASE_YEAR "2016"
setenv EPI_STDATE_TIME "${BASE_YEAR}-01-01 00:00:00.0"
setenv EPI_ENDATE_TIME "${BASE_YEAR}-12-31 23:59:00.0"

## Inventory case name, if inventories are coming from a different case (they usually aren't)
#  CASEINPUTS is defined in directory_definitions and optionally overridden here
#setenv INVENTORY_CASE "2011ek_cb6v2_v6_11g"
#setenv CASEINPUTS "$INSTALL_DIR/$INVENTORY_CASE/inputs"
setenv CASEINPUTS_EF "$INSTALL_DIR/2028ff_16j/inputs"

## Inputs for all sectors
setenv AGREF "${GE_DAT}/gridding/agref_us_2014platform_03dec2018_nf_v11.txt"
setenv ARTOPNT "${GE_DAT}/gridding/artopnt_2002detroit_30mar2012_v1.txt"
setenv ATPRO_HOURLY_NCF "${GE_DAT}/temporal/Gentpro_TPRO_HOUR_HOURLY_BASH_NH3.agNH3_bash_2016j_12US2_smk37.ncf"
setenv ATPRO_HOURLY "${GE_DAT}/temporal/amptpro_general_2011platform_tpro_hourly_6nov2014_24jul2017_v5"
setenv ATPRO_MONTHLY "${GE_DAT}/temporal/amptpro_general_2011platform_tpro_monthly_6nov2014_30nov2018_nf_v9"
setenv ATPRO_WEEKLY "${GE_DAT}/temporal/amptpro_general_2011platform_tpro_weekly_6nov2014_09sep2016_v2"
setenv ATREF "${GE_DAT}/temporal/amptref_general_2014platform_tref_07dec2018_nf_v15"
setenv COSTCY "${GE_DAT}/costcy_for_2007platform_28nov2018_nf_v23.txt"
setenv EFTABLES "$CASEINPUTS_EF/onroad/eftables/rateperdistance_smoke_aq_cb6_saprc_nei2028v2_20180810_10003_1.csv"
setenv GRIDDESC "${GE_DAT}/gridding/griddesc_lambertonly_29nov2018_nf_v7.txt"
setenv GSCNV "${GE_DAT}/speciation/gscnv_Create_Speciate4_5_CB6CMAQ_04jan2018_nf_v1.txt"
#setenv GSPROTMP_A  "${GE_DAT}/speciation/gspro_cmaq_cb6_2016ff_16j_29nov2018.txt"
#setenv GSREFTMP_A "${GE_DAT}/speciation/gsref_cmaq_cb6_2016ff_16j_10dec2018.txt"
setenv HOLIDAYS "${GE_DAT}/temporal/holidays_13feb2017_v1.txt"
#setenv INVTABLE "${GE_DAT}/invtable_2014platform_integrate_27nov2018_nf_v3.txt"
setenv MRGDATE_FILES "$INSTALL_DIR/smoke4.6/scripts/smk_dates/2016/smk_merge_dates_201601.txt"
setenv MTPRO_HOURLY "${GE_DAT}/temporal/mtpro_hourly_MOVES_2014v2_03nov2017_v0"
setenv MTPRO_MONTHLY "${GE_DAT}/temporal/mtpro_monthly_MOVES_03aug2016_v1"
setenv MTPRO_WEEKLY "${GE_DAT}/temporal/mtpro_weekly_MOVES_2014v2_03nov2017_v0"
setenv MTREF "${GE_DAT}/temporal/mtref_onroad_MOVES_2014v2_19sep2018_nf_v2"
setenv NAICSDESC "${GE_DAT}/smkreport/naicsdesc_02jan2008_v0.txt"
setenv ORISDESC "${GE_DAT}/smkreport/orisdesc_04dec2006_v0.txt"
setenv PELVCONFIG "${GE_DAT}/point/pelvconfig_inline_20m_13nov2012_v0.txt"
setenv PSTK "${GE_DAT}/point/pstk_13nov2018_v1.txt"
setenv PTPRO_HOURLY "${GE_DAT}/temporal/amptpro_general_2011platform_tpro_hourly_6nov2014_24jul2017_v5"
setenv PTPRO_MONTHLY "${GE_DAT}/temporal/amptpro_general_2011platform_tpro_monthly_6nov2014_30nov2018_nf_v9"
setenv PTPRO_WEEKLY "${GE_DAT}/temporal/amptpro_general_2011platform_tpro_weekly_6nov2014_09sep2016_v2"
setenv PTREF "${GE_DAT}/temporal/amptref_general_2014platform_tref_07dec2018_nf_v15"
#setenv REPCONFIG_GRID "${GE_DAT}/smkreport/repconfig_area_invgrid_2011platform_11aug2014_v0.txt"
setenv REPCONFIG_INV2 "${GE_DAT}/smkreport/repconfig_area_inv2_2011platform_11aug2014_v0.txt"
#setenv REPCONFIG_INV "${GE_DAT}/smkreport/repconfig_area_inv_2011platform_11aug2014_v0.txt"
setenv SCCDESC "${GE_DAT}/smkreport/sccdesc_2014platform_07dec2018_nf_v2.txt"
setenv SECTORLIST "$CASESCRIPTS/sectorlist_2028fg"
setenv SRGDESC "${GE_DAT}/gridding/srgdesc_CONUS12_2014_v1_3_29nov2016_13oct2017_v1.txt"
setenv SRGPRO "${GE_DAT}/gridding/surrogates/CONUS12_2014_03dec2018/USA_100_NOFILL.txt"

# Inputs specific to this sector
setenv SPECIES_DEF "$GE_DAT/speciation/combine_species_def_onroad_CB6CMAQ_08jun2018_v0"
setenv GSREF "$GE_DAT/speciation/gsref_MOVES2014_dummy_nei_2014v1_platform_17jan2017_v0.txt"
setenv GSPRO "$GE_DAT/speciation/gspro_MOVES2014_CB6_27jun2017_v2.txt"
setenv CFPRO "$GE_DAT/onroad/cfpro_2028ff_onroad_ca_adj_05oct2018_v0"
setenv SPDPRO "$GE_DAT/onroad/SPDPRO_NEI_v2_2014_from_ERG_20170822_08sep2017_v0"
setenv REPCONFIG_GRID "$GE_DAT/smkreport/repconfig_onroad_invgrid_2011platform_18aug2014_v1.txt"
#setenv SCCXREF "$GE_DAT/onroad/MOVES2014_SCCXREF_RPD_02feb2018_v6.csv"
#setenv MEPROC "$GE_DAT/onroad/meproc_MOVES2014_RPD_AQ_27jun2017_v8"
#setenv MRCLIST "$GE_DAT/onroad/mrclist_RPD_2028v2_AQ_CB6_10aug2018_02oct2018_v0"
setenv METMOVES "$GE_DAT/onroad/SMOKE_DAILY_2016fc_v2_16j_smk46_12US1_2016001-2017001.ncf"
setenv MCXREF "$GE_DAT/onroad/MCXREF_2014v2_10jul2017_v0"
setenv MFMREF "$GE_DAT/onroad/MFMREF_2014v2_10jul2017_v0"
setenv REPCONFIG_INV "$GE_DAT/smkreport/repconfig_onroad_inv_2011platform_11may2011_v0.txt"
#setenv EMISINV_A "$CASEINPUTS/onroad_ca_adj/VMT_2028ff_beta_projection_04oct2018_nf_v3.csv"
setenv MGREF "$GE_DAT/gridding/mgref_onroad_us_2014platform_18sep2018_v5.txt"
setenv INVTABLE "$GE_DAT/invtable_MOVES2014_27jun2017_v4.txt"

# Inputs specific to this rate
setenv SCCXREF "$GE_DAT/onroad/MOVES2014_SCCXREF_RPH_21jul2014_v0.csv"
setenv EMISINV_A "$CASEINPUTS/onroad_ca_adj/HOTELLING_2028ff_beta_projection_04oct2018_nf_v3.csv"
setenv MEPROC "$GE_DAT/onroad/meproc_MOVES2014_RPH_AQ_27jun2017_v9"
setenv MRCLIST "$GE_DAT/onroad/mrclist_RPH_2028v2_AQ_CB6_10aug2018_02oct2018_v0"

# Parameters for all sectors
#setenv FILL_ANNUAL "N"
setenv FULLSCC_ONLY "Y"
setenv INLINE_MODE "both"
setenv IOAPI_ISPH "20"
#setenv L_TYPE "mwdss"
#setenv M_TYPE "mwdss"
setenv MRG_MARKETPEN_YN "N"
#setenv MRG_REPCNY_YN "Y"
#setenv MRG_REPSTA_YN "N"
setenv MTMP_OUTPUT_YN "N"
setenv NO_SPC_ZERO_EMIS "Y"
setenv OUTPUT_FORMAT "$EMF_AQM"
setenv OUTZONE "0"
setenv PLATFORM "v7.2"
#setenv POLLUTANT_CONVERSION "Y"
setenv RAW_DUP_CHECK "N"
setenv RENORM_TPROF "Y"
setenv REPORT_DEFAULTS "Y"
setenv RUN_HOLIDAYS "Y"
setenv RUN_PYTHON_ANNUAL "Y"
setenv SMK_AVEDAY_YN "N"
setenv SMK_DEFAULT_SRGID "100"
#setenv SMKINVEN_FORMULA "PMC=PM10-PM2_5"
setenv SMK_MAXERROR "10000"
#setenv SMK_MAXWARNING "10"
setenv SMKMERGE_CUSTOM_OUTPUT "Y"
setenv SMK_PING_METHOD "0"
setenv SMK_SPECELEV_YN "Y"
setenv SPC "$EMF_SPC"
setenv SPINUP_MONTH_END "Y"
setenv WEST_HSPHERE "Y"

# Sector-specific parameters
setenv SMKINVEN_FORMULA ""
setenv SMK_MAXWARNING "200"
setenv L_TYPE "all"
setenv M_TYPE "all"
setenv NONHAP_TYPE "TOG"
setenv SMK_PROCESS_HAPS "ALL"
setenv USE_MCODE_SCC_YN "N"
setenv USE_HOURLY_SPEEDS "Y"
setenv TEMP_BUFFER_BIN "10"
setenv USE_MCODES_SCC_YN "N"
setenv KEEP_RFL_SEPARATE ""
setenv USE_LINUX2 "Y"
setenv USE_CONTROL_FACTORS "Y"
setenv USE_REF_SCC_YN "Y"
setenv EXCLUDE_REF_SCC_YN "N"
setenv USE_EXP_CONTROL_FAC_YN "Y"
setenv TVARNAME "TEMP2"
setenv MEMORY_OPTIMIZE_YN "N"
setenv MRG_REPSTA_YN "N"
setenv POLLUTANT_CONVERSION "N"
setenv MRG_REPCNY_YN "Y"
setenv MRG_REPSCC_YN "Y"
setenv MRG_REPSRC_YN "Y"
setenv SMK_EF_MODEL "MOVES"
setenv MOVESMRG_CUSTOM_OUTPUT "Y"

# Rate-specific parameters
setenv MOVES_TYPE "RPH"
setenv FILL_ANNUAL "Y"

setenv DAYS_PER_RUN "1"

$RUNSCRIPTS/emf/smk_or_monthly_MOVES_emf.csh $REGION_ABBREV $REGION_IOAPI_GRIDNAME -m "$RUN_MONTHS" $SPINUP_DURATION all
