#!/bin/csh
#PBS -j oe
#PBS -r n
#PBS -q romo
#PBS -W group_list=romo
#PBS -W umask=022
#PBS -A plateval

# This sample script creates a bioseason file.
# Several intermediate files are produced in this script, but the "full" bioseason is the one with "full" in the name.

#### CHANGE THE FOLLOWING SCRIPT SETTINGS: ####
# Grid name (should match the GRIDDESC)
# MET_ROOT (METCRO2D files should be in this directory)
# YEAR (your modeling year)
# LABEL (included in filenames)
# LEAP (if your modeling year is a leap year)
# SPINUP_DURATION (if you need something other than 10 day spinup from the previous December)
# RUN_LENGTH (if not running a full year)
# temp2: This is a hardcoded value. Run $IOAPI_LOCATION/m3xtract on one of your METCRO2D files. Which variable number is TEMP2? 
#   That should be the value of "temp2" in this script. In EPA's METCRO2D files, TEMP2 is variable #12.
# SMOKE_LOCATION and IOAPI_LOCATION, if necessary

setenv GRID 36US3 # should match GRIDDESC
setenv MET_ROOT /sol/work/EMIS/met/MCIP_v4.3/WRFv3.8_36US3_2016_35aL # location of METCRO2D files
setenv OUT_PATH $INSTALL_DIR/bioseason
setenv YEAR 2011
setenv LABEL 2011g # for filenames
setenv LEAP N  # Is the year a leap year
setenv SPINUP_DURATION 10 #10 # assumes December of previous year
setenv RUN_LENGTH 365 # not including spinup
set temp2 = 12 # variable number of TEMP2 in METCRO2Ds
setenv SMOKE_LOCATION $INSTALL_DIR/smoke3.7/Linux2_x86_64ifort
setenv IOAPI_LOCATION $INSTALL_DIR/ioapi/Linux2_x86_64ifort

set skip_extract = N

@ spinyear = $YEAR - 1

############

# Metscan requires a single METCRO2D file that includes all timesteps, as opposed to one file per day.
# This part of the script runs $IOAPI_LOCATION/m3xtract repeatedly in order to create a year-long METCRO2D.

setenv PROMPTFLAG Y
setenv OUTFILE $OUT_PATH/METCRO2D_${YEAR}_$GRID

if (-e $OUT_PATH/logs) then
	mkdir -p $OUT_PATH/logs 
endif

set monlist = (1 2 3 4 5 6 7 8 9 10 11 12)

if ($LEAP == "Y") then
	set dimon = (31 29 31 30 31 30 31 31 30 31 30 31)
else
	set dimon = (31 28 31 30 31 30 31 31 30 31 30 31)
endif

if ($skip_extract != Y) then

	foreach mon ($monlist) 

		if ($mon < 10) then
			set MM = 0${mon}
		else
			set MM = ${mon}
		endif

		set day = 1
		while ($day <= $dimon[$mon])

			if ($day < 10) then
				set DD = 0${day}
			else
				set DD = ${day}
			endif

			set kday = ${MM}${DD}
		
			setenv LOGFILE $OUT_PATH/logs/extract_${GRID}_${YEAR}${kday}.log
			if ( -e $LOGFILE ) then
				rm $LOGFILE
			endif
	
			set YY = `echo $YEAR | cut -c3-4`
			setenv INFILE $MET_ROOT/METCRO2D_${YY}${kday}

$IOAPI_LOCATION/m3xtract << eof

1
$temp2

0




eof

			@ day += 1
		end # day
	end # mon
############

# Metscan has to run separately for spinup versus the base year (can't cross years in a single Metscan run).
# So, spinup days need their own METCRO2D that covers the entire spinup period.

	setenv OUTFILE $OUT_PATH/METCRO2D_${spinyear}_$GRID

	@ day = 32 - $SPINUP_DURATION
	while ($day <= 31)

		set DD = ${day}
		set kday = 12${DD}
		
		setenv LOGFILE $OUT_PATH/logs/extract_${GRID}_${spinyear}${kday}.log
		if ( -e $LOGFILE ) then
			rm $LOGFILE
		endif

		set YY = `echo $spinyear | cut -c3-4`
		setenv INFILE $MET_ROOT/METCRO2D_${YY}${kday}

$IOAPI_LOCATION/m3xtract << eof

1
$temp2

0




eof

		@ day += 1
	end # day

endif #if not skipping MCIP extract

# Since Metscan can't cross years, must remove the last hour (January 1 00:00) from both the full year and spinup METCRO2D files.

set annfile = METCRO2D_${YEAR}_${GRID}
set spinfile = METCRO2D_${spinyear}_${GRID}

@ hours = $RUN_LENGTH * 240000
@ spinhours = $SPINUP_DURATION * 240000

#----------
if (! -e ${OUT_PATH}/bak) then
	mkdir ${OUT_PATH}/bak
endif

unsetenv LOGFILE
setenv INFILE ${OUT_PATH}/tmp.ncf
setenv OUTFILE ${OUT_PATH}/$annfile
cp -f $OUTFILE ${OUT_PATH}/bak/
mv -f $OUTFILE $INFILE
	 
$IOAPI_LOCATION/m3xtract << EOF

0



$hours

EOF

setenv OUTFILE ${OUT_PATH}/$spinfile
cp -f $OUTFILE ${OUT_PATH}/bak/
mv -f $OUTFILE $INFILE
	 
$IOAPI_LOCATION/m3xtract << EOF

0



$spinhours

EOF

rm -f ${OUT_PATH}/tmp.ncf

##############

# Run Metscan to create the full year bioseasons file

setenv EDSS_ROOT $OUT_PATH
setenv N_S_HEMI NORTH
setenv binpath $SMOKE_LOCATION
setenv BIOSEASON $OUT_PATH/bioseason.cmaq.${LABEL}_${GRID}.ncf
setenv PROMPTFLAG N
setenv TMPR_VAR TEMP2
setenv MET_CRO_3D $OUT_PATH/METCRO2D_${YEAR}_${GRID}
setenv LOGFILE $OUT_PATH/logs/bioseason.cmaq.${LABEL}.${GRID}.log
if ( -e $LOGFILE ) then
	rm $LOGFILE
endif

$binpath/metscan
##############

# Run Metscan to create the spinup bioseasons file

setenv EDSS_ROOT $OUT_PATH
setenv N_S_HEMI NORTH
setenv binpath $SMOKE_LOCATION
setenv BIOSEASON $OUT_PATH/bioseason.cmaq.${spinyear}_${GRID}.ncf
setenv PROMPTFLAG N
setenv TMPR_VAR TEMP2
setenv MET_CRO_3D $OUT_PATH/METCRO2D_${spinyear}_${GRID}
setenv LOGFILE $OUT_PATH/logs/bioseason.cmaq.${spinyear}.${GRID}.log
if ( -e $LOGFILE ) then
	rm $LOGFILE
endif

$binpath/metscan

##########

# Tmpbeis requires that the bioseason include January 1 of the following year. Use m3xtract to copy December 31 of the base year to January 1 of the following year.

set annfile = bioseason.cmaq.${LABEL}_${GRID}.ncf
set spinfile = bioseason.cmaq.${spinyear}_${GRID}.ncf
unsetenv LOGFILE

setenv PROMPTFLAG Y

#------------
cp -f $OUT_PATH/$annfile ${OUT_PATH}/bak
setenv INFILE ${OUT_PATH}/bak/$annfile
setenv OUTFILE ${OUT_PATH}/bak/tlasthour
if (-e $OUTFILE) rm -f $OUTFILE

if ($LEAP == "Y") then
	set jday = ${YEAR}366
else
	set jday = ${YEAR}365
endif

@ nextyear = $YEAR + 1

m3tshift << EOF

$jday
0
${nextyear}001
0
240000
240000

EOF

setenv INFILE ${OUT_PATH}/bak/tlasthour
setenv OUTFILE ${OUT_PATH}/bak/$annfile

$IOAPI_LOCATION/m3xtract << EOF

0






EOF

#######

# Combine spinup bioseason with full year bioseason

cp -f $OUT_PATH/$spinfile ${OUT_PATH}/bak

setenv INFILE ${OUT_PATH}/bak/$annfile
setenv OUTFILE ${OUT_PATH}/bak/$spinfile

$IOAPI_LOCATION/m3xtract << EOF

0






EOF

mv -f ${OUT_PATH}/bak/$spinfile ${OUT_PATH}/${annfile}_full
